// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const GroupsMenuIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 12 10.087"
    {...props}
  >
    <defs>
      <clipPath id="clip-path-groups-menu-icon">
        <rect
          id="Rectángulo_992"
          data-name="Rectángulo 992"
          width="12"
          height="10.087"
        />
      </clipPath>
    </defs>
    <g
      id="Grupo_2367"
      data-name="Grupo 2367"
      clipPath="url(#clip-path-groups-menu-icon)"
    >
      <path
        id="Trazado_7090"
        data-name="Trazado 7090"
        d="M204.925,3.5a2.963,2.963,0,0,1-.177,1.011c.042,0,.084,0,.127,0a2.274,2.274,0,0,0,2.284-2.258,2.288,2.288,0,0,0-4-1.486A3.005,3.005,0,0,1,204.925,3.5"
        transform="translate(-195.887 0)"
      />
      <path
        id="Trazado_7091"
        data-name="Trazado 7091"
        d="M207.3,137.346a3.458,3.458,0,0,0-1.31-1.03,3.642,3.642,0,0,0-.725-.242,3.479,3.479,0,0,0-.748-.082c-.05,0-.1,0-.151,0h-.017l-.1.007a3.039,3.039,0,0,1-1.442,1.357,4.587,4.587,0,0,1,.583.219,4.389,4.389,0,0,1,1.656,1.3,1.775,1.775,0,0,1,.177.28h1.242a1.169,1.169,0,0,0,.3-.039,1.066,1.066,0,0,0,.27-.113,1.02,1.02,0,0,0,.225-.181,1.036,1.036,0,0,0,.168-.242,1.179,1.179,0,0,0-.128-1.239"
        transform="translate(-195.543 -131.125)"
      />
      <path
        id="Trazado_7092"
        data-name="Trazado 7092"
        d="M22.838,4.516c.043,0,.086,0,.129,0A2.962,2.962,0,0,1,22.789,3.5,3.005,3.005,0,0,1,24.556.773a2.288,2.288,0,0,0-4,1.485,2.274,2.274,0,0,0,2.284,2.258"
        transform="translate(-19.819 -0.001)"
      />
      <path
        id="Trazado_7093"
        data-name="Trazado 7093"
        d="M3.757,137.784a4.577,4.577,0,0,1,.986-.428,3.039,3.039,0,0,1-1.431-1.35c-.1-.009-.206-.014-.31-.014-.05,0-.1,0-.151,0H2.834a3.293,3.293,0,0,0-.367.039,3.506,3.506,0,0,0-2.194,1.286l-.057.077h0a1.154,1.154,0,0,0-.089,1.194,1.058,1.058,0,0,0,.171.239,1.042,1.042,0,0,0,.226.179,1.079,1.079,0,0,0,.269.112,1.169,1.169,0,0,0,.3.039H2.331a1.764,1.764,0,0,1,.126-.2v0l0,0,.071-.1a4.235,4.235,0,0,1,1.225-1.071"
        transform="translate(-0.001 -131.126)"
      />
      <path
        id="Trazado_7094"
        data-name="Trazado 7094"
        d="M95.021,28.466a2.6,2.6,0,1,0,2.6-2.574,2.592,2.592,0,0,0-2.6,2.574"
        transform="translate(-91.621 -24.965)"
      />
      <path
        id="Trazado_7095"
        data-name="Trazado 7095"
        d="M76.691,181.3a4.152,4.152,0,0,0-.827-.276,3.966,3.966,0,0,0-.853-.094c-.057,0-.115,0-.172,0h-.02a3.753,3.753,0,0,0-.419.045,4,4,0,0,0-2.5,1.466l-.065.088h0a1.315,1.315,0,0,0-.1,1.362,1.208,1.208,0,0,0,.195.272,1.189,1.189,0,0,0,.257.2,1.233,1.233,0,0,0,.307.127,1.333,1.333,0,0,0,.342.044h4.4a1.331,1.331,0,0,0,.345-.045,1.216,1.216,0,0,0,.307-.129,1.164,1.164,0,0,0,.256-.207,1.183,1.183,0,0,0,.191-.276,1.344,1.344,0,0,0-.146-1.412,3.943,3.943,0,0,0-1.494-1.174"
        transform="translate(-69.028 -174.452)"
      />
    </g>
  </svg>
);

export default GroupsMenuIcon;
