// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const SpeedtestIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g data-name="SpeedTestIcon">
        <path data-name="Rect\xE1ngulo 850" fill="none" d="M0 0h256v256H0z" />
        <path
          data-name="Trazado 426"
          d="m63.413 63.057-.1.084a5.326 5.326 0 0 0 3.505 9.344l-.011.063a5.319 5.319 0 0 0 3.516-1.371l.1-.084q.167-.135.322-.281a5.337 5.337 0 1 0-7.333-7.756Z"
        />
        <path
          data-name="Trazado 427"
          d="M48.827 88.433a4.336 4.336 0 0 0-5.884 1.729v.095a4.336 4.336 0 0 0 3.817 6.344l-.011.01a4.361 4.361 0 0 0 2.078-8.178Z"
        />
        <path
          data-name="Trazado 428"
          d="M127.29 52.816h.293a7.816 7.816 0 1 0-.046-15.631h-.247a7.816 7.816 0 0 0 0 15.631Z"
        />
        <path
          data-name="Trazado 429"
          d="M37.263 119.721h-.028a2.958 2.958 0 0 0-3.324 2.541v.08a2.973 2.973 0 0 0 2.559 3.336 3.173 3.173 0 0 0 .379 0l-.021.007a2.972 2.972 0 0 0 2.959-2.558v-.056a2.966 2.966 0 0 0-2.524-3.35Z"
        />
        <path
          data-name="Trazado 430"
          d="m91.954 44.052-.209.078a7.07 7.07 0 0 0 2.5 13.688l-.022.065a7.009 7.009 0 0 0 2.537-.529l.165-.066.1-.039a7.071 7.071 0 1 0-5.076-13.2Z"
        />
        <path
          data-name="Trazado 431"
          d="M192.48 73.763a9.817 9.817 0 0 0-.929-13.852l-.268-.235a9.817 9.817 0 0 0-12.881 14.8l.246.212a9.806 9.806 0 0 0 6.452 2.426 9.815 9.815 0 0 0 7.38-3.351Z"
        />
        <path data-name="Trazado 432" d="M205.131 108.033Z" />
        <path
          data-name="Trazado 433"
          d="m227.69 121.128-.067-.495a12.786 12.786 0 0 0-12.612-11.007 12.761 12.761 0 0 0-12.638 14.485v.428a12.786 12.786 0 0 0 12.612 11.047 13.068 13.068 0 0 0 1.778-.12 12.76 12.76 0 0 0 10.927-14.338Z"
        />
        <path
          data-name="Trazado 434"
          d="M210.416 102.215a11.283 11.283 0 0 0 4.537-15.3l-.2-.361a16.398 16.398 0 0 0-.27-.5 11.283 11.283 0 1 0-19.545 11.281l.187.336a11.278 11.278 0 0 0 15.289 4.538Z"
        />
        <path
          data-name="Trazado 435"
          d="m160.575 42.633-.289-.111a8.657 8.657 0 1 0-6.052 16.222l.255.1a8.643 8.643 0 0 0 3.048.556l-.01.066a8.7 8.7 0 0 0 3.048-16.833Z"
        />
        <path
          data-name="Trazado 436"
          d="m148.433 112.148-13.839 11.867a.333.333 0 0 1-.331 0 17.171 17.171 0 1 0 10.435 12.167.333.333 0 0 1 0-.316l13.9-11.866a7.807 7.807 0 0 0-10.165-11.851Zm-12.039 27.588a8.26 8.26 0 1 1-8.26-8.26 8.26 8.26 0 0 1 8.26 8.259Z"
        />
        <path
          data-name="Trazado 437"
          d="M138.134 194.756h-20.3a3.765 3.765 0 0 0 0 7.53h20.33a3.764 3.764 0 0 0 3.764-3.765v-.03a3.765 3.765 0 0 0-3.794-3.735Z"
        />
        <path
          data-name="Trazado 438"
          d="M127.999 0a128 128 0 1 0 128 128 128.15 128.15 0 0 0-128-128Zm0 233.412A105.412 105.412 0 1 1 233.414 128a105.412 105.412 0 0 1-105.415 105.412Z"
        />
      </g>
    </g>
  </svg>
);

export default SpeedtestIcon;
