// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const TenantsOutlineIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g data-name="Tenants Outline" clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 452"
        d="M135.881 213.702a42.222 42.222 0 0 1 7.779-24.429l-29.932-38.917a76.63 76.63 0 0 1-20.656 5.106l-.867 16.144a24.837 24.837 0 0 1 7.207 17.521 24.937 24.937 0 0 1-24.893 24.918 24.94 24.94 0 0 1-24.891-24.918 24.779 24.779 0 0 1 18.055-23.967l.6-11.047A78.47 78.47 0 0 1 7.002 77.955 78 78 0 0 1 84.861-.005a78 78 0 0 1 77.863 77.96 77.537 77.537 0 0 1-1.119 13.111l28.8 4.184a31.653 31.653 0 0 1 25.73-12.966 32.13 32.13 0 0 1 32.082 32.115 32.128 32.128 0 0 1-32.082 32.108 32.267 32.267 0 0 1-31.66-27.009l-31.1-4.519a78.56 78.56 0 0 1-18.219 22.474l28.188 36.653a42.235 42.235 0 0 1 14.787-2.7 42.307 42.307 0 0 1 42.238 42.293 42.313 42.313 0 0 1-42.238 42.293 42.322 42.322 0 0 1-42.25-42.29Zm28.877-23.668-3.377 1.911-2.689 2.762a27.045 27.045 0 0 0-7.75 19 27.231 27.231 0 0 0 27.182 27.218 27.232 27.232 0 0 0 27.184-27.218 27.232 27.232 0 0 0-27.184-27.218 27 27 0 0 0-13.366 3.548Zm-100.051-.906a9.84 9.84 0 0 0 9.813 9.842 9.847 9.847 0 0 0 9.824-9.842 9.889 9.889 0 0 0-4.2-8.058l-2.445-1.711-2.979-.054a9.827 9.827 0 0 0-10.016 9.826ZM22.078 77.956a62.885 62.885 0 0 0 55.014 62.386l4.365.535 4.355-.063a62.125 62.125 0 0 0 26.91-6.511l4-1.992 3.578-2.455a63.038 63.038 0 0 0 21.867-26.212l1.793-3.993 1.268-4.381a63.234 63.234 0 0 0 2.424-17.313 62.907 62.907 0 0 0-62.793-62.883A62.9 62.9 0 0 0 22.078 77.96Zm178.871 28.831-1.549 3.061-.219 3.54c-.051 10.4 7.58 18.045 16.949 18.045a17.044 17.044 0 0 0 17.018-17.032 17.046 17.046 0 0 0-17.018-17.04 16.888 16.888 0 0 0-15.181 9.429Z"
      />
      <path data-name="Rect\xE1ngulo 865" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default TenantsOutlineIcon;
