// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const VersionIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path d="m144.506 255.256-14.883-15.1a2.5 2.5 0 0 1-.721-1.758v-88.02c-4.229 2.145-8.4 4.255-12.479 6.313-5.391 2.731-10.971 5.553-16.449 8.336l-20.359 10.364-11.967 6.092a2.514 2.514 0 0 1-2.635-.217 2.508 2.508 0 0 1-.973-2.458 120.437 120.437 0 0 1 4.3-16.642 154.087 154.087 0 0 1 7.375-18.167 160.659 160.659 0 0 1 10.453-18.526 148.6 148.6 0 0 1 13.559-17.688 161.263 161.263 0 0 1 21-19.616 157.34 157.34 0 0 1 24.42-15.569 2.512 2.512 0 0 1 2.455.086 2.512 2.512 0 0 1 1.205 2.145v43.791a27.491 27.491 0 0 0 8.039-6.747 27.647 27.647 0 0 0 5.527-11.558 27.41 27.41 0 0 0-.295-12.7 27.57 27.57 0 0 0-6.549-11.788c-5.266-5.679-10.748-11.349-16.051-16.837-4.262-4.407-8.676-8.97-12.955-13.52-.342-.365-.689-.729-1.039-1.1-2.916-3.07-5.934-6.248-7.914-10.09a22.79 22.79 0 0 1-1.416-17.614 23.808 23.808 0 0 1 4.559-8.124 24.373 24.373 0 0 1 7.617-5.952A23.519 23.519 0 0 1 138.992 0a25.109 25.109 0 0 1 12.957 3.756 30.3 30.3 0 0 1 9.525 9.222l1.318 1.945c.018.026.035.056.053.082l1.033 1.663c2.971 4.767 6.035 9.7 9.018 14.584a9375.397 9375.397 0 0 1 19.088 31.434 7.057 7.057 0 0 1 .754 1.962c.049.183.1.352.141.486a2.514 2.514 0 0 1-1.117 2.948l-.582.343a2.514 2.514 0 0 1-2.895-.251 27.192 27.192 0 0 0-.447-.369 13.275 13.275 0 0 1-1.291-1.137l-2.756-2.875c-8.3-8.649-16.881-17.593-25.3-26.415a2847.157 2847.157 0 0 1-5.229-5.5c-4.15-4.372-9.322-9.816-10.338-10.841a5.772 5.772 0 0 0-4-1.88 4.533 4.533 0 0 0-3.152 1.333 4.7 4.7 0 0 0-1.594 3.269 5.364 5.364 0 0 0 1.693 3.791 7287.52 7287.52 0 0 0 18.535 19.351c4.8 5.01 9.777 10.19 14.656 15.292a47.4 47.4 0 0 1 6.354 8.306 46.309 46.309 0 0 1 4.229 9.152 46.6 46.6 0 0 1 2.131 9.648 46.826 46.826 0 0 1 .061 9.786 46.84 46.84 0 0 1-1.953 9.539 46.211 46.211 0 0 1-3.947 9 46.028 46.028 0 0 1-5.895 8.114 46.986 46.986 0 0 1-7.812 6.874 79.956 79.956 0 0 1-9.746 5.548 192.77 192.77 0 0 0-3.555 1.833c-.039.021-.084.047-.121.065v113.437a2.517 2.517 0 0 1-1.561 2.323 2.529 2.529 0 0 1-.951.186 2.513 2.513 0 0 1-1.79-.748Zm-23.9-141.771a136 136 0 0 0-10.672 11.727 137.8 137.8 0 0 0-9.287 12.973q-2.262 3.589-4.359 7.394c.139-.074.277-.143.416-.217 4.941-2.527 9.605-4.915 14.33-7.342l1.783-.916c5.258-2.7 10.693-5.5 16-8.306.018-.014.039-.035.061-.053.061-7.372.053-15.174.039-22.768a139.007 139.007 0 0 0-8.312 7.508Z" />
      <path data-name="Rect\xE1ngulo 861" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default VersionIcon;
