// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const WatchIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g data-name="watch-icn" transform="translate(4333.082 464.859)">
        <g data-name="Grupo 1495">
          <path
            data-name="Trazado 345"
            d="M-4237.731-461.928h-70.438a21.991 21.991 0 0 0-21.981 21.98v72.661a5.084 5.084 0 0 0 5.083 5.084h7.4a5.09 5.09 0 0 0 5.1-5.084v-57.382a19.671 19.671 0 0 1 19.665-19.672h55.169a5.081 5.081 0 0 0 5.076-5.084v-7.416a5.081 5.081 0 0 0-5.074-5.087Z"
          />
          <path
            data-name="Trazado 345 - Contorno"
            d="M-4308.169-464.859h70.439a8.021 8.021 0 0 1 8.008 8.015v7.416a8.021 8.021 0 0 1-8.008 8.015h-55.17a16.756 16.756 0 0 0-16.733 16.74v57.386a8.032 8.032 0 0 1-8.03 8.015h-7.4a8.023 8.023 0 0 1-8.014-8.015v-72.661a24.94 24.94 0 0 1 24.908-24.911Zm70.439 17.583a2.151 2.151 0 0 0 2.145-2.152v-7.416a2.151 2.151 0 0 0-2.145-2.156h-70.439a19.071 19.071 0 0 0-19.05 19.049v72.661a2.154 2.154 0 0 0 2.151 2.153h7.4a2.163 2.163 0 0 0 2.168-2.153v-57.386a22.625 22.625 0 0 1 22.6-22.6Z"
          />
          <path
            data-name="Trazado 346"
            d="M-4101.983-461.928h-77.172a5.088 5.088 0 0 0-5.09 5.084v7.416a5.088 5.088 0 0 0 5.09 5.084h61.9a19.677 19.677 0 0 1 19.674 19.672v57.386a5.085 5.085 0 0 0 5.089 5.084h7.4a5.076 5.076 0 0 0 5.074-5.084v-72.661a21.977 21.977 0 0 0-21.965-21.981Z"
          />
          <path
            data-name="Trazado 346 - Contorno"
            d="M-4179.155-464.859h77.172a24.935 24.935 0 0 1 24.9 24.911v72.661a8.02 8.02 0 0 1-8.006 8.015h-7.4a8.028 8.028 0 0 1-8.021-8.015v-57.386a16.761 16.761 0 0 0-16.743-16.74h-61.9a8.027 8.027 0 0 1-8.021-8.015v-7.416a8.027 8.027 0 0 1 8.019-8.015Zm94.067 99.725a2.15 2.15 0 0 0 2.143-2.153v-72.661A19.066 19.066 0 0 0-4101.983-459h-77.172a2.158 2.158 0 0 0-2.158 2.153v7.416a2.158 2.158 0 0 0 2.158 2.152h61.9a22.63 22.63 0 0 1 22.605 22.6v57.386a2.158 2.158 0 0 0 2.158 2.153Z"
          />
          <path
            data-name="Trazado 347"
            d="M-4085.088-313.79h-7.4a5.085 5.085 0 0 0-5.089 5.084v59.661a19.685 19.685 0 0 1-19.674 19.68h-61.9a5.086 5.086 0 0 0-5.094 5.075v7.424a5.085 5.085 0 0 0 5.09 5.075h77.172a21.972 21.972 0 0 0 21.97-21.98v-74.935a5.075 5.075 0 0 0-5.075-5.084Z"
          />
          <path
            data-name="Trazado 347 - Contorno"
            d="M-4092.489-316.721h7.4a8.02 8.02 0 0 1 8.006 8.015v74.935a24.935 24.935 0 0 1-24.9 24.911h-77.172a8.023 8.023 0 0 1-8.021-8.006v-7.424a8.023 8.023 0 0 1 8.021-8.007h61.9a16.765 16.765 0 0 0 16.743-16.749v-59.661a8.027 8.027 0 0 1 8.023-8.014Zm-9.494 102a19.065 19.065 0 0 0 19.039-19.049v-74.935a2.15 2.15 0 0 0-2.143-2.153h-7.4a2.158 2.158 0 0 0-2.158 2.153v59.661a22.634 22.634 0 0 1-22.605 22.611h-61.9a2.153 2.153 0 0 0-2.158 2.144v7.424a2.153 2.153 0 0 0 2.158 2.143Z"
          />
          <path
            data-name="Trazado 348"
            d="M-4237.731-229.365h-55.169a19.679 19.679 0 0 1-19.665-19.68v-59.661a5.089 5.089 0 0 0-5.1-5.084h-7.4a5.083 5.083 0 0 0-5.083 5.084v74.935a21.985 21.985 0 0 0 21.979 21.981h70.439a5.079 5.079 0 0 0 5.076-5.075v-7.425a5.079 5.079 0 0 0-5.077-5.075Z"
          />
          <path
            data-name="Trazado 348 - Contorno"
            d="M-4237.73-208.859h-70.439a24.94 24.94 0 0 1-24.913-24.911v-74.935a8.023 8.023 0 0 1 8.014-8.015h7.4a8.032 8.032 0 0 1 8.03 8.015v59.661a16.76 16.76 0 0 0 16.733 16.749h55.169a8.016 8.016 0 0 1 8.008 8.007v7.424a8.016 8.016 0 0 1-8.002 8.005Zm-87.338-102a2.154 2.154 0 0 0-2.151 2.153v74.935a19.071 19.071 0 0 0 19.05 19.049h70.439a2.147 2.147 0 0 0 2.145-2.143v-7.424a2.147 2.147 0 0 0-2.145-2.144h-55.17a22.629 22.629 0 0 1-22.6-22.611v-59.661a2.163 2.163 0 0 0-2.168-2.153Z"
          />
        </g>
        <ellipse
          data-name="Elipse 56"
          cx={56.415}
          cy={56.414}
          rx={56.415}
          ry={56.414}
          transform="translate(-4260.489 -392.445)"
        />
        <path
          data-name="Elipse 56 - Contorno"
          d="M-4205.074-393.376a51.345 51.345 0 1 1-51.346 51.345 51.4 51.4 0 0 1 51.346-51.345Zm0 96.827a45.482 45.482 0 1 0-45.483-45.482 45.535 45.535 0 0 0 45.483 45.482Z"
        />
      </g>
      <path data-name="Rect\xE1ngulo 890" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default WatchIcon;
