// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

export interface NotificationEndpoint {
  service: string;
  account_id: string;
  properties: Map<string, string>;
}

export interface NotificationEndpointItem {
  service: string;
  account_id: string;
  status: string;
}

export interface TransformedEndpointItem {
  service_name: string;
  status: string;
  name: string;
  account_id: string;
}

export interface NotificationEndpointsList {
  notification_endpoints: NotificationEndpointItem[];
}
