// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

package databasepb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DatabaseAdmin_ListDatabases_FullMethodName                = "/google.spanner.admin.database.v1.DatabaseAdmin/ListDatabases"
	DatabaseAdmin_CreateDatabase_FullMethodName               = "/google.spanner.admin.database.v1.DatabaseAdmin/CreateDatabase"
	DatabaseAdmin_GetDatabase_FullMethodName                  = "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabase"
	DatabaseAdmin_UpdateDatabase_FullMethodName               = "/google.spanner.admin.database.v1.DatabaseAdmin/UpdateDatabase"
	DatabaseAdmin_UpdateDatabaseDdl_FullMethodName            = "/google.spanner.admin.database.v1.DatabaseAdmin/UpdateDatabaseDdl"
	DatabaseAdmin_DropDatabase_FullMethodName                 = "/google.spanner.admin.database.v1.DatabaseAdmin/DropDatabase"
	DatabaseAdmin_GetDatabaseDdl_FullMethodName               = "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabaseDdl"
	DatabaseAdmin_SetIamPolicy_FullMethodName                 = "/google.spanner.admin.database.v1.DatabaseAdmin/SetIamPolicy"
	DatabaseAdmin_GetIamPolicy_FullMethodName                 = "/google.spanner.admin.database.v1.DatabaseAdmin/GetIamPolicy"
	DatabaseAdmin_TestIamPermissions_FullMethodName           = "/google.spanner.admin.database.v1.DatabaseAdmin/TestIamPermissions"
	DatabaseAdmin_CreateBackup_FullMethodName                 = "/google.spanner.admin.database.v1.DatabaseAdmin/CreateBackup"
	DatabaseAdmin_CopyBackup_FullMethodName                   = "/google.spanner.admin.database.v1.DatabaseAdmin/CopyBackup"
	DatabaseAdmin_GetBackup_FullMethodName                    = "/google.spanner.admin.database.v1.DatabaseAdmin/GetBackup"
	DatabaseAdmin_UpdateBackup_FullMethodName                 = "/google.spanner.admin.database.v1.DatabaseAdmin/UpdateBackup"
	DatabaseAdmin_DeleteBackup_FullMethodName                 = "/google.spanner.admin.database.v1.DatabaseAdmin/DeleteBackup"
	DatabaseAdmin_ListBackups_FullMethodName                  = "/google.spanner.admin.database.v1.DatabaseAdmin/ListBackups"
	DatabaseAdmin_RestoreDatabase_FullMethodName              = "/google.spanner.admin.database.v1.DatabaseAdmin/RestoreDatabase"
	DatabaseAdmin_ListDatabaseOperations_FullMethodName       = "/google.spanner.admin.database.v1.DatabaseAdmin/ListDatabaseOperations"
	DatabaseAdmin_ListBackupOperations_FullMethodName         = "/google.spanner.admin.database.v1.DatabaseAdmin/ListBackupOperations"
	DatabaseAdmin_ListDatabaseRoles_FullMethodName            = "/google.spanner.admin.database.v1.DatabaseAdmin/ListDatabaseRoles"
	DatabaseAdmin_AddSplitPoints_FullMethodName               = "/google.spanner.admin.database.v1.DatabaseAdmin/AddSplitPoints"
	DatabaseAdmin_CreateBackupSchedule_FullMethodName         = "/google.spanner.admin.database.v1.DatabaseAdmin/CreateBackupSchedule"
	DatabaseAdmin_GetBackupSchedule_FullMethodName            = "/google.spanner.admin.database.v1.DatabaseAdmin/GetBackupSchedule"
	DatabaseAdmin_UpdateBackupSchedule_FullMethodName         = "/google.spanner.admin.database.v1.DatabaseAdmin/UpdateBackupSchedule"
	DatabaseAdmin_DeleteBackupSchedule_FullMethodName         = "/google.spanner.admin.database.v1.DatabaseAdmin/DeleteBackupSchedule"
	DatabaseAdmin_ListBackupSchedules_FullMethodName          = "/google.spanner.admin.database.v1.DatabaseAdmin/ListBackupSchedules"
	DatabaseAdmin_InternalUpdateGraphOperation_FullMethodName = "/google.spanner.admin.database.v1.DatabaseAdmin/InternalUpdateGraphOperation"
)

// DatabaseAdminClient is the client API for DatabaseAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DatabaseAdminClient interface {
	// Lists Cloud Spanner databases.
	ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error)
	// Creates a new Cloud Spanner database and starts to prepare it for serving.
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<database_name>/operations/<operation_id>` and
	// can be used to track preparation of the database. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Database][google.spanner.admin.database.v1.Database], if successful.
	CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the state of a Cloud Spanner database.
	GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error)
	// Updates a Cloud Spanner database. The returned
	// [long-running operation][google.longrunning.Operation] can be used to track
	// the progress of updating the database. If the named database does not
	// exist, returns `NOT_FOUND`.
	//
	// While the operation is pending:
	//
	//   - The database's
	//     [reconciling][google.spanner.admin.database.v1.Database.reconciling]
	//     field is set to true.
	//   - Cancelling the operation is best-effort. If the cancellation succeeds,
	//     the operation metadata's
	//     [cancel_time][google.spanner.admin.database.v1.UpdateDatabaseMetadata.cancel_time]
	//     is set, the updates are reverted, and the operation terminates with a
	//     `CANCELLED` status.
	//   - New UpdateDatabase requests will return a `FAILED_PRECONDITION` error
	//     until the pending operation is done (returns successfully or with
	//     error).
	//   - Reading the database via the API continues to give the pre-request
	//     values.
	//
	// Upon completion of the returned operation:
	//
	//   - The new values are in effect and readable via the API.
	//   - The database's
	//     [reconciling][google.spanner.admin.database.v1.Database.reconciling]
	//     field becomes false.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`
	// and can be used to track the database modification. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateDatabaseMetadata][google.spanner.admin.database.v1.UpdateDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Database][google.spanner.admin.database.v1.Database], if successful.
	UpdateDatabase(ctx context.Context, in *UpdateDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the schema of a Cloud Spanner database by
	// creating/altering/dropping tables, columns, indexes, etc. The returned
	// [long-running operation][google.longrunning.Operation] will have a name of
	// the format `<database_name>/operations/<operation_id>` and can be used to
	// track execution of the schema change(s). The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].
	// The operation has no response.
	UpdateDatabaseDdl(ctx context.Context, in *UpdateDatabaseDdlRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Drops (aka deletes) a Cloud Spanner database.
	// Completed backups for the database will be retained according to their
	// `expire_time`.
	// Note: Cloud Spanner might continue to accept requests for a few seconds
	// after the database has been deleted.
	DropDatabase(ctx context.Context, in *DropDatabaseRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the schema of a Cloud Spanner database as a list of formatted
	// DDL statements. This method does not show pending schema updates, those may
	// be queried using the [Operations][google.longrunning.Operations] API.
	GetDatabaseDdl(ctx context.Context, in *GetDatabaseDdlRequest, opts ...grpc.CallOption) (*GetDatabaseDdlResponse, error)
	// Sets the access control policy on a database or backup resource.
	// Replaces any existing policy.
	//
	// Authorization requires `spanner.databases.setIamPolicy`
	// permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
	// For backups, authorization requires `spanner.backups.setIamPolicy`
	// permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the access control policy for a database or backup resource.
	// Returns an empty policy if a database or backup exists but does not have a
	// policy set.
	//
	// Authorization requires `spanner.databases.getIamPolicy` permission on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	// For backups, authorization requires `spanner.backups.getIamPolicy`
	// permission on [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified database or backup
	// resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner database will
	// result in a NOT_FOUND error if the user has
	// `spanner.databases.list` permission on the containing Cloud
	// Spanner instance. Otherwise returns an empty set of permissions.
	// Calling this method on a backup that does not exist will
	// result in a NOT_FOUND error if the user has
	// `spanner.backups.list` permission on the containing instance.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Starts creating a new Cloud Spanner Backup.
	// The returned backup [long-running operation][google.longrunning.Operation]
	// will have a name of the format
	// `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
	// and can be used to track creation of the backup. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Backup][google.spanner.admin.database.v1.Backup], if successful.
	// Cancelling the returned operation will stop the creation and delete the
	// backup. There can be only one pending backup creation per database. Backup
	// creation of different databases can run concurrently.
	CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts copying a Cloud Spanner Backup.
	// The returned backup [long-running operation][google.longrunning.Operation]
	// will have a name of the format
	// `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
	// and can be used to track copying of the backup. The operation is associated
	// with the destination backup.
	// The [metadata][google.longrunning.Operation.metadata] field type is
	// [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Backup][google.spanner.admin.database.v1.Backup], if successful.
	// Cancelling the returned operation will stop the copying and delete the
	// destination backup. Concurrent CopyBackup requests can run on the same
	// source backup.
	CopyBackup(ctx context.Context, in *CopyBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets metadata on a pending or completed
	// [Backup][google.spanner.admin.database.v1.Backup].
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Updates a pending or completed
	// [Backup][google.spanner.admin.database.v1.Backup].
	UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Deletes a pending or completed
	// [Backup][google.spanner.admin.database.v1.Backup].
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists completed and pending backups.
	// Backups returned are ordered by `create_time` in descending order,
	// starting from the most recent `create_time`.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Create a new database by restoring from a completed backup. The new
	// database must be in the same project and in an instance with the same
	// instance configuration as the instance containing
	// the backup. The returned database [long-running
	// operation][google.longrunning.Operation] has a name of the format
	// `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`,
	// and can be used to track the progress of the operation, and to cancel it.
	// The [metadata][google.longrunning.Operation.metadata] field type is
	// [RestoreDatabaseMetadata][google.spanner.admin.database.v1.RestoreDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] type
	// is [Database][google.spanner.admin.database.v1.Database], if
	// successful. Cancelling the returned operation will stop the restore and
	// delete the database.
	// There can be only one database being restored into an instance at a time.
	// Once the restore operation completes, a new restore operation can be
	// initiated, without waiting for the optimize operation associated with the
	// first restore to complete.
	RestoreDatabase(ctx context.Context, in *RestoreDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists database [longrunning-operations][google.longrunning.Operation].
	// A database operation has a name of the form
	// `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`.
	// The long-running operation
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations.
	ListDatabaseOperations(ctx context.Context, in *ListDatabaseOperationsRequest, opts ...grpc.CallOption) (*ListDatabaseOperationsResponse, error)
	// Lists the backup [long-running operations][google.longrunning.Operation] in
	// the given instance. A backup operation has a name of the form
	// `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation>`.
	// The long-running operation
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.progress.start_time` in descending order starting
	// from the most recently started operation.
	ListBackupOperations(ctx context.Context, in *ListBackupOperationsRequest, opts ...grpc.CallOption) (*ListBackupOperationsResponse, error)
	// Lists Cloud Spanner database roles.
	ListDatabaseRoles(ctx context.Context, in *ListDatabaseRolesRequest, opts ...grpc.CallOption) (*ListDatabaseRolesResponse, error)
	// Adds split points to specified tables, indexes of a database.
	AddSplitPoints(ctx context.Context, in *AddSplitPointsRequest, opts ...grpc.CallOption) (*AddSplitPointsResponse, error)
	// Creates a new backup schedule.
	CreateBackupSchedule(ctx context.Context, in *CreateBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error)
	// Gets backup schedule for the input schedule name.
	GetBackupSchedule(ctx context.Context, in *GetBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error)
	// Updates a backup schedule.
	UpdateBackupSchedule(ctx context.Context, in *UpdateBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error)
	// Deletes a backup schedule.
	DeleteBackupSchedule(ctx context.Context, in *DeleteBackupScheduleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all the backup schedules for the database.
	ListBackupSchedules(ctx context.Context, in *ListBackupSchedulesRequest, opts ...grpc.CallOption) (*ListBackupSchedulesResponse, error)
	// This is an internal API called by Spanner Graph jobs. You should never need
	// to call this API directly.
	InternalUpdateGraphOperation(ctx context.Context, in *InternalUpdateGraphOperationRequest, opts ...grpc.CallOption) (*InternalUpdateGraphOperationResponse, error)
}

type databaseAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewDatabaseAdminClient(cc grpc.ClientConnInterface) DatabaseAdminClient {
	return &databaseAdminClient{cc}
}

func (c *databaseAdminClient) ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error) {
	out := new(ListDatabasesResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_ListDatabases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatabaseAdmin_CreateDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, DatabaseAdmin_GetDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) UpdateDatabase(ctx context.Context, in *UpdateDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatabaseAdmin_UpdateDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) UpdateDatabaseDdl(ctx context.Context, in *UpdateDatabaseDdlRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatabaseAdmin_UpdateDatabaseDdl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) DropDatabase(ctx context.Context, in *DropDatabaseRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DatabaseAdmin_DropDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetDatabaseDdl(ctx context.Context, in *GetDatabaseDdlRequest, opts ...grpc.CallOption) (*GetDatabaseDdlResponse, error) {
	out := new(GetDatabaseDdlResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_GetDatabaseDdl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DatabaseAdmin_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DatabaseAdmin_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatabaseAdmin_CreateBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) CopyBackup(ctx context.Context, in *CopyBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatabaseAdmin_CopyBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, DatabaseAdmin_GetBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, DatabaseAdmin_UpdateBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DatabaseAdmin_DeleteBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_ListBackups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) RestoreDatabase(ctx context.Context, in *RestoreDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatabaseAdmin_RestoreDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) ListDatabaseOperations(ctx context.Context, in *ListDatabaseOperationsRequest, opts ...grpc.CallOption) (*ListDatabaseOperationsResponse, error) {
	out := new(ListDatabaseOperationsResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_ListDatabaseOperations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) ListBackupOperations(ctx context.Context, in *ListBackupOperationsRequest, opts ...grpc.CallOption) (*ListBackupOperationsResponse, error) {
	out := new(ListBackupOperationsResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_ListBackupOperations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) ListDatabaseRoles(ctx context.Context, in *ListDatabaseRolesRequest, opts ...grpc.CallOption) (*ListDatabaseRolesResponse, error) {
	out := new(ListDatabaseRolesResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_ListDatabaseRoles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) AddSplitPoints(ctx context.Context, in *AddSplitPointsRequest, opts ...grpc.CallOption) (*AddSplitPointsResponse, error) {
	out := new(AddSplitPointsResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_AddSplitPoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) CreateBackupSchedule(ctx context.Context, in *CreateBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error) {
	out := new(BackupSchedule)
	err := c.cc.Invoke(ctx, DatabaseAdmin_CreateBackupSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetBackupSchedule(ctx context.Context, in *GetBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error) {
	out := new(BackupSchedule)
	err := c.cc.Invoke(ctx, DatabaseAdmin_GetBackupSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) UpdateBackupSchedule(ctx context.Context, in *UpdateBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error) {
	out := new(BackupSchedule)
	err := c.cc.Invoke(ctx, DatabaseAdmin_UpdateBackupSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) DeleteBackupSchedule(ctx context.Context, in *DeleteBackupScheduleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DatabaseAdmin_DeleteBackupSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) ListBackupSchedules(ctx context.Context, in *ListBackupSchedulesRequest, opts ...grpc.CallOption) (*ListBackupSchedulesResponse, error) {
	out := new(ListBackupSchedulesResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_ListBackupSchedules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) InternalUpdateGraphOperation(ctx context.Context, in *InternalUpdateGraphOperationRequest, opts ...grpc.CallOption) (*InternalUpdateGraphOperationResponse, error) {
	out := new(InternalUpdateGraphOperationResponse)
	err := c.cc.Invoke(ctx, DatabaseAdmin_InternalUpdateGraphOperation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatabaseAdminServer is the server API for DatabaseAdmin service.
// All implementations should embed UnimplementedDatabaseAdminServer
// for forward compatibility
type DatabaseAdminServer interface {
	// Lists Cloud Spanner databases.
	ListDatabases(context.Context, *ListDatabasesRequest) (*ListDatabasesResponse, error)
	// Creates a new Cloud Spanner database and starts to prepare it for serving.
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<database_name>/operations/<operation_id>` and
	// can be used to track preparation of the database. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Database][google.spanner.admin.database.v1.Database], if successful.
	CreateDatabase(context.Context, *CreateDatabaseRequest) (*longrunningpb.Operation, error)
	// Gets the state of a Cloud Spanner database.
	GetDatabase(context.Context, *GetDatabaseRequest) (*Database, error)
	// Updates a Cloud Spanner database. The returned
	// [long-running operation][google.longrunning.Operation] can be used to track
	// the progress of updating the database. If the named database does not
	// exist, returns `NOT_FOUND`.
	//
	// While the operation is pending:
	//
	//   - The database's
	//     [reconciling][google.spanner.admin.database.v1.Database.reconciling]
	//     field is set to true.
	//   - Cancelling the operation is best-effort. If the cancellation succeeds,
	//     the operation metadata's
	//     [cancel_time][google.spanner.admin.database.v1.UpdateDatabaseMetadata.cancel_time]
	//     is set, the updates are reverted, and the operation terminates with a
	//     `CANCELLED` status.
	//   - New UpdateDatabase requests will return a `FAILED_PRECONDITION` error
	//     until the pending operation is done (returns successfully or with
	//     error).
	//   - Reading the database via the API continues to give the pre-request
	//     values.
	//
	// Upon completion of the returned operation:
	//
	//   - The new values are in effect and readable via the API.
	//   - The database's
	//     [reconciling][google.spanner.admin.database.v1.Database.reconciling]
	//     field becomes false.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`
	// and can be used to track the database modification. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateDatabaseMetadata][google.spanner.admin.database.v1.UpdateDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Database][google.spanner.admin.database.v1.Database], if successful.
	UpdateDatabase(context.Context, *UpdateDatabaseRequest) (*longrunningpb.Operation, error)
	// Updates the schema of a Cloud Spanner database by
	// creating/altering/dropping tables, columns, indexes, etc. The returned
	// [long-running operation][google.longrunning.Operation] will have a name of
	// the format `<database_name>/operations/<operation_id>` and can be used to
	// track execution of the schema change(s). The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].
	// The operation has no response.
	UpdateDatabaseDdl(context.Context, *UpdateDatabaseDdlRequest) (*longrunningpb.Operation, error)
	// Drops (aka deletes) a Cloud Spanner database.
	// Completed backups for the database will be retained according to their
	// `expire_time`.
	// Note: Cloud Spanner might continue to accept requests for a few seconds
	// after the database has been deleted.
	DropDatabase(context.Context, *DropDatabaseRequest) (*emptypb.Empty, error)
	// Returns the schema of a Cloud Spanner database as a list of formatted
	// DDL statements. This method does not show pending schema updates, those may
	// be queried using the [Operations][google.longrunning.Operations] API.
	GetDatabaseDdl(context.Context, *GetDatabaseDdlRequest) (*GetDatabaseDdlResponse, error)
	// Sets the access control policy on a database or backup resource.
	// Replaces any existing policy.
	//
	// Authorization requires `spanner.databases.setIamPolicy`
	// permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
	// For backups, authorization requires `spanner.backups.setIamPolicy`
	// permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the access control policy for a database or backup resource.
	// Returns an empty policy if a database or backup exists but does not have a
	// policy set.
	//
	// Authorization requires `spanner.databases.getIamPolicy` permission on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	// For backups, authorization requires `spanner.backups.getIamPolicy`
	// permission on [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified database or backup
	// resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner database will
	// result in a NOT_FOUND error if the user has
	// `spanner.databases.list` permission on the containing Cloud
	// Spanner instance. Otherwise returns an empty set of permissions.
	// Calling this method on a backup that does not exist will
	// result in a NOT_FOUND error if the user has
	// `spanner.backups.list` permission on the containing instance.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Starts creating a new Cloud Spanner Backup.
	// The returned backup [long-running operation][google.longrunning.Operation]
	// will have a name of the format
	// `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
	// and can be used to track creation of the backup. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Backup][google.spanner.admin.database.v1.Backup], if successful.
	// Cancelling the returned operation will stop the creation and delete the
	// backup. There can be only one pending backup creation per database. Backup
	// creation of different databases can run concurrently.
	CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error)
	// Starts copying a Cloud Spanner Backup.
	// The returned backup [long-running operation][google.longrunning.Operation]
	// will have a name of the format
	// `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
	// and can be used to track copying of the backup. The operation is associated
	// with the destination backup.
	// The [metadata][google.longrunning.Operation.metadata] field type is
	// [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Backup][google.spanner.admin.database.v1.Backup], if successful.
	// Cancelling the returned operation will stop the copying and delete the
	// destination backup. Concurrent CopyBackup requests can run on the same
	// source backup.
	CopyBackup(context.Context, *CopyBackupRequest) (*longrunningpb.Operation, error)
	// Gets metadata on a pending or completed
	// [Backup][google.spanner.admin.database.v1.Backup].
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Updates a pending or completed
	// [Backup][google.spanner.admin.database.v1.Backup].
	UpdateBackup(context.Context, *UpdateBackupRequest) (*Backup, error)
	// Deletes a pending or completed
	// [Backup][google.spanner.admin.database.v1.Backup].
	DeleteBackup(context.Context, *DeleteBackupRequest) (*emptypb.Empty, error)
	// Lists completed and pending backups.
	// Backups returned are ordered by `create_time` in descending order,
	// starting from the most recent `create_time`.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Create a new database by restoring from a completed backup. The new
	// database must be in the same project and in an instance with the same
	// instance configuration as the instance containing
	// the backup. The returned database [long-running
	// operation][google.longrunning.Operation] has a name of the format
	// `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`,
	// and can be used to track the progress of the operation, and to cancel it.
	// The [metadata][google.longrunning.Operation.metadata] field type is
	// [RestoreDatabaseMetadata][google.spanner.admin.database.v1.RestoreDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] type
	// is [Database][google.spanner.admin.database.v1.Database], if
	// successful. Cancelling the returned operation will stop the restore and
	// delete the database.
	// There can be only one database being restored into an instance at a time.
	// Once the restore operation completes, a new restore operation can be
	// initiated, without waiting for the optimize operation associated with the
	// first restore to complete.
	RestoreDatabase(context.Context, *RestoreDatabaseRequest) (*longrunningpb.Operation, error)
	// Lists database [longrunning-operations][google.longrunning.Operation].
	// A database operation has a name of the form
	// `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`.
	// The long-running operation
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations.
	ListDatabaseOperations(context.Context, *ListDatabaseOperationsRequest) (*ListDatabaseOperationsResponse, error)
	// Lists the backup [long-running operations][google.longrunning.Operation] in
	// the given instance. A backup operation has a name of the form
	// `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation>`.
	// The long-running operation
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.progress.start_time` in descending order starting
	// from the most recently started operation.
	ListBackupOperations(context.Context, *ListBackupOperationsRequest) (*ListBackupOperationsResponse, error)
	// Lists Cloud Spanner database roles.
	ListDatabaseRoles(context.Context, *ListDatabaseRolesRequest) (*ListDatabaseRolesResponse, error)
	// Adds split points to specified tables, indexes of a database.
	AddSplitPoints(context.Context, *AddSplitPointsRequest) (*AddSplitPointsResponse, error)
	// Creates a new backup schedule.
	CreateBackupSchedule(context.Context, *CreateBackupScheduleRequest) (*BackupSchedule, error)
	// Gets backup schedule for the input schedule name.
	GetBackupSchedule(context.Context, *GetBackupScheduleRequest) (*BackupSchedule, error)
	// Updates a backup schedule.
	UpdateBackupSchedule(context.Context, *UpdateBackupScheduleRequest) (*BackupSchedule, error)
	// Deletes a backup schedule.
	DeleteBackupSchedule(context.Context, *DeleteBackupScheduleRequest) (*emptypb.Empty, error)
	// Lists all the backup schedules for the database.
	ListBackupSchedules(context.Context, *ListBackupSchedulesRequest) (*ListBackupSchedulesResponse, error)
	// This is an internal API called by Spanner Graph jobs. You should never need
	// to call this API directly.
	InternalUpdateGraphOperation(context.Context, *InternalUpdateGraphOperationRequest) (*InternalUpdateGraphOperationResponse, error)
}

// UnimplementedDatabaseAdminServer should be embedded to have forward compatible implementations.
type UnimplementedDatabaseAdminServer struct {
}

func (UnimplementedDatabaseAdminServer) ListDatabases(context.Context, *ListDatabasesRequest) (*ListDatabasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatabases not implemented")
}
func (UnimplementedDatabaseAdminServer) CreateDatabase(context.Context, *CreateDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDatabase not implemented")
}
func (UnimplementedDatabaseAdminServer) GetDatabase(context.Context, *GetDatabaseRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatabase not implemented")
}
func (UnimplementedDatabaseAdminServer) UpdateDatabase(context.Context, *UpdateDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDatabase not implemented")
}
func (UnimplementedDatabaseAdminServer) UpdateDatabaseDdl(context.Context, *UpdateDatabaseDdlRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDatabaseDdl not implemented")
}
func (UnimplementedDatabaseAdminServer) DropDatabase(context.Context, *DropDatabaseRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DropDatabase not implemented")
}
func (UnimplementedDatabaseAdminServer) GetDatabaseDdl(context.Context, *GetDatabaseDdlRequest) (*GetDatabaseDdlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatabaseDdl not implemented")
}
func (UnimplementedDatabaseAdminServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedDatabaseAdminServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedDatabaseAdminServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedDatabaseAdminServer) CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackup not implemented")
}
func (UnimplementedDatabaseAdminServer) CopyBackup(context.Context, *CopyBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CopyBackup not implemented")
}
func (UnimplementedDatabaseAdminServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (UnimplementedDatabaseAdminServer) UpdateBackup(context.Context, *UpdateBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackup not implemented")
}
func (UnimplementedDatabaseAdminServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (UnimplementedDatabaseAdminServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (UnimplementedDatabaseAdminServer) RestoreDatabase(context.Context, *RestoreDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreDatabase not implemented")
}
func (UnimplementedDatabaseAdminServer) ListDatabaseOperations(context.Context, *ListDatabaseOperationsRequest) (*ListDatabaseOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatabaseOperations not implemented")
}
func (UnimplementedDatabaseAdminServer) ListBackupOperations(context.Context, *ListBackupOperationsRequest) (*ListBackupOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupOperations not implemented")
}
func (UnimplementedDatabaseAdminServer) ListDatabaseRoles(context.Context, *ListDatabaseRolesRequest) (*ListDatabaseRolesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatabaseRoles not implemented")
}
func (UnimplementedDatabaseAdminServer) AddSplitPoints(context.Context, *AddSplitPointsRequest) (*AddSplitPointsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddSplitPoints not implemented")
}
func (UnimplementedDatabaseAdminServer) CreateBackupSchedule(context.Context, *CreateBackupScheduleRequest) (*BackupSchedule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackupSchedule not implemented")
}
func (UnimplementedDatabaseAdminServer) GetBackupSchedule(context.Context, *GetBackupScheduleRequest) (*BackupSchedule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupSchedule not implemented")
}
func (UnimplementedDatabaseAdminServer) UpdateBackupSchedule(context.Context, *UpdateBackupScheduleRequest) (*BackupSchedule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackupSchedule not implemented")
}
func (UnimplementedDatabaseAdminServer) DeleteBackupSchedule(context.Context, *DeleteBackupScheduleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackupSchedule not implemented")
}
func (UnimplementedDatabaseAdminServer) ListBackupSchedules(context.Context, *ListBackupSchedulesRequest) (*ListBackupSchedulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupSchedules not implemented")
}
func (UnimplementedDatabaseAdminServer) InternalUpdateGraphOperation(context.Context, *InternalUpdateGraphOperationRequest) (*InternalUpdateGraphOperationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InternalUpdateGraphOperation not implemented")
}

// UnsafeDatabaseAdminServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DatabaseAdminServer will
// result in compilation errors.
type UnsafeDatabaseAdminServer interface {
	mustEmbedUnimplementedDatabaseAdminServer()
}

func RegisterDatabaseAdminServer(s grpc.ServiceRegistrar, srv DatabaseAdminServer) {
	s.RegisterService(&DatabaseAdmin_ServiceDesc, srv)
}

func _DatabaseAdmin_ListDatabases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).ListDatabases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_ListDatabases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).ListDatabases(ctx, req.(*ListDatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_CreateDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).CreateDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_CreateDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).CreateDatabase(ctx, req.(*CreateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_GetDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetDatabase(ctx, req.(*GetDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_UpdateDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).UpdateDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_UpdateDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).UpdateDatabase(ctx, req.(*UpdateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_UpdateDatabaseDdl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatabaseDdlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).UpdateDatabaseDdl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_UpdateDatabaseDdl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).UpdateDatabaseDdl(ctx, req.(*UpdateDatabaseDdlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_DropDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DropDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).DropDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_DropDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).DropDatabase(ctx, req.(*DropDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetDatabaseDdl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseDdlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetDatabaseDdl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_GetDatabaseDdl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetDatabaseDdl(ctx, req.(*GetDatabaseDdlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_CreateBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).CreateBackup(ctx, req.(*CreateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_CopyBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CopyBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).CopyBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_CopyBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).CopyBackup(ctx, req.(*CopyBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_GetBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_UpdateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).UpdateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_UpdateBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).UpdateBackup(ctx, req.(*UpdateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_DeleteBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_ListBackups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_RestoreDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).RestoreDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_RestoreDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).RestoreDatabase(ctx, req.(*RestoreDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_ListDatabaseOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatabaseOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).ListDatabaseOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_ListDatabaseOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).ListDatabaseOperations(ctx, req.(*ListDatabaseOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_ListBackupOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).ListBackupOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_ListBackupOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).ListBackupOperations(ctx, req.(*ListBackupOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_ListDatabaseRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatabaseRolesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).ListDatabaseRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_ListDatabaseRoles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).ListDatabaseRoles(ctx, req.(*ListDatabaseRolesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_AddSplitPoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSplitPointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).AddSplitPoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_AddSplitPoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).AddSplitPoints(ctx, req.(*AddSplitPointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_CreateBackupSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).CreateBackupSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_CreateBackupSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).CreateBackupSchedule(ctx, req.(*CreateBackupScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetBackupSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetBackupSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_GetBackupSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetBackupSchedule(ctx, req.(*GetBackupScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_UpdateBackupSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).UpdateBackupSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_UpdateBackupSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).UpdateBackupSchedule(ctx, req.(*UpdateBackupScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_DeleteBackupSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).DeleteBackupSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_DeleteBackupSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).DeleteBackupSchedule(ctx, req.(*DeleteBackupScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_ListBackupSchedules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupSchedulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).ListBackupSchedules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_ListBackupSchedules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).ListBackupSchedules(ctx, req.(*ListBackupSchedulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_InternalUpdateGraphOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InternalUpdateGraphOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).InternalUpdateGraphOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatabaseAdmin_InternalUpdateGraphOperation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).InternalUpdateGraphOperation(ctx, req.(*InternalUpdateGraphOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DatabaseAdmin_ServiceDesc is the grpc.ServiceDesc for DatabaseAdmin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DatabaseAdmin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.admin.database.v1.DatabaseAdmin",
	HandlerType: (*DatabaseAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDatabases",
			Handler:    _DatabaseAdmin_ListDatabases_Handler,
		},
		{
			MethodName: "CreateDatabase",
			Handler:    _DatabaseAdmin_CreateDatabase_Handler,
		},
		{
			MethodName: "GetDatabase",
			Handler:    _DatabaseAdmin_GetDatabase_Handler,
		},
		{
			MethodName: "UpdateDatabase",
			Handler:    _DatabaseAdmin_UpdateDatabase_Handler,
		},
		{
			MethodName: "UpdateDatabaseDdl",
			Handler:    _DatabaseAdmin_UpdateDatabaseDdl_Handler,
		},
		{
			MethodName: "DropDatabase",
			Handler:    _DatabaseAdmin_DropDatabase_Handler,
		},
		{
			MethodName: "GetDatabaseDdl",
			Handler:    _DatabaseAdmin_GetDatabaseDdl_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DatabaseAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DatabaseAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DatabaseAdmin_TestIamPermissions_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _DatabaseAdmin_CreateBackup_Handler,
		},
		{
			MethodName: "CopyBackup",
			Handler:    _DatabaseAdmin_CopyBackup_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _DatabaseAdmin_GetBackup_Handler,
		},
		{
			MethodName: "UpdateBackup",
			Handler:    _DatabaseAdmin_UpdateBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _DatabaseAdmin_DeleteBackup_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _DatabaseAdmin_ListBackups_Handler,
		},
		{
			MethodName: "RestoreDatabase",
			Handler:    _DatabaseAdmin_RestoreDatabase_Handler,
		},
		{
			MethodName: "ListDatabaseOperations",
			Handler:    _DatabaseAdmin_ListDatabaseOperations_Handler,
		},
		{
			MethodName: "ListBackupOperations",
			Handler:    _DatabaseAdmin_ListBackupOperations_Handler,
		},
		{
			MethodName: "ListDatabaseRoles",
			Handler:    _DatabaseAdmin_ListDatabaseRoles_Handler,
		},
		{
			MethodName: "AddSplitPoints",
			Handler:    _DatabaseAdmin_AddSplitPoints_Handler,
		},
		{
			MethodName: "CreateBackupSchedule",
			Handler:    _DatabaseAdmin_CreateBackupSchedule_Handler,
		},
		{
			MethodName: "GetBackupSchedule",
			Handler:    _DatabaseAdmin_GetBackupSchedule_Handler,
		},
		{
			MethodName: "UpdateBackupSchedule",
			Handler:    _DatabaseAdmin_UpdateBackupSchedule_Handler,
		},
		{
			MethodName: "DeleteBackupSchedule",
			Handler:    _DatabaseAdmin_DeleteBackupSchedule_Handler,
		},
		{
			MethodName: "ListBackupSchedules",
			Handler:    _DatabaseAdmin_ListBackupSchedules_Handler,
		},
		{
			MethodName: "InternalUpdateGraphOperation",
			Handler:    _DatabaseAdmin_InternalUpdateGraphOperation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/spanner/admin/database/v1/spanner_database_admin.proto",
}
