/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParserSupportedFileExtension;
import liquibase.parser.core.xml.AbstractChangeLogParser;
import liquibase.parser.core.xml.LiquibaseEntityResolver;
import liquibase.parser.core.xml.XMLChangeLogSAXHandler;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.BomAwareInputStream;
import liquibase.util.FileUtil;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLChangeLogSAXParser
extends AbstractChangeLogParser {
    public static final String LIQUIBASE_SCHEMA_VERSION = XMLChangeLogSAXParser.computeSchemaVersion(LiquibaseUtil.getBuildVersion());
    private final SAXParserFactory saxParserFactory;
    private final String FIRST_VALID_TAG_REGEX = "^\\s*<databaseChangeLog\\s?.*";
    private final Pattern FIRST_VALID_TAG_PATTERN = Pattern.compile("^\\s*<databaseChangeLog\\s?.*", 2);
    private final String IGNORE_FIRST_LINE_COMMENTS_AND_XML_TAG_REGEX = "^\\s*(<!--|<!|<!DOCTYPE|]>|<\\?xml).*|^\\s*$";
    private final Pattern IGNORE_FIRST_LINE_COMMENTS_AND_XML_TAG_PATTERN = Pattern.compile("^\\s*(<!--|<!|<!DOCTYPE|]>|<\\?xml).*|^\\s*$", 2);
    private final LiquibaseEntityResolver resolver = new LiquibaseEntityResolver();

    public XMLChangeLogSAXParser() {
        this.saxParserFactory = SAXParserFactory.newInstance();
        this.saxParserFactory.setValidating(GlobalConfiguration.VALIDATE_XML_CHANGELOG_FILES.getCurrentValue());
        this.saxParserFactory.setNamespaceAware(true);
        if (GlobalConfiguration.SECURE_PARSING.getCurrentValue().booleanValue()) {
            try {
                this.saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (Throwable e) {
                Scope.getCurrentScope().getLog(this.getClass()).fine("Cannot enable FEATURE_SECURE_PROCESSING: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    public static String getSchemaVersion() {
        return LIQUIBASE_SCHEMA_VERSION;
    }

    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        return ParserSupportedFileExtension.XML_SUPPORTED_EXTENSIONS.stream().anyMatch(ext -> changeLogFile.toLowerCase().endsWith((String)ext));
    }

    protected SAXParserFactory getSaxParserFactory() {
        return this.saxParserFactory;
    }

    public void setShouldWarnOnMismatchedXsdVersion(boolean shouldWarnOnMismatchedXsdVersion) {
        this.resolver.setShouldWarnOnMismatchedXsdVersion(shouldWarnOnMismatchedXsdVersion);
    }

    @Override
    protected ParsedNode parseToNode(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        try {
            Resource resource = resourceAccessor.get(physicalChangeLogLocation);
            SAXParser parser = this.saxParserFactory.newSAXParser();
            if (GlobalConfiguration.SECURE_PARSING.getCurrentValue().booleanValue()) {
                try {
                    parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "http,https");
                }
                catch (SAXException e) {
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Cannot enable ACCESS_EXTERNAL_SCHEMA: " + e.getMessage(), e);
                }
            }
            this.trySetSchemaLanguageProperty(parser);
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setEntityResolver(this.resolver);
            xmlReader.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    Scope.getCurrentScope().getLog(this.getClass()).warning(exception.getMessage());
                    throw exception;
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    Scope.getCurrentScope().getLog(this.getClass()).severe(exception.getMessage());
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    Scope.getCurrentScope().getLog(this.getClass()).severe(exception.getMessage());
                    throw exception;
                }
            });
            if (!resource.exists()) {
                if (physicalChangeLogLocation.startsWith("WEB-INF/classes/")) {
                    return this.parseToNode(physicalChangeLogLocation.replaceFirst("WEB-INF/classes/", ""), changeLogParameters, resourceAccessor);
                }
                throw new ChangeLogParseException(FileUtil.getFileNotFoundMessage(physicalChangeLogLocation));
            }
            XMLChangeLogSAXHandler contentHandler = new XMLChangeLogSAXHandler(physicalChangeLogLocation, resourceAccessor, changeLogParameters);
            xmlReader.setContentHandler(contentHandler);
            try (InputStream stream = resource.openInputStream();){
                xmlReader.parse(new InputSource((InputStream)((Object)new BomAwareInputStream(stream))));
            }
            return contentHandler.getDatabaseChangeLogTree();
        }
        catch (ChangeLogParseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ChangeLogParseException("Error Reading Changelog File: " + e.getMessage(), e);
        }
        catch (SAXParseException e) {
            String errMsg = e.getMessage();
            try {
                Boolean isDatabaseChangeLogRootElement = this.isDatabaseChangeLogTagTheFirstElement(physicalChangeLogLocation, resourceAccessor);
                if (isDatabaseChangeLogRootElement != null && !isDatabaseChangeLogRootElement.booleanValue()) {
                    errMsg = "\"databaseChangeLog\" expected as root element";
                } else if (isDatabaseChangeLogRootElement == null) {
                    throw new ChangeLogParseException(String.format("Unable to parse empty file: '%s'", physicalChangeLogLocation));
                }
            }
            catch (IOException ex) {
                throw new ChangeLogParseException(errMsg, e);
            }
            throw new ChangeLogParseException("Error parsing line " + e.getLineNumber() + " column " + e.getColumnNumber() + " of " + physicalChangeLogLocation + ": " + errMsg, e);
        }
        catch (SAXException e) {
            for (Throwable parentCause = e.getException(); parentCause != null; parentCause = parentCause.getCause()) {
                if (!(parentCause instanceof ChangeLogParseException)) continue;
                throw (ChangeLogParseException)parentCause;
            }
            String reason = e.getMessage();
            String causeReason = null;
            if (e.getCause() != null) {
                causeReason = e.getCause().getMessage();
            }
            if (reason == null) {
                reason = causeReason != null ? causeReason : "Unknown Reason";
            }
            throw new ChangeLogParseException("Invalid Migration File: " + reason, e);
        }
        catch (Exception e) {
            throw new ChangeLogParseException(e);
        }
    }

    private void trySetSchemaLanguageProperty(SAXParser parser) {
        try {
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }

    static String computeSchemaVersion(String version) {
        Object finalVersion = null;
        if (version != null && version.contains(".")) {
            String[] splitVersion = version.split("\\.");
            finalVersion = splitVersion[0] + "." + splitVersion[1];
        }
        if (finalVersion == null) {
            finalVersion = "latest";
        }
        return finalVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean isDatabaseChangeLogTagTheFirstElement(String changeLogFile, ResourceAccessor resourceAccessor) throws IOException, ChangeLogParseException {
        BufferedReader reader = null;
        try {
            InputStream fileStream = this.openChangeLogFile(changeLogFile, resourceAccessor);
            if (fileStream == null) {
                Boolean bl = false;
                return bl;
            }
            reader = new BufferedReader(StreamUtil.readStreamWithReader(fileStream, null));
            if (!reader.ready()) {
                throw new ChangeLogParseException(String.format("Unable to parse empty file: '%s'", changeLogFile));
            }
            String firstLine = reader.readLine();
            boolean keepSearchingFirstValidTag = true;
            while (keepSearchingFirstValidTag) {
                if (this.IGNORE_FIRST_LINE_COMMENTS_AND_XML_TAG_PATTERN.matcher(firstLine).matches() && reader.ready()) {
                    firstLine = reader.readLine();
                    continue;
                }
                keepSearchingFirstValidTag = false;
            }
            if (firstLine != null && firstLine.trim().isEmpty()) {
                throw new ChangeLogParseException(String.format("Unable to parse empty file: '%s'", changeLogFile));
            }
            if (firstLine != null) {
                Boolean bl = this.FIRST_VALID_TAG_PATTERN.matcher(firstLine).matches();
                return bl;
            }
            Boolean bl = null;
            return bl;
        }
        catch (IOException e) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Exception reading " + changeLogFile, e);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Exception closing " + changeLogFile, e);
                }
            }
        }
    }

    protected InputStream openChangeLogFile(String physicalChangeLogLocation, ResourceAccessor resourceAccessor) throws IOException {
        return resourceAccessor.getExisting(physicalChangeLogLocation).openInputStream();
    }
}

