/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.ClassLoaderHelper;
import software.amazon.awssdk.utils.Logger;

@SdkProtectedApi
public final class DependencyValidate {
    private static final Logger LOG = Logger.loggerFor(DependencyValidate.class);

    private DependencyValidate() {
    }

    public static void requireClass(String classPath, String module, String feature) {
        try {
            ClassLoaderHelper.loadClass(classPath, false, new Class[0]);
        }
        catch (ClassNotFoundException e) {
            LOG.debug(() -> "Cannot find the " + classPath + " class: ", e);
            String msg = String.format("Could not load class. You must add a dependency on the '%s' module to enable the %s feature: ", module, feature);
            throw new RuntimeException(msg, e);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not load class (%s): ", classPath), e);
        }
    }
}

