/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class AutoGradeProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("(").number("d{12}").number("(d{15})").number("(dd)(dd)(dd)").expression("([AV])").number("(d+)(dd.d+)([NS])").number("(d+)(dd.d+)([EW])").number("([d.]{5})").number("(dd)(dd)(dd)").number("([d.]{6})").expression("(.)").number("A(xxxx)").number("B(xxxx)").number("C(xxxx)").number("D(xxxx)").number("E(xxxx)").number("K(xxxx)").number("L(xxxx)").number("M(xxxx)").number("N(xxxx)").number("O(xxxx)").any().compile();

    public AutoGradeProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        int i;
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        dateBuilder.setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        position.setCourse(parser.nextDouble(0.0));
        char status = parser.next().charAt(0);
        position.set("status", Integer.valueOf(status));
        position.set("ignition", BitUtil.check(status, 0));
        for (i = 1; i <= 5; ++i) {
            position.set("adc" + i, parser.next());
        }
        for (i = 1; i <= 5; ++i) {
            position.set("can" + i, parser.next());
        }
        return position;
    }
}

