/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.semconv.url.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.semconv.url.UrlAttributesGetter;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.function.Function;

public final class InternalUrlAttributesExtractor<REQUEST> {
    private final UrlAttributesGetter<REQUEST> getter;
    private final Function<REQUEST, String> alternateSchemeProvider;

    public InternalUrlAttributesExtractor(UrlAttributesGetter<REQUEST> getter, Function<REQUEST, String> alternateSchemeProvider) {
        this.getter = getter;
        this.alternateSchemeProvider = alternateSchemeProvider;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        String urlScheme = this.getUrlScheme(request);
        String urlPath = this.getter.getUrlPath(request);
        String urlQuery = this.getter.getUrlQuery(request);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.URL_SCHEME, urlScheme);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.URL_PATH, urlPath);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.URL_QUERY, urlQuery);
    }

    private String getUrlScheme(REQUEST request) {
        String urlScheme = this.alternateSchemeProvider.apply(request);
        if (urlScheme == null) {
            urlScheme = this.getter.getUrlScheme(request);
        }
        return urlScheme;
    }
}

