// This file is part of MinIO DirectPV
// Copyright (c) 2021, 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by client-gen. DO NOT EDIT.

package v1beta3

import (
	"context"
	"time"

	v1beta3 "github.com/minio/directpv/pkg/apis/direct.csi.min.io/v1beta3"
	scheme "github.com/minio/directpv/pkg/clientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// DirectCSIDrivesGetter has a method to return a DirectCSIDriveInterface.
// A group's client should implement this interface.
type DirectCSIDrivesGetter interface {
	DirectCSIDrives() DirectCSIDriveInterface
}

// DirectCSIDriveInterface has methods to work with DirectCSIDrive resources.
type DirectCSIDriveInterface interface {
	Create(ctx context.Context, directCSIDrive *v1beta3.DirectCSIDrive, opts v1.CreateOptions) (*v1beta3.DirectCSIDrive, error)
	Update(ctx context.Context, directCSIDrive *v1beta3.DirectCSIDrive, opts v1.UpdateOptions) (*v1beta3.DirectCSIDrive, error)
	UpdateStatus(ctx context.Context, directCSIDrive *v1beta3.DirectCSIDrive, opts v1.UpdateOptions) (*v1beta3.DirectCSIDrive, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta3.DirectCSIDrive, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta3.DirectCSIDriveList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta3.DirectCSIDrive, err error)
	DirectCSIDriveExpansion
}

// directCSIDrives implements DirectCSIDriveInterface
type directCSIDrives struct {
	client rest.Interface
}

// newDirectCSIDrives returns a DirectCSIDrives
func newDirectCSIDrives(c *DirectV1beta3Client) *directCSIDrives {
	return &directCSIDrives{
		client: c.RESTClient(),
	}
}

// Get takes name of the directCSIDrive, and returns the corresponding directCSIDrive object, and an error if there is any.
func (c *directCSIDrives) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta3.DirectCSIDrive, err error) {
	result = &v1beta3.DirectCSIDrive{}
	err = c.client.Get().
		Resource("directcsidrives").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of DirectCSIDrives that match those selectors.
func (c *directCSIDrives) List(ctx context.Context, opts v1.ListOptions) (result *v1beta3.DirectCSIDriveList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta3.DirectCSIDriveList{}
	err = c.client.Get().
		Resource("directcsidrives").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested directCSIDrives.
func (c *directCSIDrives) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("directcsidrives").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a directCSIDrive and creates it.  Returns the server's representation of the directCSIDrive, and an error, if there is any.
func (c *directCSIDrives) Create(ctx context.Context, directCSIDrive *v1beta3.DirectCSIDrive, opts v1.CreateOptions) (result *v1beta3.DirectCSIDrive, err error) {
	result = &v1beta3.DirectCSIDrive{}
	err = c.client.Post().
		Resource("directcsidrives").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(directCSIDrive).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a directCSIDrive and updates it. Returns the server's representation of the directCSIDrive, and an error, if there is any.
func (c *directCSIDrives) Update(ctx context.Context, directCSIDrive *v1beta3.DirectCSIDrive, opts v1.UpdateOptions) (result *v1beta3.DirectCSIDrive, err error) {
	result = &v1beta3.DirectCSIDrive{}
	err = c.client.Put().
		Resource("directcsidrives").
		Name(directCSIDrive.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(directCSIDrive).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *directCSIDrives) UpdateStatus(ctx context.Context, directCSIDrive *v1beta3.DirectCSIDrive, opts v1.UpdateOptions) (result *v1beta3.DirectCSIDrive, err error) {
	result = &v1beta3.DirectCSIDrive{}
	err = c.client.Put().
		Resource("directcsidrives").
		Name(directCSIDrive.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(directCSIDrive).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the directCSIDrive and deletes it. Returns an error if one occurs.
func (c *directCSIDrives) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("directcsidrives").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *directCSIDrives) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("directcsidrives").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched directCSIDrive.
func (c *directCSIDrives) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta3.DirectCSIDrive, err error) {
	result = &v1beta3.DirectCSIDrive{}
	err = c.client.Patch(pt).
		Resource("directcsidrives").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
