//
// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: proto/scan_result.proto

package scan_result_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Vuln exclusion reasons - Mirrors the format from the official VEX
// documentation
// (https://www.cisa.gov/sites/default/files/publications/VEX_Status_Justification_Jun22.pdf)
type VexJustification int32

const (
	VexJustification_VEX_JUSTIFICATION_UNSPECIFIED VexJustification = 0
	// The vulnerable component is not used in the affected artifact.
	VexJustification_COMPONENT_NOT_PRESENT VexJustification = 1
	// The component is used but vulnerable code was removed or not included.
	VexJustification_VULNERABLE_CODE_NOT_PRESENT VexJustification = 2
	// Vulnerable code is included but is not executed.
	VexJustification_VULNERABLE_CODE_NOT_IN_EXECUTE_PATH VexJustification = 3
	// Vulnerable code is executed but can't be exploited due to program logic.
	VexJustification_VULNERABLE_CODE_CANNOT_BE_CONTROLLED_BY_ADVERSARY VexJustification = 4
	// Code can be executed but additional mitigations prevent exploitation.
	VexJustification_INLINE_MITIGATION_ALREADY_EXISTS VexJustification = 5
)

// Enum value maps for VexJustification.
var (
	VexJustification_name = map[int32]string{
		0: "VEX_JUSTIFICATION_UNSPECIFIED",
		1: "COMPONENT_NOT_PRESENT",
		2: "VULNERABLE_CODE_NOT_PRESENT",
		3: "VULNERABLE_CODE_NOT_IN_EXECUTE_PATH",
		4: "VULNERABLE_CODE_CANNOT_BE_CONTROLLED_BY_ADVERSARY",
		5: "INLINE_MITIGATION_ALREADY_EXISTS",
	}
	VexJustification_value = map[string]int32{
		"VEX_JUSTIFICATION_UNSPECIFIED":                     0,
		"COMPONENT_NOT_PRESENT":                             1,
		"VULNERABLE_CODE_NOT_PRESENT":                       2,
		"VULNERABLE_CODE_NOT_IN_EXECUTE_PATH":               3,
		"VULNERABLE_CODE_CANNOT_BE_CONTROLLED_BY_ADVERSARY": 4,
		"INLINE_MITIGATION_ALREADY_EXISTS":                  5,
	}
)

func (x VexJustification) Enum() *VexJustification {
	p := new(VexJustification)
	*p = x
	return p
}

func (x VexJustification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VexJustification) Descriptor() protoreflect.EnumDescriptor {
	return file_proto_scan_result_proto_enumTypes[0].Descriptor()
}

func (VexJustification) Type() protoreflect.EnumType {
	return &file_proto_scan_result_proto_enumTypes[0]
}

func (x VexJustification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VexJustification.Descriptor instead.
func (VexJustification) EnumDescriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{0}
}

type SeverityEnum int32

const (
	SeverityEnum_SEVERITY_UNSPECIFIED SeverityEnum = 0
	SeverityEnum_MINIMAL              SeverityEnum = 1
	SeverityEnum_LOW                  SeverityEnum = 2
	SeverityEnum_MEDIUM               SeverityEnum = 3
	SeverityEnum_HIGH                 SeverityEnum = 4
	SeverityEnum_CRITICAL             SeverityEnum = 5
)

// Enum value maps for SeverityEnum.
var (
	SeverityEnum_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "MINIMAL",
		2: "LOW",
		3: "MEDIUM",
		4: "HIGH",
		5: "CRITICAL",
	}
	SeverityEnum_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"MINIMAL":              1,
		"LOW":                  2,
		"MEDIUM":               3,
		"HIGH":                 4,
		"CRITICAL":             5,
	}
)

func (x SeverityEnum) Enum() *SeverityEnum {
	p := new(SeverityEnum)
	*p = x
	return p
}

func (x SeverityEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SeverityEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_proto_scan_result_proto_enumTypes[1].Descriptor()
}

func (SeverityEnum) Type() protoreflect.EnumType {
	return &file_proto_scan_result_proto_enumTypes[1]
}

func (x SeverityEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SeverityEnum.Descriptor instead.
func (SeverityEnum) EnumDescriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{1}
}

type ScanStatus_ScanStatusEnum int32

const (
	ScanStatus_UNSPECIFIED         ScanStatus_ScanStatusEnum = 0
	ScanStatus_SUCCEEDED           ScanStatus_ScanStatusEnum = 1
	ScanStatus_PARTIALLY_SUCCEEDED ScanStatus_ScanStatusEnum = 2
	ScanStatus_FAILED              ScanStatus_ScanStatusEnum = 3
)

// Enum value maps for ScanStatus_ScanStatusEnum.
var (
	ScanStatus_ScanStatusEnum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "SUCCEEDED",
		2: "PARTIALLY_SUCCEEDED",
		3: "FAILED",
	}
	ScanStatus_ScanStatusEnum_value = map[string]int32{
		"UNSPECIFIED":         0,
		"SUCCEEDED":           1,
		"PARTIALLY_SUCCEEDED": 2,
		"FAILED":              3,
	}
)

func (x ScanStatus_ScanStatusEnum) Enum() *ScanStatus_ScanStatusEnum {
	p := new(ScanStatus_ScanStatusEnum)
	*p = x
	return p
}

func (x ScanStatus_ScanStatusEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScanStatus_ScanStatusEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_proto_scan_result_proto_enumTypes[2].Descriptor()
}

func (ScanStatus_ScanStatusEnum) Type() protoreflect.EnumType {
	return &file_proto_scan_result_proto_enumTypes[2]
}

func (x ScanStatus_ScanStatusEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ScanStatus_ScanStatusEnum.Descriptor instead.
func (ScanStatus_ScanStatusEnum) EnumDescriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{2, 0}
}

type Package_AnnotationEnum int32

const (
	Package_UNSPECIFIED       Package_AnnotationEnum = 0
	Package_TRANSITIONAL      Package_AnnotationEnum = 1
	Package_INSIDE_OS_PACKAGE Package_AnnotationEnum = 2
	Package_INSIDE_CACHE_DIR  Package_AnnotationEnum = 3
)

// Enum value maps for Package_AnnotationEnum.
var (
	Package_AnnotationEnum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "TRANSITIONAL",
		2: "INSIDE_OS_PACKAGE",
		3: "INSIDE_CACHE_DIR",
	}
	Package_AnnotationEnum_value = map[string]int32{
		"UNSPECIFIED":       0,
		"TRANSITIONAL":      1,
		"INSIDE_OS_PACKAGE": 2,
		"INSIDE_CACHE_DIR":  3,
	}
)

func (x Package_AnnotationEnum) Enum() *Package_AnnotationEnum {
	p := new(Package_AnnotationEnum)
	*p = x
	return p
}

func (x Package_AnnotationEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Package_AnnotationEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_proto_scan_result_proto_enumTypes[3].Descriptor()
}

func (Package_AnnotationEnum) Type() protoreflect.EnumType {
	return &file_proto_scan_result_proto_enumTypes[3]
}

func (x Package_AnnotationEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Package_AnnotationEnum.Descriptor instead.
func (Package_AnnotationEnum) EnumDescriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{4, 0}
}

type SecretStatus_SecretStatusEnum int32

const (
	// The default value for SecretStatusEnum. Set when no validation was
	// attempted.
	SecretStatus_UNSPECIFIED SecretStatus_SecretStatusEnum = 0
	// Deprecated. Use UNSPECIFIED instead.
	//
	// Deprecated: Marked as deprecated in proto/scan_result.proto.
	SecretStatus_UNKNOWN SecretStatus_SecretStatusEnum = 1
	// The secret is confirmed to be invalid.
	SecretStatus_INVALID SecretStatus_SecretStatusEnum = 2
	// The secret is confirmed to be valid.
	SecretStatus_VALID SecretStatus_SecretStatusEnum = 3
	// Validating the secret is not supported by the scanner.
	SecretStatus_UNSUPPORTED SecretStatus_SecretStatusEnum = 4
	// Validation is supported but the validation failed.
	SecretStatus_FAILED SecretStatus_SecretStatusEnum = 5
)

// Enum value maps for SecretStatus_SecretStatusEnum.
var (
	SecretStatus_SecretStatusEnum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "UNKNOWN",
		2: "INVALID",
		3: "VALID",
		4: "UNSUPPORTED",
		5: "FAILED",
	}
	SecretStatus_SecretStatusEnum_value = map[string]int32{
		"UNSPECIFIED": 0,
		"UNKNOWN":     1,
		"INVALID":     2,
		"VALID":       3,
		"UNSUPPORTED": 4,
		"FAILED":      5,
	}
)

func (x SecretStatus_SecretStatusEnum) Enum() *SecretStatus_SecretStatusEnum {
	p := new(SecretStatus_SecretStatusEnum)
	*p = x
	return p
}

func (x SecretStatus_SecretStatusEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecretStatus_SecretStatusEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_proto_scan_result_proto_enumTypes[4].Descriptor()
}

func (SecretStatus_SecretStatusEnum) Type() protoreflect.EnumType {
	return &file_proto_scan_result_proto_enumTypes[4]
}

func (x SecretStatus_SecretStatusEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecretStatus_SecretStatusEnum.Descriptor instead.
func (SecretStatus_SecretStatusEnum) EnumDescriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{51, 0}
}

// The results of a scan incl. scan status and artifacts found.
type ScanResult struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	Version   string                 `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	EndTime   *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Status of the overall scan.
	Status *ScanStatus `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	// Status and versions of the plugins that ran.
	PluginStatus []*PluginStatus `protobuf:"bytes,5,rep,name=plugin_status,json=pluginStatus,proto3" json:"plugin_status,omitempty"`
	// TODO(b/400910349): Remove once integrators stop using these fields.
	//
	// Deprecated: Marked as deprecated in proto/scan_result.proto.
	InventoriesDeprecated []*Package `protobuf:"bytes,6,rep,name=inventories_deprecated,json=inventoriesDeprecated,proto3" json:"inventories_deprecated,omitempty"`
	// Deprecated: Marked as deprecated in proto/scan_result.proto.
	FindingsDeprecated []*GenericFinding `protobuf:"bytes,7,rep,name=findings_deprecated,json=findingsDeprecated,proto3" json:"findings_deprecated,omitempty"`
	Inventory          *Inventory        `protobuf:"bytes,8,opt,name=inventory,proto3" json:"inventory,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ScanResult) Reset() {
	*x = ScanResult{}
	mi := &file_proto_scan_result_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScanResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScanResult) ProtoMessage() {}

func (x *ScanResult) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScanResult.ProtoReflect.Descriptor instead.
func (*ScanResult) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{0}
}

func (x *ScanResult) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ScanResult) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ScanResult) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ScanResult) GetStatus() *ScanStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ScanResult) GetPluginStatus() []*PluginStatus {
	if x != nil {
		return x.PluginStatus
	}
	return nil
}

// Deprecated: Marked as deprecated in proto/scan_result.proto.
func (x *ScanResult) GetInventoriesDeprecated() []*Package {
	if x != nil {
		return x.InventoriesDeprecated
	}
	return nil
}

// Deprecated: Marked as deprecated in proto/scan_result.proto.
func (x *ScanResult) GetFindingsDeprecated() []*GenericFinding {
	if x != nil {
		return x.FindingsDeprecated
	}
	return nil
}

func (x *ScanResult) GetInventory() *Inventory {
	if x != nil {
		return x.Inventory
	}
	return nil
}

// The artifacts (e.g. software inventory, security findings) that a scan found.
type Inventory struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Packages        []*Package             `protobuf:"bytes,1,rep,name=packages,proto3" json:"packages,omitempty"`
	GenericFindings []*GenericFinding      `protobuf:"bytes,2,rep,name=generic_findings,json=genericFindings,proto3" json:"generic_findings,omitempty"`
	Secrets         []*Secret              `protobuf:"bytes,3,rep,name=secrets,proto3" json:"secrets,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Inventory) Reset() {
	*x = Inventory{}
	mi := &file_proto_scan_result_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory) ProtoMessage() {}

func (x *Inventory) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory.ProtoReflect.Descriptor instead.
func (*Inventory) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{1}
}

func (x *Inventory) GetPackages() []*Package {
	if x != nil {
		return x.Packages
	}
	return nil
}

func (x *Inventory) GetGenericFindings() []*GenericFinding {
	if x != nil {
		return x.GenericFindings
	}
	return nil
}

func (x *Inventory) GetSecrets() []*Secret {
	if x != nil {
		return x.Secrets
	}
	return nil
}

type ScanStatus struct {
	state         protoimpl.MessageState    `protogen:"open.v1"`
	Status        ScanStatus_ScanStatusEnum `protobuf:"varint,1,opt,name=status,proto3,enum=scalibr.ScanStatus_ScanStatusEnum" json:"status,omitempty"`
	FailureReason string                    `protobuf:"bytes,2,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ScanStatus) Reset() {
	*x = ScanStatus{}
	mi := &file_proto_scan_result_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScanStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScanStatus) ProtoMessage() {}

func (x *ScanStatus) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScanStatus.ProtoReflect.Descriptor instead.
func (*ScanStatus) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{2}
}

func (x *ScanStatus) GetStatus() ScanStatus_ScanStatusEnum {
	if x != nil {
		return x.Status
	}
	return ScanStatus_UNSPECIFIED
}

func (x *ScanStatus) GetFailureReason() string {
	if x != nil {
		return x.FailureReason
	}
	return ""
}

type PluginStatus struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version       int32                  `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	Status        *ScanStatus            `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PluginStatus) Reset() {
	*x = PluginStatus{}
	mi := &file_proto_scan_result_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginStatus) ProtoMessage() {}

func (x *PluginStatus) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginStatus.ProtoReflect.Descriptor instead.
func (*PluginStatus) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{3}
}

func (x *PluginStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PluginStatus) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *PluginStatus) GetStatus() *ScanStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

// A software package or library found by an extractor.
// PURL or CPE needs to be set, maybe both.
type Package struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Human-readable name of the software, to be used for things like logging.
	// For vuln matching, use the name from metadata.
	Name string `protobuf:"bytes,11,opt,name=name,proto3" json:"name,omitempty"`
	// Version of the package.
	Version string `protobuf:"bytes,12,opt,name=version,proto3" json:"version,omitempty"`
	// Source code level package identifiers.
	SourceCode *SourceCodeIdentifier `protobuf:"bytes,26,opt,name=source_code,json=sourceCode,proto3" json:"source_code,omitempty"`
	// Package URL of the software.
	Purl *Purl `protobuf:"bytes,1,opt,name=purl,proto3" json:"purl,omitempty"`
	// Ecosystem - For software packages this corresponds to an OSV ecosystem
	// value, e.g. PyPI.
	Ecosystem string `protobuf:"bytes,27,opt,name=ecosystem,proto3" json:"ecosystem,omitempty"`
	// Paths or source of files related to the package.
	Locations []string `protobuf:"bytes,2,rep,name=locations,proto3" json:"locations,omitempty"`
	// TODO(b/400910349): Remove once integrators stop using these fields.
	//
	// Deprecated: Marked as deprecated in proto/scan_result.proto.
	ExtractorDeprecated string `protobuf:"bytes,10,opt,name=extractor_deprecated,json=extractorDeprecated,proto3" json:"extractor_deprecated,omitempty"`
	// The names of the plugins that found this software. Set by the
	// core library.
	Plugins []string `protobuf:"bytes,49,rep,name=plugins,proto3" json:"plugins,omitempty"`
	// The additional data found in the package.
	// LINT.IfChange
	//
	// Types that are valid to be assigned to Metadata:
	//
	//	*Package_PythonMetadata
	//	*Package_JavascriptMetadata
	//	*Package_ApkMetadata
	//	*Package_DpkgMetadata
	//	*Package_RpmMetadata
	//	*Package_CosMetadata
	//	*Package_DepsjsonMetadata
	//	*Package_SpdxMetadata
	//	*Package_JavaArchiveMetadata
	//	*Package_JavaLockfileMetadata
	//	*Package_PacmanMetadata
	//	*Package_NixMetadata
	//	*Package_KernelModuleMetadata
	//	*Package_VmlinuzMetadata
	//	*Package_PortageMetadata
	//	*Package_OsvMetadata
	//	*Package_NetportsMetadata
	//	*Package_PythonRequirementsMetadata
	//	*Package_PythonSetupMetadata
	//	*Package_ContainerdContainerMetadata
	//	*Package_SnapMetadata
	//	*Package_FlatpakMetadata
	//	*Package_MacAppsMetadata
	//	*Package_ContainerdRuntimeContainerMetadata
	//	*Package_CdxMetadata
	//	*Package_WindowsOsVersionMetadata
	//	*Package_HomebrewMetadata
	//	*Package_ChromeExtensionsMetadata
	//	*Package_VscodeExtensionsMetadata
	//	*Package_PodmanMetadata
	//	*Package_DockerContainersMetadata
	Metadata isPackage_Metadata `protobuf_oneof:"metadata"`
	// Deprecated - use exploitability_signals instead
	// TODO(b/400910349): Remove once integrators stop using this.
	//
	// Deprecated: Marked as deprecated in proto/scan_result.proto.
	AnnotationsDeprecated []Package_AnnotationEnum `protobuf:"varint,28,rep,packed,name=annotations_deprecated,json=annotationsDeprecated,proto3,enum=scalibr.Package_AnnotationEnum" json:"annotations_deprecated,omitempty"`
	// Signals to indicate that specific vulnerabilities are not applicable to
	// this package.
	ExploitabilitySignals []*PackageExploitabilitySignal `protobuf:"bytes,51,rep,name=exploitability_signals,json=exploitabilitySignals,proto3" json:"exploitability_signals,omitempty"`
	// Details about the layer a package was found in. This should be set only for
	// container image scanning.
	LayerDetails  *LayerDetails `protobuf:"bytes,35,opt,name=layer_details,json=layerDetails,proto3" json:"layer_details,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Package) Reset() {
	*x = Package{}
	mi := &file_proto_scan_result_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Package) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Package) ProtoMessage() {}

func (x *Package) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Package.ProtoReflect.Descriptor instead.
func (*Package) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{4}
}

func (x *Package) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Package) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Package) GetSourceCode() *SourceCodeIdentifier {
	if x != nil {
		return x.SourceCode
	}
	return nil
}

func (x *Package) GetPurl() *Purl {
	if x != nil {
		return x.Purl
	}
	return nil
}

func (x *Package) GetEcosystem() string {
	if x != nil {
		return x.Ecosystem
	}
	return ""
}

func (x *Package) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

// Deprecated: Marked as deprecated in proto/scan_result.proto.
func (x *Package) GetExtractorDeprecated() string {
	if x != nil {
		return x.ExtractorDeprecated
	}
	return ""
}

func (x *Package) GetPlugins() []string {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *Package) GetMetadata() isPackage_Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Package) GetPythonMetadata() *PythonPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_PythonMetadata); ok {
			return x.PythonMetadata
		}
	}
	return nil
}

func (x *Package) GetJavascriptMetadata() *JavascriptPackageJSONMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_JavascriptMetadata); ok {
			return x.JavascriptMetadata
		}
	}
	return nil
}

func (x *Package) GetApkMetadata() *APKPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_ApkMetadata); ok {
			return x.ApkMetadata
		}
	}
	return nil
}

func (x *Package) GetDpkgMetadata() *DPKGPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_DpkgMetadata); ok {
			return x.DpkgMetadata
		}
	}
	return nil
}

func (x *Package) GetRpmMetadata() *RPMPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_RpmMetadata); ok {
			return x.RpmMetadata
		}
	}
	return nil
}

func (x *Package) GetCosMetadata() *COSPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_CosMetadata); ok {
			return x.CosMetadata
		}
	}
	return nil
}

func (x *Package) GetDepsjsonMetadata() *DEPSJSONMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_DepsjsonMetadata); ok {
			return x.DepsjsonMetadata
		}
	}
	return nil
}

func (x *Package) GetSpdxMetadata() *SPDXPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_SpdxMetadata); ok {
			return x.SpdxMetadata
		}
	}
	return nil
}

func (x *Package) GetJavaArchiveMetadata() *JavaArchiveMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_JavaArchiveMetadata); ok {
			return x.JavaArchiveMetadata
		}
	}
	return nil
}

func (x *Package) GetJavaLockfileMetadata() *JavaLockfileMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_JavaLockfileMetadata); ok {
			return x.JavaLockfileMetadata
		}
	}
	return nil
}

func (x *Package) GetPacmanMetadata() *PACMANPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_PacmanMetadata); ok {
			return x.PacmanMetadata
		}
	}
	return nil
}

func (x *Package) GetNixMetadata() *NixPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_NixMetadata); ok {
			return x.NixMetadata
		}
	}
	return nil
}

func (x *Package) GetKernelModuleMetadata() *KernelModuleMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_KernelModuleMetadata); ok {
			return x.KernelModuleMetadata
		}
	}
	return nil
}

func (x *Package) GetVmlinuzMetadata() *VmlinuzMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_VmlinuzMetadata); ok {
			return x.VmlinuzMetadata
		}
	}
	return nil
}

func (x *Package) GetPortageMetadata() *PortagePackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_PortageMetadata); ok {
			return x.PortageMetadata
		}
	}
	return nil
}

func (x *Package) GetOsvMetadata() *OSVPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_OsvMetadata); ok {
			return x.OsvMetadata
		}
	}
	return nil
}

func (x *Package) GetNetportsMetadata() *NetportsMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_NetportsMetadata); ok {
			return x.NetportsMetadata
		}
	}
	return nil
}

func (x *Package) GetPythonRequirementsMetadata() *PythonRequirementsMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_PythonRequirementsMetadata); ok {
			return x.PythonRequirementsMetadata
		}
	}
	return nil
}

func (x *Package) GetPythonSetupMetadata() *PythonSetupMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_PythonSetupMetadata); ok {
			return x.PythonSetupMetadata
		}
	}
	return nil
}

func (x *Package) GetContainerdContainerMetadata() *ContainerdContainerMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_ContainerdContainerMetadata); ok {
			return x.ContainerdContainerMetadata
		}
	}
	return nil
}

func (x *Package) GetSnapMetadata() *SNAPPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_SnapMetadata); ok {
			return x.SnapMetadata
		}
	}
	return nil
}

func (x *Package) GetFlatpakMetadata() *FlatpakPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_FlatpakMetadata); ok {
			return x.FlatpakMetadata
		}
	}
	return nil
}

func (x *Package) GetMacAppsMetadata() *MacAppsMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_MacAppsMetadata); ok {
			return x.MacAppsMetadata
		}
	}
	return nil
}

func (x *Package) GetContainerdRuntimeContainerMetadata() *ContainerdRuntimeContainerMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_ContainerdRuntimeContainerMetadata); ok {
			return x.ContainerdRuntimeContainerMetadata
		}
	}
	return nil
}

func (x *Package) GetCdxMetadata() *CDXPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_CdxMetadata); ok {
			return x.CdxMetadata
		}
	}
	return nil
}

func (x *Package) GetWindowsOsVersionMetadata() *WindowsOSVersion {
	if x != nil {
		if x, ok := x.Metadata.(*Package_WindowsOsVersionMetadata); ok {
			return x.WindowsOsVersionMetadata
		}
	}
	return nil
}

func (x *Package) GetHomebrewMetadata() *HomebrewPackageMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_HomebrewMetadata); ok {
			return x.HomebrewMetadata
		}
	}
	return nil
}

func (x *Package) GetChromeExtensionsMetadata() *ChromeExtensionsMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_ChromeExtensionsMetadata); ok {
			return x.ChromeExtensionsMetadata
		}
	}
	return nil
}

func (x *Package) GetVscodeExtensionsMetadata() *VSCodeExtensionsMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_VscodeExtensionsMetadata); ok {
			return x.VscodeExtensionsMetadata
		}
	}
	return nil
}

func (x *Package) GetPodmanMetadata() *PodmanMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_PodmanMetadata); ok {
			return x.PodmanMetadata
		}
	}
	return nil
}

func (x *Package) GetDockerContainersMetadata() *DockerContainersMetadata {
	if x != nil {
		if x, ok := x.Metadata.(*Package_DockerContainersMetadata); ok {
			return x.DockerContainersMetadata
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in proto/scan_result.proto.
func (x *Package) GetAnnotationsDeprecated() []Package_AnnotationEnum {
	if x != nil {
		return x.AnnotationsDeprecated
	}
	return nil
}

func (x *Package) GetExploitabilitySignals() []*PackageExploitabilitySignal {
	if x != nil {
		return x.ExploitabilitySignals
	}
	return nil
}

func (x *Package) GetLayerDetails() *LayerDetails {
	if x != nil {
		return x.LayerDetails
	}
	return nil
}

type isPackage_Metadata interface {
	isPackage_Metadata()
}

type Package_PythonMetadata struct {
	PythonMetadata *PythonPackageMetadata `protobuf:"bytes,5,opt,name=python_metadata,json=pythonMetadata,proto3,oneof"`
}

type Package_JavascriptMetadata struct {
	JavascriptMetadata *JavascriptPackageJSONMetadata `protobuf:"bytes,6,opt,name=javascript_metadata,json=javascriptMetadata,proto3,oneof"`
}

type Package_ApkMetadata struct {
	ApkMetadata *APKPackageMetadata `protobuf:"bytes,7,opt,name=apk_metadata,json=apkMetadata,proto3,oneof"`
}

type Package_DpkgMetadata struct {
	DpkgMetadata *DPKGPackageMetadata `protobuf:"bytes,8,opt,name=dpkg_metadata,json=dpkgMetadata,proto3,oneof"`
}

type Package_RpmMetadata struct {
	RpmMetadata *RPMPackageMetadata `protobuf:"bytes,9,opt,name=rpm_metadata,json=rpmMetadata,proto3,oneof"`
}

type Package_CosMetadata struct {
	CosMetadata *COSPackageMetadata `protobuf:"bytes,13,opt,name=cos_metadata,json=cosMetadata,proto3,oneof"`
}

type Package_DepsjsonMetadata struct {
	DepsjsonMetadata *DEPSJSONMetadata `protobuf:"bytes,40,opt,name=depsjson_metadata,json=depsjsonMetadata,proto3,oneof"`
}

type Package_SpdxMetadata struct {
	SpdxMetadata *SPDXPackageMetadata `protobuf:"bytes,14,opt,name=spdx_metadata,json=spdxMetadata,proto3,oneof"`
}

type Package_JavaArchiveMetadata struct {
	JavaArchiveMetadata *JavaArchiveMetadata `protobuf:"bytes,15,opt,name=java_archive_metadata,json=javaArchiveMetadata,proto3,oneof"`
}

type Package_JavaLockfileMetadata struct {
	JavaLockfileMetadata *JavaLockfileMetadata `protobuf:"bytes,31,opt,name=java_lockfile_metadata,json=javaLockfileMetadata,proto3,oneof"`
}

type Package_PacmanMetadata struct {
	PacmanMetadata *PACMANPackageMetadata `protobuf:"bytes,36,opt,name=pacman_metadata,json=pacmanMetadata,proto3,oneof"`
}

type Package_NixMetadata struct {
	NixMetadata *NixPackageMetadata `protobuf:"bytes,37,opt,name=nix_metadata,json=nixMetadata,proto3,oneof"`
}

type Package_KernelModuleMetadata struct {
	KernelModuleMetadata *KernelModuleMetadata `protobuf:"bytes,38,opt,name=kernel_module_metadata,json=kernelModuleMetadata,proto3,oneof"`
}

type Package_VmlinuzMetadata struct {
	VmlinuzMetadata *VmlinuzMetadata `protobuf:"bytes,39,opt,name=vmlinuz_metadata,json=vmlinuzMetadata,proto3,oneof"`
}

type Package_PortageMetadata struct {
	PortageMetadata *PortagePackageMetadata `protobuf:"bytes,41,opt,name=portage_metadata,json=portageMetadata,proto3,oneof"`
}

type Package_OsvMetadata struct {
	OsvMetadata *OSVPackageMetadata `protobuf:"bytes,16,opt,name=osv_metadata,json=osvMetadata,proto3,oneof"`
}

type Package_NetportsMetadata struct {
	NetportsMetadata *NetportsMetadata `protobuf:"bytes,45,opt,name=netports_metadata,json=netportsMetadata,proto3,oneof"`
}

type Package_PythonRequirementsMetadata struct {
	PythonRequirementsMetadata *PythonRequirementsMetadata `protobuf:"bytes,21,opt,name=python_requirements_metadata,json=pythonRequirementsMetadata,proto3,oneof"`
}

type Package_PythonSetupMetadata struct {
	PythonSetupMetadata *PythonSetupMetadata `protobuf:"bytes,44,opt,name=python_setup_metadata,json=pythonSetupMetadata,proto3,oneof"`
}

type Package_ContainerdContainerMetadata struct {
	ContainerdContainerMetadata *ContainerdContainerMetadata `protobuf:"bytes,22,opt,name=containerd_container_metadata,json=containerdContainerMetadata,proto3,oneof"`
}

type Package_SnapMetadata struct {
	SnapMetadata *SNAPPackageMetadata `protobuf:"bytes,23,opt,name=snap_metadata,json=snapMetadata,proto3,oneof"`
}

type Package_FlatpakMetadata struct {
	FlatpakMetadata *FlatpakPackageMetadata `protobuf:"bytes,24,opt,name=flatpak_metadata,json=flatpakMetadata,proto3,oneof"`
}

type Package_MacAppsMetadata struct {
	MacAppsMetadata *MacAppsMetadata `protobuf:"bytes,34,opt,name=mac_apps_metadata,json=macAppsMetadata,proto3,oneof"`
}

type Package_ContainerdRuntimeContainerMetadata struct {
	ContainerdRuntimeContainerMetadata *ContainerdRuntimeContainerMetadata `protobuf:"bytes,25,opt,name=containerd_runtime_container_metadata,json=containerdRuntimeContainerMetadata,proto3,oneof"`
}

type Package_CdxMetadata struct {
	CdxMetadata *CDXPackageMetadata `protobuf:"bytes,30,opt,name=cdx_metadata,json=cdxMetadata,proto3,oneof"`
}

type Package_WindowsOsVersionMetadata struct {
	WindowsOsVersionMetadata *WindowsOSVersion `protobuf:"bytes,33,opt,name=windows_os_version_metadata,json=windowsOsVersionMetadata,proto3,oneof"`
}

type Package_HomebrewMetadata struct {
	HomebrewMetadata *HomebrewPackageMetadata `protobuf:"bytes,42,opt,name=homebrew_metadata,json=homebrewMetadata,proto3,oneof"`
}

type Package_ChromeExtensionsMetadata struct {
	ChromeExtensionsMetadata *ChromeExtensionsMetadata `protobuf:"bytes,47,opt,name=chrome_extensions_metadata,json=chromeExtensionsMetadata,proto3,oneof"`
}

type Package_VscodeExtensionsMetadata struct {
	VscodeExtensionsMetadata *VSCodeExtensionsMetadata `protobuf:"bytes,46,opt,name=vscode_extensions_metadata,json=vscodeExtensionsMetadata,proto3,oneof"`
}

type Package_PodmanMetadata struct {
	PodmanMetadata *PodmanMetadata `protobuf:"bytes,50,opt,name=podman_metadata,json=podmanMetadata,proto3,oneof"`
}

type Package_DockerContainersMetadata struct {
	DockerContainersMetadata *DockerContainersMetadata `protobuf:"bytes,48,opt,name=docker_containers_metadata,json=dockerContainersMetadata,proto3,oneof"`
}

func (*Package_PythonMetadata) isPackage_Metadata() {}

func (*Package_JavascriptMetadata) isPackage_Metadata() {}

func (*Package_ApkMetadata) isPackage_Metadata() {}

func (*Package_DpkgMetadata) isPackage_Metadata() {}

func (*Package_RpmMetadata) isPackage_Metadata() {}

func (*Package_CosMetadata) isPackage_Metadata() {}

func (*Package_DepsjsonMetadata) isPackage_Metadata() {}

func (*Package_SpdxMetadata) isPackage_Metadata() {}

func (*Package_JavaArchiveMetadata) isPackage_Metadata() {}

func (*Package_JavaLockfileMetadata) isPackage_Metadata() {}

func (*Package_PacmanMetadata) isPackage_Metadata() {}

func (*Package_NixMetadata) isPackage_Metadata() {}

func (*Package_KernelModuleMetadata) isPackage_Metadata() {}

func (*Package_VmlinuzMetadata) isPackage_Metadata() {}

func (*Package_PortageMetadata) isPackage_Metadata() {}

func (*Package_OsvMetadata) isPackage_Metadata() {}

func (*Package_NetportsMetadata) isPackage_Metadata() {}

func (*Package_PythonRequirementsMetadata) isPackage_Metadata() {}

func (*Package_PythonSetupMetadata) isPackage_Metadata() {}

func (*Package_ContainerdContainerMetadata) isPackage_Metadata() {}

func (*Package_SnapMetadata) isPackage_Metadata() {}

func (*Package_FlatpakMetadata) isPackage_Metadata() {}

func (*Package_MacAppsMetadata) isPackage_Metadata() {}

func (*Package_ContainerdRuntimeContainerMetadata) isPackage_Metadata() {}

func (*Package_CdxMetadata) isPackage_Metadata() {}

func (*Package_WindowsOsVersionMetadata) isPackage_Metadata() {}

func (*Package_HomebrewMetadata) isPackage_Metadata() {}

func (*Package_ChromeExtensionsMetadata) isPackage_Metadata() {}

func (*Package_VscodeExtensionsMetadata) isPackage_Metadata() {}

func (*Package_PodmanMetadata) isPackage_Metadata() {}

func (*Package_DockerContainersMetadata) isPackage_Metadata() {}

// Additional identifiers for source code software packages (e.g. NPM).
type SourceCodeIdentifier struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Repo          string                 `protobuf:"bytes,1,opt,name=repo,proto3" json:"repo,omitempty"`
	Commit        string                 `protobuf:"bytes,2,opt,name=commit,proto3" json:"commit,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SourceCodeIdentifier) Reset() {
	*x = SourceCodeIdentifier{}
	mi := &file_proto_scan_result_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SourceCodeIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceCodeIdentifier) ProtoMessage() {}

func (x *SourceCodeIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceCodeIdentifier.ProtoReflect.Descriptor instead.
func (*SourceCodeIdentifier) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{5}
}

func (x *SourceCodeIdentifier) GetRepo() string {
	if x != nil {
		return x.Repo
	}
	return ""
}

func (x *SourceCodeIdentifier) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

// Details about the layer a package was found in.
type LayerDetails struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The index of the layer in the container image.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// The diff ID (typically a sha256 hash) of the layer in the container image.
	DiffId string `protobuf:"bytes,2,opt,name=diff_id,json=diffId,proto3" json:"diff_id,omitempty"`
	// The layer chain ID (sha256 hash) of the layer in the container image.
	// https://github.com/opencontainers/image-spec/blob/main/config.md#layer-chainid
	ChainId string `protobuf:"bytes,5,opt,name=chain_id,json=chainId,proto3" json:"chain_id,omitempty"`
	// The layer build command that was used to build the layer. This may not be
	// found in all layers depending on how the container image is built.
	Command string `protobuf:"bytes,3,opt,name=command,proto3" json:"command,omitempty"`
	// Denotes whether the layer is in the base image.
	InBaseImage   bool `protobuf:"varint,4,opt,name=in_base_image,json=inBaseImage,proto3" json:"in_base_image,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LayerDetails) Reset() {
	*x = LayerDetails{}
	mi := &file_proto_scan_result_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LayerDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LayerDetails) ProtoMessage() {}

func (x *LayerDetails) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LayerDetails.ProtoReflect.Descriptor instead.
func (*LayerDetails) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{6}
}

func (x *LayerDetails) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *LayerDetails) GetDiffId() string {
	if x != nil {
		return x.DiffId
	}
	return ""
}

func (x *LayerDetails) GetChainId() string {
	if x != nil {
		return x.ChainId
	}
	return ""
}

func (x *LayerDetails) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *LayerDetails) GetInBaseImage() bool {
	if x != nil {
		return x.InBaseImage
	}
	return false
}

// PackageExploitabilitySignal is used to indicate that specific vulnerabilities
// are not applicable to a given package.
type PackageExploitabilitySignal struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the plugin (e.g. Annotator) that added this signal.
	Plugin string `protobuf:"bytes,1,opt,name=plugin,proto3" json:"plugin,omitempty"`
	// Reason for exclusion.
	Justification VexJustification `protobuf:"varint,2,opt,name=justification,proto3,enum=scalibr.VexJustification" json:"justification,omitempty"`
	// Types that are valid to be assigned to VulnFilter:
	//
	//	*PackageExploitabilitySignal_VulnIdentifiers
	//	*PackageExploitabilitySignal_MatchesAllVulns
	VulnFilter    isPackageExploitabilitySignal_VulnFilter `protobuf_oneof:"vuln_filter"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PackageExploitabilitySignal) Reset() {
	*x = PackageExploitabilitySignal{}
	mi := &file_proto_scan_result_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PackageExploitabilitySignal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageExploitabilitySignal) ProtoMessage() {}

func (x *PackageExploitabilitySignal) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageExploitabilitySignal.ProtoReflect.Descriptor instead.
func (*PackageExploitabilitySignal) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{7}
}

func (x *PackageExploitabilitySignal) GetPlugin() string {
	if x != nil {
		return x.Plugin
	}
	return ""
}

func (x *PackageExploitabilitySignal) GetJustification() VexJustification {
	if x != nil {
		return x.Justification
	}
	return VexJustification_VEX_JUSTIFICATION_UNSPECIFIED
}

func (x *PackageExploitabilitySignal) GetVulnFilter() isPackageExploitabilitySignal_VulnFilter {
	if x != nil {
		return x.VulnFilter
	}
	return nil
}

func (x *PackageExploitabilitySignal) GetVulnIdentifiers() *VulnIdentifiers {
	if x != nil {
		if x, ok := x.VulnFilter.(*PackageExploitabilitySignal_VulnIdentifiers); ok {
			return x.VulnIdentifiers
		}
	}
	return nil
}

func (x *PackageExploitabilitySignal) GetMatchesAllVulns() bool {
	if x != nil {
		if x, ok := x.VulnFilter.(*PackageExploitabilitySignal_MatchesAllVulns); ok {
			return x.MatchesAllVulns
		}
	}
	return false
}

type isPackageExploitabilitySignal_VulnFilter interface {
	isPackageExploitabilitySignal_VulnFilter()
}

type PackageExploitabilitySignal_VulnIdentifiers struct {
	// Advisory Identifier (CVE, GHSA, ...) and aliases of the vulns that are
	// not applicable to this package.
	VulnIdentifiers *VulnIdentifiers `protobuf:"bytes,3,opt,name=vuln_identifiers,json=vulnIdentifiers,proto3,oneof"`
}

type PackageExploitabilitySignal_MatchesAllVulns struct {
	// Indicates that all vulnerabilities associated with the package are
	// irrelevant.
	MatchesAllVulns bool `protobuf:"varint,4,opt,name=matches_all_vulns,json=matchesAllVulns,proto3,oneof"`
}

func (*PackageExploitabilitySignal_VulnIdentifiers) isPackageExploitabilitySignal_VulnFilter() {}

func (*PackageExploitabilitySignal_MatchesAllVulns) isPackageExploitabilitySignal_VulnFilter() {}

type VulnIdentifiers struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Identifiers   []string               `protobuf:"bytes,1,rep,name=identifiers,proto3" json:"identifiers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VulnIdentifiers) Reset() {
	*x = VulnIdentifiers{}
	mi := &file_proto_scan_result_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VulnIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnIdentifiers) ProtoMessage() {}

func (x *VulnIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnIdentifiers.ProtoReflect.Descriptor instead.
func (*VulnIdentifiers) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{8}
}

func (x *VulnIdentifiers) GetIdentifiers() []string {
	if x != nil {
		return x.Identifiers
	}
	return nil
}

// FindingExploitabilitySignal is used to indicate that a finding is not
// exploitable.
type FindingExploitabilitySignal struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the plugin (e.g. Annotator) that added this signal.
	Plugin string `protobuf:"bytes,1,opt,name=plugin,proto3" json:"plugin,omitempty"`
	// Reason for exclusion.
	Justification VexJustification `protobuf:"varint,2,opt,name=justification,proto3,enum=scalibr.VexJustification" json:"justification,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FindingExploitabilitySignal) Reset() {
	*x = FindingExploitabilitySignal{}
	mi := &file_proto_scan_result_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindingExploitabilitySignal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindingExploitabilitySignal) ProtoMessage() {}

func (x *FindingExploitabilitySignal) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindingExploitabilitySignal.ProtoReflect.Descriptor instead.
func (*FindingExploitabilitySignal) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{9}
}

func (x *FindingExploitabilitySignal) GetPlugin() string {
	if x != nil {
		return x.Plugin
	}
	return ""
}

func (x *FindingExploitabilitySignal) GetJustification() VexJustification {
	if x != nil {
		return x.Justification
	}
	return VexJustification_VEX_JUSTIFICATION_UNSPECIFIED
}

// Package URL, see https://github.com/package-url/purl-spec
type Purl struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// String representation.
	Purl string `protobuf:"bytes,1,opt,name=purl,proto3" json:"purl,omitempty"`
	// Package type, e.g. "maven, npm, pypi".
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Package name.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Package version.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Name prefix such as a Maven groupid, or Docker image owner.
	Namespace string `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Extra qualifying data for a package such as an OS, architecture, etc.
	Qualifiers []*Qualifier `protobuf:"bytes,6,rep,name=qualifiers,proto3" json:"qualifiers,omitempty"`
	// Extra subpath within a package, relative to the package root.
	Subpath       string `protobuf:"bytes,7,opt,name=subpath,proto3" json:"subpath,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Purl) Reset() {
	*x = Purl{}
	mi := &file_proto_scan_result_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Purl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Purl) ProtoMessage() {}

func (x *Purl) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Purl.ProtoReflect.Descriptor instead.
func (*Purl) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{10}
}

func (x *Purl) GetPurl() string {
	if x != nil {
		return x.Purl
	}
	return ""
}

func (x *Purl) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Purl) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Purl) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Purl) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Purl) GetQualifiers() []*Qualifier {
	if x != nil {
		return x.Qualifiers
	}
	return nil
}

func (x *Purl) GetSubpath() string {
	if x != nil {
		return x.Subpath
	}
	return ""
}

type Qualifier struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value         string                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Qualifier) Reset() {
	*x = Qualifier{}
	mi := &file_proto_scan_result_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Qualifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Qualifier) ProtoMessage() {}

func (x *Qualifier) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Qualifier.ProtoReflect.Descriptor instead.
func (*Qualifier) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{11}
}

func (x *Qualifier) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Qualifier) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Describes generic security findings not associated with any
// specific package, e.g. weak credentials.
type GenericFinding struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Info specific to the finding. Should always be the same for the same type
	// of finding.
	Adv *GenericFindingAdvisory `protobuf:"bytes,1,opt,name=adv,proto3" json:"adv,omitempty"`
	// Instance-specific info such as location of the vulnerable files.
	Target *GenericFindingTargetDetails `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	// The plugins (e.g. Detectors, Enrichers) that found this vuln.
	Plugins []string `protobuf:"bytes,4,rep,name=plugins,proto3" json:"plugins,omitempty"`
	// Signals that indicate this finding is not exploitable.
	ExploitabilitySignals []*FindingExploitabilitySignal `protobuf:"bytes,5,rep,name=exploitability_signals,json=exploitabilitySignals,proto3" json:"exploitability_signals,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GenericFinding) Reset() {
	*x = GenericFinding{}
	mi := &file_proto_scan_result_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenericFinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenericFinding) ProtoMessage() {}

func (x *GenericFinding) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenericFinding.ProtoReflect.Descriptor instead.
func (*GenericFinding) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{12}
}

func (x *GenericFinding) GetAdv() *GenericFindingAdvisory {
	if x != nil {
		return x.Adv
	}
	return nil
}

func (x *GenericFinding) GetTarget() *GenericFindingTargetDetails {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *GenericFinding) GetPlugins() []string {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *GenericFinding) GetExploitabilitySignals() []*FindingExploitabilitySignal {
	if x != nil {
		return x.ExploitabilitySignals
	}
	return nil
}

// Describes a security finding and how to remediate it. It should not
// contain any information specific to the target (e.g. which files were
// found vulnerable).
type GenericFindingAdvisory struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A unique ID for the finding.
	Id          *AdvisoryId `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Title       string      `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	Description string      `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Remediation instructions, e.g. "update to latest version".
	Recommendation string       `protobuf:"bytes,5,opt,name=recommendation,proto3" json:"recommendation,omitempty"`
	Sev            SeverityEnum `protobuf:"varint,7,opt,name=sev,proto3,enum=scalibr.SeverityEnum" json:"sev,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GenericFindingAdvisory) Reset() {
	*x = GenericFindingAdvisory{}
	mi := &file_proto_scan_result_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenericFindingAdvisory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenericFindingAdvisory) ProtoMessage() {}

func (x *GenericFindingAdvisory) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenericFindingAdvisory.ProtoReflect.Descriptor instead.
func (*GenericFindingAdvisory) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{13}
}

func (x *GenericFindingAdvisory) GetId() *AdvisoryId {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *GenericFindingAdvisory) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *GenericFindingAdvisory) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *GenericFindingAdvisory) GetRecommendation() string {
	if x != nil {
		return x.Recommendation
	}
	return ""
}

func (x *GenericFindingAdvisory) GetSev() SeverityEnum {
	if x != nil {
		return x.Sev
	}
	return SeverityEnum_SEVERITY_UNSPECIFIED
}

// A unique identifier per advisory.
type AdvisoryId struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Publisher     string                 `protobuf:"bytes,1,opt,name=publisher,proto3" json:"publisher,omitempty"` // e.g. "CVE".
	Reference     string                 `protobuf:"bytes,2,opt,name=reference,proto3" json:"reference,omitempty"` // e.g. "CVE-2023-1234".
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AdvisoryId) Reset() {
	*x = AdvisoryId{}
	mi := &file_proto_scan_result_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvisoryId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvisoryId) ProtoMessage() {}

func (x *AdvisoryId) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvisoryId.ProtoReflect.Descriptor instead.
func (*AdvisoryId) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{14}
}

func (x *AdvisoryId) GetPublisher() string {
	if x != nil {
		return x.Publisher
	}
	return ""
}

func (x *AdvisoryId) GetReference() string {
	if x != nil {
		return x.Reference
	}
	return ""
}

// Instance-specific details about the generic security finding.
type GenericFindingTargetDetails struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Free-text info.
	Extra         string `protobuf:"bytes,4,opt,name=extra,proto3" json:"extra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenericFindingTargetDetails) Reset() {
	*x = GenericFindingTargetDetails{}
	mi := &file_proto_scan_result_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenericFindingTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenericFindingTargetDetails) ProtoMessage() {}

func (x *GenericFindingTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenericFindingTargetDetails.ProtoReflect.Descriptor instead.
func (*GenericFindingTargetDetails) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{15}
}

func (x *GenericFindingTargetDetails) GetExtra() string {
	if x != nil {
		return x.Extra
	}
	return ""
}

// The additional data found in python packages.
type PythonPackageMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Author        string                 `protobuf:"bytes,1,opt,name=author,proto3" json:"author,omitempty"`
	AuthorEmail   string                 `protobuf:"bytes,2,opt,name=author_email,json=authorEmail,proto3" json:"author_email,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PythonPackageMetadata) Reset() {
	*x = PythonPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PythonPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PythonPackageMetadata) ProtoMessage() {}

func (x *PythonPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PythonPackageMetadata.ProtoReflect.Descriptor instead.
func (*PythonPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{16}
}

func (x *PythonPackageMetadata) GetAuthor() string {
	if x != nil {
		return x.Author
	}
	return ""
}

func (x *PythonPackageMetadata) GetAuthorEmail() string {
	if x != nil {
		return x.AuthorEmail
	}
	return ""
}

// The additional data found in npm packages.
type JavascriptPackageJSONMetadata struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	Author            string                 `protobuf:"bytes,1,opt,name=author,proto3" json:"author,omitempty"`
	Maintainers       []string               `protobuf:"bytes,2,rep,name=maintainers,proto3" json:"maintainers,omitempty"`
	Contributors      []string               `protobuf:"bytes,3,rep,name=contributors,proto3" json:"contributors,omitempty"`
	FromNpmRepository bool                   `protobuf:"varint,4,opt,name=from_npm_repository,json=fromNpmRepository,proto3" json:"from_npm_repository,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *JavascriptPackageJSONMetadata) Reset() {
	*x = JavascriptPackageJSONMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JavascriptPackageJSONMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JavascriptPackageJSONMetadata) ProtoMessage() {}

func (x *JavascriptPackageJSONMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JavascriptPackageJSONMetadata.ProtoReflect.Descriptor instead.
func (*JavascriptPackageJSONMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{17}
}

func (x *JavascriptPackageJSONMetadata) GetAuthor() string {
	if x != nil {
		return x.Author
	}
	return ""
}

func (x *JavascriptPackageJSONMetadata) GetMaintainers() []string {
	if x != nil {
		return x.Maintainers
	}
	return nil
}

func (x *JavascriptPackageJSONMetadata) GetContributors() []string {
	if x != nil {
		return x.Contributors
	}
	return nil
}

func (x *JavascriptPackageJSONMetadata) GetFromNpmRepository() bool {
	if x != nil {
		return x.FromNpmRepository
	}
	return false
}

// The additional data found in APK packages.
type APKPackageMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PackageName   string                 `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	OriginName    string                 `protobuf:"bytes,2,opt,name=origin_name,json=originName,proto3" json:"origin_name,omitempty"`
	OsId          string                 `protobuf:"bytes,3,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionId   string                 `protobuf:"bytes,4,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	Maintainer    string                 `protobuf:"bytes,5,opt,name=maintainer,proto3" json:"maintainer,omitempty"`
	Architecture  string                 `protobuf:"bytes,6,opt,name=architecture,proto3" json:"architecture,omitempty"`
	License       string                 `protobuf:"bytes,7,opt,name=license,proto3" json:"license,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *APKPackageMetadata) Reset() {
	*x = APKPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *APKPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APKPackageMetadata) ProtoMessage() {}

func (x *APKPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APKPackageMetadata.ProtoReflect.Descriptor instead.
func (*APKPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{18}
}

func (x *APKPackageMetadata) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *APKPackageMetadata) GetOriginName() string {
	if x != nil {
		return x.OriginName
	}
	return ""
}

func (x *APKPackageMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *APKPackageMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

func (x *APKPackageMetadata) GetMaintainer() string {
	if x != nil {
		return x.Maintainer
	}
	return ""
}

func (x *APKPackageMetadata) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *APKPackageMetadata) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

// The additional data found in DPKG packages.
// Next ID: 11
type DPKGPackageMetadata struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	PackageName       string                 `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	SourceName        string                 `protobuf:"bytes,2,opt,name=source_name,json=sourceName,proto3" json:"source_name,omitempty"`
	SourceVersion     string                 `protobuf:"bytes,3,opt,name=source_version,json=sourceVersion,proto3" json:"source_version,omitempty"`
	PackageVersion    string                 `protobuf:"bytes,4,opt,name=package_version,json=packageVersion,proto3" json:"package_version,omitempty"`
	OsId              string                 `protobuf:"bytes,5,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionCodename string                 `protobuf:"bytes,6,opt,name=os_version_codename,json=osVersionCodename,proto3" json:"os_version_codename,omitempty"`
	OsVersionId       string                 `protobuf:"bytes,7,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	Maintainer        string                 `protobuf:"bytes,8,opt,name=maintainer,proto3" json:"maintainer,omitempty"`
	Architecture      string                 `protobuf:"bytes,9,opt,name=architecture,proto3" json:"architecture,omitempty"`
	Status            string                 `protobuf:"bytes,10,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *DPKGPackageMetadata) Reset() {
	*x = DPKGPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DPKGPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DPKGPackageMetadata) ProtoMessage() {}

func (x *DPKGPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DPKGPackageMetadata.ProtoReflect.Descriptor instead.
func (*DPKGPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{19}
}

func (x *DPKGPackageMetadata) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *DPKGPackageMetadata) GetSourceName() string {
	if x != nil {
		return x.SourceName
	}
	return ""
}

func (x *DPKGPackageMetadata) GetSourceVersion() string {
	if x != nil {
		return x.SourceVersion
	}
	return ""
}

func (x *DPKGPackageMetadata) GetPackageVersion() string {
	if x != nil {
		return x.PackageVersion
	}
	return ""
}

func (x *DPKGPackageMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *DPKGPackageMetadata) GetOsVersionCodename() string {
	if x != nil {
		return x.OsVersionCodename
	}
	return ""
}

func (x *DPKGPackageMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

func (x *DPKGPackageMetadata) GetMaintainer() string {
	if x != nil {
		return x.Maintainer
	}
	return ""
}

func (x *DPKGPackageMetadata) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *DPKGPackageMetadata) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

// The additional data found in RPM packages.
type RPMPackageMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PackageName   string                 `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	SourceRpm     string                 `protobuf:"bytes,2,opt,name=source_rpm,json=sourceRpm,proto3" json:"source_rpm,omitempty"`
	Epoch         int32                  `protobuf:"varint,3,opt,name=epoch,proto3" json:"epoch,omitempty"`
	OsId          string                 `protobuf:"bytes,4,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionId   string                 `protobuf:"bytes,5,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	OsBuildId     string                 `protobuf:"bytes,6,opt,name=os_build_id,json=osBuildId,proto3" json:"os_build_id,omitempty"`
	OsName        string                 `protobuf:"bytes,7,opt,name=os_name,json=osName,proto3" json:"os_name,omitempty"`
	Vendor        string                 `protobuf:"bytes,8,opt,name=vendor,proto3" json:"vendor,omitempty"`
	Architecture  string                 `protobuf:"bytes,9,opt,name=architecture,proto3" json:"architecture,omitempty"`
	License       string                 `protobuf:"bytes,10,opt,name=license,proto3" json:"license,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RPMPackageMetadata) Reset() {
	*x = RPMPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RPMPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RPMPackageMetadata) ProtoMessage() {}

func (x *RPMPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RPMPackageMetadata.ProtoReflect.Descriptor instead.
func (*RPMPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{20}
}

func (x *RPMPackageMetadata) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *RPMPackageMetadata) GetSourceRpm() string {
	if x != nil {
		return x.SourceRpm
	}
	return ""
}

func (x *RPMPackageMetadata) GetEpoch() int32 {
	if x != nil {
		return x.Epoch
	}
	return 0
}

func (x *RPMPackageMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *RPMPackageMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

func (x *RPMPackageMetadata) GetOsBuildId() string {
	if x != nil {
		return x.OsBuildId
	}
	return ""
}

func (x *RPMPackageMetadata) GetOsName() string {
	if x != nil {
		return x.OsName
	}
	return ""
}

func (x *RPMPackageMetadata) GetVendor() string {
	if x != nil {
		return x.Vendor
	}
	return ""
}

func (x *RPMPackageMetadata) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *RPMPackageMetadata) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

// The additional data found in COS packages.
type COSPackageMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version       string                 `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Category      string                 `protobuf:"bytes,3,opt,name=category,proto3" json:"category,omitempty"`
	OsVersion     string                 `protobuf:"bytes,4,opt,name=os_version,json=osVersion,proto3" json:"os_version,omitempty"`
	OsVersionId   string                 `protobuf:"bytes,5,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	EbuildVersion string                 `protobuf:"bytes,6,opt,name=ebuild_version,json=ebuildVersion,proto3" json:"ebuild_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *COSPackageMetadata) Reset() {
	*x = COSPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *COSPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*COSPackageMetadata) ProtoMessage() {}

func (x *COSPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use COSPackageMetadata.ProtoReflect.Descriptor instead.
func (*COSPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{21}
}

func (x *COSPackageMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *COSPackageMetadata) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *COSPackageMetadata) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *COSPackageMetadata) GetOsVersion() string {
	if x != nil {
		return x.OsVersion
	}
	return ""
}

func (x *COSPackageMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

func (x *COSPackageMetadata) GetEbuildVersion() string {
	if x != nil {
		return x.EbuildVersion
	}
	return ""
}

// The additional data found in PACMAN packages.
type PACMANPackageMetadata struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	PackageName         string                 `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	PackageVersion      string                 `protobuf:"bytes,2,opt,name=package_version,json=packageVersion,proto3" json:"package_version,omitempty"`
	OsId                string                 `protobuf:"bytes,3,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionId         string                 `protobuf:"bytes,4,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	PackageDescription  string                 `protobuf:"bytes,5,opt,name=package_description,json=packageDescription,proto3" json:"package_description,omitempty"`
	PackageDependencies string                 `protobuf:"bytes,6,opt,name=package_dependencies,json=packageDependencies,proto3" json:"package_dependencies,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *PACMANPackageMetadata) Reset() {
	*x = PACMANPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PACMANPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PACMANPackageMetadata) ProtoMessage() {}

func (x *PACMANPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PACMANPackageMetadata.ProtoReflect.Descriptor instead.
func (*PACMANPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{22}
}

func (x *PACMANPackageMetadata) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *PACMANPackageMetadata) GetPackageVersion() string {
	if x != nil {
		return x.PackageVersion
	}
	return ""
}

func (x *PACMANPackageMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *PACMANPackageMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

func (x *PACMANPackageMetadata) GetPackageDescription() string {
	if x != nil {
		return x.PackageDescription
	}
	return ""
}

func (x *PACMANPackageMetadata) GetPackageDependencies() string {
	if x != nil {
		return x.PackageDependencies
	}
	return ""
}

// The additional data found in Nix packages.
type NixPackageMetadata struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	PackageName       string                 `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	PackageVersion    string                 `protobuf:"bytes,2,opt,name=package_version,json=packageVersion,proto3" json:"package_version,omitempty"`
	PackageHash       string                 `protobuf:"bytes,3,opt,name=package_hash,json=packageHash,proto3" json:"package_hash,omitempty"`
	PackageOutput     string                 `protobuf:"bytes,4,opt,name=package_output,json=packageOutput,proto3" json:"package_output,omitempty"`
	OsId              string                 `protobuf:"bytes,5,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionCodename string                 `protobuf:"bytes,6,opt,name=os_version_codename,json=osVersionCodename,proto3" json:"os_version_codename,omitempty"`
	OsVersionId       string                 `protobuf:"bytes,7,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *NixPackageMetadata) Reset() {
	*x = NixPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NixPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NixPackageMetadata) ProtoMessage() {}

func (x *NixPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NixPackageMetadata.ProtoReflect.Descriptor instead.
func (*NixPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{23}
}

func (x *NixPackageMetadata) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *NixPackageMetadata) GetPackageVersion() string {
	if x != nil {
		return x.PackageVersion
	}
	return ""
}

func (x *NixPackageMetadata) GetPackageHash() string {
	if x != nil {
		return x.PackageHash
	}
	return ""
}

func (x *NixPackageMetadata) GetPackageOutput() string {
	if x != nil {
		return x.PackageOutput
	}
	return ""
}

func (x *NixPackageMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *NixPackageMetadata) GetOsVersionCodename() string {
	if x != nil {
		return x.OsVersionCodename
	}
	return ""
}

func (x *NixPackageMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

// The additional data found in .NET deps json packages.
type DEPSJSONMetadata struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	PackageName    string                 `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	PackageVersion string                 `protobuf:"bytes,2,opt,name=package_version,json=packageVersion,proto3" json:"package_version,omitempty"`
	Type           string                 `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *DEPSJSONMetadata) Reset() {
	*x = DEPSJSONMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DEPSJSONMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DEPSJSONMetadata) ProtoMessage() {}

func (x *DEPSJSONMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DEPSJSONMetadata.ProtoReflect.Descriptor instead.
func (*DEPSJSONMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{24}
}

func (x *DEPSJSONMetadata) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *DEPSJSONMetadata) GetPackageVersion() string {
	if x != nil {
		return x.PackageVersion
	}
	return ""
}

func (x *DEPSJSONMetadata) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// The additional data found in SNAP packages.
type SNAPPackageMetadata struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	Name              string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version           string                 `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Grade             string                 `protobuf:"bytes,3,opt,name=grade,proto3" json:"grade,omitempty"`
	Type              string                 `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	Architectures     []string               `protobuf:"bytes,5,rep,name=architectures,proto3" json:"architectures,omitempty"`
	OsId              string                 `protobuf:"bytes,6,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionCodename string                 `protobuf:"bytes,7,opt,name=os_version_codename,json=osVersionCodename,proto3" json:"os_version_codename,omitempty"`
	OsVersionId       string                 `protobuf:"bytes,8,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *SNAPPackageMetadata) Reset() {
	*x = SNAPPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SNAPPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SNAPPackageMetadata) ProtoMessage() {}

func (x *SNAPPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SNAPPackageMetadata.ProtoReflect.Descriptor instead.
func (*SNAPPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{25}
}

func (x *SNAPPackageMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SNAPPackageMetadata) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SNAPPackageMetadata) GetGrade() string {
	if x != nil {
		return x.Grade
	}
	return ""
}

func (x *SNAPPackageMetadata) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *SNAPPackageMetadata) GetArchitectures() []string {
	if x != nil {
		return x.Architectures
	}
	return nil
}

func (x *SNAPPackageMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *SNAPPackageMetadata) GetOsVersionCodename() string {
	if x != nil {
		return x.OsVersionCodename
	}
	return ""
}

func (x *SNAPPackageMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

// The additional data found in portage packages.
type PortagePackageMetadata struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	PackageName    string                 `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	PackageVersion string                 `protobuf:"bytes,2,opt,name=package_version,json=packageVersion,proto3" json:"package_version,omitempty"`
	OsId           string                 `protobuf:"bytes,3,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionId    string                 `protobuf:"bytes,4,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *PortagePackageMetadata) Reset() {
	*x = PortagePackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortagePackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortagePackageMetadata) ProtoMessage() {}

func (x *PortagePackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortagePackageMetadata.ProtoReflect.Descriptor instead.
func (*PortagePackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{26}
}

func (x *PortagePackageMetadata) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *PortagePackageMetadata) GetPackageVersion() string {
	if x != nil {
		return x.PackageVersion
	}
	return ""
}

func (x *PortagePackageMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *PortagePackageMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

// The additional data found in Flatpak packages.
type FlatpakPackageMetadata struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	PackageName    string                 `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	PackageId      string                 `protobuf:"bytes,2,opt,name=package_id,json=packageId,proto3" json:"package_id,omitempty"`
	PackageVersion string                 `protobuf:"bytes,3,opt,name=package_version,json=packageVersion,proto3" json:"package_version,omitempty"`
	ReleaseDate    string                 `protobuf:"bytes,4,opt,name=release_date,json=releaseDate,proto3" json:"release_date,omitempty"`
	OsName         string                 `protobuf:"bytes,5,opt,name=os_name,json=osName,proto3" json:"os_name,omitempty"`
	OsId           string                 `protobuf:"bytes,6,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionId    string                 `protobuf:"bytes,7,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	OsBuildId      string                 `protobuf:"bytes,8,opt,name=os_build_id,json=osBuildId,proto3" json:"os_build_id,omitempty"`
	Developer      string                 `protobuf:"bytes,9,opt,name=developer,proto3" json:"developer,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *FlatpakPackageMetadata) Reset() {
	*x = FlatpakPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlatpakPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlatpakPackageMetadata) ProtoMessage() {}

func (x *FlatpakPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlatpakPackageMetadata.ProtoReflect.Descriptor instead.
func (*FlatpakPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{27}
}

func (x *FlatpakPackageMetadata) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *FlatpakPackageMetadata) GetPackageId() string {
	if x != nil {
		return x.PackageId
	}
	return ""
}

func (x *FlatpakPackageMetadata) GetPackageVersion() string {
	if x != nil {
		return x.PackageVersion
	}
	return ""
}

func (x *FlatpakPackageMetadata) GetReleaseDate() string {
	if x != nil {
		return x.ReleaseDate
	}
	return ""
}

func (x *FlatpakPackageMetadata) GetOsName() string {
	if x != nil {
		return x.OsName
	}
	return ""
}

func (x *FlatpakPackageMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *FlatpakPackageMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

func (x *FlatpakPackageMetadata) GetOsBuildId() string {
	if x != nil {
		return x.OsBuildId
	}
	return ""
}

func (x *FlatpakPackageMetadata) GetDeveloper() string {
	if x != nil {
		return x.Developer
	}
	return ""
}

// The additional data found in MODULE packages.
type KernelModuleMetadata struct {
	state                          protoimpl.MessageState `protogen:"open.v1"`
	PackageName                    string                 `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	PackageVersion                 string                 `protobuf:"bytes,2,opt,name=package_version,json=packageVersion,proto3" json:"package_version,omitempty"`
	PackageVermagic                string                 `protobuf:"bytes,3,opt,name=package_vermagic,json=packageVermagic,proto3" json:"package_vermagic,omitempty"`
	PackageSourceVersionIdentifier string                 `protobuf:"bytes,4,opt,name=package_source_version_identifier,json=packageSourceVersionIdentifier,proto3" json:"package_source_version_identifier,omitempty"`
	OsId                           string                 `protobuf:"bytes,5,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionCodename              string                 `protobuf:"bytes,6,opt,name=os_version_codename,json=osVersionCodename,proto3" json:"os_version_codename,omitempty"`
	OsVersionId                    string                 `protobuf:"bytes,7,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	PackageAuthor                  string                 `protobuf:"bytes,8,opt,name=package_author,json=packageAuthor,proto3" json:"package_author,omitempty"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *KernelModuleMetadata) Reset() {
	*x = KernelModuleMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KernelModuleMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KernelModuleMetadata) ProtoMessage() {}

func (x *KernelModuleMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KernelModuleMetadata.ProtoReflect.Descriptor instead.
func (*KernelModuleMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{28}
}

func (x *KernelModuleMetadata) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *KernelModuleMetadata) GetPackageVersion() string {
	if x != nil {
		return x.PackageVersion
	}
	return ""
}

func (x *KernelModuleMetadata) GetPackageVermagic() string {
	if x != nil {
		return x.PackageVermagic
	}
	return ""
}

func (x *KernelModuleMetadata) GetPackageSourceVersionIdentifier() string {
	if x != nil {
		return x.PackageSourceVersionIdentifier
	}
	return ""
}

func (x *KernelModuleMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *KernelModuleMetadata) GetOsVersionCodename() string {
	if x != nil {
		return x.OsVersionCodename
	}
	return ""
}

func (x *KernelModuleMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

func (x *KernelModuleMetadata) GetPackageAuthor() string {
	if x != nil {
		return x.PackageAuthor
	}
	return ""
}

// The additional data found in Vmlinuz packages.
type VmlinuzMetadata struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	Name              string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version           string                 `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Architecture      string                 `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	ExtendedVersion   string                 `protobuf:"bytes,4,opt,name=extended_version,json=extendedVersion,proto3" json:"extended_version,omitempty"`
	Format            string                 `protobuf:"bytes,5,opt,name=format,proto3" json:"format,omitempty"`
	SwapDevice        int32                  `protobuf:"varint,6,opt,name=swap_device,json=swapDevice,proto3" json:"swap_device,omitempty"`
	RootDevice        int32                  `protobuf:"varint,7,opt,name=root_device,json=rootDevice,proto3" json:"root_device,omitempty"`
	VideoMode         string                 `protobuf:"bytes,8,opt,name=video_mode,json=videoMode,proto3" json:"video_mode,omitempty"`
	OsId              string                 `protobuf:"bytes,9,opt,name=os_id,json=osId,proto3" json:"os_id,omitempty"`
	OsVersionCodename string                 `protobuf:"bytes,10,opt,name=os_version_codename,json=osVersionCodename,proto3" json:"os_version_codename,omitempty"`
	OsVersionId       string                 `protobuf:"bytes,11,opt,name=os_version_id,json=osVersionId,proto3" json:"os_version_id,omitempty"`
	RwRootFs          bool                   `protobuf:"varint,12,opt,name=rw_root_fs,json=rwRootFs,proto3" json:"rw_root_fs,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *VmlinuzMetadata) Reset() {
	*x = VmlinuzMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmlinuzMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmlinuzMetadata) ProtoMessage() {}

func (x *VmlinuzMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmlinuzMetadata.ProtoReflect.Descriptor instead.
func (*VmlinuzMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{29}
}

func (x *VmlinuzMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VmlinuzMetadata) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *VmlinuzMetadata) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *VmlinuzMetadata) GetExtendedVersion() string {
	if x != nil {
		return x.ExtendedVersion
	}
	return ""
}

func (x *VmlinuzMetadata) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *VmlinuzMetadata) GetSwapDevice() int32 {
	if x != nil {
		return x.SwapDevice
	}
	return 0
}

func (x *VmlinuzMetadata) GetRootDevice() int32 {
	if x != nil {
		return x.RootDevice
	}
	return 0
}

func (x *VmlinuzMetadata) GetVideoMode() string {
	if x != nil {
		return x.VideoMode
	}
	return ""
}

func (x *VmlinuzMetadata) GetOsId() string {
	if x != nil {
		return x.OsId
	}
	return ""
}

func (x *VmlinuzMetadata) GetOsVersionCodename() string {
	if x != nil {
		return x.OsVersionCodename
	}
	return ""
}

func (x *VmlinuzMetadata) GetOsVersionId() string {
	if x != nil {
		return x.OsVersionId
	}
	return ""
}

func (x *VmlinuzMetadata) GetRwRootFs() bool {
	if x != nil {
		return x.RwRootFs
	}
	return false
}

// The additional data found in Mac Applications.
type MacAppsMetadata struct {
	state                    protoimpl.MessageState `protogen:"open.v1"`
	BundleDisplayName        string                 `protobuf:"bytes,1,opt,name=bundle_display_name,json=bundleDisplayName,proto3" json:"bundle_display_name,omitempty"`
	BundleIdentifier         string                 `protobuf:"bytes,2,opt,name=bundle_identifier,json=bundleIdentifier,proto3" json:"bundle_identifier,omitempty"`
	BundleShortVersionString string                 `protobuf:"bytes,3,opt,name=bundle_short_version_string,json=bundleShortVersionString,proto3" json:"bundle_short_version_string,omitempty"`
	BundleExecutable         string                 `protobuf:"bytes,4,opt,name=bundle_executable,json=bundleExecutable,proto3" json:"bundle_executable,omitempty"`
	BundleName               string                 `protobuf:"bytes,5,opt,name=bundle_name,json=bundleName,proto3" json:"bundle_name,omitempty"`
	BundlePackageType        string                 `protobuf:"bytes,6,opt,name=bundle_package_type,json=bundlePackageType,proto3" json:"bundle_package_type,omitempty"`
	BundleSignature          string                 `protobuf:"bytes,7,opt,name=bundle_signature,json=bundleSignature,proto3" json:"bundle_signature,omitempty"`
	BundleVersion            string                 `protobuf:"bytes,8,opt,name=bundle_version,json=bundleVersion,proto3" json:"bundle_version,omitempty"`
	ProductId                string                 `protobuf:"bytes,9,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	UpdateUrl                string                 `protobuf:"bytes,10,opt,name=update_url,json=updateUrl,proto3" json:"update_url,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *MacAppsMetadata) Reset() {
	*x = MacAppsMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MacAppsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MacAppsMetadata) ProtoMessage() {}

func (x *MacAppsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MacAppsMetadata.ProtoReflect.Descriptor instead.
func (*MacAppsMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{30}
}

func (x *MacAppsMetadata) GetBundleDisplayName() string {
	if x != nil {
		return x.BundleDisplayName
	}
	return ""
}

func (x *MacAppsMetadata) GetBundleIdentifier() string {
	if x != nil {
		return x.BundleIdentifier
	}
	return ""
}

func (x *MacAppsMetadata) GetBundleShortVersionString() string {
	if x != nil {
		return x.BundleShortVersionString
	}
	return ""
}

func (x *MacAppsMetadata) GetBundleExecutable() string {
	if x != nil {
		return x.BundleExecutable
	}
	return ""
}

func (x *MacAppsMetadata) GetBundleName() string {
	if x != nil {
		return x.BundleName
	}
	return ""
}

func (x *MacAppsMetadata) GetBundlePackageType() string {
	if x != nil {
		return x.BundlePackageType
	}
	return ""
}

func (x *MacAppsMetadata) GetBundleSignature() string {
	if x != nil {
		return x.BundleSignature
	}
	return ""
}

func (x *MacAppsMetadata) GetBundleVersion() string {
	if x != nil {
		return x.BundleVersion
	}
	return ""
}

func (x *MacAppsMetadata) GetProductId() string {
	if x != nil {
		return x.ProductId
	}
	return ""
}

func (x *MacAppsMetadata) GetUpdateUrl() string {
	if x != nil {
		return x.UpdateUrl
	}
	return ""
}

// The additional data for packages extracted from SPDX files.
type SPDXPackageMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Purl          *Purl                  `protobuf:"bytes,1,opt,name=purl,proto3" json:"purl,omitempty"`
	Cpes          []string               `protobuf:"bytes,2,rep,name=cpes,proto3" json:"cpes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SPDXPackageMetadata) Reset() {
	*x = SPDXPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SPDXPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SPDXPackageMetadata) ProtoMessage() {}

func (x *SPDXPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SPDXPackageMetadata.ProtoReflect.Descriptor instead.
func (*SPDXPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{31}
}

func (x *SPDXPackageMetadata) GetPurl() *Purl {
	if x != nil {
		return x.Purl
	}
	return nil
}

func (x *SPDXPackageMetadata) GetCpes() []string {
	if x != nil {
		return x.Cpes
	}
	return nil
}

// The additional data for packages extracted from CDX files.
type CDXPackageMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Purl          *Purl                  `protobuf:"bytes,1,opt,name=purl,proto3" json:"purl,omitempty"`
	Cpes          []string               `protobuf:"bytes,2,rep,name=cpes,proto3" json:"cpes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CDXPackageMetadata) Reset() {
	*x = CDXPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CDXPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CDXPackageMetadata) ProtoMessage() {}

func (x *CDXPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CDXPackageMetadata.ProtoReflect.Descriptor instead.
func (*CDXPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{32}
}

func (x *CDXPackageMetadata) GetPurl() *Purl {
	if x != nil {
		return x.Purl
	}
	return nil
}

func (x *CDXPackageMetadata) GetCpes() []string {
	if x != nil {
		return x.Cpes
	}
	return nil
}

// The additional data found in Java JAR packages.
type JavaArchiveMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ArtifactId    string                 `protobuf:"bytes,2,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	GroupId       string                 `protobuf:"bytes,3,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	Sha1          string                 `protobuf:"bytes,4,opt,name=sha1,proto3" json:"sha1,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JavaArchiveMetadata) Reset() {
	*x = JavaArchiveMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JavaArchiveMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JavaArchiveMetadata) ProtoMessage() {}

func (x *JavaArchiveMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JavaArchiveMetadata.ProtoReflect.Descriptor instead.
func (*JavaArchiveMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{33}
}

func (x *JavaArchiveMetadata) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

func (x *JavaArchiveMetadata) GetGroupId() string {
	if x != nil {
		return x.GroupId
	}
	return ""
}

func (x *JavaArchiveMetadata) GetSha1() string {
	if x != nil {
		return x.Sha1
	}
	return ""
}

// The additional data found in Java lockfiles.
type JavaLockfileMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ArtifactId    string                 `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	GroupId       string                 `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	DepGroupVals  []string               `protobuf:"bytes,3,rep,name=dep_group_vals,json=depGroupVals,proto3" json:"dep_group_vals,omitempty"`
	IsTransitive  bool                   `protobuf:"varint,4,opt,name=is_transitive,json=isTransitive,proto3" json:"is_transitive,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JavaLockfileMetadata) Reset() {
	*x = JavaLockfileMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JavaLockfileMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JavaLockfileMetadata) ProtoMessage() {}

func (x *JavaLockfileMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JavaLockfileMetadata.ProtoReflect.Descriptor instead.
func (*JavaLockfileMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{34}
}

func (x *JavaLockfileMetadata) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

func (x *JavaLockfileMetadata) GetGroupId() string {
	if x != nil {
		return x.GroupId
	}
	return ""
}

func (x *JavaLockfileMetadata) GetDepGroupVals() []string {
	if x != nil {
		return x.DepGroupVals
	}
	return nil
}

func (x *JavaLockfileMetadata) GetIsTransitive() bool {
	if x != nil {
		return x.IsTransitive
	}
	return false
}

// The additional data for packages extracted by an OSV extractor wrapper.
type OSVPackageMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PurlType      string                 `protobuf:"bytes,1,opt,name=purl_type,json=purlType,proto3" json:"purl_type,omitempty"`
	Commit        string                 `protobuf:"bytes,2,opt,name=commit,proto3" json:"commit,omitempty"`
	Ecosystem     string                 `protobuf:"bytes,3,opt,name=ecosystem,proto3" json:"ecosystem,omitempty"`
	CompareAs     string                 `protobuf:"bytes,4,opt,name=compare_as,json=compareAs,proto3" json:"compare_as,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OSVPackageMetadata) Reset() {
	*x = OSVPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OSVPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSVPackageMetadata) ProtoMessage() {}

func (x *OSVPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSVPackageMetadata.ProtoReflect.Descriptor instead.
func (*OSVPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{35}
}

func (x *OSVPackageMetadata) GetPurlType() string {
	if x != nil {
		return x.PurlType
	}
	return ""
}

func (x *OSVPackageMetadata) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

func (x *OSVPackageMetadata) GetEcosystem() string {
	if x != nil {
		return x.Ecosystem
	}
	return ""
}

func (x *OSVPackageMetadata) GetCompareAs() string {
	if x != nil {
		return x.CompareAs
	}
	return ""
}

type PythonRequirementsMetadata struct {
	state                  protoimpl.MessageState `protogen:"open.v1"`
	HashCheckingModeValues []string               `protobuf:"bytes,1,rep,name=hash_checking_mode_values,json=hashCheckingModeValues,proto3" json:"hash_checking_mode_values,omitempty"`
	VersionComparator      string                 `protobuf:"bytes,2,opt,name=version_comparator,json=versionComparator,proto3" json:"version_comparator,omitempty"`
	Requirement            string                 `protobuf:"bytes,3,opt,name=requirement,proto3" json:"requirement,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *PythonRequirementsMetadata) Reset() {
	*x = PythonRequirementsMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PythonRequirementsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PythonRequirementsMetadata) ProtoMessage() {}

func (x *PythonRequirementsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PythonRequirementsMetadata.ProtoReflect.Descriptor instead.
func (*PythonRequirementsMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{36}
}

func (x *PythonRequirementsMetadata) GetHashCheckingModeValues() []string {
	if x != nil {
		return x.HashCheckingModeValues
	}
	return nil
}

func (x *PythonRequirementsMetadata) GetVersionComparator() string {
	if x != nil {
		return x.VersionComparator
	}
	return ""
}

func (x *PythonRequirementsMetadata) GetRequirement() string {
	if x != nil {
		return x.Requirement
	}
	return ""
}

type PythonSetupMetadata struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	VersionComparator string                 `protobuf:"bytes,2,opt,name=version_comparator,json=versionComparator,proto3" json:"version_comparator,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *PythonSetupMetadata) Reset() {
	*x = PythonSetupMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PythonSetupMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PythonSetupMetadata) ProtoMessage() {}

func (x *PythonSetupMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PythonSetupMetadata.ProtoReflect.Descriptor instead.
func (*PythonSetupMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{37}
}

func (x *PythonSetupMetadata) GetVersionComparator() string {
	if x != nil {
		return x.VersionComparator
	}
	return ""
}

// Used to report open ports on a system.
type NetportsMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Port          uint32                 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	Protocol      string                 `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	CommandLine   string                 `protobuf:"bytes,3,opt,name=command_line,json=commandLine,proto3" json:"command_line,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NetportsMetadata) Reset() {
	*x = NetportsMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetportsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetportsMetadata) ProtoMessage() {}

func (x *NetportsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetportsMetadata.ProtoReflect.Descriptor instead.
func (*NetportsMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{38}
}

func (x *NetportsMetadata) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *NetportsMetadata) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *NetportsMetadata) GetCommandLine() string {
	if x != nil {
		return x.CommandLine
	}
	return ""
}

type ContainerdContainerMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NamespaceName string                 `protobuf:"bytes,1,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	ImageName     string                 `protobuf:"bytes,2,opt,name=image_name,json=imageName,proto3" json:"image_name,omitempty"`
	ImageDigest   string                 `protobuf:"bytes,3,opt,name=image_digest,json=imageDigest,proto3" json:"image_digest,omitempty"`
	Runtime       string                 `protobuf:"bytes,4,opt,name=runtime,proto3" json:"runtime,omitempty"`
	Pid           int32                  `protobuf:"varint,5,opt,name=pid,proto3" json:"pid,omitempty"`
	Snapshotter   string                 `protobuf:"bytes,6,opt,name=snapshotter,proto3" json:"snapshotter,omitempty"`
	SnapshotKey   string                 `protobuf:"bytes,7,opt,name=snapshot_key,json=snapshotKey,proto3" json:"snapshot_key,omitempty"`
	LowerDir      string                 `protobuf:"bytes,8,opt,name=lower_dir,json=lowerDir,proto3" json:"lower_dir,omitempty"`
	UpperDir      string                 `protobuf:"bytes,9,opt,name=upper_dir,json=upperDir,proto3" json:"upper_dir,omitempty"`
	WorkDir       string                 `protobuf:"bytes,10,opt,name=work_dir,json=workDir,proto3" json:"work_dir,omitempty"`
	Id            string                 `protobuf:"bytes,11,opt,name=id,proto3" json:"id,omitempty"`
	PodName       string                 `protobuf:"bytes,12,opt,name=pod_name,json=podName,proto3" json:"pod_name,omitempty"`
	PodNamespace  string                 `protobuf:"bytes,13,opt,name=pod_namespace,json=podNamespace,proto3" json:"pod_namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerdContainerMetadata) Reset() {
	*x = ContainerdContainerMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerdContainerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerdContainerMetadata) ProtoMessage() {}

func (x *ContainerdContainerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerdContainerMetadata.ProtoReflect.Descriptor instead.
func (*ContainerdContainerMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{39}
}

func (x *ContainerdContainerMetadata) GetNamespaceName() string {
	if x != nil {
		return x.NamespaceName
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetImageName() string {
	if x != nil {
		return x.ImageName
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetImageDigest() string {
	if x != nil {
		return x.ImageDigest
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetRuntime() string {
	if x != nil {
		return x.Runtime
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetPid() int32 {
	if x != nil {
		return x.Pid
	}
	return 0
}

func (x *ContainerdContainerMetadata) GetSnapshotter() string {
	if x != nil {
		return x.Snapshotter
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetSnapshotKey() string {
	if x != nil {
		return x.SnapshotKey
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetLowerDir() string {
	if x != nil {
		return x.LowerDir
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetUpperDir() string {
	if x != nil {
		return x.UpperDir
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetWorkDir() string {
	if x != nil {
		return x.WorkDir
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetPodName() string {
	if x != nil {
		return x.PodName
	}
	return ""
}

func (x *ContainerdContainerMetadata) GetPodNamespace() string {
	if x != nil {
		return x.PodNamespace
	}
	return ""
}

type ContainerdRuntimeContainerMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NamespaceName string                 `protobuf:"bytes,1,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	ImageName     string                 `protobuf:"bytes,2,opt,name=image_name,json=imageName,proto3" json:"image_name,omitempty"`
	ImageDigest   string                 `protobuf:"bytes,3,opt,name=image_digest,json=imageDigest,proto3" json:"image_digest,omitempty"`
	Runtime       string                 `protobuf:"bytes,4,opt,name=runtime,proto3" json:"runtime,omitempty"`
	Id            string                 `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	Pid           int32                  `protobuf:"varint,6,opt,name=pid,proto3" json:"pid,omitempty"`
	RootfsPath    string                 `protobuf:"bytes,7,opt,name=rootfs_path,json=rootfsPath,proto3" json:"rootfs_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerdRuntimeContainerMetadata) Reset() {
	*x = ContainerdRuntimeContainerMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerdRuntimeContainerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerdRuntimeContainerMetadata) ProtoMessage() {}

func (x *ContainerdRuntimeContainerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerdRuntimeContainerMetadata.ProtoReflect.Descriptor instead.
func (*ContainerdRuntimeContainerMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{40}
}

func (x *ContainerdRuntimeContainerMetadata) GetNamespaceName() string {
	if x != nil {
		return x.NamespaceName
	}
	return ""
}

func (x *ContainerdRuntimeContainerMetadata) GetImageName() string {
	if x != nil {
		return x.ImageName
	}
	return ""
}

func (x *ContainerdRuntimeContainerMetadata) GetImageDigest() string {
	if x != nil {
		return x.ImageDigest
	}
	return ""
}

func (x *ContainerdRuntimeContainerMetadata) GetRuntime() string {
	if x != nil {
		return x.Runtime
	}
	return ""
}

func (x *ContainerdRuntimeContainerMetadata) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerdRuntimeContainerMetadata) GetPid() int32 {
	if x != nil {
		return x.Pid
	}
	return 0
}

func (x *ContainerdRuntimeContainerMetadata) GetRootfsPath() string {
	if x != nil {
		return x.RootfsPath
	}
	return ""
}

type WindowsOSVersion struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Product       string                 `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	FullVersion   string                 `protobuf:"bytes,2,opt,name=full_version,json=fullVersion,proto3" json:"full_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsOSVersion) Reset() {
	*x = WindowsOSVersion{}
	mi := &file_proto_scan_result_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsOSVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsOSVersion) ProtoMessage() {}

func (x *WindowsOSVersion) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsOSVersion.ProtoReflect.Descriptor instead.
func (*WindowsOSVersion) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{41}
}

func (x *WindowsOSVersion) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

func (x *WindowsOSVersion) GetFullVersion() string {
	if x != nil {
		return x.FullVersion
	}
	return ""
}

// The additional data found in Homebrew packages.
type HomebrewPackageMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HomebrewPackageMetadata) Reset() {
	*x = HomebrewPackageMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HomebrewPackageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HomebrewPackageMetadata) ProtoMessage() {}

func (x *HomebrewPackageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HomebrewPackageMetadata.ProtoReflect.Descriptor instead.
func (*HomebrewPackageMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{42}
}

// The additional data found in Chrome extensions.
type ChromeExtensionsMetadata struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Name                 string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Description          string                 `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	AuthorEmail          string                 `protobuf:"bytes,3,opt,name=author_email,json=authorEmail,proto3" json:"author_email,omitempty"`
	HostPermissions      []string               `protobuf:"bytes,4,rep,name=host_permissions,json=hostPermissions,proto3" json:"host_permissions,omitempty"`
	ManifestVersion      int32                  `protobuf:"varint,5,opt,name=manifest_version,json=manifestVersion,proto3" json:"manifest_version,omitempty"`
	MinimumChromeVersion string                 `protobuf:"bytes,6,opt,name=minimum_chrome_version,json=minimumChromeVersion,proto3" json:"minimum_chrome_version,omitempty"`
	Permissions          []string               `protobuf:"bytes,7,rep,name=permissions,proto3" json:"permissions,omitempty"`
	UpdateUrl            string                 `protobuf:"bytes,8,opt,name=update_url,json=updateUrl,proto3" json:"update_url,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ChromeExtensionsMetadata) Reset() {
	*x = ChromeExtensionsMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChromeExtensionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChromeExtensionsMetadata) ProtoMessage() {}

func (x *ChromeExtensionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChromeExtensionsMetadata.ProtoReflect.Descriptor instead.
func (*ChromeExtensionsMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{43}
}

func (x *ChromeExtensionsMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChromeExtensionsMetadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ChromeExtensionsMetadata) GetAuthorEmail() string {
	if x != nil {
		return x.AuthorEmail
	}
	return ""
}

func (x *ChromeExtensionsMetadata) GetHostPermissions() []string {
	if x != nil {
		return x.HostPermissions
	}
	return nil
}

func (x *ChromeExtensionsMetadata) GetManifestVersion() int32 {
	if x != nil {
		return x.ManifestVersion
	}
	return 0
}

func (x *ChromeExtensionsMetadata) GetMinimumChromeVersion() string {
	if x != nil {
		return x.MinimumChromeVersion
	}
	return ""
}

func (x *ChromeExtensionsMetadata) GetPermissions() []string {
	if x != nil {
		return x.Permissions
	}
	return nil
}

func (x *ChromeExtensionsMetadata) GetUpdateUrl() string {
	if x != nil {
		return x.UpdateUrl
	}
	return ""
}

// The additional data found in VSCode extensions.
type VSCodeExtensionsMetadata struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Id                   string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	PublisherId          string                 `protobuf:"bytes,2,opt,name=publisher_id,json=publisherId,proto3" json:"publisher_id,omitempty"`
	PublisherDisplayName string                 `protobuf:"bytes,3,opt,name=publisher_display_name,json=publisherDisplayName,proto3" json:"publisher_display_name,omitempty"`
	TargetPlatform       string                 `protobuf:"bytes,4,opt,name=target_platform,json=targetPlatform,proto3" json:"target_platform,omitempty"`
	Updated              bool                   `protobuf:"varint,5,opt,name=updated,proto3" json:"updated,omitempty"`
	IsPreReleaseVersion  bool                   `protobuf:"varint,6,opt,name=is_pre_release_version,json=isPreReleaseVersion,proto3" json:"is_pre_release_version,omitempty"`
	InstalledTimestamp   int64                  `protobuf:"varint,7,opt,name=installed_timestamp,json=installedTimestamp,proto3" json:"installed_timestamp,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *VSCodeExtensionsMetadata) Reset() {
	*x = VSCodeExtensionsMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VSCodeExtensionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VSCodeExtensionsMetadata) ProtoMessage() {}

func (x *VSCodeExtensionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VSCodeExtensionsMetadata.ProtoReflect.Descriptor instead.
func (*VSCodeExtensionsMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{44}
}

func (x *VSCodeExtensionsMetadata) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VSCodeExtensionsMetadata) GetPublisherId() string {
	if x != nil {
		return x.PublisherId
	}
	return ""
}

func (x *VSCodeExtensionsMetadata) GetPublisherDisplayName() string {
	if x != nil {
		return x.PublisherDisplayName
	}
	return ""
}

func (x *VSCodeExtensionsMetadata) GetTargetPlatform() string {
	if x != nil {
		return x.TargetPlatform
	}
	return ""
}

func (x *VSCodeExtensionsMetadata) GetUpdated() bool {
	if x != nil {
		return x.Updated
	}
	return false
}

func (x *VSCodeExtensionsMetadata) GetIsPreReleaseVersion() bool {
	if x != nil {
		return x.IsPreReleaseVersion
	}
	return false
}

func (x *VSCodeExtensionsMetadata) GetInstalledTimestamp() int64 {
	if x != nil {
		return x.InstalledTimestamp
	}
	return 0
}

// The additional data found in Podman containers.
type PodmanMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ExposedPorts  map[uint32]*Protocol   `protobuf:"bytes,1,rep,name=exposed_ports,json=exposedPorts,proto3" json:"exposed_ports,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Pid           int32                  `protobuf:"varint,2,opt,name=pid,proto3" json:"pid,omitempty"`
	NamespaceName string                 `protobuf:"bytes,3,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	StartedTime   *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=started_time,json=startedTime,proto3" json:"started_time,omitempty"`
	FinishedTime  *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=finished_time,json=finishedTime,proto3" json:"finished_time,omitempty"`
	Status        string                 `protobuf:"bytes,6,opt,name=status,proto3" json:"status,omitempty"`
	ExitCode      int32                  `protobuf:"varint,7,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	Exited        bool                   `protobuf:"varint,8,opt,name=exited,proto3" json:"exited,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodmanMetadata) Reset() {
	*x = PodmanMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodmanMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodmanMetadata) ProtoMessage() {}

func (x *PodmanMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodmanMetadata.ProtoReflect.Descriptor instead.
func (*PodmanMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{45}
}

func (x *PodmanMetadata) GetExposedPorts() map[uint32]*Protocol {
	if x != nil {
		return x.ExposedPorts
	}
	return nil
}

func (x *PodmanMetadata) GetPid() int32 {
	if x != nil {
		return x.Pid
	}
	return 0
}

func (x *PodmanMetadata) GetNamespaceName() string {
	if x != nil {
		return x.NamespaceName
	}
	return ""
}

func (x *PodmanMetadata) GetStartedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartedTime
	}
	return nil
}

func (x *PodmanMetadata) GetFinishedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FinishedTime
	}
	return nil
}

func (x *PodmanMetadata) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *PodmanMetadata) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *PodmanMetadata) GetExited() bool {
	if x != nil {
		return x.Exited
	}
	return false
}

type Protocol struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Names         []string               `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Protocol) Reset() {
	*x = Protocol{}
	mi := &file_proto_scan_result_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Protocol) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Protocol) ProtoMessage() {}

func (x *Protocol) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Protocol.ProtoReflect.Descriptor instead.
func (*Protocol) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{46}
}

func (x *Protocol) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

type DockerContainersMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ImageName     string                 `protobuf:"bytes,1,opt,name=image_name,json=imageName,proto3" json:"image_name,omitempty"`
	ImageDigest   string                 `protobuf:"bytes,2,opt,name=image_digest,json=imageDigest,proto3" json:"image_digest,omitempty"`
	Id            string                 `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	Ports         []*DockerPort          `protobuf:"bytes,4,rep,name=ports,proto3" json:"ports,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DockerContainersMetadata) Reset() {
	*x = DockerContainersMetadata{}
	mi := &file_proto_scan_result_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DockerContainersMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DockerContainersMetadata) ProtoMessage() {}

func (x *DockerContainersMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DockerContainersMetadata.ProtoReflect.Descriptor instead.
func (*DockerContainersMetadata) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{47}
}

func (x *DockerContainersMetadata) GetImageName() string {
	if x != nil {
		return x.ImageName
	}
	return ""
}

func (x *DockerContainersMetadata) GetImageDigest() string {
	if x != nil {
		return x.ImageDigest
	}
	return ""
}

func (x *DockerContainersMetadata) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DockerContainersMetadata) GetPorts() []*DockerPort {
	if x != nil {
		return x.Ports
	}
	return nil
}

type DockerPort struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Ip            string                 `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	PrivatePort   uint32                 `protobuf:"varint,2,opt,name=private_port,json=privatePort,proto3" json:"private_port,omitempty"`
	PublicPort    uint32                 `protobuf:"varint,3,opt,name=public_port,json=publicPort,proto3" json:"public_port,omitempty"`
	Type          string                 `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DockerPort) Reset() {
	*x = DockerPort{}
	mi := &file_proto_scan_result_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DockerPort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DockerPort) ProtoMessage() {}

func (x *DockerPort) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DockerPort.ProtoReflect.Descriptor instead.
func (*DockerPort) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{48}
}

func (x *DockerPort) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *DockerPort) GetPrivatePort() uint32 {
	if x != nil {
		return x.PrivatePort
	}
	return 0
}

func (x *DockerPort) GetPublicPort() uint32 {
	if x != nil {
		return x.PublicPort
	}
	return 0
}

func (x *DockerPort) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// A secret (i.e. credential) found by Veles secret scanning.
type Secret struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Secret        *SecretData            `protobuf:"bytes,1,opt,name=secret,proto3" json:"secret,omitempty"`
	Status        *SecretStatus          `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Locations     []*Location            `protobuf:"bytes,3,rep,name=locations,proto3" json:"locations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Secret) Reset() {
	*x = Secret{}
	mi := &file_proto_scan_result_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Secret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Secret) ProtoMessage() {}

func (x *Secret) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Secret.ProtoReflect.Descriptor instead.
func (*Secret) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{49}
}

func (x *Secret) GetSecret() *SecretData {
	if x != nil {
		return x.Secret
	}
	return nil
}

func (x *Secret) GetStatus() *SecretStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Secret) GetLocations() []*Location {
	if x != nil {
		return x.Locations
	}
	return nil
}

type SecretData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Secret:
	//
	//	*SecretData_Gcpsak
	Secret        isSecretData_Secret `protobuf_oneof:"secret"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecretData) Reset() {
	*x = SecretData{}
	mi := &file_proto_scan_result_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecretData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretData) ProtoMessage() {}

func (x *SecretData) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretData.ProtoReflect.Descriptor instead.
func (*SecretData) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{50}
}

func (x *SecretData) GetSecret() isSecretData_Secret {
	if x != nil {
		return x.Secret
	}
	return nil
}

func (x *SecretData) GetGcpsak() *SecretData_GCPSAK {
	if x != nil {
		if x, ok := x.Secret.(*SecretData_Gcpsak); ok {
			return x.Gcpsak
		}
	}
	return nil
}

type isSecretData_Secret interface {
	isSecretData_Secret()
}

type SecretData_Gcpsak struct {
	Gcpsak *SecretData_GCPSAK `protobuf:"bytes,1,opt,name=gcpsak,proto3,oneof"`
}

func (*SecretData_Gcpsak) isSecretData_Secret() {}

type SecretStatus struct {
	state         protoimpl.MessageState        `protogen:"open.v1"`
	Status        SecretStatus_SecretStatusEnum `protobuf:"varint,1,opt,name=status,proto3,enum=scalibr.SecretStatus_SecretStatusEnum" json:"status,omitempty"`
	LastUpdated   *timestamppb.Timestamp        `protobuf:"bytes,2,opt,name=last_updated,json=lastUpdated,proto3" json:"last_updated,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecretStatus) Reset() {
	*x = SecretStatus{}
	mi := &file_proto_scan_result_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecretStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretStatus) ProtoMessage() {}

func (x *SecretStatus) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretStatus.ProtoReflect.Descriptor instead.
func (*SecretStatus) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{51}
}

func (x *SecretStatus) GetStatus() SecretStatus_SecretStatusEnum {
	if x != nil {
		return x.Status
	}
	return SecretStatus_UNSPECIFIED
}

func (x *SecretStatus) GetLastUpdated() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdated
	}
	return nil
}

type Location struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Location:
	//
	//	*Location_Filepath
	//	*Location_FilepathWithLayerDetails
	//	*Location_EnvironmentVariable
	//	*Location_ContainerCommand
	Location      isLocation_Location `protobuf_oneof:"location"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Location) Reset() {
	*x = Location{}
	mi := &file_proto_scan_result_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{52}
}

func (x *Location) GetLocation() isLocation_Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Location) GetFilepath() *Filepath {
	if x != nil {
		if x, ok := x.Location.(*Location_Filepath); ok {
			return x.Filepath
		}
	}
	return nil
}

func (x *Location) GetFilepathWithLayerDetails() *FilepathWithLayerDetails {
	if x != nil {
		if x, ok := x.Location.(*Location_FilepathWithLayerDetails); ok {
			return x.FilepathWithLayerDetails
		}
	}
	return nil
}

func (x *Location) GetEnvironmentVariable() *EnvironmentVariable {
	if x != nil {
		if x, ok := x.Location.(*Location_EnvironmentVariable); ok {
			return x.EnvironmentVariable
		}
	}
	return nil
}

func (x *Location) GetContainerCommand() *ContainerCommand {
	if x != nil {
		if x, ok := x.Location.(*Location_ContainerCommand); ok {
			return x.ContainerCommand
		}
	}
	return nil
}

type isLocation_Location interface {
	isLocation_Location()
}

type Location_Filepath struct {
	Filepath *Filepath `protobuf:"bytes,1,opt,name=filepath,proto3,oneof"`
}

type Location_FilepathWithLayerDetails struct {
	FilepathWithLayerDetails *FilepathWithLayerDetails `protobuf:"bytes,2,opt,name=filepath_with_layer_details,json=filepathWithLayerDetails,proto3,oneof"`
}

type Location_EnvironmentVariable struct {
	EnvironmentVariable *EnvironmentVariable `protobuf:"bytes,3,opt,name=environment_variable,json=environmentVariable,proto3,oneof"`
}

type Location_ContainerCommand struct {
	ContainerCommand *ContainerCommand `protobuf:"bytes,4,opt,name=container_command,json=containerCommand,proto3,oneof"`
}

func (*Location_Filepath) isLocation_Location() {}

func (*Location_FilepathWithLayerDetails) isLocation_Location() {}

func (*Location_EnvironmentVariable) isLocation_Location() {}

func (*Location_ContainerCommand) isLocation_Location() {}

type Filepath struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Path          string                 `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Filepath) Reset() {
	*x = Filepath{}
	mi := &file_proto_scan_result_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Filepath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filepath) ProtoMessage() {}

func (x *Filepath) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filepath.ProtoReflect.Descriptor instead.
func (*Filepath) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{53}
}

func (x *Filepath) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

type FilepathWithLayerDetails struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Path          string                 `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	LayerDetails  *LayerDetails          `protobuf:"bytes,2,opt,name=layer_details,json=layerDetails,proto3" json:"layer_details,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FilepathWithLayerDetails) Reset() {
	*x = FilepathWithLayerDetails{}
	mi := &file_proto_scan_result_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilepathWithLayerDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilepathWithLayerDetails) ProtoMessage() {}

func (x *FilepathWithLayerDetails) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilepathWithLayerDetails.ProtoReflect.Descriptor instead.
func (*FilepathWithLayerDetails) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{54}
}

func (x *FilepathWithLayerDetails) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *FilepathWithLayerDetails) GetLayerDetails() *LayerDetails {
	if x != nil {
		return x.LayerDetails
	}
	return nil
}

type EnvironmentVariable struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvironmentVariable) Reset() {
	*x = EnvironmentVariable{}
	mi := &file_proto_scan_result_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvironmentVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvironmentVariable) ProtoMessage() {}

func (x *EnvironmentVariable) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvironmentVariable.ProtoReflect.Descriptor instead.
func (*EnvironmentVariable) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{55}
}

func (x *EnvironmentVariable) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type ContainerCommand struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Command       string                 `protobuf:"bytes,1,opt,name=command,proto3" json:"command,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerCommand) Reset() {
	*x = ContainerCommand{}
	mi := &file_proto_scan_result_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerCommand) ProtoMessage() {}

func (x *ContainerCommand) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerCommand.ProtoReflect.Descriptor instead.
func (*ContainerCommand) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{56}
}

func (x *ContainerCommand) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

type SecretData_GCPSAK struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Always filled.
	PrivateKeyId string `protobuf:"bytes,1,opt,name=private_key_id,json=privateKeyId,proto3" json:"private_key_id,omitempty"`
	ClientEmail  string `protobuf:"bytes,2,opt,name=client_email,json=clientEmail,proto3" json:"client_email,omitempty"`
	Signature    []byte `protobuf:"bytes,3,opt,name=signature,proto3" json:"signature,omitempty"` // derived from the private_key for validation
	// Filled only when explicitly requested.
	Type                    string `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	ProjectId               string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	ClientId                string `protobuf:"bytes,6,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	AuthUri                 string `protobuf:"bytes,7,opt,name=auth_uri,json=authUri,proto3" json:"auth_uri,omitempty"`
	TokenUri                string `protobuf:"bytes,8,opt,name=token_uri,json=tokenUri,proto3" json:"token_uri,omitempty"`
	AuthProviderX509CertUrl string `protobuf:"bytes,9,opt,name=auth_provider_x509_cert_url,json=authProviderX509CertUrl,proto3" json:"auth_provider_x509_cert_url,omitempty"`
	ClientX509CertUrl       string `protobuf:"bytes,10,opt,name=client_x509_cert_url,json=clientX509CertUrl,proto3" json:"client_x509_cert_url,omitempty"`
	UniverseDomain          string `protobuf:"bytes,11,opt,name=universe_domain,json=universeDomain,proto3" json:"universe_domain,omitempty"`
	// Should not be filled out unless very explicitly requested accepting the
	// risk that this might accidentally leak the key.
	PrivateKey    string `protobuf:"bytes,12,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecretData_GCPSAK) Reset() {
	*x = SecretData_GCPSAK{}
	mi := &file_proto_scan_result_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecretData_GCPSAK) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretData_GCPSAK) ProtoMessage() {}

func (x *SecretData_GCPSAK) ProtoReflect() protoreflect.Message {
	mi := &file_proto_scan_result_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretData_GCPSAK.ProtoReflect.Descriptor instead.
func (*SecretData_GCPSAK) Descriptor() ([]byte, []int) {
	return file_proto_scan_result_proto_rawDescGZIP(), []int{50, 0}
}

func (x *SecretData_GCPSAK) GetPrivateKeyId() string {
	if x != nil {
		return x.PrivateKeyId
	}
	return ""
}

func (x *SecretData_GCPSAK) GetClientEmail() string {
	if x != nil {
		return x.ClientEmail
	}
	return ""
}

func (x *SecretData_GCPSAK) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *SecretData_GCPSAK) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *SecretData_GCPSAK) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SecretData_GCPSAK) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *SecretData_GCPSAK) GetAuthUri() string {
	if x != nil {
		return x.AuthUri
	}
	return ""
}

func (x *SecretData_GCPSAK) GetTokenUri() string {
	if x != nil {
		return x.TokenUri
	}
	return ""
}

func (x *SecretData_GCPSAK) GetAuthProviderX509CertUrl() string {
	if x != nil {
		return x.AuthProviderX509CertUrl
	}
	return ""
}

func (x *SecretData_GCPSAK) GetClientX509CertUrl() string {
	if x != nil {
		return x.ClientX509CertUrl
	}
	return ""
}

func (x *SecretData_GCPSAK) GetUniverseDomain() string {
	if x != nil {
		return x.UniverseDomain
	}
	return ""
}

func (x *SecretData_GCPSAK) GetPrivateKey() string {
	if x != nil {
		return x.PrivateKey
	}
	return ""
}

var File_proto_scan_result_proto protoreflect.FileDescriptor

const file_proto_scan_result_proto_rawDesc = "" +
	"\n" +
	"\x17proto/scan_result.proto\x12\ascalibr\x1a\x1fgoogle/protobuf/timestamp.proto\"\xce\x03\n" +
	"\n" +
	"ScanResult\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x129\n" +
	"\n" +
	"start_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\tstartTime\x125\n" +
	"\bend_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\aendTime\x12+\n" +
	"\x06status\x18\x04 \x01(\v2\x13.scalibr.ScanStatusR\x06status\x12:\n" +
	"\rplugin_status\x18\x05 \x03(\v2\x15.scalibr.PluginStatusR\fpluginStatus\x12K\n" +
	"\x16inventories_deprecated\x18\x06 \x03(\v2\x10.scalibr.PackageB\x02\x18\x01R\x15inventoriesDeprecated\x12L\n" +
	"\x13findings_deprecated\x18\a \x03(\v2\x17.scalibr.GenericFindingB\x02\x18\x01R\x12findingsDeprecated\x120\n" +
	"\tinventory\x18\b \x01(\v2\x12.scalibr.InventoryR\tinventory\"\xa8\x01\n" +
	"\tInventory\x12,\n" +
	"\bpackages\x18\x01 \x03(\v2\x10.scalibr.PackageR\bpackages\x12B\n" +
	"\x10generic_findings\x18\x02 \x03(\v2\x17.scalibr.GenericFindingR\x0fgenericFindings\x12)\n" +
	"\asecrets\x18\x03 \x03(\v2\x0f.scalibr.SecretR\asecrets\"\xc6\x01\n" +
	"\n" +
	"ScanStatus\x12:\n" +
	"\x06status\x18\x01 \x01(\x0e2\".scalibr.ScanStatus.ScanStatusEnumR\x06status\x12%\n" +
	"\x0efailure_reason\x18\x02 \x01(\tR\rfailureReason\"U\n" +
	"\x0eScanStatusEnum\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\r\n" +
	"\tSUCCEEDED\x10\x01\x12\x17\n" +
	"\x13PARTIALLY_SUCCEEDED\x10\x02\x12\n" +
	"\n" +
	"\x06FAILED\x10\x03\"i\n" +
	"\fPluginStatus\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\x05R\aversion\x12+\n" +
	"\x06status\x18\x03 \x01(\v2\x13.scalibr.ScanStatusR\x06status\"\xe9\x18\n" +
	"\aPackage\x12\x12\n" +
	"\x04name\x18\v \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\f \x01(\tR\aversion\x12>\n" +
	"\vsource_code\x18\x1a \x01(\v2\x1d.scalibr.SourceCodeIdentifierR\n" +
	"sourceCode\x12!\n" +
	"\x04purl\x18\x01 \x01(\v2\r.scalibr.PurlR\x04purl\x12\x1c\n" +
	"\tecosystem\x18\x1b \x01(\tR\tecosystem\x12\x1c\n" +
	"\tlocations\x18\x02 \x03(\tR\tlocations\x125\n" +
	"\x14extractor_deprecated\x18\n" +
	" \x01(\tB\x02\x18\x01R\x13extractorDeprecated\x12\x18\n" +
	"\aplugins\x181 \x03(\tR\aplugins\x12I\n" +
	"\x0fpython_metadata\x18\x05 \x01(\v2\x1e.scalibr.PythonPackageMetadataH\x00R\x0epythonMetadata\x12Y\n" +
	"\x13javascript_metadata\x18\x06 \x01(\v2&.scalibr.JavascriptPackageJSONMetadataH\x00R\x12javascriptMetadata\x12@\n" +
	"\fapk_metadata\x18\a \x01(\v2\x1b.scalibr.APKPackageMetadataH\x00R\vapkMetadata\x12C\n" +
	"\rdpkg_metadata\x18\b \x01(\v2\x1c.scalibr.DPKGPackageMetadataH\x00R\fdpkgMetadata\x12@\n" +
	"\frpm_metadata\x18\t \x01(\v2\x1b.scalibr.RPMPackageMetadataH\x00R\vrpmMetadata\x12@\n" +
	"\fcos_metadata\x18\r \x01(\v2\x1b.scalibr.COSPackageMetadataH\x00R\vcosMetadata\x12H\n" +
	"\x11depsjson_metadata\x18( \x01(\v2\x19.scalibr.DEPSJSONMetadataH\x00R\x10depsjsonMetadata\x12C\n" +
	"\rspdx_metadata\x18\x0e \x01(\v2\x1c.scalibr.SPDXPackageMetadataH\x00R\fspdxMetadata\x12R\n" +
	"\x15java_archive_metadata\x18\x0f \x01(\v2\x1c.scalibr.JavaArchiveMetadataH\x00R\x13javaArchiveMetadata\x12U\n" +
	"\x16java_lockfile_metadata\x18\x1f \x01(\v2\x1d.scalibr.JavaLockfileMetadataH\x00R\x14javaLockfileMetadata\x12I\n" +
	"\x0fpacman_metadata\x18$ \x01(\v2\x1e.scalibr.PACMANPackageMetadataH\x00R\x0epacmanMetadata\x12@\n" +
	"\fnix_metadata\x18% \x01(\v2\x1b.scalibr.NixPackageMetadataH\x00R\vnixMetadata\x12U\n" +
	"\x16kernel_module_metadata\x18& \x01(\v2\x1d.scalibr.KernelModuleMetadataH\x00R\x14kernelModuleMetadata\x12E\n" +
	"\x10vmlinuz_metadata\x18' \x01(\v2\x18.scalibr.VmlinuzMetadataH\x00R\x0fvmlinuzMetadata\x12L\n" +
	"\x10portage_metadata\x18) \x01(\v2\x1f.scalibr.PortagePackageMetadataH\x00R\x0fportageMetadata\x12@\n" +
	"\fosv_metadata\x18\x10 \x01(\v2\x1b.scalibr.OSVPackageMetadataH\x00R\vosvMetadata\x12H\n" +
	"\x11netports_metadata\x18- \x01(\v2\x19.scalibr.NetportsMetadataH\x00R\x10netportsMetadata\x12g\n" +
	"\x1cpython_requirements_metadata\x18\x15 \x01(\v2#.scalibr.PythonRequirementsMetadataH\x00R\x1apythonRequirementsMetadata\x12R\n" +
	"\x15python_setup_metadata\x18, \x01(\v2\x1c.scalibr.PythonSetupMetadataH\x00R\x13pythonSetupMetadata\x12j\n" +
	"\x1dcontainerd_container_metadata\x18\x16 \x01(\v2$.scalibr.ContainerdContainerMetadataH\x00R\x1bcontainerdContainerMetadata\x12C\n" +
	"\rsnap_metadata\x18\x17 \x01(\v2\x1c.scalibr.SNAPPackageMetadataH\x00R\fsnapMetadata\x12L\n" +
	"\x10flatpak_metadata\x18\x18 \x01(\v2\x1f.scalibr.FlatpakPackageMetadataH\x00R\x0fflatpakMetadata\x12F\n" +
	"\x11mac_apps_metadata\x18\" \x01(\v2\x18.scalibr.MacAppsMetadataH\x00R\x0fmacAppsMetadata\x12\x80\x01\n" +
	"%containerd_runtime_container_metadata\x18\x19 \x01(\v2+.scalibr.ContainerdRuntimeContainerMetadataH\x00R\"containerdRuntimeContainerMetadata\x12@\n" +
	"\fcdx_metadata\x18\x1e \x01(\v2\x1b.scalibr.CDXPackageMetadataH\x00R\vcdxMetadata\x12Z\n" +
	"\x1bwindows_os_version_metadata\x18! \x01(\v2\x19.scalibr.WindowsOSVersionH\x00R\x18windowsOsVersionMetadata\x12O\n" +
	"\x11homebrew_metadata\x18* \x01(\v2 .scalibr.HomebrewPackageMetadataH\x00R\x10homebrewMetadata\x12a\n" +
	"\x1achrome_extensions_metadata\x18/ \x01(\v2!.scalibr.ChromeExtensionsMetadataH\x00R\x18chromeExtensionsMetadata\x12a\n" +
	"\x1avscode_extensions_metadata\x18. \x01(\v2!.scalibr.VSCodeExtensionsMetadataH\x00R\x18vscodeExtensionsMetadata\x12B\n" +
	"\x0fpodman_metadata\x182 \x01(\v2\x17.scalibr.PodmanMetadataH\x00R\x0epodmanMetadata\x12a\n" +
	"\x1adocker_containers_metadata\x180 \x01(\v2!.scalibr.DockerContainersMetadataH\x00R\x18dockerContainersMetadata\x12Z\n" +
	"\x16annotations_deprecated\x18\x1c \x03(\x0e2\x1f.scalibr.Package.AnnotationEnumB\x02\x18\x01R\x15annotationsDeprecated\x12[\n" +
	"\x16exploitability_signals\x183 \x03(\v2$.scalibr.PackageExploitabilitySignalR\x15exploitabilitySignals\x12:\n" +
	"\rlayer_details\x18# \x01(\v2\x15.scalibr.LayerDetailsR\flayerDetails\"`\n" +
	"\x0eAnnotationEnum\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\x10\n" +
	"\fTRANSITIONAL\x10\x01\x12\x15\n" +
	"\x11INSIDE_OS_PACKAGE\x10\x02\x12\x14\n" +
	"\x10INSIDE_CACHE_DIR\x10\x03B\n" +
	"\n" +
	"\bmetadataJ\x04\b\x03\x10\x04J\x04\b\x04\x10\x05\"B\n" +
	"\x14SourceCodeIdentifier\x12\x12\n" +
	"\x04repo\x18\x01 \x01(\tR\x04repo\x12\x16\n" +
	"\x06commit\x18\x02 \x01(\tR\x06commit\"\x96\x01\n" +
	"\fLayerDetails\x12\x14\n" +
	"\x05index\x18\x01 \x01(\x05R\x05index\x12\x17\n" +
	"\adiff_id\x18\x02 \x01(\tR\x06diffId\x12\x19\n" +
	"\bchain_id\x18\x05 \x01(\tR\achainId\x12\x18\n" +
	"\acommand\x18\x03 \x01(\tR\acommand\x12\"\n" +
	"\rin_base_image\x18\x04 \x01(\bR\vinBaseImage\"\xfa\x01\n" +
	"\x1bPackageExploitabilitySignal\x12\x16\n" +
	"\x06plugin\x18\x01 \x01(\tR\x06plugin\x12?\n" +
	"\rjustification\x18\x02 \x01(\x0e2\x19.scalibr.VexJustificationR\rjustification\x12E\n" +
	"\x10vuln_identifiers\x18\x03 \x01(\v2\x18.scalibr.VulnIdentifiersH\x00R\x0fvulnIdentifiers\x12,\n" +
	"\x11matches_all_vulns\x18\x04 \x01(\bH\x00R\x0fmatchesAllVulnsB\r\n" +
	"\vvuln_filter\"3\n" +
	"\x0fVulnIdentifiers\x12 \n" +
	"\videntifiers\x18\x01 \x03(\tR\videntifiers\"v\n" +
	"\x1bFindingExploitabilitySignal\x12\x16\n" +
	"\x06plugin\x18\x01 \x01(\tR\x06plugin\x12?\n" +
	"\rjustification\x18\x02 \x01(\x0e2\x19.scalibr.VexJustificationR\rjustification\"\xc8\x01\n" +
	"\x04Purl\x12\x12\n" +
	"\x04purl\x18\x01 \x01(\tR\x04purl\x12\x12\n" +
	"\x04type\x18\x02 \x01(\tR\x04type\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x04 \x01(\tR\aversion\x12\x1c\n" +
	"\tnamespace\x18\x05 \x01(\tR\tnamespace\x122\n" +
	"\n" +
	"qualifiers\x18\x06 \x03(\v2\x12.scalibr.QualifierR\n" +
	"qualifiers\x12\x18\n" +
	"\asubpath\x18\a \x01(\tR\asubpath\"3\n" +
	"\tQualifier\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\"\xfe\x01\n" +
	"\x0eGenericFinding\x121\n" +
	"\x03adv\x18\x01 \x01(\v2\x1f.scalibr.GenericFindingAdvisoryR\x03adv\x12<\n" +
	"\x06target\x18\x02 \x01(\v2$.scalibr.GenericFindingTargetDetailsR\x06target\x12\x18\n" +
	"\aplugins\x18\x04 \x03(\tR\aplugins\x12[\n" +
	"\x16exploitability_signals\x18\x05 \x03(\v2$.scalibr.FindingExploitabilitySignalR\x15exploitabilitySignalsJ\x04\b\x03\x10\x04\"\xd2\x01\n" +
	"\x16GenericFindingAdvisory\x12#\n" +
	"\x02id\x18\x01 \x01(\v2\x13.scalibr.AdvisoryIdR\x02id\x12\x14\n" +
	"\x05title\x18\x03 \x01(\tR\x05title\x12 \n" +
	"\vdescription\x18\x04 \x01(\tR\vdescription\x12&\n" +
	"\x0erecommendation\x18\x05 \x01(\tR\x0erecommendation\x12'\n" +
	"\x03sev\x18\a \x01(\x0e2\x15.scalibr.SeverityEnumR\x03sevJ\x04\b\x02\x10\x03J\x04\b\x06\x10\a\"H\n" +
	"\n" +
	"AdvisoryId\x12\x1c\n" +
	"\tpublisher\x18\x01 \x01(\tR\tpublisher\x12\x1c\n" +
	"\treference\x18\x02 \x01(\tR\treference\"E\n" +
	"\x1bGenericFindingTargetDetails\x12\x14\n" +
	"\x05extra\x18\x04 \x01(\tR\x05extraJ\x04\b\x01\x10\x02J\x04\b\x02\x10\x03J\x04\b\x03\x10\x04\"R\n" +
	"\x15PythonPackageMetadata\x12\x16\n" +
	"\x06author\x18\x01 \x01(\tR\x06author\x12!\n" +
	"\fauthor_email\x18\x02 \x01(\tR\vauthorEmail\"\xad\x01\n" +
	"\x1dJavascriptPackageJSONMetadata\x12\x16\n" +
	"\x06author\x18\x01 \x01(\tR\x06author\x12 \n" +
	"\vmaintainers\x18\x02 \x03(\tR\vmaintainers\x12\"\n" +
	"\fcontributors\x18\x03 \x03(\tR\fcontributors\x12.\n" +
	"\x13from_npm_repository\x18\x04 \x01(\bR\x11fromNpmRepository\"\xef\x01\n" +
	"\x12APKPackageMetadata\x12!\n" +
	"\fpackage_name\x18\x01 \x01(\tR\vpackageName\x12\x1f\n" +
	"\vorigin_name\x18\x02 \x01(\tR\n" +
	"originName\x12\x13\n" +
	"\x05os_id\x18\x03 \x01(\tR\x04osId\x12\"\n" +
	"\ros_version_id\x18\x04 \x01(\tR\vosVersionId\x12\x1e\n" +
	"\n" +
	"maintainer\x18\x05 \x01(\tR\n" +
	"maintainer\x12\"\n" +
	"\farchitecture\x18\x06 \x01(\tR\farchitecture\x12\x18\n" +
	"\alicense\x18\a \x01(\tR\alicense\"\xee\x02\n" +
	"\x13DPKGPackageMetadata\x12!\n" +
	"\fpackage_name\x18\x01 \x01(\tR\vpackageName\x12\x1f\n" +
	"\vsource_name\x18\x02 \x01(\tR\n" +
	"sourceName\x12%\n" +
	"\x0esource_version\x18\x03 \x01(\tR\rsourceVersion\x12'\n" +
	"\x0fpackage_version\x18\x04 \x01(\tR\x0epackageVersion\x12\x13\n" +
	"\x05os_id\x18\x05 \x01(\tR\x04osId\x12.\n" +
	"\x13os_version_codename\x18\x06 \x01(\tR\x11osVersionCodename\x12\"\n" +
	"\ros_version_id\x18\a \x01(\tR\vosVersionId\x12\x1e\n" +
	"\n" +
	"maintainer\x18\b \x01(\tR\n" +
	"maintainer\x12\"\n" +
	"\farchitecture\x18\t \x01(\tR\farchitecture\x12\x16\n" +
	"\x06status\x18\n" +
	" \x01(\tR\x06status\"\xb4\x02\n" +
	"\x12RPMPackageMetadata\x12!\n" +
	"\fpackage_name\x18\x01 \x01(\tR\vpackageName\x12\x1d\n" +
	"\n" +
	"source_rpm\x18\x02 \x01(\tR\tsourceRpm\x12\x14\n" +
	"\x05epoch\x18\x03 \x01(\x05R\x05epoch\x12\x13\n" +
	"\x05os_id\x18\x04 \x01(\tR\x04osId\x12\"\n" +
	"\ros_version_id\x18\x05 \x01(\tR\vosVersionId\x12\x1e\n" +
	"\vos_build_id\x18\x06 \x01(\tR\tosBuildId\x12\x17\n" +
	"\aos_name\x18\a \x01(\tR\x06osName\x12\x16\n" +
	"\x06vendor\x18\b \x01(\tR\x06vendor\x12\"\n" +
	"\farchitecture\x18\t \x01(\tR\farchitecture\x12\x18\n" +
	"\alicense\x18\n" +
	" \x01(\tR\alicense\"\xc8\x01\n" +
	"\x12COSPackageMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12\x1a\n" +
	"\bcategory\x18\x03 \x01(\tR\bcategory\x12\x1d\n" +
	"\n" +
	"os_version\x18\x04 \x01(\tR\tosVersion\x12\"\n" +
	"\ros_version_id\x18\x05 \x01(\tR\vosVersionId\x12%\n" +
	"\x0eebuild_version\x18\x06 \x01(\tR\rebuildVersion\"\x80\x02\n" +
	"\x15PACMANPackageMetadata\x12!\n" +
	"\fpackage_name\x18\x01 \x01(\tR\vpackageName\x12'\n" +
	"\x0fpackage_version\x18\x02 \x01(\tR\x0epackageVersion\x12\x13\n" +
	"\x05os_id\x18\x03 \x01(\tR\x04osId\x12\"\n" +
	"\ros_version_id\x18\x04 \x01(\tR\vosVersionId\x12/\n" +
	"\x13package_description\x18\x05 \x01(\tR\x12packageDescription\x121\n" +
	"\x14package_dependencies\x18\x06 \x01(\tR\x13packageDependencies\"\x93\x02\n" +
	"\x12NixPackageMetadata\x12!\n" +
	"\fpackage_name\x18\x01 \x01(\tR\vpackageName\x12'\n" +
	"\x0fpackage_version\x18\x02 \x01(\tR\x0epackageVersion\x12!\n" +
	"\fpackage_hash\x18\x03 \x01(\tR\vpackageHash\x12%\n" +
	"\x0epackage_output\x18\x04 \x01(\tR\rpackageOutput\x12\x13\n" +
	"\x05os_id\x18\x05 \x01(\tR\x04osId\x12.\n" +
	"\x13os_version_codename\x18\x06 \x01(\tR\x11osVersionCodename\x12\"\n" +
	"\ros_version_id\x18\a \x01(\tR\vosVersionId\"r\n" +
	"\x10DEPSJSONMetadata\x12!\n" +
	"\fpackage_name\x18\x01 \x01(\tR\vpackageName\x12'\n" +
	"\x0fpackage_version\x18\x02 \x01(\tR\x0epackageVersion\x12\x12\n" +
	"\x04type\x18\x03 \x01(\tR\x04type\"\xfc\x01\n" +
	"\x13SNAPPackageMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12\x14\n" +
	"\x05grade\x18\x03 \x01(\tR\x05grade\x12\x12\n" +
	"\x04type\x18\x04 \x01(\tR\x04type\x12$\n" +
	"\rarchitectures\x18\x05 \x03(\tR\rarchitectures\x12\x13\n" +
	"\x05os_id\x18\x06 \x01(\tR\x04osId\x12.\n" +
	"\x13os_version_codename\x18\a \x01(\tR\x11osVersionCodename\x12\"\n" +
	"\ros_version_id\x18\b \x01(\tR\vosVersionId\"\x9d\x01\n" +
	"\x16PortagePackageMetadata\x12!\n" +
	"\fpackage_name\x18\x01 \x01(\tR\vpackageName\x12'\n" +
	"\x0fpackage_version\x18\x02 \x01(\tR\x0epackageVersion\x12\x13\n" +
	"\x05os_id\x18\x03 \x01(\tR\x04osId\x12\"\n" +
	"\ros_version_id\x18\x04 \x01(\tR\vosVersionId\"\xb6\x02\n" +
	"\x16FlatpakPackageMetadata\x12!\n" +
	"\fpackage_name\x18\x01 \x01(\tR\vpackageName\x12\x1d\n" +
	"\n" +
	"package_id\x18\x02 \x01(\tR\tpackageId\x12'\n" +
	"\x0fpackage_version\x18\x03 \x01(\tR\x0epackageVersion\x12!\n" +
	"\frelease_date\x18\x04 \x01(\tR\vreleaseDate\x12\x17\n" +
	"\aos_name\x18\x05 \x01(\tR\x06osName\x12\x13\n" +
	"\x05os_id\x18\x06 \x01(\tR\x04osId\x12\"\n" +
	"\ros_version_id\x18\a \x01(\tR\vosVersionId\x12\x1e\n" +
	"\vos_build_id\x18\b \x01(\tR\tosBuildId\x12\x1c\n" +
	"\tdeveloper\x18\t \x01(\tR\tdeveloper\"\xe8\x02\n" +
	"\x14KernelModuleMetadata\x12!\n" +
	"\fpackage_name\x18\x01 \x01(\tR\vpackageName\x12'\n" +
	"\x0fpackage_version\x18\x02 \x01(\tR\x0epackageVersion\x12)\n" +
	"\x10package_vermagic\x18\x03 \x01(\tR\x0fpackageVermagic\x12I\n" +
	"!package_source_version_identifier\x18\x04 \x01(\tR\x1epackageSourceVersionIdentifier\x12\x13\n" +
	"\x05os_id\x18\x05 \x01(\tR\x04osId\x12.\n" +
	"\x13os_version_codename\x18\x06 \x01(\tR\x11osVersionCodename\x12\"\n" +
	"\ros_version_id\x18\a \x01(\tR\vosVersionId\x12%\n" +
	"\x0epackage_author\x18\b \x01(\tR\rpackageAuthor\"\x8e\x03\n" +
	"\x0fVmlinuzMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12\"\n" +
	"\farchitecture\x18\x03 \x01(\tR\farchitecture\x12)\n" +
	"\x10extended_version\x18\x04 \x01(\tR\x0fextendedVersion\x12\x16\n" +
	"\x06format\x18\x05 \x01(\tR\x06format\x12\x1f\n" +
	"\vswap_device\x18\x06 \x01(\x05R\n" +
	"swapDevice\x12\x1f\n" +
	"\vroot_device\x18\a \x01(\x05R\n" +
	"rootDevice\x12\x1d\n" +
	"\n" +
	"video_mode\x18\b \x01(\tR\tvideoMode\x12\x13\n" +
	"\x05os_id\x18\t \x01(\tR\x04osId\x12.\n" +
	"\x13os_version_codename\x18\n" +
	" \x01(\tR\x11osVersionCodename\x12\"\n" +
	"\ros_version_id\x18\v \x01(\tR\vosVersionId\x12\x1c\n" +
	"\n" +
	"rw_root_fs\x18\f \x01(\bR\brwRootFs\"\xbb\x03\n" +
	"\x0fMacAppsMetadata\x12.\n" +
	"\x13bundle_display_name\x18\x01 \x01(\tR\x11bundleDisplayName\x12+\n" +
	"\x11bundle_identifier\x18\x02 \x01(\tR\x10bundleIdentifier\x12=\n" +
	"\x1bbundle_short_version_string\x18\x03 \x01(\tR\x18bundleShortVersionString\x12+\n" +
	"\x11bundle_executable\x18\x04 \x01(\tR\x10bundleExecutable\x12\x1f\n" +
	"\vbundle_name\x18\x05 \x01(\tR\n" +
	"bundleName\x12.\n" +
	"\x13bundle_package_type\x18\x06 \x01(\tR\x11bundlePackageType\x12)\n" +
	"\x10bundle_signature\x18\a \x01(\tR\x0fbundleSignature\x12%\n" +
	"\x0ebundle_version\x18\b \x01(\tR\rbundleVersion\x12\x1d\n" +
	"\n" +
	"product_id\x18\t \x01(\tR\tproductId\x12\x1d\n" +
	"\n" +
	"update_url\x18\n" +
	" \x01(\tR\tupdateUrl\"L\n" +
	"\x13SPDXPackageMetadata\x12!\n" +
	"\x04purl\x18\x01 \x01(\v2\r.scalibr.PurlR\x04purl\x12\x12\n" +
	"\x04cpes\x18\x02 \x03(\tR\x04cpes\"K\n" +
	"\x12CDXPackageMetadata\x12!\n" +
	"\x04purl\x18\x01 \x01(\v2\r.scalibr.PurlR\x04purl\x12\x12\n" +
	"\x04cpes\x18\x02 \x03(\tR\x04cpes\"e\n" +
	"\x13JavaArchiveMetadata\x12\x1f\n" +
	"\vartifact_id\x18\x02 \x01(\tR\n" +
	"artifactId\x12\x19\n" +
	"\bgroup_id\x18\x03 \x01(\tR\agroupId\x12\x12\n" +
	"\x04sha1\x18\x04 \x01(\tR\x04sha1\"\x9d\x01\n" +
	"\x14JavaLockfileMetadata\x12\x1f\n" +
	"\vartifact_id\x18\x01 \x01(\tR\n" +
	"artifactId\x12\x19\n" +
	"\bgroup_id\x18\x02 \x01(\tR\agroupId\x12$\n" +
	"\x0edep_group_vals\x18\x03 \x03(\tR\fdepGroupVals\x12#\n" +
	"\ris_transitive\x18\x04 \x01(\bR\fisTransitive\"\x86\x01\n" +
	"\x12OSVPackageMetadata\x12\x1b\n" +
	"\tpurl_type\x18\x01 \x01(\tR\bpurlType\x12\x16\n" +
	"\x06commit\x18\x02 \x01(\tR\x06commit\x12\x1c\n" +
	"\tecosystem\x18\x03 \x01(\tR\tecosystem\x12\x1d\n" +
	"\n" +
	"compare_as\x18\x04 \x01(\tR\tcompareAs\"\xa8\x01\n" +
	"\x1aPythonRequirementsMetadata\x129\n" +
	"\x19hash_checking_mode_values\x18\x01 \x03(\tR\x16hashCheckingModeValues\x12-\n" +
	"\x12version_comparator\x18\x02 \x01(\tR\x11versionComparator\x12 \n" +
	"\vrequirement\x18\x03 \x01(\tR\vrequirement\"D\n" +
	"\x13PythonSetupMetadata\x12-\n" +
	"\x12version_comparator\x18\x02 \x01(\tR\x11versionComparator\"e\n" +
	"\x10NetportsMetadata\x12\x12\n" +
	"\x04port\x18\x01 \x01(\rR\x04port\x12\x1a\n" +
	"\bprotocol\x18\x02 \x01(\tR\bprotocol\x12!\n" +
	"\fcommand_line\x18\x03 \x01(\tR\vcommandLine\"\x9c\x03\n" +
	"\x1bContainerdContainerMetadata\x12%\n" +
	"\x0enamespace_name\x18\x01 \x01(\tR\rnamespaceName\x12\x1d\n" +
	"\n" +
	"image_name\x18\x02 \x01(\tR\timageName\x12!\n" +
	"\fimage_digest\x18\x03 \x01(\tR\vimageDigest\x12\x18\n" +
	"\aruntime\x18\x04 \x01(\tR\aruntime\x12\x10\n" +
	"\x03pid\x18\x05 \x01(\x05R\x03pid\x12 \n" +
	"\vsnapshotter\x18\x06 \x01(\tR\vsnapshotter\x12!\n" +
	"\fsnapshot_key\x18\a \x01(\tR\vsnapshotKey\x12\x1b\n" +
	"\tlower_dir\x18\b \x01(\tR\blowerDir\x12\x1b\n" +
	"\tupper_dir\x18\t \x01(\tR\bupperDir\x12\x19\n" +
	"\bwork_dir\x18\n" +
	" \x01(\tR\aworkDir\x12\x0e\n" +
	"\x02id\x18\v \x01(\tR\x02id\x12\x19\n" +
	"\bpod_name\x18\f \x01(\tR\apodName\x12#\n" +
	"\rpod_namespace\x18\r \x01(\tR\fpodNamespace\"\xea\x01\n" +
	"\"ContainerdRuntimeContainerMetadata\x12%\n" +
	"\x0enamespace_name\x18\x01 \x01(\tR\rnamespaceName\x12\x1d\n" +
	"\n" +
	"image_name\x18\x02 \x01(\tR\timageName\x12!\n" +
	"\fimage_digest\x18\x03 \x01(\tR\vimageDigest\x12\x18\n" +
	"\aruntime\x18\x04 \x01(\tR\aruntime\x12\x0e\n" +
	"\x02id\x18\x05 \x01(\tR\x02id\x12\x10\n" +
	"\x03pid\x18\x06 \x01(\x05R\x03pid\x12\x1f\n" +
	"\vrootfs_path\x18\a \x01(\tR\n" +
	"rootfsPath\"O\n" +
	"\x10WindowsOSVersion\x12\x18\n" +
	"\aproduct\x18\x01 \x01(\tR\aproduct\x12!\n" +
	"\ffull_version\x18\x02 \x01(\tR\vfullVersion\"\x19\n" +
	"\x17HomebrewPackageMetadata\"\xc0\x02\n" +
	"\x18ChromeExtensionsMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12!\n" +
	"\fauthor_email\x18\x03 \x01(\tR\vauthorEmail\x12)\n" +
	"\x10host_permissions\x18\x04 \x03(\tR\x0fhostPermissions\x12)\n" +
	"\x10manifest_version\x18\x05 \x01(\x05R\x0fmanifestVersion\x124\n" +
	"\x16minimum_chrome_version\x18\x06 \x01(\tR\x14minimumChromeVersion\x12 \n" +
	"\vpermissions\x18\a \x03(\tR\vpermissions\x12\x1d\n" +
	"\n" +
	"update_url\x18\b \x01(\tR\tupdateUrl\"\xac\x02\n" +
	"\x18VSCodeExtensionsMetadata\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12!\n" +
	"\fpublisher_id\x18\x02 \x01(\tR\vpublisherId\x124\n" +
	"\x16publisher_display_name\x18\x03 \x01(\tR\x14publisherDisplayName\x12'\n" +
	"\x0ftarget_platform\x18\x04 \x01(\tR\x0etargetPlatform\x12\x18\n" +
	"\aupdated\x18\x05 \x01(\bR\aupdated\x123\n" +
	"\x16is_pre_release_version\x18\x06 \x01(\bR\x13isPreReleaseVersion\x12/\n" +
	"\x13installed_timestamp\x18\a \x01(\x03R\x12installedTimestamp\"\xba\x03\n" +
	"\x0ePodmanMetadata\x12N\n" +
	"\rexposed_ports\x18\x01 \x03(\v2).scalibr.PodmanMetadata.ExposedPortsEntryR\fexposedPorts\x12\x10\n" +
	"\x03pid\x18\x02 \x01(\x05R\x03pid\x12%\n" +
	"\x0enamespace_name\x18\x03 \x01(\tR\rnamespaceName\x12=\n" +
	"\fstarted_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\vstartedTime\x12?\n" +
	"\rfinished_time\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\ffinishedTime\x12\x16\n" +
	"\x06status\x18\x06 \x01(\tR\x06status\x12\x1b\n" +
	"\texit_code\x18\a \x01(\x05R\bexitCode\x12\x16\n" +
	"\x06exited\x18\b \x01(\bR\x06exited\x1aR\n" +
	"\x11ExposedPortsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\rR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.scalibr.ProtocolR\x05value:\x028\x01\" \n" +
	"\bProtocol\x12\x14\n" +
	"\x05names\x18\x01 \x03(\tR\x05names\"\x97\x01\n" +
	"\x18DockerContainersMetadata\x12\x1d\n" +
	"\n" +
	"image_name\x18\x01 \x01(\tR\timageName\x12!\n" +
	"\fimage_digest\x18\x02 \x01(\tR\vimageDigest\x12\x0e\n" +
	"\x02id\x18\x03 \x01(\tR\x02id\x12)\n" +
	"\x05ports\x18\x04 \x03(\v2\x13.scalibr.DockerPortR\x05ports\"t\n" +
	"\n" +
	"DockerPort\x12\x0e\n" +
	"\x02ip\x18\x01 \x01(\tR\x02ip\x12!\n" +
	"\fprivate_port\x18\x02 \x01(\rR\vprivatePort\x12\x1f\n" +
	"\vpublic_port\x18\x03 \x01(\rR\n" +
	"publicPort\x12\x12\n" +
	"\x04type\x18\x04 \x01(\tR\x04type\"\x95\x01\n" +
	"\x06Secret\x12+\n" +
	"\x06secret\x18\x01 \x01(\v2\x13.scalibr.SecretDataR\x06secret\x12-\n" +
	"\x06status\x18\x02 \x01(\v2\x15.scalibr.SecretStatusR\x06status\x12/\n" +
	"\tlocations\x18\x03 \x03(\v2\x11.scalibr.LocationR\tlocations\"\xff\x03\n" +
	"\n" +
	"SecretData\x124\n" +
	"\x06gcpsak\x18\x01 \x01(\v2\x1a.scalibr.SecretData.GCPSAKH\x00R\x06gcpsak\x1a\xb0\x03\n" +
	"\x06GCPSAK\x12$\n" +
	"\x0eprivate_key_id\x18\x01 \x01(\tR\fprivateKeyId\x12!\n" +
	"\fclient_email\x18\x02 \x01(\tR\vclientEmail\x12\x1c\n" +
	"\tsignature\x18\x03 \x01(\fR\tsignature\x12\x12\n" +
	"\x04type\x18\x04 \x01(\tR\x04type\x12\x1d\n" +
	"\n" +
	"project_id\x18\x05 \x01(\tR\tprojectId\x12\x1b\n" +
	"\tclient_id\x18\x06 \x01(\tR\bclientId\x12\x19\n" +
	"\bauth_uri\x18\a \x01(\tR\aauthUri\x12\x1b\n" +
	"\ttoken_uri\x18\b \x01(\tR\btokenUri\x12<\n" +
	"\x1bauth_provider_x509_cert_url\x18\t \x01(\tR\x17authProviderX509CertUrl\x12/\n" +
	"\x14client_x509_cert_url\x18\n" +
	" \x01(\tR\x11clientX509CertUrl\x12'\n" +
	"\x0funiverse_domain\x18\v \x01(\tR\x0euniverseDomain\x12\x1f\n" +
	"\vprivate_key\x18\f \x01(\tR\n" +
	"privateKeyB\b\n" +
	"\x06secret\"\xf8\x01\n" +
	"\fSecretStatus\x12>\n" +
	"\x06status\x18\x01 \x01(\x0e2&.scalibr.SecretStatus.SecretStatusEnumR\x06status\x12=\n" +
	"\flast_updated\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\vlastUpdated\"i\n" +
	"\x10SecretStatusEnum\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\x0f\n" +
	"\aUNKNOWN\x10\x01\x1a\x02\b\x01\x12\v\n" +
	"\aINVALID\x10\x02\x12\t\n" +
	"\x05VALID\x10\x03\x12\x0f\n" +
	"\vUNSUPPORTED\x10\x04\x12\n" +
	"\n" +
	"\x06FAILED\x10\x05\"\xc8\x02\n" +
	"\bLocation\x12/\n" +
	"\bfilepath\x18\x01 \x01(\v2\x11.scalibr.FilepathH\x00R\bfilepath\x12b\n" +
	"\x1bfilepath_with_layer_details\x18\x02 \x01(\v2!.scalibr.FilepathWithLayerDetailsH\x00R\x18filepathWithLayerDetails\x12Q\n" +
	"\x14environment_variable\x18\x03 \x01(\v2\x1c.scalibr.EnvironmentVariableH\x00R\x13environmentVariable\x12H\n" +
	"\x11container_command\x18\x04 \x01(\v2\x19.scalibr.ContainerCommandH\x00R\x10containerCommandB\n" +
	"\n" +
	"\blocation\"\x1e\n" +
	"\bFilepath\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\"j\n" +
	"\x18FilepathWithLayerDetails\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x12:\n" +
	"\rlayer_details\x18\x02 \x01(\v2\x15.scalibr.LayerDetailsR\flayerDetails\")\n" +
	"\x13EnvironmentVariable\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\",\n" +
	"\x10ContainerCommand\x12\x18\n" +
	"\acommand\x18\x01 \x01(\tR\acommand*\xf7\x01\n" +
	"\x10VexJustification\x12!\n" +
	"\x1dVEX_JUSTIFICATION_UNSPECIFIED\x10\x00\x12\x19\n" +
	"\x15COMPONENT_NOT_PRESENT\x10\x01\x12\x1f\n" +
	"\x1bVULNERABLE_CODE_NOT_PRESENT\x10\x02\x12'\n" +
	"#VULNERABLE_CODE_NOT_IN_EXECUTE_PATH\x10\x03\x125\n" +
	"1VULNERABLE_CODE_CANNOT_BE_CONTROLLED_BY_ADVERSARY\x10\x04\x12$\n" +
	" INLINE_MITIGATION_ALREADY_EXISTS\x10\x05*b\n" +
	"\fSeverityEnum\x12\x18\n" +
	"\x14SEVERITY_UNSPECIFIED\x10\x00\x12\v\n" +
	"\aMINIMAL\x10\x01\x12\a\n" +
	"\x03LOW\x10\x02\x12\n" +
	"\n" +
	"\x06MEDIUM\x10\x03\x12\b\n" +
	"\x04HIGH\x10\x04\x12\f\n" +
	"\bCRITICAL\x10\x05B?P\x01Z;github.com/google/scalibr/binary/proto/scan_result_go_protob\x06proto3"

var (
	file_proto_scan_result_proto_rawDescOnce sync.Once
	file_proto_scan_result_proto_rawDescData []byte
)

func file_proto_scan_result_proto_rawDescGZIP() []byte {
	file_proto_scan_result_proto_rawDescOnce.Do(func() {
		file_proto_scan_result_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_proto_scan_result_proto_rawDesc), len(file_proto_scan_result_proto_rawDesc)))
	})
	return file_proto_scan_result_proto_rawDescData
}

var file_proto_scan_result_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_proto_scan_result_proto_msgTypes = make([]protoimpl.MessageInfo, 59)
var file_proto_scan_result_proto_goTypes = []any{
	(VexJustification)(0),                      // 0: scalibr.VexJustification
	(SeverityEnum)(0),                          // 1: scalibr.SeverityEnum
	(ScanStatus_ScanStatusEnum)(0),             // 2: scalibr.ScanStatus.ScanStatusEnum
	(Package_AnnotationEnum)(0),                // 3: scalibr.Package.AnnotationEnum
	(SecretStatus_SecretStatusEnum)(0),         // 4: scalibr.SecretStatus.SecretStatusEnum
	(*ScanResult)(nil),                         // 5: scalibr.ScanResult
	(*Inventory)(nil),                          // 6: scalibr.Inventory
	(*ScanStatus)(nil),                         // 7: scalibr.ScanStatus
	(*PluginStatus)(nil),                       // 8: scalibr.PluginStatus
	(*Package)(nil),                            // 9: scalibr.Package
	(*SourceCodeIdentifier)(nil),               // 10: scalibr.SourceCodeIdentifier
	(*LayerDetails)(nil),                       // 11: scalibr.LayerDetails
	(*PackageExploitabilitySignal)(nil),        // 12: scalibr.PackageExploitabilitySignal
	(*VulnIdentifiers)(nil),                    // 13: scalibr.VulnIdentifiers
	(*FindingExploitabilitySignal)(nil),        // 14: scalibr.FindingExploitabilitySignal
	(*Purl)(nil),                               // 15: scalibr.Purl
	(*Qualifier)(nil),                          // 16: scalibr.Qualifier
	(*GenericFinding)(nil),                     // 17: scalibr.GenericFinding
	(*GenericFindingAdvisory)(nil),             // 18: scalibr.GenericFindingAdvisory
	(*AdvisoryId)(nil),                         // 19: scalibr.AdvisoryId
	(*GenericFindingTargetDetails)(nil),        // 20: scalibr.GenericFindingTargetDetails
	(*PythonPackageMetadata)(nil),              // 21: scalibr.PythonPackageMetadata
	(*JavascriptPackageJSONMetadata)(nil),      // 22: scalibr.JavascriptPackageJSONMetadata
	(*APKPackageMetadata)(nil),                 // 23: scalibr.APKPackageMetadata
	(*DPKGPackageMetadata)(nil),                // 24: scalibr.DPKGPackageMetadata
	(*RPMPackageMetadata)(nil),                 // 25: scalibr.RPMPackageMetadata
	(*COSPackageMetadata)(nil),                 // 26: scalibr.COSPackageMetadata
	(*PACMANPackageMetadata)(nil),              // 27: scalibr.PACMANPackageMetadata
	(*NixPackageMetadata)(nil),                 // 28: scalibr.NixPackageMetadata
	(*DEPSJSONMetadata)(nil),                   // 29: scalibr.DEPSJSONMetadata
	(*SNAPPackageMetadata)(nil),                // 30: scalibr.SNAPPackageMetadata
	(*PortagePackageMetadata)(nil),             // 31: scalibr.PortagePackageMetadata
	(*FlatpakPackageMetadata)(nil),             // 32: scalibr.FlatpakPackageMetadata
	(*KernelModuleMetadata)(nil),               // 33: scalibr.KernelModuleMetadata
	(*VmlinuzMetadata)(nil),                    // 34: scalibr.VmlinuzMetadata
	(*MacAppsMetadata)(nil),                    // 35: scalibr.MacAppsMetadata
	(*SPDXPackageMetadata)(nil),                // 36: scalibr.SPDXPackageMetadata
	(*CDXPackageMetadata)(nil),                 // 37: scalibr.CDXPackageMetadata
	(*JavaArchiveMetadata)(nil),                // 38: scalibr.JavaArchiveMetadata
	(*JavaLockfileMetadata)(nil),               // 39: scalibr.JavaLockfileMetadata
	(*OSVPackageMetadata)(nil),                 // 40: scalibr.OSVPackageMetadata
	(*PythonRequirementsMetadata)(nil),         // 41: scalibr.PythonRequirementsMetadata
	(*PythonSetupMetadata)(nil),                // 42: scalibr.PythonSetupMetadata
	(*NetportsMetadata)(nil),                   // 43: scalibr.NetportsMetadata
	(*ContainerdContainerMetadata)(nil),        // 44: scalibr.ContainerdContainerMetadata
	(*ContainerdRuntimeContainerMetadata)(nil), // 45: scalibr.ContainerdRuntimeContainerMetadata
	(*WindowsOSVersion)(nil),                   // 46: scalibr.WindowsOSVersion
	(*HomebrewPackageMetadata)(nil),            // 47: scalibr.HomebrewPackageMetadata
	(*ChromeExtensionsMetadata)(nil),           // 48: scalibr.ChromeExtensionsMetadata
	(*VSCodeExtensionsMetadata)(nil),           // 49: scalibr.VSCodeExtensionsMetadata
	(*PodmanMetadata)(nil),                     // 50: scalibr.PodmanMetadata
	(*Protocol)(nil),                           // 51: scalibr.Protocol
	(*DockerContainersMetadata)(nil),           // 52: scalibr.DockerContainersMetadata
	(*DockerPort)(nil),                         // 53: scalibr.DockerPort
	(*Secret)(nil),                             // 54: scalibr.Secret
	(*SecretData)(nil),                         // 55: scalibr.SecretData
	(*SecretStatus)(nil),                       // 56: scalibr.SecretStatus
	(*Location)(nil),                           // 57: scalibr.Location
	(*Filepath)(nil),                           // 58: scalibr.Filepath
	(*FilepathWithLayerDetails)(nil),           // 59: scalibr.FilepathWithLayerDetails
	(*EnvironmentVariable)(nil),                // 60: scalibr.EnvironmentVariable
	(*ContainerCommand)(nil),                   // 61: scalibr.ContainerCommand
	nil,                                        // 62: scalibr.PodmanMetadata.ExposedPortsEntry
	(*SecretData_GCPSAK)(nil),                  // 63: scalibr.SecretData.GCPSAK
	(*timestamppb.Timestamp)(nil),              // 64: google.protobuf.Timestamp
}
var file_proto_scan_result_proto_depIdxs = []int32{
	64, // 0: scalibr.ScanResult.start_time:type_name -> google.protobuf.Timestamp
	64, // 1: scalibr.ScanResult.end_time:type_name -> google.protobuf.Timestamp
	7,  // 2: scalibr.ScanResult.status:type_name -> scalibr.ScanStatus
	8,  // 3: scalibr.ScanResult.plugin_status:type_name -> scalibr.PluginStatus
	9,  // 4: scalibr.ScanResult.inventories_deprecated:type_name -> scalibr.Package
	17, // 5: scalibr.ScanResult.findings_deprecated:type_name -> scalibr.GenericFinding
	6,  // 6: scalibr.ScanResult.inventory:type_name -> scalibr.Inventory
	9,  // 7: scalibr.Inventory.packages:type_name -> scalibr.Package
	17, // 8: scalibr.Inventory.generic_findings:type_name -> scalibr.GenericFinding
	54, // 9: scalibr.Inventory.secrets:type_name -> scalibr.Secret
	2,  // 10: scalibr.ScanStatus.status:type_name -> scalibr.ScanStatus.ScanStatusEnum
	7,  // 11: scalibr.PluginStatus.status:type_name -> scalibr.ScanStatus
	10, // 12: scalibr.Package.source_code:type_name -> scalibr.SourceCodeIdentifier
	15, // 13: scalibr.Package.purl:type_name -> scalibr.Purl
	21, // 14: scalibr.Package.python_metadata:type_name -> scalibr.PythonPackageMetadata
	22, // 15: scalibr.Package.javascript_metadata:type_name -> scalibr.JavascriptPackageJSONMetadata
	23, // 16: scalibr.Package.apk_metadata:type_name -> scalibr.APKPackageMetadata
	24, // 17: scalibr.Package.dpkg_metadata:type_name -> scalibr.DPKGPackageMetadata
	25, // 18: scalibr.Package.rpm_metadata:type_name -> scalibr.RPMPackageMetadata
	26, // 19: scalibr.Package.cos_metadata:type_name -> scalibr.COSPackageMetadata
	29, // 20: scalibr.Package.depsjson_metadata:type_name -> scalibr.DEPSJSONMetadata
	36, // 21: scalibr.Package.spdx_metadata:type_name -> scalibr.SPDXPackageMetadata
	38, // 22: scalibr.Package.java_archive_metadata:type_name -> scalibr.JavaArchiveMetadata
	39, // 23: scalibr.Package.java_lockfile_metadata:type_name -> scalibr.JavaLockfileMetadata
	27, // 24: scalibr.Package.pacman_metadata:type_name -> scalibr.PACMANPackageMetadata
	28, // 25: scalibr.Package.nix_metadata:type_name -> scalibr.NixPackageMetadata
	33, // 26: scalibr.Package.kernel_module_metadata:type_name -> scalibr.KernelModuleMetadata
	34, // 27: scalibr.Package.vmlinuz_metadata:type_name -> scalibr.VmlinuzMetadata
	31, // 28: scalibr.Package.portage_metadata:type_name -> scalibr.PortagePackageMetadata
	40, // 29: scalibr.Package.osv_metadata:type_name -> scalibr.OSVPackageMetadata
	43, // 30: scalibr.Package.netports_metadata:type_name -> scalibr.NetportsMetadata
	41, // 31: scalibr.Package.python_requirements_metadata:type_name -> scalibr.PythonRequirementsMetadata
	42, // 32: scalibr.Package.python_setup_metadata:type_name -> scalibr.PythonSetupMetadata
	44, // 33: scalibr.Package.containerd_container_metadata:type_name -> scalibr.ContainerdContainerMetadata
	30, // 34: scalibr.Package.snap_metadata:type_name -> scalibr.SNAPPackageMetadata
	32, // 35: scalibr.Package.flatpak_metadata:type_name -> scalibr.FlatpakPackageMetadata
	35, // 36: scalibr.Package.mac_apps_metadata:type_name -> scalibr.MacAppsMetadata
	45, // 37: scalibr.Package.containerd_runtime_container_metadata:type_name -> scalibr.ContainerdRuntimeContainerMetadata
	37, // 38: scalibr.Package.cdx_metadata:type_name -> scalibr.CDXPackageMetadata
	46, // 39: scalibr.Package.windows_os_version_metadata:type_name -> scalibr.WindowsOSVersion
	47, // 40: scalibr.Package.homebrew_metadata:type_name -> scalibr.HomebrewPackageMetadata
	48, // 41: scalibr.Package.chrome_extensions_metadata:type_name -> scalibr.ChromeExtensionsMetadata
	49, // 42: scalibr.Package.vscode_extensions_metadata:type_name -> scalibr.VSCodeExtensionsMetadata
	50, // 43: scalibr.Package.podman_metadata:type_name -> scalibr.PodmanMetadata
	52, // 44: scalibr.Package.docker_containers_metadata:type_name -> scalibr.DockerContainersMetadata
	3,  // 45: scalibr.Package.annotations_deprecated:type_name -> scalibr.Package.AnnotationEnum
	12, // 46: scalibr.Package.exploitability_signals:type_name -> scalibr.PackageExploitabilitySignal
	11, // 47: scalibr.Package.layer_details:type_name -> scalibr.LayerDetails
	0,  // 48: scalibr.PackageExploitabilitySignal.justification:type_name -> scalibr.VexJustification
	13, // 49: scalibr.PackageExploitabilitySignal.vuln_identifiers:type_name -> scalibr.VulnIdentifiers
	0,  // 50: scalibr.FindingExploitabilitySignal.justification:type_name -> scalibr.VexJustification
	16, // 51: scalibr.Purl.qualifiers:type_name -> scalibr.Qualifier
	18, // 52: scalibr.GenericFinding.adv:type_name -> scalibr.GenericFindingAdvisory
	20, // 53: scalibr.GenericFinding.target:type_name -> scalibr.GenericFindingTargetDetails
	14, // 54: scalibr.GenericFinding.exploitability_signals:type_name -> scalibr.FindingExploitabilitySignal
	19, // 55: scalibr.GenericFindingAdvisory.id:type_name -> scalibr.AdvisoryId
	1,  // 56: scalibr.GenericFindingAdvisory.sev:type_name -> scalibr.SeverityEnum
	15, // 57: scalibr.SPDXPackageMetadata.purl:type_name -> scalibr.Purl
	15, // 58: scalibr.CDXPackageMetadata.purl:type_name -> scalibr.Purl
	62, // 59: scalibr.PodmanMetadata.exposed_ports:type_name -> scalibr.PodmanMetadata.ExposedPortsEntry
	64, // 60: scalibr.PodmanMetadata.started_time:type_name -> google.protobuf.Timestamp
	64, // 61: scalibr.PodmanMetadata.finished_time:type_name -> google.protobuf.Timestamp
	53, // 62: scalibr.DockerContainersMetadata.ports:type_name -> scalibr.DockerPort
	55, // 63: scalibr.Secret.secret:type_name -> scalibr.SecretData
	56, // 64: scalibr.Secret.status:type_name -> scalibr.SecretStatus
	57, // 65: scalibr.Secret.locations:type_name -> scalibr.Location
	63, // 66: scalibr.SecretData.gcpsak:type_name -> scalibr.SecretData.GCPSAK
	4,  // 67: scalibr.SecretStatus.status:type_name -> scalibr.SecretStatus.SecretStatusEnum
	64, // 68: scalibr.SecretStatus.last_updated:type_name -> google.protobuf.Timestamp
	58, // 69: scalibr.Location.filepath:type_name -> scalibr.Filepath
	59, // 70: scalibr.Location.filepath_with_layer_details:type_name -> scalibr.FilepathWithLayerDetails
	60, // 71: scalibr.Location.environment_variable:type_name -> scalibr.EnvironmentVariable
	61, // 72: scalibr.Location.container_command:type_name -> scalibr.ContainerCommand
	11, // 73: scalibr.FilepathWithLayerDetails.layer_details:type_name -> scalibr.LayerDetails
	51, // 74: scalibr.PodmanMetadata.ExposedPortsEntry.value:type_name -> scalibr.Protocol
	75, // [75:75] is the sub-list for method output_type
	75, // [75:75] is the sub-list for method input_type
	75, // [75:75] is the sub-list for extension type_name
	75, // [75:75] is the sub-list for extension extendee
	0,  // [0:75] is the sub-list for field type_name
}

func init() { file_proto_scan_result_proto_init() }
func file_proto_scan_result_proto_init() {
	if File_proto_scan_result_proto != nil {
		return
	}
	file_proto_scan_result_proto_msgTypes[4].OneofWrappers = []any{
		(*Package_PythonMetadata)(nil),
		(*Package_JavascriptMetadata)(nil),
		(*Package_ApkMetadata)(nil),
		(*Package_DpkgMetadata)(nil),
		(*Package_RpmMetadata)(nil),
		(*Package_CosMetadata)(nil),
		(*Package_DepsjsonMetadata)(nil),
		(*Package_SpdxMetadata)(nil),
		(*Package_JavaArchiveMetadata)(nil),
		(*Package_JavaLockfileMetadata)(nil),
		(*Package_PacmanMetadata)(nil),
		(*Package_NixMetadata)(nil),
		(*Package_KernelModuleMetadata)(nil),
		(*Package_VmlinuzMetadata)(nil),
		(*Package_PortageMetadata)(nil),
		(*Package_OsvMetadata)(nil),
		(*Package_NetportsMetadata)(nil),
		(*Package_PythonRequirementsMetadata)(nil),
		(*Package_PythonSetupMetadata)(nil),
		(*Package_ContainerdContainerMetadata)(nil),
		(*Package_SnapMetadata)(nil),
		(*Package_FlatpakMetadata)(nil),
		(*Package_MacAppsMetadata)(nil),
		(*Package_ContainerdRuntimeContainerMetadata)(nil),
		(*Package_CdxMetadata)(nil),
		(*Package_WindowsOsVersionMetadata)(nil),
		(*Package_HomebrewMetadata)(nil),
		(*Package_ChromeExtensionsMetadata)(nil),
		(*Package_VscodeExtensionsMetadata)(nil),
		(*Package_PodmanMetadata)(nil),
		(*Package_DockerContainersMetadata)(nil),
	}
	file_proto_scan_result_proto_msgTypes[7].OneofWrappers = []any{
		(*PackageExploitabilitySignal_VulnIdentifiers)(nil),
		(*PackageExploitabilitySignal_MatchesAllVulns)(nil),
	}
	file_proto_scan_result_proto_msgTypes[50].OneofWrappers = []any{
		(*SecretData_Gcpsak)(nil),
	}
	file_proto_scan_result_proto_msgTypes[52].OneofWrappers = []any{
		(*Location_Filepath)(nil),
		(*Location_FilepathWithLayerDetails)(nil),
		(*Location_EnvironmentVariable)(nil),
		(*Location_ContainerCommand)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_proto_scan_result_proto_rawDesc), len(file_proto_scan_result_proto_rawDesc)),
			NumEnums:      5,
			NumMessages:   59,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_proto_scan_result_proto_goTypes,
		DependencyIndexes: file_proto_scan_result_proto_depIdxs,
		EnumInfos:         file_proto_scan_result_proto_enumTypes,
		MessageInfos:      file_proto_scan_result_proto_msgTypes,
	}.Build()
	File_proto_scan_result_proto = out.File
	file_proto_scan_result_proto_goTypes = nil
	file_proto_scan_result_proto_depIdxs = nil
}
