// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/dialogflow/v2beta1/audio_config.proto

package dialogflow

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Audio encoding of the audio content sent in the conversational query request.
// Refer to the
// [Cloud Speech API
// documentation](https://cloud.google.com/speech-to-text/docs/basics) for more
// details.
type AudioEncoding int32

const (
	// Not specified.
	AudioEncoding_AUDIO_ENCODING_UNSPECIFIED AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	AudioEncoding_AUDIO_ENCODING_LINEAR_16 AudioEncoding = 1
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
	// Codec) is the recommended encoding because it is lossless (therefore
	// recognition is not compromised) and requires only about half the
	// bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
	// 24-bit samples, however, not all fields in `STREAMINFO` are supported.
	AudioEncoding_AUDIO_ENCODING_FLAC AudioEncoding = 2
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	AudioEncoding_AUDIO_ENCODING_MULAW AudioEncoding = 3
	// Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
	AudioEncoding_AUDIO_ENCODING_AMR AudioEncoding = 4
	// Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_AMR_WB AudioEncoding = 5
	// Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)).
	// `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_OGG_OPUS AudioEncoding = 6
	// Although the use of lossy encodings is not recommended, if a very low
	// bitrate encoding is required, `OGG_OPUS` is highly preferred over
	// Speex encoding. The [Speex](https://speex.org/) encoding supported by
	// Dialogflow API has a header byte in each block, as in MIME type
	// `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in
	// [RFC 5574](https://tools.ietf.org/html/rfc5574).
	// The stream is a sequence of blocks, one block per RTP packet. Each block
	// starts with a byte containing the length of the block, in bytes, followed
	// by one or more frames of Speex data, padded to an integral number of
	// bytes (octets) as specified in RFC 5574. In other words, each RTP header
	// is replaced with a single byte containing the block length. Only Speex
	// wideband is supported. `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE AudioEncoding = 7
)

// Enum value maps for AudioEncoding.
var (
	AudioEncoding_name = map[int32]string{
		0: "AUDIO_ENCODING_UNSPECIFIED",
		1: "AUDIO_ENCODING_LINEAR_16",
		2: "AUDIO_ENCODING_FLAC",
		3: "AUDIO_ENCODING_MULAW",
		4: "AUDIO_ENCODING_AMR",
		5: "AUDIO_ENCODING_AMR_WB",
		6: "AUDIO_ENCODING_OGG_OPUS",
		7: "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE",
	}
	AudioEncoding_value = map[string]int32{
		"AUDIO_ENCODING_UNSPECIFIED":            0,
		"AUDIO_ENCODING_LINEAR_16":              1,
		"AUDIO_ENCODING_FLAC":                   2,
		"AUDIO_ENCODING_MULAW":                  3,
		"AUDIO_ENCODING_AMR":                    4,
		"AUDIO_ENCODING_AMR_WB":                 5,
		"AUDIO_ENCODING_OGG_OPUS":               6,
		"AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE": 7,
	}
)

func (x AudioEncoding) Enum() *AudioEncoding {
	p := new(AudioEncoding)
	*p = x
	return p
}

func (x AudioEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudioEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[0].Descriptor()
}

func (AudioEncoding) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[0]
}

func (x AudioEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudioEncoding.Descriptor instead.
func (AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{0}
}

// Variant of the specified [Speech model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use.
//
// See the [Cloud Speech
// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
// for which models have different variants. For example, the "phone_call" model
// has both a standard and an enhanced variant. When you use an enhanced model,
// you will generally receive higher quality results than for a standard model.
type SpeechModelVariant int32

const (
	// No model variant specified. In this case Dialogflow defaults to
	// USE_BEST_AVAILABLE.
	SpeechModelVariant_SPEECH_MODEL_VARIANT_UNSPECIFIED SpeechModelVariant = 0
	// Use the best available variant of the [Speech
	// model][InputAudioConfig.model] that the caller is eligible for.
	//
	// Please see the [Dialogflow
	// docs](https://cloud.google.com/dialogflow/docs/data-logging) for
	// how to make your project eligible for enhanced models.
	SpeechModelVariant_USE_BEST_AVAILABLE SpeechModelVariant = 1
	// Use standard model variant even if an enhanced model is available.  See the
	// [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// for details about enhanced models.
	SpeechModelVariant_USE_STANDARD SpeechModelVariant = 2
	// Use an enhanced model variant:
	//
	// * If an enhanced variant does not exist for the given
	//   [model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] and request language, Dialogflow falls
	//   back to the standard variant.
	//
	//   The [Cloud Speech
	//   documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	//   describes which models have enhanced variants.
	//
	// * If the API caller isn't eligible for enhanced models, Dialogflow returns
	//   an error.  Please see the [Dialogflow
	//   docs](https://cloud.google.com/dialogflow/docs/data-logging)
	//   for how to make your project eligible.
	SpeechModelVariant_USE_ENHANCED SpeechModelVariant = 3
)

// Enum value maps for SpeechModelVariant.
var (
	SpeechModelVariant_name = map[int32]string{
		0: "SPEECH_MODEL_VARIANT_UNSPECIFIED",
		1: "USE_BEST_AVAILABLE",
		2: "USE_STANDARD",
		3: "USE_ENHANCED",
	}
	SpeechModelVariant_value = map[string]int32{
		"SPEECH_MODEL_VARIANT_UNSPECIFIED": 0,
		"USE_BEST_AVAILABLE":               1,
		"USE_STANDARD":                     2,
		"USE_ENHANCED":                     3,
	}
)

func (x SpeechModelVariant) Enum() *SpeechModelVariant {
	p := new(SpeechModelVariant)
	*p = x
	return p
}

func (x SpeechModelVariant) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SpeechModelVariant) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[1].Descriptor()
}

func (SpeechModelVariant) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[1]
}

func (x SpeechModelVariant) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SpeechModelVariant.Descriptor instead.
func (SpeechModelVariant) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{1}
}

// Gender of the voice as described in
// [SSML voice element](https://www.w3.org/TR/speech-synthesis11/#edef_voice).
type SsmlVoiceGender int32

const (
	// An unspecified gender, which means that the client doesn't care which
	// gender the selected voice will have.
	SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED SsmlVoiceGender = 0
	// A male voice.
	SsmlVoiceGender_SSML_VOICE_GENDER_MALE SsmlVoiceGender = 1
	// A female voice.
	SsmlVoiceGender_SSML_VOICE_GENDER_FEMALE SsmlVoiceGender = 2
	// A gender-neutral voice.
	SsmlVoiceGender_SSML_VOICE_GENDER_NEUTRAL SsmlVoiceGender = 3
)

// Enum value maps for SsmlVoiceGender.
var (
	SsmlVoiceGender_name = map[int32]string{
		0: "SSML_VOICE_GENDER_UNSPECIFIED",
		1: "SSML_VOICE_GENDER_MALE",
		2: "SSML_VOICE_GENDER_FEMALE",
		3: "SSML_VOICE_GENDER_NEUTRAL",
	}
	SsmlVoiceGender_value = map[string]int32{
		"SSML_VOICE_GENDER_UNSPECIFIED": 0,
		"SSML_VOICE_GENDER_MALE":        1,
		"SSML_VOICE_GENDER_FEMALE":      2,
		"SSML_VOICE_GENDER_NEUTRAL":     3,
	}
)

func (x SsmlVoiceGender) Enum() *SsmlVoiceGender {
	p := new(SsmlVoiceGender)
	*p = x
	return p
}

func (x SsmlVoiceGender) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SsmlVoiceGender) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[2].Descriptor()
}

func (SsmlVoiceGender) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[2]
}

func (x SsmlVoiceGender) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SsmlVoiceGender.Descriptor instead.
func (SsmlVoiceGender) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{2}
}

// Audio encoding of the output audio format in Text-To-Speech.
type OutputAudioEncoding int32

const (
	// Not specified.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_UNSPECIFIED OutputAudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// Audio content returned as LINEAR16 also contains a WAV header.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_LINEAR_16 OutputAudioEncoding = 1
	// MP3 audio at 32kbps.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MP3 OutputAudioEncoding = 2
	// MP3 audio at 64kbps.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MP3_64_KBPS OutputAudioEncoding = 4
	// Opus encoded audio wrapped in an ogg container. The result will be a
	// file which can be played natively on Android, and in browsers (at least
	// Chrome and Firefox). The quality of the encoding is considerably higher
	// than MP3 while using approximately the same bitrate.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_OGG_OPUS OutputAudioEncoding = 3
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MULAW OutputAudioEncoding = 5
)

// Enum value maps for OutputAudioEncoding.
var (
	OutputAudioEncoding_name = map[int32]string{
		0: "OUTPUT_AUDIO_ENCODING_UNSPECIFIED",
		1: "OUTPUT_AUDIO_ENCODING_LINEAR_16",
		2: "OUTPUT_AUDIO_ENCODING_MP3",
		4: "OUTPUT_AUDIO_ENCODING_MP3_64_KBPS",
		3: "OUTPUT_AUDIO_ENCODING_OGG_OPUS",
		5: "OUTPUT_AUDIO_ENCODING_MULAW",
	}
	OutputAudioEncoding_value = map[string]int32{
		"OUTPUT_AUDIO_ENCODING_UNSPECIFIED": 0,
		"OUTPUT_AUDIO_ENCODING_LINEAR_16":   1,
		"OUTPUT_AUDIO_ENCODING_MP3":         2,
		"OUTPUT_AUDIO_ENCODING_MP3_64_KBPS": 4,
		"OUTPUT_AUDIO_ENCODING_OGG_OPUS":    3,
		"OUTPUT_AUDIO_ENCODING_MULAW":       5,
	}
)

func (x OutputAudioEncoding) Enum() *OutputAudioEncoding {
	p := new(OutputAudioEncoding)
	*p = x
	return p
}

func (x OutputAudioEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutputAudioEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[3].Descriptor()
}

func (OutputAudioEncoding) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[3]
}

func (x OutputAudioEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutputAudioEncoding.Descriptor instead.
func (OutputAudioEncoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{3}
}

// [DTMF](https://en.wikipedia.org/wiki/Dual-tone_multi-frequency_signaling)
// digit in Telephony Gateway.
type TelephonyDtmf int32

const (
	// Not specified. This value may be used to indicate an absent digit.
	TelephonyDtmf_TELEPHONY_DTMF_UNSPECIFIED TelephonyDtmf = 0
	// Number: '1'.
	TelephonyDtmf_DTMF_ONE TelephonyDtmf = 1
	// Number: '2'.
	TelephonyDtmf_DTMF_TWO TelephonyDtmf = 2
	// Number: '3'.
	TelephonyDtmf_DTMF_THREE TelephonyDtmf = 3
	// Number: '4'.
	TelephonyDtmf_DTMF_FOUR TelephonyDtmf = 4
	// Number: '5'.
	TelephonyDtmf_DTMF_FIVE TelephonyDtmf = 5
	// Number: '6'.
	TelephonyDtmf_DTMF_SIX TelephonyDtmf = 6
	// Number: '7'.
	TelephonyDtmf_DTMF_SEVEN TelephonyDtmf = 7
	// Number: '8'.
	TelephonyDtmf_DTMF_EIGHT TelephonyDtmf = 8
	// Number: '9'.
	TelephonyDtmf_DTMF_NINE TelephonyDtmf = 9
	// Number: '0'.
	TelephonyDtmf_DTMF_ZERO TelephonyDtmf = 10
	// Letter: 'A'.
	TelephonyDtmf_DTMF_A TelephonyDtmf = 11
	// Letter: 'B'.
	TelephonyDtmf_DTMF_B TelephonyDtmf = 12
	// Letter: 'C'.
	TelephonyDtmf_DTMF_C TelephonyDtmf = 13
	// Letter: 'D'.
	TelephonyDtmf_DTMF_D TelephonyDtmf = 14
	// Asterisk/star: '*'.
	TelephonyDtmf_DTMF_STAR TelephonyDtmf = 15
	// Pound/diamond/hash/square/gate/octothorpe: '#'.
	TelephonyDtmf_DTMF_POUND TelephonyDtmf = 16
)

// Enum value maps for TelephonyDtmf.
var (
	TelephonyDtmf_name = map[int32]string{
		0:  "TELEPHONY_DTMF_UNSPECIFIED",
		1:  "DTMF_ONE",
		2:  "DTMF_TWO",
		3:  "DTMF_THREE",
		4:  "DTMF_FOUR",
		5:  "DTMF_FIVE",
		6:  "DTMF_SIX",
		7:  "DTMF_SEVEN",
		8:  "DTMF_EIGHT",
		9:  "DTMF_NINE",
		10: "DTMF_ZERO",
		11: "DTMF_A",
		12: "DTMF_B",
		13: "DTMF_C",
		14: "DTMF_D",
		15: "DTMF_STAR",
		16: "DTMF_POUND",
	}
	TelephonyDtmf_value = map[string]int32{
		"TELEPHONY_DTMF_UNSPECIFIED": 0,
		"DTMF_ONE":                   1,
		"DTMF_TWO":                   2,
		"DTMF_THREE":                 3,
		"DTMF_FOUR":                  4,
		"DTMF_FIVE":                  5,
		"DTMF_SIX":                   6,
		"DTMF_SEVEN":                 7,
		"DTMF_EIGHT":                 8,
		"DTMF_NINE":                  9,
		"DTMF_ZERO":                  10,
		"DTMF_A":                     11,
		"DTMF_B":                     12,
		"DTMF_C":                     13,
		"DTMF_D":                     14,
		"DTMF_STAR":                  15,
		"DTMF_POUND":                 16,
	}
)

func (x TelephonyDtmf) Enum() *TelephonyDtmf {
	p := new(TelephonyDtmf)
	*p = x
	return p
}

func (x TelephonyDtmf) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TelephonyDtmf) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[4].Descriptor()
}

func (TelephonyDtmf) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes[4]
}

func (x TelephonyDtmf) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TelephonyDtmf.Descriptor instead.
func (TelephonyDtmf) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{4}
}

// Hints for the speech recognizer to help with recognition in a specific
// conversation state.
type SpeechContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of strings containing words and phrases that the speech
	// recognizer should recognize with higher likelihood.
	//
	// This list can be used to:
	//
	// * improve accuracy for words and phrases you expect the user to say,
	//   e.g. typical commands for your Dialogflow agent
	// * add additional words to the speech recognizer vocabulary
	// * ...
	//
	// See the [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/quotas) for usage
	// limits.
	Phrases []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	// Optional. Boost for this context compared to other contexts:
	//
	// * If the boost is positive, Dialogflow will increase the probability that
	//   the phrases in this context are recognized over similar sounding phrases.
	// * If the boost is unspecified or non-positive, Dialogflow will not apply
	//   any boost.
	//
	// Dialogflow recommends that you use boosts in the range (0, 20] and that you
	// find a value that fits your use case with binary search.
	Boost float32 `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
}

func (x *SpeechContext) Reset() {
	*x = SpeechContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechContext) ProtoMessage() {}

func (x *SpeechContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechContext.ProtoReflect.Descriptor instead.
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{0}
}

func (x *SpeechContext) GetPhrases() []string {
	if x != nil {
		return x.Phrases
	}
	return nil
}

func (x *SpeechContext) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

// Information for a word recognized by the speech recognizer.
type SpeechWordInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The word this info is for.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// Time offset relative to the beginning of the audio that corresponds to the
	// start of the spoken word. This is an experimental feature and the accuracy
	// of the time offset can vary.
	StartOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// Time offset relative to the beginning of the audio that corresponds to the
	// end of the spoken word. This is an experimental feature and the accuracy of
	// the time offset can vary.
	EndOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for this word. A higher number
	// indicates an estimated greater likelihood that the recognized word is
	// correct. The default of 0.0 is a sentinel value indicating that confidence
	// was not set.
	//
	// This field is not guaranteed to be fully stable over time for the same
	// audio input. Users should also not rely on it to always be provided.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *SpeechWordInfo) Reset() {
	*x = SpeechWordInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechWordInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechWordInfo) ProtoMessage() {}

func (x *SpeechWordInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechWordInfo.ProtoReflect.Descriptor instead.
func (*SpeechWordInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{1}
}

func (x *SpeechWordInfo) GetWord() string {
	if x != nil {
		return x.Word
	}
	return ""
}

func (x *SpeechWordInfo) GetStartOffset() *durationpb.Duration {
	if x != nil {
		return x.StartOffset
	}
	return nil
}

func (x *SpeechWordInfo) GetEndOffset() *durationpb.Duration {
	if x != nil {
		return x.EndOffset
	}
	return nil
}

func (x *SpeechWordInfo) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Instructs the speech recognizer on how to process the audio content.
type InputAudioConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Audio encoding of the audio content to process.
	AudioEncoding AudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.dialogflow.v2beta1.AudioEncoding" json:"audio_encoding,omitempty"`
	// Required. Sample rate (in Hertz) of the audio content sent in the query.
	// Refer to
	// [Cloud Speech API
	// documentation](https://cloud.google.com/speech-to-text/docs/basics) for
	// more details.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Required. The language of the supplied audio. Dialogflow does not do
	// translations. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// If `true`, Dialogflow returns [SpeechWordInfo][google.cloud.dialogflow.v2beta1.SpeechWordInfo] in
	// [StreamingRecognitionResult][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult] with information about the recognized speech
	// words, e.g. start and end time offsets. If false or unspecified, Speech
	// doesn't return any word-level information.
	EnableWordInfo bool `protobuf:"varint,13,opt,name=enable_word_info,json=enableWordInfo,proto3" json:"enable_word_info,omitempty"`
	// A list of strings containing words and phrases that the speech
	// recognizer should recognize with higher likelihood.
	//
	// See [the Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
	// for more details.
	//
	// This field is deprecated. Please use [speech_contexts]() instead. If you
	// specify both [phrase_hints]() and [speech_contexts](), Dialogflow will
	// treat the [phrase_hints]() as a single additional [SpeechContext]().
	//
	// Deprecated: Do not use.
	PhraseHints []string `protobuf:"bytes,4,rep,name=phrase_hints,json=phraseHints,proto3" json:"phrase_hints,omitempty"`
	// Context information to assist speech recognition.
	//
	// See [the Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
	// for more details.
	SpeechContexts []*SpeechContext `protobuf:"bytes,11,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// Which Speech model to select for the given request. Select the
	// model best suited to your domain to get best results. If a model is not
	// explicitly specified, then we auto-select a model based on the parameters
	// in the InputAudioConfig.
	// If enhanced speech model is enabled for the agent and an enhanced
	// version of the specified model for the language does not exist, then the
	// speech is recognized using the standard version of the specified model.
	// Refer to
	// [Cloud Speech API
	// documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
	// for more details.
	Model string `protobuf:"bytes,7,opt,name=model,proto3" json:"model,omitempty"`
	// Which variant of the [Speech model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use.
	ModelVariant SpeechModelVariant `protobuf:"varint,10,opt,name=model_variant,json=modelVariant,proto3,enum=google.cloud.dialogflow.v2beta1.SpeechModelVariant" json:"model_variant,omitempty"`
	// If `false` (default), recognition does not cease until the
	// client closes the stream.
	// If `true`, the recognizer will detect a single spoken utterance in input
	// audio. Recognition ceases when it detects the audio's voice has
	// stopped or paused. In this case, once a detected intent is received, the
	// client should close the stream and start a new request with a new stream as
	// needed.
	// Note: This setting is relevant only for streaming methods.
	// Note: When specified, InputAudioConfig.single_utterance takes precedence
	// over StreamingDetectIntentRequest.single_utterance.
	SingleUtterance bool `protobuf:"varint,8,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// Only used in [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent] and
	// [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent].
	// If `false` and recognition doesn't return any result, trigger
	// `NO_SPEECH_RECOGNIZED` event to Dialogflow agent.
	DisableNoSpeechRecognizedEvent bool `protobuf:"varint,14,opt,name=disable_no_speech_recognized_event,json=disableNoSpeechRecognizedEvent,proto3" json:"disable_no_speech_recognized_event,omitempty"`
}

func (x *InputAudioConfig) Reset() {
	*x = InputAudioConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputAudioConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputAudioConfig) ProtoMessage() {}

func (x *InputAudioConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputAudioConfig.ProtoReflect.Descriptor instead.
func (*InputAudioConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{2}
}

func (x *InputAudioConfig) GetAudioEncoding() AudioEncoding {
	if x != nil {
		return x.AudioEncoding
	}
	return AudioEncoding_AUDIO_ENCODING_UNSPECIFIED
}

func (x *InputAudioConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *InputAudioConfig) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *InputAudioConfig) GetEnableWordInfo() bool {
	if x != nil {
		return x.EnableWordInfo
	}
	return false
}

// Deprecated: Do not use.
func (x *InputAudioConfig) GetPhraseHints() []string {
	if x != nil {
		return x.PhraseHints
	}
	return nil
}

func (x *InputAudioConfig) GetSpeechContexts() []*SpeechContext {
	if x != nil {
		return x.SpeechContexts
	}
	return nil
}

func (x *InputAudioConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *InputAudioConfig) GetModelVariant() SpeechModelVariant {
	if x != nil {
		return x.ModelVariant
	}
	return SpeechModelVariant_SPEECH_MODEL_VARIANT_UNSPECIFIED
}

func (x *InputAudioConfig) GetSingleUtterance() bool {
	if x != nil {
		return x.SingleUtterance
	}
	return false
}

func (x *InputAudioConfig) GetDisableNoSpeechRecognizedEvent() bool {
	if x != nil {
		return x.DisableNoSpeechRecognizedEvent
	}
	return false
}

// Description of which voice to use for speech synthesis.
type VoiceSelectionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the voice. If not set, the service will choose a
	// voice based on the other parameters such as language_code and
	// [ssml_gender][google.cloud.dialogflow.v2beta1.VoiceSelectionParams.ssml_gender].
	//
	// For the list of available voices, please refer to [Supported voices and
	// languages](https://cloud.google.com/text-to-speech/docs/voices).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The preferred gender of the voice. If not set, the service will
	// choose a voice based on the other parameters such as language_code and
	// [name][google.cloud.dialogflow.v2beta1.VoiceSelectionParams.name]. Note that this is only a preference, not requirement. If a
	// voice of the appropriate gender is not available, the synthesizer should
	// substitute a voice with a different gender rather than failing the request.
	SsmlGender SsmlVoiceGender `protobuf:"varint,2,opt,name=ssml_gender,json=ssmlGender,proto3,enum=google.cloud.dialogflow.v2beta1.SsmlVoiceGender" json:"ssml_gender,omitempty"`
}

func (x *VoiceSelectionParams) Reset() {
	*x = VoiceSelectionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VoiceSelectionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoiceSelectionParams) ProtoMessage() {}

func (x *VoiceSelectionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoiceSelectionParams.ProtoReflect.Descriptor instead.
func (*VoiceSelectionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{3}
}

func (x *VoiceSelectionParams) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VoiceSelectionParams) GetSsmlGender() SsmlVoiceGender {
	if x != nil {
		return x.SsmlGender
	}
	return SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED
}

// Configuration of how speech should be synthesized.
type SynthesizeSpeechConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Speaking rate/speed, in the range [0.25, 4.0]. 1.0 is the normal
	// native speed supported by the specific voice. 2.0 is twice as fast, and
	// 0.5 is half as fast. If unset(0.0), defaults to the native 1.0 speed. Any
	// other values < 0.25 or > 4.0 will return an error.
	SpeakingRate float64 `protobuf:"fixed64,1,opt,name=speaking_rate,json=speakingRate,proto3" json:"speaking_rate,omitempty"`
	// Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means increase 20
	// semitones from the original pitch. -20 means decrease 20 semitones from the
	// original pitch.
	Pitch float64 `protobuf:"fixed64,2,opt,name=pitch,proto3" json:"pitch,omitempty"`
	// Optional. Volume gain (in dB) of the normal native volume supported by the
	// specific voice, in the range [-96.0, 16.0]. If unset, or set to a value of
	// 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
	// will play at approximately half the amplitude of the normal native signal
	// amplitude. A value of +6.0 (dB) will play at approximately twice the
	// amplitude of the normal native signal amplitude. We strongly recommend not
	// to exceed +10 (dB) as there's usually no effective increase in loudness for
	// any value greater than that.
	VolumeGainDb float64 `protobuf:"fixed64,3,opt,name=volume_gain_db,json=volumeGainDb,proto3" json:"volume_gain_db,omitempty"`
	// Optional. An identifier which selects 'audio effects' profiles that are
	// applied on (post synthesized) text to speech. Effects are applied on top of
	// each other in the order they are given.
	EffectsProfileId []string `protobuf:"bytes,5,rep,name=effects_profile_id,json=effectsProfileId,proto3" json:"effects_profile_id,omitempty"`
	// Optional. The desired voice of the synthesized audio.
	Voice *VoiceSelectionParams `protobuf:"bytes,4,opt,name=voice,proto3" json:"voice,omitempty"`
}

func (x *SynthesizeSpeechConfig) Reset() {
	*x = SynthesizeSpeechConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SynthesizeSpeechConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynthesizeSpeechConfig) ProtoMessage() {}

func (x *SynthesizeSpeechConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynthesizeSpeechConfig.ProtoReflect.Descriptor instead.
func (*SynthesizeSpeechConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{4}
}

func (x *SynthesizeSpeechConfig) GetSpeakingRate() float64 {
	if x != nil {
		return x.SpeakingRate
	}
	return 0
}

func (x *SynthesizeSpeechConfig) GetPitch() float64 {
	if x != nil {
		return x.Pitch
	}
	return 0
}

func (x *SynthesizeSpeechConfig) GetVolumeGainDb() float64 {
	if x != nil {
		return x.VolumeGainDb
	}
	return 0
}

func (x *SynthesizeSpeechConfig) GetEffectsProfileId() []string {
	if x != nil {
		return x.EffectsProfileId
	}
	return nil
}

func (x *SynthesizeSpeechConfig) GetVoice() *VoiceSelectionParams {
	if x != nil {
		return x.Voice
	}
	return nil
}

// Instructs the speech synthesizer how to generate the output audio content.
// If this audio config is supplied in a request, it overrides all existing
// text-to-speech settings applied to the agent.
type OutputAudioConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Audio encoding of the synthesized audio content.
	AudioEncoding OutputAudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.dialogflow.v2beta1.OutputAudioEncoding" json:"audio_encoding,omitempty"`
	// The synthesis sample rate (in hertz) for this audio. If not
	// provided, then the synthesizer will use the default sample rate based on
	// the audio encoding. If this is different from the voice's natural sample
	// rate, then the synthesizer will honor this request by converting to the
	// desired sample rate (which might result in worse audio quality).
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Configuration of how speech should be synthesized.
	SynthesizeSpeechConfig *SynthesizeSpeechConfig `protobuf:"bytes,3,opt,name=synthesize_speech_config,json=synthesizeSpeechConfig,proto3" json:"synthesize_speech_config,omitempty"`
}

func (x *OutputAudioConfig) Reset() {
	*x = OutputAudioConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputAudioConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputAudioConfig) ProtoMessage() {}

func (x *OutputAudioConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputAudioConfig.ProtoReflect.Descriptor instead.
func (*OutputAudioConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{5}
}

func (x *OutputAudioConfig) GetAudioEncoding() OutputAudioEncoding {
	if x != nil {
		return x.AudioEncoding
	}
	return OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_UNSPECIFIED
}

func (x *OutputAudioConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *OutputAudioConfig) GetSynthesizeSpeechConfig() *SynthesizeSpeechConfig {
	if x != nil {
		return x.SynthesizeSpeechConfig
	}
	return nil
}

// A wrapper of repeated TelephonyDtmf digits.
type TelephonyDtmfEvents struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sequence of TelephonyDtmf digits.
	DtmfEvents []TelephonyDtmf `protobuf:"varint,1,rep,packed,name=dtmf_events,json=dtmfEvents,proto3,enum=google.cloud.dialogflow.v2beta1.TelephonyDtmf" json:"dtmf_events,omitempty"`
}

func (x *TelephonyDtmfEvents) Reset() {
	*x = TelephonyDtmfEvents{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelephonyDtmfEvents) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelephonyDtmfEvents) ProtoMessage() {}

func (x *TelephonyDtmfEvents) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelephonyDtmfEvents.ProtoReflect.Descriptor instead.
func (*TelephonyDtmfEvents) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{6}
}

func (x *TelephonyDtmfEvents) GetDtmfEvents() []TelephonyDtmf {
	if x != nil {
		return x.DtmfEvents
	}
	return nil
}

// Configures speech transcription for [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile].
type SpeechToTextConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The speech model used in speech to text.
	// `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as
	// `USE_ENHANCED`. It can be overridden in [AnalyzeContentRequest][google.cloud.dialogflow.v2beta1.AnalyzeContentRequest] and
	// [StreamingAnalyzeContentRequest][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest] request.
	// If enhanced model variant is specified and an enhanced
	// version of the specified model for the language does not exist, then it
	// would emit an error.
	SpeechModelVariant SpeechModelVariant `protobuf:"varint,1,opt,name=speech_model_variant,json=speechModelVariant,proto3,enum=google.cloud.dialogflow.v2beta1.SpeechModelVariant" json:"speech_model_variant,omitempty"`
}

func (x *SpeechToTextConfig) Reset() {
	*x = SpeechToTextConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechToTextConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechToTextConfig) ProtoMessage() {}

func (x *SpeechToTextConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechToTextConfig.ProtoReflect.Descriptor instead.
func (*SpeechToTextConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP(), []int{7}
}

func (x *SpeechToTextConfig) GetSpeechModelVariant() SpeechModelVariant {
	if x != nil {
		return x.SpeechModelVariant
	}
	return SpeechModelVariant_SPEECH_MODEL_VARIANT_UNSPECIFIED
}

var File_google_cloud_dialogflow_v2beta1_audio_config_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x3f, 0x0a, 0x0d, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x07, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05,
	0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f,
	0x73, 0x74, 0x22, 0xbc, 0x01, 0x0a, 0x0e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x57, 0x6f, 0x72,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x3c, 0x0a, 0x0c, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x22, 0xcb, 0x04, 0x0a, 0x10, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0d,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a,
	0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72,
	0x74, 0x7a, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x28,
	0x0a, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0c, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0b, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12,
	0x57, 0x0a, 0x0f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x58,
	0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x4a, 0x0a, 0x22, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e,
	0x6f, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x1e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22,
	0x7d, 0x0a, 0x14, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x0b, 0x73,
	0x73, 0x6d, 0x6c, 0x5f, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x73, 0x6d, 0x6c, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x52, 0x0a, 0x73, 0x73, 0x6d, 0x6c, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x22, 0xf4,
	0x01, 0x0a, 0x16, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x70, 0x65,
	0x61, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x0c, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x70, 0x69, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x70,
	0x69, 0x74, 0x63, 0x68, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x67,
	0x61, 0x69, 0x6e, 0x5f, 0x64, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0c, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x47, 0x61, 0x69, 0x6e, 0x44, 0x62, 0x12, 0x2c, 0x0a, 0x12, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x73, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x05, 0x76, 0x6f, 0x69, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x05,
	0x76, 0x6f, 0x69, 0x63, 0x65, 0x22, 0x94, 0x02, 0x0a, 0x11, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x0e, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a,
	0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72,
	0x74, 0x7a, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12, 0x71, 0x0a, 0x18, 0x73, 0x79, 0x6e,
	0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x79,
	0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x73, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65,
	0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x66, 0x0a, 0x13,
	0x54, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79, 0x44, 0x74, 0x6d, 0x66, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x64, 0x74, 0x6d, 0x66, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x70,
	0x68, 0x6f, 0x6e, 0x79, 0x44, 0x74, 0x6d, 0x66, 0x52, 0x0a, 0x64, 0x74, 0x6d, 0x66, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x22, 0x7b, 0x0a, 0x12, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x6f,
	0x54, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x14, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x12, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x2a, 0xfb, 0x01, 0x0a, 0x0d, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43,
	0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43,
	0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x5f, 0x31, 0x36, 0x10,
	0x01, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44,
	0x49, 0x4e, 0x47, 0x5f, 0x46, 0x4c, 0x41, 0x43, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x55,
	0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x55, 0x4c,
	0x41, 0x57, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e,
	0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4d, 0x52, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15,
	0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x41,
	0x4d, 0x52, 0x5f, 0x57, 0x42, 0x10, 0x05, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x55, 0x44, 0x49, 0x4f,
	0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x47, 0x47, 0x5f, 0x4f, 0x50,
	0x55, 0x53, 0x10, 0x06, 0x12, 0x29, 0x0a, 0x25, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e,
	0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x50, 0x45, 0x45, 0x58, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x10, 0x07, 0x2a,
	0x76, 0x0a, 0x12, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x4e, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x55,
	0x53, 0x45, 0x5f, 0x42, 0x45, 0x53, 0x54, 0x5f, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c,
	0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x53, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44,
	0x41, 0x52, 0x44, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x48,
	0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x8d, 0x01, 0x0a, 0x0f, 0x53, 0x73, 0x6d, 0x6c,
	0x56, 0x6f, 0x69, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x1d, 0x53,
	0x53, 0x4d, 0x4c, 0x5f, 0x56, 0x4f, 0x49, 0x43, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x44, 0x45, 0x52,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a,
	0x0a, 0x16, 0x53, 0x53, 0x4d, 0x4c, 0x5f, 0x56, 0x4f, 0x49, 0x43, 0x45, 0x5f, 0x47, 0x45, 0x4e,
	0x44, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x53,
	0x4d, 0x4c, 0x5f, 0x56, 0x4f, 0x49, 0x43, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x5f,
	0x46, 0x45, 0x4d, 0x41, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x53, 0x4d, 0x4c,
	0x5f, 0x56, 0x4f, 0x49, 0x43, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x5f, 0x4e, 0x45,
	0x55, 0x54, 0x52, 0x41, 0x4c, 0x10, 0x03, 0x2a, 0xec, 0x01, 0x0a, 0x13, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x25, 0x0a, 0x21, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f,
	0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54,
	0x5f, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f,
	0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x5f, 0x31, 0x36, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x4f,
	0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f,
	0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x50, 0x33, 0x10, 0x02, 0x12, 0x25, 0x0a, 0x21, 0x4f, 0x55,
	0x54, 0x50, 0x55, 0x54, 0x5f, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44,
	0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x50, 0x33, 0x5f, 0x36, 0x34, 0x5f, 0x4b, 0x42, 0x50, 0x53, 0x10,
	0x04, 0x12, 0x22, 0x0a, 0x1e, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x41, 0x55, 0x44, 0x49,
	0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x47, 0x47, 0x5f, 0x4f,
	0x50, 0x55, 0x53, 0x10, 0x03, 0x12, 0x1f, 0x0a, 0x1b, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f,
	0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4d,
	0x55, 0x4c, 0x41, 0x57, 0x10, 0x05, 0x2a, 0x94, 0x02, 0x0a, 0x0d, 0x54, 0x65, 0x6c, 0x65, 0x70,
	0x68, 0x6f, 0x6e, 0x79, 0x44, 0x74, 0x6d, 0x66, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x45, 0x4c, 0x45,
	0x50, 0x48, 0x4f, 0x4e, 0x59, 0x5f, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x54, 0x4d, 0x46,
	0x5f, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x54,
	0x57, 0x4f, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x54, 0x48, 0x52,
	0x45, 0x45, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x46, 0x4f, 0x55,
	0x52, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x46, 0x49, 0x56, 0x45,
	0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x53, 0x49, 0x58, 0x10, 0x06,
	0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x4e, 0x10, 0x07,
	0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x45, 0x49, 0x47, 0x48, 0x54, 0x10, 0x08,
	0x12, 0x0d, 0x0a, 0x09, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x4e, 0x49, 0x4e, 0x45, 0x10, 0x09, 0x12,
	0x0d, 0x0a, 0x09, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x5a, 0x45, 0x52, 0x4f, 0x10, 0x0a, 0x12, 0x0a,
	0x0a, 0x06, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x41, 0x10, 0x0b, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x54,
	0x4d, 0x46, 0x5f, 0x42, 0x10, 0x0c, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x43,
	0x10, 0x0d, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x44, 0x10, 0x0e, 0x12, 0x0d,
	0x0a, 0x09, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x10, 0x0f, 0x12, 0x0e, 0x0a,
	0x0a, 0x44, 0x54, 0x4d, 0x46, 0x5f, 0x50, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x10, 0x42, 0xae, 0x01,
	0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x10, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescData = file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDesc
)

func file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDescData
}

var file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_dialogflow_v2beta1_audio_config_proto_goTypes = []interface{}{
	(AudioEncoding)(0),             // 0: google.cloud.dialogflow.v2beta1.AudioEncoding
	(SpeechModelVariant)(0),        // 1: google.cloud.dialogflow.v2beta1.SpeechModelVariant
	(SsmlVoiceGender)(0),           // 2: google.cloud.dialogflow.v2beta1.SsmlVoiceGender
	(OutputAudioEncoding)(0),       // 3: google.cloud.dialogflow.v2beta1.OutputAudioEncoding
	(TelephonyDtmf)(0),             // 4: google.cloud.dialogflow.v2beta1.TelephonyDtmf
	(*SpeechContext)(nil),          // 5: google.cloud.dialogflow.v2beta1.SpeechContext
	(*SpeechWordInfo)(nil),         // 6: google.cloud.dialogflow.v2beta1.SpeechWordInfo
	(*InputAudioConfig)(nil),       // 7: google.cloud.dialogflow.v2beta1.InputAudioConfig
	(*VoiceSelectionParams)(nil),   // 8: google.cloud.dialogflow.v2beta1.VoiceSelectionParams
	(*SynthesizeSpeechConfig)(nil), // 9: google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig
	(*OutputAudioConfig)(nil),      // 10: google.cloud.dialogflow.v2beta1.OutputAudioConfig
	(*TelephonyDtmfEvents)(nil),    // 11: google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents
	(*SpeechToTextConfig)(nil),     // 12: google.cloud.dialogflow.v2beta1.SpeechToTextConfig
	(*durationpb.Duration)(nil),    // 13: google.protobuf.Duration
}
var file_google_cloud_dialogflow_v2beta1_audio_config_proto_depIdxs = []int32{
	13, // 0: google.cloud.dialogflow.v2beta1.SpeechWordInfo.start_offset:type_name -> google.protobuf.Duration
	13, // 1: google.cloud.dialogflow.v2beta1.SpeechWordInfo.end_offset:type_name -> google.protobuf.Duration
	0,  // 2: google.cloud.dialogflow.v2beta1.InputAudioConfig.audio_encoding:type_name -> google.cloud.dialogflow.v2beta1.AudioEncoding
	5,  // 3: google.cloud.dialogflow.v2beta1.InputAudioConfig.speech_contexts:type_name -> google.cloud.dialogflow.v2beta1.SpeechContext
	1,  // 4: google.cloud.dialogflow.v2beta1.InputAudioConfig.model_variant:type_name -> google.cloud.dialogflow.v2beta1.SpeechModelVariant
	2,  // 5: google.cloud.dialogflow.v2beta1.VoiceSelectionParams.ssml_gender:type_name -> google.cloud.dialogflow.v2beta1.SsmlVoiceGender
	8,  // 6: google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig.voice:type_name -> google.cloud.dialogflow.v2beta1.VoiceSelectionParams
	3,  // 7: google.cloud.dialogflow.v2beta1.OutputAudioConfig.audio_encoding:type_name -> google.cloud.dialogflow.v2beta1.OutputAudioEncoding
	9,  // 8: google.cloud.dialogflow.v2beta1.OutputAudioConfig.synthesize_speech_config:type_name -> google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig
	4,  // 9: google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.dtmf_events:type_name -> google.cloud.dialogflow.v2beta1.TelephonyDtmf
	1,  // 10: google.cloud.dialogflow.v2beta1.SpeechToTextConfig.speech_model_variant:type_name -> google.cloud.dialogflow.v2beta1.SpeechModelVariant
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2beta1_audio_config_proto_init() }
func file_google_cloud_dialogflow_v2beta1_audio_config_proto_init() {
	if File_google_cloud_dialogflow_v2beta1_audio_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechWordInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputAudioConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VoiceSelectionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SynthesizeSpeechConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputAudioConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelephonyDtmfEvents); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechToTextConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_v2beta1_audio_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2beta1_audio_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2beta1_audio_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2beta1_audio_config_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2beta1_audio_config_proto = out.File
	file_google_cloud_dialogflow_v2beta1_audio_config_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2beta1_audio_config_proto_goTypes = nil
	file_google_cloud_dialogflow_v2beta1_audio_config_proto_depIdxs = nil
}
