package devopsapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/devops/mgmt/2019-07-01-preview/devops"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result devops.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result devops.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*devops.OperationsClient)(nil)

// PipelineTemplateDefinitionsClientAPI contains the set of methods on the PipelineTemplateDefinitionsClient type.
type PipelineTemplateDefinitionsClientAPI interface {
	List(ctx context.Context) (result devops.PipelineTemplateDefinitionListResultPage, err error)
	ListComplete(ctx context.Context) (result devops.PipelineTemplateDefinitionListResultIterator, err error)
}

var _ PipelineTemplateDefinitionsClientAPI = (*devops.PipelineTemplateDefinitionsClient)(nil)

// PipelinesClientAPI contains the set of methods on the PipelinesClient type.
type PipelinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, pipelineName string, createOperationParameters devops.Pipeline) (result devops.PipelinesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, pipelineName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, pipelineName string) (result devops.Pipeline, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result devops.PipelineListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result devops.PipelineListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result devops.PipelineListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result devops.PipelineListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, pipelineName string, updateOperationParameters devops.PipelineUpdateParameters) (result devops.Pipeline, err error)
}

var _ PipelinesClientAPI = (*devops.PipelinesClient)(nil)
