// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.25.3
// source: envoy/extensions/filters/http/ratelimit/v3/rate_limit.proto

package ratelimitv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	v32 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/ratelimit/v3"
	v33 "github.com/envoyproxy/go-control-plane/envoy/config/route/v3"
	v34 "github.com/envoyproxy/go-control-plane/envoy/type/metadata/v3"
	v31 "github.com/envoyproxy/go-control-plane/envoy/type/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines the version of the standard to use for X-RateLimit headers.
//
// [#next-major-version: unify with local ratelimit, should use common.ratelimit.v3.XRateLimitHeadersRFCVersion instead.]
type RateLimit_XRateLimitHeadersRFCVersion int32

const (
	// X-RateLimit headers disabled.
	RateLimit_OFF RateLimit_XRateLimitHeadersRFCVersion = 0
	// Use `draft RFC Version 03 <https://tools.ietf.org/id/draft-polli-ratelimit-headers-03.html>`_.
	RateLimit_DRAFT_VERSION_03 RateLimit_XRateLimitHeadersRFCVersion = 1
)

// Enum value maps for RateLimit_XRateLimitHeadersRFCVersion.
var (
	RateLimit_XRateLimitHeadersRFCVersion_name = map[int32]string{
		0: "OFF",
		1: "DRAFT_VERSION_03",
	}
	RateLimit_XRateLimitHeadersRFCVersion_value = map[string]int32{
		"OFF":              0,
		"DRAFT_VERSION_03": 1,
	}
)

func (x RateLimit_XRateLimitHeadersRFCVersion) Enum() *RateLimit_XRateLimitHeadersRFCVersion {
	p := new(RateLimit_XRateLimitHeadersRFCVersion)
	*p = x
	return p
}

func (x RateLimit_XRateLimitHeadersRFCVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RateLimit_XRateLimitHeadersRFCVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[0].Descriptor()
}

func (RateLimit_XRateLimitHeadersRFCVersion) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[0]
}

func (x RateLimit_XRateLimitHeadersRFCVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RateLimit_XRateLimitHeadersRFCVersion.Descriptor instead.
func (RateLimit_XRateLimitHeadersRFCVersion) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{0, 0}
}

type RateLimitConfig_Action_MetaData_Source int32

const (
	// Query :ref:`dynamic metadata <well_known_dynamic_metadata>`
	RateLimitConfig_Action_MetaData_DYNAMIC RateLimitConfig_Action_MetaData_Source = 0
	// Query :ref:`route entry metadata <envoy_v3_api_field_config.route.v3.Route.metadata>`
	RateLimitConfig_Action_MetaData_ROUTE_ENTRY RateLimitConfig_Action_MetaData_Source = 1
)

// Enum value maps for RateLimitConfig_Action_MetaData_Source.
var (
	RateLimitConfig_Action_MetaData_Source_name = map[int32]string{
		0: "DYNAMIC",
		1: "ROUTE_ENTRY",
	}
	RateLimitConfig_Action_MetaData_Source_value = map[string]int32{
		"DYNAMIC":     0,
		"ROUTE_ENTRY": 1,
	}
)

func (x RateLimitConfig_Action_MetaData_Source) Enum() *RateLimitConfig_Action_MetaData_Source {
	p := new(RateLimitConfig_Action_MetaData_Source)
	*p = x
	return p
}

func (x RateLimitConfig_Action_MetaData_Source) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RateLimitConfig_Action_MetaData_Source) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[1].Descriptor()
}

func (RateLimitConfig_Action_MetaData_Source) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[1]
}

func (x RateLimitConfig_Action_MetaData_Source) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RateLimitConfig_Action_MetaData_Source.Descriptor instead.
func (RateLimitConfig_Action_MetaData_Source) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0, 6, 0}
}

// [#next-major-version: unify with local ratelimit, should use common.ratelimit.v3.VhRateLimitsOptions instead.]
type RateLimitPerRoute_VhRateLimitsOptions int32

const (
	// Use the virtual host rate limits unless the route has a rate limit policy.
	RateLimitPerRoute_OVERRIDE RateLimitPerRoute_VhRateLimitsOptions = 0
	// Use the virtual host rate limits even if the route has a rate limit policy.
	RateLimitPerRoute_INCLUDE RateLimitPerRoute_VhRateLimitsOptions = 1
	// Ignore the virtual host rate limits even if the route does not have a rate limit policy.
	RateLimitPerRoute_IGNORE RateLimitPerRoute_VhRateLimitsOptions = 2
)

// Enum value maps for RateLimitPerRoute_VhRateLimitsOptions.
var (
	RateLimitPerRoute_VhRateLimitsOptions_name = map[int32]string{
		0: "OVERRIDE",
		1: "INCLUDE",
		2: "IGNORE",
	}
	RateLimitPerRoute_VhRateLimitsOptions_value = map[string]int32{
		"OVERRIDE": 0,
		"INCLUDE":  1,
		"IGNORE":   2,
	}
)

func (x RateLimitPerRoute_VhRateLimitsOptions) Enum() *RateLimitPerRoute_VhRateLimitsOptions {
	p := new(RateLimitPerRoute_VhRateLimitsOptions)
	*p = x
	return p
}

func (x RateLimitPerRoute_VhRateLimitsOptions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RateLimitPerRoute_VhRateLimitsOptions) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[2].Descriptor()
}

func (RateLimitPerRoute_VhRateLimitsOptions) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[2]
}

func (x RateLimitPerRoute_VhRateLimitsOptions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RateLimitPerRoute_VhRateLimitsOptions.Descriptor instead.
func (RateLimitPerRoute_VhRateLimitsOptions) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{2, 0}
}

// The override option determines how the filter handles the cases where there is an override config at a more specific level than this one (from least to most specific: virtual host, route, cluster weight).
// [#not-implemented-hide:]
type RateLimitPerRoute_OverrideOptions int32

const (
	// Client-defined default, typically OVERRIDE_POLICY. If VhRateLimitsOptions is set, that will be used instead.
	RateLimitPerRoute_DEFAULT RateLimitPerRoute_OverrideOptions = 0
	// If there is an override config at a more specific level, use that instead of this one.
	RateLimitPerRoute_OVERRIDE_POLICY RateLimitPerRoute_OverrideOptions = 1
	// If there is an override config at a more specific level, use data from both.
	RateLimitPerRoute_INCLUDE_POLICY RateLimitPerRoute_OverrideOptions = 2
	// If there is an override config at a more specific level, ignore it and use only this one.
	RateLimitPerRoute_IGNORE_POLICY RateLimitPerRoute_OverrideOptions = 3
)

// Enum value maps for RateLimitPerRoute_OverrideOptions.
var (
	RateLimitPerRoute_OverrideOptions_name = map[int32]string{
		0: "DEFAULT",
		1: "OVERRIDE_POLICY",
		2: "INCLUDE_POLICY",
		3: "IGNORE_POLICY",
	}
	RateLimitPerRoute_OverrideOptions_value = map[string]int32{
		"DEFAULT":         0,
		"OVERRIDE_POLICY": 1,
		"INCLUDE_POLICY":  2,
		"IGNORE_POLICY":   3,
	}
)

func (x RateLimitPerRoute_OverrideOptions) Enum() *RateLimitPerRoute_OverrideOptions {
	p := new(RateLimitPerRoute_OverrideOptions)
	*p = x
	return p
}

func (x RateLimitPerRoute_OverrideOptions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RateLimitPerRoute_OverrideOptions) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[3].Descriptor()
}

func (RateLimitPerRoute_OverrideOptions) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[3]
}

func (x RateLimitPerRoute_OverrideOptions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RateLimitPerRoute_OverrideOptions.Descriptor instead.
func (RateLimitPerRoute_OverrideOptions) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{2, 1}
}

// [#next-free-field: 14]
type RateLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rate limit domain to use when calling the rate limit service.
	Domain string `protobuf:"bytes,1,opt,name=domain,proto3" json:"domain,omitempty"`
	// Specifies the rate limit configurations to be applied with the same
	// stage number. If not set, the default stage number is 0.
	//
	// .. note::
	//
	//	The filter supports a range of 0 - 10 inclusively for stage numbers.
	Stage uint32 `protobuf:"varint,2,opt,name=stage,proto3" json:"stage,omitempty"`
	// The type of requests the filter should apply to. The supported
	// types are “internal“, “external“ or “both“. A request is considered internal if
	// :ref:`x-envoy-internal<config_http_conn_man_headers_x-envoy-internal>` is set to true. If
	// :ref:`x-envoy-internal<config_http_conn_man_headers_x-envoy-internal>` is not set or false, a
	// request is considered external. The filter defaults to “both“, and it will apply to all request
	// types.
	RequestType string `protobuf:"bytes,3,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The timeout in milliseconds for the rate limit service RPC. If not
	// set, this defaults to 20ms.
	Timeout *durationpb.Duration `protobuf:"bytes,4,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The filter's behaviour in case the rate limiting service does
	// not respond back. When it is set to true, Envoy will not allow traffic in case of
	// communication failure between rate limiting service and the proxy.
	FailureModeDeny bool `protobuf:"varint,5,opt,name=failure_mode_deny,json=failureModeDeny,proto3" json:"failure_mode_deny,omitempty"`
	// Specifies whether a “RESOURCE_EXHAUSTED“ gRPC code must be returned instead
	// of the default “UNAVAILABLE“ gRPC code for a rate limited gRPC call. The
	// HTTP code will be 200 for a gRPC response.
	RateLimitedAsResourceExhausted bool `protobuf:"varint,6,opt,name=rate_limited_as_resource_exhausted,json=rateLimitedAsResourceExhausted,proto3" json:"rate_limited_as_resource_exhausted,omitempty"`
	// Configuration for an external rate limit service provider. If not
	// specified, any calls to the rate limit service will immediately return
	// success.
	RateLimitService *v3.RateLimitServiceConfig `protobuf:"bytes,7,opt,name=rate_limit_service,json=rateLimitService,proto3" json:"rate_limit_service,omitempty"`
	// Defines the standard version to use for X-RateLimit headers emitted by the filter:
	//
	//   - “X-RateLimit-Limit“ - indicates the request-quota associated to the
	//     client in the current time-window followed by the description of the
	//     quota policy. The values are returned by the rate limiting service in
	//     :ref:`current_limit<envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.DescriptorStatus.current_limit>`
	//     field. Example: “10, 10;w=1;name="per-ip", 1000;w=3600“.
	//   - “X-RateLimit-Remaining“ - indicates the remaining requests in the
	//     current time-window. The values are returned by the rate limiting service
	//     in :ref:`limit_remaining<envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.DescriptorStatus.limit_remaining>`
	//     field.
	//   - “X-RateLimit-Reset“ - indicates the number of seconds until reset of
	//     the current time-window. The values are returned by the rate limiting service
	//     in :ref:`duration_until_reset<envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.DescriptorStatus.duration_until_reset>`
	//     field.
	//
	// In case rate limiting policy specifies more then one time window, the values
	// above represent the window that is closest to reaching its limit.
	//
	// For more information about the headers specification see selected version of
	// the `draft RFC <https://tools.ietf.org/id/draft-polli-ratelimit-headers-03.html>`_.
	//
	// Disabled by default.
	//
	// [#next-major-version: unify with local ratelimit, should use common.ratelimit.v3.XRateLimitHeadersRFCVersion instead.]
	EnableXRatelimitHeaders RateLimit_XRateLimitHeadersRFCVersion `protobuf:"varint,8,opt,name=enable_x_ratelimit_headers,json=enableXRatelimitHeaders,proto3,enum=envoy.extensions.filters.http.ratelimit.v3.RateLimit_XRateLimitHeadersRFCVersion" json:"enable_x_ratelimit_headers,omitempty"`
	// Disables emitting the :ref:`x-envoy-ratelimited<config_http_filters_router_x-envoy-ratelimited>` header
	// in case of rate limiting (i.e. 429 responses).
	// Having this header not present potentially makes the request retriable.
	DisableXEnvoyRatelimitedHeader bool `protobuf:"varint,9,opt,name=disable_x_envoy_ratelimited_header,json=disableXEnvoyRatelimitedHeader,proto3" json:"disable_x_envoy_ratelimited_header,omitempty"`
	// This field allows for a custom HTTP response status code to the downstream client when
	// the request has been rate limited.
	// Defaults to 429 (TooManyRequests).
	//
	// .. note::
	//
	//	If this is set to < 400, 429 will be used instead.
	RateLimitedStatus *v31.HttpStatus `protobuf:"bytes,10,opt,name=rate_limited_status,json=rateLimitedStatus,proto3" json:"rate_limited_status,omitempty"`
	// Specifies a list of HTTP headers that should be added to each response for requests that
	// have been rate limited.
	ResponseHeadersToAdd []*v32.HeaderValueOption `protobuf:"bytes,11,rep,name=response_headers_to_add,json=responseHeadersToAdd,proto3" json:"response_headers_to_add,omitempty"`
	// Sets the HTTP status that is returned to the client when the ratelimit server returns an error
	// or cannot be reached. The default status is 500.
	StatusOnError *v31.HttpStatus `protobuf:"bytes,12,opt,name=status_on_error,json=statusOnError,proto3" json:"status_on_error,omitempty"`
	// Optional additional prefix to use when emitting statistics. This allows to distinguish
	// emitted statistics between configured “ratelimit“ filters in an HTTP filter chain.
	StatPrefix string `protobuf:"bytes,13,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
}

func (x *RateLimit) Reset() {
	*x = RateLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimit) ProtoMessage() {}

func (x *RateLimit) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimit.ProtoReflect.Descriptor instead.
func (*RateLimit) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{0}
}

func (x *RateLimit) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *RateLimit) GetStage() uint32 {
	if x != nil {
		return x.Stage
	}
	return 0
}

func (x *RateLimit) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *RateLimit) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *RateLimit) GetFailureModeDeny() bool {
	if x != nil {
		return x.FailureModeDeny
	}
	return false
}

func (x *RateLimit) GetRateLimitedAsResourceExhausted() bool {
	if x != nil {
		return x.RateLimitedAsResourceExhausted
	}
	return false
}

func (x *RateLimit) GetRateLimitService() *v3.RateLimitServiceConfig {
	if x != nil {
		return x.RateLimitService
	}
	return nil
}

func (x *RateLimit) GetEnableXRatelimitHeaders() RateLimit_XRateLimitHeadersRFCVersion {
	if x != nil {
		return x.EnableXRatelimitHeaders
	}
	return RateLimit_OFF
}

func (x *RateLimit) GetDisableXEnvoyRatelimitedHeader() bool {
	if x != nil {
		return x.DisableXEnvoyRatelimitedHeader
	}
	return false
}

func (x *RateLimit) GetRateLimitedStatus() *v31.HttpStatus {
	if x != nil {
		return x.RateLimitedStatus
	}
	return nil
}

func (x *RateLimit) GetResponseHeadersToAdd() []*v32.HeaderValueOption {
	if x != nil {
		return x.ResponseHeadersToAdd
	}
	return nil
}

func (x *RateLimit) GetStatusOnError() *v31.HttpStatus {
	if x != nil {
		return x.StatusOnError
	}
	return nil
}

func (x *RateLimit) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

// Global rate limiting :ref:`architecture overview <arch_overview_global_rate_limit>`.
// Also applies to Local rate limiting :ref:`using descriptors <config_http_filters_local_rate_limit_descriptors>`.
// [#not-implemented-hide:]
type RateLimitConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Refers to the stage set in the filter. The rate limit configuration only
	// applies to filters with the same stage number. The default stage number is
	// 0.
	//
	// .. note::
	//
	//	The filter supports a range of 0 - 10 inclusively for stage numbers.
	Stage uint32 `protobuf:"varint,1,opt,name=stage,proto3" json:"stage,omitempty"`
	// The key to be set in runtime to disable this rate limit configuration.
	DisableKey string `protobuf:"bytes,2,opt,name=disable_key,json=disableKey,proto3" json:"disable_key,omitempty"`
	// A list of actions that are to be applied for this rate limit configuration.
	// Order matters as the actions are processed sequentially and the descriptor
	// is composed by appending descriptor entries in that sequence. If an action
	// cannot append a descriptor entry, no descriptor is generated for the
	// configuration. See :ref:`composing actions
	// <config_http_filters_rate_limit_composing_actions>` for additional documentation.
	Actions []*RateLimitConfig_Action `protobuf:"bytes,3,rep,name=actions,proto3" json:"actions,omitempty"`
	// An optional limit override to be appended to the descriptor produced by this
	// rate limit configuration. If the override value is invalid or cannot be resolved
	// from metadata, no override is provided. See :ref:`rate limit override
	// <config_http_filters_rate_limit_rate_limit_override>` for more information.
	Limit *RateLimitConfig_Override `protobuf:"bytes,4,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (x *RateLimitConfig) Reset() {
	*x = RateLimitConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig) ProtoMessage() {}

func (x *RateLimitConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig.ProtoReflect.Descriptor instead.
func (*RateLimitConfig) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1}
}

func (x *RateLimitConfig) GetStage() uint32 {
	if x != nil {
		return x.Stage
	}
	return 0
}

func (x *RateLimitConfig) GetDisableKey() string {
	if x != nil {
		return x.DisableKey
	}
	return ""
}

func (x *RateLimitConfig) GetActions() []*RateLimitConfig_Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *RateLimitConfig) GetLimit() *RateLimitConfig_Override {
	if x != nil {
		return x.Limit
	}
	return nil
}

type RateLimitPerRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies if the rate limit filter should include the virtual host rate limits.
	// [#next-major-version: unify with local ratelimit, should use common.ratelimit.v3.VhRateLimitsOptions instead.]
	VhRateLimits RateLimitPerRoute_VhRateLimitsOptions `protobuf:"varint,1,opt,name=vh_rate_limits,json=vhRateLimits,proto3,enum=envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute_VhRateLimitsOptions" json:"vh_rate_limits,omitempty"`
	// Specifies if the rate limit filter should include the lower levels (route level, virtual host level or cluster weight level) rate limits override options.
	// [#not-implemented-hide:]
	OverrideOption RateLimitPerRoute_OverrideOptions `protobuf:"varint,2,opt,name=override_option,json=overrideOption,proto3,enum=envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute_OverrideOptions" json:"override_option,omitempty"`
	// Rate limit configuration. If not set, uses the
	// :ref:`VirtualHost.rate_limits<envoy_v3_api_field_config.route.v3.VirtualHost.rate_limits>` or
	// :ref:`RouteAction.rate_limits<envoy_v3_api_field_config.route.v3.RouteAction.rate_limits>` fields instead.
	// [#not-implemented-hide:]
	RateLimits []*RateLimitConfig `protobuf:"bytes,3,rep,name=rate_limits,json=rateLimits,proto3" json:"rate_limits,omitempty"`
	// Overrides the domain. If not set, uses the filter-level domain instead.
	Domain string `protobuf:"bytes,4,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *RateLimitPerRoute) Reset() {
	*x = RateLimitPerRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitPerRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitPerRoute) ProtoMessage() {}

func (x *RateLimitPerRoute) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitPerRoute.ProtoReflect.Descriptor instead.
func (*RateLimitPerRoute) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{2}
}

func (x *RateLimitPerRoute) GetVhRateLimits() RateLimitPerRoute_VhRateLimitsOptions {
	if x != nil {
		return x.VhRateLimits
	}
	return RateLimitPerRoute_OVERRIDE
}

func (x *RateLimitPerRoute) GetOverrideOption() RateLimitPerRoute_OverrideOptions {
	if x != nil {
		return x.OverrideOption
	}
	return RateLimitPerRoute_DEFAULT
}

func (x *RateLimitPerRoute) GetRateLimits() []*RateLimitConfig {
	if x != nil {
		return x.RateLimits
	}
	return nil
}

func (x *RateLimitPerRoute) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

// [#next-free-field: 10]
type RateLimitConfig_Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ActionSpecifier:
	//
	//	*RateLimitConfig_Action_SourceCluster_
	//	*RateLimitConfig_Action_DestinationCluster_
	//	*RateLimitConfig_Action_RequestHeaders_
	//	*RateLimitConfig_Action_RemoteAddress_
	//	*RateLimitConfig_Action_GenericKey_
	//	*RateLimitConfig_Action_HeaderValueMatch_
	//	*RateLimitConfig_Action_Metadata
	//	*RateLimitConfig_Action_Extension
	ActionSpecifier isRateLimitConfig_Action_ActionSpecifier `protobuf_oneof:"action_specifier"`
}

func (x *RateLimitConfig_Action) Reset() {
	*x = RateLimitConfig_Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Action) ProtoMessage() {}

func (x *RateLimitConfig_Action) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Action.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Action) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0}
}

func (m *RateLimitConfig_Action) GetActionSpecifier() isRateLimitConfig_Action_ActionSpecifier {
	if m != nil {
		return m.ActionSpecifier
	}
	return nil
}

func (x *RateLimitConfig_Action) GetSourceCluster() *RateLimitConfig_Action_SourceCluster {
	if x, ok := x.GetActionSpecifier().(*RateLimitConfig_Action_SourceCluster_); ok {
		return x.SourceCluster
	}
	return nil
}

func (x *RateLimitConfig_Action) GetDestinationCluster() *RateLimitConfig_Action_DestinationCluster {
	if x, ok := x.GetActionSpecifier().(*RateLimitConfig_Action_DestinationCluster_); ok {
		return x.DestinationCluster
	}
	return nil
}

func (x *RateLimitConfig_Action) GetRequestHeaders() *RateLimitConfig_Action_RequestHeaders {
	if x, ok := x.GetActionSpecifier().(*RateLimitConfig_Action_RequestHeaders_); ok {
		return x.RequestHeaders
	}
	return nil
}

func (x *RateLimitConfig_Action) GetRemoteAddress() *RateLimitConfig_Action_RemoteAddress {
	if x, ok := x.GetActionSpecifier().(*RateLimitConfig_Action_RemoteAddress_); ok {
		return x.RemoteAddress
	}
	return nil
}

func (x *RateLimitConfig_Action) GetGenericKey() *RateLimitConfig_Action_GenericKey {
	if x, ok := x.GetActionSpecifier().(*RateLimitConfig_Action_GenericKey_); ok {
		return x.GenericKey
	}
	return nil
}

func (x *RateLimitConfig_Action) GetHeaderValueMatch() *RateLimitConfig_Action_HeaderValueMatch {
	if x, ok := x.GetActionSpecifier().(*RateLimitConfig_Action_HeaderValueMatch_); ok {
		return x.HeaderValueMatch
	}
	return nil
}

func (x *RateLimitConfig_Action) GetMetadata() *RateLimitConfig_Action_MetaData {
	if x, ok := x.GetActionSpecifier().(*RateLimitConfig_Action_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (x *RateLimitConfig_Action) GetExtension() *v32.TypedExtensionConfig {
	if x, ok := x.GetActionSpecifier().(*RateLimitConfig_Action_Extension); ok {
		return x.Extension
	}
	return nil
}

type isRateLimitConfig_Action_ActionSpecifier interface {
	isRateLimitConfig_Action_ActionSpecifier()
}

type RateLimitConfig_Action_SourceCluster_ struct {
	// Rate limit on source cluster.
	SourceCluster *RateLimitConfig_Action_SourceCluster `protobuf:"bytes,1,opt,name=source_cluster,json=sourceCluster,proto3,oneof"`
}

type RateLimitConfig_Action_DestinationCluster_ struct {
	// Rate limit on destination cluster.
	DestinationCluster *RateLimitConfig_Action_DestinationCluster `protobuf:"bytes,2,opt,name=destination_cluster,json=destinationCluster,proto3,oneof"`
}

type RateLimitConfig_Action_RequestHeaders_ struct {
	// Rate limit on request headers.
	RequestHeaders *RateLimitConfig_Action_RequestHeaders `protobuf:"bytes,3,opt,name=request_headers,json=requestHeaders,proto3,oneof"`
}

type RateLimitConfig_Action_RemoteAddress_ struct {
	// Rate limit on remote address.
	RemoteAddress *RateLimitConfig_Action_RemoteAddress `protobuf:"bytes,4,opt,name=remote_address,json=remoteAddress,proto3,oneof"`
}

type RateLimitConfig_Action_GenericKey_ struct {
	// Rate limit on a generic key.
	GenericKey *RateLimitConfig_Action_GenericKey `protobuf:"bytes,5,opt,name=generic_key,json=genericKey,proto3,oneof"`
}

type RateLimitConfig_Action_HeaderValueMatch_ struct {
	// Rate limit on the existence of request headers.
	HeaderValueMatch *RateLimitConfig_Action_HeaderValueMatch `protobuf:"bytes,6,opt,name=header_value_match,json=headerValueMatch,proto3,oneof"`
}

type RateLimitConfig_Action_Metadata struct {
	// Rate limit on metadata.
	Metadata *RateLimitConfig_Action_MetaData `protobuf:"bytes,8,opt,name=metadata,proto3,oneof"`
}

type RateLimitConfig_Action_Extension struct {
	// Rate limit descriptor extension. See the rate limit descriptor extensions documentation.
	// [#extension-category: envoy.rate_limit_descriptors]
	Extension *v32.TypedExtensionConfig `protobuf:"bytes,9,opt,name=extension,proto3,oneof"`
}

func (*RateLimitConfig_Action_SourceCluster_) isRateLimitConfig_Action_ActionSpecifier() {}

func (*RateLimitConfig_Action_DestinationCluster_) isRateLimitConfig_Action_ActionSpecifier() {}

func (*RateLimitConfig_Action_RequestHeaders_) isRateLimitConfig_Action_ActionSpecifier() {}

func (*RateLimitConfig_Action_RemoteAddress_) isRateLimitConfig_Action_ActionSpecifier() {}

func (*RateLimitConfig_Action_GenericKey_) isRateLimitConfig_Action_ActionSpecifier() {}

func (*RateLimitConfig_Action_HeaderValueMatch_) isRateLimitConfig_Action_ActionSpecifier() {}

func (*RateLimitConfig_Action_Metadata) isRateLimitConfig_Action_ActionSpecifier() {}

func (*RateLimitConfig_Action_Extension) isRateLimitConfig_Action_ActionSpecifier() {}

type RateLimitConfig_Override struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OverrideSpecifier:
	//
	//	*RateLimitConfig_Override_DynamicMetadata_
	OverrideSpecifier isRateLimitConfig_Override_OverrideSpecifier `protobuf_oneof:"override_specifier"`
}

func (x *RateLimitConfig_Override) Reset() {
	*x = RateLimitConfig_Override{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Override) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Override) ProtoMessage() {}

func (x *RateLimitConfig_Override) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Override.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Override) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 1}
}

func (m *RateLimitConfig_Override) GetOverrideSpecifier() isRateLimitConfig_Override_OverrideSpecifier {
	if m != nil {
		return m.OverrideSpecifier
	}
	return nil
}

func (x *RateLimitConfig_Override) GetDynamicMetadata() *RateLimitConfig_Override_DynamicMetadata {
	if x, ok := x.GetOverrideSpecifier().(*RateLimitConfig_Override_DynamicMetadata_); ok {
		return x.DynamicMetadata
	}
	return nil
}

type isRateLimitConfig_Override_OverrideSpecifier interface {
	isRateLimitConfig_Override_OverrideSpecifier()
}

type RateLimitConfig_Override_DynamicMetadata_ struct {
	// Limit override from dynamic metadata.
	DynamicMetadata *RateLimitConfig_Override_DynamicMetadata `protobuf:"bytes,1,opt,name=dynamic_metadata,json=dynamicMetadata,proto3,oneof"`
}

func (*RateLimitConfig_Override_DynamicMetadata_) isRateLimitConfig_Override_OverrideSpecifier() {}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//	("source_cluster", "<local service cluster>")
//
// <local service cluster> is derived from the :option:`--service-cluster` option.
type RateLimitConfig_Action_SourceCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RateLimitConfig_Action_SourceCluster) Reset() {
	*x = RateLimitConfig_Action_SourceCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Action_SourceCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Action_SourceCluster) ProtoMessage() {}

func (x *RateLimitConfig_Action_SourceCluster) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Action_SourceCluster.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Action_SourceCluster) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0, 0}
}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//	("destination_cluster", "<routed target cluster>")
//
// Once a request matches against a route table rule, a routed cluster is determined by one of
// the following :ref:`route table configuration <envoy_v3_api_msg_config.route.v3.RouteConfiguration>`
// settings:
//
//   - :ref:`cluster <envoy_v3_api_field_config.route.v3.RouteAction.cluster>` indicates the upstream cluster
//     to route to.
//   - :ref:`weighted_clusters <envoy_v3_api_field_config.route.v3.RouteAction.weighted_clusters>`
//     chooses a cluster randomly from a set of clusters with attributed weight.
//   - :ref:`cluster_header <envoy_v3_api_field_config.route.v3.RouteAction.cluster_header>` indicates which
//     header in the request contains the target cluster.
type RateLimitConfig_Action_DestinationCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RateLimitConfig_Action_DestinationCluster) Reset() {
	*x = RateLimitConfig_Action_DestinationCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Action_DestinationCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Action_DestinationCluster) ProtoMessage() {}

func (x *RateLimitConfig_Action_DestinationCluster) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Action_DestinationCluster.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Action_DestinationCluster) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0, 1}
}

// The following descriptor entry is appended when a header contains a key that matches the
// “header_name“:
//
// .. code-block:: cpp
//
//	("<descriptor_key>", "<header_value_queried_from_header>")
type RateLimitConfig_Action_RequestHeaders struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The header name to be queried from the request headers. The header’s
	// value is used to populate the value of the descriptor entry for the
	// descriptor_key.
	HeaderName string `protobuf:"bytes,1,opt,name=header_name,json=headerName,proto3" json:"header_name,omitempty"`
	// The key to use in the descriptor entry.
	DescriptorKey string `protobuf:"bytes,2,opt,name=descriptor_key,json=descriptorKey,proto3" json:"descriptor_key,omitempty"`
	// If set to true, Envoy skips the descriptor while calling rate limiting service
	// when header is not present in the request. By default it skips calling the
	// rate limiting service if this header is not present in the request.
	SkipIfAbsent bool `protobuf:"varint,3,opt,name=skip_if_absent,json=skipIfAbsent,proto3" json:"skip_if_absent,omitempty"`
}

func (x *RateLimitConfig_Action_RequestHeaders) Reset() {
	*x = RateLimitConfig_Action_RequestHeaders{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Action_RequestHeaders) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Action_RequestHeaders) ProtoMessage() {}

func (x *RateLimitConfig_Action_RequestHeaders) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Action_RequestHeaders.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Action_RequestHeaders) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0, 2}
}

func (x *RateLimitConfig_Action_RequestHeaders) GetHeaderName() string {
	if x != nil {
		return x.HeaderName
	}
	return ""
}

func (x *RateLimitConfig_Action_RequestHeaders) GetDescriptorKey() string {
	if x != nil {
		return x.DescriptorKey
	}
	return ""
}

func (x *RateLimitConfig_Action_RequestHeaders) GetSkipIfAbsent() bool {
	if x != nil {
		return x.SkipIfAbsent
	}
	return false
}

// The following descriptor entry is appended to the descriptor and is populated using the
// trusted address from :ref:`x-forwarded-for <config_http_conn_man_headers_x-forwarded-for>`:
//
// .. code-block:: cpp
//
//	("remote_address", "<trusted address from x-forwarded-for>")
type RateLimitConfig_Action_RemoteAddress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RateLimitConfig_Action_RemoteAddress) Reset() {
	*x = RateLimitConfig_Action_RemoteAddress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Action_RemoteAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Action_RemoteAddress) ProtoMessage() {}

func (x *RateLimitConfig_Action_RemoteAddress) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Action_RemoteAddress.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Action_RemoteAddress) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0, 3}
}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//	("generic_key", "<descriptor_value>")
type RateLimitConfig_Action_GenericKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value to use in the descriptor entry.
	DescriptorValue string `protobuf:"bytes,1,opt,name=descriptor_value,json=descriptorValue,proto3" json:"descriptor_value,omitempty"`
	// An optional key to use in the descriptor entry. If not set it defaults
	// to 'generic_key' as the descriptor key.
	DescriptorKey string `protobuf:"bytes,2,opt,name=descriptor_key,json=descriptorKey,proto3" json:"descriptor_key,omitempty"`
}

func (x *RateLimitConfig_Action_GenericKey) Reset() {
	*x = RateLimitConfig_Action_GenericKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Action_GenericKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Action_GenericKey) ProtoMessage() {}

func (x *RateLimitConfig_Action_GenericKey) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Action_GenericKey.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Action_GenericKey) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0, 4}
}

func (x *RateLimitConfig_Action_GenericKey) GetDescriptorValue() string {
	if x != nil {
		return x.DescriptorValue
	}
	return ""
}

func (x *RateLimitConfig_Action_GenericKey) GetDescriptorKey() string {
	if x != nil {
		return x.DescriptorKey
	}
	return ""
}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//	("header_match", "<descriptor_value>")
type RateLimitConfig_Action_HeaderValueMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value to use in the descriptor entry.
	DescriptorValue string `protobuf:"bytes,1,opt,name=descriptor_value,json=descriptorValue,proto3" json:"descriptor_value,omitempty"`
	// If set to true, the action will append a descriptor entry when the
	// request matches the headers. If set to false, the action will append a
	// descriptor entry when the request does not match the headers. The
	// default value is true.
	ExpectMatch bool `protobuf:"varint,2,opt,name=expect_match,json=expectMatch,proto3" json:"expect_match,omitempty"`
	// Specifies a set of headers that the rate limit action should match
	// on. The action will check the request’s headers against all the
	// specified headers in the config. A match will happen if all the
	// headers in the config are present in the request with the same values
	// (or based on presence if the value field is not in the config).
	Headers []*v33.HeaderMatcher `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty"`
}

func (x *RateLimitConfig_Action_HeaderValueMatch) Reset() {
	*x = RateLimitConfig_Action_HeaderValueMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Action_HeaderValueMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Action_HeaderValueMatch) ProtoMessage() {}

func (x *RateLimitConfig_Action_HeaderValueMatch) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Action_HeaderValueMatch.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Action_HeaderValueMatch) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0, 5}
}

func (x *RateLimitConfig_Action_HeaderValueMatch) GetDescriptorValue() string {
	if x != nil {
		return x.DescriptorValue
	}
	return ""
}

func (x *RateLimitConfig_Action_HeaderValueMatch) GetExpectMatch() bool {
	if x != nil {
		return x.ExpectMatch
	}
	return false
}

func (x *RateLimitConfig_Action_HeaderValueMatch) GetHeaders() []*v33.HeaderMatcher {
	if x != nil {
		return x.Headers
	}
	return nil
}

// The following descriptor entry is appended when the metadata contains a key value:
//
// .. code-block:: cpp
//
//	("<descriptor_key>", "<value_queried_from_metadata>")
//
// [#next-free-field: 6]
type RateLimitConfig_Action_MetaData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key to use in the descriptor entry.
	DescriptorKey string `protobuf:"bytes,1,opt,name=descriptor_key,json=descriptorKey,proto3" json:"descriptor_key,omitempty"`
	// Metadata struct that defines the key and path to retrieve the string value. A match will
	// only happen if the value in the metadata is of type string.
	MetadataKey *v34.MetadataKey `protobuf:"bytes,2,opt,name=metadata_key,json=metadataKey,proto3" json:"metadata_key,omitempty"`
	// An optional value to use if “metadata_key“ is empty. If not set and
	// no value is present under the metadata_key then “skip_if_absent“ is followed to
	// skip calling the rate limiting service or skip the descriptor.
	DefaultValue string `protobuf:"bytes,3,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// Source of metadata
	Source RateLimitConfig_Action_MetaData_Source `protobuf:"varint,4,opt,name=source,proto3,enum=envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig_Action_MetaData_Source" json:"source,omitempty"`
	// If set to true, Envoy skips the descriptor while calling rate limiting service
	// when “metadata_key“ is empty and “default_value“ is not set. By default it skips calling the
	// rate limiting service in that case.
	SkipIfAbsent bool `protobuf:"varint,5,opt,name=skip_if_absent,json=skipIfAbsent,proto3" json:"skip_if_absent,omitempty"`
}

func (x *RateLimitConfig_Action_MetaData) Reset() {
	*x = RateLimitConfig_Action_MetaData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Action_MetaData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Action_MetaData) ProtoMessage() {}

func (x *RateLimitConfig_Action_MetaData) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Action_MetaData.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Action_MetaData) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0, 6}
}

func (x *RateLimitConfig_Action_MetaData) GetDescriptorKey() string {
	if x != nil {
		return x.DescriptorKey
	}
	return ""
}

func (x *RateLimitConfig_Action_MetaData) GetMetadataKey() *v34.MetadataKey {
	if x != nil {
		return x.MetadataKey
	}
	return nil
}

func (x *RateLimitConfig_Action_MetaData) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

func (x *RateLimitConfig_Action_MetaData) GetSource() RateLimitConfig_Action_MetaData_Source {
	if x != nil {
		return x.Source
	}
	return RateLimitConfig_Action_MetaData_DYNAMIC
}

func (x *RateLimitConfig_Action_MetaData) GetSkipIfAbsent() bool {
	if x != nil {
		return x.SkipIfAbsent
	}
	return false
}

// Fetches the override from the dynamic metadata.
type RateLimitConfig_Override_DynamicMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata struct that defines the key and path to retrieve the struct value.
	// The value must be a struct containing an integer "requests_per_unit" property
	// and a "unit" property with a value parseable to :ref:`RateLimitUnit
	// enum <envoy_v3_api_enum_type.v3.RateLimitUnit>`
	MetadataKey *v34.MetadataKey `protobuf:"bytes,1,opt,name=metadata_key,json=metadataKey,proto3" json:"metadata_key,omitempty"`
}

func (x *RateLimitConfig_Override_DynamicMetadata) Reset() {
	*x = RateLimitConfig_Override_DynamicMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitConfig_Override_DynamicMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitConfig_Override_DynamicMetadata) ProtoMessage() {}

func (x *RateLimitConfig_Override_DynamicMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitConfig_Override_DynamicMetadata.ProtoReflect.Descriptor instead.
func (*RateLimitConfig_Override_DynamicMetadata) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (x *RateLimitConfig_Override_DynamicMetadata) GetMetadataKey() *v34.MetadataKey {
	if x != nil {
		return x.MetadataKey
	}
	return nil
}

var File_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto protoreflect.FileDescriptor

var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f,
	0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74,
	0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33,
	0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x72,
	0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x6c, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75, 0x64, 0x70,
	0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x75, 0x64, 0x70, 0x61,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa0, 0x08, 0x0a, 0x09, 0x52, 0x61, 0x74, 0x65, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x12, 0x1f, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x06, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x1d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x0a, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x67, 0x65, 0x12, 0x44, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xfa, 0x42, 0x1e, 0x72,
	0x1c, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x08, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x04, 0x62, 0x6f, 0x74, 0x68, 0x52, 0x00, 0x52, 0x0b, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12,
	0x2a, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x5f,
	0x64, 0x65, 0x6e, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x6e, 0x79, 0x12, 0x4a, 0x0a, 0x22, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x68, 0x61, 0x75, 0x73, 0x74, 0x65,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1e, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x65, 0x64, 0x41, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x78,
	0x68, 0x61, 0x75, 0x73, 0x74, 0x65, 0x64, 0x12, 0x69, 0x0a, 0x12, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x10, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x98, 0x01, 0x0a, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x78, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x58,
	0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x52, 0x46, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x58, 0x52, 0x61, 0x74,
	0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x4a, 0x0a,
	0x22, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x78, 0x5f, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1e, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x58, 0x45, 0x6e, 0x76, 0x6f, 0x79, 0x52, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x65, 0x64, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x13, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x11, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x68, 0x0a, 0x17, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x61, 0x64, 0x64, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x0a, 0x52, 0x14, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x54, 0x6f, 0x41, 0x64, 0x64, 0x12, 0x41,
	0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4f, 0x6e, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x22, 0x3c, 0x0a, 0x1b, 0x58, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x52, 0x46, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x52,
	0x41, 0x46, 0x54, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x30, 0x33, 0x10, 0x01,
	0x3a, 0x37, 0x9a, 0xc5, 0x88, 0x1e, 0x32, 0x0a, 0x30, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0xe0, 0x12, 0x0a, 0x0f, 0x52, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42,
	0x04, 0x2a, 0x02, 0x18, 0x0a, 0x52, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x66, 0x0a,
	0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72,
	0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x07, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x1a, 0xb7, 0x0e, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x79, 0x0a, 0x0e,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x88, 0x01, 0x0a, 0x13, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x12,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x7c, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x48, 0x00,
	0x52, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x12, 0x79, 0x0a, 0x0e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x70, 0x0a, 0x0b, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4d, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x48,
	0x00, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x83, 0x01,
	0x0a, 0x12, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x48,
	0x00, 0x52, 0x10, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x69, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61,
	0x74, 0x61, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4a,
	0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x0f, 0x0a, 0x0d, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x1a, 0x14, 0x0a, 0x12, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x1a, 0x96, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x12, 0x2e, 0x0a, 0x0b, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0d, 0xfa, 0x42, 0x0a, 0x72, 0x08,
	0x10, 0x01, 0xc8, 0x01, 0x00, 0xc0, 0x01, 0x01, 0x52, 0x0a, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x0e, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42,
	0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x0d, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x4b, 0x65, 0x79, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x69, 0x66, 0x5f,
	0x61, 0x62, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x73, 0x6b,
	0x69, 0x70, 0x49, 0x66, 0x41, 0x62, 0x73, 0x65, 0x6e, 0x74, 0x1a, 0x0f, 0x0a, 0x0d, 0x52, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x67, 0x0a, 0x0a, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x32, 0x0a, 0x10, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x0f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x4b, 0x65, 0x79, 0x1a, 0xb3, 0x01, 0x0a, 0x10, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x32, 0x0a, 0x10, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x0f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x12, 0x48, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08,
	0x01, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x1a, 0xf5, 0x02, 0x0a, 0x08, 0x4d,
	0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x12, 0x2e, 0x0a, 0x0e, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x0d, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x6f, 0x72, 0x4b, 0x65, 0x79, 0x12, 0x50, 0x0a, 0x0c, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4b,
	0x65, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0b, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4b, 0x65, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x74,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72,
	0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x69, 0x66, 0x5f,
	0x61, 0x62, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x73, 0x6b,
	0x69, 0x70, 0x49, 0x66, 0x41, 0x62, 0x73, 0x65, 0x6e, 0x74, 0x22, 0x26, 0x0a, 0x06, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x10,
	0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x52, 0x59,
	0x10, 0x01, 0x42, 0x17, 0x0a, 0x10, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x1a, 0x8e, 0x02, 0x0a, 0x08,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x10, 0x64, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x63, 0x0a, 0x0f,
	0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x50, 0x0a, 0x0c, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4b, 0x65, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x0b, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4b, 0x65,
	0x79, 0x42, 0x19, 0x0a, 0x12, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0xaa, 0x04, 0x0a,
	0x11, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x50, 0x65, 0x72, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x0e, 0x76, 0x68, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x50, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x56, 0x68, 0x52, 0x61, 0x74,
	0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x76, 0x68, 0x52, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x0f, 0x6f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4d, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x50, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x0b, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72,
	0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x72, 0x61, 0x74,
	0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x22,
	0x3c, 0x0a, 0x13, 0x56, 0x68, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x56, 0x45, 0x52, 0x52, 0x49,
	0x44, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x10, 0x02, 0x22, 0x5a, 0x0a,
	0x0f, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x13, 0x0a,
	0x0f, 0x4f, 0x56, 0x45, 0x52, 0x52, 0x49, 0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x5f, 0x50, 0x4f,
	0x4c, 0x49, 0x43, 0x59, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45,
	0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x03, 0x42, 0xb3, 0x01, 0xba, 0x80, 0xc8, 0xd1,
	0x06, 0x02, 0x10, 0x02, 0x0a, 0x38, 0x69, 0x6f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x42, 0x0e,
	0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x5d, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2f, 0x67, 0x6f, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x2d, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x2f, 0x76, 0x33, 0x3b, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x76, 0x33, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescData = file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDesc
)

func file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescData)
	})
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescData
}

var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_goTypes = []interface{}{
	(RateLimit_XRateLimitHeadersRFCVersion)(0),        // 0: envoy.extensions.filters.http.ratelimit.v3.RateLimit.XRateLimitHeadersRFCVersion
	(RateLimitConfig_Action_MetaData_Source)(0),       // 1: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.MetaData.Source
	(RateLimitPerRoute_VhRateLimitsOptions)(0),        // 2: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.VhRateLimitsOptions
	(RateLimitPerRoute_OverrideOptions)(0),            // 3: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.OverrideOptions
	(*RateLimit)(nil),                                 // 4: envoy.extensions.filters.http.ratelimit.v3.RateLimit
	(*RateLimitConfig)(nil),                           // 5: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig
	(*RateLimitPerRoute)(nil),                         // 6: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute
	(*RateLimitConfig_Action)(nil),                    // 7: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action
	(*RateLimitConfig_Override)(nil),                  // 8: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Override
	(*RateLimitConfig_Action_SourceCluster)(nil),      // 9: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.SourceCluster
	(*RateLimitConfig_Action_DestinationCluster)(nil), // 10: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.DestinationCluster
	(*RateLimitConfig_Action_RequestHeaders)(nil),     // 11: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.RequestHeaders
	(*RateLimitConfig_Action_RemoteAddress)(nil),      // 12: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.RemoteAddress
	(*RateLimitConfig_Action_GenericKey)(nil),         // 13: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.GenericKey
	(*RateLimitConfig_Action_HeaderValueMatch)(nil),   // 14: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.HeaderValueMatch
	(*RateLimitConfig_Action_MetaData)(nil),           // 15: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.MetaData
	(*RateLimitConfig_Override_DynamicMetadata)(nil),  // 16: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Override.DynamicMetadata
	(*durationpb.Duration)(nil),                       // 17: google.protobuf.Duration
	(*v3.RateLimitServiceConfig)(nil),                 // 18: envoy.config.ratelimit.v3.RateLimitServiceConfig
	(*v31.HttpStatus)(nil),                            // 19: envoy.type.v3.HttpStatus
	(*v32.HeaderValueOption)(nil),                     // 20: envoy.config.core.v3.HeaderValueOption
	(*v32.TypedExtensionConfig)(nil),                  // 21: envoy.config.core.v3.TypedExtensionConfig
	(*v33.HeaderMatcher)(nil),                         // 22: envoy.config.route.v3.HeaderMatcher
	(*v34.MetadataKey)(nil),                           // 23: envoy.type.metadata.v3.MetadataKey
}
var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_depIdxs = []int32{
	17, // 0: envoy.extensions.filters.http.ratelimit.v3.RateLimit.timeout:type_name -> google.protobuf.Duration
	18, // 1: envoy.extensions.filters.http.ratelimit.v3.RateLimit.rate_limit_service:type_name -> envoy.config.ratelimit.v3.RateLimitServiceConfig
	0,  // 2: envoy.extensions.filters.http.ratelimit.v3.RateLimit.enable_x_ratelimit_headers:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimit.XRateLimitHeadersRFCVersion
	19, // 3: envoy.extensions.filters.http.ratelimit.v3.RateLimit.rate_limited_status:type_name -> envoy.type.v3.HttpStatus
	20, // 4: envoy.extensions.filters.http.ratelimit.v3.RateLimit.response_headers_to_add:type_name -> envoy.config.core.v3.HeaderValueOption
	19, // 5: envoy.extensions.filters.http.ratelimit.v3.RateLimit.status_on_error:type_name -> envoy.type.v3.HttpStatus
	7,  // 6: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.actions:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action
	8,  // 7: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.limit:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Override
	2,  // 8: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.vh_rate_limits:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.VhRateLimitsOptions
	3,  // 9: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.override_option:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.OverrideOptions
	5,  // 10: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.rate_limits:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig
	9,  // 11: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.source_cluster:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.SourceCluster
	10, // 12: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.destination_cluster:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.DestinationCluster
	11, // 13: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.request_headers:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.RequestHeaders
	12, // 14: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.remote_address:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.RemoteAddress
	13, // 15: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.generic_key:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.GenericKey
	14, // 16: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.header_value_match:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.HeaderValueMatch
	15, // 17: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.metadata:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.MetaData
	21, // 18: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.extension:type_name -> envoy.config.core.v3.TypedExtensionConfig
	16, // 19: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Override.dynamic_metadata:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Override.DynamicMetadata
	22, // 20: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.HeaderValueMatch.headers:type_name -> envoy.config.route.v3.HeaderMatcher
	23, // 21: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.MetaData.metadata_key:type_name -> envoy.type.metadata.v3.MetadataKey
	1,  // 22: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.MetaData.source:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Action.MetaData.Source
	23, // 23: envoy.extensions.filters.http.ratelimit.v3.RateLimitConfig.Override.DynamicMetadata.metadata_key:type_name -> envoy.type.metadata.v3.MetadataKey
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_init() }
func file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_init() {
	if File_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitPerRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Override); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Action_SourceCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Action_DestinationCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Action_RequestHeaders); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Action_RemoteAddress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Action_GenericKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Action_HeaderValueMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Action_MetaData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitConfig_Override_DynamicMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*RateLimitConfig_Action_SourceCluster_)(nil),
		(*RateLimitConfig_Action_DestinationCluster_)(nil),
		(*RateLimitConfig_Action_RequestHeaders_)(nil),
		(*RateLimitConfig_Action_RemoteAddress_)(nil),
		(*RateLimitConfig_Action_GenericKey_)(nil),
		(*RateLimitConfig_Action_HeaderValueMatch_)(nil),
		(*RateLimitConfig_Action_Metadata)(nil),
		(*RateLimitConfig_Action_Extension)(nil),
	}
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*RateLimitConfig_Override_DynamicMetadata_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_depIdxs,
		EnumInfos:         file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes,
		MessageInfos:      file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto = out.File
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDesc = nil
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_goTypes = nil
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_depIdxs = nil
}
