/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteVpc
extends BaseCmd {
    private String vpcId;

    public DeleteVpc(String[] args) {
        super("ec2delvpc", "ec2-delete-vpc");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "VPC";
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes a VPC. You must terminate all running instances and delete all");
        System.out.println("     subnets before deleting the VPC.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.vpcId = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.deleteVpc(this.vpcId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputObjectId(System.out, "VPC", this.vpcId);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("VPC");
        this.warnIfTooManyNonOptions();
    }

    public static void main(String[] args) {
        new DeleteVpc(args).invoke();
    }
}

