/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeReservedInstancesModifications
extends BaseCmd {
    public DescribeReservedInstancesModifications(String[] args) {
        super("ec2drim", "ec2-describe-reserved-instances-modifications");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("    Describes the modifications made to your Reserved Instances.");
        System.out.println("    If no parameter is specified, information about all your Reserved Instances");
        System.out.println("    modifications will be returned. If a MODIFICATION-ID is specified,");
        System.out.println("    only information about the specific modification will be returned.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected String getOptionString() {
        return "[MODIFICATION-ID [MODIFICATION-ID [...]]]";
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        String nextToken = null;
        do {
            rsp = jec2.describeReservedInstancesModifications(Arrays.asList(this.getNonOptions()), nextToken, this.getFilters(true));
            out.outputReservedInstancesModifications(System.out, (List)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
        } while ((nextToken = rsp.getNextToken()) != null);
        return true;
    }

    public static void main(String[] args) {
        new DescribeReservedInstancesModifications(args).invoke();
    }
}

