// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package recaptchaenterprisepb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	RecaptchaEnterpriseService_CreateAssessment_FullMethodName                     = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateAssessment"
	RecaptchaEnterpriseService_AnnotateAssessment_FullMethodName                   = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/AnnotateAssessment"
	RecaptchaEnterpriseService_CreateKey_FullMethodName                            = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateKey"
	RecaptchaEnterpriseService_ListKeys_FullMethodName                             = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListKeys"
	RecaptchaEnterpriseService_RetrieveLegacySecretKey_FullMethodName              = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/RetrieveLegacySecretKey"
	RecaptchaEnterpriseService_GetKey_FullMethodName                               = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetKey"
	RecaptchaEnterpriseService_UpdateKey_FullMethodName                            = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/UpdateKey"
	RecaptchaEnterpriseService_DeleteKey_FullMethodName                            = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/DeleteKey"
	RecaptchaEnterpriseService_MigrateKey_FullMethodName                           = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/MigrateKey"
	RecaptchaEnterpriseService_AddIpOverride_FullMethodName                        = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/AddIpOverride"
	RecaptchaEnterpriseService_RemoveIpOverride_FullMethodName                     = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/RemoveIpOverride"
	RecaptchaEnterpriseService_ListIpOverrides_FullMethodName                      = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListIpOverrides"
	RecaptchaEnterpriseService_GetMetrics_FullMethodName                           = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetMetrics"
	RecaptchaEnterpriseService_CreateFirewallPolicy_FullMethodName                 = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateFirewallPolicy"
	RecaptchaEnterpriseService_ListFirewallPolicies_FullMethodName                 = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListFirewallPolicies"
	RecaptchaEnterpriseService_GetFirewallPolicy_FullMethodName                    = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetFirewallPolicy"
	RecaptchaEnterpriseService_UpdateFirewallPolicy_FullMethodName                 = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/UpdateFirewallPolicy"
	RecaptchaEnterpriseService_DeleteFirewallPolicy_FullMethodName                 = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/DeleteFirewallPolicy"
	RecaptchaEnterpriseService_ReorderFirewallPolicies_FullMethodName              = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ReorderFirewallPolicies"
	RecaptchaEnterpriseService_ListRelatedAccountGroups_FullMethodName             = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListRelatedAccountGroups"
	RecaptchaEnterpriseService_ListRelatedAccountGroupMemberships_FullMethodName   = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListRelatedAccountGroupMemberships"
	RecaptchaEnterpriseService_SearchRelatedAccountGroupMemberships_FullMethodName = "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/SearchRelatedAccountGroupMemberships"
)

// RecaptchaEnterpriseServiceClient is the client API for RecaptchaEnterpriseService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RecaptchaEnterpriseServiceClient interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fraudulent.
	AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error)
	// Creates a new reCAPTCHA Enterprise key.
	CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Returns the list of all keys that belong to a project.
	ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error)
	// Returns the secret key related to the specified public key.
	// You must use the legacy secret key only in a 3rd party integration with
	// legacy reCAPTCHA.
	RetrieveLegacySecretKey(ctx context.Context, in *RetrieveLegacySecretKeyRequest, opts ...grpc.CallOption) (*RetrieveLegacySecretKeyResponse, error)
	// Returns the specified key.
	GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Updates the specified key.
	UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Deletes the specified key.
	DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Migrates an existing key from reCAPTCHA to reCAPTCHA Enterprise.
	// Once a key is migrated, it can be used from either product. SiteVerify
	// requests are billed as CreateAssessment calls. You must be
	// authenticated as one of the current owners of the reCAPTCHA Key, and
	// your user must have the reCAPTCHA Enterprise Admin IAM role in the
	// destination project.
	MigrateKey(ctx context.Context, in *MigrateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Adds an IP override to a key. The following restrictions hold:
	//   - The maximum number of IP overrides per key is 1000.
	//   - For any conflict (such as IP already exists or IP part of an existing
	//     IP range), an error is returned.
	AddIpOverride(ctx context.Context, in *AddIpOverrideRequest, opts ...grpc.CallOption) (*AddIpOverrideResponse, error)
	// Removes an IP override from a key. The following restrictions hold:
	// * If the IP isn't found in an existing IP override, a `NOT_FOUND` error
	// is returned.
	// * If the IP is found in an existing IP override, but the
	// override type does not match, a `NOT_FOUND` error is returned.
	RemoveIpOverride(ctx context.Context, in *RemoveIpOverrideRequest, opts ...grpc.CallOption) (*RemoveIpOverrideResponse, error)
	// Lists all IP overrides for a key.
	ListIpOverrides(ctx context.Context, in *ListIpOverridesRequest, opts ...grpc.CallOption) (*ListIpOverridesResponse, error)
	// Get some aggregated metrics for a Key. This data can be used to build
	// dashboards.
	GetMetrics(ctx context.Context, in *GetMetricsRequest, opts ...grpc.CallOption) (*Metrics, error)
	// Creates a new FirewallPolicy, specifying conditions at which reCAPTCHA
	// Enterprise actions can be executed.
	// A project may have a maximum of 1000 policies.
	CreateFirewallPolicy(ctx context.Context, in *CreateFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error)
	// Returns the list of all firewall policies that belong to a project.
	ListFirewallPolicies(ctx context.Context, in *ListFirewallPoliciesRequest, opts ...grpc.CallOption) (*ListFirewallPoliciesResponse, error)
	// Returns the specified firewall policy.
	GetFirewallPolicy(ctx context.Context, in *GetFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error)
	// Updates the specified firewall policy.
	UpdateFirewallPolicy(ctx context.Context, in *UpdateFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error)
	// Deletes the specified firewall policy.
	DeleteFirewallPolicy(ctx context.Context, in *DeleteFirewallPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Reorders all firewall policies.
	ReorderFirewallPolicies(ctx context.Context, in *ReorderFirewallPoliciesRequest, opts ...grpc.CallOption) (*ReorderFirewallPoliciesResponse, error)
	// List groups of related accounts.
	ListRelatedAccountGroups(ctx context.Context, in *ListRelatedAccountGroupsRequest, opts ...grpc.CallOption) (*ListRelatedAccountGroupsResponse, error)
	// Get memberships in a group of related accounts.
	ListRelatedAccountGroupMemberships(ctx context.Context, in *ListRelatedAccountGroupMembershipsRequest, opts ...grpc.CallOption) (*ListRelatedAccountGroupMembershipsResponse, error)
	// Search group memberships related to a given account.
	SearchRelatedAccountGroupMemberships(ctx context.Context, in *SearchRelatedAccountGroupMembershipsRequest, opts ...grpc.CallOption) (*SearchRelatedAccountGroupMembershipsResponse, error)
}

type recaptchaEnterpriseServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRecaptchaEnterpriseServiceClient(cc grpc.ClientConnInterface) RecaptchaEnterpriseServiceClient {
	return &recaptchaEnterpriseServiceClient{cc}
}

func (c *recaptchaEnterpriseServiceClient) CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error) {
	out := new(Assessment)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_CreateAssessment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error) {
	out := new(AnnotateAssessmentResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_AnnotateAssessment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_CreateKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error) {
	out := new(ListKeysResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_ListKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) RetrieveLegacySecretKey(ctx context.Context, in *RetrieveLegacySecretKeyRequest, opts ...grpc.CallOption) (*RetrieveLegacySecretKeyResponse, error) {
	out := new(RetrieveLegacySecretKeyResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_RetrieveLegacySecretKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_GetKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_UpdateKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_DeleteKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) MigrateKey(ctx context.Context, in *MigrateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_MigrateKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) AddIpOverride(ctx context.Context, in *AddIpOverrideRequest, opts ...grpc.CallOption) (*AddIpOverrideResponse, error) {
	out := new(AddIpOverrideResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_AddIpOverride_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) RemoveIpOverride(ctx context.Context, in *RemoveIpOverrideRequest, opts ...grpc.CallOption) (*RemoveIpOverrideResponse, error) {
	out := new(RemoveIpOverrideResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_RemoveIpOverride_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListIpOverrides(ctx context.Context, in *ListIpOverridesRequest, opts ...grpc.CallOption) (*ListIpOverridesResponse, error) {
	out := new(ListIpOverridesResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_ListIpOverrides_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) GetMetrics(ctx context.Context, in *GetMetricsRequest, opts ...grpc.CallOption) (*Metrics, error) {
	out := new(Metrics)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_GetMetrics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) CreateFirewallPolicy(ctx context.Context, in *CreateFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error) {
	out := new(FirewallPolicy)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_CreateFirewallPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListFirewallPolicies(ctx context.Context, in *ListFirewallPoliciesRequest, opts ...grpc.CallOption) (*ListFirewallPoliciesResponse, error) {
	out := new(ListFirewallPoliciesResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_ListFirewallPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) GetFirewallPolicy(ctx context.Context, in *GetFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error) {
	out := new(FirewallPolicy)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_GetFirewallPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) UpdateFirewallPolicy(ctx context.Context, in *UpdateFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error) {
	out := new(FirewallPolicy)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_UpdateFirewallPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) DeleteFirewallPolicy(ctx context.Context, in *DeleteFirewallPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_DeleteFirewallPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ReorderFirewallPolicies(ctx context.Context, in *ReorderFirewallPoliciesRequest, opts ...grpc.CallOption) (*ReorderFirewallPoliciesResponse, error) {
	out := new(ReorderFirewallPoliciesResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_ReorderFirewallPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListRelatedAccountGroups(ctx context.Context, in *ListRelatedAccountGroupsRequest, opts ...grpc.CallOption) (*ListRelatedAccountGroupsResponse, error) {
	out := new(ListRelatedAccountGroupsResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_ListRelatedAccountGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListRelatedAccountGroupMemberships(ctx context.Context, in *ListRelatedAccountGroupMembershipsRequest, opts ...grpc.CallOption) (*ListRelatedAccountGroupMembershipsResponse, error) {
	out := new(ListRelatedAccountGroupMembershipsResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_ListRelatedAccountGroupMemberships_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) SearchRelatedAccountGroupMemberships(ctx context.Context, in *SearchRelatedAccountGroupMembershipsRequest, opts ...grpc.CallOption) (*SearchRelatedAccountGroupMembershipsResponse, error) {
	out := new(SearchRelatedAccountGroupMembershipsResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseService_SearchRelatedAccountGroupMemberships_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecaptchaEnterpriseServiceServer is the server API for RecaptchaEnterpriseService service.
// All implementations should embed UnimplementedRecaptchaEnterpriseServiceServer
// for forward compatibility
type RecaptchaEnterpriseServiceServer interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fraudulent.
	AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error)
	// Creates a new reCAPTCHA Enterprise key.
	CreateKey(context.Context, *CreateKeyRequest) (*Key, error)
	// Returns the list of all keys that belong to a project.
	ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error)
	// Returns the secret key related to the specified public key.
	// You must use the legacy secret key only in a 3rd party integration with
	// legacy reCAPTCHA.
	RetrieveLegacySecretKey(context.Context, *RetrieveLegacySecretKeyRequest) (*RetrieveLegacySecretKeyResponse, error)
	// Returns the specified key.
	GetKey(context.Context, *GetKeyRequest) (*Key, error)
	// Updates the specified key.
	UpdateKey(context.Context, *UpdateKeyRequest) (*Key, error)
	// Deletes the specified key.
	DeleteKey(context.Context, *DeleteKeyRequest) (*emptypb.Empty, error)
	// Migrates an existing key from reCAPTCHA to reCAPTCHA Enterprise.
	// Once a key is migrated, it can be used from either product. SiteVerify
	// requests are billed as CreateAssessment calls. You must be
	// authenticated as one of the current owners of the reCAPTCHA Key, and
	// your user must have the reCAPTCHA Enterprise Admin IAM role in the
	// destination project.
	MigrateKey(context.Context, *MigrateKeyRequest) (*Key, error)
	// Adds an IP override to a key. The following restrictions hold:
	//   - The maximum number of IP overrides per key is 1000.
	//   - For any conflict (such as IP already exists or IP part of an existing
	//     IP range), an error is returned.
	AddIpOverride(context.Context, *AddIpOverrideRequest) (*AddIpOverrideResponse, error)
	// Removes an IP override from a key. The following restrictions hold:
	// * If the IP isn't found in an existing IP override, a `NOT_FOUND` error
	// is returned.
	// * If the IP is found in an existing IP override, but the
	// override type does not match, a `NOT_FOUND` error is returned.
	RemoveIpOverride(context.Context, *RemoveIpOverrideRequest) (*RemoveIpOverrideResponse, error)
	// Lists all IP overrides for a key.
	ListIpOverrides(context.Context, *ListIpOverridesRequest) (*ListIpOverridesResponse, error)
	// Get some aggregated metrics for a Key. This data can be used to build
	// dashboards.
	GetMetrics(context.Context, *GetMetricsRequest) (*Metrics, error)
	// Creates a new FirewallPolicy, specifying conditions at which reCAPTCHA
	// Enterprise actions can be executed.
	// A project may have a maximum of 1000 policies.
	CreateFirewallPolicy(context.Context, *CreateFirewallPolicyRequest) (*FirewallPolicy, error)
	// Returns the list of all firewall policies that belong to a project.
	ListFirewallPolicies(context.Context, *ListFirewallPoliciesRequest) (*ListFirewallPoliciesResponse, error)
	// Returns the specified firewall policy.
	GetFirewallPolicy(context.Context, *GetFirewallPolicyRequest) (*FirewallPolicy, error)
	// Updates the specified firewall policy.
	UpdateFirewallPolicy(context.Context, *UpdateFirewallPolicyRequest) (*FirewallPolicy, error)
	// Deletes the specified firewall policy.
	DeleteFirewallPolicy(context.Context, *DeleteFirewallPolicyRequest) (*emptypb.Empty, error)
	// Reorders all firewall policies.
	ReorderFirewallPolicies(context.Context, *ReorderFirewallPoliciesRequest) (*ReorderFirewallPoliciesResponse, error)
	// List groups of related accounts.
	ListRelatedAccountGroups(context.Context, *ListRelatedAccountGroupsRequest) (*ListRelatedAccountGroupsResponse, error)
	// Get memberships in a group of related accounts.
	ListRelatedAccountGroupMemberships(context.Context, *ListRelatedAccountGroupMembershipsRequest) (*ListRelatedAccountGroupMembershipsResponse, error)
	// Search group memberships related to a given account.
	SearchRelatedAccountGroupMemberships(context.Context, *SearchRelatedAccountGroupMembershipsRequest) (*SearchRelatedAccountGroupMembershipsResponse, error)
}

// UnimplementedRecaptchaEnterpriseServiceServer should be embedded to have forward compatible implementations.
type UnimplementedRecaptchaEnterpriseServiceServer struct {
}

func (UnimplementedRecaptchaEnterpriseServiceServer) CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAssessment not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnnotateAssessment not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) CreateKey(context.Context, *CreateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKey not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeys not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) RetrieveLegacySecretKey(context.Context, *RetrieveLegacySecretKeyRequest) (*RetrieveLegacySecretKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveLegacySecretKey not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) GetKey(context.Context, *GetKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKey not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) UpdateKey(context.Context, *UpdateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateKey not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) DeleteKey(context.Context, *DeleteKeyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKey not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) MigrateKey(context.Context, *MigrateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MigrateKey not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) AddIpOverride(context.Context, *AddIpOverrideRequest) (*AddIpOverrideResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddIpOverride not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) RemoveIpOverride(context.Context, *RemoveIpOverrideRequest) (*RemoveIpOverrideResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveIpOverride not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) ListIpOverrides(context.Context, *ListIpOverridesRequest) (*ListIpOverridesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIpOverrides not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) GetMetrics(context.Context, *GetMetricsRequest) (*Metrics, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetrics not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) CreateFirewallPolicy(context.Context, *CreateFirewallPolicyRequest) (*FirewallPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFirewallPolicy not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) ListFirewallPolicies(context.Context, *ListFirewallPoliciesRequest) (*ListFirewallPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFirewallPolicies not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) GetFirewallPolicy(context.Context, *GetFirewallPolicyRequest) (*FirewallPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFirewallPolicy not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) UpdateFirewallPolicy(context.Context, *UpdateFirewallPolicyRequest) (*FirewallPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFirewallPolicy not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) DeleteFirewallPolicy(context.Context, *DeleteFirewallPolicyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFirewallPolicy not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) ReorderFirewallPolicies(context.Context, *ReorderFirewallPoliciesRequest) (*ReorderFirewallPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReorderFirewallPolicies not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) ListRelatedAccountGroups(context.Context, *ListRelatedAccountGroupsRequest) (*ListRelatedAccountGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRelatedAccountGroups not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) ListRelatedAccountGroupMemberships(context.Context, *ListRelatedAccountGroupMembershipsRequest) (*ListRelatedAccountGroupMembershipsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRelatedAccountGroupMemberships not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceServer) SearchRelatedAccountGroupMemberships(context.Context, *SearchRelatedAccountGroupMembershipsRequest) (*SearchRelatedAccountGroupMembershipsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchRelatedAccountGroupMemberships not implemented")
}

// UnsafeRecaptchaEnterpriseServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RecaptchaEnterpriseServiceServer will
// result in compilation errors.
type UnsafeRecaptchaEnterpriseServiceServer interface {
	mustEmbedUnimplementedRecaptchaEnterpriseServiceServer()
}

func RegisterRecaptchaEnterpriseServiceServer(s grpc.ServiceRegistrar, srv RecaptchaEnterpriseServiceServer) {
	s.RegisterService(&RecaptchaEnterpriseService_ServiceDesc, srv)
}

func _RecaptchaEnterpriseService_CreateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).CreateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_CreateAssessment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).CreateAssessment(ctx, req.(*CreateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_AnnotateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).AnnotateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_AnnotateAssessment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).AnnotateAssessment(ctx, req.(*AnnotateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_CreateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).CreateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_CreateKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).CreateKey(ctx, req.(*CreateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_ListKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListKeys(ctx, req.(*ListKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_RetrieveLegacySecretKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveLegacySecretKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).RetrieveLegacySecretKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_RetrieveLegacySecretKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).RetrieveLegacySecretKey(ctx, req.(*RetrieveLegacySecretKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_GetKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).GetKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_GetKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).GetKey(ctx, req.(*GetKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_UpdateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_UpdateKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateKey(ctx, req.(*UpdateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_DeleteKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_DeleteKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteKey(ctx, req.(*DeleteKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_MigrateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MigrateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).MigrateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_MigrateKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).MigrateKey(ctx, req.(*MigrateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_AddIpOverride_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddIpOverrideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).AddIpOverride(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_AddIpOverride_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).AddIpOverride(ctx, req.(*AddIpOverrideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_RemoveIpOverride_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveIpOverrideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).RemoveIpOverride(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_RemoveIpOverride_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).RemoveIpOverride(ctx, req.(*RemoveIpOverrideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListIpOverrides_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIpOverridesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListIpOverrides(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_ListIpOverrides_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListIpOverrides(ctx, req.(*ListIpOverridesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_GetMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).GetMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_GetMetrics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).GetMetrics(ctx, req.(*GetMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_CreateFirewallPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).CreateFirewallPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_CreateFirewallPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).CreateFirewallPolicy(ctx, req.(*CreateFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListFirewallPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFirewallPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListFirewallPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_ListFirewallPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListFirewallPolicies(ctx, req.(*ListFirewallPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_GetFirewallPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).GetFirewallPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_GetFirewallPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).GetFirewallPolicy(ctx, req.(*GetFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_UpdateFirewallPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateFirewallPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_UpdateFirewallPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateFirewallPolicy(ctx, req.(*UpdateFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_DeleteFirewallPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteFirewallPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_DeleteFirewallPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteFirewallPolicy(ctx, req.(*DeleteFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ReorderFirewallPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReorderFirewallPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ReorderFirewallPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_ReorderFirewallPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ReorderFirewallPolicies(ctx, req.(*ReorderFirewallPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListRelatedAccountGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRelatedAccountGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListRelatedAccountGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_ListRelatedAccountGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListRelatedAccountGroups(ctx, req.(*ListRelatedAccountGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListRelatedAccountGroupMemberships_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRelatedAccountGroupMembershipsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListRelatedAccountGroupMemberships(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_ListRelatedAccountGroupMemberships_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListRelatedAccountGroupMemberships(ctx, req.(*ListRelatedAccountGroupMembershipsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_SearchRelatedAccountGroupMemberships_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchRelatedAccountGroupMembershipsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).SearchRelatedAccountGroupMemberships(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseService_SearchRelatedAccountGroupMemberships_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).SearchRelatedAccountGroupMemberships(ctx, req.(*SearchRelatedAccountGroupMembershipsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RecaptchaEnterpriseService_ServiceDesc is the grpc.ServiceDesc for RecaptchaEnterpriseService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RecaptchaEnterpriseService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService",
	HandlerType: (*RecaptchaEnterpriseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAssessment",
			Handler:    _RecaptchaEnterpriseService_CreateAssessment_Handler,
		},
		{
			MethodName: "AnnotateAssessment",
			Handler:    _RecaptchaEnterpriseService_AnnotateAssessment_Handler,
		},
		{
			MethodName: "CreateKey",
			Handler:    _RecaptchaEnterpriseService_CreateKey_Handler,
		},
		{
			MethodName: "ListKeys",
			Handler:    _RecaptchaEnterpriseService_ListKeys_Handler,
		},
		{
			MethodName: "RetrieveLegacySecretKey",
			Handler:    _RecaptchaEnterpriseService_RetrieveLegacySecretKey_Handler,
		},
		{
			MethodName: "GetKey",
			Handler:    _RecaptchaEnterpriseService_GetKey_Handler,
		},
		{
			MethodName: "UpdateKey",
			Handler:    _RecaptchaEnterpriseService_UpdateKey_Handler,
		},
		{
			MethodName: "DeleteKey",
			Handler:    _RecaptchaEnterpriseService_DeleteKey_Handler,
		},
		{
			MethodName: "MigrateKey",
			Handler:    _RecaptchaEnterpriseService_MigrateKey_Handler,
		},
		{
			MethodName: "AddIpOverride",
			Handler:    _RecaptchaEnterpriseService_AddIpOverride_Handler,
		},
		{
			MethodName: "RemoveIpOverride",
			Handler:    _RecaptchaEnterpriseService_RemoveIpOverride_Handler,
		},
		{
			MethodName: "ListIpOverrides",
			Handler:    _RecaptchaEnterpriseService_ListIpOverrides_Handler,
		},
		{
			MethodName: "GetMetrics",
			Handler:    _RecaptchaEnterpriseService_GetMetrics_Handler,
		},
		{
			MethodName: "CreateFirewallPolicy",
			Handler:    _RecaptchaEnterpriseService_CreateFirewallPolicy_Handler,
		},
		{
			MethodName: "ListFirewallPolicies",
			Handler:    _RecaptchaEnterpriseService_ListFirewallPolicies_Handler,
		},
		{
			MethodName: "GetFirewallPolicy",
			Handler:    _RecaptchaEnterpriseService_GetFirewallPolicy_Handler,
		},
		{
			MethodName: "UpdateFirewallPolicy",
			Handler:    _RecaptchaEnterpriseService_UpdateFirewallPolicy_Handler,
		},
		{
			MethodName: "DeleteFirewallPolicy",
			Handler:    _RecaptchaEnterpriseService_DeleteFirewallPolicy_Handler,
		},
		{
			MethodName: "ReorderFirewallPolicies",
			Handler:    _RecaptchaEnterpriseService_ReorderFirewallPolicies_Handler,
		},
		{
			MethodName: "ListRelatedAccountGroups",
			Handler:    _RecaptchaEnterpriseService_ListRelatedAccountGroups_Handler,
		},
		{
			MethodName: "ListRelatedAccountGroupMemberships",
			Handler:    _RecaptchaEnterpriseService_ListRelatedAccountGroupMemberships_Handler,
		},
		{
			MethodName: "SearchRelatedAccountGroupMemberships",
			Handler:    _RecaptchaEnterpriseService_SearchRelatedAccountGroupMemberships_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto",
}
