// Code generated by 'ccgo -o vfs_netbsd_amd64.go c/vfs.c -I../testdata/sqlite-amalgamation-3380500 -lmodernc.org/sqlite/lib -pkgname vfs -nocapi -export-externs X -D SQLITE_OS_UNIX -hide=vfsFullPathname -hide=vfsOpen -hide=vfsRead -hide=vfsAccess -hide=vfsFileSize -hide=vfsClose', DO NOT EDIT.

package vfs

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/sqlite/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ *libc.TLS
var _ types.Size_t

const (
	_REG_RDI    = 0
	_REG_RSI    = 1
	_REG_RDX    = 2
	_REG_R10    = 6
	_REG_R8     = 4
	_REG_R9     = 5
	_REG_RCX    = 3
	_REG_R11    = 7
	_REG_R12    = 8
	_REG_R13    = 9
	_REG_R14    = 10
	_REG_R15    = 11
	_REG_RBP    = 12
	_REG_RBX    = 13
	_REG_RAX    = 14
	_REG_GS     = 15
	_REG_FS     = 16
	_REG_ES     = 17
	_REG_DS     = 18
	_REG_TRAPNO = 19
	_REG_ERR    = 20
	_REG_RIP    = 21
	_REG_CS     = 22
	_REG_RFLAGS = 23
	_REG_RSP    = 24
	_REG_SS     = 25
	_NGREG      = 26
)

const (
	P_MYID       = -1
	P_ALL        = 0
	P_PID        = 1
	P_LWPID      = 2
	P_PPID       = 3
	P_PGID       = 4
	P_SID        = 5
	P_CID        = 6
	P_UID        = 7
	P_GID        = 8
	P_TASKID     = 9
	P_PROJID     = 10
	P_POOLID     = 11
	P_ZONEID     = 12
	P_CTID       = 13
	P_CPUID      = 14
	P_PSETID     = 15
	_P_MAXIDTYPE = 2147483647
)

type ptrdiff_t = int64

type size_t = uint64

type wchar_t = int32

type va_list = uintptr

type sqlite_int64 = int64
type sqlite_uint64 = uint64
type sqlite3_int64 = sqlite_int64
type sqlite3_uint64 = sqlite_uint64

type sqlite3_callback = uintptr

type sqlite3_file1 = struct{ pMethods uintptr }

type sqlite3_file = sqlite3_file1
type sqlite3_io_methods1 = struct {
	iVersion               int32
	_                      [4]byte
	xClose                 uintptr
	xRead                  uintptr
	xWrite                 uintptr
	xTruncate              uintptr
	xSync                  uintptr
	xFileSize              uintptr
	xLock                  uintptr
	xUnlock                uintptr
	xCheckReservedLock     uintptr
	xFileControl           uintptr
	xSectorSize            uintptr
	xDeviceCharacteristics uintptr
	xShmMap                uintptr
	xShmLock               uintptr
	xShmBarrier            uintptr
	xShmUnmap              uintptr
	xFetch                 uintptr
	xUnfetch               uintptr
}

type sqlite3_io_methods = sqlite3_io_methods1

type sqlite3_vfs1 = struct {
	iVersion          int32
	szOsFile          int32
	mxPathname        int32
	_                 [4]byte
	pNext             uintptr
	zName             uintptr
	pAppData          uintptr
	xOpen             uintptr
	xDelete           uintptr
	xAccess           uintptr
	xFullPathname     uintptr
	xDlOpen           uintptr
	xDlError          uintptr
	xDlSym            uintptr
	xDlClose          uintptr
	xRandomness       uintptr
	xSleep            uintptr
	xCurrentTime      uintptr
	xGetLastError     uintptr
	xCurrentTimeInt64 uintptr
	xSetSystemCall    uintptr
	xGetSystemCall    uintptr
	xNextSystemCall   uintptr
}

type sqlite3_vfs = sqlite3_vfs1
type sqlite3_syscall_ptr = uintptr

type sqlite3_mem_methods1 = struct {
	xMalloc   uintptr
	xFree     uintptr
	xRealloc  uintptr
	xSize     uintptr
	xRoundup  uintptr
	xInit     uintptr
	xShutdown uintptr
	pAppData  uintptr
}

type sqlite3_mem_methods = sqlite3_mem_methods1

type sqlite3_destructor_type = uintptr

type sqlite3_vtab1 = struct {
	pModule uintptr
	nRef    int32
	_       [4]byte
	zErrMsg uintptr
}

type sqlite3_vtab = sqlite3_vtab1
type sqlite3_index_info1 = struct {
	nConstraint      int32
	_                [4]byte
	aConstraint      uintptr
	nOrderBy         int32
	_                [4]byte
	aOrderBy         uintptr
	aConstraintUsage uintptr
	idxNum           int32
	_                [4]byte
	idxStr           uintptr
	needToFreeIdxStr int32
	orderByConsumed  int32
	estimatedCost    float64
	estimatedRows    sqlite3_int64
	idxFlags         int32
	_                [4]byte
	colUsed          sqlite3_uint64
}

type sqlite3_index_info = sqlite3_index_info1
type sqlite3_vtab_cursor1 = struct{ pVtab uintptr }

type sqlite3_vtab_cursor = sqlite3_vtab_cursor1
type sqlite3_module1 = struct {
	iVersion      int32
	_             [4]byte
	xCreate       uintptr
	xConnect      uintptr
	xBestIndex    uintptr
	xDisconnect   uintptr
	xDestroy      uintptr
	xOpen         uintptr
	xClose        uintptr
	xFilter       uintptr
	xNext         uintptr
	xEof          uintptr
	xColumn       uintptr
	xRowid        uintptr
	xUpdate       uintptr
	xBegin        uintptr
	xSync         uintptr
	xCommit       uintptr
	xRollback     uintptr
	xFindFunction uintptr
	xRename       uintptr
	xSavepoint    uintptr
	xRelease      uintptr
	xRollbackTo   uintptr
	xShadowName   uintptr
}

type sqlite3_module = sqlite3_module1

type sqlite3_index_constraint = struct {
	iColumn     int32
	op          uint8
	usable      uint8
	_           [2]byte
	iTermOffset int32
}

type sqlite3_index_orderby = struct {
	iColumn int32
	desc    uint8
	_       [3]byte
}

type sqlite3_index_constraint_usage = struct {
	argvIndex int32
	omit      uint8
	_         [3]byte
}

type sqlite3_mutex_methods1 = struct {
	xMutexInit    uintptr
	xMutexEnd     uintptr
	xMutexAlloc   uintptr
	xMutexFree    uintptr
	xMutexEnter   uintptr
	xMutexTry     uintptr
	xMutexLeave   uintptr
	xMutexHeld    uintptr
	xMutexNotheld uintptr
}

type sqlite3_mutex_methods = sqlite3_mutex_methods1

type sqlite3_pcache_page1 = struct {
	pBuf   uintptr
	pExtra uintptr
}

type sqlite3_pcache_page = sqlite3_pcache_page1

type sqlite3_pcache_methods21 = struct {
	iVersion   int32
	_          [4]byte
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
	xShrink    uintptr
}

type sqlite3_pcache_methods2 = sqlite3_pcache_methods21

type sqlite3_pcache_methods1 = struct {
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
}

type sqlite3_pcache_methods = sqlite3_pcache_methods1

type sqlite3_snapshot1 = struct{ hidden [48]uint8 }

type sqlite3_snapshot = sqlite3_snapshot1

type sqlite3_rtree_geometry1 = struct {
	pContext uintptr
	nParam   int32
	_        [4]byte
	aParam   uintptr
	pUser    uintptr
	xDelUser uintptr
}

type sqlite3_rtree_geometry = sqlite3_rtree_geometry1
type sqlite3_rtree_query_info1 = struct {
	pContext      uintptr
	nParam        int32
	_             [4]byte
	aParam        uintptr
	pUser         uintptr
	xDelUser      uintptr
	aCoord        uintptr
	anQueue       uintptr
	nCoord        int32
	iLevel        int32
	mxLevel       int32
	_             [4]byte
	iRowid        sqlite3_int64
	rParentScore  sqlite3_rtree_dbl
	eParentWithin int32
	eWithin       int32
	rScore        sqlite3_rtree_dbl
	apSqlParam    uintptr
}

type sqlite3_rtree_query_info = sqlite3_rtree_query_info1

type sqlite3_rtree_dbl = float64

type Fts5ExtensionApi1 = struct {
	iVersion           int32
	_                  [4]byte
	xUserData          uintptr
	xColumnCount       uintptr
	xRowCount          uintptr
	xColumnTotalSize   uintptr
	xTokenize          uintptr
	xPhraseCount       uintptr
	xPhraseSize        uintptr
	xInstCount         uintptr
	xInst              uintptr
	xRowid             uintptr
	xColumnText        uintptr
	xColumnSize        uintptr
	xQueryPhrase       uintptr
	xSetAuxdata        uintptr
	xGetAuxdata        uintptr
	xPhraseFirst       uintptr
	xPhraseNext        uintptr
	xPhraseFirstColumn uintptr
	xPhraseNextColumn  uintptr
}

type Fts5ExtensionApi = Fts5ExtensionApi1
type Fts5PhraseIter1 = struct {
	a uintptr
	b uintptr
}

type Fts5PhraseIter = Fts5PhraseIter1

type fts5_extension_function = uintptr
type fts5_tokenizer1 = struct {
	xCreate   uintptr
	xDelete   uintptr
	xTokenize uintptr
}

type fts5_tokenizer = fts5_tokenizer1

type fts5_api1 = struct {
	iVersion         int32
	_                [4]byte
	xCreateTokenizer uintptr
	xFindTokenizer   uintptr
	xCreateFunction  uintptr
}

type fts5_api = fts5_api1

type locale_t = uintptr

type int8_t = int8

type uint8_t = uint8

type int16_t = int16

type uint16_t = uint16

type int32_t = int32

type uint32_t = uint32

type int64_t = int64

type uint64_t = uint64

type u_int8_t = uint8_t
type u_int16_t = uint16_t
type u_int32_t = uint32_t
type u_int64_t = uint64_t

type in_addr_t = uint32

type in_port_t = uint16

func __byte_swap_u64_variable(tls *libc.TLS, x uint64_t) uint64_t {
	panic(`/usr/include/machine/byte_swap.h:50:2: assembler statements not supported`)
	return x
}

func __byte_swap_u32_variable(tls *libc.TLS, x uint32_t) uint32_t {
	panic(`/usr/include/machine/byte_swap.h:59:2: assembler statements not supported`)
	return x
}

func __byte_swap_u16_variable(tls *libc.TLS, x uint16_t) uint16_t {
	panic(`/usr/include/machine/byte_swap.h:68:2: assembler statements not supported`)
	return x
}

type intptr_t = int64

type uintptr_t = uint64

type int_least8_t = int8
type uint_least8_t = uint8
type int_least16_t = int16
type uint_least16_t = uint16
type int_least32_t = int32
type uint_least32_t = uint32
type int_least64_t = int64
type uint_least64_t = uint64

type int_fast8_t = int32
type uint_fast8_t = uint32
type int_fast16_t = int32
type uint_fast16_t = uint32
type int_fast32_t = int32
type uint_fast32_t = uint32
type int_fast64_t = int64
type uint_fast64_t = uint64

type intmax_t = int64
type uintmax_t = uint64

type u_char = uint8
type u_short = uint16
type u_int = uint32
type u_long = uint64

type unchar = uint8
type ushort = uint16
type uint = uint32
type ulong = uint64

type u_quad_t = uint64_t
type quad_t = int64_t
type qaddr_t = uintptr

type longlong_t = int64_t
type u_longlong_t = uint64_t

type blkcnt_t = int64_t
type blksize_t = int32_t

type fsblkcnt_t = uint64

type fsfilcnt_t = uint64

type caddr_t = uintptr

type daddr_t = int64_t

type dev_t = uint64_t
type fixpt_t = uint32_t

type gid_t = uint32

type id_t = uint32_t
type ino_t = uint64_t
type key_t = int64

type mode_t = uint32

type nlink_t = uint32_t

type off_t = int64

type pid_t = int32
type lwpid_t = int32_t
type rlim_t = uint64_t
type segsz_t = int32_t
type swblk_t = int32_t

type uid_t = uint32

type mqd_t = int32

type cpuid_t = uint64

type psetid_t = int32

type clock_t = uint32

type ssize_t = int64

type time_t = int64

type clockid_t = int32

type timer_t = int32

type suseconds_t = int32

type useconds_t = uint32

type fd_set1 = struct{ fds_bits [8]uint32 }

type fd_set = fd_set1

type kauth_cred_t = uintptr

type pri_t = int32

type pthread_spin_t = uint8

type pthread_queue_struct_t = struct {
	ptqh_first uintptr
	ptqh_last  uintptr
}

type pthread_queue_t = pthread_queue_struct_t
type __pthread_attr_st = struct {
	pta_magic   uint32
	pta_flags   int32
	pta_private uintptr
}

type __pthread_mutex_st = struct {
	ptm_magic      uint32
	ptm_errorcheck uint8
	ptm_pad1       [3]uint8_t
	__8            struct{ ptm_ceiling uint8 }
	ptm_pad2       [3]uint8_t
	_              [4]byte
	ptm_owner      pthread_t
	ptm_waiters    uintptr
	ptm_recursed   uint32
	_              [4]byte
	ptm_spare2     uintptr
}

type __pthread_mutexattr_st = struct {
	ptma_magic   uint32
	_            [4]byte
	ptma_private uintptr
}

type __pthread_cond_st = struct {
	ptc_magic   uint32
	ptc_lock    uint8
	_           [3]byte
	ptc_waiters pthread_queue_t
	ptc_mutex   uintptr
	ptc_private uintptr
}

type __pthread_condattr_st = struct {
	ptca_magic   uint32
	_            [4]byte
	ptca_private uintptr
}

type __pthread_rwlock_st = struct {
	ptr_magic     uint32
	ptr_interlock uint8
	_             [3]byte
	ptr_rblocked  pthread_queue_t
	ptr_wblocked  pthread_queue_t
	ptr_nreaders  uint32
	_             [4]byte
	ptr_owner     pthread_t
	ptr_private   uintptr
}

type __pthread_rwlockattr_st = struct {
	ptra_magic   uint32
	_            [4]byte
	ptra_private uintptr
}

type __pthread_barrier_st = struct {
	ptb_magic      uint32
	ptb_lock       pthread_spin_t
	_              [3]byte
	ptb_waiters    pthread_queue_t
	ptb_initcount  uint32
	ptb_curcount   uint32
	ptb_generation uint32
	_              [4]byte
	ptb_private    uintptr
}

type __pthread_barrierattr_st = struct {
	ptba_magic   uint32
	_            [4]byte
	ptba_private uintptr
}

type pthread_t = uintptr
type pthread_attr_t = __pthread_attr_st
type pthread_mutex_t = __pthread_mutex_st
type pthread_mutexattr_t = __pthread_mutexattr_st
type pthread_cond_t = __pthread_cond_st
type pthread_condattr_t = __pthread_condattr_st
type __pthread_once_st = struct {
	pto_mutex pthread_mutex_t
	pto_done  int32
	_         [4]byte
}

type pthread_once_t = __pthread_once_st
type __pthread_spinlock_st = struct {
	pts_magic uint32
	pts_spin  uint8
	_         [3]byte
	pts_flags int32
}

type pthread_spinlock_t = __pthread_spinlock_st
type pthread_rwlock_t = __pthread_rwlock_st
type pthread_rwlockattr_t = __pthread_rwlockattr_st
type pthread_barrier_t = __pthread_barrier_st
type pthread_barrierattr_t = __pthread_barrierattr_st
type pthread_key_t = int32

type timeval = struct {
	tv_sec  time_t
	tv_usec suseconds_t
	_       [4]byte
}

type timespec = struct {
	tv_sec  time_t
	tv_nsec int64
}

type timezone = struct {
	tz_minuteswest int32
	tz_dsttime     int32
}

type bintime = struct {
	sec  time_t
	frac uint64_t
}

type itimerval = struct {
	it_interval struct {
		tv_sec  time_t
		tv_usec suseconds_t
		_       [4]byte
	}
	it_value struct {
		tv_sec  time_t
		tv_usec suseconds_t
		_       [4]byte
	}
}

type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int64
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int64
	}
}

type sigset_t = struct{ __bits [4]uint32 }

type sigaltstack = struct {
	ss_sp    uintptr
	ss_size  size_t
	ss_flags int32
	_        [4]byte
}

type stack_t = sigaltstack

type tm = struct {
	tm_sec    int32
	tm_min    int32
	tm_hour   int32
	tm_mday   int32
	tm_mon    int32
	tm_year   int32
	tm_wday   int32
	tm_yday   int32
	tm_isdst  int32
	_         [4]byte
	tm_gmtoff int64
	tm_zone   uintptr
}

type sigevent = struct {
	sigev_notify int32
	sigev_signo  int32
	sigev_value  struct {
		_         [0]uint64
		sival_int int32
		_         [4]byte
	}
	sigev_notify_function   uintptr
	sigev_notify_attributes uintptr
}

type idtype_t = int32

type timezone_t = uintptr

type stat = struct {
	st_dev   dev_t
	st_mode  uint32
	_        [4]byte
	st_ino   ino_t
	st_nlink nlink_t
	st_uid   uint32
	st_gid   uint32
	_        [4]byte
	st_rdev  dev_t
	st_atim  struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_mtim struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_ctim struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_birthtim struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_size    int64
	st_blocks  blkcnt_t
	st_blksize blksize_t
	st_flags   uint32_t
	st_gen     uint32_t
	st_spare   [2]uint32_t
	_          [4]byte
}

type flock = struct {
	l_start  int64
	l_len    int64
	l_pid    int32
	l_type   int16
	l_whence int16
}

type sig_atomic_t = int32

type mcontext_t = struct {
	__gregs     [26]uint64
	_mc_tlsbase uint64
	__fpregs    [512]int8
}

type sigval = struct {
	_         [0]uint64
	sival_int int32
	_         [4]byte
}

type sigval_t = sigval

type _ksiginfo = struct {
	_signo  int32
	_code   int32
	_errno  int32
	_pad    int32
	_reason struct {
		_rt struct {
			_pid   int32
			_uid   uint32
			_value sigval_t
		}
		_ [64]byte
	}
}

type siginfo = struct {
	_      [0]uint64
	si_pad [128]int8
}

type siginfo_t = siginfo

type __ucontext = struct {
	uc_flags    uint32
	_           [4]byte
	uc_link     uintptr
	uc_sigmask  sigset_t
	uc_stack    stack_t
	uc_mcontext mcontext_t
}

type ucontext_t = __ucontext

type sigaction = struct {
	_sa_u    struct{ _sa_handler uintptr }
	sa_mask  sigset_t
	sa_flags int32
	_        [4]byte
}

type sig_t = uintptr

type sigstack = struct {
	ss_sp      uintptr
	ss_onstack int32
	_          [4]byte
}

type VFSFile1 = struct {
	base        sqlite3_file
	fsFile      uintptr
	fd          int32
	_           [4]byte
	aBuffer     uintptr
	nBuffer     int32
	_           [4]byte
	iBufferOfst sqlite3_int64
}

type VFSFile = VFSFile1

func vfsDirectWrite(tls *libc.TLS, p uintptr, zBuf uintptr, iAmt int32, iOfst sqlite_int64) int32 {
	bp := tls.Alloc(16)
	defer tls.Free(16)

	var ofst int64
	var nWrite size_t

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__)), 178))
	libc.X__builtin_abort(tls)
	ofst = libc.Xlseek(tls, (*VFSFile)(unsafe.Pointer(p)).fd, iOfst, 0)
	if ofst != iOfst {
		return 10 | int32(3)<<8
	}

	nWrite = size_t(libc.Xwrite(tls, (*VFSFile)(unsafe.Pointer(p)).fd, zBuf, uint64(iAmt)))
	if nWrite != size_t(iAmt) {
		return 10 | int32(3)<<8
	}

	return 0
}

var __func__ = *(*[15]int8)(unsafe.Pointer(ts + 13))

func vfsFlushBuffer(tls *libc.TLS, p uintptr) int32 {
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__1)), 198))
	libc.X__builtin_abort(tls)
	var rc int32 = 0
	if (*VFSFile)(unsafe.Pointer(p)).nBuffer != 0 {
		rc = vfsDirectWrite(tls, p, (*VFSFile)(unsafe.Pointer(p)).aBuffer, (*VFSFile)(unsafe.Pointer(p)).nBuffer, (*VFSFile)(unsafe.Pointer(p)).iBufferOfst)
		(*VFSFile)(unsafe.Pointer(p)).nBuffer = 0
	}
	return rc
}

var __func__1 = *(*[15]int8)(unsafe.Pointer(ts + 28))

func vfsWrite(tls *libc.TLS, pFile uintptr, zBuf uintptr, iAmt int32, iOfst sqlite_int64) int32 {
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__4)), 273))
	libc.X__builtin_abort(tls)
	var p uintptr = pFile

	if (*VFSFile)(unsafe.Pointer(p)).aBuffer != 0 {
		var z uintptr = zBuf
		var n int32 = iAmt
		var i sqlite3_int64 = iOfst

		for n > 0 {
			var nCopy int32

			if (*VFSFile)(unsafe.Pointer(p)).nBuffer == 8192 || (*VFSFile)(unsafe.Pointer(p)).iBufferOfst+sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer) != i {
				var rc int32 = vfsFlushBuffer(tls, p)
				if rc != 0 {
					return rc
				}
			}
			if !((*VFSFile)(unsafe.Pointer(p)).nBuffer == 0 || (*VFSFile)(unsafe.Pointer(p)).iBufferOfst+sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer) == i) {
				libc.X__assert13(tls, ts+43, 294, uintptr(unsafe.Pointer(&__func__4)), ts+51)
			}
			(*VFSFile)(unsafe.Pointer(p)).iBufferOfst = i - sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer)

			nCopy = 8192 - (*VFSFile)(unsafe.Pointer(p)).nBuffer
			if nCopy > n {
				nCopy = n
			}
			libc.Xmemcpy(tls, (*VFSFile)(unsafe.Pointer(p)).aBuffer+uintptr((*VFSFile)(unsafe.Pointer(p)).nBuffer), z, uint64(nCopy))
			*(*int32)(unsafe.Pointer(p + 32)) += nCopy

			n = n - nCopy
			i = i + sqlite3_int64(nCopy)
			z += uintptr(nCopy)
		}
	} else {
		return vfsDirectWrite(tls, p, zBuf, iAmt, iOfst)
	}

	return 0
}

var __func__4 = *(*[9]int8)(unsafe.Pointer(ts + 97))

func vfsTruncate(tls *libc.TLS, pFile uintptr, size sqlite_int64) int32 {
	return 0
}

func vfsSync(tls *libc.TLS, pFile uintptr, flags int32) int32 {
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__5)), 331))
	libc.X__builtin_abort(tls)
	var p uintptr = pFile
	var rc int32

	rc = vfsFlushBuffer(tls, p)
	if rc != 0 {
		return rc
	}

	rc = libc.Xfsync(tls, (*VFSFile)(unsafe.Pointer(p)).fd)
	return func() int32 {
		if rc == 0 {
			return 0
		}
		return 10 | int32(4)<<8
	}()
}

var __func__5 = *(*[8]int8)(unsafe.Pointer(ts + 106))

func vfsLock(tls *libc.TLS, pFile uintptr, eLock int32) int32 {
	return 0
}

func vfsUnlock(tls *libc.TLS, pFile uintptr, eLock int32) int32 {
	return 0
}

func vfsCheckReservedLock(tls *libc.TLS, pFile uintptr, pResOut uintptr) int32 {
	*(*int32)(unsafe.Pointer(pResOut)) = 0
	return 0
}

func vfsFileControl(tls *libc.TLS, pFile uintptr, op int32, pArg uintptr) int32 {
	return 12
}

func vfsSectorSize(tls *libc.TLS, pFile uintptr) int32 {
	return 0
}

func vfsDeviceCharacteristics(tls *libc.TLS, pFile uintptr) int32 {
	return 0
}

func vfsDelete(tls *libc.TLS, pVfs uintptr, zPath uintptr, dirSync int32) int32 {
	bp := tls.Alloc(4129)
	defer tls.Free(4129)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__8)), 473))
	libc.X__builtin_abort(tls)
	var rc int32

	rc = libc.Xunlink(tls, zPath)
	if rc != 0 && *(*int32)(unsafe.Pointer(libc.X__errno(tls))) == 2 {
		return 0
	}

	if rc == 0 && dirSync != 0 {
		var dfd int32
		var i int32

		sqlite3.Xsqlite3_snprintf(tls, 4096, bp+32, ts+114, libc.VaList(bp+16, zPath))
		*(*int8)(unsafe.Pointer(bp + 32 + 4096)) = int8(0)
		for i = int32(libc.Xstrlen(tls, bp+32)); i > 1 && int32(*(*int8)(unsafe.Pointer(bp + 32 + uintptr(i)))) != '/'; i++ {
		}
		*(*int8)(unsafe.Pointer(bp + 32 + uintptr(i))) = int8(0)

		dfd = libc.Xopen(tls, bp+32, 0x00000000, libc.VaList(bp+24, 0))
		if dfd < 0 {
			rc = -1
		} else {
			rc = libc.Xfsync(tls, dfd)
			libc.Xclose(tls, dfd)
		}
	}
	return func() int32 {
		if rc == 0 {
			return 0
		}
		return 10 | int32(10)<<8
	}()
}

var __func__8 = *(*[10]int8)(unsafe.Pointer(ts + 117))

func vfsDlOpen(tls *libc.TLS, pVfs uintptr, zPath uintptr) uintptr {
	return uintptr(0)
}

func vfsDlError(tls *libc.TLS, pVfs uintptr, nByte int32, zErrMsg uintptr) {
	sqlite3.Xsqlite3_snprintf(tls, nByte, zErrMsg, ts+127, 0)
	*(*int8)(unsafe.Pointer(zErrMsg + uintptr(nByte-1))) = int8(0)
}

func vfsDlSym(tls *libc.TLS, pVfs uintptr, pH uintptr, z uintptr) uintptr {
	return uintptr(0)
}

func vfsDlClose(tls *libc.TLS, pVfs uintptr, pHandle uintptr) {
	return
}

func vfsRandomness(tls *libc.TLS, pVfs uintptr, nByte int32, zByte uintptr) int32 {
	return 0
}

func vfsSleep(tls *libc.TLS, pVfs uintptr, nMicro int32) int32 {
	libc.Xsleep(tls, uint32(nMicro/1000000))
	libc.Xusleep(tls, uint32(nMicro%1000000))
	return nMicro
}

func vfsCurrentTime(tls *libc.TLS, pVfs uintptr, pTime uintptr) int32 {
	var t time_t = libc.Xtime(tls, uintptr(0))
	*(*float64)(unsafe.Pointer(pTime)) = float64(t)/86400.0 + 2440587.5
	return 0
}

func Xsqlite3_fsFS(tls *libc.TLS, zName uintptr, pAppData uintptr) uintptr {
	var p uintptr = libc.Xmalloc(tls, libc.Tsize_t(unsafe.Sizeof(sqlite3_vfs{})))
	if !(p != 0) {
		return uintptr(0)
	}

	*(*sqlite3_vfs)(unsafe.Pointer(p)) = sqlite3_vfs{
		iVersion:   1,
		szOsFile:   int32(unsafe.Sizeof(VFSFile{})),
		mxPathname: 4096,
		zName:      zName,
		pAppData:   pAppData,
		xOpen: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, uintptr, int32, uintptr) int32
		}{vfsOpen})),
		xDelete: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32) int32
		}{vfsDelete})),
		xAccess: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32, uintptr) int32
		}{vfsAccess})),
		xFullPathname: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32, uintptr) int32
		}{vfsFullPathname})),
		xDlOpen: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr) uintptr
		}{vfsDlOpen})),
		xDlError: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32, uintptr)
		}{vfsDlError})),
		xDlSym: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, uintptr) uintptr
		}{vfsDlSym})),
		xDlClose: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr)
		}{vfsDlClose})),
		xRandomness: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32, uintptr) int32
		}{vfsRandomness})),
		xSleep: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32) int32
		}{vfsSleep})),
		xCurrentTime: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr) int32
		}{vfsCurrentTime}))}
	return p
}

var ts1 = "TODO %s:%i:\n\x00vfsDirectWrite\x00vfsFlushBuffer\x00c/vfs.c\x00p->nBuffer==0 || p->iBufferOfst+p->nBuffer==i\x00vfsWrite\x00vfsSync\x00%s\x00vfsDelete\x00Loadable extensions are not supported\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
