// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/spanner/v1/mutation.proto

package spannerpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A modification to one or more Cloud Spanner rows.  Mutations can be
// applied to a Cloud Spanner database by sending them in a
// [Commit][google.spanner.v1.Spanner.Commit] call.
type Mutation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The operation to perform.
	//
	// Types that are assignable to Operation:
	//
	//	*Mutation_Insert
	//	*Mutation_Update
	//	*Mutation_InsertOrUpdate
	//	*Mutation_Replace
	//	*Mutation_Delete_
	//	*Mutation_Send_
	//	*Mutation_Ack_
	Operation isMutation_Operation `protobuf_oneof:"operation"`
}

func (x *Mutation) Reset() {
	*x = Mutation{}
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mutation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mutation) ProtoMessage() {}

func (x *Mutation) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mutation.ProtoReflect.Descriptor instead.
func (*Mutation) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_mutation_proto_rawDescGZIP(), []int{0}
}

func (m *Mutation) GetOperation() isMutation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *Mutation) GetInsert() *Mutation_Write {
	if x, ok := x.GetOperation().(*Mutation_Insert); ok {
		return x.Insert
	}
	return nil
}

func (x *Mutation) GetUpdate() *Mutation_Write {
	if x, ok := x.GetOperation().(*Mutation_Update); ok {
		return x.Update
	}
	return nil
}

func (x *Mutation) GetInsertOrUpdate() *Mutation_Write {
	if x, ok := x.GetOperation().(*Mutation_InsertOrUpdate); ok {
		return x.InsertOrUpdate
	}
	return nil
}

func (x *Mutation) GetReplace() *Mutation_Write {
	if x, ok := x.GetOperation().(*Mutation_Replace); ok {
		return x.Replace
	}
	return nil
}

func (x *Mutation) GetDelete() *Mutation_Delete {
	if x, ok := x.GetOperation().(*Mutation_Delete_); ok {
		return x.Delete
	}
	return nil
}

func (x *Mutation) GetSend() *Mutation_Send {
	if x, ok := x.GetOperation().(*Mutation_Send_); ok {
		return x.Send
	}
	return nil
}

func (x *Mutation) GetAck() *Mutation_Ack {
	if x, ok := x.GetOperation().(*Mutation_Ack_); ok {
		return x.Ack
	}
	return nil
}

type isMutation_Operation interface {
	isMutation_Operation()
}

type Mutation_Insert struct {
	// Insert new rows in a table. If any of the rows already exist,
	// the write or transaction fails with error `ALREADY_EXISTS`.
	Insert *Mutation_Write `protobuf:"bytes,1,opt,name=insert,proto3,oneof"`
}

type Mutation_Update struct {
	// Update existing rows in a table. If any of the rows does not
	// already exist, the transaction fails with error `NOT_FOUND`.
	Update *Mutation_Write `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type Mutation_InsertOrUpdate struct {
	// Like [insert][google.spanner.v1.Mutation.insert], except that if the row
	// already exists, then its column values are overwritten with the ones
	// provided. Any column values not explicitly written are preserved.
	//
	// When using
	// [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as
	// when using [insert][google.spanner.v1.Mutation.insert], all `NOT NULL`
	// columns in the table must be given a value. This holds true even when the
	// row already exists and will therefore actually be updated.
	InsertOrUpdate *Mutation_Write `protobuf:"bytes,3,opt,name=insert_or_update,json=insertOrUpdate,proto3,oneof"`
}

type Mutation_Replace struct {
	// Like [insert][google.spanner.v1.Mutation.insert], except that if the row
	// already exists, it is deleted, and the column values provided are
	// inserted instead. Unlike
	// [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this
	// means any values not explicitly written become `NULL`.
	//
	// In an interleaved table, if you create the child table with the
	// `ON DELETE CASCADE` annotation, then replacing a parent row
	// also deletes the child rows. Otherwise, you must delete the
	// child rows before you replace the parent row.
	Replace *Mutation_Write `protobuf:"bytes,4,opt,name=replace,proto3,oneof"`
}

type Mutation_Delete_ struct {
	// Delete rows from a table. Succeeds whether or not the named
	// rows were present.
	Delete *Mutation_Delete `protobuf:"bytes,5,opt,name=delete,proto3,oneof"`
}

type Mutation_Send_ struct {
	// Send a message to a queue.
	Send *Mutation_Send `protobuf:"bytes,6,opt,name=send,proto3,oneof"`
}

type Mutation_Ack_ struct {
	// Ack a message from a queue.
	Ack *Mutation_Ack `protobuf:"bytes,7,opt,name=ack,proto3,oneof"`
}

func (*Mutation_Insert) isMutation_Operation() {}

func (*Mutation_Update) isMutation_Operation() {}

func (*Mutation_InsertOrUpdate) isMutation_Operation() {}

func (*Mutation_Replace) isMutation_Operation() {}

func (*Mutation_Delete_) isMutation_Operation() {}

func (*Mutation_Send_) isMutation_Operation() {}

func (*Mutation_Ack_) isMutation_Operation() {}

// Arguments to [insert][google.spanner.v1.Mutation.insert],
// [update][google.spanner.v1.Mutation.update],
// [insert_or_update][google.spanner.v1.Mutation.insert_or_update], and
// [replace][google.spanner.v1.Mutation.replace] operations.
type Mutation_Write struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The table whose rows will be written.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// The names of the columns in
	// [table][google.spanner.v1.Mutation.Write.table] to be written.
	//
	// The list of columns must contain enough columns to allow
	// Cloud Spanner to derive values for all primary key columns in the
	// row(s) to be modified.
	Columns []string `protobuf:"bytes,2,rep,name=columns,proto3" json:"columns,omitempty"`
	// The values to be written. `values` can contain more than one
	// list of values. If it does, then multiple rows are written, one
	// for each entry in `values`. Each list in `values` must have
	// exactly as many entries as there are entries in
	// [columns][google.spanner.v1.Mutation.Write.columns] above. Sending
	// multiple lists is equivalent to sending multiple `Mutation`s, each
	// containing one `values` entry and repeating
	// [table][google.spanner.v1.Mutation.Write.table] and
	// [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in
	// each list are encoded as described [here][google.spanner.v1.TypeCode].
	Values []*structpb.ListValue `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Mutation_Write) Reset() {
	*x = Mutation_Write{}
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mutation_Write) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mutation_Write) ProtoMessage() {}

func (x *Mutation_Write) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mutation_Write.ProtoReflect.Descriptor instead.
func (*Mutation_Write) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_mutation_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Mutation_Write) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *Mutation_Write) GetColumns() []string {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *Mutation_Write) GetValues() []*structpb.ListValue {
	if x != nil {
		return x.Values
	}
	return nil
}

// Arguments to [delete][google.spanner.v1.Mutation.delete] operations.
type Mutation_Delete struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The table whose rows will be deleted.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Required. The primary keys of the rows within
	// [table][google.spanner.v1.Mutation.Delete.table] to delete.  The primary
	// keys must be specified in the order in which they appear in the `PRIMARY
	// KEY()` clause of the table's equivalent DDL statement (the DDL statement
	// used to create the table). Delete is idempotent. The transaction will
	// succeed even if some or all rows do not exist.
	KeySet *KeySet `protobuf:"bytes,2,opt,name=key_set,json=keySet,proto3" json:"key_set,omitempty"`
}

func (x *Mutation_Delete) Reset() {
	*x = Mutation_Delete{}
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mutation_Delete) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mutation_Delete) ProtoMessage() {}

func (x *Mutation_Delete) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mutation_Delete.ProtoReflect.Descriptor instead.
func (*Mutation_Delete) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_mutation_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Mutation_Delete) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *Mutation_Delete) GetKeySet() *KeySet {
	if x != nil {
		return x.KeySet
	}
	return nil
}

// Arguments to [send][google.spanner.v1.Mutation.send] operations.
type Mutation_Send struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queue to which the message will be sent.
	Queue string `protobuf:"bytes,1,opt,name=queue,proto3" json:"queue,omitempty"`
	// Required. The primary key of the message to be sent.
	Key *structpb.ListValue `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// The time at which Spanner will begin attempting to deliver the message.
	// If `deliver_time` is not set, Spanner will deliver the message
	// immediately. If `deliver_time` is in the past, Spanner will replace it
	// with a value closer to the current time.
	DeliverTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=deliver_time,json=deliverTime,proto3" json:"deliver_time,omitempty"`
	// The payload of the message.
	Payload *structpb.Value `protobuf:"bytes,4,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *Mutation_Send) Reset() {
	*x = Mutation_Send{}
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mutation_Send) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mutation_Send) ProtoMessage() {}

func (x *Mutation_Send) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mutation_Send.ProtoReflect.Descriptor instead.
func (*Mutation_Send) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_mutation_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Mutation_Send) GetQueue() string {
	if x != nil {
		return x.Queue
	}
	return ""
}

func (x *Mutation_Send) GetKey() *structpb.ListValue {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Mutation_Send) GetDeliverTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeliverTime
	}
	return nil
}

func (x *Mutation_Send) GetPayload() *structpb.Value {
	if x != nil {
		return x.Payload
	}
	return nil
}

// Arguments to [ack][google.spanner.v1.Mutation.ack] operations.
type Mutation_Ack struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queue where the message to be acked is stored.
	Queue string `protobuf:"bytes,1,opt,name=queue,proto3" json:"queue,omitempty"`
	// Required. The primary key of the message to be acked.
	Key *structpb.ListValue `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// By default, an attempt to ack a message that does not exist will fail
	// with a `NOT_FOUND` error. With `ignore_not_found` set to true, the ack
	// will succeed even if the message does not exist. This is useful for
	// unconditionally acking a message, even if it is missing or has already
	// been acked.
	IgnoreNotFound bool `protobuf:"varint,3,opt,name=ignore_not_found,json=ignoreNotFound,proto3" json:"ignore_not_found,omitempty"`
}

func (x *Mutation_Ack) Reset() {
	*x = Mutation_Ack{}
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mutation_Ack) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mutation_Ack) ProtoMessage() {}

func (x *Mutation_Ack) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_mutation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mutation_Ack.ProtoReflect.Descriptor instead.
func (*Mutation_Ack) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_mutation_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Mutation_Ack) GetQueue() string {
	if x != nil {
		return x.Queue
	}
	return ""
}

func (x *Mutation_Ack) GetKey() *structpb.ListValue {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Mutation_Ack) GetIgnoreNotFound() bool {
	if x != nil {
		return x.IgnoreNotFound
	}
	return false
}

var File_google_spanner_v1_mutation_proto protoreflect.FileDescriptor

var file_google_spanner_v1_mutation_proto_rawDesc = []byte{
	0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xe1, 0x07, 0x0a, 0x08, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3b, 0x0a, 0x06, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x48, 0x00, 0x52, 0x06, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x3b, 0x0a,
	0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x48, 0x00, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x4d, 0x0a, 0x10, 0x69, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x5f, 0x6f, 0x72, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x65, 0x72,
	0x74, 0x4f, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x07, 0x72, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x48, 0x00, 0x52,
	0x07, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x00, 0x52, 0x06,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x04, 0x73, 0x65, 0x6e, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x04, 0x73, 0x65, 0x6e, 0x64, 0x12, 0x33,
	0x0a, 0x03, 0x61, 0x63, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x63, 0x6b, 0x48, 0x00, 0x52, 0x03,
	0x61, 0x63, 0x6b, 0x1a, 0x70, 0x0a, 0x05, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x05,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x73, 0x12, 0x32, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x5c, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12,
	0x19, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x07, 0x6b, 0x65,
	0x79, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6b, 0x65, 0x79,
	0x53, 0x65, 0x74, 0x1a, 0xc5, 0x01, 0x0a, 0x04, 0x53, 0x65, 0x6e, 0x64, 0x12, 0x19, 0x0a, 0x05,
	0x71, 0x75, 0x65, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x71, 0x75, 0x65, 0x75, 0x65, 0x12, 0x31, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x0c, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x1a, 0x7d, 0x0a, 0x03, 0x41,
	0x63, 0x6b, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x75, 0x65, 0x12, 0x31, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x28, 0x0a, 0x10, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66,
	0x6f, 0x75, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x69, 0x67, 0x6e, 0x6f,
	0x72, 0x65, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0xb0, 0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x42, 0x0d, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x70, 0x62, 0x3b,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_spanner_v1_mutation_proto_rawDescOnce sync.Once
	file_google_spanner_v1_mutation_proto_rawDescData = file_google_spanner_v1_mutation_proto_rawDesc
)

func file_google_spanner_v1_mutation_proto_rawDescGZIP() []byte {
	file_google_spanner_v1_mutation_proto_rawDescOnce.Do(func() {
		file_google_spanner_v1_mutation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_v1_mutation_proto_rawDescData)
	})
	return file_google_spanner_v1_mutation_proto_rawDescData
}

var file_google_spanner_v1_mutation_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_spanner_v1_mutation_proto_goTypes = []any{
	(*Mutation)(nil),              // 0: google.spanner.v1.Mutation
	(*Mutation_Write)(nil),        // 1: google.spanner.v1.Mutation.Write
	(*Mutation_Delete)(nil),       // 2: google.spanner.v1.Mutation.Delete
	(*Mutation_Send)(nil),         // 3: google.spanner.v1.Mutation.Send
	(*Mutation_Ack)(nil),          // 4: google.spanner.v1.Mutation.Ack
	(*structpb.ListValue)(nil),    // 5: google.protobuf.ListValue
	(*KeySet)(nil),                // 6: google.spanner.v1.KeySet
	(*timestamppb.Timestamp)(nil), // 7: google.protobuf.Timestamp
	(*structpb.Value)(nil),        // 8: google.protobuf.Value
}
var file_google_spanner_v1_mutation_proto_depIdxs = []int32{
	1,  // 0: google.spanner.v1.Mutation.insert:type_name -> google.spanner.v1.Mutation.Write
	1,  // 1: google.spanner.v1.Mutation.update:type_name -> google.spanner.v1.Mutation.Write
	1,  // 2: google.spanner.v1.Mutation.insert_or_update:type_name -> google.spanner.v1.Mutation.Write
	1,  // 3: google.spanner.v1.Mutation.replace:type_name -> google.spanner.v1.Mutation.Write
	2,  // 4: google.spanner.v1.Mutation.delete:type_name -> google.spanner.v1.Mutation.Delete
	3,  // 5: google.spanner.v1.Mutation.send:type_name -> google.spanner.v1.Mutation.Send
	4,  // 6: google.spanner.v1.Mutation.ack:type_name -> google.spanner.v1.Mutation.Ack
	5,  // 7: google.spanner.v1.Mutation.Write.values:type_name -> google.protobuf.ListValue
	6,  // 8: google.spanner.v1.Mutation.Delete.key_set:type_name -> google.spanner.v1.KeySet
	5,  // 9: google.spanner.v1.Mutation.Send.key:type_name -> google.protobuf.ListValue
	7,  // 10: google.spanner.v1.Mutation.Send.deliver_time:type_name -> google.protobuf.Timestamp
	8,  // 11: google.spanner.v1.Mutation.Send.payload:type_name -> google.protobuf.Value
	5,  // 12: google.spanner.v1.Mutation.Ack.key:type_name -> google.protobuf.ListValue
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_spanner_v1_mutation_proto_init() }
func file_google_spanner_v1_mutation_proto_init() {
	if File_google_spanner_v1_mutation_proto != nil {
		return
	}
	file_google_spanner_v1_keys_proto_init()
	file_google_spanner_v1_mutation_proto_msgTypes[0].OneofWrappers = []any{
		(*Mutation_Insert)(nil),
		(*Mutation_Update)(nil),
		(*Mutation_InsertOrUpdate)(nil),
		(*Mutation_Replace)(nil),
		(*Mutation_Delete_)(nil),
		(*Mutation_Send_)(nil),
		(*Mutation_Ack_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_v1_mutation_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_spanner_v1_mutation_proto_goTypes,
		DependencyIndexes: file_google_spanner_v1_mutation_proto_depIdxs,
		MessageInfos:      file_google_spanner_v1_mutation_proto_msgTypes,
	}.Build()
	File_google_spanner_v1_mutation_proto = out.File
	file_google_spanner_v1_mutation_proto_rawDesc = nil
	file_google_spanner_v1_mutation_proto_goTypes = nil
	file_google_spanner_v1_mutation_proto_depIdxs = nil
}
