// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/datalabeling/v1beta1/dataset.proto

package datalabelingpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DataType int32

const (
	DataType_DATA_TYPE_UNSPECIFIED DataType = 0
	// Allowed for continuous evaluation.
	DataType_IMAGE DataType = 1
	DataType_VIDEO DataType = 2
	// Allowed for continuous evaluation.
	DataType_TEXT DataType = 4
	// Allowed for continuous evaluation.
	DataType_GENERAL_DATA DataType = 6
)

// Enum value maps for DataType.
var (
	DataType_name = map[int32]string{
		0: "DATA_TYPE_UNSPECIFIED",
		1: "IMAGE",
		2: "VIDEO",
		4: "TEXT",
		6: "GENERAL_DATA",
	}
	DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED": 0,
		"IMAGE":                 1,
		"VIDEO":                 2,
		"TEXT":                  4,
		"GENERAL_DATA":          6,
	}
)

func (x DataType) Enum() *DataType {
	p := new(DataType)
	*p = x
	return p
}

func (x DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_enumTypes[0].Descriptor()
}

func (DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_datalabeling_v1beta1_dataset_proto_enumTypes[0]
}

func (x DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataType.Descriptor instead.
func (DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{0}
}

// Dataset is the resource to hold your data. You can request multiple labeling
// tasks for a dataset while each one will generate an AnnotatedDataset.
type Dataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Dataset resource name, format is:
	// projects/{project_id}/datasets/{dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the dataset. Maximum of 64 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-provided description of the annotation specification set.
	// The description can be up to 10000 characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time the dataset is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. This is populated with the original input configs
	// where ImportData is called. It is available only after the clients
	// import data to this dataset.
	InputConfigs []*InputConfig `protobuf:"bytes,5,rep,name=input_configs,json=inputConfigs,proto3" json:"input_configs,omitempty"`
	// Output only. The names of any related resources that are blocking changes
	// to the dataset.
	BlockingResources []string `protobuf:"bytes,6,rep,name=blocking_resources,json=blockingResources,proto3" json:"blocking_resources,omitempty"`
	// Output only. The number of data items in the dataset.
	DataItemCount int64 `protobuf:"varint,7,opt,name=data_item_count,json=dataItemCount,proto3" json:"data_item_count,omitempty"`
}

func (x *Dataset) Reset() {
	*x = Dataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dataset) ProtoMessage() {}

func (x *Dataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dataset.ProtoReflect.Descriptor instead.
func (*Dataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{0}
}

func (x *Dataset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Dataset) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Dataset) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Dataset) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Dataset) GetInputConfigs() []*InputConfig {
	if x != nil {
		return x.InputConfigs
	}
	return nil
}

func (x *Dataset) GetBlockingResources() []string {
	if x != nil {
		return x.BlockingResources
	}
	return nil
}

func (x *Dataset) GetDataItemCount() int64 {
	if x != nil {
		return x.DataItemCount
	}
	return 0
}

// The configuration of input data, including data type, location, etc.
type InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The metadata associated with each data type.
	//
	// Types that are assignable to DataTypeMetadata:
	//
	//	*InputConfig_TextMetadata
	DataTypeMetadata isInputConfig_DataTypeMetadata `protobuf_oneof:"data_type_metadata"`
	// Required. Where the data is from.
	//
	// Types that are assignable to Source:
	//
	//	*InputConfig_GcsSource
	//	*InputConfig_BigquerySource
	Source isInputConfig_Source `protobuf_oneof:"source"`
	// Required. Data type must be specifed when user tries to import data.
	DataType DataType `protobuf:"varint,1,opt,name=data_type,json=dataType,proto3,enum=google.cloud.datalabeling.v1beta1.DataType" json:"data_type,omitempty"`
	// Optional. The type of annotation to be performed on this data. You must
	// specify this field if you are using this InputConfig in an
	// [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
	AnnotationType AnnotationType `protobuf:"varint,3,opt,name=annotation_type,json=annotationType,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationType" json:"annotation_type,omitempty"`
	// Optional. Metadata about annotations for the input. You must specify this
	// field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
	// model version that performs classification.
	ClassificationMetadata *ClassificationMetadata `protobuf:"bytes,4,opt,name=classification_metadata,json=classificationMetadata,proto3" json:"classification_metadata,omitempty"`
}

func (x *InputConfig) Reset() {
	*x = InputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputConfig) ProtoMessage() {}

func (x *InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputConfig.ProtoReflect.Descriptor instead.
func (*InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{1}
}

func (m *InputConfig) GetDataTypeMetadata() isInputConfig_DataTypeMetadata {
	if m != nil {
		return m.DataTypeMetadata
	}
	return nil
}

func (x *InputConfig) GetTextMetadata() *TextMetadata {
	if x, ok := x.GetDataTypeMetadata().(*InputConfig_TextMetadata); ok {
		return x.TextMetadata
	}
	return nil
}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *InputConfig) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*InputConfig_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *InputConfig) GetDataType() DataType {
	if x != nil {
		return x.DataType
	}
	return DataType_DATA_TYPE_UNSPECIFIED
}

func (x *InputConfig) GetAnnotationType() AnnotationType {
	if x != nil {
		return x.AnnotationType
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (x *InputConfig) GetClassificationMetadata() *ClassificationMetadata {
	if x != nil {
		return x.ClassificationMetadata
	}
	return nil
}

type isInputConfig_DataTypeMetadata interface {
	isInputConfig_DataTypeMetadata()
}

type InputConfig_TextMetadata struct {
	// Required for text import, as language code must be specified.
	TextMetadata *TextMetadata `protobuf:"bytes,6,opt,name=text_metadata,json=textMetadata,proto3,oneof"`
}

func (*InputConfig_TextMetadata) isInputConfig_DataTypeMetadata() {}

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	// Source located in Cloud Storage.
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type InputConfig_BigquerySource struct {
	// Source located in BigQuery. You must specify this field if you are using
	// this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
	BigquerySource *BigQuerySource `protobuf:"bytes,5,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (*InputConfig_BigquerySource) isInputConfig_Source() {}

// Metadata for the text.
type TextMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The language of this text, as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
	// Default value is en-US.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *TextMetadata) Reset() {
	*x = TextMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextMetadata) ProtoMessage() {}

func (x *TextMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextMetadata.ProtoReflect.Descriptor instead.
func (*TextMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{2}
}

func (x *TextMetadata) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Metadata for classification annotations.
type ClassificationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the classification task is multi-label or not.
	IsMultiLabel bool `protobuf:"varint,1,opt,name=is_multi_label,json=isMultiLabel,proto3" json:"is_multi_label,omitempty"`
}

func (x *ClassificationMetadata) Reset() {
	*x = ClassificationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassificationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassificationMetadata) ProtoMessage() {}

func (x *ClassificationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassificationMetadata.ProtoReflect.Descriptor instead.
func (*ClassificationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{3}
}

func (x *ClassificationMetadata) GetIsMultiLabel() bool {
	if x != nil {
		return x.IsMultiLabel
	}
	return false
}

// Source of the Cloud Storage file to be imported.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The input URI of source file. This must be a Cloud Storage path
	// (`gs://...`).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Required. The format of the source file. Only "text/csv" is supported.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{4}
}

func (x *GcsSource) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *GcsSource) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// The BigQuery location for input data. If used in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob], this
// is where the service saves the prediction input and output sampled from the
// model version.
type BigQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. BigQuery URI to a table, up to 2,000 characters long. If you
	// specify the URI of a table that does not exist, Data Labeling Service
	// creates a table at the URI with the correct schema when you create your
	// [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob]. If you specify the URI of a table that already exists,
	// it must have the
	// [correct
	// schema](/ml-engine/docs/continuous-evaluation/create-job#table-schema).
	//
	// Provide the table URI in the following format:
	//
	// "bq://<var>{your_project_id}</var>/<var>{your_dataset_name}</var>/<var>{your_table_name}</var>"
	//
	// [Learn
	// more](/ml-engine/docs/continuous-evaluation/create-job#table-schema).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
}

func (x *BigQuerySource) Reset() {
	*x = BigQuerySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQuerySource) ProtoMessage() {}

func (x *BigQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQuerySource.ProtoReflect.Descriptor instead.
func (*BigQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{5}
}

func (x *BigQuerySource) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

// The configuration of output data.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Location to output data to.
	//
	// Types that are assignable to Destination:
	//
	//	*OutputConfig_GcsDestination
	//	*OutputConfig_GcsFolderDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{6}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *OutputConfig) GetGcsFolderDestination() *GcsFolderDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsFolderDestination); ok {
		return x.GcsFolderDestination
	}
	return nil
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	// Output to a file in Cloud Storage. Should be used for labeling output
	// other than image segmentation.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_GcsFolderDestination struct {
	// Output to a folder in Cloud Storage. Should be used for image
	// segmentation labeling output.
	GcsFolderDestination *GcsFolderDestination `protobuf:"bytes,2,opt,name=gcs_folder_destination,json=gcsFolderDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (*OutputConfig_GcsFolderDestination) isOutputConfig_Destination() {}

// Export destination of the data.Only gcs path is allowed in
// output_uri.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The output uri of destination file.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Required. The format of the gcs destination. Only "text/csv" and
	// "application/json"
	// are supported.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{7}
}

func (x *GcsDestination) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

func (x *GcsDestination) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// Export folder destination of the data.
type GcsFolderDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Cloud Storage directory to export data to.
	OutputFolderUri string `protobuf:"bytes,1,opt,name=output_folder_uri,json=outputFolderUri,proto3" json:"output_folder_uri,omitempty"`
}

func (x *GcsFolderDestination) Reset() {
	*x = GcsFolderDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsFolderDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsFolderDestination) ProtoMessage() {}

func (x *GcsFolderDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsFolderDestination.ProtoReflect.Descriptor instead.
func (*GcsFolderDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{8}
}

func (x *GcsFolderDestination) GetOutputFolderUri() string {
	if x != nil {
		return x.OutputFolderUri
	}
	return ""
}

// DataItem is a piece of data, without annotation. For example, an image.
type DataItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only.
	//
	// Types that are assignable to Payload:
	//
	//	*DataItem_ImagePayload
	//	*DataItem_TextPayload
	//	*DataItem_VideoPayload
	Payload isDataItem_Payload `protobuf_oneof:"payload"`
	// Output only. Name of the data item, in format of:
	// projects/{project_id}/datasets/{dataset_id}/dataItems/{data_item_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DataItem) Reset() {
	*x = DataItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataItem) ProtoMessage() {}

func (x *DataItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataItem.ProtoReflect.Descriptor instead.
func (*DataItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{9}
}

func (m *DataItem) GetPayload() isDataItem_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (x *DataItem) GetImagePayload() *ImagePayload {
	if x, ok := x.GetPayload().(*DataItem_ImagePayload); ok {
		return x.ImagePayload
	}
	return nil
}

func (x *DataItem) GetTextPayload() *TextPayload {
	if x, ok := x.GetPayload().(*DataItem_TextPayload); ok {
		return x.TextPayload
	}
	return nil
}

func (x *DataItem) GetVideoPayload() *VideoPayload {
	if x, ok := x.GetPayload().(*DataItem_VideoPayload); ok {
		return x.VideoPayload
	}
	return nil
}

func (x *DataItem) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isDataItem_Payload interface {
	isDataItem_Payload()
}

type DataItem_ImagePayload struct {
	// The image payload, a container of the image bytes/uri.
	ImagePayload *ImagePayload `protobuf:"bytes,2,opt,name=image_payload,json=imagePayload,proto3,oneof"`
}

type DataItem_TextPayload struct {
	// The text payload, a container of text content.
	TextPayload *TextPayload `protobuf:"bytes,3,opt,name=text_payload,json=textPayload,proto3,oneof"`
}

type DataItem_VideoPayload struct {
	// The video payload, a container of the video uri.
	VideoPayload *VideoPayload `protobuf:"bytes,4,opt,name=video_payload,json=videoPayload,proto3,oneof"`
}

func (*DataItem_ImagePayload) isDataItem_Payload() {}

func (*DataItem_TextPayload) isDataItem_Payload() {}

func (*DataItem_VideoPayload) isDataItem_Payload() {}

// AnnotatedDataset is a set holding annotations for data in a Dataset. Each
// labeling task will generate an AnnotatedDataset under the Dataset that the
// task is requested for.
type AnnotatedDataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. AnnotatedDataset resource name in format of:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The display name of the AnnotatedDataset. It is specified in
	// HumanAnnotationConfig when user starts a labeling task. Maximum of 64
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The description of the AnnotatedDataset. It is specified in
	// HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
	// characters.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Source of the annotation.
	AnnotationSource AnnotationSource `protobuf:"varint,3,opt,name=annotation_source,json=annotationSource,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationSource" json:"annotation_source,omitempty"`
	// Output only. Type of the annotation. It is specified when starting labeling
	// task.
	AnnotationType AnnotationType `protobuf:"varint,8,opt,name=annotation_type,json=annotationType,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationType" json:"annotation_type,omitempty"`
	// Output only. Number of examples in the annotated dataset.
	ExampleCount int64 `protobuf:"varint,4,opt,name=example_count,json=exampleCount,proto3" json:"example_count,omitempty"`
	// Output only. Number of examples that have annotation in the annotated
	// dataset.
	CompletedExampleCount int64 `protobuf:"varint,5,opt,name=completed_example_count,json=completedExampleCount,proto3" json:"completed_example_count,omitempty"`
	// Output only. Per label statistics.
	LabelStats *LabelStats `protobuf:"bytes,6,opt,name=label_stats,json=labelStats,proto3" json:"label_stats,omitempty"`
	// Output only. Time the AnnotatedDataset was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Additional information about AnnotatedDataset.
	Metadata *AnnotatedDatasetMetadata `protobuf:"bytes,10,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Output only. The names of any related resources that are blocking changes
	// to the annotated dataset.
	BlockingResources []string `protobuf:"bytes,11,rep,name=blocking_resources,json=blockingResources,proto3" json:"blocking_resources,omitempty"`
}

func (x *AnnotatedDataset) Reset() {
	*x = AnnotatedDataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotatedDataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotatedDataset) ProtoMessage() {}

func (x *AnnotatedDataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotatedDataset.ProtoReflect.Descriptor instead.
func (*AnnotatedDataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{10}
}

func (x *AnnotatedDataset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnnotatedDataset) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AnnotatedDataset) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AnnotatedDataset) GetAnnotationSource() AnnotationSource {
	if x != nil {
		return x.AnnotationSource
	}
	return AnnotationSource_ANNOTATION_SOURCE_UNSPECIFIED
}

func (x *AnnotatedDataset) GetAnnotationType() AnnotationType {
	if x != nil {
		return x.AnnotationType
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (x *AnnotatedDataset) GetExampleCount() int64 {
	if x != nil {
		return x.ExampleCount
	}
	return 0
}

func (x *AnnotatedDataset) GetCompletedExampleCount() int64 {
	if x != nil {
		return x.CompletedExampleCount
	}
	return 0
}

func (x *AnnotatedDataset) GetLabelStats() *LabelStats {
	if x != nil {
		return x.LabelStats
	}
	return nil
}

func (x *AnnotatedDataset) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AnnotatedDataset) GetMetadata() *AnnotatedDatasetMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *AnnotatedDataset) GetBlockingResources() []string {
	if x != nil {
		return x.BlockingResources
	}
	return nil
}

// Statistics about annotation specs.
type LabelStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of each annotation spec's example count. Key is the annotation spec
	// name and value is the number of examples for that annotation spec.
	// If the annotated dataset does not have annotation spec, the map will return
	// a pair where the key is empty string and value is the total number of
	// annotations.
	ExampleCount map[string]int64 `protobuf:"bytes,1,rep,name=example_count,json=exampleCount,proto3" json:"example_count,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *LabelStats) Reset() {
	*x = LabelStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelStats) ProtoMessage() {}

func (x *LabelStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelStats.ProtoReflect.Descriptor instead.
func (*LabelStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{11}
}

func (x *LabelStats) GetExampleCount() map[string]int64 {
	if x != nil {
		return x.ExampleCount
	}
	return nil
}

// Metadata on AnnotatedDataset.
type AnnotatedDatasetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specific request configuration used when requesting the labeling task.
	//
	// Types that are assignable to AnnotationRequestConfig:
	//
	//	*AnnotatedDatasetMetadata_ImageClassificationConfig
	//	*AnnotatedDatasetMetadata_BoundingPolyConfig
	//	*AnnotatedDatasetMetadata_PolylineConfig
	//	*AnnotatedDatasetMetadata_SegmentationConfig
	//	*AnnotatedDatasetMetadata_VideoClassificationConfig
	//	*AnnotatedDatasetMetadata_ObjectDetectionConfig
	//	*AnnotatedDatasetMetadata_ObjectTrackingConfig
	//	*AnnotatedDatasetMetadata_EventConfig
	//	*AnnotatedDatasetMetadata_TextClassificationConfig
	//	*AnnotatedDatasetMetadata_TextEntityExtractionConfig
	AnnotationRequestConfig isAnnotatedDatasetMetadata_AnnotationRequestConfig `protobuf_oneof:"annotation_request_config"`
	// HumanAnnotationConfig used when requesting the human labeling task for this
	// AnnotatedDataset.
	HumanAnnotationConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=human_annotation_config,json=humanAnnotationConfig,proto3" json:"human_annotation_config,omitempty"`
}

func (x *AnnotatedDatasetMetadata) Reset() {
	*x = AnnotatedDatasetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotatedDatasetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotatedDatasetMetadata) ProtoMessage() {}

func (x *AnnotatedDatasetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotatedDatasetMetadata.ProtoReflect.Descriptor instead.
func (*AnnotatedDatasetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{12}
}

func (m *AnnotatedDatasetMetadata) GetAnnotationRequestConfig() isAnnotatedDatasetMetadata_AnnotationRequestConfig {
	if m != nil {
		return m.AnnotationRequestConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetImageClassificationConfig() *ImageClassificationConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_ImageClassificationConfig); ok {
		return x.ImageClassificationConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetBoundingPolyConfig() *BoundingPolyConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_BoundingPolyConfig); ok {
		return x.BoundingPolyConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetPolylineConfig() *PolylineConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_PolylineConfig); ok {
		return x.PolylineConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetSegmentationConfig() *SegmentationConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_SegmentationConfig); ok {
		return x.SegmentationConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetVideoClassificationConfig() *VideoClassificationConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_VideoClassificationConfig); ok {
		return x.VideoClassificationConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetObjectDetectionConfig() *ObjectDetectionConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_ObjectDetectionConfig); ok {
		return x.ObjectDetectionConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetObjectTrackingConfig() *ObjectTrackingConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_ObjectTrackingConfig); ok {
		return x.ObjectTrackingConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetEventConfig() *EventConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_EventConfig); ok {
		return x.EventConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetTextClassificationConfig() *TextClassificationConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_TextClassificationConfig); ok {
		return x.TextClassificationConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetTextEntityExtractionConfig() *TextEntityExtractionConfig {
	if x, ok := x.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_TextEntityExtractionConfig); ok {
		return x.TextEntityExtractionConfig
	}
	return nil
}

func (x *AnnotatedDatasetMetadata) GetHumanAnnotationConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.HumanAnnotationConfig
	}
	return nil
}

type isAnnotatedDatasetMetadata_AnnotationRequestConfig interface {
	isAnnotatedDatasetMetadata_AnnotationRequestConfig()
}

type AnnotatedDatasetMetadata_ImageClassificationConfig struct {
	// Configuration for image classification task.
	ImageClassificationConfig *ImageClassificationConfig `protobuf:"bytes,2,opt,name=image_classification_config,json=imageClassificationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_BoundingPolyConfig struct {
	// Configuration for image bounding box and bounding poly task.
	BoundingPolyConfig *BoundingPolyConfig `protobuf:"bytes,3,opt,name=bounding_poly_config,json=boundingPolyConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_PolylineConfig struct {
	// Configuration for image polyline task.
	PolylineConfig *PolylineConfig `protobuf:"bytes,4,opt,name=polyline_config,json=polylineConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_SegmentationConfig struct {
	// Configuration for image segmentation task.
	SegmentationConfig *SegmentationConfig `protobuf:"bytes,5,opt,name=segmentation_config,json=segmentationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_VideoClassificationConfig struct {
	// Configuration for video classification task.
	VideoClassificationConfig *VideoClassificationConfig `protobuf:"bytes,6,opt,name=video_classification_config,json=videoClassificationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_ObjectDetectionConfig struct {
	// Configuration for video object detection task.
	ObjectDetectionConfig *ObjectDetectionConfig `protobuf:"bytes,7,opt,name=object_detection_config,json=objectDetectionConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_ObjectTrackingConfig struct {
	// Configuration for video object tracking task.
	ObjectTrackingConfig *ObjectTrackingConfig `protobuf:"bytes,8,opt,name=object_tracking_config,json=objectTrackingConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_EventConfig struct {
	// Configuration for video event labeling task.
	EventConfig *EventConfig `protobuf:"bytes,9,opt,name=event_config,json=eventConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_TextClassificationConfig struct {
	// Configuration for text classification task.
	TextClassificationConfig *TextClassificationConfig `protobuf:"bytes,10,opt,name=text_classification_config,json=textClassificationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_TextEntityExtractionConfig struct {
	// Configuration for text entity extraction task.
	TextEntityExtractionConfig *TextEntityExtractionConfig `protobuf:"bytes,11,opt,name=text_entity_extraction_config,json=textEntityExtractionConfig,proto3,oneof"`
}

func (*AnnotatedDatasetMetadata_ImageClassificationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_BoundingPolyConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_PolylineConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_SegmentationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_VideoClassificationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_ObjectDetectionConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_ObjectTrackingConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_EventConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {}

func (*AnnotatedDatasetMetadata_TextClassificationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_TextEntityExtractionConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

// An Example is a piece of data and its annotation. For example, an image with
// label "house".
type Example struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The data part of Example.
	//
	// Types that are assignable to Payload:
	//
	//	*Example_ImagePayload
	//	*Example_TextPayload
	//	*Example_VideoPayload
	Payload isExample_Payload `protobuf_oneof:"payload"`
	// Output only. Name of the example, in format of:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}/examples/{example_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Annotations for the piece of data in Example.
	// One piece of data can have multiple annotations.
	Annotations []*Annotation `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *Example) Reset() {
	*x = Example{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Example) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Example) ProtoMessage() {}

func (x *Example) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Example.ProtoReflect.Descriptor instead.
func (*Example) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP(), []int{13}
}

func (m *Example) GetPayload() isExample_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (x *Example) GetImagePayload() *ImagePayload {
	if x, ok := x.GetPayload().(*Example_ImagePayload); ok {
		return x.ImagePayload
	}
	return nil
}

func (x *Example) GetTextPayload() *TextPayload {
	if x, ok := x.GetPayload().(*Example_TextPayload); ok {
		return x.TextPayload
	}
	return nil
}

func (x *Example) GetVideoPayload() *VideoPayload {
	if x, ok := x.GetPayload().(*Example_VideoPayload); ok {
		return x.VideoPayload
	}
	return nil
}

func (x *Example) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Example) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

type isExample_Payload interface {
	isExample_Payload()
}

type Example_ImagePayload struct {
	// The image payload, a container of the image bytes/uri.
	ImagePayload *ImagePayload `protobuf:"bytes,2,opt,name=image_payload,json=imagePayload,proto3,oneof"`
}

type Example_TextPayload struct {
	// The text payload, a container of the text content.
	TextPayload *TextPayload `protobuf:"bytes,6,opt,name=text_payload,json=textPayload,proto3,oneof"`
}

type Example_VideoPayload struct {
	// The video payload, a container of the video uri.
	VideoPayload *VideoPayload `protobuf:"bytes,7,opt,name=video_payload,json=videoPayload,proto3,oneof"`
}

func (*Example_ImagePayload) isExample_Payload() {}

func (*Example_TextPayload) isExample_Payload() {}

func (*Example_VideoPayload) isExample_Payload() {}

var File_google_cloud_datalabeling_v1beta1_dataset_proto protoreflect.FileDescriptor

var file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x68, 0x75, 0x6d, 0x61, 0x6e,
	0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9c, 0x03, 0x0a, 0x07, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x0d, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x12, 0x2d, 0x0a, 0x12, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x49, 0x74,
	0x65, 0x6d, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x3a, 0x4f, 0xea, 0x41, 0x4c, 0x0a, 0x23, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x12, 0x25, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x22, 0xcc, 0x04, 0x0a, 0x0b, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x0d, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x4d, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x48, 0x01, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x5c, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x01, 0x52, 0x0e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x48, 0x0a,
	0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x72, 0x0a, 0x17, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x16, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x14, 0x0a, 0x12, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x08, 0x0a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x33, 0x0a, 0x0c, 0x54, 0x65, 0x78, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x3e, 0x0a, 0x16,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x69, 0x73, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x45, 0x0a, 0x09,
	0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x22, 0x2d, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55,
	0x72, 0x69, 0x22, 0xec, 0x01, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x6f, 0x0a, 0x16, 0x67, 0x63, 0x73, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x67, 0x63,
	0x73, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x4c, 0x0a, 0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55,
	0x72, 0x69, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x42, 0x0a, 0x14, 0x47, 0x63, 0x73, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x55, 0x72, 0x69, 0x22, 0x96, 0x03, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d,
	0x12, 0x56, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x53, 0x0a, 0x0c, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00,
	0x52, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x56, 0x0a,
	0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x66, 0xea, 0x41, 0x63, 0x0a, 0x24,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x49, 0x74, 0x65, 0x6d, 0x12, 0x3b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x49, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d,
	0x7d, 0x42, 0x09, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x9b, 0x06, 0x0a,
	0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x11, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5a, 0x0a, 0x0f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x36, 0x0a,
	0x17, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x57, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2d, 0x0a, 0x12, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x3a, 0x7e, 0xea, 0x41, 0x7b, 0x0a,
	0x2c, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x4b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x22, 0xb3, 0x01, 0x0a, 0x0a, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x64, 0x0a, 0x0d, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e,
	0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a,
	0x3f, 0x0a, 0x11, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x98, 0x0a, 0x0a, 0x18, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7e, 0x0a,
	0x1b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x19, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a,
	0x14, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x12, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x0f, 0x70, 0x6f, 0x6c, 0x79,
	0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x68, 0x0a, 0x13, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x12, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x7e, 0x0a, 0x1b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x19, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x72, 0x0a, 0x17, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x15, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54,
	0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x14, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x1a, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x18, 0x74,
	0x65, 0x78, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x82, 0x01, 0x0a, 0x1d, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x45, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00,
	0x52, 0x1a, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x17,
	0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x1b,
	0x0a, 0x19, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8a, 0x04, 0x0a, 0x07,
	0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x56, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48,
	0x00, 0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x53, 0x0a, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x56, 0x0a, 0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x0c,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x4f, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x3a, 0x89, 0x01, 0xea, 0x41, 0x85, 0x01, 0x0a, 0x23, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x5e, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x7d, 0x42, 0x09, 0x0a,
	0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2a, 0x57, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x56, 0x49,
	0x44, 0x45, 0x4f, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45, 0x58, 0x54, 0x10, 0x04, 0x12,
	0x10, 0x0a, 0x0c, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10,
	0x06, 0x42, 0xe3, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x50, 0x01, 0x5a, 0x49, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x21, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescOnce sync.Once
	file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescData = file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDesc
)

func file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescGZIP() []byte {
	file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescOnce.Do(func() {
		file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescData)
	})
	return file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDescData
}

var file_google_cloud_datalabeling_v1beta1_dataset_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_datalabeling_v1beta1_dataset_proto_goTypes = []interface{}{
	(DataType)(0),                      // 0: google.cloud.datalabeling.v1beta1.DataType
	(*Dataset)(nil),                    // 1: google.cloud.datalabeling.v1beta1.Dataset
	(*InputConfig)(nil),                // 2: google.cloud.datalabeling.v1beta1.InputConfig
	(*TextMetadata)(nil),               // 3: google.cloud.datalabeling.v1beta1.TextMetadata
	(*ClassificationMetadata)(nil),     // 4: google.cloud.datalabeling.v1beta1.ClassificationMetadata
	(*GcsSource)(nil),                  // 5: google.cloud.datalabeling.v1beta1.GcsSource
	(*BigQuerySource)(nil),             // 6: google.cloud.datalabeling.v1beta1.BigQuerySource
	(*OutputConfig)(nil),               // 7: google.cloud.datalabeling.v1beta1.OutputConfig
	(*GcsDestination)(nil),             // 8: google.cloud.datalabeling.v1beta1.GcsDestination
	(*GcsFolderDestination)(nil),       // 9: google.cloud.datalabeling.v1beta1.GcsFolderDestination
	(*DataItem)(nil),                   // 10: google.cloud.datalabeling.v1beta1.DataItem
	(*AnnotatedDataset)(nil),           // 11: google.cloud.datalabeling.v1beta1.AnnotatedDataset
	(*LabelStats)(nil),                 // 12: google.cloud.datalabeling.v1beta1.LabelStats
	(*AnnotatedDatasetMetadata)(nil),   // 13: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata
	(*Example)(nil),                    // 14: google.cloud.datalabeling.v1beta1.Example
	nil,                                // 15: google.cloud.datalabeling.v1beta1.LabelStats.ExampleCountEntry
	(*timestamppb.Timestamp)(nil),      // 16: google.protobuf.Timestamp
	(AnnotationType)(0),                // 17: google.cloud.datalabeling.v1beta1.AnnotationType
	(*ImagePayload)(nil),               // 18: google.cloud.datalabeling.v1beta1.ImagePayload
	(*TextPayload)(nil),                // 19: google.cloud.datalabeling.v1beta1.TextPayload
	(*VideoPayload)(nil),               // 20: google.cloud.datalabeling.v1beta1.VideoPayload
	(AnnotationSource)(0),              // 21: google.cloud.datalabeling.v1beta1.AnnotationSource
	(*ImageClassificationConfig)(nil),  // 22: google.cloud.datalabeling.v1beta1.ImageClassificationConfig
	(*BoundingPolyConfig)(nil),         // 23: google.cloud.datalabeling.v1beta1.BoundingPolyConfig
	(*PolylineConfig)(nil),             // 24: google.cloud.datalabeling.v1beta1.PolylineConfig
	(*SegmentationConfig)(nil),         // 25: google.cloud.datalabeling.v1beta1.SegmentationConfig
	(*VideoClassificationConfig)(nil),  // 26: google.cloud.datalabeling.v1beta1.VideoClassificationConfig
	(*ObjectDetectionConfig)(nil),      // 27: google.cloud.datalabeling.v1beta1.ObjectDetectionConfig
	(*ObjectTrackingConfig)(nil),       // 28: google.cloud.datalabeling.v1beta1.ObjectTrackingConfig
	(*EventConfig)(nil),                // 29: google.cloud.datalabeling.v1beta1.EventConfig
	(*TextClassificationConfig)(nil),   // 30: google.cloud.datalabeling.v1beta1.TextClassificationConfig
	(*TextEntityExtractionConfig)(nil), // 31: google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
	(*HumanAnnotationConfig)(nil),      // 32: google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	(*Annotation)(nil),                 // 33: google.cloud.datalabeling.v1beta1.Annotation
}
var file_google_cloud_datalabeling_v1beta1_dataset_proto_depIdxs = []int32{
	16, // 0: google.cloud.datalabeling.v1beta1.Dataset.create_time:type_name -> google.protobuf.Timestamp
	2,  // 1: google.cloud.datalabeling.v1beta1.Dataset.input_configs:type_name -> google.cloud.datalabeling.v1beta1.InputConfig
	3,  // 2: google.cloud.datalabeling.v1beta1.InputConfig.text_metadata:type_name -> google.cloud.datalabeling.v1beta1.TextMetadata
	5,  // 3: google.cloud.datalabeling.v1beta1.InputConfig.gcs_source:type_name -> google.cloud.datalabeling.v1beta1.GcsSource
	6,  // 4: google.cloud.datalabeling.v1beta1.InputConfig.bigquery_source:type_name -> google.cloud.datalabeling.v1beta1.BigQuerySource
	0,  // 5: google.cloud.datalabeling.v1beta1.InputConfig.data_type:type_name -> google.cloud.datalabeling.v1beta1.DataType
	17, // 6: google.cloud.datalabeling.v1beta1.InputConfig.annotation_type:type_name -> google.cloud.datalabeling.v1beta1.AnnotationType
	4,  // 7: google.cloud.datalabeling.v1beta1.InputConfig.classification_metadata:type_name -> google.cloud.datalabeling.v1beta1.ClassificationMetadata
	8,  // 8: google.cloud.datalabeling.v1beta1.OutputConfig.gcs_destination:type_name -> google.cloud.datalabeling.v1beta1.GcsDestination
	9,  // 9: google.cloud.datalabeling.v1beta1.OutputConfig.gcs_folder_destination:type_name -> google.cloud.datalabeling.v1beta1.GcsFolderDestination
	18, // 10: google.cloud.datalabeling.v1beta1.DataItem.image_payload:type_name -> google.cloud.datalabeling.v1beta1.ImagePayload
	19, // 11: google.cloud.datalabeling.v1beta1.DataItem.text_payload:type_name -> google.cloud.datalabeling.v1beta1.TextPayload
	20, // 12: google.cloud.datalabeling.v1beta1.DataItem.video_payload:type_name -> google.cloud.datalabeling.v1beta1.VideoPayload
	21, // 13: google.cloud.datalabeling.v1beta1.AnnotatedDataset.annotation_source:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSource
	17, // 14: google.cloud.datalabeling.v1beta1.AnnotatedDataset.annotation_type:type_name -> google.cloud.datalabeling.v1beta1.AnnotationType
	12, // 15: google.cloud.datalabeling.v1beta1.AnnotatedDataset.label_stats:type_name -> google.cloud.datalabeling.v1beta1.LabelStats
	16, // 16: google.cloud.datalabeling.v1beta1.AnnotatedDataset.create_time:type_name -> google.protobuf.Timestamp
	13, // 17: google.cloud.datalabeling.v1beta1.AnnotatedDataset.metadata:type_name -> google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata
	15, // 18: google.cloud.datalabeling.v1beta1.LabelStats.example_count:type_name -> google.cloud.datalabeling.v1beta1.LabelStats.ExampleCountEntry
	22, // 19: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.image_classification_config:type_name -> google.cloud.datalabeling.v1beta1.ImageClassificationConfig
	23, // 20: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.bounding_poly_config:type_name -> google.cloud.datalabeling.v1beta1.BoundingPolyConfig
	24, // 21: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.polyline_config:type_name -> google.cloud.datalabeling.v1beta1.PolylineConfig
	25, // 22: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.segmentation_config:type_name -> google.cloud.datalabeling.v1beta1.SegmentationConfig
	26, // 23: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.video_classification_config:type_name -> google.cloud.datalabeling.v1beta1.VideoClassificationConfig
	27, // 24: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.object_detection_config:type_name -> google.cloud.datalabeling.v1beta1.ObjectDetectionConfig
	28, // 25: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.object_tracking_config:type_name -> google.cloud.datalabeling.v1beta1.ObjectTrackingConfig
	29, // 26: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.event_config:type_name -> google.cloud.datalabeling.v1beta1.EventConfig
	30, // 27: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.text_classification_config:type_name -> google.cloud.datalabeling.v1beta1.TextClassificationConfig
	31, // 28: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.text_entity_extraction_config:type_name -> google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
	32, // 29: google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.human_annotation_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	18, // 30: google.cloud.datalabeling.v1beta1.Example.image_payload:type_name -> google.cloud.datalabeling.v1beta1.ImagePayload
	19, // 31: google.cloud.datalabeling.v1beta1.Example.text_payload:type_name -> google.cloud.datalabeling.v1beta1.TextPayload
	20, // 32: google.cloud.datalabeling.v1beta1.Example.video_payload:type_name -> google.cloud.datalabeling.v1beta1.VideoPayload
	33, // 33: google.cloud.datalabeling.v1beta1.Example.annotations:type_name -> google.cloud.datalabeling.v1beta1.Annotation
	34, // [34:34] is the sub-list for method output_type
	34, // [34:34] is the sub-list for method input_type
	34, // [34:34] is the sub-list for extension type_name
	34, // [34:34] is the sub-list for extension extendee
	0,  // [0:34] is the sub-list for field type_name
}

func init() { file_google_cloud_datalabeling_v1beta1_dataset_proto_init() }
func file_google_cloud_datalabeling_v1beta1_dataset_proto_init() {
	if File_google_cloud_datalabeling_v1beta1_dataset_proto != nil {
		return
	}
	file_google_cloud_datalabeling_v1beta1_annotation_proto_init()
	file_google_cloud_datalabeling_v1beta1_annotation_spec_set_proto_init()
	file_google_cloud_datalabeling_v1beta1_data_payloads_proto_init()
	file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClassificationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQuerySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsFolderDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotatedDataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotatedDatasetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Example); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*InputConfig_TextMetadata)(nil),
		(*InputConfig_GcsSource)(nil),
		(*InputConfig_BigquerySource)(nil),
	}
	file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*OutputConfig_GcsDestination)(nil),
		(*OutputConfig_GcsFolderDestination)(nil),
	}
	file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*DataItem_ImagePayload)(nil),
		(*DataItem_TextPayload)(nil),
		(*DataItem_VideoPayload)(nil),
	}
	file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*AnnotatedDatasetMetadata_ImageClassificationConfig)(nil),
		(*AnnotatedDatasetMetadata_BoundingPolyConfig)(nil),
		(*AnnotatedDatasetMetadata_PolylineConfig)(nil),
		(*AnnotatedDatasetMetadata_SegmentationConfig)(nil),
		(*AnnotatedDatasetMetadata_VideoClassificationConfig)(nil),
		(*AnnotatedDatasetMetadata_ObjectDetectionConfig)(nil),
		(*AnnotatedDatasetMetadata_ObjectTrackingConfig)(nil),
		(*AnnotatedDatasetMetadata_EventConfig)(nil),
		(*AnnotatedDatasetMetadata_TextClassificationConfig)(nil),
		(*AnnotatedDatasetMetadata_TextEntityExtractionConfig)(nil),
	}
	file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*Example_ImagePayload)(nil),
		(*Example_TextPayload)(nil),
		(*Example_VideoPayload)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datalabeling_v1beta1_dataset_proto_goTypes,
		DependencyIndexes: file_google_cloud_datalabeling_v1beta1_dataset_proto_depIdxs,
		EnumInfos:         file_google_cloud_datalabeling_v1beta1_dataset_proto_enumTypes,
		MessageInfos:      file_google_cloud_datalabeling_v1beta1_dataset_proto_msgTypes,
	}.Build()
	File_google_cloud_datalabeling_v1beta1_dataset_proto = out.File
	file_google_cloud_datalabeling_v1beta1_dataset_proto_rawDesc = nil
	file_google_cloud_datalabeling_v1beta1_dataset_proto_goTypes = nil
	file_google_cloud_datalabeling_v1beta1_dataset_proto_depIdxs = nil
}
