// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/feed_item_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [FeedItemService.GetFeedItem][google.ads.googleads.v3.services.FeedItemService.GetFeedItem].
type GetFeedItemRequest struct {
	// Required. The resource name of the feed item to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFeedItemRequest) Reset()         { *m = GetFeedItemRequest{} }
func (m *GetFeedItemRequest) String() string { return proto.CompactTextString(m) }
func (*GetFeedItemRequest) ProtoMessage()    {}
func (*GetFeedItemRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a2fe5829c243597, []int{0}
}

func (m *GetFeedItemRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFeedItemRequest.Unmarshal(m, b)
}
func (m *GetFeedItemRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFeedItemRequest.Marshal(b, m, deterministic)
}
func (m *GetFeedItemRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFeedItemRequest.Merge(m, src)
}
func (m *GetFeedItemRequest) XXX_Size() int {
	return xxx_messageInfo_GetFeedItemRequest.Size(m)
}
func (m *GetFeedItemRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFeedItemRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFeedItemRequest proto.InternalMessageInfo

func (m *GetFeedItemRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [FeedItemService.MutateFeedItems][google.ads.googleads.v3.services.FeedItemService.MutateFeedItems].
type MutateFeedItemsRequest struct {
	// Required. The ID of the customer whose feed items are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual feed items.
	Operations []*FeedItemOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateFeedItemsRequest) Reset()         { *m = MutateFeedItemsRequest{} }
func (m *MutateFeedItemsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateFeedItemsRequest) ProtoMessage()    {}
func (*MutateFeedItemsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a2fe5829c243597, []int{1}
}

func (m *MutateFeedItemsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateFeedItemsRequest.Unmarshal(m, b)
}
func (m *MutateFeedItemsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateFeedItemsRequest.Marshal(b, m, deterministic)
}
func (m *MutateFeedItemsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateFeedItemsRequest.Merge(m, src)
}
func (m *MutateFeedItemsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateFeedItemsRequest.Size(m)
}
func (m *MutateFeedItemsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateFeedItemsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateFeedItemsRequest proto.InternalMessageInfo

func (m *MutateFeedItemsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateFeedItemsRequest) GetOperations() []*FeedItemOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateFeedItemsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateFeedItemsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on an feed item.
type FeedItemOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*FeedItemOperation_Create
	//	*FeedItemOperation_Update
	//	*FeedItemOperation_Remove
	Operation            isFeedItemOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *FeedItemOperation) Reset()         { *m = FeedItemOperation{} }
func (m *FeedItemOperation) String() string { return proto.CompactTextString(m) }
func (*FeedItemOperation) ProtoMessage()    {}
func (*FeedItemOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a2fe5829c243597, []int{2}
}

func (m *FeedItemOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeedItemOperation.Unmarshal(m, b)
}
func (m *FeedItemOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeedItemOperation.Marshal(b, m, deterministic)
}
func (m *FeedItemOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeedItemOperation.Merge(m, src)
}
func (m *FeedItemOperation) XXX_Size() int {
	return xxx_messageInfo_FeedItemOperation.Size(m)
}
func (m *FeedItemOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_FeedItemOperation.DiscardUnknown(m)
}

var xxx_messageInfo_FeedItemOperation proto.InternalMessageInfo

func (m *FeedItemOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isFeedItemOperation_Operation interface {
	isFeedItemOperation_Operation()
}

type FeedItemOperation_Create struct {
	Create *resources.FeedItem `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type FeedItemOperation_Update struct {
	Update *resources.FeedItem `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type FeedItemOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*FeedItemOperation_Create) isFeedItemOperation_Operation() {}

func (*FeedItemOperation_Update) isFeedItemOperation_Operation() {}

func (*FeedItemOperation_Remove) isFeedItemOperation_Operation() {}

func (m *FeedItemOperation) GetOperation() isFeedItemOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *FeedItemOperation) GetCreate() *resources.FeedItem {
	if x, ok := m.GetOperation().(*FeedItemOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *FeedItemOperation) GetUpdate() *resources.FeedItem {
	if x, ok := m.GetOperation().(*FeedItemOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *FeedItemOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*FeedItemOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FeedItemOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FeedItemOperation_Create)(nil),
		(*FeedItemOperation_Update)(nil),
		(*FeedItemOperation_Remove)(nil),
	}
}

// Response message for an feed item mutate.
type MutateFeedItemsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateFeedItemResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *MutateFeedItemsResponse) Reset()         { *m = MutateFeedItemsResponse{} }
func (m *MutateFeedItemsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateFeedItemsResponse) ProtoMessage()    {}
func (*MutateFeedItemsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a2fe5829c243597, []int{3}
}

func (m *MutateFeedItemsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateFeedItemsResponse.Unmarshal(m, b)
}
func (m *MutateFeedItemsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateFeedItemsResponse.Marshal(b, m, deterministic)
}
func (m *MutateFeedItemsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateFeedItemsResponse.Merge(m, src)
}
func (m *MutateFeedItemsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateFeedItemsResponse.Size(m)
}
func (m *MutateFeedItemsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateFeedItemsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateFeedItemsResponse proto.InternalMessageInfo

func (m *MutateFeedItemsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateFeedItemsResponse) GetResults() []*MutateFeedItemResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the feed item mutate.
type MutateFeedItemResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateFeedItemResult) Reset()         { *m = MutateFeedItemResult{} }
func (m *MutateFeedItemResult) String() string { return proto.CompactTextString(m) }
func (*MutateFeedItemResult) ProtoMessage()    {}
func (*MutateFeedItemResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a2fe5829c243597, []int{4}
}

func (m *MutateFeedItemResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateFeedItemResult.Unmarshal(m, b)
}
func (m *MutateFeedItemResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateFeedItemResult.Marshal(b, m, deterministic)
}
func (m *MutateFeedItemResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateFeedItemResult.Merge(m, src)
}
func (m *MutateFeedItemResult) XXX_Size() int {
	return xxx_messageInfo_MutateFeedItemResult.Size(m)
}
func (m *MutateFeedItemResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateFeedItemResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateFeedItemResult proto.InternalMessageInfo

func (m *MutateFeedItemResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetFeedItemRequest)(nil), "google.ads.googleads.v3.services.GetFeedItemRequest")
	proto.RegisterType((*MutateFeedItemsRequest)(nil), "google.ads.googleads.v3.services.MutateFeedItemsRequest")
	proto.RegisterType((*FeedItemOperation)(nil), "google.ads.googleads.v3.services.FeedItemOperation")
	proto.RegisterType((*MutateFeedItemsResponse)(nil), "google.ads.googleads.v3.services.MutateFeedItemsResponse")
	proto.RegisterType((*MutateFeedItemResult)(nil), "google.ads.googleads.v3.services.MutateFeedItemResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/feed_item_service.proto", fileDescriptor_1a2fe5829c243597)
}

var fileDescriptor_1a2fe5829c243597 = []byte{
	// 759 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x4d, 0x6b, 0xdc, 0x46,
	0x18, 0xae, 0xb4, 0xc5, 0xad, 0x47, 0x76, 0x4d, 0xa7, 0xae, 0xbd, 0x6c, 0x0b, 0x5d, 0x54, 0x43,
	0x97, 0x75, 0x2b, 0xd1, 0x55, 0x29, 0x8e, 0x8c, 0x03, 0xda, 0xe0, 0xb5, 0x7d, 0x70, 0x6c, 0x64,
	0x30, 0x21, 0x2c, 0x88, 0xb1, 0x34, 0xbb, 0x11, 0x96, 0x34, 0xca, 0xcc, 0x68, 0xc1, 0x18, 0x5f,
	0x02, 0xf9, 0x05, 0xf9, 0x07, 0x39, 0xe6, 0x1a, 0xf2, 0x0b, 0x72, 0xf3, 0x35, 0x37, 0x9f, 0x72,
	0x08, 0x39, 0xe4, 0x2f, 0xe4, 0x12, 0xa4, 0xd1, 0xec, 0x97, 0x6d, 0x16, 0xfb, 0xf6, 0xee, 0xbc,
	0xcf, 0xf3, 0xbc, 0xdf, 0x5a, 0xb0, 0xd1, 0x27, 0xa4, 0x1f, 0x61, 0x13, 0x05, 0xcc, 0x14, 0x66,
	0x6e, 0x0d, 0x2c, 0x93, 0x61, 0x3a, 0x08, 0x7d, 0xcc, 0xcc, 0x1e, 0xc6, 0x81, 0x17, 0x72, 0x1c,
	0x7b, 0xe5, 0x93, 0x91, 0x52, 0xc2, 0x09, 0xac, 0x0b, 0xb8, 0x81, 0x02, 0x66, 0x0c, 0x99, 0xc6,
	0xc0, 0x32, 0x24, 0xb3, 0xf6, 0xef, 0x6d, 0xda, 0x14, 0x33, 0x92, 0xd1, 0x09, 0x71, 0x21, 0x5a,
	0xfb, 0x5d, 0x52, 0xd2, 0xd0, 0x44, 0x49, 0x42, 0x38, 0xe2, 0x21, 0x49, 0x58, 0xe9, 0x5d, 0x1d,
	0xf3, 0xfa, 0x51, 0x88, 0x13, 0x5e, 0x3a, 0xfe, 0x18, 0x73, 0xf4, 0x42, 0x1c, 0x05, 0xde, 0x09,
	0x7e, 0x86, 0x06, 0x21, 0xa1, 0x25, 0xa0, 0x4c, 0xd6, 0x2c, 0x7e, 0x9d, 0x64, 0xbd, 0x12, 0x15,
	0x23, 0x76, 0x3a, 0xa5, 0x4d, 0x53, 0xdf, 0x64, 0x1c, 0xf1, 0xac, 0x0c, 0xaa, 0x3f, 0x04, 0x70,
	0x07, 0xf3, 0x0e, 0xc6, 0xc1, 0x1e, 0xc7, 0xb1, 0x8b, 0x9f, 0x67, 0x98, 0x71, 0xd8, 0x00, 0x8b,
	0xb2, 0x0a, 0x2f, 0x41, 0x31, 0xae, 0x2a, 0x75, 0xa5, 0x31, 0xdf, 0xae, 0x7c, 0x74, 0x54, 0x77,
	0x41, 0x7a, 0x1e, 0xa3, 0x18, 0xeb, 0x9f, 0x15, 0xb0, 0xb2, 0x9f, 0x71, 0xc4, 0xb1, 0xd4, 0x60,
	0x52, 0x64, 0x0d, 0x68, 0x7e, 0xc6, 0x38, 0x89, 0x31, 0xf5, 0xc2, 0x60, 0x5c, 0x02, 0xc8, 0xf7,
	0xbd, 0x00, 0x3e, 0x01, 0x80, 0xa4, 0x98, 0x8a, 0x4e, 0x54, 0xd5, 0x7a, 0xa5, 0xa1, 0xb5, 0x2c,
	0x63, 0x56, 0xf7, 0x0d, 0x19, 0xed, 0x40, 0x72, 0x4b, 0xe5, 0x91, 0x16, 0xfc, 0x0b, 0x2c, 0xa5,
	0x88, 0xf2, 0x10, 0x45, 0x5e, 0x0f, 0x85, 0x51, 0x46, 0x71, 0xb5, 0x52, 0x57, 0x1a, 0x3f, 0xba,
	0x3f, 0x95, 0xcf, 0x1d, 0xf1, 0x0a, 0xff, 0x04, 0x8b, 0x03, 0x14, 0x85, 0x01, 0xe2, 0xd8, 0x23,
	0x49, 0x74, 0x56, 0xfd, 0xbe, 0x80, 0x2d, 0xc8, 0xc7, 0x83, 0x24, 0x3a, 0xd3, 0x5f, 0xaa, 0xe0,
	0xe7, 0x6b, 0x41, 0xe1, 0x26, 0xd0, 0xb2, 0xb4, 0x20, 0xe6, 0xcd, 0x2e, 0x88, 0x5a, 0xab, 0x26,
	0xd3, 0x97, 0xf3, 0x30, 0x3a, 0xf9, 0x3c, 0xf6, 0x11, 0x3b, 0x75, 0x81, 0x80, 0xe7, 0x36, 0xdc,
	0x06, 0x73, 0x3e, 0xc5, 0x88, 0x8b, 0xf6, 0x6a, 0xad, 0xf5, 0x5b, 0xcb, 0x1e, 0xae, 0xd4, 0xb0,
	0xee, 0xdd, 0xef, 0xdc, 0x92, 0x9c, 0xcb, 0x08, 0xd1, 0xaa, 0x7a, 0x2f, 0x19, 0x41, 0x86, 0x55,
	0x30, 0x47, 0x71, 0x4c, 0x06, 0xa2, 0x4b, 0xf3, 0xb9, 0x47, 0xfc, 0x6e, 0x6b, 0x60, 0x7e, 0xd8,
	0x56, 0xfd, 0xad, 0x02, 0x56, 0xaf, 0x0d, 0x9c, 0xa5, 0x24, 0x61, 0x18, 0x76, 0xc0, 0xaf, 0x53,
	0x1d, 0xf7, 0x30, 0xa5, 0x84, 0x16, 0x8a, 0x5a, 0x0b, 0xca, 0xc4, 0x68, 0xea, 0x1b, 0x47, 0xc5,
	0x16, 0xba, 0xbf, 0x4c, 0xce, 0x62, 0x3b, 0x87, 0xc3, 0x43, 0xf0, 0x03, 0xc5, 0x2c, 0x8b, 0xb8,
	0x5c, 0x88, 0xff, 0x67, 0x2f, 0xc4, 0x64, 0x4e, 0x6e, 0x41, 0x77, 0xa5, 0x8c, 0xbe, 0x09, 0x96,
	0x6f, 0x02, 0xe4, 0xa3, 0xbf, 0x61, 0xd1, 0x27, 0x77, 0xbc, 0xf5, 0xbe, 0x02, 0x96, 0x24, 0xef,
	0x48, 0xc4, 0x83, 0xef, 0x14, 0xa0, 0x8d, 0x1d, 0x0e, 0xfc, 0x6f, 0x76, 0x86, 0xd7, 0xef, 0xac,
	0x76, 0x97, 0x51, 0xe9, 0x8f, 0xae, 0x9c, 0xc9, 0x64, 0x5f, 0x7c, 0xf8, 0xf4, 0x4a, 0xfd, 0x07,
	0xae, 0xe7, 0x1f, 0x9d, 0xf3, 0x09, 0xcf, 0x96, 0x3c, 0x30, 0x66, 0x36, 0x8b, 0xaf, 0x50, 0x31,
	0x27, 0xb3, 0x79, 0x01, 0xaf, 0x14, 0xb0, 0x34, 0x35, 0x3e, 0xb8, 0x71, 0xd7, 0xee, 0xca, 0x13,
	0xaf, 0x3d, 0xb8, 0x07, 0x53, 0xec, 0x8a, 0xee, 0x5e, 0x39, 0x2b, 0x63, 0x9f, 0x87, 0xbf, 0x47,
	0x87, 0x5b, 0x94, 0x65, 0xe9, 0x46, 0x5e, 0xd6, 0xa8, 0x8e, 0xf3, 0x31, 0xf0, 0x56, 0xf3, 0x62,
	0x54, 0x95, 0x1d, 0x17, 0x11, 0x6c, 0xa5, 0x59, 0xfb, 0xed, 0xd2, 0xa9, 0x8e, 0xb2, 0x28, 0xad,
	0x34, 0x64, 0x86, 0x4f, 0xe2, 0xf6, 0x57, 0x05, 0xac, 0xf9, 0x24, 0x9e, 0x99, 0x71, 0x7b, 0x79,
	0x6a, 0xd6, 0x87, 0xf9, 0x15, 0x1f, 0x2a, 0x4f, 0x77, 0x4b, 0x66, 0x9f, 0x44, 0x28, 0xe9, 0x1b,
	0x84, 0xf6, 0xcd, 0x3e, 0x4e, 0x8a, 0x1b, 0x37, 0x47, 0xb1, 0x6e, 0xff, 0xaf, 0xd9, 0x94, 0xc6,
	0x6b, 0xb5, 0xb2, 0xe3, 0x38, 0x6f, 0xd4, 0xfa, 0x8e, 0x10, 0x74, 0x02, 0x66, 0x08, 0x33, 0xb7,
	0x8e, 0x2d, 0xa3, 0x0c, 0xcc, 0x2e, 0x25, 0xa4, 0xeb, 0x04, 0xac, 0x3b, 0x84, 0x74, 0x8f, 0xad,
	0xae, 0x84, 0x7c, 0x51, 0xd7, 0xc4, 0xbb, 0x6d, 0x3b, 0x01, 0xb3, 0xed, 0x21, 0xc8, 0xb6, 0x8f,
	0x2d, 0xdb, 0x96, 0xb0, 0x93, 0xb9, 0x22, 0x4f, 0xeb, 0x5b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xbe,
	0x87, 0xfe, 0x4a, 0x12, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FeedItemServiceClient is the client API for FeedItemService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FeedItemServiceClient interface {
	// Returns the requested feed item in full detail.
	GetFeedItem(ctx context.Context, in *GetFeedItemRequest, opts ...grpc.CallOption) (*resources.FeedItem, error)
	// Creates, updates, or removes feed items. Operation statuses are
	// returned.
	MutateFeedItems(ctx context.Context, in *MutateFeedItemsRequest, opts ...grpc.CallOption) (*MutateFeedItemsResponse, error)
}

type feedItemServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFeedItemServiceClient(cc grpc.ClientConnInterface) FeedItemServiceClient {
	return &feedItemServiceClient{cc}
}

func (c *feedItemServiceClient) GetFeedItem(ctx context.Context, in *GetFeedItemRequest, opts ...grpc.CallOption) (*resources.FeedItem, error) {
	out := new(resources.FeedItem)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.FeedItemService/GetFeedItem", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *feedItemServiceClient) MutateFeedItems(ctx context.Context, in *MutateFeedItemsRequest, opts ...grpc.CallOption) (*MutateFeedItemsResponse, error) {
	out := new(MutateFeedItemsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.FeedItemService/MutateFeedItems", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FeedItemServiceServer is the server API for FeedItemService service.
type FeedItemServiceServer interface {
	// Returns the requested feed item in full detail.
	GetFeedItem(context.Context, *GetFeedItemRequest) (*resources.FeedItem, error)
	// Creates, updates, or removes feed items. Operation statuses are
	// returned.
	MutateFeedItems(context.Context, *MutateFeedItemsRequest) (*MutateFeedItemsResponse, error)
}

// UnimplementedFeedItemServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFeedItemServiceServer struct {
}

func (*UnimplementedFeedItemServiceServer) GetFeedItem(ctx context.Context, req *GetFeedItemRequest) (*resources.FeedItem, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetFeedItem not implemented")
}
func (*UnimplementedFeedItemServiceServer) MutateFeedItems(ctx context.Context, req *MutateFeedItemsRequest) (*MutateFeedItemsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateFeedItems not implemented")
}

func RegisterFeedItemServiceServer(s *grpc.Server, srv FeedItemServiceServer) {
	s.RegisterService(&_FeedItemService_serviceDesc, srv)
}

func _FeedItemService_GetFeedItem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeedItemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeedItemServiceServer).GetFeedItem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.FeedItemService/GetFeedItem",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeedItemServiceServer).GetFeedItem(ctx, req.(*GetFeedItemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeedItemService_MutateFeedItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateFeedItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeedItemServiceServer).MutateFeedItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.FeedItemService/MutateFeedItems",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeedItemServiceServer).MutateFeedItems(ctx, req.(*MutateFeedItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FeedItemService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.FeedItemService",
	HandlerType: (*FeedItemServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetFeedItem",
			Handler:    _FeedItemService_GetFeedItem_Handler,
		},
		{
			MethodName: "MutateFeedItems",
			Handler:    _FeedItemService_MutateFeedItems_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/feed_item_service.proto",
}
