// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/customer.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A customer.
type Customer struct {
	// The resource name of the customer.
	// Customer resource names have the form:
	//
	// `customers/{customer_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the customer.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// Optional, non-unique descriptive name of the customer.
	DescriptiveName *wrappers.StringValue `protobuf:"bytes,4,opt,name=descriptive_name,json=descriptiveName,proto3" json:"descriptive_name,omitempty"`
	// The currency in which the account operates.
	// A subset of the currency codes from the ISO 4217 standard is
	// supported.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,5,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// The local timezone ID of the customer.
	TimeZone *wrappers.StringValue `protobuf:"bytes,6,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// The URL template for constructing a tracking URL out of parameters.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,7,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The URL template for appending params to the final URL
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,11,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// Whether auto-tagging is enabled for the customer.
	AutoTaggingEnabled *wrappers.BoolValue `protobuf:"bytes,8,opt,name=auto_tagging_enabled,json=autoTaggingEnabled,proto3" json:"auto_tagging_enabled,omitempty"`
	// Whether the Customer has a Partners program badge. If the Customer is not
	// associated with the Partners program, this will be false. For more
	// information, see https://support.google.com/partners/answer/3125774.
	HasPartnersBadge *wrappers.BoolValue `protobuf:"bytes,9,opt,name=has_partners_badge,json=hasPartnersBadge,proto3" json:"has_partners_badge,omitempty"`
	// Whether the customer is a manager.
	Manager *wrappers.BoolValue `protobuf:"bytes,12,opt,name=manager,proto3" json:"manager,omitempty"`
	// Whether the customer is a test account.
	TestAccount *wrappers.BoolValue `protobuf:"bytes,13,opt,name=test_account,json=testAccount,proto3" json:"test_account,omitempty"`
	// Call reporting setting for a customer.
	CallReportingSetting *CallReportingSetting `protobuf:"bytes,10,opt,name=call_reporting_setting,json=callReportingSetting,proto3" json:"call_reporting_setting,omitempty"`
	// Conversion tracking setting for a customer.
	ConversionTrackingSetting *ConversionTrackingSetting `protobuf:"bytes,14,opt,name=conversion_tracking_setting,json=conversionTrackingSetting,proto3" json:"conversion_tracking_setting,omitempty"`
	// Remarketing setting for a customer.
	RemarketingSetting *RemarketingSetting `protobuf:"bytes,15,opt,name=remarketing_setting,json=remarketingSetting,proto3" json:"remarketing_setting,omitempty"`
	// Reasons why the customer is not eligible to use PaymentMode.CONVERSIONS. If
	// the list is empty, the customer is eligible. This field is read-only.
	PayPerConversionEligibilityFailureReasons []enums.CustomerPayPerConversionEligibilityFailureReasonEnum_CustomerPayPerConversionEligibilityFailureReason `protobuf:"varint,16,rep,packed,name=pay_per_conversion_eligibility_failure_reasons,json=payPerConversionEligibilityFailureReasons,proto3,enum=google.ads.googleads.v1.enums.CustomerPayPerConversionEligibilityFailureReasonEnum_CustomerPayPerConversionEligibilityFailureReason" json:"pay_per_conversion_eligibility_failure_reasons,omitempty"`
	XXX_NoUnkeyedLiteral                      struct{}                                                                                                      `json:"-"`
	XXX_unrecognized                          []byte                                                                                                        `json:"-"`
	XXX_sizecache                             int32                                                                                                         `json:"-"`
}

func (m *Customer) Reset()         { *m = Customer{} }
func (m *Customer) String() string { return proto.CompactTextString(m) }
func (*Customer) ProtoMessage()    {}
func (*Customer) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f95889c65daf179, []int{0}
}

func (m *Customer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Customer.Unmarshal(m, b)
}
func (m *Customer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Customer.Marshal(b, m, deterministic)
}
func (m *Customer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Customer.Merge(m, src)
}
func (m *Customer) XXX_Size() int {
	return xxx_messageInfo_Customer.Size(m)
}
func (m *Customer) XXX_DiscardUnknown() {
	xxx_messageInfo_Customer.DiscardUnknown(m)
}

var xxx_messageInfo_Customer proto.InternalMessageInfo

func (m *Customer) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Customer) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Customer) GetDescriptiveName() *wrappers.StringValue {
	if m != nil {
		return m.DescriptiveName
	}
	return nil
}

func (m *Customer) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *Customer) GetTimeZone() *wrappers.StringValue {
	if m != nil {
		return m.TimeZone
	}
	return nil
}

func (m *Customer) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *Customer) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *Customer) GetAutoTaggingEnabled() *wrappers.BoolValue {
	if m != nil {
		return m.AutoTaggingEnabled
	}
	return nil
}

func (m *Customer) GetHasPartnersBadge() *wrappers.BoolValue {
	if m != nil {
		return m.HasPartnersBadge
	}
	return nil
}

func (m *Customer) GetManager() *wrappers.BoolValue {
	if m != nil {
		return m.Manager
	}
	return nil
}

func (m *Customer) GetTestAccount() *wrappers.BoolValue {
	if m != nil {
		return m.TestAccount
	}
	return nil
}

func (m *Customer) GetCallReportingSetting() *CallReportingSetting {
	if m != nil {
		return m.CallReportingSetting
	}
	return nil
}

func (m *Customer) GetConversionTrackingSetting() *ConversionTrackingSetting {
	if m != nil {
		return m.ConversionTrackingSetting
	}
	return nil
}

func (m *Customer) GetRemarketingSetting() *RemarketingSetting {
	if m != nil {
		return m.RemarketingSetting
	}
	return nil
}

func (m *Customer) GetPayPerConversionEligibilityFailureReasons() []enums.CustomerPayPerConversionEligibilityFailureReasonEnum_CustomerPayPerConversionEligibilityFailureReason {
	if m != nil {
		return m.PayPerConversionEligibilityFailureReasons
	}
	return nil
}

// Call reporting setting for a customer.
type CallReportingSetting struct {
	// Enable reporting of phone call events by redirecting them via Google
	// System.
	CallReportingEnabled *wrappers.BoolValue `protobuf:"bytes,1,opt,name=call_reporting_enabled,json=callReportingEnabled,proto3" json:"call_reporting_enabled,omitempty"`
	// Whether to enable call conversion reporting.
	CallConversionReportingEnabled *wrappers.BoolValue `protobuf:"bytes,2,opt,name=call_conversion_reporting_enabled,json=callConversionReportingEnabled,proto3" json:"call_conversion_reporting_enabled,omitempty"`
	// Customer-level call conversion action to attribute a call conversion to.
	// If not set a default conversion action is used. Only in effect when
	// call_conversion_reporting_enabled is set to true.
	CallConversionAction *wrappers.StringValue `protobuf:"bytes,9,opt,name=call_conversion_action,json=callConversionAction,proto3" json:"call_conversion_action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CallReportingSetting) Reset()         { *m = CallReportingSetting{} }
func (m *CallReportingSetting) String() string { return proto.CompactTextString(m) }
func (*CallReportingSetting) ProtoMessage()    {}
func (*CallReportingSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f95889c65daf179, []int{1}
}

func (m *CallReportingSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CallReportingSetting.Unmarshal(m, b)
}
func (m *CallReportingSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CallReportingSetting.Marshal(b, m, deterministic)
}
func (m *CallReportingSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CallReportingSetting.Merge(m, src)
}
func (m *CallReportingSetting) XXX_Size() int {
	return xxx_messageInfo_CallReportingSetting.Size(m)
}
func (m *CallReportingSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_CallReportingSetting.DiscardUnknown(m)
}

var xxx_messageInfo_CallReportingSetting proto.InternalMessageInfo

func (m *CallReportingSetting) GetCallReportingEnabled() *wrappers.BoolValue {
	if m != nil {
		return m.CallReportingEnabled
	}
	return nil
}

func (m *CallReportingSetting) GetCallConversionReportingEnabled() *wrappers.BoolValue {
	if m != nil {
		return m.CallConversionReportingEnabled
	}
	return nil
}

func (m *CallReportingSetting) GetCallConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.CallConversionAction
	}
	return nil
}

// A collection of customer-wide settings related to Google Ads Conversion
// Tracking.
type ConversionTrackingSetting struct {
	// The conversion tracking id used for this account. This id is automatically
	// assigned after any conversion tracking feature is used. If the customer
	// doesn't use conversion tracking, this is 0. This field is read-only.
	ConversionTrackingId *wrappers.Int64Value `protobuf:"bytes,1,opt,name=conversion_tracking_id,json=conversionTrackingId,proto3" json:"conversion_tracking_id,omitempty"`
	// The conversion tracking id of the customer's manager. This is set when the
	// customer is opted into cross account conversion tracking, and it overrides
	// conversion_tracking_id. This field can only be managed through the Google
	// Ads UI. This field is read-only.
	CrossAccountConversionTrackingId *wrappers.Int64Value `protobuf:"bytes,2,opt,name=cross_account_conversion_tracking_id,json=crossAccountConversionTrackingId,proto3" json:"cross_account_conversion_tracking_id,omitempty"`
	XXX_NoUnkeyedLiteral             struct{}             `json:"-"`
	XXX_unrecognized                 []byte               `json:"-"`
	XXX_sizecache                    int32                `json:"-"`
}

func (m *ConversionTrackingSetting) Reset()         { *m = ConversionTrackingSetting{} }
func (m *ConversionTrackingSetting) String() string { return proto.CompactTextString(m) }
func (*ConversionTrackingSetting) ProtoMessage()    {}
func (*ConversionTrackingSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f95889c65daf179, []int{2}
}

func (m *ConversionTrackingSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConversionTrackingSetting.Unmarshal(m, b)
}
func (m *ConversionTrackingSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConversionTrackingSetting.Marshal(b, m, deterministic)
}
func (m *ConversionTrackingSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConversionTrackingSetting.Merge(m, src)
}
func (m *ConversionTrackingSetting) XXX_Size() int {
	return xxx_messageInfo_ConversionTrackingSetting.Size(m)
}
func (m *ConversionTrackingSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_ConversionTrackingSetting.DiscardUnknown(m)
}

var xxx_messageInfo_ConversionTrackingSetting proto.InternalMessageInfo

func (m *ConversionTrackingSetting) GetConversionTrackingId() *wrappers.Int64Value {
	if m != nil {
		return m.ConversionTrackingId
	}
	return nil
}

func (m *ConversionTrackingSetting) GetCrossAccountConversionTrackingId() *wrappers.Int64Value {
	if m != nil {
		return m.CrossAccountConversionTrackingId
	}
	return nil
}

// Remarketing setting for a customer.
type RemarketingSetting struct {
	// The Google global site tag.
	GoogleGlobalSiteTag  *wrappers.StringValue `protobuf:"bytes,1,opt,name=google_global_site_tag,json=googleGlobalSiteTag,proto3" json:"google_global_site_tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *RemarketingSetting) Reset()         { *m = RemarketingSetting{} }
func (m *RemarketingSetting) String() string { return proto.CompactTextString(m) }
func (*RemarketingSetting) ProtoMessage()    {}
func (*RemarketingSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_3f95889c65daf179, []int{3}
}

func (m *RemarketingSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemarketingSetting.Unmarshal(m, b)
}
func (m *RemarketingSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemarketingSetting.Marshal(b, m, deterministic)
}
func (m *RemarketingSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemarketingSetting.Merge(m, src)
}
func (m *RemarketingSetting) XXX_Size() int {
	return xxx_messageInfo_RemarketingSetting.Size(m)
}
func (m *RemarketingSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_RemarketingSetting.DiscardUnknown(m)
}

var xxx_messageInfo_RemarketingSetting proto.InternalMessageInfo

func (m *RemarketingSetting) GetGoogleGlobalSiteTag() *wrappers.StringValue {
	if m != nil {
		return m.GoogleGlobalSiteTag
	}
	return nil
}

func init() {
	proto.RegisterType((*Customer)(nil), "google.ads.googleads.v1.resources.Customer")
	proto.RegisterType((*CallReportingSetting)(nil), "google.ads.googleads.v1.resources.CallReportingSetting")
	proto.RegisterType((*ConversionTrackingSetting)(nil), "google.ads.googleads.v1.resources.ConversionTrackingSetting")
	proto.RegisterType((*RemarketingSetting)(nil), "google.ads.googleads.v1.resources.RemarketingSetting")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/customer.proto", fileDescriptor_3f95889c65daf179)
}

var fileDescriptor_3f95889c65daf179 = []byte{
	// 879 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x96, 0xdf, 0x6e, 0xe4, 0x34,
	0x14, 0xc6, 0x95, 0x29, 0xec, 0xb6, 0xee, 0x9f, 0xad, 0xbc, 0xc3, 0x2a, 0xdb, 0x5d, 0xad, 0xda,
	0xc2, 0x4a, 0x45, 0x48, 0x19, 0x66, 0x59, 0x40, 0x0c, 0x70, 0x31, 0xad, 0xba, 0x65, 0x11, 0x42,
	0x43, 0xda, 0xed, 0x45, 0x55, 0xc9, 0xf2, 0x24, 0x67, 0xb2, 0x56, 0x1d, 0x3b, 0xb2, 0x9d, 0x42,
	0x11, 0x97, 0x5c, 0xf1, 0x18, 0x70, 0xc7, 0xa3, 0xf0, 0x0a, 0xbc, 0x00, 0xe2, 0x11, 0xb8, 0x42,
	0x71, 0xe2, 0x4c, 0xab, 0xcc, 0x34, 0xd3, 0xab, 0xf1, 0xd8, 0xe7, 0xfb, 0x7d, 0xb6, 0x73, 0xce,
	0x49, 0xd0, 0xc7, 0x89, 0x94, 0x09, 0x87, 0x1e, 0x8d, 0x75, 0xaf, 0x1c, 0x16, 0xa3, 0xcb, 0x7e,
	0x4f, 0x81, 0x96, 0xb9, 0x8a, 0x40, 0xf7, 0xa2, 0x5c, 0x1b, 0x99, 0x82, 0x0a, 0x32, 0x25, 0x8d,
	0xc4, 0x3b, 0x65, 0x58, 0x40, 0x63, 0x1d, 0xd4, 0x8a, 0xe0, 0xb2, 0x1f, 0xd4, 0x8a, 0xad, 0xb3,
	0x79, 0x50, 0x10, 0x79, 0x3a, 0x05, 0x92, 0x8c, 0x5e, 0x91, 0x0c, 0x14, 0x89, 0xa4, 0xb8, 0x04,
	0xa5, 0x99, 0x14, 0x04, 0x38, 0x4b, 0xd8, 0x98, 0x71, 0x66, 0xae, 0xc8, 0x84, 0x32, 0x9e, 0x2b,
	0x20, 0x0a, 0xa8, 0x96, 0xa2, 0xb4, 0xdf, 0x7a, 0x56, 0xb1, 0xed, 0xbf, 0x71, 0x3e, 0xe9, 0xfd,
	0xa8, 0x68, 0x96, 0x81, 0xd2, 0xd5, 0xfa, 0x53, 0xe7, 0x9d, 0xb1, 0x1e, 0x15, 0x42, 0x1a, 0x6a,
	0x98, 0x14, 0xd5, 0xea, 0xee, 0x6f, 0x08, 0x2d, 0x1f, 0x54, 0xf6, 0xf8, 0x7d, 0xb4, 0xee, 0xf6,
	0x4c, 0x04, 0x4d, 0xc1, 0xf7, 0xb6, 0xbd, 0xbd, 0x95, 0x70, 0xcd, 0x4d, 0x7e, 0x4f, 0x53, 0xc0,
	0x1f, 0xa1, 0x0e, 0x8b, 0xfd, 0xa5, 0x6d, 0x6f, 0x6f, 0xf5, 0xc5, 0x93, 0xea, 0xc0, 0x81, 0x33,
	0x0f, 0x5e, 0x0b, 0xf3, 0xd9, 0xcb, 0x53, 0xca, 0x73, 0x08, 0x3b, 0x2c, 0xc6, 0x47, 0x68, 0x33,
	0x06, 0x1d, 0x29, 0x96, 0x19, 0x76, 0x59, 0x41, 0xdf, 0xb1, 0xd2, 0xa7, 0x0d, 0xe9, 0xb1, 0x51,
	0x4c, 0x24, 0xa5, 0xf6, 0xc1, 0x35, 0x95, 0x75, 0x1d, 0xa2, 0xf5, 0x28, 0x57, 0x0a, 0x44, 0x74,
	0x45, 0x22, 0x19, 0x83, 0xff, 0xee, 0x02, 0x94, 0x35, 0x27, 0x39, 0x90, 0x31, 0xe0, 0x2f, 0xd0,
	0x8a, 0x61, 0x29, 0x90, 0x9f, 0xa5, 0x00, 0xff, 0xde, 0x02, 0xf2, 0xe5, 0x22, 0xfc, 0x4c, 0x0a,
	0xc0, 0x23, 0xf4, 0x9e, 0x51, 0x34, 0xba, 0x60, 0x22, 0x21, 0xb9, 0xe2, 0xc4, 0x40, 0x9a, 0x71,
	0x6a, 0xc0, 0xbf, 0xbf, 0x00, 0xe6, 0xa1, 0x93, 0xbe, 0x51, 0xfc, 0xa4, 0x12, 0xe2, 0x57, 0x68,
	0x73, 0xc2, 0x04, 0xe5, 0x16, 0xa7, 0xf3, 0xc9, 0x84, 0xfd, 0xe4, 0xaf, 0x2e, 0x00, 0xdb, 0xb0,
	0xaa, 0x37, 0x8a, 0x1f, 0x5b, 0x0d, 0xfe, 0x0e, 0x75, 0x69, 0x6e, 0x24, 0x31, 0x34, 0x49, 0x8a,
	0xdd, 0x81, 0xa0, 0x63, 0x0e, 0xb1, 0xbf, 0x6c, 0x59, 0x5b, 0x0d, 0xd6, 0xbe, 0x94, 0xbc, 0x24,
	0xe1, 0x42, 0x77, 0x52, 0xca, 0x0e, 0x4b, 0x15, 0xfe, 0x06, 0xe1, 0xb7, 0x54, 0x93, 0x8c, 0x2a,
	0x23, 0x40, 0x69, 0x32, 0xa6, 0x71, 0x02, 0xfe, 0x4a, 0x2b, 0x6b, 0xf3, 0x2d, 0xd5, 0xa3, 0x4a,
	0xb4, 0x5f, 0x68, 0xf0, 0x4b, 0x74, 0x3f, 0xa5, 0x82, 0x26, 0xa0, 0xfc, 0xb5, 0x56, 0xb9, 0x0b,
	0xc5, 0x5f, 0xa3, 0x35, 0x03, 0xda, 0x10, 0x1a, 0x45, 0x32, 0x17, 0xc6, 0x5f, 0x6f, 0x95, 0xae,
	0x16, 0xf1, 0xc3, 0x32, 0x1c, 0xa7, 0xe8, 0x51, 0x44, 0x39, 0x27, 0x0a, 0x32, 0xa9, 0x4c, 0x71,
	0x1d, 0x1a, 0x4c, 0xf1, 0xeb, 0x23, 0x0b, 0xfa, 0x3c, 0x68, 0x2d, 0xd5, 0xe0, 0x80, 0x72, 0x1e,
	0x3a, 0xfd, 0x71, 0x29, 0x0f, 0xbb, 0xd1, 0x8c, 0x59, 0xfc, 0x0b, 0x7a, 0x72, 0xad, 0x50, 0xeb,
	0x04, 0x71, 0x9e, 0x1b, 0xd6, 0xf3, 0xab, 0x45, 0x3c, 0x6b, 0xca, 0x49, 0x05, 0x71, 0xc6, 0x8f,
	0xa3, 0x79, 0x4b, 0x78, 0x82, 0x1e, 0x2a, 0x48, 0xa9, 0xba, 0x80, 0x1b, 0x27, 0x7d, 0x60, 0x5d,
	0x3f, 0x5d, 0xc0, 0x35, 0x9c, 0xaa, 0x9d, 0x1d, 0x56, 0x8d, 0x39, 0xfc, 0x8f, 0x87, 0x82, 0x3b,
	0xf5, 0x25, 0xed, 0x6f, 0x6e, 0x2f, 0xed, 0x6d, 0xbc, 0xf8, 0xd5, 0x9b, 0xbb, 0x09, 0xdb, 0xf6,
	0x02, 0xd7, 0x77, 0x46, 0xf4, 0x6a, 0x04, 0x6a, 0x7a, 0x09, 0x87, 0x53, 0xf4, 0xab, 0x92, 0x1c,
	0x5a, 0xf0, 0xa1, 0xc8, 0xd3, 0x3b, 0x8b, 0xc2, 0x0f, 0xb3, 0x05, 0x23, 0xf5, 0xee, 0x1f, 0x1d,
	0xd4, 0x9d, 0xf5, 0xfc, 0xf1, 0xa8, 0x91, 0x58, 0xae, 0xce, 0xbc, 0xd6, 0x0c, 0xbd, 0x99, 0x3b,
	0xae, 0xd2, 0x00, 0xed, 0x58, 0xe2, 0xb5, 0x1b, 0x6d, 0xc2, 0x3b, 0xad, 0xf0, 0x67, 0x05, 0x64,
	0x7a, 0xb4, 0x86, 0x4d, 0x58, 0x6d, 0xfc, 0x9a, 0x0d, 0x8d, 0x8a, 0xfe, 0x5f, 0x15, 0xf5, 0xed,
	0xcd, 0xa6, 0x7b, 0x93, 0x3e, 0xb4, 0xca, 0xdd, 0xbf, 0x3d, 0xf4, 0x78, 0x6e, 0xc6, 0xe2, 0x1f,
	0xd0, 0xa3, 0x59, 0x45, 0xc1, 0xdc, 0x55, 0xdd, 0xfa, 0xca, 0xe8, 0x36, 0xd3, 0xfd, 0x75, 0x8c,
	0x2f, 0xd0, 0x07, 0x91, 0x92, 0x5a, 0xbb, 0xb6, 0x40, 0xe6, 0x18, 0x74, 0xda, 0x0d, 0xb6, 0x2d,
	0xa8, 0xea, 0x17, 0x07, 0x33, 0xcc, 0x76, 0x13, 0x84, 0x9b, 0x85, 0x51, 0x9c, 0xaa, 0xa4, 0x92,
	0x84, 0xcb, 0x31, 0xe5, 0x44, 0x33, 0x03, 0x45, 0xd3, 0xad, 0x4e, 0xd5, 0xf2, 0x06, 0x28, 0x17,
	0x8f, 0xac, 0xf4, 0x98, 0x19, 0x38, 0xa1, 0xc9, 0xfe, 0x7f, 0x1e, 0x7a, 0x1e, 0xc9, 0xb4, 0xbd,
	0x50, 0xf7, 0xd7, 0xeb, 0x9c, 0x2f, 0xe0, 0x23, 0xef, 0xec, 0xdb, 0x4a, 0x93, 0x48, 0x4e, 0x45,
	0x12, 0x48, 0x95, 0xf4, 0x12, 0x10, 0xd6, 0xda, 0x7d, 0x5e, 0x64, 0x4c, 0xdf, 0xf2, 0x09, 0xf3,
	0x65, 0x3d, 0xfa, 0xbd, 0xb3, 0x74, 0x34, 0x1c, 0xfe, 0xd9, 0xd9, 0x39, 0x2a, 0x91, 0xc3, 0x58,
	0x07, 0xe5, 0xb0, 0x18, 0x9d, 0xf6, 0x83, 0xd0, 0x45, 0xfe, 0xe5, 0x62, 0xce, 0x87, 0xb1, 0x3e,
	0xaf, 0x63, 0xce, 0x4f, 0xfb, 0xe7, 0x75, 0xcc, 0xbf, 0x9d, 0xe7, 0xe5, 0xc2, 0x60, 0x30, 0x8c,
	0xf5, 0x60, 0x50, 0x47, 0x0d, 0x06, 0xa7, 0xfd, 0xc1, 0xa0, 0x8e, 0x1b, 0xdf, 0xb3, 0x9b, 0xfd,
	0xe4, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x65, 0x97, 0x1c, 0xdc, 0x6e, 0x09, 0x00, 0x00,
}
