// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/customer_feed_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [CustomerFeedService.GetCustomerFeed][google.ads.googleads.v3.services.CustomerFeedService.GetCustomerFeed].
type GetCustomerFeedRequest struct {
	// Required. The resource name of the customer feed to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomerFeedRequest) Reset()         { *m = GetCustomerFeedRequest{} }
func (m *GetCustomerFeedRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomerFeedRequest) ProtoMessage()    {}
func (*GetCustomerFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{0}
}

func (m *GetCustomerFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomerFeedRequest.Unmarshal(m, b)
}
func (m *GetCustomerFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomerFeedRequest.Marshal(b, m, deterministic)
}
func (m *GetCustomerFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomerFeedRequest.Merge(m, src)
}
func (m *GetCustomerFeedRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomerFeedRequest.Size(m)
}
func (m *GetCustomerFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomerFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomerFeedRequest proto.InternalMessageInfo

func (m *GetCustomerFeedRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CustomerFeedService.MutateCustomerFeeds][google.ads.googleads.v3.services.CustomerFeedService.MutateCustomerFeeds].
type MutateCustomerFeedsRequest struct {
	// Required. The ID of the customer whose customer feeds are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual customer feeds.
	Operations []*CustomerFeedOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerFeedsRequest) Reset()         { *m = MutateCustomerFeedsRequest{} }
func (m *MutateCustomerFeedsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerFeedsRequest) ProtoMessage()    {}
func (*MutateCustomerFeedsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{1}
}

func (m *MutateCustomerFeedsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerFeedsRequest.Unmarshal(m, b)
}
func (m *MutateCustomerFeedsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerFeedsRequest.Marshal(b, m, deterministic)
}
func (m *MutateCustomerFeedsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerFeedsRequest.Merge(m, src)
}
func (m *MutateCustomerFeedsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerFeedsRequest.Size(m)
}
func (m *MutateCustomerFeedsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerFeedsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerFeedsRequest proto.InternalMessageInfo

func (m *MutateCustomerFeedsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomerFeedsRequest) GetOperations() []*CustomerFeedOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateCustomerFeedsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateCustomerFeedsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on a customer feed.
type CustomerFeedOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomerFeedOperation_Create
	//	*CustomerFeedOperation_Update
	//	*CustomerFeedOperation_Remove
	Operation            isCustomerFeedOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *CustomerFeedOperation) Reset()         { *m = CustomerFeedOperation{} }
func (m *CustomerFeedOperation) String() string { return proto.CompactTextString(m) }
func (*CustomerFeedOperation) ProtoMessage()    {}
func (*CustomerFeedOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{2}
}

func (m *CustomerFeedOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerFeedOperation.Unmarshal(m, b)
}
func (m *CustomerFeedOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerFeedOperation.Marshal(b, m, deterministic)
}
func (m *CustomerFeedOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerFeedOperation.Merge(m, src)
}
func (m *CustomerFeedOperation) XXX_Size() int {
	return xxx_messageInfo_CustomerFeedOperation.Size(m)
}
func (m *CustomerFeedOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerFeedOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerFeedOperation proto.InternalMessageInfo

func (m *CustomerFeedOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomerFeedOperation_Operation interface {
	isCustomerFeedOperation_Operation()
}

type CustomerFeedOperation_Create struct {
	Create *resources.CustomerFeed `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type CustomerFeedOperation_Update struct {
	Update *resources.CustomerFeed `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type CustomerFeedOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*CustomerFeedOperation_Create) isCustomerFeedOperation_Operation() {}

func (*CustomerFeedOperation_Update) isCustomerFeedOperation_Operation() {}

func (*CustomerFeedOperation_Remove) isCustomerFeedOperation_Operation() {}

func (m *CustomerFeedOperation) GetOperation() isCustomerFeedOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomerFeedOperation) GetCreate() *resources.CustomerFeed {
	if x, ok := m.GetOperation().(*CustomerFeedOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *CustomerFeedOperation) GetUpdate() *resources.CustomerFeed {
	if x, ok := m.GetOperation().(*CustomerFeedOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *CustomerFeedOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*CustomerFeedOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CustomerFeedOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CustomerFeedOperation_Create)(nil),
		(*CustomerFeedOperation_Update)(nil),
		(*CustomerFeedOperation_Remove)(nil),
	}
}

// Response message for a customer feed mutate.
type MutateCustomerFeedsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateCustomerFeedResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *MutateCustomerFeedsResponse) Reset()         { *m = MutateCustomerFeedsResponse{} }
func (m *MutateCustomerFeedsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerFeedsResponse) ProtoMessage()    {}
func (*MutateCustomerFeedsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{3}
}

func (m *MutateCustomerFeedsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerFeedsResponse.Unmarshal(m, b)
}
func (m *MutateCustomerFeedsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerFeedsResponse.Marshal(b, m, deterministic)
}
func (m *MutateCustomerFeedsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerFeedsResponse.Merge(m, src)
}
func (m *MutateCustomerFeedsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerFeedsResponse.Size(m)
}
func (m *MutateCustomerFeedsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerFeedsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerFeedsResponse proto.InternalMessageInfo

func (m *MutateCustomerFeedsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateCustomerFeedsResponse) GetResults() []*MutateCustomerFeedResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the customer feed mutate.
type MutateCustomerFeedResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerFeedResult) Reset()         { *m = MutateCustomerFeedResult{} }
func (m *MutateCustomerFeedResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerFeedResult) ProtoMessage()    {}
func (*MutateCustomerFeedResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{4}
}

func (m *MutateCustomerFeedResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerFeedResult.Unmarshal(m, b)
}
func (m *MutateCustomerFeedResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerFeedResult.Marshal(b, m, deterministic)
}
func (m *MutateCustomerFeedResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerFeedResult.Merge(m, src)
}
func (m *MutateCustomerFeedResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerFeedResult.Size(m)
}
func (m *MutateCustomerFeedResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerFeedResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerFeedResult proto.InternalMessageInfo

func (m *MutateCustomerFeedResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomerFeedRequest)(nil), "google.ads.googleads.v3.services.GetCustomerFeedRequest")
	proto.RegisterType((*MutateCustomerFeedsRequest)(nil), "google.ads.googleads.v3.services.MutateCustomerFeedsRequest")
	proto.RegisterType((*CustomerFeedOperation)(nil), "google.ads.googleads.v3.services.CustomerFeedOperation")
	proto.RegisterType((*MutateCustomerFeedsResponse)(nil), "google.ads.googleads.v3.services.MutateCustomerFeedsResponse")
	proto.RegisterType((*MutateCustomerFeedResult)(nil), "google.ads.googleads.v3.services.MutateCustomerFeedResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/customer_feed_service.proto", fileDescriptor_900ccf1cb9cd0de8)
}

var fileDescriptor_900ccf1cb9cd0de8 = []byte{
	// 758 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x4f, 0x6b, 0xdb, 0x48,
	0x14, 0x5f, 0xc9, 0x4b, 0x76, 0x33, 0x4e, 0x36, 0x30, 0x21, 0x59, 0xe1, 0x2c, 0xac, 0xd1, 0x06,
	0xd6, 0x98, 0x45, 0x62, 0x6d, 0x96, 0x2c, 0x4a, 0x42, 0x91, 0x4b, 0xed, 0xe4, 0x90, 0x26, 0x28,
	0xc5, 0x87, 0x62, 0x30, 0x13, 0x69, 0xec, 0x8a, 0x48, 0x1a, 0x75, 0x66, 0x64, 0x08, 0x21, 0x97,
	0x7e, 0x83, 0xd2, 0x6f, 0xd0, 0x63, 0xbf, 0x42, 0xcf, 0xbd, 0xe4, 0xda, 0x5b, 0x4e, 0x3d, 0x14,
	0x0a, 0x39, 0xf4, 0x2b, 0xb4, 0x48, 0xa3, 0xb1, 0xe5, 0xc4, 0xc6, 0x34, 0xb7, 0xa7, 0x79, 0xbf,
	0xf7, 0x7b, 0xff, 0x9f, 0xc0, 0xde, 0x90, 0x90, 0x61, 0x80, 0x4d, 0xe4, 0x31, 0x53, 0x88, 0xa9,
	0x34, 0x6a, 0x9a, 0x0c, 0xd3, 0x91, 0xef, 0x62, 0x66, 0xba, 0x09, 0xe3, 0x24, 0xc4, 0xb4, 0x3f,
	0xc0, 0xd8, 0xeb, 0xe7, 0xcf, 0x46, 0x4c, 0x09, 0x27, 0xb0, 0x2a, 0x4c, 0x0c, 0xe4, 0x31, 0x63,
	0x6c, 0x6d, 0x8c, 0x9a, 0x86, 0xb4, 0xae, 0xfc, 0x37, 0x8f, 0x9f, 0x62, 0x46, 0x12, 0x7a, 0xcf,
	0x81, 0x20, 0xae, 0xfc, 0x21, 0xcd, 0x62, 0xdf, 0x44, 0x51, 0x44, 0x38, 0xe2, 0x3e, 0x89, 0x58,
	0xae, 0xfd, 0xbd, 0xa0, 0x75, 0x03, 0x1f, 0x47, 0x3c, 0x57, 0xfc, 0x59, 0x50, 0x0c, 0x7c, 0x1c,
	0x78, 0xfd, 0x33, 0xfc, 0x02, 0x8d, 0x7c, 0x42, 0x73, 0x40, 0x1e, 0xb0, 0x99, 0x7d, 0x9d, 0x25,
	0x83, 0x1c, 0x15, 0x22, 0x76, 0x7e, 0x87, 0x9b, 0xc6, 0xae, 0xc9, 0x38, 0xe2, 0x49, 0xee, 0x54,
	0x6f, 0x81, 0xcd, 0x0e, 0xe6, 0x8f, 0xf3, 0x60, 0xdb, 0x18, 0x7b, 0x0e, 0x7e, 0x99, 0x60, 0xc6,
	0x61, 0x0d, 0xac, 0xca, 0x6c, 0xfa, 0x11, 0x0a, 0xb1, 0xa6, 0x54, 0x95, 0xda, 0x72, 0xab, 0xf4,
	0xc9, 0x56, 0x9d, 0x15, 0xa9, 0x79, 0x8a, 0x42, 0xac, 0x7f, 0x55, 0x40, 0xe5, 0x28, 0xe1, 0x88,
	0xe3, 0x22, 0x0f, 0x93, 0x44, 0xdb, 0xa0, 0x3c, 0x2e, 0x86, 0xef, 0x15, 0x69, 0x80, 0x7c, 0x3f,
	0xf4, 0x60, 0x0f, 0x00, 0x12, 0x63, 0x2a, 0x2a, 0xa2, 0xa9, 0xd5, 0x52, 0xad, 0xdc, 0xd8, 0x31,
	0x16, 0x75, 0xc2, 0x28, 0x7a, 0x3c, 0x96, 0xf6, 0x39, 0xfb, 0x84, 0x0f, 0xfe, 0x0d, 0xd6, 0x62,
	0x44, 0xb9, 0x8f, 0x82, 0xfe, 0x00, 0xf9, 0x41, 0x42, 0xb1, 0x56, 0xaa, 0x2a, 0xb5, 0x5f, 0x9d,
	0xdf, 0xf2, 0xe7, 0xb6, 0x78, 0x85, 0x7f, 0x81, 0xd5, 0x11, 0x0a, 0x7c, 0x0f, 0x71, 0xdc, 0x27,
	0x51, 0x70, 0xa1, 0xfd, 0x9c, 0xc1, 0x56, 0xe4, 0xe3, 0x71, 0x14, 0x5c, 0xe8, 0xaf, 0x55, 0xb0,
	0x31, 0xd3, 0x31, 0xdc, 0x05, 0xe5, 0x24, 0xce, 0x8c, 0xd3, 0xe2, 0x67, 0xc6, 0xe5, 0x46, 0x45,
	0xa6, 0x21, 0xfb, 0x63, 0xb4, 0xd3, 0xfe, 0x1c, 0x21, 0x76, 0xee, 0x00, 0x01, 0x4f, 0x65, 0x78,
	0x08, 0x96, 0x5c, 0x8a, 0x11, 0x17, 0xa5, 0x2e, 0x37, 0xcc, 0xb9, 0xe9, 0x8f, 0xc7, 0x6c, 0x2a,
	0xff, 0x83, 0x9f, 0x9c, 0x9c, 0x20, 0xa5, 0x12, 0xc4, 0x9a, 0xfa, 0x60, 0x2a, 0x41, 0x00, 0x35,
	0xb0, 0x44, 0x71, 0x48, 0x46, 0xa2, 0x62, 0xcb, 0xa9, 0x46, 0x7c, 0xb7, 0xca, 0x60, 0x79, 0x5c,
	0x62, 0xfd, 0xbd, 0x02, 0xb6, 0x66, 0x0e, 0x01, 0x8b, 0x49, 0xc4, 0x30, 0x6c, 0x83, 0x8d, 0x3b,
	0x1d, 0xe8, 0x63, 0x4a, 0x09, 0xcd, 0x58, 0xcb, 0x0d, 0x28, 0x03, 0xa4, 0xb1, 0x6b, 0x9c, 0x66,
	0x13, 0xea, 0xac, 0x4f, 0xf7, 0xe6, 0x49, 0x0a, 0x87, 0xcf, 0xc0, 0x2f, 0x14, 0xb3, 0x24, 0xe0,
	0x72, 0x48, 0xac, 0xc5, 0x43, 0x72, 0x3f, 0x2e, 0x27, 0xa3, 0x70, 0x24, 0x95, 0xfe, 0x08, 0x68,
	0xf3, 0x40, 0xe9, 0x48, 0xcc, 0x58, 0x84, 0xe9, 0x1d, 0x68, 0x7c, 0x29, 0x81, 0xf5, 0xa2, 0xed,
	0xa9, 0xf0, 0x0d, 0x3f, 0x28, 0x60, 0xed, 0xce, 0x82, 0xc1, 0xff, 0x17, 0x47, 0x3c, 0x7b, 0x27,
	0x2b, 0x3f, 0xda, 0x46, 0xbd, 0x73, 0x63, 0x4f, 0x07, 0xff, 0xea, 0xe3, 0xe7, 0x37, 0xea, 0xbf,
	0xd0, 0x4c, 0x8f, 0xd5, 0xe5, 0x94, 0x66, 0x5f, 0x2e, 0x23, 0x33, 0xeb, 0xe3, 0xeb, 0x95, 0xf5,
	0xd0, 0xac, 0x5f, 0xc1, 0x5b, 0x05, 0xac, 0xcf, 0x68, 0x2f, 0xdc, 0x7b, 0x48, 0xf5, 0xe5, 0x69,
	0xa8, 0xec, 0x3f, 0xd0, 0x5a, 0xcc, 0x94, 0xde, 0xbd, 0xb1, 0x37, 0x0b, 0xa7, 0xe5, 0x9f, 0xc9,
	0xc2, 0x67, 0x69, 0xee, 0xe8, 0x8d, 0x34, 0xcd, 0x49, 0x5e, 0x97, 0x05, 0xf0, 0x7e, 0xfd, 0x6a,
	0x3a, 0x4b, 0x2b, 0xcc, 0x3c, 0x59, 0x4a, 0xbd, 0xb2, 0x75, 0x6d, 0x6b, 0x93, 0x68, 0x72, 0x29,
	0xf6, 0x99, 0xe1, 0x92, 0xb0, 0xf5, 0x4d, 0x01, 0xdb, 0x2e, 0x09, 0x17, 0x46, 0xde, 0xd2, 0x66,
	0xcc, 0xc3, 0x49, 0x7a, 0x01, 0x4e, 0x94, 0xe7, 0x07, 0xb9, 0xf5, 0x90, 0x04, 0x28, 0x1a, 0x1a,
	0x84, 0x0e, 0xcd, 0x21, 0x8e, 0xb2, 0xfb, 0x60, 0x4e, 0xfc, 0xcd, 0xff, 0x7f, 0xed, 0x4a, 0xe1,
	0xad, 0x5a, 0xea, 0xd8, 0xf6, 0x3b, 0xb5, 0xda, 0x11, 0x84, 0xb6, 0xc7, 0x0c, 0x21, 0xa6, 0x52,
	0xb7, 0x69, 0xe4, 0x8e, 0xd9, 0xb5, 0x84, 0xf4, 0x6c, 0x8f, 0xf5, 0xc6, 0x90, 0x5e, 0xb7, 0xd9,
	0x93, 0x90, 0x5b, 0x75, 0x5b, 0xbc, 0x5b, 0x96, 0xed, 0x31, 0xcb, 0x1a, 0x83, 0x2c, 0xab, 0xdb,
	0xb4, 0x2c, 0x09, 0x3b, 0x5b, 0xca, 0xe2, 0x6c, 0x7e, 0x0f, 0x00, 0x00, 0xff, 0xff, 0x4a, 0xcc,
	0xb1, 0x8a, 0x66, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CustomerFeedServiceClient is the client API for CustomerFeedService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomerFeedServiceClient interface {
	// Returns the requested customer feed in full detail.
	GetCustomerFeed(ctx context.Context, in *GetCustomerFeedRequest, opts ...grpc.CallOption) (*resources.CustomerFeed, error)
	// Creates, updates, or removes customer feeds. Operation statuses are
	// returned.
	MutateCustomerFeeds(ctx context.Context, in *MutateCustomerFeedsRequest, opts ...grpc.CallOption) (*MutateCustomerFeedsResponse, error)
}

type customerFeedServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomerFeedServiceClient(cc grpc.ClientConnInterface) CustomerFeedServiceClient {
	return &customerFeedServiceClient{cc}
}

func (c *customerFeedServiceClient) GetCustomerFeed(ctx context.Context, in *GetCustomerFeedRequest, opts ...grpc.CallOption) (*resources.CustomerFeed, error) {
	out := new(resources.CustomerFeed)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomerFeedService/GetCustomerFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerFeedServiceClient) MutateCustomerFeeds(ctx context.Context, in *MutateCustomerFeedsRequest, opts ...grpc.CallOption) (*MutateCustomerFeedsResponse, error) {
	out := new(MutateCustomerFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomerFeedService/MutateCustomerFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomerFeedServiceServer is the server API for CustomerFeedService service.
type CustomerFeedServiceServer interface {
	// Returns the requested customer feed in full detail.
	GetCustomerFeed(context.Context, *GetCustomerFeedRequest) (*resources.CustomerFeed, error)
	// Creates, updates, or removes customer feeds. Operation statuses are
	// returned.
	MutateCustomerFeeds(context.Context, *MutateCustomerFeedsRequest) (*MutateCustomerFeedsResponse, error)
}

// UnimplementedCustomerFeedServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCustomerFeedServiceServer struct {
}

func (*UnimplementedCustomerFeedServiceServer) GetCustomerFeed(ctx context.Context, req *GetCustomerFeedRequest) (*resources.CustomerFeed, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCustomerFeed not implemented")
}
func (*UnimplementedCustomerFeedServiceServer) MutateCustomerFeeds(ctx context.Context, req *MutateCustomerFeedsRequest) (*MutateCustomerFeedsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateCustomerFeeds not implemented")
}

func RegisterCustomerFeedServiceServer(s *grpc.Server, srv CustomerFeedServiceServer) {
	s.RegisterService(&_CustomerFeedService_serviceDesc, srv)
}

func _CustomerFeedService_GetCustomerFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerFeedServiceServer).GetCustomerFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomerFeedService/GetCustomerFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerFeedServiceServer).GetCustomerFeed(ctx, req.(*GetCustomerFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerFeedService_MutateCustomerFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomerFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerFeedServiceServer).MutateCustomerFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomerFeedService/MutateCustomerFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerFeedServiceServer).MutateCustomerFeeds(ctx, req.(*MutateCustomerFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomerFeedService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.CustomerFeedService",
	HandlerType: (*CustomerFeedServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomerFeed",
			Handler:    _CustomerFeedService_GetCustomerFeed_Handler,
		},
		{
			MethodName: "MutateCustomerFeeds",
			Handler:    _CustomerFeedService_MutateCustomerFeeds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/customer_feed_service.proto",
}
