---
title: Scheherazade New - Honorific ligatures
fontversion: 3.300
---

Unicode has a number of honorific ligatures. A significant number of them were added to Unicode 14.0. The below chart should aid in understanding in what context they should be used. As new characters, applications may have problems with rendering them in right-to-left text. In some cases, you can correct reading order problems by inserting a Right-to-Left mark (U+200F) after the honorific ligature.

To view the simplified alternate glyphs and for instructions in accessing the simplified alternate glyphs, see the [Features](features.md) document.


Unicode Name (ARABIC LIGATURE...) | USV | Glyph | Meaning
------------- | ---- | ---- | ------------- 
RAHIMAHU ALLAAH | FD40 | <span class='scheherazadenew-R normal'>﵀</span>  | May God have mercy upon him.</br>(Used for companions of the prophet or other widely recognized scholars. Can be for any believer who has passed away.)
RADI ALLAAHU ANH | FD41 | <span class='scheherazadenew-R normal'>﵁ </span>  | May God be pleased with him.</br>(Used for companions of the prophet.)
RADI ALLAAHU ANHAA | FD42 | <span class='scheherazadenew-R normal'>﵂ </span>  | May God be pleased with her.</br>(Used for companions of the prophet, and in some regions for others such as Mary or Jesus’ apostles.)
RADI ALLAAHU ANHUM | FD43 | <span class='scheherazadenew-R normal'>﵃ </span> | May God be pleased with them (masculine plural, but can be used for a mixed group of men and women).</br>(Used for companions of the prophet.)
RADI ALLAAHU ANHUMAA | FD44 | <span class='scheherazadenew-R normal'>﵄ </span> | May God be pleased with them (both).</br>(Used for companions of the prophet.)
RADI ALLAAHU ANHUNNA | FD45 | <span class='scheherazadenew-R normal'>﵅ </span>  | May God be pleased with them (feminine).</br>(Used for companions of the prophet.)
SALLALLAAHU ALAYHI WA-AALIH | FD46 | <span class='scheherazadenew-R normal'>﵆ </span>  | Blessings of God be upon him and the people of his household.</br>(Used particularly in Shia Islam for leaders who come from the bloodline of the prophet.)
ALAYHI AS-SALAAM | FD47 | <span class='scheherazadenew-R normal'>﵇ </span>  | Peace be upon him.</br>(The normal honorific used after a prophet's or an Archangel's name.)
ALAYHIM AS-SALAAM | FD48 | <span class='scheherazadenew-R normal'>﵈ </span>  | Peace be upon them.</br>(Used for two or more prophets.)
ALAYHIMAA AS-SALAAM | FD49 | <span class='scheherazadenew-R normal'>﵉ </span>  | Peace be upon them (both).</br>(Used for prophets and angels.)
ALAYHI AS-SALAATU WAS-SALAAM | FD4A | <span class='scheherazadenew-R normal'>﵊ </span> | Blessings and Peace be upon him.</br>(A lesser used honorific used after a prophet's or an Archangel's name.)
QUDDISA SIRRAH | FD4B | <span class='scheherazadenew-R normal'>﵋ </span> | May his secret be sanctified.</br>(Used for Sufi saints, and refers to their shrines where people come to worship.)
SALLALLAHU ALAYHI WA-AALIHEE WA-SALLAM | FD4C | <span class='scheherazadenew-R normal'>﵌ </span> | The blessings of God and peace be upon him and the people of his household.</br>(Used by all Muslims, but particularly in Shia Islam for the prophet Muhammad.)
ALAYHAA AS-SALAAM | FD4D | <span class='scheherazadenew-R normal'>﵍ </span>  | Peace be upon her.</br>(Used after the name of a woman who was the mother of a prophet.)
TABAARAKA WA-TAAALAA | FD4E | <span class='scheherazadenew-R normal'>﵎ </span> | May he be blessed and exalted (Blessed and Lofty).</br>(One of the honorifics used only for God himself.)
RAHIMAHUM ALLAAH | FD4F | <span class='scheherazadenew-R normal'>﵏ </span>  | God have mercy upon them (masculine).</br>(Used for widely recognized scholars. Also used for ordinary believers.)
SALAAMUHU ALAYNAA | FDCF | <span class='scheherazadenew-R normal'>﷏ </span> | His peace be upon us.</br>(Used by some followers of Jesus to give special honor to him.)
SALLALLAHOU ALAYHEWASALLAM  | FDFA | <span class='scheherazadenew-R normal'>ﷺ</span> | The blessings and peace of God be upon him. </br>(Used after the name of a major prophet, especially the prophet of Islam.)
JALLAJALALOUHOU | FDFB | <span class='scheherazadenew-R normal'>ﷻ</span> | May His glory be glorified.</br>(Used after the name of God.)
BISMILLAH AR-RAHMAN AR-RAHEEM | FDFD | <span
  class='scheherazadenew-R normal'>﷽ </span> | In the name of God, the most merciful, the most compassionate.</br>(Used as the opening of each action in order to receive blessing from God.)
SUBHAANAHU WA TAAALAA | FDFE | <span class='scheherazadenew-R normal'>﷾ </span> | May He be praised and exalted (Glorified and Lofty).</br>(The most common honorific for God.)
AZZA WA JALL | FDFF | <span class='scheherazadenew-R normal'>﷿ </span> | The Glorified/Exalted/Mighty and Sublime (Prestigious and Majestic).</br>(The second most common honorific for God.)



<!-- PRODUCT SITE ONLY
[font id='scheherazadenew' face='ScheherazadeNew-Regular' bold='ScheherazadeNew-Bold' size='200%' rtl=1]
[font id='scheherazadenewL' face='ScheherazadeNew-Regular' bold='ScheherazadeNew-Bold' size='200%']
-->
