//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewActionGroupsClient creates a new instance of ActionGroupsClient.
func (c *ClientFactory) NewActionGroupsClient() *ActionGroupsClient {
	subClient, _ := NewActionGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewActivityLogAlertsClient creates a new instance of ActivityLogAlertsClient.
func (c *ClientFactory) NewActivityLogAlertsClient() *ActivityLogAlertsClient {
	subClient, _ := NewActivityLogAlertsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewActivityLogsClient creates a new instance of ActivityLogsClient.
func (c *ClientFactory) NewActivityLogsClient() *ActivityLogsClient {
	subClient, _ := NewActivityLogsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAlertRuleIncidentsClient creates a new instance of AlertRuleIncidentsClient.
func (c *ClientFactory) NewAlertRuleIncidentsClient() *AlertRuleIncidentsClient {
	subClient, _ := NewAlertRuleIncidentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAlertRulesClient creates a new instance of AlertRulesClient.
func (c *ClientFactory) NewAlertRulesClient() *AlertRulesClient {
	subClient, _ := NewAlertRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAutoscaleSettingsClient creates a new instance of AutoscaleSettingsClient.
func (c *ClientFactory) NewAutoscaleSettingsClient() *AutoscaleSettingsClient {
	subClient, _ := NewAutoscaleSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAzureMonitorWorkspacesClient creates a new instance of AzureMonitorWorkspacesClient.
func (c *ClientFactory) NewAzureMonitorWorkspacesClient() *AzureMonitorWorkspacesClient {
	subClient, _ := NewAzureMonitorWorkspacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBaselinesClient creates a new instance of BaselinesClient.
func (c *ClientFactory) NewBaselinesClient() *BaselinesClient {
	subClient, _ := NewBaselinesClient(c.credential, c.options)
	return subClient
}

// NewDataCollectionEndpointsClient creates a new instance of DataCollectionEndpointsClient.
func (c *ClientFactory) NewDataCollectionEndpointsClient() *DataCollectionEndpointsClient {
	subClient, _ := NewDataCollectionEndpointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataCollectionRuleAssociationsClient creates a new instance of DataCollectionRuleAssociationsClient.
func (c *ClientFactory) NewDataCollectionRuleAssociationsClient() *DataCollectionRuleAssociationsClient {
	subClient, _ := NewDataCollectionRuleAssociationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataCollectionRulesClient creates a new instance of DataCollectionRulesClient.
func (c *ClientFactory) NewDataCollectionRulesClient() *DataCollectionRulesClient {
	subClient, _ := NewDataCollectionRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDiagnosticSettingsCategoryClient creates a new instance of DiagnosticSettingsCategoryClient.
func (c *ClientFactory) NewDiagnosticSettingsCategoryClient() *DiagnosticSettingsCategoryClient {
	subClient, _ := NewDiagnosticSettingsCategoryClient(c.credential, c.options)
	return subClient
}

// NewDiagnosticSettingsClient creates a new instance of DiagnosticSettingsClient.
func (c *ClientFactory) NewDiagnosticSettingsClient() *DiagnosticSettingsClient {
	subClient, _ := NewDiagnosticSettingsClient(c.credential, c.options)
	return subClient
}

// NewEventCategoriesClient creates a new instance of EventCategoriesClient.
func (c *ClientFactory) NewEventCategoriesClient() *EventCategoriesClient {
	subClient, _ := NewEventCategoriesClient(c.credential, c.options)
	return subClient
}

// NewLogProfilesClient creates a new instance of LogProfilesClient.
func (c *ClientFactory) NewLogProfilesClient() *LogProfilesClient {
	subClient, _ := NewLogProfilesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMetricAlertsClient creates a new instance of MetricAlertsClient.
func (c *ClientFactory) NewMetricAlertsClient() *MetricAlertsClient {
	subClient, _ := NewMetricAlertsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMetricAlertsStatusClient creates a new instance of MetricAlertsStatusClient.
func (c *ClientFactory) NewMetricAlertsStatusClient() *MetricAlertsStatusClient {
	subClient, _ := NewMetricAlertsStatusClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMetricDefinitionsClient creates a new instance of MetricDefinitionsClient.
func (c *ClientFactory) NewMetricDefinitionsClient() *MetricDefinitionsClient {
	subClient, _ := NewMetricDefinitionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMetricNamespacesClient creates a new instance of MetricNamespacesClient.
func (c *ClientFactory) NewMetricNamespacesClient() *MetricNamespacesClient {
	subClient, _ := NewMetricNamespacesClient(c.credential, c.options)
	return subClient
}

// NewMetricsClient creates a new instance of MetricsClient.
func (c *ClientFactory) NewMetricsClient() *MetricsClient {
	subClient, _ := NewMetricsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewOperationsForMonitorClient creates a new instance of OperationsForMonitorClient.
func (c *ClientFactory) NewOperationsForMonitorClient() *OperationsForMonitorClient {
	subClient, _ := NewOperationsForMonitorClient(c.credential, c.options)
	return subClient
}

// NewPredictiveMetricClient creates a new instance of PredictiveMetricClient.
func (c *ClientFactory) NewPredictiveMetricClient() *PredictiveMetricClient {
	subClient, _ := NewPredictiveMetricClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkScopeOperationStatusClient creates a new instance of PrivateLinkScopeOperationStatusClient.
func (c *ClientFactory) NewPrivateLinkScopeOperationStatusClient() *PrivateLinkScopeOperationStatusClient {
	subClient, _ := NewPrivateLinkScopeOperationStatusClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkScopedResourcesClient creates a new instance of PrivateLinkScopedResourcesClient.
func (c *ClientFactory) NewPrivateLinkScopedResourcesClient() *PrivateLinkScopedResourcesClient {
	subClient, _ := NewPrivateLinkScopedResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkScopesClient creates a new instance of PrivateLinkScopesClient.
func (c *ClientFactory) NewPrivateLinkScopesClient() *PrivateLinkScopesClient {
	subClient, _ := NewPrivateLinkScopesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewScheduledQueryRulesClient creates a new instance of ScheduledQueryRulesClient.
func (c *ClientFactory) NewScheduledQueryRulesClient() *ScheduledQueryRulesClient {
	subClient, _ := NewScheduledQueryRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTenantActionGroupsClient creates a new instance of TenantActionGroupsClient.
func (c *ClientFactory) NewTenantActionGroupsClient() *TenantActionGroupsClient {
	subClient, _ := NewTenantActionGroupsClient(c.credential, c.options)
	return subClient
}

// NewTenantActivityLogsClient creates a new instance of TenantActivityLogsClient.
func (c *ClientFactory) NewTenantActivityLogsClient() *TenantActivityLogsClient {
	subClient, _ := NewTenantActivityLogsClient(c.credential, c.options)
	return subClient
}

// NewVMInsightsClient creates a new instance of VMInsightsClient.
func (c *ClientFactory) NewVMInsightsClient() *VMInsightsClient {
	subClient, _ := NewVMInsightsClient(c.credential, c.options)
	return subClient
}
