//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2016-03-01/examples/deleteLogProfile.json
func ExampleLogProfilesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewLogProfilesClient().Delete(ctx, "Rac46PostSwapRG", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2016-03-01/examples/getLogProfile.json
func ExampleLogProfilesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLogProfilesClient().Get(ctx, "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LogProfileResource = armmonitor.LogProfileResource{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr(""),
	// 	ID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/providers/microsoft.insights/logprofiles/default"),
	// 	Location: to.Ptr(""),
	// 	Properties: &armmonitor.LogProfileProperties{
	// 		Categories: []*string{
	// 			to.Ptr("Delete"),
	// 			to.Ptr("Write"),
	// 			to.Ptr("Action")},
	// 			Locations: []*string{
	// 				to.Ptr("global")},
	// 				RetentionPolicy: &armmonitor.RetentionPolicy{
	// 					Days: to.Ptr[int32](3),
	// 					Enabled: to.Ptr(true),
	// 				},
	// 				ServiceBusRuleID: to.Ptr(""),
	// 				StorageAccountID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2016-03-01/examples/createOrUpdateLogProfile.json
func ExampleLogProfilesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLogProfilesClient().CreateOrUpdate(ctx, "Rac46PostSwapRG", armmonitor.LogProfileResource{
		Location: to.Ptr(""),
		Tags:     map[string]*string{},
		Properties: &armmonitor.LogProfileProperties{
			Categories: []*string{
				to.Ptr("Write"),
				to.Ptr("Delete"),
				to.Ptr("Action")},
			Locations: []*string{
				to.Ptr("global")},
			RetentionPolicy: &armmonitor.RetentionPolicy{
				Days:    to.Ptr[int32](3),
				Enabled: to.Ptr(true),
			},
			ServiceBusRuleID: to.Ptr(""),
			StorageAccountID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LogProfileResource = armmonitor.LogProfileResource{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr(""),
	// 	ID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/providers/microsoft.insights/logprofiles/default"),
	// 	Location: to.Ptr(""),
	// 	Properties: &armmonitor.LogProfileProperties{
	// 		Categories: []*string{
	// 			to.Ptr("Delete"),
	// 			to.Ptr("Write"),
	// 			to.Ptr("Action")},
	// 			Locations: []*string{
	// 				to.Ptr("global")},
	// 				RetentionPolicy: &armmonitor.RetentionPolicy{
	// 					Days: to.Ptr[int32](3),
	// 					Enabled: to.Ptr(true),
	// 				},
	// 				ServiceBusRuleID: to.Ptr(""),
	// 				StorageAccountID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2016-03-01/examples/patchLogProfile.json
func ExampleLogProfilesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLogProfilesClient().Update(ctx, "Rac46PostSwapRG", armmonitor.LogProfileResourcePatch{
		Properties: &armmonitor.LogProfileProperties{
			Categories: []*string{
				to.Ptr("Write"),
				to.Ptr("Delete"),
				to.Ptr("Action")},
			Locations: []*string{
				to.Ptr("global")},
			RetentionPolicy: &armmonitor.RetentionPolicy{
				Days:    to.Ptr[int32](3),
				Enabled: to.Ptr(true),
			},
			ServiceBusRuleID: to.Ptr(""),
			StorageAccountID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162"),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LogProfileResource = armmonitor.LogProfileResource{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr(""),
	// 	ID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/providers/microsoft.insights/logprofiles/default"),
	// 	Location: to.Ptr(""),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Properties: &armmonitor.LogProfileProperties{
	// 		Categories: []*string{
	// 			to.Ptr("Delete"),
	// 			to.Ptr("Write"),
	// 			to.Ptr("Action")},
	// 			Locations: []*string{
	// 				to.Ptr("global")},
	// 				RetentionPolicy: &armmonitor.RetentionPolicy{
	// 					Days: to.Ptr[int32](3),
	// 					Enabled: to.Ptr(true),
	// 				},
	// 				ServiceBusRuleID: to.Ptr(""),
	// 				StorageAccountID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2016-03-01/examples/listLogProfile.json
func ExampleLogProfilesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLogProfilesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LogProfileCollection = armmonitor.LogProfileCollection{
		// 	Value: []*armmonitor.LogProfileResource{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr(""),
		// 			ID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/providers/microsoft.insights/logprofiles/default"),
		// 			Location: to.Ptr(""),
		// 			Properties: &armmonitor.LogProfileProperties{
		// 				Categories: []*string{
		// 					to.Ptr("Delete"),
		// 					to.Ptr("Write"),
		// 					to.Ptr("Action")},
		// 					Locations: []*string{
		// 						to.Ptr("global")},
		// 						RetentionPolicy: &armmonitor.RetentionPolicy{
		// 							Days: to.Ptr[int32](3),
		// 							Enabled: to.Ptr(true),
		// 						},
		// 						ServiceBusRuleID: to.Ptr(""),
		// 						StorageAccountID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162"),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("default2"),
		// 					Type: to.Ptr(""),
		// 					ID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/providers/microsoft.insights/logprofiles/default2"),
		// 					Location: to.Ptr(""),
		// 					Properties: &armmonitor.LogProfileProperties{
		// 						Categories: []*string{
		// 							to.Ptr("Delete"),
		// 							to.Ptr("Write"),
		// 							to.Ptr("Action")},
		// 							Locations: []*string{
		// 								to.Ptr("global")},
		// 								RetentionPolicy: &armmonitor.RetentionPolicy{
		// 									Days: to.Ptr[int32](15),
		// 									Enabled: to.Ptr(true),
		// 								},
		// 								ServiceBusRuleID: to.Ptr(""),
		// 								StorageAccountID: to.Ptr("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8165"),
		// 							},
		// 					}},
		// 				}
	}
}
