// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/monitoring/dashboard/v1/metrics.proto

package dashboardpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines the possible types of spark chart supported by the `Scorecard`.
type SparkChartType int32

const (
	// Not allowed in well-formed requests.
	SparkChartType_SPARK_CHART_TYPE_UNSPECIFIED SparkChartType = 0
	// The sparkline will be rendered as a small line chart.
	SparkChartType_SPARK_LINE SparkChartType = 1
	// The sparkbar will be rendered as a small bar chart.
	SparkChartType_SPARK_BAR SparkChartType = 2
)

// Enum value maps for SparkChartType.
var (
	SparkChartType_name = map[int32]string{
		0: "SPARK_CHART_TYPE_UNSPECIFIED",
		1: "SPARK_LINE",
		2: "SPARK_BAR",
	}
	SparkChartType_value = map[string]int32{
		"SPARK_CHART_TYPE_UNSPECIFIED": 0,
		"SPARK_LINE":                   1,
		"SPARK_BAR":                    2,
	}
)

func (x SparkChartType) Enum() *SparkChartType {
	p := new(SparkChartType)
	*p = x
	return p
}

func (x SparkChartType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SparkChartType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_metrics_proto_enumTypes[0].Descriptor()
}

func (SparkChartType) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_metrics_proto_enumTypes[0]
}

func (x SparkChartType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SparkChartType.Descriptor instead.
func (SparkChartType) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP(), []int{0}
}

// The color suggests an interpretation to the viewer when actual values cross
// the threshold. Comments on each color provide UX guidance on how users can
// be expected to interpret a given state color.
type Threshold_Color int32

const (
	// Color is unspecified. Not allowed in well-formed requests.
	Threshold_COLOR_UNSPECIFIED Threshold_Color = 0
	// Crossing the threshold is "concerning" behavior.
	Threshold_YELLOW Threshold_Color = 4
	// Crossing the threshold is "emergency" behavior.
	Threshold_RED Threshold_Color = 6
)

// Enum value maps for Threshold_Color.
var (
	Threshold_Color_name = map[int32]string{
		0: "COLOR_UNSPECIFIED",
		4: "YELLOW",
		6: "RED",
	}
	Threshold_Color_value = map[string]int32{
		"COLOR_UNSPECIFIED": 0,
		"YELLOW":            4,
		"RED":               6,
	}
)

func (x Threshold_Color) Enum() *Threshold_Color {
	p := new(Threshold_Color)
	*p = x
	return p
}

func (x Threshold_Color) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Threshold_Color) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_metrics_proto_enumTypes[1].Descriptor()
}

func (Threshold_Color) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_metrics_proto_enumTypes[1]
}

func (x Threshold_Color) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Threshold_Color.Descriptor instead.
func (Threshold_Color) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP(), []int{3, 0}
}

// Whether the threshold is considered crossed by an actual value above or
// below its threshold value.
type Threshold_Direction int32

const (
	// Not allowed in well-formed requests.
	Threshold_DIRECTION_UNSPECIFIED Threshold_Direction = 0
	// The threshold will be considered crossed if the actual value is above
	// the threshold value.
	Threshold_ABOVE Threshold_Direction = 1
	// The threshold will be considered crossed if the actual value is below
	// the threshold value.
	Threshold_BELOW Threshold_Direction = 2
)

// Enum value maps for Threshold_Direction.
var (
	Threshold_Direction_name = map[int32]string{
		0: "DIRECTION_UNSPECIFIED",
		1: "ABOVE",
		2: "BELOW",
	}
	Threshold_Direction_value = map[string]int32{
		"DIRECTION_UNSPECIFIED": 0,
		"ABOVE":                 1,
		"BELOW":                 2,
	}
)

func (x Threshold_Direction) Enum() *Threshold_Direction {
	p := new(Threshold_Direction)
	*p = x
	return p
}

func (x Threshold_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Threshold_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_metrics_proto_enumTypes[2].Descriptor()
}

func (Threshold_Direction) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_metrics_proto_enumTypes[2]
}

func (x Threshold_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Threshold_Direction.Descriptor instead.
func (Threshold_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP(), []int{3, 1}
}

// An axis identifier.
type Threshold_TargetAxis int32

const (
	// The target axis was not specified. Defaults to Y1.
	Threshold_TARGET_AXIS_UNSPECIFIED Threshold_TargetAxis = 0
	// The y_axis (the right axis of chart).
	Threshold_Y1 Threshold_TargetAxis = 1
	// The y2_axis (the left axis of chart).
	Threshold_Y2 Threshold_TargetAxis = 2
)

// Enum value maps for Threshold_TargetAxis.
var (
	Threshold_TargetAxis_name = map[int32]string{
		0: "TARGET_AXIS_UNSPECIFIED",
		1: "Y1",
		2: "Y2",
	}
	Threshold_TargetAxis_value = map[string]int32{
		"TARGET_AXIS_UNSPECIFIED": 0,
		"Y1":                      1,
		"Y2":                      2,
	}
)

func (x Threshold_TargetAxis) Enum() *Threshold_TargetAxis {
	p := new(Threshold_TargetAxis)
	*p = x
	return p
}

func (x Threshold_TargetAxis) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Threshold_TargetAxis) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_metrics_proto_enumTypes[3].Descriptor()
}

func (Threshold_TargetAxis) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_metrics_proto_enumTypes[3]
}

func (x Threshold_TargetAxis) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Threshold_TargetAxis.Descriptor instead.
func (Threshold_TargetAxis) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP(), []int{3, 2}
}

// TimeSeriesQuery collects the set of supported methods for querying time
// series data from the Stackdriver metrics API.
type TimeSeriesQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameters needed to obtain data for the chart.
	//
	// Types that are assignable to Source:
	//
	//	*TimeSeriesQuery_TimeSeriesFilter
	//	*TimeSeriesQuery_TimeSeriesFilterRatio
	//	*TimeSeriesQuery_TimeSeriesQueryLanguage
	//	*TimeSeriesQuery_PrometheusQuery
	Source isTimeSeriesQuery_Source `protobuf_oneof:"source"`
	// The unit of data contained in fetched time series. If non-empty, this
	// unit will override any unit that accompanies fetched data. The format is
	// the same as the
	// [`unit`](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors)
	// field in `MetricDescriptor`.
	UnitOverride string `protobuf:"bytes,5,opt,name=unit_override,json=unitOverride,proto3" json:"unit_override,omitempty"`
	// Optional. If set, Cloud Monitoring will treat the full query duration as
	// the alignment period so that there will be only 1 output value.
	//
	// *Note: This could override the configured alignment period except for
	// the cases where a series of data points are expected, like
	//   - XyChart
	//   - Scorecard's spark chart
	OutputFullDuration bool `protobuf:"varint,7,opt,name=output_full_duration,json=outputFullDuration,proto3" json:"output_full_duration,omitempty"`
}

func (x *TimeSeriesQuery) Reset() {
	*x = TimeSeriesQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeriesQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeriesQuery) ProtoMessage() {}

func (x *TimeSeriesQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeriesQuery.ProtoReflect.Descriptor instead.
func (*TimeSeriesQuery) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP(), []int{0}
}

func (m *TimeSeriesQuery) GetSource() isTimeSeriesQuery_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *TimeSeriesQuery) GetTimeSeriesFilter() *TimeSeriesFilter {
	if x, ok := x.GetSource().(*TimeSeriesQuery_TimeSeriesFilter); ok {
		return x.TimeSeriesFilter
	}
	return nil
}

func (x *TimeSeriesQuery) GetTimeSeriesFilterRatio() *TimeSeriesFilterRatio {
	if x, ok := x.GetSource().(*TimeSeriesQuery_TimeSeriesFilterRatio); ok {
		return x.TimeSeriesFilterRatio
	}
	return nil
}

func (x *TimeSeriesQuery) GetTimeSeriesQueryLanguage() string {
	if x, ok := x.GetSource().(*TimeSeriesQuery_TimeSeriesQueryLanguage); ok {
		return x.TimeSeriesQueryLanguage
	}
	return ""
}

func (x *TimeSeriesQuery) GetPrometheusQuery() string {
	if x, ok := x.GetSource().(*TimeSeriesQuery_PrometheusQuery); ok {
		return x.PrometheusQuery
	}
	return ""
}

func (x *TimeSeriesQuery) GetUnitOverride() string {
	if x != nil {
		return x.UnitOverride
	}
	return ""
}

func (x *TimeSeriesQuery) GetOutputFullDuration() bool {
	if x != nil {
		return x.OutputFullDuration
	}
	return false
}

type isTimeSeriesQuery_Source interface {
	isTimeSeriesQuery_Source()
}

type TimeSeriesQuery_TimeSeriesFilter struct {
	// Filter parameters to fetch time series.
	TimeSeriesFilter *TimeSeriesFilter `protobuf:"bytes,1,opt,name=time_series_filter,json=timeSeriesFilter,proto3,oneof"`
}

type TimeSeriesQuery_TimeSeriesFilterRatio struct {
	// Parameters to fetch a ratio between two time series filters.
	TimeSeriesFilterRatio *TimeSeriesFilterRatio `protobuf:"bytes,2,opt,name=time_series_filter_ratio,json=timeSeriesFilterRatio,proto3,oneof"`
}

type TimeSeriesQuery_TimeSeriesQueryLanguage struct {
	// A query used to fetch time series with MQL.
	TimeSeriesQueryLanguage string `protobuf:"bytes,3,opt,name=time_series_query_language,json=timeSeriesQueryLanguage,proto3,oneof"`
}

type TimeSeriesQuery_PrometheusQuery struct {
	// A query used to fetch time series with PromQL.
	PrometheusQuery string `protobuf:"bytes,6,opt,name=prometheus_query,json=prometheusQuery,proto3,oneof"`
}

func (*TimeSeriesQuery_TimeSeriesFilter) isTimeSeriesQuery_Source() {}

func (*TimeSeriesQuery_TimeSeriesFilterRatio) isTimeSeriesQuery_Source() {}

func (*TimeSeriesQuery_TimeSeriesQueryLanguage) isTimeSeriesQuery_Source() {}

func (*TimeSeriesQuery_PrometheusQuery) isTimeSeriesQuery_Source() {}

// A filter that defines a subset of time series data that is displayed in a
// widget. Time series data is fetched using the
// [`ListTimeSeries`](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
// method.
type TimeSeriesFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [monitoring
	// filter](https://cloud.google.com/monitoring/api/v3/filters) that identifies
	// the metric types, resources, and projects to query.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// By default, the raw time series data is returned.
	// Use this field to combine multiple time series for different views of the
	// data.
	Aggregation *Aggregation `protobuf:"bytes,2,opt,name=aggregation,proto3" json:"aggregation,omitempty"`
	// Apply a second aggregation after `aggregation` is applied.
	SecondaryAggregation *Aggregation `protobuf:"bytes,3,opt,name=secondary_aggregation,json=secondaryAggregation,proto3" json:"secondary_aggregation,omitempty"`
	// Selects an optional time series filter.
	//
	// Types that are assignable to OutputFilter:
	//
	//	*TimeSeriesFilter_PickTimeSeriesFilter
	//	*TimeSeriesFilter_StatisticalTimeSeriesFilter
	OutputFilter isTimeSeriesFilter_OutputFilter `protobuf_oneof:"output_filter"`
}

func (x *TimeSeriesFilter) Reset() {
	*x = TimeSeriesFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeriesFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeriesFilter) ProtoMessage() {}

func (x *TimeSeriesFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeriesFilter.ProtoReflect.Descriptor instead.
func (*TimeSeriesFilter) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP(), []int{1}
}

func (x *TimeSeriesFilter) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *TimeSeriesFilter) GetAggregation() *Aggregation {
	if x != nil {
		return x.Aggregation
	}
	return nil
}

func (x *TimeSeriesFilter) GetSecondaryAggregation() *Aggregation {
	if x != nil {
		return x.SecondaryAggregation
	}
	return nil
}

func (m *TimeSeriesFilter) GetOutputFilter() isTimeSeriesFilter_OutputFilter {
	if m != nil {
		return m.OutputFilter
	}
	return nil
}

func (x *TimeSeriesFilter) GetPickTimeSeriesFilter() *PickTimeSeriesFilter {
	if x, ok := x.GetOutputFilter().(*TimeSeriesFilter_PickTimeSeriesFilter); ok {
		return x.PickTimeSeriesFilter
	}
	return nil
}

// Deprecated: Marked as deprecated in google/monitoring/dashboard/v1/metrics.proto.
func (x *TimeSeriesFilter) GetStatisticalTimeSeriesFilter() *StatisticalTimeSeriesFilter {
	if x, ok := x.GetOutputFilter().(*TimeSeriesFilter_StatisticalTimeSeriesFilter); ok {
		return x.StatisticalTimeSeriesFilter
	}
	return nil
}

type isTimeSeriesFilter_OutputFilter interface {
	isTimeSeriesFilter_OutputFilter()
}

type TimeSeriesFilter_PickTimeSeriesFilter struct {
	// Ranking based time series filter.
	PickTimeSeriesFilter *PickTimeSeriesFilter `protobuf:"bytes,4,opt,name=pick_time_series_filter,json=pickTimeSeriesFilter,proto3,oneof"`
}

type TimeSeriesFilter_StatisticalTimeSeriesFilter struct {
	// Statistics based time series filter.
	// Note: This field is deprecated and completely ignored by the API.
	//
	// Deprecated: Marked as deprecated in google/monitoring/dashboard/v1/metrics.proto.
	StatisticalTimeSeriesFilter *StatisticalTimeSeriesFilter `protobuf:"bytes,5,opt,name=statistical_time_series_filter,json=statisticalTimeSeriesFilter,proto3,oneof"`
}

func (*TimeSeriesFilter_PickTimeSeriesFilter) isTimeSeriesFilter_OutputFilter() {}

func (*TimeSeriesFilter_StatisticalTimeSeriesFilter) isTimeSeriesFilter_OutputFilter() {}

// A pair of time series filters that define a ratio computation. The output
// time series is the pair-wise division of each aligned element from the
// numerator and denominator time series.
type TimeSeriesFilterRatio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The numerator of the ratio.
	Numerator *TimeSeriesFilterRatio_RatioPart `protobuf:"bytes,1,opt,name=numerator,proto3" json:"numerator,omitempty"`
	// The denominator of the ratio.
	Denominator *TimeSeriesFilterRatio_RatioPart `protobuf:"bytes,2,opt,name=denominator,proto3" json:"denominator,omitempty"`
	// Apply a second aggregation after the ratio is computed.
	SecondaryAggregation *Aggregation `protobuf:"bytes,3,opt,name=secondary_aggregation,json=secondaryAggregation,proto3" json:"secondary_aggregation,omitempty"`
	// Selects an optional filter that is applied to the time series after
	// computing the ratio.
	//
	// Types that are assignable to OutputFilter:
	//
	//	*TimeSeriesFilterRatio_PickTimeSeriesFilter
	//	*TimeSeriesFilterRatio_StatisticalTimeSeriesFilter
	OutputFilter isTimeSeriesFilterRatio_OutputFilter `protobuf_oneof:"output_filter"`
}

func (x *TimeSeriesFilterRatio) Reset() {
	*x = TimeSeriesFilterRatio{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeriesFilterRatio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeriesFilterRatio) ProtoMessage() {}

func (x *TimeSeriesFilterRatio) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeriesFilterRatio.ProtoReflect.Descriptor instead.
func (*TimeSeriesFilterRatio) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP(), []int{2}
}

func (x *TimeSeriesFilterRatio) GetNumerator() *TimeSeriesFilterRatio_RatioPart {
	if x != nil {
		return x.Numerator
	}
	return nil
}

func (x *TimeSeriesFilterRatio) GetDenominator() *TimeSeriesFilterRatio_RatioPart {
	if x != nil {
		return x.Denominator
	}
	return nil
}

func (x *TimeSeriesFilterRatio) GetSecondaryAggregation() *Aggregation {
	if x != nil {
		return x.SecondaryAggregation
	}
	return nil
}

func (m *TimeSeriesFilterRatio) GetOutputFilter() isTimeSeriesFilterRatio_OutputFilter {
	if m != nil {
		return m.OutputFilter
	}
	return nil
}

func (x *TimeSeriesFilterRatio) GetPickTimeSeriesFilter() *PickTimeSeriesFilter {
	if x, ok := x.GetOutputFilter().(*TimeSeriesFilterRatio_PickTimeSeriesFilter); ok {
		return x.PickTimeSeriesFilter
	}
	return nil
}

// Deprecated: Marked as deprecated in google/monitoring/dashboard/v1/metrics.proto.
func (x *TimeSeriesFilterRatio) GetStatisticalTimeSeriesFilter() *StatisticalTimeSeriesFilter {
	if x, ok := x.GetOutputFilter().(*TimeSeriesFilterRatio_StatisticalTimeSeriesFilter); ok {
		return x.StatisticalTimeSeriesFilter
	}
	return nil
}

type isTimeSeriesFilterRatio_OutputFilter interface {
	isTimeSeriesFilterRatio_OutputFilter()
}

type TimeSeriesFilterRatio_PickTimeSeriesFilter struct {
	// Ranking based time series filter.
	PickTimeSeriesFilter *PickTimeSeriesFilter `protobuf:"bytes,4,opt,name=pick_time_series_filter,json=pickTimeSeriesFilter,proto3,oneof"`
}

type TimeSeriesFilterRatio_StatisticalTimeSeriesFilter struct {
	// Statistics based time series filter.
	// Note: This field is deprecated and completely ignored by the API.
	//
	// Deprecated: Marked as deprecated in google/monitoring/dashboard/v1/metrics.proto.
	StatisticalTimeSeriesFilter *StatisticalTimeSeriesFilter `protobuf:"bytes,5,opt,name=statistical_time_series_filter,json=statisticalTimeSeriesFilter,proto3,oneof"`
}

func (*TimeSeriesFilterRatio_PickTimeSeriesFilter) isTimeSeriesFilterRatio_OutputFilter() {}

func (*TimeSeriesFilterRatio_StatisticalTimeSeriesFilter) isTimeSeriesFilterRatio_OutputFilter() {}

// Defines a threshold for categorizing time series values.
type Threshold struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A label for the threshold.
	Label string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	// The value of the threshold. The value should be defined in the native scale
	// of the metric.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
	// The state color for this threshold. Color is not allowed in a XyChart.
	Color Threshold_Color `protobuf:"varint,3,opt,name=color,proto3,enum=google.monitoring.dashboard.v1.Threshold_Color" json:"color,omitempty"`
	// The direction for the current threshold. Direction is not allowed in a
	// XyChart.
	Direction Threshold_Direction `protobuf:"varint,4,opt,name=direction,proto3,enum=google.monitoring.dashboard.v1.Threshold_Direction" json:"direction,omitempty"`
	// The target axis to use for plotting the threshold. Target axis is not
	// allowed in a Scorecard.
	TargetAxis Threshold_TargetAxis `protobuf:"varint,5,opt,name=target_axis,json=targetAxis,proto3,enum=google.monitoring.dashboard.v1.Threshold_TargetAxis" json:"target_axis,omitempty"`
}

func (x *Threshold) Reset() {
	*x = Threshold{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Threshold) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Threshold) ProtoMessage() {}

func (x *Threshold) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Threshold.ProtoReflect.Descriptor instead.
func (*Threshold) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP(), []int{3}
}

func (x *Threshold) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *Threshold) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *Threshold) GetColor() Threshold_Color {
	if x != nil {
		return x.Color
	}
	return Threshold_COLOR_UNSPECIFIED
}

func (x *Threshold) GetDirection() Threshold_Direction {
	if x != nil {
		return x.Direction
	}
	return Threshold_DIRECTION_UNSPECIFIED
}

func (x *Threshold) GetTargetAxis() Threshold_TargetAxis {
	if x != nil {
		return x.TargetAxis
	}
	return Threshold_TARGET_AXIS_UNSPECIFIED
}

// Describes a query to build the numerator or denominator of a
// TimeSeriesFilterRatio.
type TimeSeriesFilterRatio_RatioPart struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [monitoring
	// filter](https://cloud.google.com/monitoring/api/v3/filters) that
	// identifies the metric types, resources, and projects to query.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// By default, the raw time series data is returned.
	// Use this field to combine multiple time series for different views of the
	// data.
	Aggregation *Aggregation `protobuf:"bytes,2,opt,name=aggregation,proto3" json:"aggregation,omitempty"`
}

func (x *TimeSeriesFilterRatio_RatioPart) Reset() {
	*x = TimeSeriesFilterRatio_RatioPart{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeriesFilterRatio_RatioPart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeriesFilterRatio_RatioPart) ProtoMessage() {}

func (x *TimeSeriesFilterRatio_RatioPart) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeriesFilterRatio_RatioPart.ProtoReflect.Descriptor instead.
func (*TimeSeriesFilterRatio_RatioPart) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP(), []int{2, 0}
}

func (x *TimeSeriesFilterRatio_RatioPart) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *TimeSeriesFilterRatio_RatioPart) GetAggregation() *Aggregation {
	if x != nil {
		return x.Aggregation
	}
	return nil
}

var File_google_monitoring_dashboard_v1_metrics_proto protoreflect.FileDescriptor

var file_google_monitoring_dashboard_v1_metrics_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2f, 0x76, 0x31,
	0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb7, 0x03, 0x0a,
	0x0f, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x60, 0x0a, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x70, 0x0a, 0x18, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x48, 0x00, 0x52, 0x15, 0x74,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x61, 0x74, 0x69, 0x6f, 0x12, 0x3d, 0x0a, 0x1a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x17, 0x74, 0x69, 0x6d, 0x65,
	0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x12, 0x2b, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75,
	0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0f, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x23, 0x0a, 0x0d, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x75, 0x6e, 0x69, 0x74, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x46, 0x75, 0x6c, 0x6c, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xe9, 0x03, 0x0a, 0x10, 0x54, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4d, 0x0a, 0x0b, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x15, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x14, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x17, 0x70, 0x69, 0x63,
	0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64,
	0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x63, 0x6b,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x14, 0x70, 0x69, 0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x86, 0x01, 0x0a, 0x1e, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x02,
	0x18, 0x01, 0x48, 0x00, 0x52, 0x1b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61,
	0x6c, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x42, 0x0f, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0xbd, 0x05, 0x0a, 0x15, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x5d, 0x0a, 0x09,
	0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x2e, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x50, 0x61, 0x72, 0x74,
	0x52, 0x09, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x61, 0x0a, 0x0b, 0x64,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x2e, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x50, 0x61, 0x72,
	0x74, 0x52, 0x0b, 0x64, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x60,
	0x0a, 0x15, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x6d, 0x0a, 0x17, 0x70, 0x69, 0x63, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x69, 0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x14, 0x70, 0x69, 0x63, 0x6b, 0x54,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x86, 0x01, 0x0a, 0x1e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73,
	0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73,
	0x74, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x1b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x1a, 0x77, 0x0a, 0x09, 0x52, 0x61, 0x74, 0x69,
	0x6f, 0x50, 0x61, 0x72, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x4d, 0x0a, 0x0b, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0xd6, 0x03, 0x0a, 0x09, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x05,
	0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x05, 0x63, 0x6f,
	0x6c, 0x6f, 0x72, 0x12, 0x51, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x61, 0x78, 0x69, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x78, 0x69,
	0x73, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x78, 0x69, 0x73, 0x22, 0x33, 0x0a,
	0x05, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4c, 0x4f, 0x52, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x59, 0x45, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x52, 0x45, 0x44,
	0x10, 0x06, 0x22, 0x3c, 0x0a, 0x09, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x19, 0x0a, 0x15, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x42,
	0x4f, 0x56, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x45, 0x4c, 0x4f, 0x57, 0x10, 0x02,
	0x22, 0x39, 0x0a, 0x0a, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x78, 0x69, 0x73, 0x12, 0x1b,
	0x0a, 0x17, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x41, 0x58, 0x49, 0x53, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x59,
	0x31, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x59, 0x32, 0x10, 0x02, 0x2a, 0x51, 0x0a, 0x0e, 0x53,
	0x70, 0x61, 0x72, 0x6b, 0x43, 0x68, 0x61, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a,
	0x1c, 0x53, 0x50, 0x41, 0x52, 0x4b, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0e, 0x0a, 0x0a, 0x53, 0x50, 0x41, 0x52, 0x4b, 0x5f, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x50, 0x41, 0x52, 0x4b, 0x5f, 0x42, 0x41, 0x52, 0x10, 0x02, 0x42, 0xf5,
	0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x46, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x70,
	0x62, 0x3b, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x70, 0x62, 0xaa, 0x02, 0x24,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5c, 0x44,
	0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x28, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_monitoring_dashboard_v1_metrics_proto_rawDescOnce sync.Once
	file_google_monitoring_dashboard_v1_metrics_proto_rawDescData = file_google_monitoring_dashboard_v1_metrics_proto_rawDesc
)

func file_google_monitoring_dashboard_v1_metrics_proto_rawDescGZIP() []byte {
	file_google_monitoring_dashboard_v1_metrics_proto_rawDescOnce.Do(func() {
		file_google_monitoring_dashboard_v1_metrics_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_monitoring_dashboard_v1_metrics_proto_rawDescData)
	})
	return file_google_monitoring_dashboard_v1_metrics_proto_rawDescData
}

var file_google_monitoring_dashboard_v1_metrics_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_monitoring_dashboard_v1_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_monitoring_dashboard_v1_metrics_proto_goTypes = []interface{}{
	(SparkChartType)(0),                     // 0: google.monitoring.dashboard.v1.SparkChartType
	(Threshold_Color)(0),                    // 1: google.monitoring.dashboard.v1.Threshold.Color
	(Threshold_Direction)(0),                // 2: google.monitoring.dashboard.v1.Threshold.Direction
	(Threshold_TargetAxis)(0),               // 3: google.monitoring.dashboard.v1.Threshold.TargetAxis
	(*TimeSeriesQuery)(nil),                 // 4: google.monitoring.dashboard.v1.TimeSeriesQuery
	(*TimeSeriesFilter)(nil),                // 5: google.monitoring.dashboard.v1.TimeSeriesFilter
	(*TimeSeriesFilterRatio)(nil),           // 6: google.monitoring.dashboard.v1.TimeSeriesFilterRatio
	(*Threshold)(nil),                       // 7: google.monitoring.dashboard.v1.Threshold
	(*TimeSeriesFilterRatio_RatioPart)(nil), // 8: google.monitoring.dashboard.v1.TimeSeriesFilterRatio.RatioPart
	(*Aggregation)(nil),                     // 9: google.monitoring.dashboard.v1.Aggregation
	(*PickTimeSeriesFilter)(nil),            // 10: google.monitoring.dashboard.v1.PickTimeSeriesFilter
	(*StatisticalTimeSeriesFilter)(nil),     // 11: google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter
}
var file_google_monitoring_dashboard_v1_metrics_proto_depIdxs = []int32{
	5,  // 0: google.monitoring.dashboard.v1.TimeSeriesQuery.time_series_filter:type_name -> google.monitoring.dashboard.v1.TimeSeriesFilter
	6,  // 1: google.monitoring.dashboard.v1.TimeSeriesQuery.time_series_filter_ratio:type_name -> google.monitoring.dashboard.v1.TimeSeriesFilterRatio
	9,  // 2: google.monitoring.dashboard.v1.TimeSeriesFilter.aggregation:type_name -> google.monitoring.dashboard.v1.Aggregation
	9,  // 3: google.monitoring.dashboard.v1.TimeSeriesFilter.secondary_aggregation:type_name -> google.monitoring.dashboard.v1.Aggregation
	10, // 4: google.monitoring.dashboard.v1.TimeSeriesFilter.pick_time_series_filter:type_name -> google.monitoring.dashboard.v1.PickTimeSeriesFilter
	11, // 5: google.monitoring.dashboard.v1.TimeSeriesFilter.statistical_time_series_filter:type_name -> google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter
	8,  // 6: google.monitoring.dashboard.v1.TimeSeriesFilterRatio.numerator:type_name -> google.monitoring.dashboard.v1.TimeSeriesFilterRatio.RatioPart
	8,  // 7: google.monitoring.dashboard.v1.TimeSeriesFilterRatio.denominator:type_name -> google.monitoring.dashboard.v1.TimeSeriesFilterRatio.RatioPart
	9,  // 8: google.monitoring.dashboard.v1.TimeSeriesFilterRatio.secondary_aggregation:type_name -> google.monitoring.dashboard.v1.Aggregation
	10, // 9: google.monitoring.dashboard.v1.TimeSeriesFilterRatio.pick_time_series_filter:type_name -> google.monitoring.dashboard.v1.PickTimeSeriesFilter
	11, // 10: google.monitoring.dashboard.v1.TimeSeriesFilterRatio.statistical_time_series_filter:type_name -> google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter
	1,  // 11: google.monitoring.dashboard.v1.Threshold.color:type_name -> google.monitoring.dashboard.v1.Threshold.Color
	2,  // 12: google.monitoring.dashboard.v1.Threshold.direction:type_name -> google.monitoring.dashboard.v1.Threshold.Direction
	3,  // 13: google.monitoring.dashboard.v1.Threshold.target_axis:type_name -> google.monitoring.dashboard.v1.Threshold.TargetAxis
	9,  // 14: google.monitoring.dashboard.v1.TimeSeriesFilterRatio.RatioPart.aggregation:type_name -> google.monitoring.dashboard.v1.Aggregation
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_monitoring_dashboard_v1_metrics_proto_init() }
func file_google_monitoring_dashboard_v1_metrics_proto_init() {
	if File_google_monitoring_dashboard_v1_metrics_proto != nil {
		return
	}
	file_google_monitoring_dashboard_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeriesQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeriesFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeriesFilterRatio); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Threshold); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeriesFilterRatio_RatioPart); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*TimeSeriesQuery_TimeSeriesFilter)(nil),
		(*TimeSeriesQuery_TimeSeriesFilterRatio)(nil),
		(*TimeSeriesQuery_TimeSeriesQueryLanguage)(nil),
		(*TimeSeriesQuery_PrometheusQuery)(nil),
	}
	file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*TimeSeriesFilter_PickTimeSeriesFilter)(nil),
		(*TimeSeriesFilter_StatisticalTimeSeriesFilter)(nil),
	}
	file_google_monitoring_dashboard_v1_metrics_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*TimeSeriesFilterRatio_PickTimeSeriesFilter)(nil),
		(*TimeSeriesFilterRatio_StatisticalTimeSeriesFilter)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_monitoring_dashboard_v1_metrics_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_monitoring_dashboard_v1_metrics_proto_goTypes,
		DependencyIndexes: file_google_monitoring_dashboard_v1_metrics_proto_depIdxs,
		EnumInfos:         file_google_monitoring_dashboard_v1_metrics_proto_enumTypes,
		MessageInfos:      file_google_monitoring_dashboard_v1_metrics_proto_msgTypes,
	}.Build()
	File_google_monitoring_dashboard_v1_metrics_proto = out.File
	file_google_monitoring_dashboard_v1_metrics_proto_rawDesc = nil
	file_google_monitoring_dashboard_v1_metrics_proto_goTypes = nil
	file_google_monitoring_dashboard_v1_metrics_proto_depIdxs = nil
}
