; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX11 %s

define amdgpu_kernel void @test_fmin3_olt_0_f32(ptr addrspace(1) %out, ptr addrspace(1) %aptr, ptr addrspace(1) %bptr, ptr addrspace(1) %cptr) #0 {
; SI-LABEL: test_fmin3_olt_0_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s15, s11
; SI-NEXT:    s_mov_b32 s18, s10
; SI-NEXT:    s_mov_b32 s19, s11
; SI-NEXT:    s_mov_b32 s22, s10
; SI-NEXT:    s_mov_b32 s23, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s16, s4
; SI-NEXT:    s_mov_b32 s17, s5
; SI-NEXT:    s_mov_b32 s20, s6
; SI-NEXT:    s_mov_b32 s21, s7
; SI-NEXT:    buffer_load_dword v0, off, s[12:15], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[16:19], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dword v2, off, s[20:23], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s0
; SI-NEXT:    s_mov_b32 s9, s1
; SI-NEXT:    v_min3_f32 v0, v0, v1, v2
; SI-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_fmin3_olt_0_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s14, s10
; VI-NEXT:    s_mov_b32 s15, s11
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s12, s2
; VI-NEXT:    s_mov_b32 s13, s3
; VI-NEXT:    s_mov_b32 s16, s4
; VI-NEXT:    s_mov_b32 s17, s5
; VI-NEXT:    s_mov_b32 s18, s10
; VI-NEXT:    s_mov_b32 s19, s11
; VI-NEXT:    s_mov_b32 s4, s6
; VI-NEXT:    s_mov_b32 s5, s7
; VI-NEXT:    s_mov_b32 s6, s10
; VI-NEXT:    s_mov_b32 s7, s11
; VI-NEXT:    buffer_load_dword v0, off, s[12:15], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_load_dword v1, off, s[16:19], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_load_dword v2, off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s0
; VI-NEXT:    s_mov_b32 s9, s1
; VI-NEXT:    v_min3_f32 v0, v0, v1, v2
; VI-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fmin3_olt_0_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_mov_b32 s14, s2
; GFX9-NEXT:    s_mov_b32 s15, s3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mov_b32 s16, s8
; GFX9-NEXT:    s_mov_b32 s17, s9
; GFX9-NEXT:    s_mov_b32 s18, s2
; GFX9-NEXT:    s_mov_b32 s19, s3
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    s_mov_b32 s10, s2
; GFX9-NEXT:    s_mov_b32 s11, s3
; GFX9-NEXT:    buffer_load_dword v0, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_dword v1, off, s[16:19], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_dword v2, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, s4
; GFX9-NEXT:    s_mov_b32 s1, s5
; GFX9-NEXT:    v_min3_f32 v0, v0, v1, v2
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fmin3_olt_0_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-NEXT:    s_mov_b32 s10, -1
; GFX11-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-NEXT:    s_mov_b32 s14, s10
; GFX11-NEXT:    s_mov_b32 s15, s11
; GFX11-NEXT:    s_mov_b32 s18, s10
; GFX11-NEXT:    s_mov_b32 s19, s11
; GFX11-NEXT:    s_mov_b32 s22, s10
; GFX11-NEXT:    s_mov_b32 s23, s11
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s2
; GFX11-NEXT:    s_mov_b32 s13, s3
; GFX11-NEXT:    s_mov_b32 s16, s4
; GFX11-NEXT:    s_mov_b32 s17, s5
; GFX11-NEXT:    s_mov_b32 s20, s6
; GFX11-NEXT:    s_mov_b32 s21, s7
; GFX11-NEXT:    buffer_load_b32 v0, off, s[12:15], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_b32 v1, off, s[16:19], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_b32 v2, off, s[20:23], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s0
; GFX11-NEXT:    s_mov_b32 s9, s1
; GFX11-NEXT:    v_min3_f32 v0, v0, v1, v2
; GFX11-NEXT:    buffer_store_b32 v0, off, s[8:11], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %a = load volatile float, ptr addrspace(1) %aptr, align 4
  %b = load volatile float, ptr addrspace(1) %bptr, align 4
  %c = load volatile float, ptr addrspace(1) %cptr, align 4
  %f0 = call float @llvm.minnum.f32(float %a, float %b)
  %f1 = call float @llvm.minnum.f32(float %f0, float %c)
  store float %f1, ptr addrspace(1) %out, align 4
  ret void
}

; Commute operand of second fmin
define amdgpu_kernel void @test_fmin3_olt_1_f32(ptr addrspace(1) %out, ptr addrspace(1) %aptr, ptr addrspace(1) %bptr, ptr addrspace(1) %cptr) #0 {
; SI-LABEL: test_fmin3_olt_1_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s15, s11
; SI-NEXT:    s_mov_b32 s18, s10
; SI-NEXT:    s_mov_b32 s19, s11
; SI-NEXT:    s_mov_b32 s22, s10
; SI-NEXT:    s_mov_b32 s23, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s16, s4
; SI-NEXT:    s_mov_b32 s17, s5
; SI-NEXT:    s_mov_b32 s20, s6
; SI-NEXT:    s_mov_b32 s21, s7
; SI-NEXT:    buffer_load_dword v0, off, s[12:15], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[16:19], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dword v2, off, s[20:23], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s0
; SI-NEXT:    s_mov_b32 s9, s1
; SI-NEXT:    v_min3_f32 v0, v2, v0, v1
; SI-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_fmin3_olt_1_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s14, s10
; VI-NEXT:    s_mov_b32 s15, s11
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s12, s2
; VI-NEXT:    s_mov_b32 s13, s3
; VI-NEXT:    s_mov_b32 s16, s4
; VI-NEXT:    s_mov_b32 s17, s5
; VI-NEXT:    s_mov_b32 s18, s10
; VI-NEXT:    s_mov_b32 s19, s11
; VI-NEXT:    s_mov_b32 s4, s6
; VI-NEXT:    s_mov_b32 s5, s7
; VI-NEXT:    s_mov_b32 s6, s10
; VI-NEXT:    s_mov_b32 s7, s11
; VI-NEXT:    buffer_load_dword v0, off, s[12:15], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_load_dword v1, off, s[16:19], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_load_dword v2, off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s0
; VI-NEXT:    s_mov_b32 s9, s1
; VI-NEXT:    v_min3_f32 v0, v2, v0, v1
; VI-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fmin3_olt_1_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_mov_b32 s14, s2
; GFX9-NEXT:    s_mov_b32 s15, s3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mov_b32 s16, s8
; GFX9-NEXT:    s_mov_b32 s17, s9
; GFX9-NEXT:    s_mov_b32 s18, s2
; GFX9-NEXT:    s_mov_b32 s19, s3
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    s_mov_b32 s10, s2
; GFX9-NEXT:    s_mov_b32 s11, s3
; GFX9-NEXT:    buffer_load_dword v0, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_dword v1, off, s[16:19], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_dword v2, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, s4
; GFX9-NEXT:    s_mov_b32 s1, s5
; GFX9-NEXT:    v_min3_f32 v0, v2, v0, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fmin3_olt_1_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-NEXT:    s_mov_b32 s10, -1
; GFX11-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-NEXT:    s_mov_b32 s14, s10
; GFX11-NEXT:    s_mov_b32 s15, s11
; GFX11-NEXT:    s_mov_b32 s18, s10
; GFX11-NEXT:    s_mov_b32 s19, s11
; GFX11-NEXT:    s_mov_b32 s22, s10
; GFX11-NEXT:    s_mov_b32 s23, s11
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s2
; GFX11-NEXT:    s_mov_b32 s13, s3
; GFX11-NEXT:    s_mov_b32 s16, s4
; GFX11-NEXT:    s_mov_b32 s17, s5
; GFX11-NEXT:    s_mov_b32 s20, s6
; GFX11-NEXT:    s_mov_b32 s21, s7
; GFX11-NEXT:    buffer_load_b32 v0, off, s[12:15], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_b32 v1, off, s[16:19], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_b32 v2, off, s[20:23], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s0
; GFX11-NEXT:    s_mov_b32 s9, s1
; GFX11-NEXT:    v_min3_f32 v0, v2, v0, v1
; GFX11-NEXT:    buffer_store_b32 v0, off, s[8:11], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %a = load volatile float, ptr addrspace(1) %aptr, align 4
  %b = load volatile float, ptr addrspace(1) %bptr, align 4
  %c = load volatile float, ptr addrspace(1) %cptr, align 4
  %f0 = call float @llvm.minnum.f32(float %a, float %b)
  %f1 = call float @llvm.minnum.f32(float %c, float %f0)
  store float %f1, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_fmin3_olt_0_f16(ptr addrspace(1) %out, ptr addrspace(1) %aptr, ptr addrspace(1) %bptr, ptr addrspace(1) %cptr) #0 {
; SI-LABEL: test_fmin3_olt_0_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s15, s11
; SI-NEXT:    s_mov_b32 s18, s10
; SI-NEXT:    s_mov_b32 s19, s11
; SI-NEXT:    s_mov_b32 s22, s10
; SI-NEXT:    s_mov_b32 s23, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s16, s4
; SI-NEXT:    s_mov_b32 s17, s5
; SI-NEXT:    s_mov_b32 s20, s6
; SI-NEXT:    s_mov_b32 s21, s7
; SI-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v1, off, s[16:19], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, off, s[20:23], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s0
; SI-NEXT:    s_mov_b32 s9, s1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_min3_f32 v0, v0, v1, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_fmin3_olt_0_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s14, s10
; VI-NEXT:    s_mov_b32 s15, s11
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s12, s2
; VI-NEXT:    s_mov_b32 s13, s3
; VI-NEXT:    s_mov_b32 s16, s4
; VI-NEXT:    s_mov_b32 s17, s5
; VI-NEXT:    s_mov_b32 s18, s10
; VI-NEXT:    s_mov_b32 s19, s11
; VI-NEXT:    s_mov_b32 s4, s6
; VI-NEXT:    s_mov_b32 s5, s7
; VI-NEXT:    s_mov_b32 s6, s10
; VI-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_load_ushort v1, off, s[16:19], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s7, s11
; VI-NEXT:    buffer_load_ushort v2, off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s0
; VI-NEXT:    s_mov_b32 s9, s1
; VI-NEXT:    v_max_f16_e32 v0, v0, v0
; VI-NEXT:    v_max_f16_e32 v1, v1, v1
; VI-NEXT:    v_min_f16_e32 v0, v0, v1
; VI-NEXT:    v_max_f16_e32 v1, v2, v2
; VI-NEXT:    v_min_f16_e32 v0, v0, v1
; VI-NEXT:    buffer_store_short v0, off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fmin3_olt_0_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_mov_b32 s14, s2
; GFX9-NEXT:    s_mov_b32 s15, s3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mov_b32 s16, s8
; GFX9-NEXT:    s_mov_b32 s17, s9
; GFX9-NEXT:    s_mov_b32 s18, s2
; GFX9-NEXT:    s_mov_b32 s19, s3
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    s_mov_b32 s10, s2
; GFX9-NEXT:    s_mov_b32 s11, s3
; GFX9-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_ushort v1, off, s[16:19], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_ushort v2, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, s4
; GFX9-NEXT:    s_mov_b32 s1, s5
; GFX9-NEXT:    v_min3_f16 v0, v0, v1, v2
; GFX9-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fmin3_olt_0_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-NEXT:    s_mov_b32 s10, -1
; GFX11-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-NEXT:    s_mov_b32 s14, s10
; GFX11-NEXT:    s_mov_b32 s15, s11
; GFX11-NEXT:    s_mov_b32 s18, s10
; GFX11-NEXT:    s_mov_b32 s19, s11
; GFX11-NEXT:    s_mov_b32 s22, s10
; GFX11-NEXT:    s_mov_b32 s23, s11
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s2
; GFX11-NEXT:    s_mov_b32 s13, s3
; GFX11-NEXT:    s_mov_b32 s16, s4
; GFX11-NEXT:    s_mov_b32 s17, s5
; GFX11-NEXT:    s_mov_b32 s20, s6
; GFX11-NEXT:    s_mov_b32 s21, s7
; GFX11-NEXT:    buffer_load_u16 v0, off, s[12:15], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_u16 v1, off, s[16:19], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_u16 v2, off, s[20:23], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s0
; GFX11-NEXT:    s_mov_b32 s9, s1
; GFX11-NEXT:    v_min3_f16 v0, v0, v1, v2
; GFX11-NEXT:    buffer_store_b16 v0, off, s[8:11], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %a = load volatile half, ptr addrspace(1) %aptr, align 2
  %b = load volatile half, ptr addrspace(1) %bptr, align 2
  %c = load volatile half, ptr addrspace(1) %cptr, align 2
  %f0 = call half @llvm.minnum.f16(half %a, half %b)
  %f1 = call half @llvm.minnum.f16(half %f0, half %c)
  store half %f1, ptr addrspace(1) %out, align 2
  ret void
}

; Commute operand of second fmin
define amdgpu_kernel void @test_fmin3_olt_1_f16(ptr addrspace(1) %out, ptr addrspace(1) %aptr, ptr addrspace(1) %bptr, ptr addrspace(1) %cptr) #0 {
; SI-LABEL: test_fmin3_olt_1_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s15, s11
; SI-NEXT:    s_mov_b32 s18, s10
; SI-NEXT:    s_mov_b32 s19, s11
; SI-NEXT:    s_mov_b32 s22, s10
; SI-NEXT:    s_mov_b32 s23, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s16, s4
; SI-NEXT:    s_mov_b32 s17, s5
; SI-NEXT:    s_mov_b32 s20, s6
; SI-NEXT:    s_mov_b32 s21, s7
; SI-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v1, off, s[16:19], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, off, s[20:23], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s0
; SI-NEXT:    s_mov_b32 s9, s1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_min3_f32 v0, v2, v0, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_fmin3_olt_1_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s14, s10
; VI-NEXT:    s_mov_b32 s15, s11
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s12, s2
; VI-NEXT:    s_mov_b32 s13, s3
; VI-NEXT:    s_mov_b32 s16, s4
; VI-NEXT:    s_mov_b32 s17, s5
; VI-NEXT:    s_mov_b32 s18, s10
; VI-NEXT:    s_mov_b32 s19, s11
; VI-NEXT:    s_mov_b32 s4, s6
; VI-NEXT:    s_mov_b32 s5, s7
; VI-NEXT:    s_mov_b32 s6, s10
; VI-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_load_ushort v1, off, s[16:19], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s7, s11
; VI-NEXT:    buffer_load_ushort v2, off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s0
; VI-NEXT:    s_mov_b32 s9, s1
; VI-NEXT:    v_max_f16_e32 v0, v0, v0
; VI-NEXT:    v_max_f16_e32 v1, v1, v1
; VI-NEXT:    v_min_f16_e32 v0, v0, v1
; VI-NEXT:    v_max_f16_e32 v1, v2, v2
; VI-NEXT:    v_min_f16_e32 v0, v1, v0
; VI-NEXT:    buffer_store_short v0, off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fmin3_olt_1_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_mov_b32 s14, s2
; GFX9-NEXT:    s_mov_b32 s15, s3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mov_b32 s16, s8
; GFX9-NEXT:    s_mov_b32 s17, s9
; GFX9-NEXT:    s_mov_b32 s18, s2
; GFX9-NEXT:    s_mov_b32 s19, s3
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    s_mov_b32 s10, s2
; GFX9-NEXT:    s_mov_b32 s11, s3
; GFX9-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_ushort v1, off, s[16:19], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_ushort v2, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, s4
; GFX9-NEXT:    s_mov_b32 s1, s5
; GFX9-NEXT:    v_min3_f16 v0, v2, v0, v1
; GFX9-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fmin3_olt_1_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-NEXT:    s_mov_b32 s10, -1
; GFX11-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-NEXT:    s_mov_b32 s14, s10
; GFX11-NEXT:    s_mov_b32 s15, s11
; GFX11-NEXT:    s_mov_b32 s18, s10
; GFX11-NEXT:    s_mov_b32 s19, s11
; GFX11-NEXT:    s_mov_b32 s22, s10
; GFX11-NEXT:    s_mov_b32 s23, s11
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s2
; GFX11-NEXT:    s_mov_b32 s13, s3
; GFX11-NEXT:    s_mov_b32 s16, s4
; GFX11-NEXT:    s_mov_b32 s17, s5
; GFX11-NEXT:    s_mov_b32 s20, s6
; GFX11-NEXT:    s_mov_b32 s21, s7
; GFX11-NEXT:    buffer_load_u16 v0, off, s[12:15], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_u16 v1, off, s[16:19], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_u16 v2, off, s[20:23], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s0
; GFX11-NEXT:    s_mov_b32 s9, s1
; GFX11-NEXT:    v_min3_f16 v0, v2, v0, v1
; GFX11-NEXT:    buffer_store_b16 v0, off, s[8:11], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %a = load volatile half, ptr addrspace(1) %aptr, align 2
  %b = load volatile half, ptr addrspace(1) %bptr, align 2
  %c = load volatile half, ptr addrspace(1) %cptr, align 2
  %f0 = call half @llvm.minnum.f16(half %a, half %b)
  %f1 = call half @llvm.minnum.f16(half %c, half %f0)
  store half %f1, ptr addrspace(1) %out, align 2
  ret void
}

; Checks whether the test passes; performMinMaxCombine() should not optimize vector patterns of min3
; since there are no pack instructions for fmin3.
define <2 x half> @no_fmin3_v2f16(<2 x half> %a, <2 x half> %b, <2 x half> %c, <2 x half> %d) #2 {
; SI-LABEL: no_fmin3_v2f16:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_min_f32_e32 v1, v1, v3
; SI-NEXT:    v_min_f32_e32 v0, v0, v2
; SI-NEXT:    v_min3_f32 v0, v4, v0, v6
; SI-NEXT:    v_min3_f32 v1, v5, v1, v7
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: no_fmin3_v2f16:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_min_f16_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_min_f16_e32 v0, v0, v1
; VI-NEXT:    v_min_f16_sdwa v1, v2, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_min_f16_e32 v0, v2, v0
; VI-NEXT:    v_min_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_min_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: no_fmin3_v2f16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_min_f16 v0, v0, v1
; GFX9-NEXT:    v_pk_min_f16 v0, v2, v0
; GFX9-NEXT:    v_pk_min_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: no_fmin3_v2f16:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_min_f16 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_pk_min_f16 v0, v2, v0
; GFX11-NEXT:    v_pk_min_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
entry:
  %min = call <2 x half> @llvm.minnum.v2f16(<2 x half> %a, <2 x half> %b)
  %min1 = call <2 x half> @llvm.minnum.v2f16(<2 x half> %c, <2 x half> %min)
  %res = call <2 x half> @llvm.minnum.v2f16(<2 x half> %min1, <2 x half> %d)
  ret <2 x half> %res
}

define amdgpu_kernel void @test_fmin3_olt_0_f64(ptr addrspace(1) %out, ptr addrspace(1) %aptr, ptr addrspace(1) %bptr, ptr addrspace(1) %cptr) #0 {
; SI-LABEL: test_fmin3_olt_0_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s15, s11
; SI-NEXT:    s_mov_b32 s18, s10
; SI-NEXT:    s_mov_b32 s19, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s16, s4
; SI-NEXT:    s_mov_b32 s17, s5
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[12:15], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dwordx2 v[2:3], off, s[16:19], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s2, s10
; SI-NEXT:    s_mov_b32 s3, s11
; SI-NEXT:    s_mov_b32 s8, s0
; SI-NEXT:    s_mov_b32 s9, s1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; SI-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; SI-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; SI-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; SI-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_fmin3_olt_0_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s14, s10
; VI-NEXT:    s_mov_b32 s15, s11
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s12, s2
; VI-NEXT:    s_mov_b32 s13, s3
; VI-NEXT:    s_mov_b32 s16, s4
; VI-NEXT:    s_mov_b32 s17, s5
; VI-NEXT:    s_mov_b32 s18, s10
; VI-NEXT:    s_mov_b32 s19, s11
; VI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[12:15], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_load_dwordx2 v[2:3], off, s[16:19], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s6
; VI-NEXT:    s_mov_b32 s5, s7
; VI-NEXT:    s_mov_b32 s6, s10
; VI-NEXT:    s_mov_b32 s7, s11
; VI-NEXT:    buffer_load_dwordx2 v[4:5], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s0
; VI-NEXT:    s_mov_b32 s9, s1
; VI-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; VI-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; VI-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; VI-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; VI-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fmin3_olt_0_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_mov_b32 s14, s2
; GFX9-NEXT:    s_mov_b32 s15, s3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mov_b32 s16, s8
; GFX9-NEXT:    s_mov_b32 s17, s9
; GFX9-NEXT:    s_mov_b32 s18, s2
; GFX9-NEXT:    s_mov_b32 s19, s3
; GFX9-NEXT:    buffer_load_dwordx2 v[0:1], off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_dwordx2 v[2:3], off, s[16:19], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    s_mov_b32 s10, s2
; GFX9-NEXT:    s_mov_b32 s11, s3
; GFX9-NEXT:    buffer_load_dwordx2 v[4:5], off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, s4
; GFX9-NEXT:    s_mov_b32 s1, s5
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX9-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fmin3_olt_0_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-NEXT:    s_mov_b32 s10, -1
; GFX11-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-NEXT:    s_mov_b32 s14, s10
; GFX11-NEXT:    s_mov_b32 s15, s11
; GFX11-NEXT:    s_mov_b32 s18, s10
; GFX11-NEXT:    s_mov_b32 s19, s11
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s2
; GFX11-NEXT:    s_mov_b32 s13, s3
; GFX11-NEXT:    s_mov_b32 s16, s4
; GFX11-NEXT:    s_mov_b32 s17, s5
; GFX11-NEXT:    buffer_load_b64 v[0:1], off, s[12:15], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_b64 v[2:3], off, s[16:19], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s6
; GFX11-NEXT:    s_mov_b32 s13, s7
; GFX11-NEXT:    s_mov_b32 s8, s0
; GFX11-NEXT:    buffer_load_b64 v[4:5], off, s[12:15], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s9, s1
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX11-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[8:11], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %a = load volatile double, ptr addrspace(1) %aptr, align 4
  %b = load volatile double, ptr addrspace(1) %bptr, align 4
  %c = load volatile double, ptr addrspace(1) %cptr, align 4
  %f0 = call double @llvm.minnum.f64(double %a, double %b)
  %f1 = call double @llvm.minnum.f64(double %f0, double %c)
  store double %f1, ptr addrspace(1) %out, align 4
  ret void
}

; Commute operand of second fmin
define amdgpu_kernel void @test_fmin3_olt_1_f64(ptr addrspace(1) %out, ptr addrspace(1) %aptr, ptr addrspace(1) %bptr, ptr addrspace(1) %cptr) #0 {
; SI-LABEL: test_fmin3_olt_1_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s15, s11
; SI-NEXT:    s_mov_b32 s18, s10
; SI-NEXT:    s_mov_b32 s19, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s16, s4
; SI-NEXT:    s_mov_b32 s17, s5
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[12:15], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_dwordx2 v[2:3], off, s[16:19], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s2, s10
; SI-NEXT:    s_mov_b32 s3, s11
; SI-NEXT:    s_mov_b32 s8, s0
; SI-NEXT:    s_mov_b32 s9, s1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; SI-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; SI-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; SI-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; SI-NEXT:    v_min_f64 v[0:1], v[2:3], v[0:1]
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_fmin3_olt_1_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s14, s10
; VI-NEXT:    s_mov_b32 s15, s11
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s12, s2
; VI-NEXT:    s_mov_b32 s13, s3
; VI-NEXT:    s_mov_b32 s16, s4
; VI-NEXT:    s_mov_b32 s17, s5
; VI-NEXT:    s_mov_b32 s18, s10
; VI-NEXT:    s_mov_b32 s19, s11
; VI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[12:15], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_load_dwordx2 v[2:3], off, s[16:19], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s6
; VI-NEXT:    s_mov_b32 s5, s7
; VI-NEXT:    s_mov_b32 s6, s10
; VI-NEXT:    s_mov_b32 s7, s11
; VI-NEXT:    buffer_load_dwordx2 v[4:5], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s0
; VI-NEXT:    s_mov_b32 s9, s1
; VI-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; VI-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; VI-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; VI-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; VI-NEXT:    v_min_f64 v[0:1], v[2:3], v[0:1]
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: test_fmin3_olt_1_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_mov_b32 s14, s2
; GFX9-NEXT:    s_mov_b32 s15, s3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mov_b32 s16, s8
; GFX9-NEXT:    s_mov_b32 s17, s9
; GFX9-NEXT:    s_mov_b32 s18, s2
; GFX9-NEXT:    s_mov_b32 s19, s3
; GFX9-NEXT:    buffer_load_dwordx2 v[0:1], off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_load_dwordx2 v[2:3], off, s[16:19], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    s_mov_b32 s10, s2
; GFX9-NEXT:    s_mov_b32 s11, s3
; GFX9-NEXT:    buffer_load_dwordx2 v[4:5], off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, s4
; GFX9-NEXT:    s_mov_b32 s1, s5
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX9-NEXT:    v_min_f64 v[0:1], v[2:3], v[0:1]
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: test_fmin3_olt_1_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-NEXT:    s_mov_b32 s10, -1
; GFX11-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-NEXT:    s_mov_b32 s14, s10
; GFX11-NEXT:    s_mov_b32 s15, s11
; GFX11-NEXT:    s_mov_b32 s18, s10
; GFX11-NEXT:    s_mov_b32 s19, s11
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s2
; GFX11-NEXT:    s_mov_b32 s13, s3
; GFX11-NEXT:    s_mov_b32 s16, s4
; GFX11-NEXT:    s_mov_b32 s17, s5
; GFX11-NEXT:    buffer_load_b64 v[0:1], off, s[12:15], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_load_b64 v[2:3], off, s[16:19], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s6
; GFX11-NEXT:    s_mov_b32 s13, s7
; GFX11-NEXT:    s_mov_b32 s8, s0
; GFX11-NEXT:    buffer_load_b64 v[4:5], off, s[12:15], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s9, s1
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX11-NEXT:    v_min_f64 v[0:1], v[2:3], v[0:1]
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[8:11], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %a = load volatile double, ptr addrspace(1) %aptr, align 4
  %b = load volatile double, ptr addrspace(1) %bptr, align 4
  %c = load volatile double, ptr addrspace(1) %cptr, align 4
  %f0 = call double @llvm.minnum.f64(double %a, double %b)
  %f1 = call double @llvm.minnum.f64(double %c, double %f0)
  store double %f1, ptr addrspace(1) %out, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1
declare double @llvm.minnum.f64(double, double) #1
declare float @llvm.minnum.f32(float, float) #1
declare half @llvm.minnum.f16(half, half) #1
declare <2 x half> @llvm.minnum.v2f16(<2 x half>, <2 x half>)

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone speculatable }
attributes #2 = { nounwind "no-nans-fp-math"="true" }
