; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -mcpu=fiji -denormal-fp-math=preserve-sign -denormal-fp-math-f32=ieee -fp-contract=on -verify-machineinstrs < %s | FileCheck -check-prefixes=VI-FLUSH %s
; RUN: llc -mtriple=amdgcn -mcpu=fiji -denormal-fp-math=preserve-sign -denormal-fp-math-f32=ieee -fp-contract=fast -verify-machineinstrs < %s | FileCheck -check-prefixes=VI-FLUSH %s

; RUN: llc -mtriple=amdgcn -mcpu=fiji -denormal-fp-math=ieee -denormal-fp-math-f32=ieee -fp-contract=on -verify-machineinstrs < %s | FileCheck -check-prefixes=VI-DENORM %s
; RUN: llc -mtriple=amdgcn -mcpu=fiji -denormal-fp-math=ieee -denormal-fp-math-f32=ieee -fp-contract=fast -verify-machineinstrs < %s | FileCheck -check-prefixes=VI-DENORM,VI-DENORM-CONTRACT %s

; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -denormal-fp-math=preserve-sign -denormal-fp-math-f32=ieee -fp-contract=on -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-FLUSH %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -denormal-fp-math=preserve-sign -denormal-fp-math-f32=ieee -fp-contract=fast -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-FLUSH %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -denormal-fp-math=ieee -denormal-fp-math-f32=ieee -fp-contract=on -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DENORM,GFX10-DENORM-STRICT %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -denormal-fp-math=ieee -denormal-fp-math-f32=ieee -fp-contract=fast -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DENORM,GFX10-DENORM-CONTRACT %s

; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -denormal-fp-math=preserve-sign -denormal-fp-math-f32=ieee -fp-contract=on -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-FLUSH %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -denormal-fp-math=preserve-sign -denormal-fp-math-f32=ieee -fp-contract=fast -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-FLUSH %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -denormal-fp-math=ieee -denormal-fp-math-f32=ieee -fp-contract=on -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-DENORM,GFX11-DENORM-STRICT %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -denormal-fp-math=ieee -denormal-fp-math-f32=ieee -fp-contract=fast -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-DENORM,GFX11-DENORM-CONTRACT %s

declare i32 @llvm.amdgcn.workitem.id.x() #1
declare half @llvm.fmuladd.f16(half, half, half) #1
declare half @llvm.fabs.f16(half) #1

define amdgpu_kernel void @fmuladd_f16(ptr addrspace(1) %out, ptr addrspace(1) %in1,
; VI-FLUSH-LABEL: fmuladd_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s2
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    v_mov_b32_e32 v2, s4
; VI-FLUSH-NEXT:    v_mov_b32_e32 v3, s5
; VI-FLUSH-NEXT:    v_mov_b32_e32 v4, s6
; VI-FLUSH-NEXT:    v_mov_b32_e32 v5, s7
; VI-FLUSH-NEXT:    flat_load_ushort v6, v[0:1]
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3]
; VI-FLUSH-NEXT:    flat_load_ushort v3, v[4:5]
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s0
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v3, v6, v2
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v3
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s2
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-NEXT:    v_mov_b32_e32 v2, s4
; VI-DENORM-NEXT:    v_mov_b32_e32 v3, s5
; VI-DENORM-NEXT:    v_mov_b32_e32 v4, s6
; VI-DENORM-NEXT:    v_mov_b32_e32 v5, s7
; VI-DENORM-NEXT:    flat_load_ushort v6, v[0:1]
; VI-DENORM-NEXT:    flat_load_ushort v2, v[2:3]
; VI-DENORM-NEXT:    flat_load_ushort v3, v[4:5]
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s0
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_fma_f16 v2, v6, v2, v3
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_clause 0x2
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[6:7]
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[8:9]
; GFX10-FLUSH-NEXT:    global_load_ushort v3, v0, s[10:11]
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v3
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX10-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_clause 0x2
; GFX10-DENORM-NEXT:    global_load_ushort v1, v0, s[6:7]
; GFX10-DENORM-NEXT:    global_load_ushort v2, v0, s[8:9]
; GFX10-DENORM-NEXT:    global_load_ushort v3, v0, s[10:11]
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_fmac_f16_e32 v3, v1, v2
; GFX10-DENORM-NEXT:    global_store_short v0, v3, s[4:5]
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_clause 0x2
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[4:5]
; GFX11-FLUSH-NEXT:    global_load_u16 v3, v0, s[6:7]
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v3
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_clause 0x2
; GFX11-DENORM-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-DENORM-NEXT:    global_load_u16 v2, v0, s[4:5]
; GFX11-DENORM-NEXT:    global_load_u16 v3, v0, s[6:7]
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v3, v1, v2
; GFX11-DENORM-NEXT:    global_store_b16 v0, v3, s[0:1]
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
                         ptr addrspace(1) %in2, ptr addrspace(1) %in3) #0 {
  %r0 = load half, ptr addrspace(1) %in1
  %r1 = load half, ptr addrspace(1) %in2
  %r2 = load half, ptr addrspace(1) %in3
  %r3 = tail call half @llvm.fmuladd.f16(half %r0, half %r1, half %r2)
  store half %r3, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @fmul_fadd_f16(ptr addrspace(1) %out, ptr addrspace(1) %in1,
; VI-FLUSH-LABEL: fmul_fadd_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s2
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    v_mov_b32_e32 v2, s4
; VI-FLUSH-NEXT:    v_mov_b32_e32 v3, s5
; VI-FLUSH-NEXT:    v_mov_b32_e32 v4, s6
; VI-FLUSH-NEXT:    v_mov_b32_e32 v5, s7
; VI-FLUSH-NEXT:    flat_load_ushort v6, v[0:1]
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3]
; VI-FLUSH-NEXT:    flat_load_ushort v3, v[4:5]
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s0
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v3, v6, v2
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v3
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: fmul_fadd_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v0, s2
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v2, s4
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v3, s5
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v4, s6
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v5, s7
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v6, v[0:1]
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3]
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v3, v[4:5]
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v0, s0
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, v6, v2, v3
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmul_fadd_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_clause 0x2
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[6:7]
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[8:9]
; GFX10-FLUSH-NEXT:    global_load_ushort v3, v0, s[10:11]
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v3
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: fmul_fadd_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    s_clause 0x2
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[6:7]
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[8:9]
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v3, v0, s[10:11]
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v3
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: fmul_fadd_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    s_clause 0x2
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[6:7]
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[8:9]
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v3, v0, s[10:11]
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v3, v1, v2
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v3, s[4:5]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmul_fadd_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_clause 0x2
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[4:5]
; GFX11-FLUSH-NEXT:    global_load_u16 v3, v0, s[6:7]
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v3
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: fmul_fadd_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    s_clause 0x2
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[4:5]
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v3, v0, s[6:7]
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v3
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: fmul_fadd_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    s_clause 0x2
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[4:5]
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v3, v0, s[6:7]
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v3, v1, v2
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v3, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
                         ptr addrspace(1) %in2, ptr addrspace(1) %in3) #0 {
  %r0 = load half, ptr addrspace(1) %in1
  %r1 = load half, ptr addrspace(1) %in2
  %r2 = load half, ptr addrspace(1) %in3
  %mul = fmul half %r0, %r1
  %add = fadd half %mul, %r2
  store half %add, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @fmul_fadd_contract_f16(ptr addrspace(1) %out, ptr addrspace(1) %in1,
; VI-FLUSH-LABEL: fmul_fadd_contract_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s2
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    v_mov_b32_e32 v2, s4
; VI-FLUSH-NEXT:    v_mov_b32_e32 v3, s5
; VI-FLUSH-NEXT:    v_mov_b32_e32 v4, s6
; VI-FLUSH-NEXT:    v_mov_b32_e32 v5, s7
; VI-FLUSH-NEXT:    flat_load_ushort v6, v[0:1]
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3]
; VI-FLUSH-NEXT:    flat_load_ushort v3, v[4:5]
; VI-FLUSH-NEXT:    v_mov_b32_e32 v0, s0
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v3, v6, v2
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v3
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmul_fadd_contract_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s2
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-NEXT:    v_mov_b32_e32 v2, s4
; VI-DENORM-NEXT:    v_mov_b32_e32 v3, s5
; VI-DENORM-NEXT:    v_mov_b32_e32 v4, s6
; VI-DENORM-NEXT:    v_mov_b32_e32 v5, s7
; VI-DENORM-NEXT:    flat_load_ushort v6, v[0:1]
; VI-DENORM-NEXT:    flat_load_ushort v2, v[2:3]
; VI-DENORM-NEXT:    flat_load_ushort v3, v[4:5]
; VI-DENORM-NEXT:    v_mov_b32_e32 v0, s0
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_fma_f16 v2, v6, v2, v3
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmul_fadd_contract_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_clause 0x2
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[6:7]
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[8:9]
; GFX10-FLUSH-NEXT:    global_load_ushort v3, v0, s[10:11]
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v3
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmul_fadd_contract_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX10-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_clause 0x2
; GFX10-DENORM-NEXT:    global_load_ushort v1, v0, s[6:7]
; GFX10-DENORM-NEXT:    global_load_ushort v2, v0, s[8:9]
; GFX10-DENORM-NEXT:    global_load_ushort v3, v0, s[10:11]
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_fmac_f16_e32 v3, v1, v2
; GFX10-DENORM-NEXT:    global_store_short v0, v3, s[4:5]
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmul_fadd_contract_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_clause 0x2
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[4:5]
; GFX11-FLUSH-NEXT:    global_load_u16 v3, v0, s[6:7]
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v3
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmul_fadd_contract_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX11-DENORM-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_clause 0x2
; GFX11-DENORM-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-DENORM-NEXT:    global_load_u16 v2, v0, s[4:5]
; GFX11-DENORM-NEXT:    global_load_u16 v3, v0, s[6:7]
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v3, v1, v2
; GFX11-DENORM-NEXT:    global_store_b16 v0, v3, s[0:1]
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
                         ptr addrspace(1) %in2, ptr addrspace(1) %in3) #0 {
  %r0 = load half, ptr addrspace(1) %in1
  %r1 = load half, ptr addrspace(1) %in2
  %r2 = load half, ptr addrspace(1) %in3
  %mul = fmul contract half %r0, %r1
  %add = fadd contract half %mul, %r2
  store half %add, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @fmuladd_2.0_a_b_f16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; VI-FLUSH-LABEL: fmuladd_2.0_a_b_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v2, 2.0, v4
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_2.0_a_b_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_fma_f16 v2, v4, 2.0, v2
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_2.0_a_b_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_2.0_a_b_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX10-DENORM-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_2.0_a_b_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_2.0_a_b_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX11-DENORM-NEXT:    global_store_b16 v0, v2, s[0:1]
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r1 = load volatile half, ptr addrspace(1) %gep.0
  %r2 = load volatile half, ptr addrspace(1) %gep.1

  %r3 = tail call half @llvm.fmuladd.f16(half 2.0, half %r1, half %r2)
  store half %r3, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fmuladd_a_2.0_b_f16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; VI-FLUSH-LABEL: fmuladd_a_2.0_b_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v2, 2.0, v4
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_a_2.0_b_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_fma_f16 v2, v4, 2.0, v2
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_a_2.0_b_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_a_2.0_b_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX10-DENORM-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_a_2.0_b_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_a_2.0_b_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX11-DENORM-NEXT:    global_store_b16 v0, v2, s[0:1]
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r1 = load volatile half, ptr addrspace(1) %gep.0
  %r2 = load volatile half, ptr addrspace(1) %gep.1

  %r3 = tail call half @llvm.fmuladd.f16(half %r1, half 2.0, half %r2)
  store half %r3, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fadd_a_a_b_f16(ptr addrspace(1) %out,
; VI-FLUSH-LABEL: fadd_a_a_b_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v2, 2.0, v4
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: fadd_a_a_b_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, v4, 2.0, v2
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fadd_a_a_b_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: fadd_a_a_b_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v2
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: fadd_a_a_b_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fadd_a_a_b_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: fadd_a_a_b_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v2
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: fadd_a_a_b_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v2, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
                            ptr addrspace(1) %in1,
                            ptr addrspace(1) %in2) #0 {
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r0 = load volatile half, ptr addrspace(1) %gep.0
  %r1 = load volatile half, ptr addrspace(1) %gep.1

  %add.0 = fadd half %r0, %r0
  %add.1 = fadd half %add.0, %r1
  store half %add.1, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fadd_b_a_a_f16(ptr addrspace(1) %out,
; VI-FLUSH-LABEL: fadd_b_a_a_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v2, 2.0, v4
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: fadd_b_a_a_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, v4, 2.0, v2
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fadd_b_a_a_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v2, v1
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: fadd_b_a_a_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v2, v1
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: fadd_b_a_a_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fadd_b_a_a_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v2, v1
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: fadd_b_a_a_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v2, v1
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: fadd_b_a_a_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v2, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
                            ptr addrspace(1) %in1,
                            ptr addrspace(1) %in2) #0 {
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r0 = load volatile half, ptr addrspace(1) %gep.0
  %r1 = load volatile half, ptr addrspace(1) %gep.1

  %add.0 = fadd half %r0, %r0
  %add.1 = fadd half %r1, %add.0
  store half %add.1, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fmuladd_neg_2.0_a_b_f16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; VI-FLUSH-LABEL: fmuladd_neg_2.0_a_b_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v2, -2.0, v4
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_neg_2.0_a_b_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_fma_f16 v2, v4, -2.0, v2
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_neg_2.0_a_b_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_sub_f16_e32 v1, v2, v1
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_neg_2.0_a_b_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_fmac_f16_e32 v2, -2.0, v1
; GFX10-DENORM-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_neg_2.0_a_b_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e32 v1, v2, v1
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_neg_2.0_a_b_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v2, -2.0, v1
; GFX11-DENORM-NEXT:    global_store_b16 v0, v2, s[0:1]
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r1 = load volatile half, ptr addrspace(1) %gep.0
  %r2 = load volatile half, ptr addrspace(1) %gep.1

  %r3 = tail call half @llvm.fmuladd.f16(half -2.0, half %r1, half %r2)
  store half %r3, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fmuladd_neg_2.0_neg_a_b_f16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; VI-FLUSH-LABEL: fmuladd_neg_2.0_neg_a_b_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v2, 2.0, v4
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_neg_2.0_neg_a_b_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_fma_f16 v2, v4, 2.0, v2
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_neg_2.0_neg_a_b_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v2, v1
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_neg_2.0_neg_a_b_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX10-DENORM-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_neg_2.0_neg_a_b_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v2, v1
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_neg_2.0_neg_a_b_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v2, 2.0, v1
; GFX11-DENORM-NEXT:    global_store_b16 v0, v2, s[0:1]
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r1 = load volatile half, ptr addrspace(1) %gep.0
  %r2 = load volatile half, ptr addrspace(1) %gep.1

  %r1.fneg = fneg half %r1

  %r3 = tail call half @llvm.fmuladd.f16(half -2.0, half %r1.fneg, half %r2)
  store half %r3, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fmuladd_2.0_neg_a_b_f16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; VI-FLUSH-LABEL: fmuladd_2.0_neg_a_b_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v2, -2.0, v4
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_2.0_neg_a_b_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_fma_f16 v2, v4, -2.0, v2
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_2.0_neg_a_b_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_sub_f16_e32 v1, v2, v1
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_2.0_neg_a_b_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_fmac_f16_e32 v2, -2.0, v1
; GFX10-DENORM-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_2.0_neg_a_b_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e32 v1, v2, v1
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_2.0_neg_a_b_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v2, -2.0, v1
; GFX11-DENORM-NEXT:    global_store_b16 v0, v2, s[0:1]
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r1 = load volatile half, ptr addrspace(1) %gep.0
  %r2 = load volatile half, ptr addrspace(1) %gep.1

  %r1.fneg = fneg half %r1

  %r3 = tail call half @llvm.fmuladd.f16(half 2.0, half %r1.fneg, half %r2)
  store half %r3, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fmuladd_2.0_a_neg_b_f16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; VI-FLUSH-LABEL: fmuladd_2.0_a_neg_b_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mad_f16 v2, v4, 2.0, -v2
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_2.0_a_neg_b_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_fma_f16 v2, v4, 2.0, -v2
; VI-DENORM-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_2.0_a_neg_b_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_sub_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_2.0_a_neg_b_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_fma_f16 v1, v1, 2.0, -v2
; GFX10-DENORM-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_2.0_a_neg_b_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_2.0_a_neg_b_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_fma_f16 v1, v1, 2.0, -v2
; GFX11-DENORM-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r1 = load volatile half, ptr addrspace(1) %gep.0
  %r2 = load volatile half, ptr addrspace(1) %gep.1

  %r2.fneg = fneg half %r2

  %r3 = tail call half @llvm.fmuladd.f16(half 2.0, half %r1, half %r2.fneg)
  store half %r3, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @mad_sub_f16(ptr addrspace(1) noalias nocapture %out, ptr addrspace(1) noalias nocapture readonly %ptr) #1 {
; VI-FLUSH-LABEL: mad_sub_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_mad_f16 v2, v7, v2, -v3
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: mad_sub_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, v7, v2, -v3
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: mad_sub_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    v_sub_f16_e32 v1, v1, v3
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: mad_sub_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v1, v3
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: mad_sub_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, v1, v2, -v3
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: mad_sub_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e32 v1, v1, v3
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: mad_sub_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v1, v3
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: mad_sub_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, v1, v2, -v3
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %tid.ext = sext i32 %tid to i64
  %gep0 = getelementptr half, ptr addrspace(1) %ptr, i64 %tid.ext
  %add1 = add i64 %tid.ext, 1
  %gep1 = getelementptr half, ptr addrspace(1) %ptr, i64 %add1
  %add2 = add i64 %tid.ext, 2
  %gep2 = getelementptr half, ptr addrspace(1) %ptr, i64 %add2
  %outgep = getelementptr half, ptr addrspace(1) %out, i64 %tid.ext
  %a = load volatile half, ptr addrspace(1) %gep0, align 2
  %b = load volatile half, ptr addrspace(1) %gep1, align 2
  %c = load volatile half, ptr addrspace(1) %gep2, align 2
  %mul = fmul half %a, %b
  %sub = fsub half %mul, %c
  store half %sub, ptr addrspace(1) %outgep, align 2
  ret void
}

define amdgpu_kernel void @mad_sub_inv_f16(ptr addrspace(1) noalias nocapture %out, ptr addrspace(1) noalias nocapture readonly %ptr) #1 {
; VI-FLUSH-LABEL: mad_sub_inv_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_mad_f16 v2, -v7, v2, v3
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: mad_sub_inv_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, -v7, v2, v3
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: mad_sub_inv_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    v_sub_f16_e32 v1, v3, v1
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: mad_sub_inv_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v3, v1
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: mad_sub_inv_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, -v1, v2, v3
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: mad_sub_inv_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e32 v1, v3, v1
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: mad_sub_inv_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v3, v1
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: mad_sub_inv_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, -v1, v2, v3
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %tid.ext = sext i32 %tid to i64
  %gep0 = getelementptr half, ptr addrspace(1) %ptr, i64 %tid.ext
  %add1 = add i64 %tid.ext, 1
  %gep1 = getelementptr half, ptr addrspace(1) %ptr, i64 %add1
  %add2 = add i64 %tid.ext, 2
  %gep2 = getelementptr half, ptr addrspace(1) %ptr, i64 %add2
  %outgep = getelementptr half, ptr addrspace(1) %out, i64 %tid.ext
  %a = load volatile half, ptr addrspace(1) %gep0, align 2
  %b = load volatile half, ptr addrspace(1) %gep1, align 2
  %c = load volatile half, ptr addrspace(1) %gep2, align 2
  %mul = fmul half %a, %b
  %sub = fsub half %c, %mul
  store half %sub, ptr addrspace(1) %outgep, align 2
  ret void
}

define amdgpu_kernel void @mad_sub_fabs_f16(ptr addrspace(1) noalias nocapture %out, ptr addrspace(1) noalias nocapture readonly %ptr) #1 {
; VI-FLUSH-LABEL: mad_sub_fabs_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_mad_f16 v2, v7, v2, -|v3|
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: mad_sub_fabs_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, v7, v2, -|v3|
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: mad_sub_fabs_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    v_sub_f16_e64 v1, v1, |v3|
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: mad_sub_fabs_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-DENORM-STRICT-NEXT:    v_sub_f16_e64 v1, v1, |v3|
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: mad_sub_fabs_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, v1, v2, -|v3|
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: mad_sub_fabs_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e64 v1, v1, |v3|
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: mad_sub_fabs_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_sub_f16_e64 v1, v1, |v3|
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: mad_sub_fabs_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, v1, v2, -|v3|
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %tid.ext = sext i32 %tid to i64
  %gep0 = getelementptr half, ptr addrspace(1) %ptr, i64 %tid.ext
  %add1 = add i64 %tid.ext, 1
  %gep1 = getelementptr half, ptr addrspace(1) %ptr, i64 %add1
  %add2 = add i64 %tid.ext, 2
  %gep2 = getelementptr half, ptr addrspace(1) %ptr, i64 %add2
  %outgep = getelementptr half, ptr addrspace(1) %out, i64 %tid.ext
  %a = load volatile half, ptr addrspace(1) %gep0, align 2
  %b = load volatile half, ptr addrspace(1) %gep1, align 2
  %c = load volatile half, ptr addrspace(1) %gep2, align 2
  %c.abs = call half @llvm.fabs.f16(half %c) #0
  %mul = fmul half %a, %b
  %sub = fsub half %mul, %c.abs
  store half %sub, ptr addrspace(1) %outgep, align 2
  ret void
}

define amdgpu_kernel void @mad_sub_fabs_inv_f16(ptr addrspace(1) noalias nocapture %out, ptr addrspace(1) noalias nocapture readonly %ptr) #1 {
; VI-FLUSH-LABEL: mad_sub_fabs_inv_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_mad_f16 v2, -v7, v2, |v3|
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: mad_sub_fabs_inv_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, -v7, v2, |v3|
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: mad_sub_fabs_inv_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    v_sub_f16_e64 v1, |v3|, v1
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: mad_sub_fabs_inv_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-DENORM-STRICT-NEXT:    v_sub_f16_e64 v1, |v3|, v1
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: mad_sub_fabs_inv_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, -v1, v2, |v3|
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: mad_sub_fabs_inv_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e64 v1, |v3|, v1
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: mad_sub_fabs_inv_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_sub_f16_e64 v1, |v3|, v1
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: mad_sub_fabs_inv_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, -v1, v2, |v3|
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %tid.ext = sext i32 %tid to i64
  %gep0 = getelementptr half, ptr addrspace(1) %ptr, i64 %tid.ext
  %add1 = add i64 %tid.ext, 1
  %gep1 = getelementptr half, ptr addrspace(1) %ptr, i64 %add1
  %add2 = add i64 %tid.ext, 2
  %gep2 = getelementptr half, ptr addrspace(1) %ptr, i64 %add2
  %outgep = getelementptr half, ptr addrspace(1) %out, i64 %tid.ext
  %a = load volatile half, ptr addrspace(1) %gep0, align 2
  %b = load volatile half, ptr addrspace(1) %gep1, align 2
  %c = load volatile half, ptr addrspace(1) %gep2, align 2
  %c.abs = call half @llvm.fabs.f16(half %c) #0
  %mul = fmul half %a, %b
  %sub = fsub half %c.abs, %mul
  store half %sub, ptr addrspace(1) %outgep, align 2
  ret void
}

define amdgpu_kernel void @neg_neg_mad_f16(ptr addrspace(1) noalias nocapture %out, ptr addrspace(1) noalias nocapture readonly %ptr) #1 {
; VI-FLUSH-LABEL: neg_neg_mad_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_mac_f16_e32 v3, v7, v2
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v3
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: neg_neg_mad_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, v7, v2, v3
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: neg_neg_mad_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v3, v1
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: neg_neg_mad_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v3, v1
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: neg_neg_mad_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v3, v1, v2
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v3, s[4:5]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: neg_neg_mad_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v3, v1
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: neg_neg_mad_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v3, v1
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: neg_neg_mad_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v3, v1, v2
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v3, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %tid.ext = sext i32 %tid to i64
  %gep0 = getelementptr half, ptr addrspace(1) %ptr, i64 %tid.ext
  %add1 = add i64 %tid.ext, 1
  %gep1 = getelementptr half, ptr addrspace(1) %ptr, i64 %add1
  %add2 = add i64 %tid.ext, 2
  %gep2 = getelementptr half, ptr addrspace(1) %ptr, i64 %add2
  %outgep = getelementptr half, ptr addrspace(1) %out, i64 %tid.ext
  %a = load volatile half, ptr addrspace(1) %gep0, align 2
  %b = load volatile half, ptr addrspace(1) %gep1, align 2
  %c = load volatile half, ptr addrspace(1) %gep2, align 2
  %nega = fneg half %a
  %negb = fneg half %b
  %mul = fmul half %nega, %negb
  %sub = fadd half %mul, %c
  store half %sub, ptr addrspace(1) %outgep, align 2
  ret void
}

define amdgpu_kernel void @mad_fabs_sub_f16(ptr addrspace(1) noalias nocapture %out, ptr addrspace(1) noalias nocapture readonly %ptr) #1 {
; VI-FLUSH-LABEL: mad_fabs_sub_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_mad_f16 v2, v7, |v2|, -v3
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: mad_fabs_sub_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s3
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s2, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v7, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v3, v[4:5] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v6
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, v7, |v2|, -v3
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: mad_fabs_sub_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_mul_f16_e64 v1, v1, |v2|
; GFX10-FLUSH-NEXT:    v_sub_f16_e32 v1, v1, v3
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: mad_fabs_sub_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_mul_f16_e64 v1, v1, |v2|
; GFX10-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v1, v3
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: mad_fabs_sub_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[6:7] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[6:7] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v3, v0, s[6:7] offset:4 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, v1, |v2|, -v3
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v1, s[4:5]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: mad_fabs_sub_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_mul_f16_e64 v1, v1, |v2|
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e32 v1, v1, v3
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: mad_fabs_sub_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_mul_f16_e64 v1, v1, |v2|
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v1, v3
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: mad_fabs_sub_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[2:3] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v3, v0, s[2:3] offset:4 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, v1, |v2|, -v3
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
  %tid = tail call i32 @llvm.amdgcn.workitem.id.x() #0
  %tid.ext = sext i32 %tid to i64
  %gep0 = getelementptr half, ptr addrspace(1) %ptr, i64 %tid.ext
  %add1 = add i64 %tid.ext, 1
  %gep1 = getelementptr half, ptr addrspace(1) %ptr, i64 %add1
  %add2 = add i64 %tid.ext, 2
  %gep2 = getelementptr half, ptr addrspace(1) %ptr, i64 %add2
  %outgep = getelementptr half, ptr addrspace(1) %out, i64 %tid.ext
  %a = load volatile half, ptr addrspace(1) %gep0, align 2
  %b = load volatile half, ptr addrspace(1) %gep1, align 2
  %c = load volatile half, ptr addrspace(1) %gep2, align 2
  %b.abs = call half @llvm.fabs.f16(half %b) #0
  %mul = fmul half %a, %b.abs
  %sub = fsub half %mul, %c
  store half %sub, ptr addrspace(1) %outgep, align 2
  ret void
}

define amdgpu_kernel void @fsub_c_fadd_a_a_f16(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; VI-FLUSH-LABEL: fsub_c_fadd_a_a_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v2, -2.0, v4
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: fsub_c_fadd_a_a_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, v4, -2.0, v2
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fsub_c_fadd_a_a_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_sub_f16_e32 v1, v2, v1
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: fsub_c_fadd_a_a_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v2, v1
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: fsub_c_fadd_a_a_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v2, -2.0, v1
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fsub_c_fadd_a_a_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e32 v1, v2, v1
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: fsub_c_fadd_a_a_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v2, v1
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: fsub_c_fadd_a_a_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fmac_f16_e32 v2, -2.0, v1
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v2, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r1 = load volatile half, ptr addrspace(1) %gep.0
  %r2 = load volatile half, ptr addrspace(1) %gep.1

  %add = fadd half %r1, %r1
  %r3 = fsub half %r2, %add

  store half %r3, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fsub_fadd_a_a_c_f16(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; VI-FLUSH-LABEL: fsub_fadd_a_a_c_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; VI-FLUSH-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-FLUSH-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-FLUSH-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mad_f16 v2, v4, 2.0, -v2
; VI-FLUSH-NEXT:    flat_store_short v[0:1], v2
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-CONTRACT-LABEL: fsub_fadd_a_a_c_f16:
; VI-DENORM-CONTRACT:       ; %bb.0:
; VI-DENORM-CONTRACT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_mov_b32_e32 v1, s1
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    v_add_u32_e32 v2, vcc, 2, v0
; VI-DENORM-CONTRACT-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    flat_load_ushort v2, v[2:3] glc
; VI-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-CONTRACT-NEXT:    v_fma_f16 v2, v4, 2.0, -v2
; VI-DENORM-CONTRACT-NEXT:    flat_store_short v[0:1], v2
; VI-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fsub_fadd_a_a_c_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-FLUSH-NEXT:    v_sub_f16_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-STRICT-LABEL: fsub_fadd_a_a_c_f16:
; GFX10-DENORM-STRICT:       ; %bb.0:
; GFX10-DENORM-STRICT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX10-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v1, v2
; GFX10-DENORM-STRICT-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX10-DENORM-CONTRACT-LABEL: fsub_fadd_a_a_c_f16:
; GFX10-DENORM-CONTRACT:       ; %bb.0:
; GFX10-DENORM-CONTRACT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v1, v0, s[0:1] glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    global_load_ushort v2, v0, s[0:1] offset:2 glc dlc
; GFX10-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, v1, 2.0, -v2
; GFX10-DENORM-CONTRACT-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DENORM-CONTRACT-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fsub_fadd_a_a_c_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLUSH-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_sub_f16_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-STRICT-LABEL: fsub_fadd_a_a_c_f16:
; GFX11-DENORM-STRICT:       ; %bb.0:
; GFX11-DENORM-STRICT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-STRICT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-STRICT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-STRICT-NEXT:    v_add_f16_e32 v1, v1, v1
; GFX11-DENORM-STRICT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-STRICT-NEXT:    v_sub_f16_e32 v1, v1, v2
; GFX11-DENORM-STRICT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-STRICT-NEXT:    s_nop 0
; GFX11-DENORM-STRICT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-STRICT-NEXT:    s_endpgm
;
; GFX11-DENORM-CONTRACT-LABEL: fsub_fadd_a_a_c_f16:
; GFX11-DENORM-CONTRACT:       ; %bb.0:
; GFX11-DENORM-CONTRACT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-DENORM-CONTRACT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DENORM-CONTRACT-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v1, v0, s[0:1] glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    global_load_u16 v2, v0, s[0:1] offset:2 glc dlc
; GFX11-DENORM-CONTRACT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-CONTRACT-NEXT:    v_fma_f16 v1, v1, 2.0, -v2
; GFX11-DENORM-CONTRACT-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-DENORM-CONTRACT-NEXT:    s_nop 0
; GFX11-DENORM-CONTRACT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-CONTRACT-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.0 = getelementptr half, ptr addrspace(1) %out, i32 %tid
  %gep.1 = getelementptr half, ptr addrspace(1) %gep.0, i32 1
  %gep.out = getelementptr half, ptr addrspace(1) %out, i32 %tid

  %r1 = load volatile half, ptr addrspace(1) %gep.0
  %r2 = load volatile half, ptr addrspace(1) %gep.1

  %add = fadd half %r1, %r1
  %r3 = fsub half %add, %r2

  store half %r3, ptr addrspace(1) %gep.out
  ret void
}

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
