; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i32_stride3_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm2[1,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[3,3,3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm0[0,2]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    movq %xmm3, 16(%rcx)
; SSE-NEXT:    movaps %xmm2, (%rcx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride3_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm2
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,1,0,3,7,5,4,7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm1 = ymm2[0,2,u,1,u,5,u,u]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3],ymm0[4],ymm1[5,6,7]
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX-NEXT:    vmovaps %xmm0, (%rcx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride3_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX2-NEXT:    vmovaps %xmm0, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride3_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-FP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX2-FP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-FP-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX2-FP-NEXT:    vmovaps %xmm0, (%rcx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride3_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-FCP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-FCP-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX2-FCP-NEXT:    vmovaps %xmm0, (%rcx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX512-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX512-NEXT:    vmovaps %xmm0, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride3_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512-FCP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX512-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512-FCP-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX512-FCP-NEXT:    vmovaps %xmm0, (%rcx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride3_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX512DQ-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512DQ-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX512DQ-NEXT:    vmovaps %xmm0, (%rcx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride3_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX512DQ-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512DQ-FCP-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX512DQ-FCP-NEXT:    vmovaps %xmm0, (%rcx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride3_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512BW-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512BW-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX512BW-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX512BW-NEXT:    vmovaps %xmm0, (%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride3_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512BW-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512BW-FCP-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX512BW-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512BW-FCP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512BW-FCP-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX512BW-FCP-NEXT:    vmovaps %xmm0, (%rcx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride3_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-BW-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-BW-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX512DQ-BW-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512DQ-BW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512DQ-BW-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX512DQ-BW-NEXT:    vmovaps %xmm0, (%rcx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride3_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-BW-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,1,3,5,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovaps %xmm0, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <2 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <2 x i32> %in.vec0, <2 x i32> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i32> %in.vec2, <2 x i32> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %3 = shufflevector <4 x i32> %1, <4 x i32> %2, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
  %interleaved.vec = shufflevector <6 x i32> %3, <6 x i32> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm2[0,3]
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm3[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm2[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm1, 16(%rcx)
; SSE-NEXT:    movaps %xmm4, (%rcx)
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride3_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm3
; AVX-NEXT:    vmovsldup {{.*#+}} ymm3 = ymm3[0,0,2,2,4,4,6,6]
; AVX-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[0,u,u,1,5,u,u,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4,5],ymm3[6],ymm2[7]
; AVX-NEXT:    vbroadcastsd (%rdx), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3]
; AVX-NEXT:    vmovaps %xmm0, 32(%rcx)
; AVX-NEXT:    vmovaps %ymm2, (%rcx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride3_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX2-NEXT:    vmovaps {{.*#+}} ymm3 = [0,4,u,1,5,u,2,6]
; AVX2-NEXT:    vpermps %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vbroadcastsd (%rdx), %ymm3
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; AVX2-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3]
; AVX2-NEXT:    vmovaps %xmm0, 32(%rcx)
; AVX2-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride3_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX2-FP-NEXT:    vmovaps {{.*#+}} ymm3 = [0,4,u,1,5,u,2,6]
; AVX2-FP-NEXT:    vpermps %ymm2, %ymm3, %ymm2
; AVX2-FP-NEXT:    vbroadcastsd (%rdx), %ymm3
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3]
; AVX2-FP-NEXT:    vmovaps %xmm0, 32(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride3_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [7,3,7,3,7,3,7,3]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0],xmm1[1,2],xmm2[3]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm2 = [0,4,u,1,5,u,2,6]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vbroadcastsd (%rdx), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2],ymm0[3,4],ymm2[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FCP-NEXT:    vmovaps %xmm1, 32(%rcx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovaps (%rdi), %xmm0
; AVX512-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinsertf32x4 $2, (%rdx), %zmm0, %zmm0
; AVX512-NEXT:    vmovaps {{.*#+}} zmm1 = [0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u]
; AVX512-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride3_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512-FCP-NEXT:    vinsertf32x4 $2, (%rdx), %zmm0, %zmm0
; AVX512-FCP-NEXT:    vmovaps {{.*#+}} zmm1 = [0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u]
; AVX512-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512-FCP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride3_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-NEXT:    vinsertf32x4 $2, (%rdx), %zmm0, %zmm0
; AVX512DQ-NEXT:    vmovaps {{.*#+}} zmm1 = [0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u]
; AVX512DQ-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512DQ-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride3_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vinsertf32x4 $2, (%rdx), %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vmovaps {{.*#+}} zmm1 = [0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512DQ-FCP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride3_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovaps (%rdi), %xmm0
; AVX512BW-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vinsertf32x4 $2, (%rdx), %zmm0, %zmm0
; AVX512BW-NEXT:    vmovaps {{.*#+}} zmm1 = [0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u]
; AVX512BW-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512BW-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride3_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vinsertf32x4 $2, (%rdx), %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vmovaps {{.*#+}} zmm1 = [0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512BW-FCP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride3_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vinsertf32x4 $2, (%rdx), %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vmovaps {{.*#+}} zmm1 = [0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512DQ-BW-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride3_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vinsertf32x4 $2, (%rdx), %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovaps {{.*#+}} zmm1 = [0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <4 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <4 x i32> %in.vec0, <4 x i32> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %in.vec2, <4 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <8 x i32> %1, <8 x i32> %2, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %interleaved.vec = shufflevector <12 x i32> %3, <12 x i32> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    movaps 16(%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm5
; SSE-NEXT:    movaps 16(%rsi), %xmm6
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps 16(%rdx), %xmm3
; SSE-NEXT:    movaps %xmm0, %xmm7
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm6[1]
; SSE-NEXT:    movaps %xmm0, %xmm8
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm6[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,2],xmm7[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm3[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm1, %xmm7
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm5[1]
; SSE-NEXT:    movaps %xmm1, %xmm8
; SSE-NEXT:    movaps %xmm1, %xmm9
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm5[0],xmm9[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm5[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm7[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm2[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm8[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm3[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,2],xmm2[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0,1,3]
; SSE-NEXT:    movaps %xmm9, (%rcx)
; SSE-NEXT:    movaps %xmm5, 16(%rcx)
; SSE-NEXT:    movaps %xmm4, 48(%rcx)
; SSE-NEXT:    movaps %xmm6, 64(%rcx)
; SSE-NEXT:    movaps %xmm1, 32(%rcx)
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride3_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovapd (%rdx), %ymm0
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vmovaps 16(%rsi), %xmm2
; AVX-NEXT:    vmovaps (%rdi), %xmm3
; AVX-NEXT:    vmovaps 16(%rdi), %xmm4
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm3[1],xmm1[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm5 = xmm1[1,1],xmm5[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,0],xmm3[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX-NEXT:    vbroadcastsd (%rdx), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2],ymm1[3,4],ymm3[5],ymm1[6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm4[3,3],xmm2[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm4[1],xmm2[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[1,1],xmm4[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3],ymm3[4],ymm2[5,6],ymm3[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm3 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm4 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1],ymm3[2],ymm4[3,4],ymm3[5],ymm4[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1,2],ymm0[3],ymm3[4,5],ymm0[6],ymm3[7]
; AVX-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX-NEXT:    vmovaps %ymm2, 64(%rcx)
; AVX-NEXT:    vmovaps %ymm1, (%rcx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride3_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vpermilps {{.*#+}} xmm3 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7]
; AVX2-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-NEXT:    vbroadcastsd 24(%rdi), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm1[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2,3],ymm5[4],ymm4[5,6],ymm5[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-NEXT:    vmovaps %ymm4, 64(%rcx)
; AVX2-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride3_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm3 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7]
; AVX2-FP-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-FP-NEXT:    vbroadcastsd 24(%rdi), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm1[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2,3],ymm5[4],ymm4[5,6],ymm5[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm4, 64(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride3_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm3 = [1,0,2,2,1,0,2,2]
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7]
; AVX2-FCP-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm4[2],ymm0[3,4],ymm4[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm2[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm0[1,2],ymm4[3],ymm0[4,5],ymm4[6],ymm0[7]
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm4 = [5,0,7,6,5,0,7,6]
; AVX2-FCP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm4, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd 24(%rdi), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm4[2],ymm1[3,4],ymm4[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5,6],ymm2[7]
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [13,21,6,14,22,7,15,23]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride3_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [13,21,6,14,22,7,15,23]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512-FCP-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride3_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [13,21,6,14,22,7,15,23]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512DQ-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride3_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [13,21,6,14,22,7,15,23]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride3_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [13,21,6,14,22,7,15,23]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512BW-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride3_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [13,21,6,14,22,7,15,23]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride3_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [13,21,6,14,22,7,15,23]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride3_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [13,21,6,14,22,7,15,23]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <8 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <8 x i32> %in.vec0, <8 x i32> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i32> %in.vec2, <8 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <16 x i32> %1, <16 x i32> %2, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %interleaved.vec = shufflevector <24 x i32> %3, <24 x i32> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    movaps 16(%rdi), %xmm2
; SSE-NEXT:    movaps 32(%rdi), %xmm4
; SSE-NEXT:    movaps 48(%rdi), %xmm5
; SSE-NEXT:    movaps (%rsi), %xmm7
; SSE-NEXT:    movaps 16(%rsi), %xmm9
; SSE-NEXT:    movaps 32(%rsi), %xmm10
; SSE-NEXT:    movaps 48(%rsi), %xmm11
; SSE-NEXT:    movaps 16(%rdx), %xmm0
; SSE-NEXT:    movaps 32(%rdx), %xmm3
; SSE-NEXT:    movaps 48(%rdx), %xmm8
; SSE-NEXT:    movaps %xmm5, %xmm12
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm11[1]
; SSE-NEXT:    movaps %xmm5, %xmm13
; SSE-NEXT:    movaps %xmm5, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm11[0],xmm6[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm11[3,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[1,1],xmm8[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm12[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[1,1],xmm8[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm13[2,0]
; SSE-NEXT:    movaps %xmm4, %xmm13
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm10[1]
; SSE-NEXT:    movaps %xmm4, %xmm14
; SSE-NEXT:    movaps %xmm4, %xmm12
; SSE-NEXT:    unpcklps {{.*#+}} xmm12 = xmm12[0],xmm10[0],xmm12[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm10[3,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm13[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[1,1],xmm3[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm14[2,0]
; SSE-NEXT:    movaps %xmm2, %xmm14
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm9[1]
; SSE-NEXT:    movaps %xmm2, %xmm15
; SSE-NEXT:    movaps %xmm2, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm9[0],xmm13[1],xmm9[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm9[3,3]
; SSE-NEXT:    movaps %xmm0, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm14[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[1,1],xmm0[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm15[2,0]
; SSE-NEXT:    movaps %xmm1, %xmm14
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm7[1]
; SSE-NEXT:    movaps %xmm1, %xmm15
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm7[0],xmm15[1],xmm7[1]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm7[3,3]
; SSE-NEXT:    movaps (%rdx), %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2],xmm14[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm3[2,0]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = xmm5[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[1,2],mem[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,2],xmm8[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,2],xmm0[2,3]
; SSE-NEXT:    movaps %xmm15, (%rcx)
; SSE-NEXT:    movaps %xmm7, 16(%rcx)
; SSE-NEXT:    movaps %xmm13, 48(%rcx)
; SSE-NEXT:    movaps %xmm9, 64(%rcx)
; SSE-NEXT:    movaps %xmm12, 96(%rcx)
; SSE-NEXT:    movaps %xmm10, 112(%rcx)
; SSE-NEXT:    movaps %xmm6, 144(%rcx)
; SSE-NEXT:    movaps %xmm11, 160(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0,1,3]
; SSE-NEXT:    movaps %xmm1, 32(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0,1,3]
; SSE-NEXT:    movaps %xmm2, 80(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0,1,3]
; SSE-NEXT:    movaps %xmm4, 128(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0,1,3]
; SSE-NEXT:    movaps %xmm5, 176(%rcx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride3_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovapd (%rdx), %ymm1
; AVX-NEXT:    vmovapd 32(%rdx), %ymm0
; AVX-NEXT:    vmovaps (%rsi), %xmm2
; AVX-NEXT:    vmovaps 16(%rsi), %xmm3
; AVX-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX-NEXT:    vmovaps 48(%rsi), %xmm5
; AVX-NEXT:    vmovaps (%rdi), %xmm6
; AVX-NEXT:    vmovaps 16(%rdi), %xmm7
; AVX-NEXT:    vmovaps 32(%rdi), %xmm8
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm6[1],xmm2[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm9 = xmm2[1,1],xmm9[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm2[0],xmm6[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[2,0],xmm6[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm2, %ymm2
; AVX-NEXT:    vbroadcastsd (%rdx), %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm6[2],ymm2[3,4],ymm6[5],ymm2[6,7]
; AVX-NEXT:    vmovaps 48(%rdi), %xmm6
; AVX-NEXT:    vshufps {{.*#+}} xmm9 = xmm6[3,3],xmm5[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm5[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[1,1],xmm6[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm5, %ymm5
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm0[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3],ymm6[4],ymm5[5,6],ymm6[7]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm8[1],xmm4[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm6 = xmm4[1,1],xmm6[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm4[0],xmm8[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[2,0],xmm8[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX-NEXT:    vbroadcastsd 32(%rdx), %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm6[2],ymm4[3,4],ymm6[5],ymm4[6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm6 = xmm7[3,3],xmm3[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm7[1],xmm3[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[1,1],xmm7[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm3, %ymm3
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm1[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm6[1],ymm3[2,3],ymm6[4],ymm3[5,6],ymm6[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm6 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm7 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2],ymm7[3,4],ymm6[5],ymm7[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1,2],ymm1[3],ymm6[4,5],ymm1[6],ymm6[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm6 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm7 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2],ymm7[3,4],ymm6[5],ymm7[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm6[1,2],ymm0[3],ymm6[4,5],ymm0[6],ymm6[7]
; AVX-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX-NEXT:    vmovaps %ymm3, 64(%rcx)
; AVX-NEXT:    vmovaps %ymm4, 96(%rcx)
; AVX-NEXT:    vmovaps %ymm5, 160(%rcx)
; AVX-NEXT:    vmovaps %ymm2, (%rcx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride3_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm4
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm5
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-NEXT:    vmovaps (%rdx), %ymm6
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-NEXT:    vpermilps {{.*#+}} xmm2 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm4[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm7[0],ymm2[1],ymm7[2,3],ymm2[4],ymm7[5,6],ymm2[7]
; AVX2-NEXT:    vbroadcastsd (%rdx), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm7[2],ymm2[3,4],ymm7[5],ymm2[6,7]
; AVX2-NEXT:    vbroadcastsd 56(%rdi), %ymm7
; AVX2-NEXT:    vshufps {{.*#+}} ymm8 = ymm3[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3,4],ymm7[5],ymm8[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm1[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3],ymm8[4],ymm7[5,6],ymm8[7]
; AVX2-NEXT:    vpermilps {{.*#+}} xmm8 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm0[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3],ymm8[4],ymm9[5,6],ymm8[7]
; AVX2-NEXT:    vbroadcastsd 32(%rdx), %ymm9
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4],ymm9[5],ymm8[6,7]
; AVX2-NEXT:    vbroadcastsd 24(%rdi), %ymm9
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2],ymm10[3,4],ymm9[5],ymm10[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm6[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1],ymm9[2,3],ymm10[4],ymm9[5,6],ymm10[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm6[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0],ymm4[1,2],ymm5[3],ymm4[4,5],ymm5[6],ymm4[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm3[2],ymm0[3,4],ymm3[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX2-NEXT:    vmovaps %ymm9, 64(%rcx)
; AVX2-NEXT:    vmovaps %ymm8, 96(%rcx)
; AVX2-NEXT:    vmovaps %ymm7, 160(%rcx)
; AVX2-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride3_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm4
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm5
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm6
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm2 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm4[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm7[0],ymm2[1],ymm7[2,3],ymm2[4],ymm7[5,6],ymm2[7]
; AVX2-FP-NEXT:    vbroadcastsd (%rdx), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm7[2],ymm2[3,4],ymm7[5],ymm2[6,7]
; AVX2-FP-NEXT:    vbroadcastsd 56(%rdi), %ymm7
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm8 = ymm3[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3,4],ymm7[5],ymm8[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm1[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3],ymm8[4],ymm7[5,6],ymm8[7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm8 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm0[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3],ymm8[4],ymm9[5,6],ymm8[7]
; AVX2-FP-NEXT:    vbroadcastsd 32(%rdx), %ymm9
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4],ymm9[5],ymm8[6,7]
; AVX2-FP-NEXT:    vbroadcastsd 24(%rdi), %ymm9
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2],ymm10[3,4],ymm9[5],ymm10[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm6[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1],ymm9[2,3],ymm10[4],ymm9[5,6],ymm10[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm6[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0],ymm4[1,2],ymm5[3],ymm4[4,5],ymm5[6],ymm4[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm3[2],ymm0[3,4],ymm3[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm9, 64(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm8, 96(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm7, 160(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride3_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm4
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm5
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm6
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm3[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1],ymm0[2],ymm7[3,4],ymm0[5],ymm7[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm5[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0],ymm0[1,2],ymm7[3],ymm0[4,5],ymm7[6],ymm0[7]
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm7 = [1,0,2,2,1,0,2,2]
; AVX2-FCP-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm3, %ymm7, %ymm8
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm8[1],ymm1[2,3],ymm8[4],ymm1[5,6],ymm8[7]
; AVX2-FCP-NEXT:    vbroadcastsd (%rdx), %ymm8
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm8[2],ymm1[3,4],ymm8[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm8 = ymm4[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm2[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1],ymm8[2],ymm9[3,4],ymm8[5],ymm9[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm6[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0],ymm8[1,2],ymm9[3],ymm8[4,5],ymm9[6],ymm8[7]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm9 = [5,6,5,6,5,6,7,7]
; AVX2-FCP-NEXT:    vpermps %ymm4, %ymm9, %ymm10
; AVX2-FCP-NEXT:    vbroadcastsd 56(%rdi), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2],ymm10[3,4],ymm11[5],ymm10[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm10[0],ymm6[1],ymm10[2,3],ymm6[4],ymm10[5,6],ymm6[7]
; AVX2-FCP-NEXT:    vpermps %ymm4, %ymm7, %ymm4
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3],ymm4[4],ymm2[5,6],ymm4[7]
; AVX2-FCP-NEXT:    vbroadcastsd 32(%rdx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4],ymm4[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermps %ymm3, %ymm9, %ymm3
; AVX2-FCP-NEXT:    vbroadcastsd 24(%rdi), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm5[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3],ymm4[4],ymm3[5,6],ymm4[7]
; AVX2-FCP-NEXT:    vmovaps %ymm3, 64(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 96(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 160(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 128(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride3_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride3_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride3_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride3_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride3_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride3_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride3_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <16 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <16 x i32> %in.vec0, <16 x i32> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i32> %in.vec2, <16 x i32> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <32 x i32> %1, <32 x i32> %2, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %interleaved.vec = shufflevector <48 x i32> %3, <48 x i32> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $152, %rsp
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    movaps 16(%rdi), %xmm2
; SSE-NEXT:    movaps 32(%rdi), %xmm3
; SSE-NEXT:    movaps 48(%rdi), %xmm4
; SSE-NEXT:    movaps (%rsi), %xmm10
; SSE-NEXT:    movaps 16(%rsi), %xmm13
; SSE-NEXT:    movaps 32(%rsi), %xmm12
; SSE-NEXT:    movaps 48(%rsi), %xmm9
; SSE-NEXT:    movaps (%rdx), %xmm5
; SSE-NEXT:    movaps 16(%rdx), %xmm6
; SSE-NEXT:    movaps 32(%rdx), %xmm7
; SSE-NEXT:    movaps 48(%rdx), %xmm8
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm5[0,3]
; SSE-NEXT:    movaps %xmm5, %xmm11
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm10[0],xmm5[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm10[3,3]
; SSE-NEXT:    movaps %xmm1, %xmm15
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,1],xmm11[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm6[0,3]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm13[0],xmm1[1],xmm13[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm13[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm13[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[1,1],xmm6[1,1]
; SSE-NEXT:    movaps %xmm6, %xmm14
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm7[0,3]
; SSE-NEXT:    movaps %xmm3, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm12[0],xmm2[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm12[3,3]
; SSE-NEXT:    movaps %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm8[0,3]
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm9[0],xmm1[1],xmm9[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm9[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm9[3,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[1,1],xmm8[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm9
; SSE-NEXT:    movaps 64(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rsi), %xmm12
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm12[0],xmm1[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[3,3],xmm12[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,2],xmm0[0,2]
; SSE-NEXT:    movaps 80(%rdi), %xmm10
; SSE-NEXT:    movaps 80(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rsi), %xmm8
; SSE-NEXT:    movaps %xmm10, %xmm11
; SSE-NEXT:    unpcklps {{.*#+}} xmm11 = xmm11[0],xmm8[0],xmm11[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[3,3],xmm8[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,2],xmm0[0,2]
; SSE-NEXT:    movaps 96(%rdi), %xmm4
; SSE-NEXT:    movaps 96(%rdx), %xmm13
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm13[0,3]
; SSE-NEXT:    movaps 96(%rsi), %xmm5
; SSE-NEXT:    movaps %xmm4, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm5[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm13[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm0[0,2]
; SSE-NEXT:    movaps 112(%rdi), %xmm0
; SSE-NEXT:    movaps 112(%rdx), %xmm7
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm7[0,3]
; SSE-NEXT:    movaps 112(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm2[0,2]
; SSE-NEXT:    movaps %xmm15, %xmm2
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[1,2],mem[2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[1,2],xmm14[2,3]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm15 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    # xmm15 = xmm15[1,2],mem[2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; SSE-NEXT:    # xmm14 = xmm14[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    # xmm9 = xmm9[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = xmm10[1,2],mem[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,2],xmm13[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm7[2,3]
; SSE-NEXT:    movaps %xmm1, 352(%rcx)
; SSE-NEXT:    movaps %xmm3, 336(%rcx)
; SSE-NEXT:    movaps %xmm5, 304(%rcx)
; SSE-NEXT:    movaps %xmm6, 288(%rcx)
; SSE-NEXT:    movaps %xmm8, 256(%rcx)
; SSE-NEXT:    movaps %xmm11, 240(%rcx)
; SSE-NEXT:    movaps %xmm12, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 368(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0,1,3]
; SSE-NEXT:    movaps %xmm4, 320(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,0,1,3]
; SSE-NEXT:    movaps %xmm10, 272(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0,1,3]
; SSE-NEXT:    movaps %xmm9, 224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps %xmm15, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm15[1,3]
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm2[1,3]
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    addq $152, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride3_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovapd (%rdx), %ymm4
; AVX-NEXT:    vmovapd 32(%rdx), %ymm2
; AVX-NEXT:    vmovapd 64(%rdx), %ymm3
; AVX-NEXT:    vmovapd 96(%rdx), %ymm0
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vmovaps 16(%rsi), %xmm7
; AVX-NEXT:    vmovaps 32(%rsi), %xmm10
; AVX-NEXT:    vmovaps 48(%rsi), %xmm9
; AVX-NEXT:    vmovaps (%rdi), %xmm5
; AVX-NEXT:    vmovaps 16(%rdi), %xmm8
; AVX-NEXT:    vmovaps 32(%rdi), %xmm11
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm5[1],xmm1[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm6 = xmm1[1,1],xmm6[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,0],xmm5[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX-NEXT:    vbroadcastsd (%rdx), %ymm5
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm5[2],ymm1[3,4],ymm5[5],ymm1[6,7]
; AVX-NEXT:    vmovaps 80(%rsi), %xmm5
; AVX-NEXT:    vmovaps 80(%rdi), %xmm6
; AVX-NEXT:    vshufps {{.*#+}} xmm12 = xmm6[3,3],xmm5[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm5[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[1,1],xmm6[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm5, %ymm5
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm3[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3],ymm6[4],ymm5[5,6],ymm6[7]
; AVX-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX-NEXT:    vmovaps 64(%rdi), %xmm12
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm13 = xmm12[1],xmm6[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm13 = xmm6[1,1],xmm13[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm6[0],xmm12[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm6 = xmm6[2,0],xmm12[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm6, %ymm6
; AVX-NEXT:    vbroadcastsd 64(%rdx), %ymm12
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm12[2],ymm6[3,4],ymm12[5],ymm6[6,7]
; AVX-NEXT:    vmovaps 48(%rdi), %xmm12
; AVX-NEXT:    vshufps {{.*#+}} xmm13 = xmm12[3,3],xmm9[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm12 = xmm12[1],xmm9[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[1,1],xmm12[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm9, %ymm9
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm2[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm12 = ymm12[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm12[1],ymm9[2,3],ymm12[4],ymm9[5,6],ymm12[7]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm12 = xmm11[1],xmm10[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm12 = xmm10[1,1],xmm12[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm10 = xmm10[0],xmm11[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm10 = xmm10[2,0],xmm11[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm10, %ymm10
; AVX-NEXT:    vbroadcastsd 32(%rdx), %ymm11
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2],ymm10[3,4],ymm11[5],ymm10[6,7]
; AVX-NEXT:    vmovaps 112(%rsi), %xmm11
; AVX-NEXT:    vmovaps 112(%rdi), %xmm12
; AVX-NEXT:    vshufps {{.*#+}} xmm13 = xmm12[3,3],xmm11[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm12 = xmm12[1],xmm11[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[1,1],xmm12[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm11, %ymm11
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm0[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm12 = ymm12[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm12[1],ymm11[2,3],ymm12[4],ymm11[5,6],ymm12[7]
; AVX-NEXT:    vmovaps 96(%rsi), %xmm12
; AVX-NEXT:    vmovaps 96(%rdi), %xmm13
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm14 = xmm13[1],xmm12[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm14 = xmm12[1,1],xmm14[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm12 = xmm12[0],xmm13[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm12 = xmm12[2,0],xmm13[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm12, %ymm12
; AVX-NEXT:    vbroadcastsd 96(%rdx), %ymm13
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm13[2],ymm12[3,4],ymm13[5],ymm12[6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm13 = xmm8[3,3],xmm7[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm8[1],xmm7[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[1,1],xmm8[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm7, %ymm7
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm4[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm8 = ymm8[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3],ymm8[4],ymm7[5,6],ymm8[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1],ymm8[2],ymm13[3,4],ymm8[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm8[1,2],ymm4[3],ymm8[4,5],ymm4[6],ymm8[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1],ymm8[2],ymm13[3,4],ymm8[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm8[1,2],ymm3[3],ymm8[4,5],ymm3[6],ymm8[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1],ymm8[2],ymm13[3,4],ymm8[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm8[1,2],ymm2[3],ymm8[4,5],ymm2[6],ymm8[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1],ymm8[2],ymm13[3,4],ymm8[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm8[1,2],ymm0[3],ymm8[4,5],ymm0[6],ymm8[7]
; AVX-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX-NEXT:    vmovaps %ymm2, 128(%rcx)
; AVX-NEXT:    vmovaps %ymm3, 224(%rcx)
; AVX-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX-NEXT:    vmovaps %ymm7, 64(%rcx)
; AVX-NEXT:    vmovaps %ymm12, 288(%rcx)
; AVX-NEXT:    vmovaps %ymm11, 352(%rcx)
; AVX-NEXT:    vmovaps %ymm10, 96(%rcx)
; AVX-NEXT:    vmovaps %ymm9, 160(%rcx)
; AVX-NEXT:    vmovaps %ymm6, 192(%rcx)
; AVX-NEXT:    vmovaps %ymm5, 256(%rcx)
; AVX-NEXT:    vmovaps %ymm1, (%rcx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride3_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $40, %rsp
; AVX2-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm6
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm9
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm10
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm3
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm8[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm0[1],ymm4[2,3],ymm0[4],ymm4[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm4[2],ymm0[3,4],ymm4[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vbroadcastsd 88(%rdi), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm11 = ymm9[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm11[0,1],ymm4[2],ymm11[3,4],ymm4[5],ymm11[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm10[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm11[1],ymm4[2,3],ymm11[4],ymm4[5,6],ymm11[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm11 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm12 = ymm6[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0],ymm11[1],ymm12[2,3],ymm11[4],ymm12[5,6],ymm11[7]
; AVX2-NEXT:    vbroadcastsd 64(%rdx), %ymm12
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1],ymm12[2],ymm11[3,4],ymm12[5],ymm11[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastsd 56(%rdi), %ymm12
; AVX2-NEXT:    vshufps {{.*#+}} ymm13 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm7[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm12[0],ymm13[1],ymm12[2,3],ymm13[4],ymm12[5,6],ymm13[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm13 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,1,0,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm14 = ymm1[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1],ymm14[2,3],ymm13[4],ymm14[5,6],ymm13[7]
; AVX2-NEXT:    vbroadcastsd 32(%rdx), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm13[0,1],ymm14[2],ymm13[3,4],ymm14[5],ymm13[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastsd 120(%rdi), %ymm14
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm2[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2],ymm15[3,4],ymm14[5],ymm15[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm3[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1],ymm14[2,3],ymm15[4],ymm14[5,6],ymm15[7]
; AVX2-NEXT:    vpermilps {{.*#+}} xmm15 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,0,1]
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm15[1],ymm4[2,3],ymm15[4],ymm4[5,6],ymm15[7]
; AVX2-NEXT:    vbroadcastsd 96(%rdx), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm15 = ymm4[0,1],ymm15[2],ymm4[3,4],ymm15[5],ymm4[6,7]
; AVX2-NEXT:    vmovaps (%rsi), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm11 = ymm4[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-NEXT:    vbroadcastsd 24(%rdi), %ymm12
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm12[2],ymm11[3,4],ymm12[5],ymm11[6,7]
; AVX2-NEXT:    vmovaps (%rdx), %ymm12
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm12[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm13[1],ymm11[2,3],ymm13[4],ymm11[5,6],ymm13[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm8[0,1],ymm4[2],ymm8[3,4],ymm4[5],ymm8[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm12[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm8[0],ymm4[1,2],ymm8[3],ymm4[4,5],ymm8[6],ymm4[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm8 = ymm9[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm8[2],ymm6[3,4],ymm8[5],ymm6[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm10[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm8[0],ymm6[1,2],ymm8[3],ymm6[4,5],ymm8[6],ymm6[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm5[2],ymm1[3,4],ymm5[5],ymm1[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm7[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0],ymm1[1,2],ymm5[3],ymm1[4,5],ymm5[6],ymm1[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2],ymm0[3,4],ymm2[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm3[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2],ymm2[3],ymm0[4,5],ymm2[6],ymm0[7]
; AVX2-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-NEXT:    vmovaps %ymm6, 224(%rcx)
; AVX2-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX2-NEXT:    vmovaps %ymm11, 64(%rcx)
; AVX2-NEXT:    vmovaps %ymm15, 288(%rcx)
; AVX2-NEXT:    vmovaps %ymm14, 352(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-NEXT:    addq $40, %rsp
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride3_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $40, %rsp
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm6
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm9
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm10
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm3
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm8[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm0[1],ymm4[2,3],ymm0[4],ymm4[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm4[2],ymm0[3,4],ymm4[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastsd 88(%rdi), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm11 = ymm9[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm11[0,1],ymm4[2],ymm11[3,4],ymm4[5],ymm11[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm10[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm11[1],ymm4[2,3],ymm11[4],ymm4[5,6],ymm11[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm11 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm12 = ymm6[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0],ymm11[1],ymm12[2,3],ymm11[4],ymm12[5,6],ymm11[7]
; AVX2-FP-NEXT:    vbroadcastsd 64(%rdx), %ymm12
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1],ymm12[2],ymm11[3,4],ymm12[5],ymm11[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastsd 56(%rdi), %ymm12
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm13 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm7[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm12[0],ymm13[1],ymm12[2,3],ymm13[4],ymm12[5,6],ymm13[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm13 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,1,0,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm1[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1],ymm14[2,3],ymm13[4],ymm14[5,6],ymm13[7]
; AVX2-FP-NEXT:    vbroadcastsd 32(%rdx), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm13[0,1],ymm14[2],ymm13[3,4],ymm14[5],ymm13[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastsd 120(%rdi), %ymm14
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm2[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2],ymm15[3,4],ymm14[5],ymm15[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm3[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1],ymm14[2,3],ymm15[4],ymm14[5,6],ymm15[7]
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm15 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,0,1]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm15[1],ymm4[2,3],ymm15[4],ymm4[5,6],ymm15[7]
; AVX2-FP-NEXT:    vbroadcastsd 96(%rdx), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm15 = ymm4[0,1],ymm15[2],ymm4[3,4],ymm15[5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm11 = ymm4[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 24(%rdi), %ymm12
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm12[2],ymm11[3,4],ymm12[5],ymm11[6,7]
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm12
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm12[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm13[1],ymm11[2,3],ymm13[4],ymm11[5,6],ymm13[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm8[0,1],ymm4[2],ymm8[3,4],ymm4[5],ymm8[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm12[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm8[0],ymm4[1,2],ymm8[3],ymm4[4,5],ymm8[6],ymm4[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm8 = ymm9[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm8[2],ymm6[3,4],ymm8[5],ymm6[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm10[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm8[0],ymm6[1,2],ymm8[3],ymm6[4,5],ymm8[6],ymm6[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm5[2],ymm1[3,4],ymm5[5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm7[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0],ymm1[1,2],ymm5[3],ymm1[4,5],ymm5[6],ymm1[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2],ymm0[3,4],ymm2[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm3[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2],ymm2[3],ymm0[4,5],ymm2[6],ymm0[7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm6, 224(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm11, 64(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm15, 288(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm14, 352(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-FP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FP-NEXT:    addq $40, %rsp
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride3_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm7
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm11
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm10
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm13
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm12
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm14
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm4[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2],ymm5[3,4],ymm0[5],ymm5[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm0[1,2],ymm5[3],ymm0[4,5],ymm5[6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm8 = [1,0,2,2,1,0,2,2]
; AVX2-FCP-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm8, %ymm5
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2,3],ymm5[4],ymm4[5,6],ymm5[7]
; AVX2-FCP-NEXT:    vbroadcastsd (%rdx), %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm9 = [5,6,5,6,5,6,7,7]
; AVX2-FCP-NEXT:    vpermps %ymm13, %ymm9, %ymm5
; AVX2-FCP-NEXT:    vbroadcastsd 88(%rdi), %ymm6
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm6[2],ymm5[3,4],ymm6[5],ymm5[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm14[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3],ymm6[4],ymm5[5,6],ymm6[7]
; AVX2-FCP-NEXT:    vpermps %ymm13, %ymm8, %ymm6
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm11[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm15[0],ymm6[1],ymm15[2,3],ymm6[4],ymm15[5,6],ymm6[7]
; AVX2-FCP-NEXT:    vbroadcastsd 64(%rdx), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm15[2],ymm6[3,4],ymm15[5],ymm6[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm13 = ymm13[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm13[2],ymm11[3,4],ymm13[5],ymm11[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm14[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm13[0],ymm11[1,2],ymm13[3],ymm11[4,5],ymm13[6],ymm11[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm13 = ymm10[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm7[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1],ymm13[2],ymm14[3,4],ymm13[5],ymm14[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm12[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1,2],ymm14[3],ymm13[4,5],ymm14[6],ymm13[7]
; AVX2-FCP-NEXT:    vpermps %ymm10, %ymm9, %ymm14
; AVX2-FCP-NEXT:    vbroadcastsd 56(%rdi), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm15
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm12 = ymm14[0],ymm12[1],ymm14[2,3],ymm12[4],ymm14[5,6],ymm12[7]
; AVX2-FCP-NEXT:    vpermps %ymm10, %ymm8, %ymm10
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm10[1],ymm7[2,3],ymm10[4],ymm7[5,6],ymm10[7]
; AVX2-FCP-NEXT:    vbroadcastsd 32(%rdx), %ymm10
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm10[2],ymm7[3,4],ymm10[5],ymm7[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm10 = ymm15[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm3[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm14[0,1],ymm10[2],ymm14[3,4],ymm10[5],ymm14[6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm14
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm14[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm10[1,2],ymm0[3],ymm10[4,5],ymm0[6],ymm10[7]
; AVX2-FCP-NEXT:    vpermps %ymm15, %ymm9, %ymm10
; AVX2-FCP-NEXT:    vbroadcastsd 120(%rdi), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm10[0,1],ymm4[2],ymm10[3,4],ymm4[5],ymm10[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm14[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm10[1],ymm4[2,3],ymm10[4],ymm4[5,6],ymm10[7]
; AVX2-FCP-NEXT:    vpermps %ymm15, %ymm8, %ymm8
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm8[1],ymm3[2,3],ymm8[4],ymm3[5,6],ymm8[7]
; AVX2-FCP-NEXT:    vbroadcastsd 96(%rdx), %ymm8
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm8[2],ymm3[3,4],ymm8[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd 24(%rdi), %ymm8
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm8[2],ymm1[3,4],ymm8[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5,6],ymm2[7]
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 288(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 352(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 96(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm12, 160(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm13, 128(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm11, 224(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 192(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 256(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-NEXT:    vpermt2d %zmm2, %zmm6, %zmm7
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512-NEXT:    vpermt2d %zmm4, %zmm8, %zmm7
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512-NEXT:    vpermt2d %zmm3, %zmm9, %zmm10
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512-NEXT:    vpermt2d %zmm5, %zmm11, %zmm10
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512-NEXT:    vpermt2d %zmm1, %zmm12, %zmm13
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512-NEXT:    vpermt2d %zmm5, %zmm14, %zmm13
; AVX512-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512-NEXT:    vpermt2d %zmm5, %zmm8, %zmm1
; AVX512-NEXT:    vpermi2d %zmm2, %zmm0, %zmm9
; AVX512-NEXT:    vpermt2d %zmm4, %zmm11, %zmm9
; AVX512-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512-NEXT:    vpermt2d %zmm4, %zmm14, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride3_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm6, %zmm7
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm7
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm9, %zmm10
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm11, %zmm10
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512-FCP-NEXT:    vpermt2d %zmm1, %zmm12, %zmm13
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm14, %zmm13
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm8, %zmm1
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm9
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm11, %zmm9
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm14, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride3_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm6, %zmm7
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm8, %zmm7
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm9, %zmm10
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm11, %zmm10
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-NEXT:    vpermt2d %zmm1, %zmm12, %zmm13
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm14, %zmm13
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm8, %zmm1
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm0, %zmm9
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm11, %zmm9
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm14, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 64(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride3_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm6, %zmm7
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm7
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm9, %zmm10
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm11, %zmm10
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm1, %zmm12, %zmm13
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm14, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm8, %zmm1
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm11, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm14, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride3_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm6, %zmm7
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm8, %zmm7
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm9, %zmm10
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm11, %zmm10
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm12, %zmm13
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm14, %zmm13
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm8, %zmm1
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm0, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm11, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm14, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride3_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm6, %zmm7
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm7
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm9, %zmm10
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm11, %zmm10
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2d %zmm1, %zmm12, %zmm13
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm14, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm8, %zmm1
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2d %zmm4, %zmm11, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2d %zmm4, %zmm14, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride3_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm6, %zmm7
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm4, %zmm8, %zmm7
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm9, %zmm10
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm11, %zmm10
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2d %zmm1, %zmm12, %zmm13
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm14, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm8, %zmm1
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm0, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2d %zmm4, %zmm11, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2d %zmm4, %zmm14, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 64(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride3_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm6, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm9 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm9, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm11 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm11, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm1, %zmm12, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm14, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm8, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm4, %zmm11, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm4, %zmm14, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <32 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <32 x i32> %in.vec0, <32 x i32> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i32> %in.vec2, <32 x i32> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <64 x i32> %1, <64 x i32> %2, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %interleaved.vec = shufflevector <96 x i32> %3, <96 x i32> poison, <96 x i32> <i32 0, i32 32, i32 64, i32 1, i32 33, i32 65, i32 2, i32 34, i32 66, i32 3, i32 35, i32 67, i32 4, i32 36, i32 68, i32 5, i32 37, i32 69, i32 6, i32 38, i32 70, i32 7, i32 39, i32 71, i32 8, i32 40, i32 72, i32 9, i32 41, i32 73, i32 10, i32 42, i32 74, i32 11, i32 43, i32 75, i32 12, i32 44, i32 76, i32 13, i32 45, i32 77, i32 14, i32 46, i32 78, i32 15, i32 47, i32 79, i32 16, i32 48, i32 80, i32 17, i32 49, i32 81, i32 18, i32 50, i32 82, i32 19, i32 51, i32 83, i32 20, i32 52, i32 84, i32 21, i32 53, i32 85, i32 22, i32 54, i32 86, i32 23, i32 55, i32 87, i32 24, i32 56, i32 88, i32 25, i32 57, i32 89, i32 26, i32 58, i32 90, i32 27, i32 59, i32 91, i32 28, i32 60, i32 92, i32 29, i32 61, i32 93, i32 30, i32 62, i32 94, i32 31, i32 63, i32 95>
  store <96 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $664, %rsp # imm = 0x298
; SSE-NEXT:    movaps (%rdi), %xmm2
; SSE-NEXT:    movaps 16(%rdi), %xmm4
; SSE-NEXT:    movaps 32(%rdi), %xmm5
; SSE-NEXT:    movaps 48(%rdi), %xmm6
; SSE-NEXT:    movaps (%rsi), %xmm0
; SSE-NEXT:    movaps 16(%rsi), %xmm11
; SSE-NEXT:    movaps 32(%rsi), %xmm14
; SSE-NEXT:    movaps 48(%rsi), %xmm3
; SSE-NEXT:    movaps (%rdx), %xmm7
; SSE-NEXT:    movaps 16(%rdx), %xmm8
; SSE-NEXT:    movaps 32(%rdx), %xmm9
; SSE-NEXT:    movaps 48(%rdx), %xmm10
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm7[0,3]
; SSE-NEXT:    movaps %xmm7, %xmm12
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm7
; SSE-NEXT:    unpcklps {{.*#+}} xmm7 = xmm7[0],xmm0[0],xmm7[1],xmm0[1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm0[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm12[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm8[0,3]
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm11[3,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[1,1],xmm8[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm9[0,3]
; SSE-NEXT:    movaps %xmm5, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm14[0],xmm1[1],xmm14[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm14[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm14[3,3]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[1,1],xmm9[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm0
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm10[0,3]
; SSE-NEXT:    movaps %xmm6, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[3,3],xmm3[3,3]
; SSE-NEXT:    movaps %xmm6, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm10[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdi), %xmm2
; SSE-NEXT:    movaps 96(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdi), %xmm2
; SSE-NEXT:    movaps 112(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdi), %xmm2
; SSE-NEXT:    movaps 128(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdi), %xmm2
; SSE-NEXT:    movaps 144(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdi), %xmm14
; SSE-NEXT:    movaps 160(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm14, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[3,3],xmm1[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdi), %xmm12
; SSE-NEXT:    movaps 176(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm12, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[3,3],xmm1[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdi), %xmm13
; SSE-NEXT:    movaps 192(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm13, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rsi), %xmm11
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[3,3],xmm11[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm0[0,2]
; SSE-NEXT:    movaps 208(%rdi), %xmm6
; SSE-NEXT:    movaps 208(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rsi), %xmm8
; SSE-NEXT:    movaps %xmm6, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm8[0],xmm10[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm6, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[3,3],xmm8[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,2],xmm0[0,2]
; SSE-NEXT:    movaps 224(%rdi), %xmm5
; SSE-NEXT:    movaps 224(%rdx), %xmm15
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm15[0,3]
; SSE-NEXT:    movaps 224(%rsi), %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    unpcklps {{.*#+}} xmm7 = xmm7[0],xmm4[0],xmm7[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm15[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,2]
; SSE-NEXT:    movaps 240(%rdi), %xmm2
; SSE-NEXT:    movaps 240(%rdx), %xmm9
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm9[0,3]
; SSE-NEXT:    movaps 240(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm0[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm9[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; SSE-NEXT:    # xmm14 = xmm14[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    # xmm12 = xmm12[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = xmm13[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = xmm6[1,2],mem[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,2],xmm15[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,2],xmm9[2,3]
; SSE-NEXT:    movaps %xmm0, 736(%rcx)
; SSE-NEXT:    movaps %xmm3, 720(%rcx)
; SSE-NEXT:    movaps %xmm4, 688(%rcx)
; SSE-NEXT:    movaps %xmm7, 672(%rcx)
; SSE-NEXT:    movaps %xmm8, 640(%rcx)
; SSE-NEXT:    movaps %xmm10, 624(%rcx)
; SSE-NEXT:    movaps %xmm11, 592(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0,1,3]
; SSE-NEXT:    movaps %xmm2, 752(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0,1,3]
; SSE-NEXT:    movaps %xmm5, 704(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0,1,3]
; SSE-NEXT:    movaps %xmm6, 656(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,0,1,3]
; SSE-NEXT:    movaps %xmm13, 608(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,0,1,3]
; SSE-NEXT:    movaps %xmm12, 560(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,0,1,3]
; SSE-NEXT:    movaps %xmm14, 512(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 464(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 416(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 368(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 320(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 272(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 224(%rcx)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    addq $664, %rsp # imm = 0x298
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride3_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $200, %rsp
; AVX-NEXT:    vmovapd (%rdx), %ymm8
; AVX-NEXT:    vmovapd 32(%rdx), %ymm9
; AVX-NEXT:    vmovapd 64(%rdx), %ymm11
; AVX-NEXT:    vmovapd 96(%rdx), %ymm12
; AVX-NEXT:    vmovaps (%rsi), %xmm0
; AVX-NEXT:    vmovaps 16(%rsi), %xmm1
; AVX-NEXT:    vmovaps 32(%rsi), %xmm2
; AVX-NEXT:    vmovaps 48(%rsi), %xmm3
; AVX-NEXT:    vmovaps (%rdi), %xmm4
; AVX-NEXT:    vmovaps 16(%rdi), %xmm5
; AVX-NEXT:    vmovaps 32(%rdi), %xmm6
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm4[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm7 = xmm0[1,1],xmm7[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm4[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; AVX-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm4[2],ymm0[3,4],ymm4[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm5[3,3],xmm1[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm5[1],xmm1[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm8[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm6[1],xmm2[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm2[1,1],xmm0[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm6[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,0],xmm6[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vbroadcastsd 32(%rdx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 48(%rdi), %xmm0
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3],xmm3[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[1,1],xmm0[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm9[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %xmm0
; AVX-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[1,1],xmm2[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vbroadcastsd 64(%rdx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 80(%rsi), %xmm0
; AVX-NEXT:    vmovaps 80(%rdi), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm11[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[1,1],xmm2[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vbroadcastsd 96(%rdx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 112(%rsi), %xmm0
; AVX-NEXT:    vmovaps 112(%rdi), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm12[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[1,1],xmm2[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vbroadcastsd 128(%rdx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 144(%rsi), %xmm0
; AVX-NEXT:    vmovaps 144(%rdi), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX-NEXT:    vmovapd 128(%rdx), %ymm6
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm6[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[1,1],xmm2[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vbroadcastsd 160(%rdx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm14 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vmovaps 176(%rsi), %xmm0
; AVX-NEXT:    vmovaps 176(%rdi), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovapd 160(%rdx), %ymm4
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm15 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm0[1,1],xmm3[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX-NEXT:    vbroadcastsd 192(%rdx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX-NEXT:    vmovaps 208(%rsi), %xmm0
; AVX-NEXT:    vmovaps 208(%rdi), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm1[3,3],xmm0[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX-NEXT:    vmovapd 192(%rdx), %ymm2
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm2[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0],ymm3[1],ymm0[2,3],ymm3[4],ymm0[5,6],ymm3[7]
; AVX-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX-NEXT:    vmovaps 224(%rdi), %xmm3
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm3[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm5 = xmm0[1,1],xmm5[0,2]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm3[2,1]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; AVX-NEXT:    vbroadcastsd 224(%rdx), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm0[0,1],ymm3[2],ymm0[3,4],ymm3[5],ymm0[6,7]
; AVX-NEXT:    vmovaps 240(%rsi), %xmm0
; AVX-NEXT:    vmovaps 240(%rdi), %xmm3
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[3,3],xmm0[3,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm0[1]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm3[0,2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 224(%rdx), %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0],ymm3[1],ymm1[2,3],ymm3[4],ymm1[5,6],ymm3[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm1 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1],ymm1[2],ymm13[3,4],ymm1[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm8 = ymm8[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm1[1,2],ymm8[3],ymm1[4,5],ymm8[6],ymm1[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm1 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1],ymm1[2],ymm13[3,4],ymm1[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm9 = ymm9[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm1[1,2],ymm9[3],ymm1[4,5],ymm9[6],ymm1[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm1 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1],ymm1[2],ymm13[3,4],ymm1[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm11 = ymm11[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm11[0],ymm1[1,2],ymm11[3],ymm1[4,5],ymm11[6],ymm1[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm11 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm13[0,1],ymm11[2],ymm13[3,4],ymm11[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm12 = ymm12[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0],ymm11[1,2],ymm12[3],ymm11[4,5],ymm12[6],ymm11[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm12 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm12[1,2],ymm6[3],ymm12[4,5],ymm6[6],ymm12[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm12 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm12[1,2],ymm4[3],ymm12[4,5],ymm4[6],ymm12[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm12 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm12[1,2],ymm2[3],ymm12[4,5],ymm2[6],ymm12[7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm12 = mem[0,0,3,3,4,4,7,7]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm12[1,2],ymm0[3],ymm12[4,5],ymm0[6],ymm12[7]
; AVX-NEXT:    vmovaps %ymm0, 704(%rcx)
; AVX-NEXT:    vmovaps %ymm2, 608(%rcx)
; AVX-NEXT:    vmovaps %ymm4, 512(%rcx)
; AVX-NEXT:    vmovaps %ymm6, 416(%rcx)
; AVX-NEXT:    vmovaps %ymm11, 320(%rcx)
; AVX-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX-NEXT:    vmovaps %ymm9, 128(%rcx)
; AVX-NEXT:    vmovaps %ymm8, 32(%rcx)
; AVX-NEXT:    vmovaps %ymm3, 736(%rcx)
; AVX-NEXT:    vmovaps %ymm5, 672(%rcx)
; AVX-NEXT:    vmovaps %ymm7, 640(%rcx)
; AVX-NEXT:    vmovaps %ymm10, 576(%rcx)
; AVX-NEXT:    vmovaps %ymm15, 544(%rcx)
; AVX-NEXT:    vmovaps %ymm14, 480(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%rcx)
; AVX-NEXT:    addq $200, %rsp
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride3_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX2-NEXT:    vmovaps (%rdi), %ymm15
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm8
; AVX2-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm13
; AVX2-NEXT:    vmovaps (%rsi), %ymm5
; AVX2-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdx), %ymm7
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm6
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm4
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm15[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd (%rdx), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastsd 24(%rdi), %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm7[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm8[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd 32(%rdx), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastsd 56(%rdi), %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm13[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd 64(%rdx), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vbroadcastsd 88(%rdi), %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm4[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd 96(%rdx), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm14
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-NEXT:    vbroadcastsd 120(%rdi), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd 128(%rdx), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rsi), %ymm12
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm12[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-NEXT:    vbroadcastsd 152(%rdi), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 128(%rdx), %ymm10
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm10[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm9
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm9[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd 160(%rdx), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rsi), %ymm7
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm7[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-NEXT:    vbroadcastsd 184(%rdi), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 160(%rdx), %ymm6
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm5
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm5[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd 192(%rdx), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rsi), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-NEXT:    vbroadcastsd 216(%rdi), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 192(%rdx), %ymm3
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[0,0,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-NEXT:    vbroadcastsd 224(%rdx), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-NEXT:    vbroadcastsd 248(%rdi), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0,1],ymm8[2],ymm0[3,4],ymm8[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm11[1],ymm8[2,3],ymm11[4],ymm8[5,6],ymm11[7]
; AVX2-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm15[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1],ymm8[2],ymm11[3,4],ymm8[5],ymm11[6,7]
; AVX2-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm11 = mem[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm8[1,2],ymm11[3],ymm8[4,5],ymm11[6],ymm8[7]
; AVX2-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0,1],ymm8[2],ymm15[3,4],ymm8[5],ymm15[6,7]
; AVX2-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0],ymm8[1,2],ymm15[3],ymm8[4,5],ymm15[6],ymm8[7]
; AVX2-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4],ymm15[5],ymm13[6,7]
; AVX2-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2],ymm15[3],ymm13[4,5],ymm15[6],ymm13[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm14[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm14 = mem[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7]
; AVX2-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2],ymm15[3],ymm14[4,5],ymm15[6],ymm14[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm12 = ymm12[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd $165, (%rsp), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm15[0,1],ymm12[2],ymm15[3,4],ymm12[5],ymm15[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm12[1,2],ymm10[3],ymm12[4,5],ymm10[6],ymm12[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1],ymm7[2],ymm9[3,4],ymm7[5],ymm9[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1,2],ymm6[3],ymm7[4,5],ymm6[6],ymm7[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1,2],ymm3[3],ymm4[4,5],ymm3[6],ymm4[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vmovaps %ymm0, 704(%rcx)
; AVX2-NEXT:    vmovaps %ymm3, 608(%rcx)
; AVX2-NEXT:    vmovaps %ymm6, 512(%rcx)
; AVX2-NEXT:    vmovaps %ymm10, 416(%rcx)
; AVX2-NEXT:    vmovaps %ymm14, 320(%rcx)
; AVX2-NEXT:    vmovaps %ymm13, 224(%rcx)
; AVX2-NEXT:    vmovaps %ymm8, 128(%rcx)
; AVX2-NEXT:    vmovaps %ymm11, 32(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 736(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 672(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 640(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 544(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 480(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride3_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm15
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm8
; AVX2-FP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm13
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm5
; AVX2-FP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm7
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm6
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm4
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm15[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd (%rdx), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastsd 24(%rdi), %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm7[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm8[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd 32(%rdx), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastsd 56(%rdi), %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm13[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd 64(%rdx), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vbroadcastsd 88(%rdi), %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm4[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd 96(%rdx), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm14
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 120(%rdi), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd 128(%rdx), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %ymm12
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm12[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 152(%rdi), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %ymm10
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm10[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm9
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm9[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd 160(%rdx), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %ymm7
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm7[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 184(%rdi), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %ymm6
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm5
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm5[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd 192(%rdx), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 216(%rdi), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %ymm3
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FP-NEXT:    vbroadcastsd 224(%rdx), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,2,3,3,5,6,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FP-NEXT:    vbroadcastsd 248(%rdi), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0,1],ymm8[2],ymm0[3,4],ymm8[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm11[1],ymm8[2,3],ymm11[4],ymm8[5,6],ymm11[7]
; AVX2-FP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm15[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1],ymm8[2],ymm11[3,4],ymm8[5],ymm11[6,7]
; AVX2-FP-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm11 = mem[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm8[1,2],ymm11[3],ymm8[4,5],ymm11[6],ymm8[7]
; AVX2-FP-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0,1],ymm8[2],ymm15[3,4],ymm8[5],ymm15[6,7]
; AVX2-FP-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0],ymm8[1,2],ymm15[3],ymm8[4,5],ymm15[6],ymm8[7]
; AVX2-FP-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4],ymm15[5],ymm13[6,7]
; AVX2-FP-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2],ymm15[3],ymm13[4,5],ymm15[6],ymm13[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm14[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm14 = mem[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7]
; AVX2-FP-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2],ymm15[3],ymm14[4,5],ymm15[6],ymm14[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm12 = ymm12[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd $165, (%rsp), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm15[0,1],ymm12[2],ymm15[3,4],ymm12[5],ymm15[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm12[1,2],ymm10[3],ymm12[4,5],ymm10[6],ymm12[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1],ymm7[2],ymm9[3,4],ymm7[5],ymm9[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1,2],ymm6[3],ymm7[4,5],ymm6[6],ymm7[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1,2],ymm3[3],ymm4[4,5],ymm3[6],ymm4[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 704(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm3, 608(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm6, 512(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm10, 416(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm14, 320(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm13, 224(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm8, 128(%rcx)
; AVX2-FP-NEXT:    vmovaps %ymm11, 32(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 736(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 672(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 640(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 544(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 480(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FP-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride3_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $232, %rsp
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm6
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm12
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm8
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm10
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm9
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm4
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm13
; AVX2-FCP-NEXT:    vbroadcastf128 {{.*#+}} ymm7 = [1,0,2,2,1,0,2,2]
; AVX2-FCP-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpermps %ymm8, %ymm7, %ymm11
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm6[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm14[0],ymm11[1],ymm14[2,3],ymm11[4],ymm14[5,6],ymm11[7]
; AVX2-FCP-NEXT:    vbroadcastsd (%rdx), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm14[2],ymm11[3,4],ymm14[5],ymm11[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm11 = ymm8[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm11[2],ymm6[3,4],ymm11[5],ymm6[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm9[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm11[0],ymm6[1,2],ymm11[3],ymm6[4,5],ymm11[6],ymm6[7]
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm6 = [5,6,5,6,5,6,7,7]
; AVX2-FCP-NEXT:    vpermps %ymm8, %ymm6, %ymm8
; AVX2-FCP-NEXT:    vbroadcastsd 24(%rdi), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm11[2],ymm8[3,4],ymm11[5],ymm8[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm9[1],ymm8[2,3],ymm9[4],ymm8[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermps %ymm5, %ymm7, %ymm8
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm3[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3],ymm8[4],ymm9[5,6],ymm8[7]
; AVX2-FCP-NEXT:    vbroadcastsd 32(%rdx), %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4],ymm9[5],ymm8[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm8 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm8[2],ymm3[3,4],ymm8[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm4[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm8[0],ymm3[1,2],ymm8[3],ymm3[4,5],ymm8[6],ymm3[7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermps %ymm5, %ymm6, %ymm3
; AVX2-FCP-NEXT:    vbroadcastsd 56(%rdi), %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm5[2],ymm3[3,4],ymm5[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3],ymm4[4],ymm3[5,6],ymm4[7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermps %ymm10, %ymm7, %ymm3
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm1[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7]
; AVX2-FCP-NEXT:    vbroadcastsd 64(%rdx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm10[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2],ymm1[3,4],ymm3[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm2[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0],ymm1[1,2],ymm3[3],ymm1[4,5],ymm3[6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermps %ymm10, %ymm6, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd 88(%rdi), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2],ymm1[3,4],ymm3[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5,6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm7, %ymm1
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm12[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vbroadcastsd 96(%rdx), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4],ymm2[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm0[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm12[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm13[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2],ymm2[3],ymm1[4,5],ymm2[6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm6, %ymm0
; AVX2-FCP-NEXT:    vbroadcastsd 120(%rdi), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm13[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5,6],ymm2[7]
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm7, %ymm2
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm1[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3],ymm2[4],ymm3[5,6],ymm2[7]
; AVX2-FCP-NEXT:    vbroadcastsd 128(%rdx), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm0[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4],ymm2[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm2[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm15 = ymm3[0],ymm1[1,2],ymm3[3],ymm1[4,5],ymm3[6],ymm1[7]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm6, %ymm0
; AVX2-FCP-NEXT:    vbroadcastsd 152(%rdi), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm7, %ymm2
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm0[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3],ymm2[4],ymm3[5,6],ymm2[7]
; AVX2-FCP-NEXT:    vbroadcastsd 160(%rdx), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0,1],ymm2[2],ymm0[3,4],ymm2[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %ymm0
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm0[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0],ymm2[1,2],ymm5[3],ymm2[4,5],ymm5[6],ymm2[7]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm6, %ymm1
; AVX2-FCP-NEXT:    vbroadcastsd 184(%rdi), %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm5[2],ymm1[3,4],ymm5[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm5
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm7, %ymm1
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm5[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm9[0],ymm1[1],ymm9[2,3],ymm1[4],ymm9[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vbroadcastsd 192(%rdx), %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm9[2],ymm1[3,4],ymm9[5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[1,1,2,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm0[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm9[2],ymm5[3,4],ymm9[5],ymm5[6,7]
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %ymm9
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm9[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0],ymm5[1,2],ymm10[3],ymm5[4,5],ymm10[6],ymm5[7]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm6, %ymm0
; AVX2-FCP-NEXT:    vbroadcastsd 216(%rdi), %ymm10
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm10[2],ymm0[3,4],ymm10[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm9[1],ymm0[2,3],ymm9[4],ymm0[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %ymm9
; AVX2-FCP-NEXT:    vpermps %ymm9, %ymm7, %ymm7
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm10
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm10[0,0,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0],ymm7[1],ymm11[2,3],ymm7[4],ymm11[5,6],ymm7[7]
; AVX2-FCP-NEXT:    vbroadcastsd 224(%rdx), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm11[2],ymm7[3,4],ymm11[5],ymm7[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[1,1,2,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm11 = ymm9[0,0,3,3,4,4,7,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2],ymm10[3,4],ymm11[5],ymm10[6,7]
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %ymm11
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm12 = ymm11[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm12[0],ymm10[1,2],ymm12[3],ymm10[4,5],ymm12[6],ymm10[7]
; AVX2-FCP-NEXT:    vpermps %ymm9, %ymm6, %ymm6
; AVX2-FCP-NEXT:    vbroadcastsd 248(%rdi), %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm9[2],ymm6[3,4],ymm9[5],ymm6[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm11[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm9[1],ymm6[2,3],ymm9[4],ymm6[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vmovaps %ymm6, 736(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 704(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 672(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 640(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 608(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 576(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 544(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 512(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 480(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 448(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm15, 416(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm14, 384(%rcx)
; AVX2-FCP-NEXT:    vmovaps %ymm13, 352(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rcx)
; AVX2-FCP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FCP-NEXT:    addq $232, %rsp
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512-NEXT:    vpermt2d %zmm4, %zmm12, %zmm13
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512-NEXT:    vpermt2d %zmm8, %zmm14, %zmm13
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512-NEXT:    vpermt2d %zmm7, %zmm15, %zmm16
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512-NEXT:    vpermt2d %zmm11, %zmm17, %zmm16
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512-NEXT:    vpermt2d %zmm0, %zmm18, %zmm19
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512-NEXT:    vpermt2d %zmm11, %zmm20, %zmm19
; AVX512-NEXT:    vpermt2d %zmm7, %zmm12, %zmm0
; AVX512-NEXT:    vpermt2d %zmm11, %zmm14, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512-NEXT:    vpermt2d %zmm6, %zmm15, %zmm7
; AVX512-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512-NEXT:    vpermt2d %zmm1, %zmm18, %zmm11
; AVX512-NEXT:    vpermt2d %zmm10, %zmm20, %zmm11
; AVX512-NEXT:    vpermt2d %zmm6, %zmm12, %zmm1
; AVX512-NEXT:    vpermt2d %zmm10, %zmm14, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512-NEXT:    vpermt2d %zmm5, %zmm15, %zmm6
; AVX512-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512-NEXT:    vpermt2d %zmm2, %zmm18, %zmm10
; AVX512-NEXT:    vpermt2d %zmm9, %zmm20, %zmm10
; AVX512-NEXT:    vpermt2d %zmm5, %zmm12, %zmm2
; AVX512-NEXT:    vpermt2d %zmm9, %zmm14, %zmm2
; AVX512-NEXT:    vpermi2d %zmm4, %zmm3, %zmm15
; AVX512-NEXT:    vpermt2d %zmm8, %zmm17, %zmm15
; AVX512-NEXT:    vpermt2d %zmm3, %zmm18, %zmm4
; AVX512-NEXT:    vpermt2d %zmm8, %zmm20, %zmm4
; AVX512-NEXT:    vmovdqa64 %zmm4, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride3_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm12, %zmm13
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm14, %zmm13
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512-FCP-NEXT:    vpermt2d %zmm7, %zmm15, %zmm16
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512-FCP-NEXT:    vpermt2d %zmm11, %zmm17, %zmm16
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm18, %zmm19
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm11, %zmm20, %zmm19
; AVX512-FCP-NEXT:    vpermt2d %zmm7, %zmm12, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm11, %zmm14, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm15, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512-FCP-NEXT:    vpermt2d %zmm1, %zmm18, %zmm11
; AVX512-FCP-NEXT:    vpermt2d %zmm10, %zmm20, %zmm11
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm12, %zmm1
; AVX512-FCP-NEXT:    vpermt2d %zmm10, %zmm14, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm15, %zmm6
; AVX512-FCP-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm18, %zmm10
; AVX512-FCP-NEXT:    vpermt2d %zmm9, %zmm20, %zmm10
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm12, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm9, %zmm14, %zmm2
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm3, %zmm15
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm17, %zmm15
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm18, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm8, %zmm20, %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride3_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512DQ-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512DQ-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm12, %zmm13
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm14, %zmm13
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512DQ-NEXT:    vpermt2d %zmm7, %zmm15, %zmm16
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-NEXT:    vpermt2d %zmm11, %zmm17, %zmm16
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm18, %zmm19
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-NEXT:    vpermt2d %zmm11, %zmm20, %zmm19
; AVX512DQ-NEXT:    vpermt2d %zmm7, %zmm12, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm11, %zmm14, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm15, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-NEXT:    vpermt2d %zmm1, %zmm18, %zmm11
; AVX512DQ-NEXT:    vpermt2d %zmm10, %zmm20, %zmm11
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm12, %zmm1
; AVX512DQ-NEXT:    vpermt2d %zmm10, %zmm14, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm15, %zmm6
; AVX512DQ-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm18, %zmm10
; AVX512DQ-NEXT:    vpermt2d %zmm9, %zmm20, %zmm10
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm12, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm9, %zmm14, %zmm2
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm3, %zmm15
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm17, %zmm15
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm18, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm8, %zmm20, %zmm4
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 64(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride3_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm12, %zmm13
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm14, %zmm13
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm7, %zmm15, %zmm16
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm11, %zmm17, %zmm16
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm18, %zmm19
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm11, %zmm20, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm7, %zmm12, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm11, %zmm14, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm15, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm1, %zmm18, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm10, %zmm20, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm12, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm10, %zmm14, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm15, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm18, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm9, %zmm20, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm12, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm9, %zmm14, %zmm2
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm3, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm17, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm18, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm8, %zmm20, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride3_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm12, %zmm13
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512BW-NEXT:    vpermt2d %zmm8, %zmm14, %zmm13
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512BW-NEXT:    vpermt2d %zmm7, %zmm15, %zmm16
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512BW-NEXT:    vpermt2d %zmm11, %zmm17, %zmm16
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm18, %zmm19
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512BW-NEXT:    vpermt2d %zmm11, %zmm20, %zmm19
; AVX512BW-NEXT:    vpermt2d %zmm7, %zmm12, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm11, %zmm14, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm15, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm18, %zmm11
; AVX512BW-NEXT:    vpermt2d %zmm10, %zmm20, %zmm11
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm12, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm10, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm15, %zmm6
; AVX512BW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm18, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm9, %zmm20, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm12, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm9, %zmm14, %zmm2
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm3, %zmm15
; AVX512BW-NEXT:    vpermt2d %zmm8, %zmm17, %zmm15
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm18, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm8, %zmm20, %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride3_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2d %zmm4, %zmm12, %zmm13
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm8, %zmm14, %zmm13
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2d %zmm7, %zmm15, %zmm16
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm11, %zmm17, %zmm16
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm18, %zmm19
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm11, %zmm20, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2d %zmm7, %zmm12, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2d %zmm11, %zmm14, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2d %zmm6, %zmm15, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2d %zmm1, %zmm18, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2d %zmm10, %zmm20, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2d %zmm6, %zmm12, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2d %zmm10, %zmm14, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm15, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm18, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2d %zmm9, %zmm20, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm12, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2d %zmm9, %zmm14, %zmm2
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm3, %zmm15
; AVX512BW-FCP-NEXT:    vpermt2d %zmm8, %zmm17, %zmm15
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm18, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2d %zmm8, %zmm20, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride3_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2d %zmm4, %zmm12, %zmm13
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm8, %zmm14, %zmm13
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2d %zmm7, %zmm15, %zmm16
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm11, %zmm17, %zmm16
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm18, %zmm19
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm11, %zmm20, %zmm19
; AVX512DQ-BW-NEXT:    vpermt2d %zmm7, %zmm12, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2d %zmm11, %zmm14, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-BW-NEXT:    vpermt2d %zmm6, %zmm15, %zmm7
; AVX512DQ-BW-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2d %zmm1, %zmm18, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2d %zmm10, %zmm20, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2d %zmm6, %zmm12, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2d %zmm10, %zmm14, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm15, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm18, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2d %zmm9, %zmm20, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm12, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2d %zmm9, %zmm14, %zmm2
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm3, %zmm15
; AVX512DQ-BW-NEXT:    vpermt2d %zmm8, %zmm17, %zmm15
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm18, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2d %zmm8, %zmm20, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 64(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride3_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [0,16,0,1,17,0,2,18,0,3,19,0,4,20,0,5]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm4, %zmm12, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm14 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm8, %zmm14, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,11,27,0,12,28,0,13,29,0,14,30,0,15,31,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm7, %zmm15, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm17 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm11, %zmm17, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [5,0,22,6,0,23,7,0,24,8,0,25,9,0,26,10]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm18, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm11, %zmm20, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm7, %zmm12, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm11, %zmm14, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm6, %zmm15, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm1, %zmm18, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm10, %zmm20, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm6, %zmm12, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm10, %zmm14, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm15, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm18, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm9, %zmm20, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm12, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm9, %zmm14, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm3, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm8, %zmm17, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm18, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm8, %zmm20, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <64 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <64 x i32> %in.vec0, <64 x i32> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i32> %in.vec2, <64 x i32> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <128 x i32> %1, <128 x i32> %2, <192 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191>
  %interleaved.vec = shufflevector <192 x i32> %3, <192 x i32> poison, <192 x i32> <i32 0, i32 64, i32 128, i32 1, i32 65, i32 129, i32 2, i32 66, i32 130, i32 3, i32 67, i32 131, i32 4, i32 68, i32 132, i32 5, i32 69, i32 133, i32 6, i32 70, i32 134, i32 7, i32 71, i32 135, i32 8, i32 72, i32 136, i32 9, i32 73, i32 137, i32 10, i32 74, i32 138, i32 11, i32 75, i32 139, i32 12, i32 76, i32 140, i32 13, i32 77, i32 141, i32 14, i32 78, i32 142, i32 15, i32 79, i32 143, i32 16, i32 80, i32 144, i32 17, i32 81, i32 145, i32 18, i32 82, i32 146, i32 19, i32 83, i32 147, i32 20, i32 84, i32 148, i32 21, i32 85, i32 149, i32 22, i32 86, i32 150, i32 23, i32 87, i32 151, i32 24, i32 88, i32 152, i32 25, i32 89, i32 153, i32 26, i32 90, i32 154, i32 27, i32 91, i32 155, i32 28, i32 92, i32 156, i32 29, i32 93, i32 157, i32 30, i32 94, i32 158, i32 31, i32 95, i32 159, i32 32, i32 96, i32 160, i32 33, i32 97, i32 161, i32 34, i32 98, i32 162, i32 35, i32 99, i32 163, i32 36, i32 100, i32 164, i32 37, i32 101, i32 165, i32 38, i32 102, i32 166, i32 39, i32 103, i32 167, i32 40, i32 104, i32 168, i32 41, i32 105, i32 169, i32 42, i32 106, i32 170, i32 43, i32 107, i32 171, i32 44, i32 108, i32 172, i32 45, i32 109, i32 173, i32 46, i32 110, i32 174, i32 47, i32 111, i32 175, i32 48, i32 112, i32 176, i32 49, i32 113, i32 177, i32 50, i32 114, i32 178, i32 51, i32 115, i32 179, i32 52, i32 116, i32 180, i32 53, i32 117, i32 181, i32 54, i32 118, i32 182, i32 55, i32 119, i32 183, i32 56, i32 120, i32 184, i32 57, i32 121, i32 185, i32 58, i32 122, i32 186, i32 59, i32 123, i32 187, i32 60, i32 124, i32 188, i32 61, i32 125, i32 189, i32 62, i32 126, i32 190, i32 63, i32 127, i32 191>
  store <192 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
