#[macro_use]
extern crate criterion;
extern crate flux;

use criterion::{black_box, Criterion};
use flux::parser::Parser;

// everything.flux was generated by running the following
// command from this directory. This file is trimmed to 5000
// lines, as the 52k lines pre-trim would cause the benchmark
// test to take a very long time (almost three hours).
// for file in `find ../../../../stdlib -name "*.flux"`; do
// cat $file | grep -v "^package" | grep -v "^import" | grep -v "^$" >> everything.flux
// done
fn everything(c: &mut Criterion) {
    let flux = include_str!("./everything.flux");
    c.bench_function("everything.flux", |b| {
        b.iter(black_box(|| {
            let mut parser = Parser::new(flux);
            parser.parse_file("".to_string());
        }));
    });
}

criterion_group!(basic, everything,);
criterion_main!(basic);
