// DO NOT EDIT: This file is autogenerated via the builtin command.

package pagerduty

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   232,
				},
				File:   "pagerduty.flux",
				Source: "package pagerduty\n\n\nimport \"http\"\nimport \"json\"\nimport \"strings\"\n\n// dedupKey uses the group key of an input table to generate and store a deduplication key in the _pagerdutyDedupKey column.\n// The function sorts, newline-concatenates, SHA256-hashes, and hex-encodes the group key to create a unique deduplication key for each input table.\n//\n// ## Parameters\n// - `exclude` is the group key columns to exclude when generating the deduplication key. Default is [\"_start\", \"_stop\", \"_level\"].\n//\n// ## Add a PagerDuty deduplication key to output data\n// ```\n// import \"pagerduty\"\n//\n// from(bucket: \"default\")\n//   |> range(start: -5m)\n//   |> filter(fn: (r) => r._measurement == \"mem\")\n//   |> pagerduty.dedupKey()\n// ```\n//\nbuiltin dedupKey : (<-tables: [A], ?exclude: [string]) => [{A with _pagerdutyDedupKey: string}]\n\noption defaultURL = \"https://events.pagerduty.com/v2/enqueue\"\n\n// severityFromLevel converts an InfluxDB status level to a PagerDuty severity.\n//\n//\n//  Status level\tPagerDuty severity\n//  crit\t        critical\n//  warn\t        warning\n//  info\t        info\n//  ok\t            info\n//\n// ## Parameters\n// - `level` is the InfluxDB status level to convert to a PagerDuty severity.\n//\nseverityFromLevel = (level) => {\n    lvl = strings.toLower(v: level)\n    sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"info\"\n    else if lvl == \"ok\" then\n        \"info\"\n    else\n        \"error\"\n\n    return sev\n}\n\n// actionFromSeverity converts a severity to a PagerDuty action. ok converts to resolve. All other severities convert to trigger.\n//\n// ## Parameters\n// - `severity` is the severity to convert to a PagerDuty action.\n//\nactionFromSeverity = (severity) => if strings.toLower(v: severity) == \"ok\" then\n    \"resolve\"\nelse\n    \"trigger\"\n\n// `actionFromLevel` converts a monitoring level to an action; \"ok\" becomes \"resolve\" everything else converts to \"trigger\".\nactionFromLevel = (level) => if strings.toLower(v: level) == \"ok\" then \"resolve\" else \"trigger\"\n\n// sendEvent sends an event to PagerDuty.\n//\n// ## Parameters\n// - `pagerdutyURL` is the URL of the PagerDuty endpoint.\n//\n//      Defaults to https://events.page rduty.com/v2/enqueue.\n//\n// - `routingKey` is the routing key generated from your PagerDuty integration.\n// - `client` is the name of the client sending the alert.\n// - `clientURL` is the URL of the client sending the alert.\n// - `dedupkey` is a per-alert ID that acts as deduplication key and allows you to acknowledge or change the severity of previous messages. Supports a maximum of 255 characters.\n// - `class` is the class or type of the event.\n//\n//      Classes are user-defined.\n//      For example, ping failure or cpu load.\n//\n// - `group` is a logical grouping used by PagerDuty.\n//\n//      Groups are user-defined.\n//      For example, app-stack.\n//\n// - `severity` is the severity of the event.\n//\n//      Valid values include:\n//\n//        critical\n//        error\n//        warning\n//        info\n//\n// - `eventAction` is the event type to send to PagerDuty.\n//\n//      Valid values include:\n//\n//        trigger\n//        resolve\n//        acknowledge\n//\n// - `source` is the unique location of the affected system. For example, the hostname or fully qualified domain name (FQDN).\n// - `summary` is a brief text summary of the event used as the summaries or titles of associated alerts. The maximum permitted length is 1024 characters.\n// - `timestamp` is the time the detected event occurred in RFC3339nano format.\n//\nsendEvent = (\n        pagerdutyURL=defaultURL,\n        routingKey,\n        client,\n        clientURL,\n        dedupKey,\n        class,\n        group,\n        severity,\n        eventAction,\n        source,\n        summary,\n        timestamp,\n) => {\n    payload = {\n        summary: summary,\n        timestamp: timestamp,\n        source: source,\n        severity: severity,\n        group: group,\n        class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}\n\n// endpoint returns a function that can be used to send a message to PagerDuty that includes output data.\n//\n// ## Parameters\n// - `url` is the The PagerDuty v2 Events API URL.\n//\n//      Defaults to https://events.pagerduty.com/v2/enqueue.\n//\n// - `Usage` the pagerduty.endpoint is a factory function that outputs another function.\n//\n//      The output function requires a mapFn parameter.\n//      See the PagerDuty v2 Events API documentation for more information about these parameters.\n//\n// - `mapFn` is a function that builds the record used to generate the POST request. Requires an r parameter.\n//\n//      mapFn accepts a table row (r) and returns a record that must include the following fields:\n//         routingKey\n//         client\n//         client_url\n//         class\n//         eventAction\n//         group\n//         severity\n//         component\n//         source\n//         summary\n//         timestamp\n//\n// ## Send critical statuses to a PagerDuty endpoint\n// ```\n// import \"pagerduty\"\n// import \"influxdata/influxdb/secrets\"\n//\n// routingKey = secrets.get(key: \"PAGERDUTY_ROUTING_KEY\")\n// toPagerDuty = pagerduty.endpoint()\n//\n// crit_statuses = from(bucket: \"example-bucket\")\n//   |> range(start: -1m)\n//   |> filter(fn: (r) => r._measurement == \"statuses\" and r.status == \"crit\")\n//\n// crit_statuses\n//   |> toPagerDuty(mapFn: (r) => ({ r with\n//       routingKey: routingKey,\n//       client: r.client,\n//       clientURL: r.clientURL,\n//       class: r.class,\n//       eventAction: r.eventAction,\n//       group: r.group,\n//       severity: r.severity,\n//       component: r.component,\n//       source: r.source,\n//       summary: r.summary,\n//       timestamp: r._time,\n//     })\n//   )()\n// ```\n//\nendpoint = (url=defaultURL) => (mapFn) => (tables=<-) => tables\n    |> dedupKey()\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// dedupKey uses the group key of an input table to generate and store a deduplication key in the _pagerdutyDedupKey column.\n"}, ast.Comment{Text: "// The function sorts, newline-concatenates, SHA256-hashes, and hex-encodes the group key to create a unique deduplication key for each input table.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `exclude` is the group key columns to exclude when generating the deduplication key. Default is [\"_start\", \"_stop\", \"_level\"].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Add a PagerDuty deduplication key to output data\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"pagerduty\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// from(bucket: \"default\")\n"}, ast.Comment{Text: "//   |> range(start: -5m)\n"}, ast.Comment{Text: "//   |> filter(fn: (r) => r._measurement == \"mem\")\n"}, ast.Comment{Text: "//   |> pagerduty.dedupKey()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   25,
					},
					File:   "pagerduty.flux",
					Source: "builtin dedupKey",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   25,
						},
						File:   "pagerduty.flux",
						Source: "dedupKey",
						Start: ast.Position{
							Column: 9,
							Line:   25,
						},
					},
				},
				Name: "dedupKey",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 96,
							Line:   25,
						},
						File:   "pagerduty.flux",
						Source: "(<-tables: [A], ?exclude: [string]) => [{A with _pagerdutyDedupKey: string}]",
						Start: ast.Position{
							Column: 20,
							Line:   25,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 96,
								Line:   25,
							},
							File:   "pagerduty.flux",
							Source: "(<-tables: [A], ?exclude: [string]) => [{A with _pagerdutyDedupKey: string}]",
							Start: ast.Position{
								Column: 20,
								Line:   25,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   25,
								},
								File:   "pagerduty.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 21,
									Line:   25,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   25,
									},
									File:   "pagerduty.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   25,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   25,
									},
									File:   "pagerduty.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   25,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   25,
										},
										File:   "pagerduty.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   25,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   25,
											},
											File:   "pagerduty.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   25,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   25,
								},
								File:   "pagerduty.flux",
								Source: "?exclude: [string]",
								Start: ast.Position{
									Column: 36,
									Line:   25,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   25,
									},
									File:   "pagerduty.flux",
									Source: "exclude",
									Start: ast.Position{
										Column: 37,
										Line:   25,
									},
								},
							},
							Name: "exclude",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   25,
									},
									File:   "pagerduty.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 46,
										Line:   25,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   25,
										},
										File:   "pagerduty.flux",
										Source: "string",
										Start: ast.Position{
											Column: 47,
											Line:   25,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   25,
											},
											File:   "pagerduty.flux",
											Source: "string",
											Start: ast.Position{
												Column: 47,
												Line:   25,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 96,
									Line:   25,
								},
								File:   "pagerduty.flux",
								Source: "[{A with _pagerdutyDedupKey: string}]",
								Start: ast.Position{
									Column: 59,
									Line:   25,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   25,
									},
									File:   "pagerduty.flux",
									Source: "{A with _pagerdutyDedupKey: string}",
									Start: ast.Position{
										Column: 60,
										Line:   25,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 94,
											Line:   25,
										},
										File:   "pagerduty.flux",
										Source: "_pagerdutyDedupKey: string",
										Start: ast.Position{
											Column: 68,
											Line:   25,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   25,
											},
											File:   "pagerduty.flux",
											Source: "_pagerdutyDedupKey",
											Start: ast.Position{
												Column: 68,
												Line:   25,
											},
										},
									},
									Name: "_pagerdutyDedupKey",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 94,
												Line:   25,
											},
											File:   "pagerduty.flux",
											Source: "string",
											Start: ast.Position{
												Column: 88,
												Line:   25,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   25,
												},
												File:   "pagerduty.flux",
												Source: "string",
												Start: ast.Position{
													Column: 88,
													Line:   25,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   25,
										},
										File:   "pagerduty.flux",
										Source: "A",
										Start: ast.Position{
											Column: 61,
											Line:   25,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 62,
							Line:   27,
						},
						File:   "pagerduty.flux",
						Source: "defaultURL = \"https://events.pagerduty.com/v2/enqueue\"",
						Start: ast.Position{
							Column: 8,
							Line:   27,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   27,
							},
							File:   "pagerduty.flux",
							Source: "defaultURL",
							Start: ast.Position{
								Column: 8,
								Line:   27,
							},
						},
					},
					Name: "defaultURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 62,
								Line:   27,
							},
							File:   "pagerduty.flux",
							Source: "\"https://events.pagerduty.com/v2/enqueue\"",
							Start: ast.Position{
								Column: 21,
								Line:   27,
							},
						},
					},
					Value: "https://events.pagerduty.com/v2/enqueue",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 62,
						Line:   27,
					},
					File:   "pagerduty.flux",
					Source: "option defaultURL = \"https://events.pagerduty.com/v2/enqueue\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   55,
					},
					File:   "pagerduty.flux",
					Source: "severityFromLevel = (level) => {\n    lvl = strings.toLower(v: level)\n    sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"info\"\n    else if lvl == \"ok\" then\n        \"info\"\n    else\n        \"error\"\n\n    return sev\n}",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// severityFromLevel converts an InfluxDB status level to a PagerDuty severity.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//  Status level\tPagerDuty severity\n"}, ast.Comment{Text: "//  crit\t        critical\n"}, ast.Comment{Text: "//  warn\t        warning\n"}, ast.Comment{Text: "//  info\t        info\n"}, ast.Comment{Text: "//  ok\t            info\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `level` is the InfluxDB status level to convert to a PagerDuty severity.\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   41,
						},
						File:   "pagerduty.flux",
						Source: "severityFromLevel",
						Start: ast.Position{
							Column: 1,
							Line:   41,
						},
					},
				},
				Name: "severityFromLevel",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   55,
						},
						File:   "pagerduty.flux",
						Source: "(level) => {\n    lvl = strings.toLower(v: level)\n    sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"info\"\n    else if lvl == \"ok\" then\n        \"info\"\n    else\n        \"error\"\n\n    return sev\n}",
						Start: ast.Position{
							Column: 21,
							Line:   41,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   55,
							},
							File:   "pagerduty.flux",
							Source: "{\n    lvl = strings.toLower(v: level)\n    sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"info\"\n    else if lvl == \"ok\" then\n        \"info\"\n    else\n        \"error\"\n\n    return sev\n}",
							Start: ast.Position{
								Column: 32,
								Line:   41,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   42,
								},
								File:   "pagerduty.flux",
								Source: "lvl = strings.toLower(v: level)",
								Start: ast.Position{
									Column: 5,
									Line:   42,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   42,
									},
									File:   "pagerduty.flux",
									Source: "lvl",
									Start: ast.Position{
										Column: 5,
										Line:   42,
									},
								},
							},
							Name: "lvl",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   42,
										},
										File:   "pagerduty.flux",
										Source: "v: level",
										Start: ast.Position{
											Column: 27,
											Line:   42,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   42,
											},
											File:   "pagerduty.flux",
											Source: "v: level",
											Start: ast.Position{
												Column: 27,
												Line:   42,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   42,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 27,
													Line:   42,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   42,
												},
												File:   "pagerduty.flux",
												Source: "level",
												Start: ast.Position{
													Column: 30,
													Line:   42,
												},
											},
										},
										Name: "level",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   42,
									},
									File:   "pagerduty.flux",
									Source: "strings.toLower(v: level)",
									Start: ast.Position{
										Column: 11,
										Line:   42,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   42,
										},
										File:   "pagerduty.flux",
										Source: "strings.toLower",
										Start: ast.Position{
											Column: 11,
											Line:   42,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   42,
											},
											File:   "pagerduty.flux",
											Source: "strings",
											Start: ast.Position{
												Column: 11,
												Line:   42,
											},
										},
									},
									Name: "strings",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   42,
											},
											File:   "pagerduty.flux",
											Source: "toLower",
											Start: ast.Position{
												Column: 19,
												Line:   42,
											},
										},
									},
									Name: "toLower",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   52,
								},
								File:   "pagerduty.flux",
								Source: "sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"info\"\n    else if lvl == \"ok\" then\n        \"info\"\n    else\n        \"error\"",
								Start: ast.Position{
									Column: 5,
									Line:   43,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   43,
									},
									File:   "pagerduty.flux",
									Source: "sev",
									Start: ast.Position{
										Column: 5,
										Line:   43,
									},
								},
							},
							Name: "sev",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.ConditionalExpression{
								Alternate: &ast.ConditionalExpression{
									Alternate: &ast.ConditionalExpression{
										Alternate: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   52,
													},
													File:   "pagerduty.flux",
													Source: "\"error\"",
													Start: ast.Position{
														Column: 9,
														Line:   52,
													},
												},
											},
											Value: "error",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   52,
												},
												File:   "pagerduty.flux",
												Source: "if lvl == \"ok\" then\n        \"info\"\n    else\n        \"error\"",
												Start: ast.Position{
													Column: 10,
													Line:   49,
												},
											},
										},
										Consequent: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   50,
													},
													File:   "pagerduty.flux",
													Source: "\"info\"",
													Start: ast.Position{
														Column: 9,
														Line:   50,
													},
												},
											},
											Value: "info",
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   49,
													},
													File:   "pagerduty.flux",
													Source: "lvl == \"ok\"",
													Start: ast.Position{
														Column: 13,
														Line:   49,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   49,
														},
														File:   "pagerduty.flux",
														Source: "lvl",
														Start: ast.Position{
															Column: 13,
															Line:   49,
														},
													},
												},
												Name: "lvl",
											},
											Operator: 17,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   49,
														},
														File:   "pagerduty.flux",
														Source: "\"ok\"",
														Start: ast.Position{
															Column: 20,
															Line:   49,
														},
													},
												},
												Value: "ok",
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   52,
											},
											File:   "pagerduty.flux",
											Source: "if lvl == \"info\" then\n        \"info\"\n    else if lvl == \"ok\" then\n        \"info\"\n    else\n        \"error\"",
											Start: ast.Position{
												Column: 10,
												Line:   47,
											},
										},
									},
									Consequent: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   48,
												},
												File:   "pagerduty.flux",
												Source: "\"info\"",
												Start: ast.Position{
													Column: 9,
													Line:   48,
												},
											},
										},
										Value: "info",
									},
									Test: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   47,
												},
												File:   "pagerduty.flux",
												Source: "lvl == \"info\"",
												Start: ast.Position{
													Column: 13,
													Line:   47,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   47,
													},
													File:   "pagerduty.flux",
													Source: "lvl",
													Start: ast.Position{
														Column: 13,
														Line:   47,
													},
												},
											},
											Name: "lvl",
										},
										Operator: 17,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   47,
													},
													File:   "pagerduty.flux",
													Source: "\"info\"",
													Start: ast.Position{
														Column: 20,
														Line:   47,
													},
												},
											},
											Value: "info",
										},
									},
									Tk_else: nil,
									Tk_if:   nil,
									Tk_then: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   52,
										},
										File:   "pagerduty.flux",
										Source: "if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"info\"\n    else if lvl == \"ok\" then\n        \"info\"\n    else\n        \"error\"",
										Start: ast.Position{
											Column: 10,
											Line:   45,
										},
									},
								},
								Consequent: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   46,
											},
											File:   "pagerduty.flux",
											Source: "\"critical\"",
											Start: ast.Position{
												Column: 9,
												Line:   46,
											},
										},
									},
									Value: "critical",
								},
								Test: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   45,
											},
											File:   "pagerduty.flux",
											Source: "lvl == \"crit\"",
											Start: ast.Position{
												Column: 13,
												Line:   45,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   45,
												},
												File:   "pagerduty.flux",
												Source: "lvl",
												Start: ast.Position{
													Column: 13,
													Line:   45,
												},
											},
										},
										Name: "lvl",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   45,
												},
												File:   "pagerduty.flux",
												Source: "\"crit\"",
												Start: ast.Position{
													Column: 20,
													Line:   45,
												},
											},
										},
										Value: "crit",
									},
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   52,
									},
									File:   "pagerduty.flux",
									Source: "if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"info\"\n    else if lvl == \"ok\" then\n        \"info\"\n    else\n        \"error\"",
									Start: ast.Position{
										Column: 11,
										Line:   43,
									},
								},
							},
							Consequent: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   44,
										},
										File:   "pagerduty.flux",
										Source: "\"warning\"",
										Start: ast.Position{
											Column: 9,
											Line:   44,
										},
									},
								},
								Value: "warning",
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   43,
										},
										File:   "pagerduty.flux",
										Source: "lvl == \"warn\"",
										Start: ast.Position{
											Column: 14,
											Line:   43,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   43,
											},
											File:   "pagerduty.flux",
											Source: "lvl",
											Start: ast.Position{
												Column: 14,
												Line:   43,
											},
										},
									},
									Name: "lvl",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   43,
											},
											File:   "pagerduty.flux",
											Source: "\"warn\"",
											Start: ast.Position{
												Column: 21,
												Line:   43,
											},
										},
									},
									Value: "warn",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   54,
									},
									File:   "pagerduty.flux",
									Source: "sev",
									Start: ast.Position{
										Column: 12,
										Line:   54,
									},
								},
							},
							Name: "sev",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   54,
								},
								File:   "pagerduty.flux",
								Source: "return sev",
								Start: ast.Position{
									Column: 5,
									Line:   54,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   41,
							},
							File:   "pagerduty.flux",
							Source: "level",
							Start: ast.Position{
								Column: 22,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   41,
								},
								File:   "pagerduty.flux",
								Source: "level",
								Start: ast.Position{
									Column: 22,
									Line:   41,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   65,
					},
					File:   "pagerduty.flux",
					Source: "actionFromSeverity = (severity) => if strings.toLower(v: severity) == \"ok\" then\n    \"resolve\"\nelse\n    \"trigger\"",
					Start: ast.Position{
						Column: 1,
						Line:   62,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// actionFromSeverity converts a severity to a PagerDuty action. ok converts to resolve. All other severities convert to trigger.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `severity` is the severity to convert to a PagerDuty action.\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   62,
						},
						File:   "pagerduty.flux",
						Source: "actionFromSeverity",
						Start: ast.Position{
							Column: 1,
							Line:   62,
						},
					},
				},
				Name: "actionFromSeverity",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   65,
						},
						File:   "pagerduty.flux",
						Source: "(severity) => if strings.toLower(v: severity) == \"ok\" then\n    \"resolve\"\nelse\n    \"trigger\"",
						Start: ast.Position{
							Column: 22,
							Line:   62,
						},
					},
				},
				Body: &ast.ConditionalExpression{
					Alternate: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   65,
								},
								File:   "pagerduty.flux",
								Source: "\"trigger\"",
								Start: ast.Position{
									Column: 5,
									Line:   65,
								},
							},
						},
						Value: "trigger",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   65,
							},
							File:   "pagerduty.flux",
							Source: "if strings.toLower(v: severity) == \"ok\" then\n    \"resolve\"\nelse\n    \"trigger\"",
							Start: ast.Position{
								Column: 36,
								Line:   62,
							},
						},
					},
					Consequent: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   63,
								},
								File:   "pagerduty.flux",
								Source: "\"resolve\"",
								Start: ast.Position{
									Column: 5,
									Line:   63,
								},
							},
						},
						Value: "resolve",
					},
					Test: &ast.BinaryExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   62,
								},
								File:   "pagerduty.flux",
								Source: "strings.toLower(v: severity) == \"ok\"",
								Start: ast.Position{
									Column: 39,
									Line:   62,
								},
							},
						},
						Left: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   62,
										},
										File:   "pagerduty.flux",
										Source: "v: severity",
										Start: ast.Position{
											Column: 55,
											Line:   62,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   62,
											},
											File:   "pagerduty.flux",
											Source: "v: severity",
											Start: ast.Position{
												Column: 55,
												Line:   62,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   62,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 55,
													Line:   62,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   62,
												},
												File:   "pagerduty.flux",
												Source: "severity",
												Start: ast.Position{
													Column: 58,
													Line:   62,
												},
											},
										},
										Name: "severity",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   62,
									},
									File:   "pagerduty.flux",
									Source: "strings.toLower(v: severity)",
									Start: ast.Position{
										Column: 39,
										Line:   62,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   62,
										},
										File:   "pagerduty.flux",
										Source: "strings.toLower",
										Start: ast.Position{
											Column: 39,
											Line:   62,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   62,
											},
											File:   "pagerduty.flux",
											Source: "strings",
											Start: ast.Position{
												Column: 39,
												Line:   62,
											},
										},
									},
									Name: "strings",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   62,
											},
											File:   "pagerduty.flux",
											Source: "toLower",
											Start: ast.Position{
												Column: 47,
												Line:   62,
											},
										},
									},
									Name: "toLower",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						Operator: 17,
						Right: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   62,
									},
									File:   "pagerduty.flux",
									Source: "\"ok\"",
									Start: ast.Position{
										Column: 71,
										Line:   62,
									},
								},
							},
							Value: "ok",
						},
					},
					Tk_else: nil,
					Tk_if:   nil,
					Tk_then: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   62,
							},
							File:   "pagerduty.flux",
							Source: "severity",
							Start: ast.Position{
								Column: 23,
								Line:   62,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   62,
								},
								File:   "pagerduty.flux",
								Source: "severity",
								Start: ast.Position{
									Column: 23,
									Line:   62,
								},
							},
						},
						Name: "severity",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 96,
						Line:   68,
					},
					File:   "pagerduty.flux",
					Source: "actionFromLevel = (level) => if strings.toLower(v: level) == \"ok\" then \"resolve\" else \"trigger\"",
					Start: ast.Position{
						Column: 1,
						Line:   68,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `actionFromLevel` converts a monitoring level to an action; \"ok\" becomes \"resolve\" everything else converts to \"trigger\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   68,
						},
						File:   "pagerduty.flux",
						Source: "actionFromLevel",
						Start: ast.Position{
							Column: 1,
							Line:   68,
						},
					},
				},
				Name: "actionFromLevel",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 96,
							Line:   68,
						},
						File:   "pagerduty.flux",
						Source: "(level) => if strings.toLower(v: level) == \"ok\" then \"resolve\" else \"trigger\"",
						Start: ast.Position{
							Column: 19,
							Line:   68,
						},
					},
				},
				Body: &ast.ConditionalExpression{
					Alternate: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 96,
									Line:   68,
								},
								File:   "pagerduty.flux",
								Source: "\"trigger\"",
								Start: ast.Position{
									Column: 87,
									Line:   68,
								},
							},
						},
						Value: "trigger",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 96,
								Line:   68,
							},
							File:   "pagerduty.flux",
							Source: "if strings.toLower(v: level) == \"ok\" then \"resolve\" else \"trigger\"",
							Start: ast.Position{
								Column: 30,
								Line:   68,
							},
						},
					},
					Consequent: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   68,
								},
								File:   "pagerduty.flux",
								Source: "\"resolve\"",
								Start: ast.Position{
									Column: 72,
									Line:   68,
								},
							},
						},
						Value: "resolve",
					},
					Test: &ast.BinaryExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   68,
								},
								File:   "pagerduty.flux",
								Source: "strings.toLower(v: level) == \"ok\"",
								Start: ast.Position{
									Column: 33,
									Line:   68,
								},
							},
						},
						Left: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   68,
										},
										File:   "pagerduty.flux",
										Source: "v: level",
										Start: ast.Position{
											Column: 49,
											Line:   68,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   68,
											},
											File:   "pagerduty.flux",
											Source: "v: level",
											Start: ast.Position{
												Column: 49,
												Line:   68,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   68,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 49,
													Line:   68,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   68,
												},
												File:   "pagerduty.flux",
												Source: "level",
												Start: ast.Position{
													Column: 52,
													Line:   68,
												},
											},
										},
										Name: "level",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   68,
									},
									File:   "pagerduty.flux",
									Source: "strings.toLower(v: level)",
									Start: ast.Position{
										Column: 33,
										Line:   68,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   68,
										},
										File:   "pagerduty.flux",
										Source: "strings.toLower",
										Start: ast.Position{
											Column: 33,
											Line:   68,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   68,
											},
											File:   "pagerduty.flux",
											Source: "strings",
											Start: ast.Position{
												Column: 33,
												Line:   68,
											},
										},
									},
									Name: "strings",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   68,
											},
											File:   "pagerduty.flux",
											Source: "toLower",
											Start: ast.Position{
												Column: 41,
												Line:   68,
											},
										},
									},
									Name: "toLower",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						Operator: 17,
						Right: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   68,
									},
									File:   "pagerduty.flux",
									Source: "\"ok\"",
									Start: ast.Position{
										Column: 62,
										Line:   68,
									},
								},
							},
							Value: "ok",
						},
					},
					Tk_else: nil,
					Tk_if:   nil,
					Tk_then: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   68,
							},
							File:   "pagerduty.flux",
							Source: "level",
							Start: ast.Position{
								Column: 20,
								Line:   68,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   68,
								},
								File:   "pagerduty.flux",
								Source: "level",
								Start: ast.Position{
									Column: 20,
									Line:   68,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   149,
					},
					File:   "pagerduty.flux",
					Source: "sendEvent = (\n        pagerdutyURL=defaultURL,\n        routingKey,\n        client,\n        clientURL,\n        dedupKey,\n        class,\n        group,\n        severity,\n        eventAction,\n        source,\n        summary,\n        timestamp,\n) => {\n    payload = {\n        summary: summary,\n        timestamp: timestamp,\n        source: source,\n        severity: severity,\n        group: group,\n        class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   112,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// sendEvent sends an event to PagerDuty.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `pagerdutyURL` is the URL of the PagerDuty endpoint.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Defaults to https://events.page rduty.com/v2/enqueue.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `routingKey` is the routing key generated from your PagerDuty integration.\n"}, ast.Comment{Text: "// - `client` is the name of the client sending the alert.\n"}, ast.Comment{Text: "// - `clientURL` is the URL of the client sending the alert.\n"}, ast.Comment{Text: "// - `dedupkey` is a per-alert ID that acts as deduplication key and allows you to acknowledge or change the severity of previous messages. Supports a maximum of 255 characters.\n"}, ast.Comment{Text: "// - `class` is the class or type of the event.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Classes are user-defined.\n"}, ast.Comment{Text: "//      For example, ping failure or cpu load.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `group` is a logical grouping used by PagerDuty.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Groups are user-defined.\n"}, ast.Comment{Text: "//      For example, app-stack.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `severity` is the severity of the event.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Valid values include:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//        critical\n"}, ast.Comment{Text: "//        error\n"}, ast.Comment{Text: "//        warning\n"}, ast.Comment{Text: "//        info\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `eventAction` is the event type to send to PagerDuty.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Valid values include:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//        trigger\n"}, ast.Comment{Text: "//        resolve\n"}, ast.Comment{Text: "//        acknowledge\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `source` is the unique location of the affected system. For example, the hostname or fully qualified domain name (FQDN).\n"}, ast.Comment{Text: "// - `summary` is a brief text summary of the event used as the summaries or titles of associated alerts. The maximum permitted length is 1024 characters.\n"}, ast.Comment{Text: "// - `timestamp` is the time the detected event occurred in RFC3339nano format.\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   112,
						},
						File:   "pagerduty.flux",
						Source: "sendEvent",
						Start: ast.Position{
							Column: 1,
							Line:   112,
						},
					},
				},
				Name: "sendEvent",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   149,
						},
						File:   "pagerduty.flux",
						Source: "(\n        pagerdutyURL=defaultURL,\n        routingKey,\n        client,\n        clientURL,\n        dedupKey,\n        class,\n        group,\n        severity,\n        eventAction,\n        source,\n        summary,\n        timestamp,\n) => {\n    payload = {\n        summary: summary,\n        timestamp: timestamp,\n        source: source,\n        severity: severity,\n        group: group,\n        class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}",
						Start: ast.Position{
							Column: 13,
							Line:   112,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   149,
							},
							File:   "pagerduty.flux",
							Source: "{\n    payload = {\n        summary: summary,\n        timestamp: timestamp,\n        source: source,\n        severity: severity,\n        group: group,\n        class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   125,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   133,
								},
								File:   "pagerduty.flux",
								Source: "payload = {\n        summary: summary,\n        timestamp: timestamp,\n        source: source,\n        severity: severity,\n        group: group,\n        class: class,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   126,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   126,
									},
									File:   "pagerduty.flux",
									Source: "payload",
									Start: ast.Position{
										Column: 5,
										Line:   126,
									},
								},
							},
							Name: "payload",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   133,
									},
									File:   "pagerduty.flux",
									Source: "{\n        summary: summary,\n        timestamp: timestamp,\n        source: source,\n        severity: severity,\n        group: group,\n        class: class,\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   126,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   127,
										},
										File:   "pagerduty.flux",
										Source: "summary: summary",
										Start: ast.Position{
											Column: 9,
											Line:   127,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   127,
											},
											File:   "pagerduty.flux",
											Source: "summary",
											Start: ast.Position{
												Column: 9,
												Line:   127,
											},
										},
									},
									Name: "summary",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   127,
											},
											File:   "pagerduty.flux",
											Source: "summary",
											Start: ast.Position{
												Column: 18,
												Line:   127,
											},
										},
									},
									Name: "summary",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   128,
										},
										File:   "pagerduty.flux",
										Source: "timestamp: timestamp",
										Start: ast.Position{
											Column: 9,
											Line:   128,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   128,
											},
											File:   "pagerduty.flux",
											Source: "timestamp",
											Start: ast.Position{
												Column: 9,
												Line:   128,
											},
										},
									},
									Name: "timestamp",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   128,
											},
											File:   "pagerduty.flux",
											Source: "timestamp",
											Start: ast.Position{
												Column: 20,
												Line:   128,
											},
										},
									},
									Name: "timestamp",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   129,
										},
										File:   "pagerduty.flux",
										Source: "source: source",
										Start: ast.Position{
											Column: 9,
											Line:   129,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   129,
											},
											File:   "pagerduty.flux",
											Source: "source",
											Start: ast.Position{
												Column: 9,
												Line:   129,
											},
										},
									},
									Name: "source",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   129,
											},
											File:   "pagerduty.flux",
											Source: "source",
											Start: ast.Position{
												Column: 17,
												Line:   129,
											},
										},
									},
									Name: "source",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   130,
										},
										File:   "pagerduty.flux",
										Source: "severity: severity",
										Start: ast.Position{
											Column: 9,
											Line:   130,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   130,
											},
											File:   "pagerduty.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 9,
												Line:   130,
											},
										},
									},
									Name: "severity",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   130,
											},
											File:   "pagerduty.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 19,
												Line:   130,
											},
										},
									},
									Name: "severity",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   131,
										},
										File:   "pagerduty.flux",
										Source: "group: group",
										Start: ast.Position{
											Column: 9,
											Line:   131,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   131,
											},
											File:   "pagerduty.flux",
											Source: "group",
											Start: ast.Position{
												Column: 9,
												Line:   131,
											},
										},
									},
									Name: "group",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   131,
											},
											File:   "pagerduty.flux",
											Source: "group",
											Start: ast.Position{
												Column: 16,
												Line:   131,
											},
										},
									},
									Name: "group",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   132,
										},
										File:   "pagerduty.flux",
										Source: "class: class",
										Start: ast.Position{
											Column: 9,
											Line:   132,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   132,
											},
											File:   "pagerduty.flux",
											Source: "class",
											Start: ast.Position{
												Column: 9,
												Line:   132,
											},
										},
									},
									Name: "class",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   132,
											},
											File:   "pagerduty.flux",
											Source: "class",
											Start: ast.Position{
												Column: 16,
												Line:   132,
											},
										},
									},
									Name: "class",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   141,
								},
								File:   "pagerduty.flux",
								Source: "data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   134,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   134,
									},
									File:   "pagerduty.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   134,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   141,
									},
									File:   "pagerduty.flux",
									Source: "{\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   134,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   135,
										},
										File:   "pagerduty.flux",
										Source: "payload: payload",
										Start: ast.Position{
											Column: 9,
											Line:   135,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   135,
											},
											File:   "pagerduty.flux",
											Source: "payload",
											Start: ast.Position{
												Column: 9,
												Line:   135,
											},
										},
									},
									Name: "payload",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   135,
											},
											File:   "pagerduty.flux",
											Source: "payload",
											Start: ast.Position{
												Column: 18,
												Line:   135,
											},
										},
									},
									Name: "payload",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   136,
										},
										File:   "pagerduty.flux",
										Source: "routing_key: routingKey",
										Start: ast.Position{
											Column: 9,
											Line:   136,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   136,
											},
											File:   "pagerduty.flux",
											Source: "routing_key",
											Start: ast.Position{
												Column: 9,
												Line:   136,
											},
										},
									},
									Name: "routing_key",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   136,
											},
											File:   "pagerduty.flux",
											Source: "routingKey",
											Start: ast.Position{
												Column: 22,
												Line:   136,
											},
										},
									},
									Name: "routingKey",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   137,
										},
										File:   "pagerduty.flux",
										Source: "dedup_key: dedupKey",
										Start: ast.Position{
											Column: 9,
											Line:   137,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   137,
											},
											File:   "pagerduty.flux",
											Source: "dedup_key",
											Start: ast.Position{
												Column: 9,
												Line:   137,
											},
										},
									},
									Name: "dedup_key",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   137,
											},
											File:   "pagerduty.flux",
											Source: "dedupKey",
											Start: ast.Position{
												Column: 20,
												Line:   137,
											},
										},
									},
									Name: "dedupKey",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   138,
										},
										File:   "pagerduty.flux",
										Source: "event_action: eventAction",
										Start: ast.Position{
											Column: 9,
											Line:   138,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   138,
											},
											File:   "pagerduty.flux",
											Source: "event_action",
											Start: ast.Position{
												Column: 9,
												Line:   138,
											},
										},
									},
									Name: "event_action",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   138,
											},
											File:   "pagerduty.flux",
											Source: "eventAction",
											Start: ast.Position{
												Column: 23,
												Line:   138,
											},
										},
									},
									Name: "eventAction",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   139,
										},
										File:   "pagerduty.flux",
										Source: "client: client",
										Start: ast.Position{
											Column: 9,
											Line:   139,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   139,
											},
											File:   "pagerduty.flux",
											Source: "client",
											Start: ast.Position{
												Column: 9,
												Line:   139,
											},
										},
									},
									Name: "client",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   139,
											},
											File:   "pagerduty.flux",
											Source: "client",
											Start: ast.Position{
												Column: 17,
												Line:   139,
											},
										},
									},
									Name: "client",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   140,
										},
										File:   "pagerduty.flux",
										Source: "client_url: clientURL",
										Start: ast.Position{
											Column: 9,
											Line:   140,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   140,
											},
											File:   "pagerduty.flux",
											Source: "client_url",
											Start: ast.Position{
												Column: 9,
												Line:   140,
											},
										},
									},
									Name: "client_url",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   140,
											},
											File:   "pagerduty.flux",
											Source: "clientURL",
											Start: ast.Position{
												Column: 21,
												Line:   140,
											},
										},
									},
									Name: "clientURL",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   145,
								},
								File:   "pagerduty.flux",
								Source: "headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   142,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   142,
									},
									File:   "pagerduty.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   142,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   145,
									},
									File:   "pagerduty.flux",
									Source: "{\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   142,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   143,
										},
										File:   "pagerduty.flux",
										Source: "\"Accept\": \"application/vnd.pagerduty+json;version=2\"",
										Start: ast.Position{
											Column: 9,
											Line:   143,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   143,
											},
											File:   "pagerduty.flux",
											Source: "\"Accept\"",
											Start: ast.Position{
												Column: 9,
												Line:   143,
											},
										},
									},
									Value: "Accept",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   143,
											},
											File:   "pagerduty.flux",
											Source: "\"application/vnd.pagerduty+json;version=2\"",
											Start: ast.Position{
												Column: 19,
												Line:   143,
											},
										},
									},
									Value: "application/vnd.pagerduty+json;version=2",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   144,
										},
										File:   "pagerduty.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   144,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   144,
											},
											File:   "pagerduty.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   144,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   144,
											},
											File:   "pagerduty.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   144,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   146,
								},
								File:   "pagerduty.flux",
								Source: "enc = json.encode(v: data)",
								Start: ast.Position{
									Column: 5,
									Line:   146,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   146,
									},
									File:   "pagerduty.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   146,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   146,
										},
										File:   "pagerduty.flux",
										Source: "v: data",
										Start: ast.Position{
											Column: 23,
											Line:   146,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   146,
											},
											File:   "pagerduty.flux",
											Source: "v: data",
											Start: ast.Position{
												Column: 23,
												Line:   146,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   146,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   146,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   146,
												},
												File:   "pagerduty.flux",
												Source: "data",
												Start: ast.Position{
													Column: 26,
													Line:   146,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   146,
									},
									File:   "pagerduty.flux",
									Source: "json.encode(v: data)",
									Start: ast.Position{
										Column: 11,
										Line:   146,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   146,
										},
										File:   "pagerduty.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   146,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   146,
											},
											File:   "pagerduty.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   146,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   146,
											},
											File:   "pagerduty.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   146,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   148,
										},
										File:   "pagerduty.flux",
										Source: "headers: headers, url: pagerdutyURL, data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   148,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   148,
											},
											File:   "pagerduty.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   148,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   148,
												},
												File:   "pagerduty.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   148,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   148,
												},
												File:   "pagerduty.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   148,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   148,
											},
											File:   "pagerduty.flux",
											Source: "url: pagerdutyURL",
											Start: ast.Position{
												Column: 40,
												Line:   148,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   148,
												},
												File:   "pagerduty.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   148,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   148,
												},
												File:   "pagerduty.flux",
												Source: "pagerdutyURL",
												Start: ast.Position{
													Column: 45,
													Line:   148,
												},
											},
										},
										Name: "pagerdutyURL",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   148,
											},
											File:   "pagerduty.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 59,
												Line:   148,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   148,
												},
												File:   "pagerduty.flux",
												Source: "data",
												Start: ast.Position{
													Column: 59,
													Line:   148,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   148,
												},
												File:   "pagerduty.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 65,
													Line:   148,
												},
											},
										},
										Name: "enc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   148,
									},
									File:   "pagerduty.flux",
									Source: "http.post(headers: headers, url: pagerdutyURL, data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   148,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   148,
										},
										File:   "pagerduty.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   148,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   148,
											},
											File:   "pagerduty.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   148,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   148,
											},
											File:   "pagerduty.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   148,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   148,
								},
								File:   "pagerduty.flux",
								Source: "return http.post(headers: headers, url: pagerdutyURL, data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   148,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   113,
							},
							File:   "pagerduty.flux",
							Source: "pagerdutyURL=defaultURL",
							Start: ast.Position{
								Column: 9,
								Line:   113,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   113,
								},
								File:   "pagerduty.flux",
								Source: "pagerdutyURL",
								Start: ast.Position{
									Column: 9,
									Line:   113,
								},
							},
						},
						Name: "pagerdutyURL",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   113,
								},
								File:   "pagerduty.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 22,
									Line:   113,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   114,
							},
							File:   "pagerduty.flux",
							Source: "routingKey",
							Start: ast.Position{
								Column: 9,
								Line:   114,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   114,
								},
								File:   "pagerduty.flux",
								Source: "routingKey",
								Start: ast.Position{
									Column: 9,
									Line:   114,
								},
							},
						},
						Name: "routingKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   115,
							},
							File:   "pagerduty.flux",
							Source: "client",
							Start: ast.Position{
								Column: 9,
								Line:   115,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   115,
								},
								File:   "pagerduty.flux",
								Source: "client",
								Start: ast.Position{
									Column: 9,
									Line:   115,
								},
							},
						},
						Name: "client",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   116,
							},
							File:   "pagerduty.flux",
							Source: "clientURL",
							Start: ast.Position{
								Column: 9,
								Line:   116,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   116,
								},
								File:   "pagerduty.flux",
								Source: "clientURL",
								Start: ast.Position{
									Column: 9,
									Line:   116,
								},
							},
						},
						Name: "clientURL",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   117,
							},
							File:   "pagerduty.flux",
							Source: "dedupKey",
							Start: ast.Position{
								Column: 9,
								Line:   117,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   117,
								},
								File:   "pagerduty.flux",
								Source: "dedupKey",
								Start: ast.Position{
									Column: 9,
									Line:   117,
								},
							},
						},
						Name: "dedupKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   118,
							},
							File:   "pagerduty.flux",
							Source: "class",
							Start: ast.Position{
								Column: 9,
								Line:   118,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   118,
								},
								File:   "pagerduty.flux",
								Source: "class",
								Start: ast.Position{
									Column: 9,
									Line:   118,
								},
							},
						},
						Name: "class",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   119,
							},
							File:   "pagerduty.flux",
							Source: "group",
							Start: ast.Position{
								Column: 9,
								Line:   119,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   119,
								},
								File:   "pagerduty.flux",
								Source: "group",
								Start: ast.Position{
									Column: 9,
									Line:   119,
								},
							},
						},
						Name: "group",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   120,
							},
							File:   "pagerduty.flux",
							Source: "severity",
							Start: ast.Position{
								Column: 9,
								Line:   120,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   120,
								},
								File:   "pagerduty.flux",
								Source: "severity",
								Start: ast.Position{
									Column: 9,
									Line:   120,
								},
							},
						},
						Name: "severity",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   121,
							},
							File:   "pagerduty.flux",
							Source: "eventAction",
							Start: ast.Position{
								Column: 9,
								Line:   121,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   121,
								},
								File:   "pagerduty.flux",
								Source: "eventAction",
								Start: ast.Position{
									Column: 9,
									Line:   121,
								},
							},
						},
						Name: "eventAction",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   122,
							},
							File:   "pagerduty.flux",
							Source: "source",
							Start: ast.Position{
								Column: 9,
								Line:   122,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   122,
								},
								File:   "pagerduty.flux",
								Source: "source",
								Start: ast.Position{
									Column: 9,
									Line:   122,
								},
							},
						},
						Name: "source",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   123,
							},
							File:   "pagerduty.flux",
							Source: "summary",
							Start: ast.Position{
								Column: 9,
								Line:   123,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   123,
								},
								File:   "pagerduty.flux",
								Source: "summary",
								Start: ast.Position{
									Column: 9,
									Line:   123,
								},
							},
						},
						Name: "summary",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   124,
							},
							File:   "pagerduty.flux",
							Source: "timestamp",
							Start: ast.Position{
								Column: 9,
								Line:   124,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   124,
								},
								File:   "pagerduty.flux",
								Source: "timestamp",
								Start: ast.Position{
									Column: 9,
									Line:   124,
								},
							},
						},
						Name: "timestamp",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   232,
					},
					File:   "pagerduty.flux",
					Source: "endpoint = (url=defaultURL) => (mapFn) => (tables=<-) => tables\n    |> dedupKey()\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   207,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// endpoint returns a function that can be used to send a message to PagerDuty that includes output data.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `url` is the The PagerDuty v2 Events API URL.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Defaults to https://events.pagerduty.com/v2/enqueue.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `Usage` the pagerduty.endpoint is a factory function that outputs another function.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      The output function requires a mapFn parameter.\n"}, ast.Comment{Text: "//      See the PagerDuty v2 Events API documentation for more information about these parameters.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `mapFn` is a function that builds the record used to generate the POST request. Requires an r parameter.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      mapFn accepts a table row (r) and returns a record that must include the following fields:\n"}, ast.Comment{Text: "//         routingKey\n"}, ast.Comment{Text: "//         client\n"}, ast.Comment{Text: "//         client_url\n"}, ast.Comment{Text: "//         class\n"}, ast.Comment{Text: "//         eventAction\n"}, ast.Comment{Text: "//         group\n"}, ast.Comment{Text: "//         severity\n"}, ast.Comment{Text: "//         component\n"}, ast.Comment{Text: "//         source\n"}, ast.Comment{Text: "//         summary\n"}, ast.Comment{Text: "//         timestamp\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Send critical statuses to a PagerDuty endpoint\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"pagerduty\"\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/secrets\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// routingKey = secrets.get(key: \"PAGERDUTY_ROUTING_KEY\")\n"}, ast.Comment{Text: "// toPagerDuty = pagerduty.endpoint()\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// crit_statuses = from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -1m)\n"}, ast.Comment{Text: "//   |> filter(fn: (r) => r._measurement == \"statuses\" and r.status == \"crit\")\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// crit_statuses\n"}, ast.Comment{Text: "//   |> toPagerDuty(mapFn: (r) => ({ r with\n"}, ast.Comment{Text: "//       routingKey: routingKey,\n"}, ast.Comment{Text: "//       client: r.client,\n"}, ast.Comment{Text: "//       clientURL: r.clientURL,\n"}, ast.Comment{Text: "//       class: r.class,\n"}, ast.Comment{Text: "//       eventAction: r.eventAction,\n"}, ast.Comment{Text: "//       group: r.group,\n"}, ast.Comment{Text: "//       severity: r.severity,\n"}, ast.Comment{Text: "//       component: r.component,\n"}, ast.Comment{Text: "//       source: r.source,\n"}, ast.Comment{Text: "//       summary: r.summary,\n"}, ast.Comment{Text: "//       timestamp: r._time,\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   207,
						},
						File:   "pagerduty.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   207,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   232,
						},
						File:   "pagerduty.flux",
						Source: "(url=defaultURL) => (mapFn) => (tables=<-) => tables\n    |> dedupKey()\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   207,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   232,
							},
							File:   "pagerduty.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> dedupKey()\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 32,
								Line:   207,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   232,
								},
								File:   "pagerduty.flux",
								Source: "(tables=<-) => tables\n    |> dedupKey()\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 43,
									Line:   207,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   207,
											},
											File:   "pagerduty.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 58,
												Line:   207,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   208,
										},
										File:   "pagerduty.flux",
										Source: "tables\n    |> dedupKey()",
										Start: ast.Position{
											Column: 58,
											Line:   207,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   208,
											},
											File:   "pagerduty.flux",
											Source: "dedupKey()",
											Start: ast.Position{
												Column: 8,
												Line:   208,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   208,
												},
												File:   "pagerduty.flux",
												Source: "dedupKey",
												Start: ast.Position{
													Column: 8,
													Line:   208,
												},
											},
										},
										Name: "dedupKey",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   232,
									},
									File:   "pagerduty.flux",
									Source: "tables\n    |> dedupKey()\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 58,
										Line:   207,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   231,
											},
											File:   "pagerduty.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   210,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   231,
												},
												File:   "pagerduty.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   210,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   210,
													},
													File:   "pagerduty.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   210,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   231,
													},
													File:   "pagerduty.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   210,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   231,
														},
														File:   "pagerduty.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   210,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   211,
															},
															File:   "pagerduty.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   211,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   211,
																},
																File:   "pagerduty.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   211,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   211,
																	},
																	File:   "pagerduty.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   211,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   211,
																		},
																		File:   "pagerduty.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   211,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   211,
																			},
																			File:   "pagerduty.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   211,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   211,
																			},
																			File:   "pagerduty.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   211,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   211,
																},
																File:   "pagerduty.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   211,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   211,
																	},
																	File:   "pagerduty.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   211,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   230,
																},
																File:   "pagerduty.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   213,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   229,
																	},
																	File:   "pagerduty.flux",
																	Source: "_sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   214,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   214,
																		},
																		File:   "pagerduty.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   214,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   228,
																			},
																			File:   "pagerduty.flux",
																			Source: "v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   215,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   228,
																				},
																				File:   "pagerduty.flux",
																				Source: "v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   215,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   215,
																					},
																					File:   "pagerduty.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   215,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   228,
																					},
																					File:   "pagerduty.flux",
																					Source: "2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   215,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   215,
																						},
																						File:   "pagerduty.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   215,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   228,
																						},
																						File:   "pagerduty.flux",
																						Source: "sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   215,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 49,
																									Line:   227,
																								},
																								File:   "pagerduty.flux",
																								Source: "pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp",
																								Start: ast.Position{
																									Column: 25,
																									Line:   216,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 42,
																										Line:   216,
																									},
																									File:   "pagerduty.flux",
																									Source: "pagerdutyURL: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   216,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   216,
																										},
																										File:   "pagerduty.flux",
																										Source: "pagerdutyURL",
																										Start: ast.Position{
																											Column: 25,
																											Line:   216,
																										},
																									},
																								},
																								Name: "pagerdutyURL",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 42,
																											Line:   216,
																										},
																										File:   "pagerduty.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 39,
																											Line:   216,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 51,
																										Line:   217,
																									},
																									File:   "pagerduty.flux",
																									Source: "routingKey: obj.routingKey",
																									Start: ast.Position{
																										Column: 25,
																										Line:   217,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   217,
																										},
																										File:   "pagerduty.flux",
																										Source: "routingKey",
																										Start: ast.Position{
																											Column: 25,
																											Line:   217,
																										},
																									},
																								},
																								Name: "routingKey",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 51,
																											Line:   217,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.routingKey",
																										Start: ast.Position{
																											Column: 37,
																											Line:   217,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 40,
																												Line:   217,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 37,
																												Line:   217,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 51,
																												Line:   217,
																											},
																											File:   "pagerduty.flux",
																											Source: "routingKey",
																											Start: ast.Position{
																												Column: 41,
																												Line:   217,
																											},
																										},
																									},
																									Name: "routingKey",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   218,
																									},
																									File:   "pagerduty.flux",
																									Source: "client: obj.client",
																									Start: ast.Position{
																										Column: 25,
																										Line:   218,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   218,
																										},
																										File:   "pagerduty.flux",
																										Source: "client",
																										Start: ast.Position{
																											Column: 25,
																											Line:   218,
																										},
																									},
																								},
																								Name: "client",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   218,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.client",
																										Start: ast.Position{
																											Column: 33,
																											Line:   218,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 36,
																												Line:   218,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 33,
																												Line:   218,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   218,
																											},
																											File:   "pagerduty.flux",
																											Source: "client",
																											Start: ast.Position{
																												Column: 37,
																												Line:   218,
																											},
																										},
																									},
																									Name: "client",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 49,
																										Line:   219,
																									},
																									File:   "pagerduty.flux",
																									Source: "clientURL: obj.clientURL",
																									Start: ast.Position{
																										Column: 25,
																										Line:   219,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 34,
																											Line:   219,
																										},
																										File:   "pagerduty.flux",
																										Source: "clientURL",
																										Start: ast.Position{
																											Column: 25,
																											Line:   219,
																										},
																									},
																								},
																								Name: "clientURL",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   219,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.clientURL",
																										Start: ast.Position{
																											Column: 36,
																											Line:   219,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   219,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 36,
																												Line:   219,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   219,
																											},
																											File:   "pagerduty.flux",
																											Source: "clientURL",
																											Start: ast.Position{
																												Column: 40,
																												Line:   219,
																											},
																										},
																									},
																									Name: "clientURL",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 55,
																										Line:   220,
																									},
																									File:   "pagerduty.flux",
																									Source: "dedupKey: r._pagerdutyDedupKey",
																									Start: ast.Position{
																										Column: 25,
																										Line:   220,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   220,
																										},
																										File:   "pagerduty.flux",
																										Source: "dedupKey",
																										Start: ast.Position{
																											Column: 25,
																											Line:   220,
																										},
																									},
																								},
																								Name: "dedupKey",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 55,
																											Line:   220,
																										},
																										File:   "pagerduty.flux",
																										Source: "r._pagerdutyDedupKey",
																										Start: ast.Position{
																											Column: 35,
																											Line:   220,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 36,
																												Line:   220,
																											},
																											File:   "pagerduty.flux",
																											Source: "r",
																											Start: ast.Position{
																												Column: 35,
																												Line:   220,
																											},
																										},
																									},
																									Name: "r",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 55,
																												Line:   220,
																											},
																											File:   "pagerduty.flux",
																											Source: "_pagerdutyDedupKey",
																											Start: ast.Position{
																												Column: 37,
																												Line:   220,
																											},
																										},
																									},
																									Name: "_pagerdutyDedupKey",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   221,
																									},
																									File:   "pagerduty.flux",
																									Source: "class: obj.class",
																									Start: ast.Position{
																										Column: 25,
																										Line:   221,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   221,
																										},
																										File:   "pagerduty.flux",
																										Source: "class",
																										Start: ast.Position{
																											Column: 25,
																											Line:   221,
																										},
																									},
																								},
																								Name: "class",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   221,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.class",
																										Start: ast.Position{
																											Column: 32,
																											Line:   221,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   221,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   221,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   221,
																											},
																											File:   "pagerduty.flux",
																											Source: "class",
																											Start: ast.Position{
																												Column: 36,
																												Line:   221,
																											},
																										},
																									},
																									Name: "class",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   222,
																									},
																									File:   "pagerduty.flux",
																									Source: "group: obj.group",
																									Start: ast.Position{
																										Column: 25,
																										Line:   222,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   222,
																										},
																										File:   "pagerduty.flux",
																										Source: "group",
																										Start: ast.Position{
																											Column: 25,
																											Line:   222,
																										},
																									},
																								},
																								Name: "group",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   222,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.group",
																										Start: ast.Position{
																											Column: 32,
																											Line:   222,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   222,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   222,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   222,
																											},
																											File:   "pagerduty.flux",
																											Source: "group",
																											Start: ast.Position{
																												Column: 36,
																												Line:   222,
																											},
																										},
																									},
																									Name: "group",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   223,
																									},
																									File:   "pagerduty.flux",
																									Source: "severity: obj.severity",
																									Start: ast.Position{
																										Column: 25,
																										Line:   223,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   223,
																										},
																										File:   "pagerduty.flux",
																										Source: "severity",
																										Start: ast.Position{
																											Column: 25,
																											Line:   223,
																										},
																									},
																								},
																								Name: "severity",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   223,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.severity",
																										Start: ast.Position{
																											Column: 35,
																											Line:   223,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 38,
																												Line:   223,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 35,
																												Line:   223,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   223,
																											},
																											File:   "pagerduty.flux",
																											Source: "severity",
																											Start: ast.Position{
																												Column: 39,
																												Line:   223,
																											},
																										},
																									},
																									Name: "severity",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 53,
																										Line:   224,
																									},
																									File:   "pagerduty.flux",
																									Source: "eventAction: obj.eventAction",
																									Start: ast.Position{
																										Column: 25,
																										Line:   224,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 36,
																											Line:   224,
																										},
																										File:   "pagerduty.flux",
																										Source: "eventAction",
																										Start: ast.Position{
																											Column: 25,
																											Line:   224,
																										},
																									},
																								},
																								Name: "eventAction",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 53,
																											Line:   224,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.eventAction",
																										Start: ast.Position{
																											Column: 38,
																											Line:   224,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   224,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 38,
																												Line:   224,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 53,
																												Line:   224,
																											},
																											File:   "pagerduty.flux",
																											Source: "eventAction",
																											Start: ast.Position{
																												Column: 42,
																												Line:   224,
																											},
																										},
																									},
																									Name: "eventAction",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   225,
																									},
																									File:   "pagerduty.flux",
																									Source: "source: obj.source",
																									Start: ast.Position{
																										Column: 25,
																										Line:   225,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   225,
																										},
																										File:   "pagerduty.flux",
																										Source: "source",
																										Start: ast.Position{
																											Column: 25,
																											Line:   225,
																										},
																									},
																								},
																								Name: "source",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   225,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.source",
																										Start: ast.Position{
																											Column: 33,
																											Line:   225,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 36,
																												Line:   225,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 33,
																												Line:   225,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   225,
																											},
																											File:   "pagerduty.flux",
																											Source: "source",
																											Start: ast.Position{
																												Column: 37,
																												Line:   225,
																											},
																										},
																									},
																									Name: "source",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   226,
																									},
																									File:   "pagerduty.flux",
																									Source: "summary: obj.summary",
																									Start: ast.Position{
																										Column: 25,
																										Line:   226,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   226,
																										},
																										File:   "pagerduty.flux",
																										Source: "summary",
																										Start: ast.Position{
																											Column: 25,
																											Line:   226,
																										},
																									},
																								},
																								Name: "summary",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   226,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.summary",
																										Start: ast.Position{
																											Column: 34,
																											Line:   226,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   226,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   226,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   226,
																											},
																											File:   "pagerduty.flux",
																											Source: "summary",
																											Start: ast.Position{
																												Column: 38,
																												Line:   226,
																											},
																										},
																									},
																									Name: "summary",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 49,
																										Line:   227,
																									},
																									File:   "pagerduty.flux",
																									Source: "timestamp: obj.timestamp",
																									Start: ast.Position{
																										Column: 25,
																										Line:   227,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 34,
																											Line:   227,
																										},
																										File:   "pagerduty.flux",
																										Source: "timestamp",
																										Start: ast.Position{
																											Column: 25,
																											Line:   227,
																										},
																									},
																								},
																								Name: "timestamp",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   227,
																										},
																										File:   "pagerduty.flux",
																										Source: "obj.timestamp",
																										Start: ast.Position{
																											Column: 36,
																											Line:   227,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   227,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 36,
																												Line:   227,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   227,
																											},
																											File:   "pagerduty.flux",
																											Source: "timestamp",
																											Start: ast.Position{
																												Column: 40,
																												Line:   227,
																											},
																										},
																									},
																									Name: "timestamp",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   228,
																							},
																							File:   "pagerduty.flux",
																							Source: "sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   215,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 38,
																									Line:   215,
																								},
																								File:   "pagerduty.flux",
																								Source: "sendEvent",
																								Start: ast.Position{
																									Column: 29,
																									Line:   215,
																								},
																							},
																						},
																						Name: "sendEvent",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   228,
																							},
																							File:   "pagerduty.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   228,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   229,
																		},
																		File:   "pagerduty.flux",
																		Source: "string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   214,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   214,
																			},
																			File:   "pagerduty.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   214,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   213,
																	},
																	File:   "pagerduty.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   213,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   230,
															},
															File:   "pagerduty.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   213,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   210,
														},
														File:   "pagerduty.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   210,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   210,
															},
															File:   "pagerduty.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   210,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   232,
										},
										File:   "pagerduty.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendEvent(\n                        pagerdutyURL: url,\n                        routingKey: obj.routingKey,\n                        client: obj.client,\n                        clientURL: obj.clientURL,\n                        dedupKey: r._pagerdutyDedupKey,\n                        class: obj.class,\n                        group: obj.group,\n                        severity: obj.severity,\n                        eventAction: obj.eventAction,\n                        source: obj.source,\n                        summary: obj.summary,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   209,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   209,
											},
											File:   "pagerduty.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   209,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   207,
									},
									File:   "pagerduty.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 44,
										Line:   207,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   207,
										},
										File:   "pagerduty.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 44,
											Line:   207,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   207,
									},
									File:   "pagerduty.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 51,
										Line:   207,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   207,
								},
								File:   "pagerduty.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 33,
									Line:   207,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   207,
									},
									File:   "pagerduty.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 33,
										Line:   207,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   207,
							},
							File:   "pagerduty.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   207,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   207,
								},
								File:   "pagerduty.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   207,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   207,
								},
								File:   "pagerduty.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   207,
								},
							},
						},
						Name: "defaultURL",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "pagerduty.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "pagerduty.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   6,
					},
					File:   "pagerduty.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   6,
						},
						File:   "pagerduty.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   7,
					},
					File:   "pagerduty.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   7,
						},
						File:   "pagerduty.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "pagerduty.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package pagerduty provides functions for sending data to PagerDuty.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   2,
					},
					File:   "pagerduty.flux",
					Source: "package pagerduty",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   2,
						},
						File:   "pagerduty.flux",
						Source: "pagerduty",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "pagerduty",
			},
		},
	}},
	Package: "pagerduty",
	Path:    "pagerduty",
}
