// DO NOT EDIT: This file is autogenerated via the builtin command.

package naiveBayesClassifier

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   81,
				},
				File:   "naiveBayesClassifier.flux",
				Source: "package naiveBayesClassifier\n\n\nimport \"system\"\n\nnaiveBayes = (tables=<-, myClass, myField, myMeasurement) => {\n    training_data = tables\n        //data for 3 days\n        |> range(start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()\n\n    //|> yield(name: \"trainingData\")\n    test_data = tables\n        //data for 1 day\n        |> range(start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()\n\n    //|> yield(name: \"test data\")\n    //data preparation \n    r = training_data\n        |> group(columns: [\"_field\"])\n        |> count()\n        |> tableFind(fn: (key) => key._field == myField)\n    r2 = getRecord(table: r, idx: 0)\n    total_count = r2._value\n    P_Class_k = training_data\n        |> group(columns: [myClass, \"_field\"])\n        |> count()\n        |> map(fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n        |> group()\n\n    //one table for each class, where r.p_k == P(Class_k)\n    P_value_x = training_data\n        |> group(columns: [\"_value\", \"_field\"])\n        |> count(column: myClass)\n        |> map(fn: (r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))\n\n    // one table for each value, where r.p_x == P(value_x)\n    P_k_x = training_data\n        |> group(columns: [\"_field\", \"_value\", myClass])\n        |> reduce(\n            fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum}),\n            identity: {sum: 0.0},\n        )\n        |> group()\n\n    // one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\n    P_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n        |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})\n    P_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n\n    //added P(value_x) to table\n    //calculated probabilities for training data \n    Probability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n        |> map(fn: (r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x}))\n\n    //|> yield(name: \"final\")\n    //predictions for test data computed \n    predictOverall = (tables=<-) => {\n        r = tables\n            |> keep(columns: [\"_value\", \"Animal_name\", \"_field\"])\n        output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n\n        return output\n    }\n\n    return test_data |> predictOverall()\n}",
				Start: ast.Position{
					Column: 1,
					Line:   4,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   81,
					},
					File:   "naiveBayesClassifier.flux",
					Source: "naiveBayes = (tables=<-, myClass, myField, myMeasurement) => {\n    training_data = tables\n        //data for 3 days\n        |> range(start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()\n\n    //|> yield(name: \"trainingData\")\n    test_data = tables\n        //data for 1 day\n        |> range(start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()\n\n    //|> yield(name: \"test data\")\n    //data preparation \n    r = training_data\n        |> group(columns: [\"_field\"])\n        |> count()\n        |> tableFind(fn: (key) => key._field == myField)\n    r2 = getRecord(table: r, idx: 0)\n    total_count = r2._value\n    P_Class_k = training_data\n        |> group(columns: [myClass, \"_field\"])\n        |> count()\n        |> map(fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n        |> group()\n\n    //one table for each class, where r.p_k == P(Class_k)\n    P_value_x = training_data\n        |> group(columns: [\"_value\", \"_field\"])\n        |> count(column: myClass)\n        |> map(fn: (r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))\n\n    // one table for each value, where r.p_x == P(value_x)\n    P_k_x = training_data\n        |> group(columns: [\"_field\", \"_value\", myClass])\n        |> reduce(\n            fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum}),\n            identity: {sum: 0.0},\n        )\n        |> group()\n\n    // one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\n    P_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n        |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})\n    P_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n\n    //added P(value_x) to table\n    //calculated probabilities for training data \n    Probability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n        |> map(fn: (r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x}))\n\n    //|> yield(name: \"final\")\n    //predictions for test data computed \n    predictOverall = (tables=<-) => {\n        r = tables\n            |> keep(columns: [\"_value\", \"Animal_name\", \"_field\"])\n        output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n\n        return output\n    }\n\n    return test_data |> predictOverall()\n}",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   9,
						},
						File:   "naiveBayesClassifier.flux",
						Source: "naiveBayes",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "naiveBayes",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   81,
						},
						File:   "naiveBayesClassifier.flux",
						Source: "(tables=<-, myClass, myField, myMeasurement) => {\n    training_data = tables\n        //data for 3 days\n        |> range(start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()\n\n    //|> yield(name: \"trainingData\")\n    test_data = tables\n        //data for 1 day\n        |> range(start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()\n\n    //|> yield(name: \"test data\")\n    //data preparation \n    r = training_data\n        |> group(columns: [\"_field\"])\n        |> count()\n        |> tableFind(fn: (key) => key._field == myField)\n    r2 = getRecord(table: r, idx: 0)\n    total_count = r2._value\n    P_Class_k = training_data\n        |> group(columns: [myClass, \"_field\"])\n        |> count()\n        |> map(fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n        |> group()\n\n    //one table for each class, where r.p_k == P(Class_k)\n    P_value_x = training_data\n        |> group(columns: [\"_value\", \"_field\"])\n        |> count(column: myClass)\n        |> map(fn: (r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))\n\n    // one table for each value, where r.p_x == P(value_x)\n    P_k_x = training_data\n        |> group(columns: [\"_field\", \"_value\", myClass])\n        |> reduce(\n            fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum}),\n            identity: {sum: 0.0},\n        )\n        |> group()\n\n    // one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\n    P_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n        |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})\n    P_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n\n    //added P(value_x) to table\n    //calculated probabilities for training data \n    Probability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n        |> map(fn: (r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x}))\n\n    //|> yield(name: \"final\")\n    //predictions for test data computed \n    predictOverall = (tables=<-) => {\n        r = tables\n            |> keep(columns: [\"_value\", \"Animal_name\", \"_field\"])\n        output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n\n        return output\n    }\n\n    return test_data |> predictOverall()\n}",
						Start: ast.Position{
							Column: 14,
							Line:   9,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   81,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "{\n    training_data = tables\n        //data for 3 days\n        |> range(start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()\n\n    //|> yield(name: \"trainingData\")\n    test_data = tables\n        //data for 1 day\n        |> range(start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()\n\n    //|> yield(name: \"test data\")\n    //data preparation \n    r = training_data\n        |> group(columns: [\"_field\"])\n        |> count()\n        |> tableFind(fn: (key) => key._field == myField)\n    r2 = getRecord(table: r, idx: 0)\n    total_count = r2._value\n    P_Class_k = training_data\n        |> group(columns: [myClass, \"_field\"])\n        |> count()\n        |> map(fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n        |> group()\n\n    //one table for each class, where r.p_k == P(Class_k)\n    P_value_x = training_data\n        |> group(columns: [\"_value\", \"_field\"])\n        |> count(column: myClass)\n        |> map(fn: (r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))\n\n    // one table for each value, where r.p_x == P(value_x)\n    P_k_x = training_data\n        |> group(columns: [\"_field\", \"_value\", myClass])\n        |> reduce(\n            fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum}),\n            identity: {sum: 0.0},\n        )\n        |> group()\n\n    // one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\n    P_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n        |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})\n    P_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n\n    //added P(value_x) to table\n    //calculated probabilities for training data \n    Probability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n        |> map(fn: (r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x}))\n\n    //|> yield(name: \"final\")\n    //predictions for test data computed \n    predictOverall = (tables=<-) => {\n        r = tables\n            |> keep(columns: [\"_value\", \"Animal_name\", \"_field\"])\n        output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n\n        return output\n    }\n\n    return test_data |> predictOverall()\n}",
							Start: ast.Position{
								Column: 62,
								Line:   9,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   14,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "training_data = tables\n        //data for 3 days\n        |> range(start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()",
								Start: ast.Position{
									Column: 5,
									Line:   10,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   10,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data",
									Start: ast.Position{
										Column: 5,
										Line:   10,
									},
								},
							},
							Name: "training_data",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   10,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 21,
													Line:   10,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: []ast.Comment{ast.Comment{Text: "//data for 3 days\n"}},
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   12,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tables\n        //data for 3 days\n        |> range(start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)",
											Start: ast.Position{
												Column: 21,
												Line:   10,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   12,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z",
													Start: ast.Position{
														Column: 18,
														Line:   12,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   12,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "start: 2020-01-02T00:00:00Z",
														Start: ast.Position{
															Column: 18,
															Line:   12,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   12,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "start",
															Start: ast.Position{
																Column: 18,
																Line:   12,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.DateTimeLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   12,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "2020-01-02T00:00:00Z",
															Start: ast.Position{
																Column: 25,
																Line:   12,
															},
														},
													},
													Value: parser.MustParseTime("2020-01-02T00:00:00Z"),
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   12,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "stop: 2020-01-06T23:00:00Z",
														Start: ast.Position{
															Column: 47,
															Line:   12,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   12,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "stop",
															Start: ast.Position{
																Column: 47,
																Line:   12,
															},
														},
													},
													Name: "stop",
												},
												Separator: nil,
												Value: &ast.DateTimeLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   12,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "2020-01-06T23:00:00Z",
															Start: ast.Position{
																Column: 53,
																Line:   12,
															},
														},
													},
													Value: parser.MustParseTime("2020-01-06T23:00:00Z"),
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   12,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "range(start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)",
												Start: ast.Position{
													Column: 12,
													Line:   12,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   12,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "range",
													Start: ast.Position{
														Column: 12,
														Line:   12,
													},
												},
											},
											Name: "range",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   13,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "tables\n        //data for 3 days\n        |> range(start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)",
										Start: ast.Position{
											Column: 21,
											Line:   10,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   13,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
												Start: ast.Position{
													Column: 19,
													Line:   13,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   13,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
													Start: ast.Position{
														Column: 19,
														Line:   13,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   13,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 19,
															Line:   13,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 91,
															Line:   13,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "(r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
														Start: ast.Position{
															Column: 23,
															Line:   13,
														},
													},
												},
												Body: &ast.LogicalExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 91,
																Line:   13,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
															Start: ast.Position{
																Column: 30,
																Line:   13,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   13,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r[\"_measurement\"] == myMeasurement",
																Start: ast.Position{
																	Column: 30,
																	Line:   13,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   13,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r[\"_measurement\"]",
																	Start: ast.Position{
																		Column: 30,
																		Line:   13,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   13,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   13,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   13,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_measurement\"",
																		Start: ast.Position{
																			Column: 32,
																			Line:   13,
																		},
																	},
																},
																Value: "_measurement",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   13,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myMeasurement",
																	Start: ast.Position{
																		Column: 51,
																		Line:   13,
																	},
																},
															},
															Name: "myMeasurement",
														},
													},
													Operator: 1,
													Right: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 91,
																	Line:   13,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r[\"_field\"] == myField",
																Start: ast.Position{
																	Column: 69,
																	Line:   13,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   13,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r[\"_field\"]",
																	Start: ast.Position{
																		Column: 69,
																		Line:   13,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 70,
																			Line:   13,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 69,
																			Line:   13,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   13,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_field\"",
																		Start: ast.Position{
																			Column: 71,
																			Line:   13,
																		},
																	},
																},
																Value: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 91,
																		Line:   13,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myField",
																	Start: ast.Position{
																		Column: 84,
																		Line:   13,
																	},
																},
															},
															Name: "myField",
														},
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   13,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   13,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   13,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   13,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   13,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)",
											Start: ast.Position{
												Column: 12,
												Line:   13,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   13,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 12,
													Line:   13,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   14,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "tables\n        //data for 3 days\n        |> range(start: 2020-01-02T00:00:00Z, stop: 2020-01-06T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()",
									Start: ast.Position{
										Column: 21,
										Line:   10,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   14,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "group()",
										Start: ast.Position{
											Column: 12,
											Line:   14,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   14,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "group",
											Start: ast.Position{
												Column: 12,
												Line:   14,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   21,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "test_data = tables\n        //data for 1 day\n        |> range(start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()",
								Start: ast.Position{
									Column: 5,
									Line:   17,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//|> yield(name: \"trainingData\")\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   17,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "test_data",
									Start: ast.Position{
										Column: 5,
										Line:   17,
									},
								},
							},
							Name: "test_data",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   17,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 17,
													Line:   17,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: []ast.Comment{ast.Comment{Text: "//data for 1 day\n"}},
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   19,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tables\n        //data for 1 day\n        |> range(start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)",
											Start: ast.Position{
												Column: 17,
												Line:   17,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   19,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z",
													Start: ast.Position{
														Column: 18,
														Line:   19,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   19,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "start: 2020-01-01T00:00:00Z",
														Start: ast.Position{
															Column: 18,
															Line:   19,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   19,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "start",
															Start: ast.Position{
																Column: 18,
																Line:   19,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.DateTimeLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   19,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "2020-01-01T00:00:00Z",
															Start: ast.Position{
																Column: 25,
																Line:   19,
															},
														},
													},
													Value: parser.MustParseTime("2020-01-01T00:00:00Z"),
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   19,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "stop: 2020-01-01T23:00:00Z",
														Start: ast.Position{
															Column: 47,
															Line:   19,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   19,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "stop",
															Start: ast.Position{
																Column: 47,
																Line:   19,
															},
														},
													},
													Name: "stop",
												},
												Separator: nil,
												Value: &ast.DateTimeLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   19,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "2020-01-01T23:00:00Z",
															Start: ast.Position{
																Column: 53,
																Line:   19,
															},
														},
													},
													Value: parser.MustParseTime("2020-01-01T23:00:00Z"),
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   19,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "range(start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)",
												Start: ast.Position{
													Column: 12,
													Line:   19,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   19,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "range",
													Start: ast.Position{
														Column: 12,
														Line:   19,
													},
												},
											},
											Name: "range",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   20,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "tables\n        //data for 1 day\n        |> range(start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)",
										Start: ast.Position{
											Column: 17,
											Line:   17,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   20,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
												Start: ast.Position{
													Column: 19,
													Line:   20,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   20,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
													Start: ast.Position{
														Column: 19,
														Line:   20,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   20,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 19,
															Line:   20,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 91,
															Line:   20,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "(r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
														Start: ast.Position{
															Column: 23,
															Line:   20,
														},
													},
												},
												Body: &ast.LogicalExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 91,
																Line:   20,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField",
															Start: ast.Position{
																Column: 30,
																Line:   20,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   20,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r[\"_measurement\"] == myMeasurement",
																Start: ast.Position{
																	Column: 30,
																	Line:   20,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   20,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r[\"_measurement\"]",
																	Start: ast.Position{
																		Column: 30,
																		Line:   20,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   20,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   20,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   20,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_measurement\"",
																		Start: ast.Position{
																			Column: 32,
																			Line:   20,
																		},
																	},
																},
																Value: "_measurement",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   20,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myMeasurement",
																	Start: ast.Position{
																		Column: 51,
																		Line:   20,
																	},
																},
															},
															Name: "myMeasurement",
														},
													},
													Operator: 1,
													Right: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 91,
																	Line:   20,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r[\"_field\"] == myField",
																Start: ast.Position{
																	Column: 69,
																	Line:   20,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   20,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r[\"_field\"]",
																	Start: ast.Position{
																		Column: 69,
																		Line:   20,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 70,
																			Line:   20,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 69,
																			Line:   20,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   20,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_field\"",
																		Start: ast.Position{
																			Column: 71,
																			Line:   20,
																		},
																	},
																},
																Value: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 91,
																		Line:   20,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myField",
																	Start: ast.Position{
																		Column: 84,
																		Line:   20,
																	},
																},
															},
															Name: "myField",
														},
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   20,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   20,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   20,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   20,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   20,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)",
											Start: ast.Position{
												Column: 12,
												Line:   20,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   20,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 12,
													Line:   20,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   21,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "tables\n        //data for 1 day\n        |> range(start: 2020-01-01T00:00:00Z, stop: 2020-01-01T23:00:00Z)\n        |> filter(fn: (r) => r[\"_measurement\"] == myMeasurement and r[\"_field\"] == myField)\n        |> group()",
									Start: ast.Position{
										Column: 17,
										Line:   17,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   21,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "group()",
										Start: ast.Position{
											Column: 12,
											Line:   21,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   21,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "group",
											Start: ast.Position{
												Column: 12,
												Line:   21,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   28,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "r = training_data\n        |> group(columns: [\"_field\"])\n        |> count()\n        |> tableFind(fn: (key) => key._field == myField)",
								Start: ast.Position{
									Column: 5,
									Line:   25,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//|> yield(name: \"test data\")\n"}, ast.Comment{Text: "//data preparation \n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   25,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "r",
									Start: ast.Position{
										Column: 5,
										Line:   25,
									},
								},
							},
							Name: "r",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   25,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "training_data",
												Start: ast.Position{
													Column: 9,
													Line:   25,
												},
											},
										},
										Name: "training_data",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   26,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "training_data\n        |> group(columns: [\"_field\"])",
											Start: ast.Position{
												Column: 9,
												Line:   25,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   26,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [\"_field\"]",
													Start: ast.Position{
														Column: 18,
														Line:   26,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   26,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_field\"]",
														Start: ast.Position{
															Column: 18,
															Line:   26,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   26,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 18,
																Line:   26,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   26,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[\"_field\"]",
															Start: ast.Position{
																Column: 27,
																Line:   26,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   26,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_field\"",
																Start: ast.Position{
																	Column: 28,
																	Line:   26,
																},
															},
														},
														Value: "_field",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   26,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "group(columns: [\"_field\"])",
												Start: ast.Position{
													Column: 12,
													Line:   26,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   26,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group",
													Start: ast.Position{
														Column: 12,
														Line:   26,
													},
												},
											},
											Name: "group",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   27,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "training_data\n        |> group(columns: [\"_field\"])\n        |> count()",
										Start: ast.Position{
											Column: 9,
											Line:   25,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   27,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "count()",
											Start: ast.Position{
												Column: 12,
												Line:   27,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   27,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "count",
												Start: ast.Position{
													Column: 12,
													Line:   27,
												},
											},
										},
										Name: "count",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   28,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data\n        |> group(columns: [\"_field\"])\n        |> count()\n        |> tableFind(fn: (key) => key._field == myField)",
									Start: ast.Position{
										Column: 9,
										Line:   25,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   28,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "fn: (key) => key._field == myField",
											Start: ast.Position{
												Column: 22,
												Line:   28,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   28,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (key) => key._field == myField",
												Start: ast.Position{
													Column: 22,
													Line:   28,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   28,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 22,
														Line:   28,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   28,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "(key) => key._field == myField",
													Start: ast.Position{
														Column: 26,
														Line:   28,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   28,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "key._field == myField",
														Start: ast.Position{
															Column: 35,
															Line:   28,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   28,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "key._field",
															Start: ast.Position{
																Column: 35,
																Line:   28,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   28,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 35,
																	Line:   28,
																},
															},
														},
														Name: "key",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   28,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "_field",
																Start: ast.Position{
																	Column: 39,
																	Line:   28,
																},
															},
														},
														Name: "_field",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   28,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "myField",
															Start: ast.Position{
																Column: 49,
																Line:   28,
															},
														},
													},
													Name: "myField",
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   28,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "key",
														Start: ast.Position{
															Column: 27,
															Line:   28,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   28,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "key",
															Start: ast.Position{
																Column: 27,
																Line:   28,
															},
														},
													},
													Name: "key",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   28,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "tableFind(fn: (key) => key._field == myField)",
										Start: ast.Position{
											Column: 12,
											Line:   28,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   28,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tableFind",
											Start: ast.Position{
												Column: 12,
												Line:   28,
											},
										},
									},
									Name: "tableFind",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   29,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "r2 = getRecord(table: r, idx: 0)",
								Start: ast.Position{
									Column: 5,
									Line:   29,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   29,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "r2",
									Start: ast.Position{
										Column: 5,
										Line:   29,
									},
								},
							},
							Name: "r2",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   29,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "table: r, idx: 0",
										Start: ast.Position{
											Column: 20,
											Line:   29,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   29,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "table: r",
											Start: ast.Position{
												Column: 20,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   29,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "table",
												Start: ast.Position{
													Column: 20,
													Line:   29,
												},
											},
										},
										Name: "table",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   29,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "r",
												Start: ast.Position{
													Column: 27,
													Line:   29,
												},
											},
										},
										Name: "r",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   29,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "idx: 0",
											Start: ast.Position{
												Column: 30,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   29,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "idx",
												Start: ast.Position{
													Column: 30,
													Line:   29,
												},
											},
										},
										Name: "idx",
									},
									Separator: nil,
									Value: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   29,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "0",
												Start: ast.Position{
													Column: 35,
													Line:   29,
												},
											},
										},
										Value: int64(0),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   29,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "getRecord(table: r, idx: 0)",
									Start: ast.Position{
										Column: 10,
										Line:   29,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   29,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "getRecord",
										Start: ast.Position{
											Column: 10,
											Line:   29,
										},
									},
								},
								Name: "getRecord",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   30,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "total_count = r2._value",
								Start: ast.Position{
									Column: 5,
									Line:   30,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   30,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "total_count",
									Start: ast.Position{
										Column: 5,
										Line:   30,
									},
								},
							},
							Name: "total_count",
						},
						Init: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   30,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "r2._value",
									Start: ast.Position{
										Column: 19,
										Line:   30,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   30,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "r2",
										Start: ast.Position{
											Column: 19,
											Line:   30,
										},
									},
								},
								Name: "r2",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   30,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "_value",
										Start: ast.Position{
											Column: 22,
											Line:   30,
										},
									},
								},
								Name: "_value",
							},
							Rbrack: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   35,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_Class_k = training_data\n        |> group(columns: [myClass, \"_field\"])\n        |> count()\n        |> map(fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n        |> group()",
								Start: ast.Position{
									Column: 5,
									Line:   31,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   31,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_Class_k",
									Start: ast.Position{
										Column: 5,
										Line:   31,
									},
								},
							},
							Name: "P_Class_k",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   31,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "training_data",
													Start: ast.Position{
														Column: 17,
														Line:   31,
													},
												},
											},
											Name: "training_data",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   32,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "training_data\n        |> group(columns: [myClass, \"_field\"])",
												Start: ast.Position{
													Column: 17,
													Line:   31,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   32,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [myClass, \"_field\"]",
														Start: ast.Position{
															Column: 18,
															Line:   32,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   32,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns: [myClass, \"_field\"]",
															Start: ast.Position{
																Column: 18,
																Line:   32,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   32,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 18,
																	Line:   32,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   32,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "[myClass, \"_field\"]",
																Start: ast.Position{
																	Column: 27,
																	Line:   32,
																},
															},
														},
														Elements: []ast.Expression{&ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   32,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myClass",
																	Start: ast.Position{
																		Column: 28,
																		Line:   32,
																	},
																},
															},
															Name: "myClass",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   32,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_field\"",
																	Start: ast.Position{
																		Column: 37,
																		Line:   32,
																	},
																},
															},
															Value: "_field",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   32,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group(columns: [myClass, \"_field\"])",
													Start: ast.Position{
														Column: 12,
														Line:   32,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   32,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "group",
														Start: ast.Position{
															Column: 12,
															Line:   32,
														},
													},
												},
												Name: "group",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   33,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "training_data\n        |> group(columns: [myClass, \"_field\"])\n        |> count()",
											Start: ast.Position{
												Column: 17,
												Line:   31,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   33,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "count()",
												Start: ast.Position{
													Column: 12,
													Line:   33,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   33,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "count",
													Start: ast.Position{
														Column: 12,
														Line:   33,
													},
												},
											},
											Name: "count",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 103,
											Line:   34,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "training_data\n        |> group(columns: [myClass, \"_field\"])\n        |> count()\n        |> map(fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))",
										Start: ast.Position{
											Column: 17,
											Line:   31,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 102,
													Line:   34,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count})",
												Start: ast.Position{
													Column: 16,
													Line:   34,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 102,
														Line:   34,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count})",
													Start: ast.Position{
														Column: 16,
														Line:   34,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   34,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   34,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 102,
															Line:   34,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "(r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count})",
														Start: ast.Position{
															Column: 20,
															Line:   34,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 102,
																Line:   34,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count})",
															Start: ast.Position{
																Column: 27,
																Line:   34,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 101,
																	Line:   34,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "{r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}",
																Start: ast.Position{
																	Column: 28,
																	Line:   34,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 83,
																		Line:   34,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "p_k: float(v: r._value) / float(v: total_count)",
																	Start: ast.Position{
																		Column: 36,
																		Line:   34,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   34,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "p_k",
																		Start: ast.Position{
																			Column: 36,
																			Line:   34,
																		},
																	},
																},
																Name: "p_k",
															},
															Separator: nil,
															Value: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 83,
																			Line:   34,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "float(v: r._value) / float(v: total_count)",
																		Start: ast.Position{
																			Column: 41,
																			Line:   34,
																		},
																	},
																},
																Left: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   34,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 47,
																					Line:   34,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 58,
																						Line:   34,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v: r._value",
																					Start: ast.Position{
																						Column: 47,
																						Line:   34,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 48,
																							Line:   34,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 47,
																							Line:   34,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 58,
																							Line:   34,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 50,
																							Line:   34,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 51,
																								Line:   34,
																							},
																							File:   "naiveBayesClassifier.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 50,
																								Line:   34,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 58,
																								Line:   34,
																							},
																							File:   "naiveBayesClassifier.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 52,
																								Line:   34,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   34,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float(v: r._value)",
																			Start: ast.Position{
																				Column: 41,
																				Line:   34,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 46,
																					Line:   34,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "float",
																				Start: ast.Position{
																					Column: 41,
																					Line:   34,
																				},
																			},
																		},
																		Name: "float",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
																Operator: 2,
																Right: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 82,
																					Line:   34,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: total_count",
																				Start: ast.Position{
																					Column: 68,
																					Line:   34,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 82,
																						Line:   34,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v: total_count",
																					Start: ast.Position{
																						Column: 68,
																						Line:   34,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 69,
																							Line:   34,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 68,
																							Line:   34,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 82,
																							Line:   34,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "total_count",
																						Start: ast.Position{
																							Column: 71,
																							Line:   34,
																						},
																					},
																				},
																				Name: "total_count",
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 83,
																				Line:   34,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float(v: total_count)",
																			Start: ast.Position{
																				Column: 62,
																				Line:   34,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 67,
																					Line:   34,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "float",
																				Start: ast.Position{
																					Column: 62,
																					Line:   34,
																				},
																			},
																		},
																		Name: "float",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 100,
																		Line:   34,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "tc: total_count",
																	Start: ast.Position{
																		Column: 85,
																		Line:   34,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   34,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "tc",
																		Start: ast.Position{
																			Column: 85,
																			Line:   34,
																		},
																	},
																},
																Name: "tc",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 100,
																			Line:   34,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "total_count",
																		Start: ast.Position{
																			Column: 89,
																			Line:   34,
																		},
																	},
																},
																Name: "total_count",
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   34,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   34,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   34,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   34,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   34,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   34,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   34,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "map(fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))",
											Start: ast.Position{
												Column: 12,
												Line:   34,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   34,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "map",
												Start: ast.Position{
													Column: 12,
													Line:   34,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   35,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data\n        |> group(columns: [myClass, \"_field\"])\n        |> count()\n        |> map(fn: (r) => ({r with p_k: float(v: r._value) / float(v: total_count), tc: total_count}))\n        |> group()",
									Start: ast.Position{
										Column: 17,
										Line:   31,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   35,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "group()",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   35,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "group",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   41,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_value_x = training_data\n        |> group(columns: [\"_value\", \"_field\"])\n        |> count(column: myClass)\n        |> map(fn: (r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))",
								Start: ast.Position{
									Column: 5,
									Line:   38,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//one table for each class, where r.p_k == P(Class_k)\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   38,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_value_x",
									Start: ast.Position{
										Column: 5,
										Line:   38,
									},
								},
							},
							Name: "P_value_x",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   38,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "training_data",
												Start: ast.Position{
													Column: 17,
													Line:   38,
												},
											},
										},
										Name: "training_data",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   39,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "training_data\n        |> group(columns: [\"_value\", \"_field\"])",
											Start: ast.Position{
												Column: 17,
												Line:   38,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   39,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [\"_value\", \"_field\"]",
													Start: ast.Position{
														Column: 18,
														Line:   39,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   39,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_value\", \"_field\"]",
														Start: ast.Position{
															Column: 18,
															Line:   39,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   39,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 18,
																Line:   39,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   39,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[\"_value\", \"_field\"]",
															Start: ast.Position{
																Column: 27,
																Line:   39,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   39,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_value\"",
																Start: ast.Position{
																	Column: 28,
																	Line:   39,
																},
															},
														},
														Value: "_value",
													}, &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   39,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_field\"",
																Start: ast.Position{
																	Column: 38,
																	Line:   39,
																},
															},
														},
														Value: "_field",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   39,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "group(columns: [\"_value\", \"_field\"])",
												Start: ast.Position{
													Column: 12,
													Line:   39,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   39,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group",
													Start: ast.Position{
														Column: 12,
														Line:   39,
													},
												},
											},
											Name: "group",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   40,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "training_data\n        |> group(columns: [\"_value\", \"_field\"])\n        |> count(column: myClass)",
										Start: ast.Position{
											Column: 17,
											Line:   38,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   40,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "column: myClass",
												Start: ast.Position{
													Column: 18,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   40,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "column: myClass",
													Start: ast.Position{
														Column: 18,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   40,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "column",
														Start: ast.Position{
															Column: 18,
															Line:   40,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   40,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "myClass",
														Start: ast.Position{
															Column: 26,
															Line:   40,
														},
													},
												},
												Name: "myClass",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   40,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "count(column: myClass)",
											Start: ast.Position{
												Column: 12,
												Line:   40,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   40,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "count",
												Start: ast.Position{
													Column: 12,
													Line:   40,
												},
											},
										},
										Name: "count",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 105,
										Line:   41,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data\n        |> group(columns: [\"_value\", \"_field\"])\n        |> count(column: myClass)\n        |> map(fn: (r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))",
									Start: ast.Position{
										Column: 17,
										Line:   38,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   41,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "fn: (r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count})",
											Start: ast.Position{
												Column: 16,
												Line:   41,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 104,
													Line:   41,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count})",
												Start: ast.Position{
													Column: 16,
													Line:   41,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   41,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 16,
														Line:   41,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 104,
														Line:   41,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "(r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count})",
													Start: ast.Position{
														Column: 20,
														Line:   41,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 104,
															Line:   41,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count})",
														Start: ast.Position{
															Column: 27,
															Line:   41,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 103,
																Line:   41,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "{r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}",
															Start: ast.Position{
																Column: 28,
																Line:   41,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   41,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "p_x: float(v: r.airborne) / float(v: total_count)",
																Start: ast.Position{
																	Column: 36,
																	Line:   41,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   41,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "p_x",
																	Start: ast.Position{
																		Column: 36,
																		Line:   41,
																	},
																},
															},
															Name: "p_x",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 85,
																		Line:   41,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "float(v: r.airborne) / float(v: total_count)",
																	Start: ast.Position{
																		Column: 41,
																		Line:   41,
																	},
																},
															},
															Left: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   41,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "v: r.airborne",
																			Start: ast.Position{
																				Column: 47,
																				Line:   41,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   41,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: r.airborne",
																				Start: ast.Position{
																					Column: 47,
																					Line:   41,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 48,
																						Line:   41,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 47,
																						Line:   41,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 60,
																						Line:   41,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "r.airborne",
																					Start: ast.Position{
																						Column: 50,
																						Line:   41,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 51,
																							Line:   41,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 50,
																							Line:   41,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 60,
																							Line:   41,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "airborne",
																						Start: ast.Position{
																							Column: 52,
																							Line:   41,
																						},
																					},
																				},
																				Name: "airborne",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   41,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "float(v: r.airborne)",
																		Start: ast.Position{
																			Column: 41,
																			Line:   41,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   41,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 41,
																				Line:   41,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
															Operator: 2,
															Right: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 84,
																				Line:   41,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "v: total_count",
																			Start: ast.Position{
																				Column: 70,
																				Line:   41,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 84,
																					Line:   41,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: total_count",
																				Start: ast.Position{
																					Column: 70,
																					Line:   41,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 71,
																						Line:   41,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 70,
																						Line:   41,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 84,
																						Line:   41,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "total_count",
																					Start: ast.Position{
																						Column: 73,
																						Line:   41,
																					},
																				},
																			},
																			Name: "total_count",
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 85,
																			Line:   41,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "float(v: total_count)",
																		Start: ast.Position{
																			Column: 64,
																			Line:   41,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   41,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 64,
																				Line:   41,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 102,
																	Line:   41,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "tc: total_count",
																Start: ast.Position{
																	Column: 87,
																	Line:   41,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 89,
																		Line:   41,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "tc",
																	Start: ast.Position{
																		Column: 87,
																		Line:   41,
																	},
																},
															},
															Name: "tc",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 102,
																		Line:   41,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "total_count",
																	Start: ast.Position{
																		Column: 91,
																		Line:   41,
																	},
																},
															},
															Name: "total_count",
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   41,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 29,
																	Line:   41,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   41,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "r",
														Start: ast.Position{
															Column: 21,
															Line:   41,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   41,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   41,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 105,
											Line:   41,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "map(fn: (r) => ({r with p_x: float(v: r.airborne) / float(v: total_count), tc: total_count}))",
										Start: ast.Position{
											Column: 12,
											Line:   41,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   41,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "map",
											Start: ast.Position{
												Column: 12,
												Line:   41,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   50,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_k_x = training_data\n        |> group(columns: [\"_field\", \"_value\", myClass])\n        |> reduce(\n            fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum}),\n            identity: {sum: 0.0},\n        )\n        |> group()",
								Start: ast.Position{
									Column: 5,
									Line:   44,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// one table for each value, where r.p_x == P(value_x)\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   44,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_k_x",
									Start: ast.Position{
										Column: 5,
										Line:   44,
									},
								},
							},
							Name: "P_k_x",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   44,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "training_data",
												Start: ast.Position{
													Column: 13,
													Line:   44,
												},
											},
										},
										Name: "training_data",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   45,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "training_data\n        |> group(columns: [\"_field\", \"_value\", myClass])",
											Start: ast.Position{
												Column: 13,
												Line:   44,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   45,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [\"_field\", \"_value\", myClass]",
													Start: ast.Position{
														Column: 18,
														Line:   45,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   45,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_field\", \"_value\", myClass]",
														Start: ast.Position{
															Column: 18,
															Line:   45,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   45,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 18,
																Line:   45,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   45,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[\"_field\", \"_value\", myClass]",
															Start: ast.Position{
																Column: 27,
																Line:   45,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   45,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_field\"",
																Start: ast.Position{
																	Column: 28,
																	Line:   45,
																},
															},
														},
														Value: "_field",
													}, &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   45,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_value\"",
																Start: ast.Position{
																	Column: 38,
																	Line:   45,
																},
															},
														},
														Value: "_value",
													}, &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   45,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "myClass",
																Start: ast.Position{
																	Column: 48,
																	Line:   45,
																},
															},
														},
														Name: "myClass",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   45,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "group(columns: [\"_field\", \"_value\", myClass])",
												Start: ast.Position{
													Column: 12,
													Line:   45,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   45,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group",
													Start: ast.Position{
														Column: 12,
														Line:   45,
													},
												},
											},
											Name: "group",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   49,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "training_data\n        |> group(columns: [\"_field\", \"_value\", myClass])\n        |> reduce(\n            fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum}),\n            identity: {sum: 0.0},\n        )",
										Start: ast.Position{
											Column: 13,
											Line:   44,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   48,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum}),\n            identity: {sum: 0.0}",
												Start: ast.Position{
													Column: 13,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   47,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum})",
													Start: ast.Position{
														Column: 13,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   47,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 13,
															Line:   47,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   47,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "(r, accumulator) => ({sum: 1.0 + accumulator.sum})",
														Start: ast.Position{
															Column: 17,
															Line:   47,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   47,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "({sum: 1.0 + accumulator.sum})",
															Start: ast.Position{
																Column: 37,
																Line:   47,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 66,
																	Line:   47,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "{sum: 1.0 + accumulator.sum}",
																Start: ast.Position{
																	Column: 38,
																	Line:   47,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   47,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "sum: 1.0 + accumulator.sum",
																	Start: ast.Position{
																		Column: 39,
																		Line:   47,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   47,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "sum",
																		Start: ast.Position{
																			Column: 39,
																			Line:   47,
																		},
																	},
																},
																Name: "sum",
															},
															Separator: nil,
															Value: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 65,
																			Line:   47,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "1.0 + accumulator.sum",
																		Start: ast.Position{
																			Column: 44,
																			Line:   47,
																		},
																	},
																},
																Left: &ast.FloatLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 47,
																				Line:   47,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "1.0",
																			Start: ast.Position{
																				Column: 44,
																				Line:   47,
																			},
																		},
																	},
																	Value: 1.0,
																},
																Operator: 5,
																Right: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   47,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "accumulator.sum",
																			Start: ast.Position{
																				Column: 50,
																				Line:   47,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   47,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "accumulator",
																				Start: ast.Position{
																					Column: 50,
																					Line:   47,
																				},
																			},
																		},
																		Name: "accumulator",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 65,
																					Line:   47,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "sum",
																				Start: ast.Position{
																					Column: 62,
																					Line:   47,
																				},
																			},
																		},
																		Name: "sum",
																	},
																	Rbrack: nil,
																},
															},
														}},
														Rbrace: nil,
														With:   nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   47,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 18,
																Line:   47,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   47,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 18,
																	Line:   47,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   47,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 21,
																Line:   47,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   47,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "accumulator",
																Start: ast.Position{
																	Column: 21,
																	Line:   47,
																},
															},
														},
														Name: "accumulator",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   48,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "identity: {sum: 0.0}",
													Start: ast.Position{
														Column: 13,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   48,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "identity",
														Start: ast.Position{
															Column: 13,
															Line:   48,
														},
													},
												},
												Name: "identity",
											},
											Separator: nil,
											Value: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   48,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "{sum: 0.0}",
														Start: ast.Position{
															Column: 23,
															Line:   48,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   48,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "sum: 0.0",
															Start: ast.Position{
																Column: 24,
																Line:   48,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   48,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "sum",
																Start: ast.Position{
																	Column: 24,
																	Line:   48,
																},
															},
														},
														Name: "sum",
													},
													Separator: nil,
													Value: &ast.FloatLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   48,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "0.0",
																Start: ast.Position{
																	Column: 29,
																	Line:   48,
																},
															},
														},
														Value: 0.0,
													},
												}},
												Rbrace: nil,
												With:   nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   49,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "reduce(\n            fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum}),\n            identity: {sum: 0.0},\n        )",
											Start: ast.Position{
												Column: 12,
												Line:   46,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   46,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "reduce",
												Start: ast.Position{
													Column: 12,
													Line:   46,
												},
											},
										},
										Name: "reduce",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   50,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "training_data\n        |> group(columns: [\"_field\", \"_value\", myClass])\n        |> reduce(\n            fn: (r, accumulator) => ({sum: 1.0 + accumulator.sum}),\n            identity: {sum: 0.0},\n        )\n        |> group()",
									Start: ast.Position{
										Column: 13,
										Line:   44,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   50,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "group()",
										Start: ast.Position{
											Column: 12,
											Line:   50,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   50,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "group",
											Start: ast.Position{
												Column: 12,
												Line:   50,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   58,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_k_x_class = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n        |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})",
								Start: ast.Position{
									Column: 5,
									Line:   53,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// one table for each value and Class pair, where r.p_k_x == P(value_x | Class_k)\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   53,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_k_x_class",
									Start: ast.Position{
										Column: 5,
										Line:   53,
									},
								},
							},
							Name: "P_k_x_class",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 100,
																Line:   53,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\"",
															Start: ast.Position{
																Column: 24,
																Line:   53,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   53,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}",
																Start: ast.Position{
																	Column: 24,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "tables",
																	Start: ast.Position{
																		Column: 24,
																		Line:   53,
																	},
																},
															},
															Name: "tables",
														},
														Separator: nil,
														Value: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "{P_k_x: P_k_x, P_Class_k: P_Class_k}",
																	Start: ast.Position{
																		Column: 32,
																		Line:   53,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 45,
																			Line:   53,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_k_x: P_k_x",
																		Start: ast.Position{
																			Column: 33,
																			Line:   53,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   53,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_k_x",
																			Start: ast.Position{
																				Column: 33,
																				Line:   53,
																			},
																		},
																	},
																	Name: "P_k_x",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   53,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_k_x",
																			Start: ast.Position{
																				Column: 40,
																				Line:   53,
																			},
																		},
																	},
																	Name: "P_k_x",
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 67,
																			Line:   53,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_Class_k: P_Class_k",
																		Start: ast.Position{
																			Column: 47,
																			Line:   53,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   53,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_Class_k",
																			Start: ast.Position{
																				Column: 47,
																				Line:   53,
																			},
																		},
																	},
																	Name: "P_Class_k",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   53,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_Class_k",
																			Start: ast.Position{
																				Column: 58,
																				Line:   53,
																			},
																		},
																	},
																	Name: "P_Class_k",
																},
															}},
															Rbrace: nil,
															With:   nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 83,
																	Line:   53,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "on: [myClass]",
																Start: ast.Position{
																	Column: 70,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "on",
																	Start: ast.Position{
																		Column: 70,
																		Line:   53,
																	},
																},
															},
															Name: "on",
														},
														Separator: nil,
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 83,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "[myClass]",
																	Start: ast.Position{
																		Column: 74,
																		Line:   53,
																	},
																},
															},
															Elements: []ast.Expression{&ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 82,
																			Line:   53,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "myClass",
																		Start: ast.Position{
																			Column: 75,
																			Line:   53,
																		},
																	},
																},
																Name: "myClass",
															}},
															Lbrack: nil,
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 100,
																	Line:   53,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "method: \"inner\"",
																Start: ast.Position{
																	Column: 85,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 91,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "method",
																	Start: ast.Position{
																		Column: 85,
																		Line:   53,
																	},
																},
															},
															Name: "method",
														},
														Separator: nil,
														Value: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 100,
																		Line:   53,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"inner\"",
																	Start: ast.Position{
																		Column: 93,
																		Line:   53,
																	},
																},
															},
															Value: "inner",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 101,
															Line:   53,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")",
														Start: ast.Position{
															Column: 19,
															Line:   53,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   53,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "join",
															Start: ast.Position{
																Column: 19,
																Line:   53,
															},
														},
													},
													Name: "join",
												},
												Lparen: nil,
												Rparen: nil,
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   54,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])",
													Start: ast.Position{
														Column: 19,
														Line:   53,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   54,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns: [myClass, \"_value_P_k_x\"]",
															Start: ast.Position{
																Column: 18,
																Line:   54,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 52,
																	Line:   54,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "columns: [myClass, \"_value_P_k_x\"]",
																Start: ast.Position{
																	Column: 18,
																	Line:   54,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   54,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "columns",
																	Start: ast.Position{
																		Column: 18,
																		Line:   54,
																	},
																},
															},
															Name: "columns",
														},
														Separator: nil,
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 52,
																		Line:   54,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "[myClass, \"_value_P_k_x\"]",
																	Start: ast.Position{
																		Column: 27,
																		Line:   54,
																	},
																},
															},
															Elements: []ast.Expression{&ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 35,
																			Line:   54,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "myClass",
																		Start: ast.Position{
																			Column: 28,
																			Line:   54,
																		},
																	},
																},
																Name: "myClass",
															}, &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 51,
																			Line:   54,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "\"_value_P_k_x\"",
																		Start: ast.Position{
																			Column: 37,
																			Line:   54,
																		},
																	},
																},
																Value: "_value_P_k_x",
															}},
															Lbrack: nil,
															Rbrack: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   54,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "group(columns: [myClass, \"_value_P_k_x\"])",
														Start: ast.Position{
															Column: 12,
															Line:   54,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   54,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "group",
															Start: ast.Position{
																Column: 12,
																Line:   54,
															},
														},
													},
													Name: "group",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   55,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)",
												Start: ast.Position{
													Column: 19,
													Line:   53,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   55,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "n: 1",
														Start: ast.Position{
															Column: 18,
															Line:   55,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   55,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "n: 1",
															Start: ast.Position{
																Column: 18,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   55,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "n",
																Start: ast.Position{
																	Column: 18,
																	Line:   55,
																},
															},
														},
														Name: "n",
													},
													Separator: nil,
													Value: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   55,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "1",
																Start: ast.Position{
																	Column: 21,
																	Line:   55,
																},
															},
														},
														Value: int64(1),
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   55,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "limit(n: 1)",
													Start: ast.Position{
														Column: 12,
														Line:   55,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   55,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "limit",
														Start: ast.Position{
															Column: 12,
															Line:   55,
														},
													},
												},
												Name: "limit",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   56,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
											Start: ast.Position{
												Column: 19,
												Line:   53,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 81,
														Line:   56,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
													Start: ast.Position{
														Column: 16,
														Line:   56,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 81,
															Line:   56,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
														Start: ast.Position{
															Column: 16,
															Line:   56,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   56,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 16,
																Line:   56,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 81,
																Line:   56,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "(r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
															Start: ast.Position{
																Column: 20,
																Line:   56,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 81,
																	Line:   56,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
																Start: ast.Position{
																	Column: 27,
																	Line:   56,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   56,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "{r with P_x_k: r.sum / float(v: r._value_P_Class_k)}",
																	Start: ast.Position{
																		Column: 28,
																		Line:   56,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   56,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_x_k: r.sum / float(v: r._value_P_Class_k)",
																		Start: ast.Position{
																			Column: 36,
																			Line:   56,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   56,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "P_x_k",
																			Start: ast.Position{
																				Column: 36,
																				Line:   56,
																			},
																		},
																	},
																	Name: "P_x_k",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 79,
																				Line:   56,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r.sum / float(v: r._value_P_Class_k)",
																			Start: ast.Position{
																				Column: 43,
																				Line:   56,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 48,
																					Line:   56,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "r.sum",
																				Start: ast.Position{
																					Column: 43,
																					Line:   56,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 44,
																						Line:   56,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 43,
																						Line:   56,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 48,
																						Line:   56,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "sum",
																					Start: ast.Position{
																						Column: 45,
																						Line:   56,
																					},
																				},
																			},
																			Name: "sum",
																		},
																		Rbrack: nil,
																	},
																	Operator: 2,
																	Right: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 78,
																						Line:   56,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v: r._value_P_Class_k",
																					Start: ast.Position{
																						Column: 57,
																						Line:   56,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 78,
																							Line:   56,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "v: r._value_P_Class_k",
																						Start: ast.Position{
																							Column: 57,
																							Line:   56,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 58,
																								Line:   56,
																							},
																							File:   "naiveBayesClassifier.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 57,
																								Line:   56,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 78,
																								Line:   56,
																							},
																							File:   "naiveBayesClassifier.flux",
																							Source: "r._value_P_Class_k",
																							Start: ast.Position{
																								Column: 60,
																								Line:   56,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 61,
																									Line:   56,
																								},
																								File:   "naiveBayesClassifier.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 60,
																									Line:   56,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 78,
																									Line:   56,
																								},
																								File:   "naiveBayesClassifier.flux",
																								Source: "_value_P_Class_k",
																								Start: ast.Position{
																									Column: 62,
																									Line:   56,
																								},
																							},
																						},
																						Name: "_value_P_Class_k",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 79,
																					Line:   56,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "float(v: r._value_P_Class_k)",
																				Start: ast.Position{
																					Column: 51,
																					Line:   56,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 56,
																						Line:   56,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "float",
																					Start: ast.Position{
																						Column: 51,
																						Line:   56,
																					},
																				},
																			},
																			Name: "float",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																},
															}},
															Rbrace: nil,
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   56,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   56,
																		},
																	},
																},
																Name: "r",
															},
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   56,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   56,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   56,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   56,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   56,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
												Start: ast.Position{
													Column: 12,
													Line:   56,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   56,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "map",
													Start: ast.Position{
														Column: 12,
														Line:   56,
													},
												},
											},
											Name: "map",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   57,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])",
										Start: ast.Position{
											Column: 19,
											Line:   53,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   57,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"]",
												Start: ast.Position{
													Column: 17,
													Line:   57,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   57,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"]",
													Start: ast.Position{
														Column: 17,
														Line:   57,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   57,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   57,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   57,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "[\"_field_P_Class_k\", \"_value_P_Class_k\"]",
														Start: ast.Position{
															Column: 26,
															Line:   57,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   57,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"_field_P_Class_k\"",
															Start: ast.Position{
																Column: 27,
																Line:   57,
															},
														},
													},
													Value: "_field_P_Class_k",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   57,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"_value_P_Class_k\"",
															Start: ast.Position{
																Column: 47,
																Line:   57,
															},
														},
													},
													Value: "_value_P_Class_k",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   57,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])",
											Start: ast.Position{
												Column: 12,
												Line:   57,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   57,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   57,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   58,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\"])\n        |> rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})",
									Start: ast.Position{
										Column: 19,
										Line:   53,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   58,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"}",
											Start: ast.Position{
												Column: 19,
												Line:   58,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   58,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"}",
												Start: ast.Position{
													Column: 19,
													Line:   58,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   58,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 19,
														Line:   58,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   58,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "{_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"}",
													Start: ast.Position{
														Column: 28,
														Line:   58,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   58,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "_field_P_k_x: \"_field\"",
														Start: ast.Position{
															Column: 29,
															Line:   58,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   58,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "_field_P_k_x",
															Start: ast.Position{
																Column: 29,
																Line:   58,
															},
														},
													},
													Name: "_field_P_k_x",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   58,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 43,
																Line:   58,
															},
														},
													},
													Value: "_field",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   58,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "_value_P_k_x: \"_value\"",
														Start: ast.Position{
															Column: 53,
															Line:   58,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   58,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "_value_P_k_x",
															Start: ast.Position{
																Column: 53,
																Line:   58,
															},
														},
													},
													Name: "_value_P_k_x",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   58,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"_value\"",
															Start: ast.Position{
																Column: 67,
																Line:   58,
															},
														},
													},
													Value: "_value",
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   58,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "rename(columns: {_field_P_k_x: \"_field\", _value_P_k_x: \"_value\"})",
										Start: ast.Position{
											Column: 12,
											Line:   58,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   58,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 12,
												Line:   58,
											},
										},
									},
									Name: "rename",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   63,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "P_k_x_class_Drop = join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
								Start: ast.Position{
									Column: 5,
									Line:   59,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   59,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "P_k_x_class_Drop",
									Start: ast.Position{
										Column: 5,
										Line:   59,
									},
								},
							},
							Name: "P_k_x_class_Drop",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 105,
															Line:   59,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\"",
														Start: ast.Position{
															Column: 29,
															Line:   59,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   59,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}",
															Start: ast.Position{
																Column: 29,
																Line:   59,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   59,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "tables",
																Start: ast.Position{
																	Column: 29,
																	Line:   59,
																},
															},
														},
														Name: "tables",
													},
													Separator: nil,
													Value: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   59,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "{P_k_x: P_k_x, P_Class_k: P_Class_k}",
																Start: ast.Position{
																	Column: 37,
																	Line:   59,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   59,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "P_k_x: P_k_x",
																	Start: ast.Position{
																		Column: 38,
																		Line:   59,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   59,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_k_x",
																		Start: ast.Position{
																			Column: 38,
																			Line:   59,
																		},
																	},
																},
																Name: "P_k_x",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   59,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_k_x",
																		Start: ast.Position{
																			Column: 45,
																			Line:   59,
																		},
																	},
																},
																Name: "P_k_x",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   59,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "P_Class_k: P_Class_k",
																	Start: ast.Position{
																		Column: 52,
																		Line:   59,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   59,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_Class_k",
																		Start: ast.Position{
																			Column: 52,
																			Line:   59,
																		},
																	},
																},
																Name: "P_Class_k",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   59,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "P_Class_k",
																		Start: ast.Position{
																			Column: 63,
																			Line:   59,
																		},
																	},
																},
																Name: "P_Class_k",
															},
														}},
														Rbrace: nil,
														With:   nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 88,
																Line:   59,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "on: [myClass]",
															Start: ast.Position{
																Column: 75,
																Line:   59,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   59,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "on",
																Start: ast.Position{
																	Column: 75,
																	Line:   59,
																},
															},
														},
														Name: "on",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 88,
																	Line:   59,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "[myClass]",
																Start: ast.Position{
																	Column: 79,
																	Line:   59,
																},
															},
														},
														Elements: []ast.Expression{&ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   59,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "myClass",
																	Start: ast.Position{
																		Column: 80,
																		Line:   59,
																	},
																},
															},
															Name: "myClass",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 105,
																Line:   59,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "method: \"inner\"",
															Start: ast.Position{
																Column: 90,
																Line:   59,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 96,
																	Line:   59,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "method",
																Start: ast.Position{
																	Column: 90,
																	Line:   59,
																},
															},
														},
														Name: "method",
													},
													Separator: nil,
													Value: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 105,
																	Line:   59,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"inner\"",
																Start: ast.Position{
																	Column: 98,
																	Line:   59,
																},
															},
														},
														Value: "inner",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 106,
														Line:   59,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")",
													Start: ast.Position{
														Column: 24,
														Line:   59,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   59,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "join",
														Start: ast.Position{
															Column: 24,
															Line:   59,
														},
													},
												},
												Name: "join",
											},
											Lparen: nil,
											Rparen: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   60,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])",
												Start: ast.Position{
													Column: 24,
													Line:   59,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   60,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"]",
														Start: ast.Position{
															Column: 17,
															Line:   60,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   60,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"]",
															Start: ast.Position{
																Column: 17,
																Line:   60,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   60,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 17,
																	Line:   60,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 82,
																	Line:   60,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "[\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"]",
																Start: ast.Position{
																	Column: 26,
																	Line:   60,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   60,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_field_P_Class_k\"",
																	Start: ast.Position{
																		Column: 27,
																		Line:   60,
																	},
																},
															},
															Value: "_field_P_Class_k",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   60,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_value_P_Class_k\"",
																	Start: ast.Position{
																		Column: 47,
																		Line:   60,
																	},
																},
															},
															Value: "_value_P_Class_k",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 81,
																		Line:   60,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_field_P_k_x\"",
																	Start: ast.Position{
																		Column: 67,
																		Line:   60,
																	},
																},
															},
															Value: "_field_P_k_x",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   60,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])",
													Start: ast.Position{
														Column: 12,
														Line:   60,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   60,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "drop",
														Start: ast.Position{
															Column: 12,
															Line:   60,
														},
													},
												},
												Name: "drop",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   61,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n        |> group(columns: [myClass, \"_value_P_k_x\"])",
											Start: ast.Position{
												Column: 24,
												Line:   59,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   61,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "columns: [myClass, \"_value_P_k_x\"]",
													Start: ast.Position{
														Column: 18,
														Line:   61,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   61,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [myClass, \"_value_P_k_x\"]",
														Start: ast.Position{
															Column: 18,
															Line:   61,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   61,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 18,
																Line:   61,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   61,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[myClass, \"_value_P_k_x\"]",
															Start: ast.Position{
																Column: 27,
																Line:   61,
															},
														},
													},
													Elements: []ast.Expression{&ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   61,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "myClass",
																Start: ast.Position{
																	Column: 28,
																	Line:   61,
																},
															},
														},
														Name: "myClass",
													}, &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   61,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_value_P_k_x\"",
																Start: ast.Position{
																	Column: 37,
																	Line:   61,
																},
															},
														},
														Value: "_value_P_k_x",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   61,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "group(columns: [myClass, \"_value_P_k_x\"])",
												Start: ast.Position{
													Column: 12,
													Line:   61,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   61,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "group",
													Start: ast.Position{
														Column: 12,
														Line:   61,
													},
												},
											},
											Name: "group",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   62,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)",
										Start: ast.Position{
											Column: 24,
											Line:   59,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   62,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "n: 1",
												Start: ast.Position{
													Column: 18,
													Line:   62,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   62,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "n: 1",
													Start: ast.Position{
														Column: 18,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   62,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "n",
														Start: ast.Position{
															Column: 18,
															Line:   62,
														},
													},
												},
												Name: "n",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   62,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "1",
														Start: ast.Position{
															Column: 21,
															Line:   62,
														},
													},
												},
												Value: int64(1),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   62,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "limit(n: 1)",
											Start: ast.Position{
												Column: 12,
												Line:   62,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   62,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "limit",
												Start: ast.Position{
													Column: 12,
													Line:   62,
												},
											},
										},
										Name: "limit",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   63,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "join(tables: {P_k_x: P_k_x, P_Class_k: P_Class_k}, on: [myClass], method: \"inner\")\n        |> drop(columns: [\"_field_P_Class_k\", \"_value_P_Class_k\", \"_field_P_k_x\"])\n        |> group(columns: [myClass, \"_value_P_k_x\"])\n        |> limit(n: 1)\n        |> map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
									Start: ast.Position{
										Column: 24,
										Line:   59,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   63,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
											Start: ast.Position{
												Column: 16,
												Line:   63,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 81,
													Line:   63,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
												Start: ast.Position{
													Column: 16,
													Line:   63,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   63,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 16,
														Line:   63,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 81,
														Line:   63,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "(r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
													Start: ast.Position{
														Column: 20,
														Line:   63,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 81,
															Line:   63,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "({r with P_x_k: r.sum / float(v: r._value_P_Class_k)})",
														Start: ast.Position{
															Column: 27,
															Line:   63,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 80,
																Line:   63,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "{r with P_x_k: r.sum / float(v: r._value_P_Class_k)}",
															Start: ast.Position{
																Column: 28,
																Line:   63,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   63,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "P_x_k: r.sum / float(v: r._value_P_Class_k)",
																Start: ast.Position{
																	Column: 36,
																	Line:   63,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   63,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "P_x_k",
																	Start: ast.Position{
																		Column: 36,
																		Line:   63,
																	},
																},
															},
															Name: "P_x_k",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   63,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r.sum / float(v: r._value_P_Class_k)",
																	Start: ast.Position{
																		Column: 43,
																		Line:   63,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   63,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r.sum",
																		Start: ast.Position{
																			Column: 43,
																			Line:   63,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 44,
																				Line:   63,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 43,
																				Line:   63,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   63,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "sum",
																			Start: ast.Position{
																				Column: 45,
																				Line:   63,
																			},
																		},
																	},
																	Name: "sum",
																},
																Rbrack: nil,
															},
															Operator: 2,
															Right: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 78,
																				Line:   63,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "v: r._value_P_Class_k",
																			Start: ast.Position{
																				Column: 57,
																				Line:   63,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 78,
																					Line:   63,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "v: r._value_P_Class_k",
																				Start: ast.Position{
																					Column: 57,
																					Line:   63,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 58,
																						Line:   63,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 57,
																						Line:   63,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 78,
																						Line:   63,
																					},
																					File:   "naiveBayesClassifier.flux",
																					Source: "r._value_P_Class_k",
																					Start: ast.Position{
																						Column: 60,
																						Line:   63,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 61,
																							Line:   63,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 60,
																							Line:   63,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 78,
																							Line:   63,
																						},
																						File:   "naiveBayesClassifier.flux",
																						Source: "_value_P_Class_k",
																						Start: ast.Position{
																							Column: 62,
																							Line:   63,
																						},
																					},
																				},
																				Name: "_value_P_Class_k",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   63,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "float(v: r._value_P_Class_k)",
																		Start: ast.Position{
																			Column: 51,
																			Line:   63,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   63,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 51,
																				Line:   63,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   63,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 29,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   63,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "r",
														Start: ast.Position{
															Column: 21,
															Line:   63,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   63,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   63,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   63,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "map(fn: (r) => ({r with P_x_k: r.sum / float(v: r._value_P_Class_k)}))",
										Start: ast.Position{
											Column: 12,
											Line:   63,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   63,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "map",
											Start: ast.Position{
												Column: 12,
												Line:   63,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   68,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "Probability_table = join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n        |> map(fn: (r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x}))",
								Start: ast.Position{
									Column: 5,
									Line:   67,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//added P(value_x) to table\n"}, ast.Comment{Text: "//calculated probabilities for training data \n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   67,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "Probability_table",
									Start: ast.Position{
										Column: 5,
										Line:   67,
									},
								},
							},
							Name: "Probability_table",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 129,
												Line:   67,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\"",
											Start: ast.Position{
												Column: 30,
												Line:   67,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 86,
													Line:   67,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}",
												Start: ast.Position{
													Column: 30,
													Line:   67,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   67,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 30,
														Line:   67,
													},
												},
											},
											Name: "tables",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   67,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "{P_k_x_class: P_k_x_class, P_value_x: P_value_x}",
													Start: ast.Position{
														Column: 38,
														Line:   67,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   67,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "P_k_x_class: P_k_x_class",
														Start: ast.Position{
															Column: 39,
															Line:   67,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   67,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "P_k_x_class",
															Start: ast.Position{
																Column: 39,
																Line:   67,
															},
														},
													},
													Name: "P_k_x_class",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   67,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "P_k_x_class",
															Start: ast.Position{
																Column: 52,
																Line:   67,
															},
														},
													},
													Name: "P_k_x_class",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   67,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "P_value_x: P_value_x",
														Start: ast.Position{
															Column: 65,
															Line:   67,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 74,
																Line:   67,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "P_value_x",
															Start: ast.Position{
																Column: 65,
																Line:   67,
															},
														},
													},
													Name: "P_value_x",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   67,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "P_value_x",
															Start: ast.Position{
																Column: 76,
																Line:   67,
															},
														},
													},
													Name: "P_value_x",
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 112,
													Line:   67,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "on: [\"_value\", \"_field\"]",
												Start: ast.Position{
													Column: 88,
													Line:   67,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 90,
														Line:   67,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "on",
													Start: ast.Position{
														Column: 88,
														Line:   67,
													},
												},
											},
											Name: "on",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 112,
														Line:   67,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "[\"_value\", \"_field\"]",
													Start: ast.Position{
														Column: 92,
														Line:   67,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 101,
															Line:   67,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "\"_value\"",
														Start: ast.Position{
															Column: 93,
															Line:   67,
														},
													},
												},
												Value: "_value",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 111,
															Line:   67,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "\"_field\"",
														Start: ast.Position{
															Column: 103,
															Line:   67,
														},
													},
												},
												Value: "_field",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 129,
													Line:   67,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "method: \"inner\"",
												Start: ast.Position{
													Column: 114,
													Line:   67,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 120,
														Line:   67,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "method",
													Start: ast.Position{
														Column: 114,
														Line:   67,
													},
												},
											},
											Name: "method",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 129,
														Line:   67,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "\"inner\"",
													Start: ast.Position{
														Column: 122,
														Line:   67,
													},
												},
											},
											Value: "inner",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   67,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")",
										Start: ast.Position{
											Column: 25,
											Line:   67,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   67,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "join",
											Start: ast.Position{
												Column: 25,
												Line:   67,
											},
										},
									},
									Name: "join",
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   68,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "join(tables: {P_k_x_class: P_k_x_class, P_value_x: P_value_x}, on: [\"_value\", \"_field\"], method: \"inner\")\n        |> map(fn: (r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x}))",
									Start: ast.Position{
										Column: 25,
										Line:   67,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   68,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "fn: (r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x})",
											Start: ast.Position{
												Column: 16,
												Line:   68,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   68,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "fn: (r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x})",
												Start: ast.Position{
													Column: 16,
													Line:   68,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   68,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 16,
														Line:   68,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   68,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "(r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x})",
													Start: ast.Position{
														Column: 20,
														Line:   68,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   68,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "({r with Probability: r.P_x_k * r.p_k / r.p_x})",
														Start: ast.Position{
															Column: 27,
															Line:   68,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   68,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "{r with Probability: r.P_x_k * r.p_k / r.p_x}",
															Start: ast.Position{
																Column: 28,
																Line:   68,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 72,
																	Line:   68,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "Probability: r.P_x_k * r.p_k / r.p_x",
																Start: ast.Position{
																	Column: 36,
																	Line:   68,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   68,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "Probability",
																	Start: ast.Position{
																		Column: 36,
																		Line:   68,
																	},
																},
															},
															Name: "Probability",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   68,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r.P_x_k * r.p_k / r.p_x",
																	Start: ast.Position{
																		Column: 49,
																		Line:   68,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   68,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r.P_x_k * r.p_k",
																		Start: ast.Position{
																			Column: 49,
																			Line:   68,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   68,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r.P_x_k",
																			Start: ast.Position{
																				Column: 49,
																				Line:   68,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 50,
																					Line:   68,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 49,
																					Line:   68,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 56,
																					Line:   68,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "P_x_k",
																				Start: ast.Position{
																					Column: 51,
																					Line:   68,
																				},
																			},
																		},
																		Name: "P_x_k",
																	},
																	Rbrack: nil,
																},
																Operator: 1,
																Right: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   68,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r.p_k",
																			Start: ast.Position{
																				Column: 59,
																				Line:   68,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   68,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 59,
																					Line:   68,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   68,
																				},
																				File:   "naiveBayesClassifier.flux",
																				Source: "p_k",
																				Start: ast.Position{
																					Column: 61,
																					Line:   68,
																				},
																			},
																		},
																		Name: "p_k",
																	},
																	Rbrack: nil,
																},
															},
															Operator: 2,
															Right: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   68,
																		},
																		File:   "naiveBayesClassifier.flux",
																		Source: "r.p_x",
																		Start: ast.Position{
																			Column: 67,
																			Line:   68,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   68,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 67,
																				Line:   68,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 72,
																				Line:   68,
																			},
																			File:   "naiveBayesClassifier.flux",
																			Source: "p_x",
																			Start: ast.Position{
																				Column: 69,
																				Line:   68,
																			},
																		},
																	},
																	Name: "p_x",
																},
																Rbrack: nil,
															},
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   68,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 29,
																	Line:   68,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   68,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "r",
														Start: ast.Position{
															Column: 21,
															Line:   68,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   68,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   68,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   68,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "map(fn: (r) => ({r with Probability: r.P_x_k * r.p_k / r.p_x}))",
										Start: ast.Position{
											Column: 12,
											Line:   68,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   68,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "map",
											Start: ast.Position{
												Column: 12,
												Line:   68,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   78,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "predictOverall = (tables=<-) => {\n        r = tables\n            |> keep(columns: [\"_value\", \"Animal_name\", \"_field\"])\n        output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n\n        return output\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   72,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "//|> yield(name: \"final\")\n"}, ast.Comment{Text: "//predictions for test data computed \n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   72,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "predictOverall",
									Start: ast.Position{
										Column: 5,
										Line:   72,
									},
								},
							},
							Name: "predictOverall",
						},
						Init: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   78,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "(tables=<-) => {\n        r = tables\n            |> keep(columns: [\"_value\", \"Animal_name\", \"_field\"])\n        output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n\n        return output\n    }",
									Start: ast.Position{
										Column: 22,
										Line:   72,
									},
								},
							},
							Body: &ast.Block{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   78,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "{\n        r = tables\n            |> keep(columns: [\"_value\", \"Animal_name\", \"_field\"])\n        output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")\n\n        return output\n    }",
										Start: ast.Position{
											Column: 37,
											Line:   72,
										},
									},
								},
								Body: []ast.Statement{&ast.VariableAssignment{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   74,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "r = tables\n            |> keep(columns: [\"_value\", \"Animal_name\", \"_field\"])",
											Start: ast.Position{
												Column: 9,
												Line:   73,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   73,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "r",
												Start: ast.Position{
													Column: 9,
													Line:   73,
												},
											},
										},
										Name: "r",
									},
									Init: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   73,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 13,
														Line:   73,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   74,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "tables\n            |> keep(columns: [\"_value\", \"Animal_name\", \"_field\"])",
												Start: ast.Position{
													Column: 13,
													Line:   73,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   74,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "columns: [\"_value\", \"Animal_name\", \"_field\"]",
														Start: ast.Position{
															Column: 21,
															Line:   74,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   74,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "columns: [\"_value\", \"Animal_name\", \"_field\"]",
															Start: ast.Position{
																Column: 21,
																Line:   74,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   74,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 21,
																	Line:   74,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   74,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "[\"_value\", \"Animal_name\", \"_field\"]",
																Start: ast.Position{
																	Column: 30,
																	Line:   74,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   74,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_value\"",
																	Start: ast.Position{
																		Column: 31,
																		Line:   74,
																	},
																},
															},
															Value: "_value",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   74,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"Animal_name\"",
																	Start: ast.Position{
																		Column: 41,
																		Line:   74,
																	},
																},
															},
															Value: "Animal_name",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   74,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "\"_field\"",
																	Start: ast.Position{
																		Column: 56,
																		Line:   74,
																	},
																},
															},
															Value: "_field",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   74,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "keep(columns: [\"_value\", \"Animal_name\", \"_field\"])",
													Start: ast.Position{
														Column: 16,
														Line:   74,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   74,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "keep",
														Start: ast.Position{
															Column: 16,
															Line:   74,
														},
													},
												},
												Name: "keep",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
								}, &ast.VariableAssignment{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   75,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "output = join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")",
											Start: ast.Position{
												Column: 9,
												Line:   75,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   75,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "output",
												Start: ast.Position{
													Column: 9,
													Line:   75,
												},
											},
										},
										Name: "output",
									},
									Init: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   75,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\"",
													Start: ast.Position{
														Column: 23,
														Line:   75,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   75,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "tables: {Probability_table: Probability_table, r: r}",
														Start: ast.Position{
															Column: 23,
															Line:   75,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   75,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "tables",
															Start: ast.Position{
																Column: 23,
																Line:   75,
															},
														},
													},
													Name: "tables",
												},
												Separator: nil,
												Value: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   75,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "{Probability_table: Probability_table, r: r}",
															Start: ast.Position{
																Column: 31,
																Line:   75,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   75,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "Probability_table: Probability_table",
																Start: ast.Position{
																	Column: 32,
																	Line:   75,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   75,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "Probability_table",
																	Start: ast.Position{
																		Column: 32,
																		Line:   75,
																	},
																},
															},
															Name: "Probability_table",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   75,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "Probability_table",
																	Start: ast.Position{
																		Column: 51,
																		Line:   75,
																	},
																},
															},
															Name: "Probability_table",
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   75,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "r: r",
																Start: ast.Position{
																	Column: 70,
																	Line:   75,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 71,
																		Line:   75,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 70,
																		Line:   75,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   75,
																	},
																	File:   "naiveBayesClassifier.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 73,
																		Line:   75,
																	},
																},
															},
															Name: "r",
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 91,
															Line:   75,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "on: [\"_value\"]",
														Start: ast.Position{
															Column: 77,
															Line:   75,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 79,
																Line:   75,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "on",
															Start: ast.Position{
																Column: 77,
																Line:   75,
															},
														},
													},
													Name: "on",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 91,
																Line:   75,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "[\"_value\"]",
															Start: ast.Position{
																Column: 81,
																Line:   75,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 90,
																	Line:   75,
																},
																File:   "naiveBayesClassifier.flux",
																Source: "\"_value\"",
																Start: ast.Position{
																	Column: 82,
																	Line:   75,
																},
															},
														},
														Value: "_value",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 108,
															Line:   75,
														},
														File:   "naiveBayesClassifier.flux",
														Source: "method: \"inner\"",
														Start: ast.Position{
															Column: 93,
															Line:   75,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 99,
																Line:   75,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "method",
															Start: ast.Position{
																Column: 93,
																Line:   75,
															},
														},
													},
													Name: "method",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 108,
																Line:   75,
															},
															File:   "naiveBayesClassifier.flux",
															Source: "\"inner\"",
															Start: ast.Position{
																Column: 101,
																Line:   75,
															},
														},
													},
													Value: "inner",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   75,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "join(tables: {Probability_table: Probability_table, r: r}, on: [\"_value\"], method: \"inner\")",
												Start: ast.Position{
													Column: 18,
													Line:   75,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   75,
													},
													File:   "naiveBayesClassifier.flux",
													Source: "join",
													Start: ast.Position{
														Column: 18,
														Line:   75,
													},
												},
											},
											Name: "join",
										},
										Lparen: nil,
										Rparen: nil,
									},
								}, &ast.ReturnStatement{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   77,
												},
												File:   "naiveBayesClassifier.flux",
												Source: "output",
												Start: ast.Position{
													Column: 16,
													Line:   77,
												},
											},
										},
										Name: "output",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   77,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "return output",
											Start: ast.Position{
												Column: 9,
												Line:   77,
											},
										},
									},
								}},
								Lbrace: nil,
								Rbrace: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   72,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "tables=<-",
										Start: ast.Position{
											Column: 23,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   72,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 23,
												Line:   72,
											},
										},
									},
									Name: "tables",
								},
								Separator: nil,
								Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   72,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "<-",
										Start: ast.Position{
											Column: 30,
											Line:   72,
										},
									},
								}},
							}},
							Rparan: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   80,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "test_data",
										Start: ast.Position{
											Column: 12,
											Line:   80,
										},
									},
								},
								Name: "test_data",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   80,
									},
									File:   "naiveBayesClassifier.flux",
									Source: "test_data |> predictOverall()",
									Start: ast.Position{
										Column: 12,
										Line:   80,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   80,
										},
										File:   "naiveBayesClassifier.flux",
										Source: "predictOverall()",
										Start: ast.Position{
											Column: 25,
											Line:   80,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   80,
											},
											File:   "naiveBayesClassifier.flux",
											Source: "predictOverall",
											Start: ast.Position{
												Column: 25,
												Line:   80,
											},
										},
									},
									Name: "predictOverall",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   80,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "return test_data |> predictOverall()",
								Start: ast.Position{
									Column: 5,
									Line:   80,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   9,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   9,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   9,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   9,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "myClass",
							Start: ast.Position{
								Column: 26,
								Line:   9,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   9,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "myClass",
								Start: ast.Position{
									Column: 26,
									Line:   9,
								},
							},
						},
						Name: "myClass",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "myField",
							Start: ast.Position{
								Column: 35,
								Line:   9,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   9,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "myField",
								Start: ast.Position{
									Column: 35,
									Line:   9,
								},
							},
						},
						Name: "myField",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   9,
							},
							File:   "naiveBayesClassifier.flux",
							Source: "myMeasurement",
							Start: ast.Position{
								Column: 44,
								Line:   9,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   9,
								},
								File:   "naiveBayesClassifier.flux",
								Source: "myMeasurement",
								Start: ast.Position{
									Column: 44,
									Line:   9,
								},
							},
						},
						Name: "myMeasurement",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   7,
					},
					File:   "naiveBayesClassifier.flux",
					Source: "import \"system\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   7,
						},
						File:   "naiveBayesClassifier.flux",
						Source: "\"system\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "system",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "naiveBayesClassifier.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "//Final working code as of August 11, 2020\n"}, ast.Comment{Text: "//Currently supports single field classification and binary data sets \n"}, ast.Comment{Text: "//Please ensure Ruby is installed\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   4,
					},
					File:   "naiveBayesClassifier.flux",
					Source: "package naiveBayesClassifier",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   4,
						},
						File:   "naiveBayesClassifier.flux",
						Source: "naiveBayesClassifier",
						Start: ast.Position{
							Column: 9,
							Line:   4,
						},
					},
				},
				Name: "naiveBayesClassifier",
			},
		},
	}},
	Package: "naiveBayesClassifier",
	Path:    "contrib/RohanSreerama5/naiveBayesClassifier",
}
