// DO NOT EDIT: This file is autogenerated via the builtin command.

package statsmodels

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   51,
				},
				File:   "linearreg.flux",
				Source: "package statsmodels\n\n\nimport \"math\"\nimport \"generate\"\n\n// performs linear regression, calculates y_hat, and residuals squared (rse) \nlinearRegression = (tables=<-) => {\n    renameAndSum = tables\n        |> rename(columns: {_value: \"y\"})\n        |> map(fn: (r) => ({r with x: 1.0}))\n        |> cumulativeSum(columns: [\"x\"])\n    t = renameAndSum\n        |> reduce(\n            fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            },\n        )\n        |> tableFind(fn: (key) => true)\n        |> getRecord(idx: 0)\n    xbar = t.sx / t.N\n    ybar = t.sy / t.N\n    slope = (t.sxy - xbar * ybar * t.N) / (t.sxx - t.N * xbar * xbar)\n    intercept = ybar - slope * xbar\n    y_hat = (r) => ({r with\n        y_hat: slope * r.x + intercept,\n        slope: slope,\n        sx: t.sx,\n        sxy: t.sxy,\n        sxx: t.sxx,\n        N: t.N,\n        sy: t.sy,\n    })\n    rse = (r) => ({r with errors: (r.y - r.y_hat) ^ 2.0})\n    output = renameAndSum\n        |> map(fn: y_hat)\n        |> map(fn: rse)\n\n    return output\n}",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   51,
					},
					File:   "linearreg.flux",
					Source: "linearRegression = (tables=<-) => {\n    renameAndSum = tables\n        |> rename(columns: {_value: \"y\"})\n        |> map(fn: (r) => ({r with x: 1.0}))\n        |> cumulativeSum(columns: [\"x\"])\n    t = renameAndSum\n        |> reduce(\n            fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            },\n        )\n        |> tableFind(fn: (key) => true)\n        |> getRecord(idx: 0)\n    xbar = t.sx / t.N\n    ybar = t.sy / t.N\n    slope = (t.sxy - xbar * ybar * t.N) / (t.sxx - t.N * xbar * xbar)\n    intercept = ybar - slope * xbar\n    y_hat = (r) => ({r with\n        y_hat: slope * r.x + intercept,\n        slope: slope,\n        sx: t.sx,\n        sxy: t.sxy,\n        sxx: t.sxx,\n        N: t.N,\n        sy: t.sy,\n    })\n    rse = (r) => ({r with errors: (r.y - r.y_hat) ^ 2.0})\n    output = renameAndSum\n        |> map(fn: y_hat)\n        |> map(fn: rse)\n\n    return output\n}",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// performs linear regression, calculates y_hat, and residuals squared (rse) \n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   8,
						},
						File:   "linearreg.flux",
						Source: "linearRegression",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "linearRegression",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   51,
						},
						File:   "linearreg.flux",
						Source: "(tables=<-) => {\n    renameAndSum = tables\n        |> rename(columns: {_value: \"y\"})\n        |> map(fn: (r) => ({r with x: 1.0}))\n        |> cumulativeSum(columns: [\"x\"])\n    t = renameAndSum\n        |> reduce(\n            fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            },\n        )\n        |> tableFind(fn: (key) => true)\n        |> getRecord(idx: 0)\n    xbar = t.sx / t.N\n    ybar = t.sy / t.N\n    slope = (t.sxy - xbar * ybar * t.N) / (t.sxx - t.N * xbar * xbar)\n    intercept = ybar - slope * xbar\n    y_hat = (r) => ({r with\n        y_hat: slope * r.x + intercept,\n        slope: slope,\n        sx: t.sx,\n        sxy: t.sxy,\n        sxx: t.sxx,\n        N: t.N,\n        sy: t.sy,\n    })\n    rse = (r) => ({r with errors: (r.y - r.y_hat) ^ 2.0})\n    output = renameAndSum\n        |> map(fn: y_hat)\n        |> map(fn: rse)\n\n    return output\n}",
						Start: ast.Position{
							Column: 20,
							Line:   8,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   51,
							},
							File:   "linearreg.flux",
							Source: "{\n    renameAndSum = tables\n        |> rename(columns: {_value: \"y\"})\n        |> map(fn: (r) => ({r with x: 1.0}))\n        |> cumulativeSum(columns: [\"x\"])\n    t = renameAndSum\n        |> reduce(\n            fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            },\n        )\n        |> tableFind(fn: (key) => true)\n        |> getRecord(idx: 0)\n    xbar = t.sx / t.N\n    ybar = t.sy / t.N\n    slope = (t.sxy - xbar * ybar * t.N) / (t.sxx - t.N * xbar * xbar)\n    intercept = ybar - slope * xbar\n    y_hat = (r) => ({r with\n        y_hat: slope * r.x + intercept,\n        slope: slope,\n        sx: t.sx,\n        sxy: t.sxy,\n        sxx: t.sxx,\n        N: t.N,\n        sy: t.sy,\n    })\n    rse = (r) => ({r with errors: (r.y - r.y_hat) ^ 2.0})\n    output = renameAndSum\n        |> map(fn: y_hat)\n        |> map(fn: rse)\n\n    return output\n}",
							Start: ast.Position{
								Column: 35,
								Line:   8,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   12,
								},
								File:   "linearreg.flux",
								Source: "renameAndSum = tables\n        |> rename(columns: {_value: \"y\"})\n        |> map(fn: (r) => ({r with x: 1.0}))\n        |> cumulativeSum(columns: [\"x\"])",
								Start: ast.Position{
									Column: 5,
									Line:   9,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   9,
									},
									File:   "linearreg.flux",
									Source: "renameAndSum",
									Start: ast.Position{
										Column: 5,
										Line:   9,
									},
								},
							},
							Name: "renameAndSum",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   9,
												},
												File:   "linearreg.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 20,
													Line:   9,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   10,
											},
											File:   "linearreg.flux",
											Source: "tables\n        |> rename(columns: {_value: \"y\"})",
											Start: ast.Position{
												Column: 20,
												Line:   9,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   10,
													},
													File:   "linearreg.flux",
													Source: "columns: {_value: \"y\"}",
													Start: ast.Position{
														Column: 19,
														Line:   10,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   10,
														},
														File:   "linearreg.flux",
														Source: "columns: {_value: \"y\"}",
														Start: ast.Position{
															Column: 19,
															Line:   10,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   10,
															},
															File:   "linearreg.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 19,
																Line:   10,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   10,
															},
															File:   "linearreg.flux",
															Source: "{_value: \"y\"}",
															Start: ast.Position{
																Column: 28,
																Line:   10,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   10,
																},
																File:   "linearreg.flux",
																Source: "_value: \"y\"",
																Start: ast.Position{
																	Column: 29,
																	Line:   10,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   10,
																	},
																	File:   "linearreg.flux",
																	Source: "_value",
																	Start: ast.Position{
																		Column: 29,
																		Line:   10,
																	},
																},
															},
															Name: "_value",
														},
														Separator: nil,
														Value: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   10,
																	},
																	File:   "linearreg.flux",
																	Source: "\"y\"",
																	Start: ast.Position{
																		Column: 37,
																		Line:   10,
																	},
																},
															},
															Value: "y",
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   10,
												},
												File:   "linearreg.flux",
												Source: "rename(columns: {_value: \"y\"})",
												Start: ast.Position{
													Column: 12,
													Line:   10,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   10,
													},
													File:   "linearreg.flux",
													Source: "rename",
													Start: ast.Position{
														Column: 12,
														Line:   10,
													},
												},
											},
											Name: "rename",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   11,
										},
										File:   "linearreg.flux",
										Source: "tables\n        |> rename(columns: {_value: \"y\"})\n        |> map(fn: (r) => ({r with x: 1.0}))",
										Start: ast.Position{
											Column: 20,
											Line:   9,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   11,
												},
												File:   "linearreg.flux",
												Source: "fn: (r) => ({r with x: 1.0})",
												Start: ast.Position{
													Column: 16,
													Line:   11,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   11,
													},
													File:   "linearreg.flux",
													Source: "fn: (r) => ({r with x: 1.0})",
													Start: ast.Position{
														Column: 16,
														Line:   11,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   11,
														},
														File:   "linearreg.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   11,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   11,
														},
														File:   "linearreg.flux",
														Source: "(r) => ({r with x: 1.0})",
														Start: ast.Position{
															Column: 20,
															Line:   11,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   11,
															},
															File:   "linearreg.flux",
															Source: "({r with x: 1.0})",
															Start: ast.Position{
																Column: 27,
																Line:   11,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 43,
																	Line:   11,
																},
																File:   "linearreg.flux",
																Source: "{r with x: 1.0}",
																Start: ast.Position{
																	Column: 28,
																	Line:   11,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   11,
																	},
																	File:   "linearreg.flux",
																	Source: "x: 1.0",
																	Start: ast.Position{
																		Column: 36,
																		Line:   11,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   11,
																		},
																		File:   "linearreg.flux",
																		Source: "x",
																		Start: ast.Position{
																			Column: 36,
																			Line:   11,
																		},
																	},
																},
																Name: "x",
															},
															Separator: nil,
															Value: &ast.FloatLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   11,
																		},
																		File:   "linearreg.flux",
																		Source: "1.0",
																		Start: ast.Position{
																			Column: 39,
																			Line:   11,
																		},
																	},
																},
																Value: 1.0,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   11,
																	},
																	File:   "linearreg.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   11,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   11,
															},
															File:   "linearreg.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   11,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   11,
																},
																File:   "linearreg.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   11,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   11,
											},
											File:   "linearreg.flux",
											Source: "map(fn: (r) => ({r with x: 1.0}))",
											Start: ast.Position{
												Column: 12,
												Line:   11,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   11,
												},
												File:   "linearreg.flux",
												Source: "map",
												Start: ast.Position{
													Column: 12,
													Line:   11,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   12,
									},
									File:   "linearreg.flux",
									Source: "tables\n        |> rename(columns: {_value: \"y\"})\n        |> map(fn: (r) => ({r with x: 1.0}))\n        |> cumulativeSum(columns: [\"x\"])",
									Start: ast.Position{
										Column: 20,
										Line:   9,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   12,
											},
											File:   "linearreg.flux",
											Source: "columns: [\"x\"]",
											Start: ast.Position{
												Column: 26,
												Line:   12,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   12,
												},
												File:   "linearreg.flux",
												Source: "columns: [\"x\"]",
												Start: ast.Position{
													Column: 26,
													Line:   12,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   12,
													},
													File:   "linearreg.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 26,
														Line:   12,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   12,
													},
													File:   "linearreg.flux",
													Source: "[\"x\"]",
													Start: ast.Position{
														Column: 35,
														Line:   12,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   12,
														},
														File:   "linearreg.flux",
														Source: "\"x\"",
														Start: ast.Position{
															Column: 36,
															Line:   12,
														},
													},
												},
												Value: "x",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   12,
										},
										File:   "linearreg.flux",
										Source: "cumulativeSum(columns: [\"x\"])",
										Start: ast.Position{
											Column: 12,
											Line:   12,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   12,
											},
											File:   "linearreg.flux",
											Source: "cumulativeSum",
											Start: ast.Position{
												Column: 12,
												Line:   12,
											},
										},
									},
									Name: "cumulativeSum",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   31,
								},
								File:   "linearreg.flux",
								Source: "t = renameAndSum\n        |> reduce(\n            fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            },\n        )\n        |> tableFind(fn: (key) => true)\n        |> getRecord(idx: 0)",
								Start: ast.Position{
									Column: 5,
									Line:   13,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   13,
									},
									File:   "linearreg.flux",
									Source: "t",
									Start: ast.Position{
										Column: 5,
										Line:   13,
									},
								},
							},
							Name: "t",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   13,
												},
												File:   "linearreg.flux",
												Source: "renameAndSum",
												Start: ast.Position{
													Column: 9,
													Line:   13,
												},
											},
										},
										Name: "renameAndSum",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   29,
											},
											File:   "linearreg.flux",
											Source: "renameAndSum\n        |> reduce(\n            fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            },\n        )",
											Start: ast.Position{
												Column: 9,
												Line:   13,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   28,
													},
													File:   "linearreg.flux",
													Source: "fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            }",
													Start: ast.Position{
														Column: 13,
														Line:   15,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   21,
														},
														File:   "linearreg.flux",
														Source: "fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            })",
														Start: ast.Position{
															Column: 13,
															Line:   15,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   15,
															},
															File:   "linearreg.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 13,
																Line:   15,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   21,
															},
															File:   "linearreg.flux",
															Source: "(r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            })",
															Start: ast.Position{
																Column: 17,
																Line:   15,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   21,
																},
																File:   "linearreg.flux",
																Source: "({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            })",
																Start: ast.Position{
																	Column: 37,
																	Line:   15,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 14,
																		Line:   21,
																	},
																	File:   "linearreg.flux",
																	Source: "{\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }",
																	Start: ast.Position{
																		Column: 38,
																		Line:   15,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   16,
																		},
																		File:   "linearreg.flux",
																		Source: "sx: r.x + accumulator.sx",
																		Start: ast.Position{
																			Column: 17,
																			Line:   16,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 19,
																				Line:   16,
																			},
																			File:   "linearreg.flux",
																			Source: "sx",
																			Start: ast.Position{
																				Column: 17,
																				Line:   16,
																			},
																		},
																	},
																	Name: "sx",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   16,
																			},
																			File:   "linearreg.flux",
																			Source: "r.x + accumulator.sx",
																			Start: ast.Position{
																				Column: 21,
																				Line:   16,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   16,
																				},
																				File:   "linearreg.flux",
																				Source: "r.x",
																				Start: ast.Position{
																					Column: 21,
																					Line:   16,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   16,
																					},
																					File:   "linearreg.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 21,
																						Line:   16,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   16,
																					},
																					File:   "linearreg.flux",
																					Source: "x",
																					Start: ast.Position{
																						Column: 23,
																						Line:   16,
																					},
																				},
																			},
																			Name: "x",
																		},
																		Rbrack: nil,
																	},
																	Operator: 5,
																	Right: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 41,
																					Line:   16,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.sx",
																				Start: ast.Position{
																					Column: 27,
																					Line:   16,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 38,
																						Line:   16,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 27,
																						Line:   16,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 41,
																						Line:   16,
																					},
																					File:   "linearreg.flux",
																					Source: "sx",
																					Start: ast.Position{
																						Column: 39,
																						Line:   16,
																					},
																				},
																			},
																			Name: "sx",
																		},
																		Rbrack: nil,
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   17,
																		},
																		File:   "linearreg.flux",
																		Source: "sy: r.y + accumulator.sy",
																		Start: ast.Position{
																			Column: 17,
																			Line:   17,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 19,
																				Line:   17,
																			},
																			File:   "linearreg.flux",
																			Source: "sy",
																			Start: ast.Position{
																				Column: 17,
																				Line:   17,
																			},
																		},
																	},
																	Name: "sy",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   17,
																			},
																			File:   "linearreg.flux",
																			Source: "r.y + accumulator.sy",
																			Start: ast.Position{
																				Column: 21,
																				Line:   17,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   17,
																				},
																				File:   "linearreg.flux",
																				Source: "r.y",
																				Start: ast.Position{
																					Column: 21,
																					Line:   17,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   17,
																					},
																					File:   "linearreg.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 21,
																						Line:   17,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   17,
																					},
																					File:   "linearreg.flux",
																					Source: "y",
																					Start: ast.Position{
																						Column: 23,
																						Line:   17,
																					},
																				},
																			},
																			Name: "y",
																		},
																		Rbrack: nil,
																	},
																	Operator: 5,
																	Right: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 41,
																					Line:   17,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.sy",
																				Start: ast.Position{
																					Column: 27,
																					Line:   17,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 38,
																						Line:   17,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 27,
																						Line:   17,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 41,
																						Line:   17,
																					},
																					File:   "linearreg.flux",
																					Source: "sy",
																					Start: ast.Position{
																						Column: 39,
																						Line:   17,
																					},
																				},
																			},
																			Name: "sy",
																		},
																		Rbrack: nil,
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   18,
																		},
																		File:   "linearreg.flux",
																		Source: "N: accumulator.N + 1.0",
																		Start: ast.Position{
																			Column: 17,
																			Line:   18,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 18,
																				Line:   18,
																			},
																			File:   "linearreg.flux",
																			Source: "N",
																			Start: ast.Position{
																				Column: 17,
																				Line:   18,
																			},
																		},
																	},
																	Name: "N",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 39,
																				Line:   18,
																			},
																			File:   "linearreg.flux",
																			Source: "accumulator.N + 1.0",
																			Start: ast.Position{
																				Column: 20,
																				Line:   18,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 33,
																					Line:   18,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.N",
																				Start: ast.Position{
																					Column: 20,
																					Line:   18,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 31,
																						Line:   18,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 20,
																						Line:   18,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 33,
																						Line:   18,
																					},
																					File:   "linearreg.flux",
																					Source: "N",
																					Start: ast.Position{
																						Column: 32,
																						Line:   18,
																					},
																				},
																			},
																			Name: "N",
																		},
																		Rbrack: nil,
																	},
																	Operator: 5,
																	Right: &ast.FloatLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 39,
																					Line:   18,
																				},
																				File:   "linearreg.flux",
																				Source: "1.0",
																				Start: ast.Position{
																					Column: 36,
																					Line:   18,
																				},
																			},
																		},
																		Value: 1.0,
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   19,
																		},
																		File:   "linearreg.flux",
																		Source: "sxy: r.x * r.y + accumulator.sxy",
																		Start: ast.Position{
																			Column: 17,
																			Line:   19,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 20,
																				Line:   19,
																			},
																			File:   "linearreg.flux",
																			Source: "sxy",
																			Start: ast.Position{
																				Column: 17,
																				Line:   19,
																			},
																		},
																	},
																	Name: "sxy",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   19,
																			},
																			File:   "linearreg.flux",
																			Source: "r.x * r.y + accumulator.sxy",
																			Start: ast.Position{
																				Column: 22,
																				Line:   19,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 31,
																					Line:   19,
																				},
																				File:   "linearreg.flux",
																				Source: "r.x * r.y",
																				Start: ast.Position{
																					Column: 22,
																					Line:   19,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 25,
																						Line:   19,
																					},
																					File:   "linearreg.flux",
																					Source: "r.x",
																					Start: ast.Position{
																						Column: 22,
																						Line:   19,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 23,
																							Line:   19,
																						},
																						File:   "linearreg.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 22,
																							Line:   19,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   19,
																						},
																						File:   "linearreg.flux",
																						Source: "x",
																						Start: ast.Position{
																							Column: 24,
																							Line:   19,
																						},
																					},
																				},
																				Name: "x",
																			},
																			Rbrack: nil,
																		},
																		Operator: 1,
																		Right: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 31,
																						Line:   19,
																					},
																					File:   "linearreg.flux",
																					Source: "r.y",
																					Start: ast.Position{
																						Column: 28,
																						Line:   19,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 29,
																							Line:   19,
																						},
																						File:   "linearreg.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 28,
																							Line:   19,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 31,
																							Line:   19,
																						},
																						File:   "linearreg.flux",
																						Source: "y",
																						Start: ast.Position{
																							Column: 30,
																							Line:   19,
																						},
																					},
																				},
																				Name: "y",
																			},
																			Rbrack: nil,
																		},
																	},
																	Operator: 5,
																	Right: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   19,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.sxy",
																				Start: ast.Position{
																					Column: 34,
																					Line:   19,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 45,
																						Line:   19,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 34,
																						Line:   19,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 49,
																						Line:   19,
																					},
																					File:   "linearreg.flux",
																					Source: "sxy",
																					Start: ast.Position{
																						Column: 46,
																						Line:   19,
																					},
																				},
																			},
																			Name: "sxy",
																		},
																		Rbrack: nil,
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   20,
																		},
																		File:   "linearreg.flux",
																		Source: "sxx: r.x * r.x + accumulator.sxx",
																		Start: ast.Position{
																			Column: 17,
																			Line:   20,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 20,
																				Line:   20,
																			},
																			File:   "linearreg.flux",
																			Source: "sxx",
																			Start: ast.Position{
																				Column: 17,
																				Line:   20,
																			},
																		},
																	},
																	Name: "sxx",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   20,
																			},
																			File:   "linearreg.flux",
																			Source: "r.x * r.x + accumulator.sxx",
																			Start: ast.Position{
																				Column: 22,
																				Line:   20,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 31,
																					Line:   20,
																				},
																				File:   "linearreg.flux",
																				Source: "r.x * r.x",
																				Start: ast.Position{
																					Column: 22,
																					Line:   20,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 25,
																						Line:   20,
																					},
																					File:   "linearreg.flux",
																					Source: "r.x",
																					Start: ast.Position{
																						Column: 22,
																						Line:   20,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 23,
																							Line:   20,
																						},
																						File:   "linearreg.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 22,
																							Line:   20,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   20,
																						},
																						File:   "linearreg.flux",
																						Source: "x",
																						Start: ast.Position{
																							Column: 24,
																							Line:   20,
																						},
																					},
																				},
																				Name: "x",
																			},
																			Rbrack: nil,
																		},
																		Operator: 1,
																		Right: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 31,
																						Line:   20,
																					},
																					File:   "linearreg.flux",
																					Source: "r.x",
																					Start: ast.Position{
																						Column: 28,
																						Line:   20,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 29,
																							Line:   20,
																						},
																						File:   "linearreg.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 28,
																							Line:   20,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 31,
																							Line:   20,
																						},
																						File:   "linearreg.flux",
																						Source: "x",
																						Start: ast.Position{
																							Column: 30,
																							Line:   20,
																						},
																					},
																				},
																				Name: "x",
																			},
																			Rbrack: nil,
																		},
																	},
																	Operator: 5,
																	Right: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   20,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.sxx",
																				Start: ast.Position{
																					Column: 34,
																					Line:   20,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 45,
																						Line:   20,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 34,
																						Line:   20,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 49,
																						Line:   20,
																					},
																					File:   "linearreg.flux",
																					Source: "sxx",
																					Start: ast.Position{
																						Column: 46,
																						Line:   20,
																					},
																				},
																			},
																			Name: "sxx",
																		},
																		Rbrack: nil,
																	},
																},
															}},
															Rbrace: nil,
															With:   nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   15,
																},
																File:   "linearreg.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 18,
																	Line:   15,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   15,
																	},
																	File:   "linearreg.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 18,
																		Line:   15,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   15,
																},
																File:   "linearreg.flux",
																Source: "accumulator",
																Start: ast.Position{
																	Column: 21,
																	Line:   15,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 32,
																		Line:   15,
																	},
																	File:   "linearreg.flux",
																	Source: "accumulator",
																	Start: ast.Position{
																		Column: 21,
																		Line:   15,
																	},
																},
															},
															Name: "accumulator",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   28,
														},
														File:   "linearreg.flux",
														Source: "identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            }",
														Start: ast.Position{
															Column: 13,
															Line:   22,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   22,
															},
															File:   "linearreg.flux",
															Source: "identity",
															Start: ast.Position{
																Column: 13,
																Line:   22,
															},
														},
													},
													Name: "identity",
												},
												Separator: nil,
												Value: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   28,
															},
															File:   "linearreg.flux",
															Source: "{\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            }",
															Start: ast.Position{
																Column: 23,
																Line:   22,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   23,
																},
																File:   "linearreg.flux",
																Source: "sxy: 0.0",
																Start: ast.Position{
																	Column: 17,
																	Line:   23,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 20,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "sxy",
																	Start: ast.Position{
																		Column: 17,
																		Line:   23,
																	},
																},
															},
															Name: "sxy",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 22,
																		Line:   23,
																	},
																},
															},
															Value: 0.0,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   24,
																},
																File:   "linearreg.flux",
																Source: "sx: 0.0",
																Start: ast.Position{
																	Column: 17,
																	Line:   24,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   24,
																	},
																	File:   "linearreg.flux",
																	Source: "sx",
																	Start: ast.Position{
																		Column: 17,
																		Line:   24,
																	},
																},
															},
															Name: "sx",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   24,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 21,
																		Line:   24,
																	},
																},
															},
															Value: 0.0,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   25,
																},
																File:   "linearreg.flux",
																Source: "sy: 0.0",
																Start: ast.Position{
																	Column: 17,
																	Line:   25,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   25,
																	},
																	File:   "linearreg.flux",
																	Source: "sy",
																	Start: ast.Position{
																		Column: 17,
																		Line:   25,
																	},
																},
															},
															Name: "sy",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   25,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 21,
																		Line:   25,
																	},
																},
															},
															Value: 0.0,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   26,
																},
																File:   "linearreg.flux",
																Source: "sxx: 0.0",
																Start: ast.Position{
																	Column: 17,
																	Line:   26,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 20,
																		Line:   26,
																	},
																	File:   "linearreg.flux",
																	Source: "sxx",
																	Start: ast.Position{
																		Column: 17,
																		Line:   26,
																	},
																},
															},
															Name: "sxx",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   26,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 22,
																		Line:   26,
																	},
																},
															},
															Value: 0.0,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   27,
																},
																File:   "linearreg.flux",
																Source: "N: 0.0",
																Start: ast.Position{
																	Column: 17,
																	Line:   27,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   27,
																	},
																	File:   "linearreg.flux",
																	Source: "N",
																	Start: ast.Position{
																		Column: 17,
																		Line:   27,
																	},
																},
															},
															Name: "N",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 23,
																		Line:   27,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 20,
																		Line:   27,
																	},
																},
															},
															Value: 0.0,
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   29,
												},
												File:   "linearreg.flux",
												Source: "reduce(\n            fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            },\n        )",
												Start: ast.Position{
													Column: 12,
													Line:   14,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   14,
													},
													File:   "linearreg.flux",
													Source: "reduce",
													Start: ast.Position{
														Column: 12,
														Line:   14,
													},
												},
											},
											Name: "reduce",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   30,
										},
										File:   "linearreg.flux",
										Source: "renameAndSum\n        |> reduce(\n            fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            },\n        )\n        |> tableFind(fn: (key) => true)",
										Start: ast.Position{
											Column: 9,
											Line:   13,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   30,
												},
												File:   "linearreg.flux",
												Source: "fn: (key) => true",
												Start: ast.Position{
													Column: 22,
													Line:   30,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   30,
													},
													File:   "linearreg.flux",
													Source: "fn: (key) => true",
													Start: ast.Position{
														Column: 22,
														Line:   30,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   30,
														},
														File:   "linearreg.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 22,
															Line:   30,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   30,
														},
														File:   "linearreg.flux",
														Source: "(key) => true",
														Start: ast.Position{
															Column: 26,
															Line:   30,
														},
													},
												},
												Body: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   30,
															},
															File:   "linearreg.flux",
															Source: "true",
															Start: ast.Position{
																Column: 35,
																Line:   30,
															},
														},
													},
													Name: "true",
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   30,
															},
															File:   "linearreg.flux",
															Source: "key",
															Start: ast.Position{
																Column: 27,
																Line:   30,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   30,
																},
																File:   "linearreg.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 27,
																	Line:   30,
																},
															},
														},
														Name: "key",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   30,
											},
											File:   "linearreg.flux",
											Source: "tableFind(fn: (key) => true)",
											Start: ast.Position{
												Column: 12,
												Line:   30,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   30,
												},
												File:   "linearreg.flux",
												Source: "tableFind",
												Start: ast.Position{
													Column: 12,
													Line:   30,
												},
											},
										},
										Name: "tableFind",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   31,
									},
									File:   "linearreg.flux",
									Source: "renameAndSum\n        |> reduce(\n            fn: (r, accumulator) => ({\n                sx: r.x + accumulator.sx,\n                sy: r.y + accumulator.sy,\n                N: accumulator.N + 1.0,\n                sxy: r.x * r.y + accumulator.sxy,\n                sxx: r.x * r.x + accumulator.sxx,\n            }),\n            identity: {\n                sxy: 0.0,\n                sx: 0.0,\n                sy: 0.0,\n                sxx: 0.0,\n                N: 0.0,\n            },\n        )\n        |> tableFind(fn: (key) => true)\n        |> getRecord(idx: 0)",
									Start: ast.Position{
										Column: 9,
										Line:   13,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   31,
											},
											File:   "linearreg.flux",
											Source: "idx: 0",
											Start: ast.Position{
												Column: 22,
												Line:   31,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   31,
												},
												File:   "linearreg.flux",
												Source: "idx: 0",
												Start: ast.Position{
													Column: 22,
													Line:   31,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "idx",
													Start: ast.Position{
														Column: 22,
														Line:   31,
													},
												},
											},
											Name: "idx",
										},
										Separator: nil,
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "0",
													Start: ast.Position{
														Column: 27,
														Line:   31,
													},
												},
											},
											Value: int64(0),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   31,
										},
										File:   "linearreg.flux",
										Source: "getRecord(idx: 0)",
										Start: ast.Position{
											Column: 12,
											Line:   31,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   31,
											},
											File:   "linearreg.flux",
											Source: "getRecord",
											Start: ast.Position{
												Column: 12,
												Line:   31,
											},
										},
									},
									Name: "getRecord",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   32,
								},
								File:   "linearreg.flux",
								Source: "xbar = t.sx / t.N",
								Start: ast.Position{
									Column: 5,
									Line:   32,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   32,
									},
									File:   "linearreg.flux",
									Source: "xbar",
									Start: ast.Position{
										Column: 5,
										Line:   32,
									},
								},
							},
							Name: "xbar",
						},
						Init: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   32,
									},
									File:   "linearreg.flux",
									Source: "t.sx / t.N",
									Start: ast.Position{
										Column: 12,
										Line:   32,
									},
								},
							},
							Left: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   32,
										},
										File:   "linearreg.flux",
										Source: "t.sx",
										Start: ast.Position{
											Column: 12,
											Line:   32,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   32,
											},
											File:   "linearreg.flux",
											Source: "t",
											Start: ast.Position{
												Column: 12,
												Line:   32,
											},
										},
									},
									Name: "t",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   32,
											},
											File:   "linearreg.flux",
											Source: "sx",
											Start: ast.Position{
												Column: 14,
												Line:   32,
											},
										},
									},
									Name: "sx",
								},
								Rbrack: nil,
							},
							Operator: 2,
							Right: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   32,
										},
										File:   "linearreg.flux",
										Source: "t.N",
										Start: ast.Position{
											Column: 19,
											Line:   32,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   32,
											},
											File:   "linearreg.flux",
											Source: "t",
											Start: ast.Position{
												Column: 19,
												Line:   32,
											},
										},
									},
									Name: "t",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   32,
											},
											File:   "linearreg.flux",
											Source: "N",
											Start: ast.Position{
												Column: 21,
												Line:   32,
											},
										},
									},
									Name: "N",
								},
								Rbrack: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   33,
								},
								File:   "linearreg.flux",
								Source: "ybar = t.sy / t.N",
								Start: ast.Position{
									Column: 5,
									Line:   33,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   33,
									},
									File:   "linearreg.flux",
									Source: "ybar",
									Start: ast.Position{
										Column: 5,
										Line:   33,
									},
								},
							},
							Name: "ybar",
						},
						Init: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   33,
									},
									File:   "linearreg.flux",
									Source: "t.sy / t.N",
									Start: ast.Position{
										Column: 12,
										Line:   33,
									},
								},
							},
							Left: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   33,
										},
										File:   "linearreg.flux",
										Source: "t.sy",
										Start: ast.Position{
											Column: 12,
											Line:   33,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   33,
											},
											File:   "linearreg.flux",
											Source: "t",
											Start: ast.Position{
												Column: 12,
												Line:   33,
											},
										},
									},
									Name: "t",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   33,
											},
											File:   "linearreg.flux",
											Source: "sy",
											Start: ast.Position{
												Column: 14,
												Line:   33,
											},
										},
									},
									Name: "sy",
								},
								Rbrack: nil,
							},
							Operator: 2,
							Right: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   33,
										},
										File:   "linearreg.flux",
										Source: "t.N",
										Start: ast.Position{
											Column: 19,
											Line:   33,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   33,
											},
											File:   "linearreg.flux",
											Source: "t",
											Start: ast.Position{
												Column: 19,
												Line:   33,
											},
										},
									},
									Name: "t",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   33,
											},
											File:   "linearreg.flux",
											Source: "N",
											Start: ast.Position{
												Column: 21,
												Line:   33,
											},
										},
									},
									Name: "N",
								},
								Rbrack: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   34,
								},
								File:   "linearreg.flux",
								Source: "slope = (t.sxy - xbar * ybar * t.N) / (t.sxx - t.N * xbar * xbar)",
								Start: ast.Position{
									Column: 5,
									Line:   34,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   34,
									},
									File:   "linearreg.flux",
									Source: "slope",
									Start: ast.Position{
										Column: 5,
										Line:   34,
									},
								},
							},
							Name: "slope",
						},
						Init: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   34,
									},
									File:   "linearreg.flux",
									Source: "(t.sxy - xbar * ybar * t.N) / (t.sxx - t.N * xbar * xbar)",
									Start: ast.Position{
										Column: 13,
										Line:   34,
									},
								},
							},
							Left: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   34,
										},
										File:   "linearreg.flux",
										Source: "(t.sxy - xbar * ybar * t.N)",
										Start: ast.Position{
											Column: 13,
											Line:   34,
										},
									},
								},
								Expression: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   34,
											},
											File:   "linearreg.flux",
											Source: "t.sxy - xbar * ybar * t.N",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "linearreg.flux",
												Source: "t.sxy",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   34,
													},
													File:   "linearreg.flux",
													Source: "t",
													Start: ast.Position{
														Column: 14,
														Line:   34,
													},
												},
											},
											Name: "t",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   34,
													},
													File:   "linearreg.flux",
													Source: "sxy",
													Start: ast.Position{
														Column: 16,
														Line:   34,
													},
												},
											},
											Name: "sxy",
										},
										Rbrack: nil,
									},
									Operator: 6,
									Right: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   34,
												},
												File:   "linearreg.flux",
												Source: "xbar * ybar * t.N",
												Start: ast.Position{
													Column: 22,
													Line:   34,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   34,
													},
													File:   "linearreg.flux",
													Source: "xbar * ybar",
													Start: ast.Position{
														Column: 22,
														Line:   34,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   34,
														},
														File:   "linearreg.flux",
														Source: "xbar",
														Start: ast.Position{
															Column: 22,
															Line:   34,
														},
													},
												},
												Name: "xbar",
											},
											Operator: 1,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   34,
														},
														File:   "linearreg.flux",
														Source: "ybar",
														Start: ast.Position{
															Column: 29,
															Line:   34,
														},
													},
												},
												Name: "ybar",
											},
										},
										Operator: 1,
										Right: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   34,
													},
													File:   "linearreg.flux",
													Source: "t.N",
													Start: ast.Position{
														Column: 36,
														Line:   34,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   34,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 36,
															Line:   34,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   34,
														},
														File:   "linearreg.flux",
														Source: "N",
														Start: ast.Position{
															Column: 38,
															Line:   34,
														},
													},
												},
												Name: "N",
											},
											Rbrack: nil,
										},
									},
								},
								Lparen: nil,
								Rparen: nil,
							},
							Operator: 2,
							Right: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   34,
										},
										File:   "linearreg.flux",
										Source: "(t.sxx - t.N * xbar * xbar)",
										Start: ast.Position{
											Column: 43,
											Line:   34,
										},
									},
								},
								Expression: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   34,
											},
											File:   "linearreg.flux",
											Source: "t.sxx - t.N * xbar * xbar",
											Start: ast.Position{
												Column: 44,
												Line:   34,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   34,
												},
												File:   "linearreg.flux",
												Source: "t.sxx",
												Start: ast.Position{
													Column: 44,
													Line:   34,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   34,
													},
													File:   "linearreg.flux",
													Source: "t",
													Start: ast.Position{
														Column: 44,
														Line:   34,
													},
												},
											},
											Name: "t",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   34,
													},
													File:   "linearreg.flux",
													Source: "sxx",
													Start: ast.Position{
														Column: 46,
														Line:   34,
													},
												},
											},
											Name: "sxx",
										},
										Rbrack: nil,
									},
									Operator: 6,
									Right: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   34,
												},
												File:   "linearreg.flux",
												Source: "t.N * xbar * xbar",
												Start: ast.Position{
													Column: 52,
													Line:   34,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   34,
													},
													File:   "linearreg.flux",
													Source: "t.N * xbar",
													Start: ast.Position{
														Column: 52,
														Line:   34,
													},
												},
											},
											Left: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   34,
														},
														File:   "linearreg.flux",
														Source: "t.N",
														Start: ast.Position{
															Column: 52,
															Line:   34,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   34,
															},
															File:   "linearreg.flux",
															Source: "t",
															Start: ast.Position{
																Column: 52,
																Line:   34,
															},
														},
													},
													Name: "t",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   34,
															},
															File:   "linearreg.flux",
															Source: "N",
															Start: ast.Position{
																Column: 54,
																Line:   34,
															},
														},
													},
													Name: "N",
												},
												Rbrack: nil,
											},
											Operator: 1,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   34,
														},
														File:   "linearreg.flux",
														Source: "xbar",
														Start: ast.Position{
															Column: 58,
															Line:   34,
														},
													},
												},
												Name: "xbar",
											},
										},
										Operator: 1,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   34,
													},
													File:   "linearreg.flux",
													Source: "xbar",
													Start: ast.Position{
														Column: 65,
														Line:   34,
													},
												},
											},
											Name: "xbar",
										},
									},
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   35,
								},
								File:   "linearreg.flux",
								Source: "intercept = ybar - slope * xbar",
								Start: ast.Position{
									Column: 5,
									Line:   35,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   35,
									},
									File:   "linearreg.flux",
									Source: "intercept",
									Start: ast.Position{
										Column: 5,
										Line:   35,
									},
								},
							},
							Name: "intercept",
						},
						Init: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   35,
									},
									File:   "linearreg.flux",
									Source: "ybar - slope * xbar",
									Start: ast.Position{
										Column: 17,
										Line:   35,
									},
								},
							},
							Left: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   35,
										},
										File:   "linearreg.flux",
										Source: "ybar",
										Start: ast.Position{
											Column: 17,
											Line:   35,
										},
									},
								},
								Name: "ybar",
							},
							Operator: 6,
							Right: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   35,
										},
										File:   "linearreg.flux",
										Source: "slope * xbar",
										Start: ast.Position{
											Column: 24,
											Line:   35,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   35,
											},
											File:   "linearreg.flux",
											Source: "slope",
											Start: ast.Position{
												Column: 24,
												Line:   35,
											},
										},
									},
									Name: "slope",
								},
								Operator: 1,
								Right: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   35,
											},
											File:   "linearreg.flux",
											Source: "xbar",
											Start: ast.Position{
												Column: 32,
												Line:   35,
											},
										},
									},
									Name: "xbar",
								},
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   44,
								},
								File:   "linearreg.flux",
								Source: "y_hat = (r) => ({r with\n        y_hat: slope * r.x + intercept,\n        slope: slope,\n        sx: t.sx,\n        sxy: t.sxy,\n        sxx: t.sxx,\n        N: t.N,\n        sy: t.sy,\n    })",
								Start: ast.Position{
									Column: 5,
									Line:   36,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   36,
									},
									File:   "linearreg.flux",
									Source: "y_hat",
									Start: ast.Position{
										Column: 5,
										Line:   36,
									},
								},
							},
							Name: "y_hat",
						},
						Init: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   44,
									},
									File:   "linearreg.flux",
									Source: "(r) => ({r with\n        y_hat: slope * r.x + intercept,\n        slope: slope,\n        sx: t.sx,\n        sxy: t.sxy,\n        sxx: t.sxx,\n        N: t.N,\n        sy: t.sy,\n    })",
									Start: ast.Position{
										Column: 13,
										Line:   36,
									},
								},
							},
							Body: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 7,
											Line:   44,
										},
										File:   "linearreg.flux",
										Source: "({r with\n        y_hat: slope * r.x + intercept,\n        slope: slope,\n        sx: t.sx,\n        sxy: t.sxy,\n        sxx: t.sxx,\n        N: t.N,\n        sy: t.sy,\n    })",
										Start: ast.Position{
											Column: 20,
											Line:   36,
										},
									},
								},
								Expression: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   44,
											},
											File:   "linearreg.flux",
											Source: "{r with\n        y_hat: slope * r.x + intercept,\n        slope: slope,\n        sx: t.sx,\n        sxy: t.sxy,\n        sxx: t.sxx,\n        N: t.N,\n        sy: t.sy,\n    }",
											Start: ast.Position{
												Column: 21,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   37,
												},
												File:   "linearreg.flux",
												Source: "y_hat: slope * r.x + intercept",
												Start: ast.Position{
													Column: 9,
													Line:   37,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   37,
													},
													File:   "linearreg.flux",
													Source: "y_hat",
													Start: ast.Position{
														Column: 9,
														Line:   37,
													},
												},
											},
											Name: "y_hat",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   37,
													},
													File:   "linearreg.flux",
													Source: "slope * r.x + intercept",
													Start: ast.Position{
														Column: 16,
														Line:   37,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   37,
														},
														File:   "linearreg.flux",
														Source: "slope * r.x",
														Start: ast.Position{
															Column: 16,
															Line:   37,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   37,
															},
															File:   "linearreg.flux",
															Source: "slope",
															Start: ast.Position{
																Column: 16,
																Line:   37,
															},
														},
													},
													Name: "slope",
												},
												Operator: 1,
												Right: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   37,
															},
															File:   "linearreg.flux",
															Source: "r.x",
															Start: ast.Position{
																Column: 24,
																Line:   37,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   37,
																},
																File:   "linearreg.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   37,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   37,
																},
																File:   "linearreg.flux",
																Source: "x",
																Start: ast.Position{
																	Column: 26,
																	Line:   37,
																},
															},
														},
														Name: "x",
													},
													Rbrack: nil,
												},
											},
											Operator: 5,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   37,
														},
														File:   "linearreg.flux",
														Source: "intercept",
														Start: ast.Position{
															Column: 30,
															Line:   37,
														},
													},
												},
												Name: "intercept",
											},
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   38,
												},
												File:   "linearreg.flux",
												Source: "slope: slope",
												Start: ast.Position{
													Column: 9,
													Line:   38,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   38,
													},
													File:   "linearreg.flux",
													Source: "slope",
													Start: ast.Position{
														Column: 9,
														Line:   38,
													},
												},
											},
											Name: "slope",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   38,
													},
													File:   "linearreg.flux",
													Source: "slope",
													Start: ast.Position{
														Column: 16,
														Line:   38,
													},
												},
											},
											Name: "slope",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   39,
												},
												File:   "linearreg.flux",
												Source: "sx: t.sx",
												Start: ast.Position{
													Column: 9,
													Line:   39,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   39,
													},
													File:   "linearreg.flux",
													Source: "sx",
													Start: ast.Position{
														Column: 9,
														Line:   39,
													},
												},
											},
											Name: "sx",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   39,
													},
													File:   "linearreg.flux",
													Source: "t.sx",
													Start: ast.Position{
														Column: 13,
														Line:   39,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   39,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 13,
															Line:   39,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   39,
														},
														File:   "linearreg.flux",
														Source: "sx",
														Start: ast.Position{
															Column: 15,
															Line:   39,
														},
													},
												},
												Name: "sx",
											},
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   40,
												},
												File:   "linearreg.flux",
												Source: "sxy: t.sxy",
												Start: ast.Position{
													Column: 9,
													Line:   40,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 12,
														Line:   40,
													},
													File:   "linearreg.flux",
													Source: "sxy",
													Start: ast.Position{
														Column: 9,
														Line:   40,
													},
												},
											},
											Name: "sxy",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   40,
													},
													File:   "linearreg.flux",
													Source: "t.sxy",
													Start: ast.Position{
														Column: 14,
														Line:   40,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   40,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 14,
															Line:   40,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   40,
														},
														File:   "linearreg.flux",
														Source: "sxy",
														Start: ast.Position{
															Column: 16,
															Line:   40,
														},
													},
												},
												Name: "sxy",
											},
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   41,
												},
												File:   "linearreg.flux",
												Source: "sxx: t.sxx",
												Start: ast.Position{
													Column: 9,
													Line:   41,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 12,
														Line:   41,
													},
													File:   "linearreg.flux",
													Source: "sxx",
													Start: ast.Position{
														Column: 9,
														Line:   41,
													},
												},
											},
											Name: "sxx",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   41,
													},
													File:   "linearreg.flux",
													Source: "t.sxx",
													Start: ast.Position{
														Column: 14,
														Line:   41,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   41,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 14,
															Line:   41,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   41,
														},
														File:   "linearreg.flux",
														Source: "sxx",
														Start: ast.Position{
															Column: 16,
															Line:   41,
														},
													},
												},
												Name: "sxx",
											},
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   42,
												},
												File:   "linearreg.flux",
												Source: "N: t.N",
												Start: ast.Position{
													Column: 9,
													Line:   42,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   42,
													},
													File:   "linearreg.flux",
													Source: "N",
													Start: ast.Position{
														Column: 9,
														Line:   42,
													},
												},
											},
											Name: "N",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   42,
													},
													File:   "linearreg.flux",
													Source: "t.N",
													Start: ast.Position{
														Column: 12,
														Line:   42,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 13,
															Line:   42,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 12,
															Line:   42,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   42,
														},
														File:   "linearreg.flux",
														Source: "N",
														Start: ast.Position{
															Column: 14,
															Line:   42,
														},
													},
												},
												Name: "N",
											},
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   43,
												},
												File:   "linearreg.flux",
												Source: "sy: t.sy",
												Start: ast.Position{
													Column: 9,
													Line:   43,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   43,
													},
													File:   "linearreg.flux",
													Source: "sy",
													Start: ast.Position{
														Column: 9,
														Line:   43,
													},
												},
											},
											Name: "sy",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   43,
													},
													File:   "linearreg.flux",
													Source: "t.sy",
													Start: ast.Position{
														Column: 13,
														Line:   43,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   43,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 13,
															Line:   43,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   43,
														},
														File:   "linearreg.flux",
														Source: "sy",
														Start: ast.Position{
															Column: 15,
															Line:   43,
														},
													},
												},
												Name: "sy",
											},
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   36,
												},
												File:   "linearreg.flux",
												Source: "r",
												Start: ast.Position{
													Column: 22,
													Line:   36,
												},
											},
										},
										Name: "r",
									},
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   36,
										},
										File:   "linearreg.flux",
										Source: "r",
										Start: ast.Position{
											Column: 14,
											Line:   36,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   36,
											},
											File:   "linearreg.flux",
											Source: "r",
											Start: ast.Position{
												Column: 14,
												Line:   36,
											},
										},
									},
									Name: "r",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   45,
								},
								File:   "linearreg.flux",
								Source: "rse = (r) => ({r with errors: (r.y - r.y_hat) ^ 2.0})",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   45,
									},
									File:   "linearreg.flux",
									Source: "rse",
									Start: ast.Position{
										Column: 5,
										Line:   45,
									},
								},
							},
							Name: "rse",
						},
						Init: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   45,
									},
									File:   "linearreg.flux",
									Source: "(r) => ({r with errors: (r.y - r.y_hat) ^ 2.0})",
									Start: ast.Position{
										Column: 11,
										Line:   45,
									},
								},
							},
							Body: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   45,
										},
										File:   "linearreg.flux",
										Source: "({r with errors: (r.y - r.y_hat) ^ 2.0})",
										Start: ast.Position{
											Column: 18,
											Line:   45,
										},
									},
								},
								Expression: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   45,
											},
											File:   "linearreg.flux",
											Source: "{r with errors: (r.y - r.y_hat) ^ 2.0}",
											Start: ast.Position{
												Column: 19,
												Line:   45,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   45,
												},
												File:   "linearreg.flux",
												Source: "errors: (r.y - r.y_hat) ^ 2.0",
												Start: ast.Position{
													Column: 27,
													Line:   45,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   45,
													},
													File:   "linearreg.flux",
													Source: "errors",
													Start: ast.Position{
														Column: 27,
														Line:   45,
													},
												},
											},
											Name: "errors",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   45,
													},
													File:   "linearreg.flux",
													Source: "(r.y - r.y_hat) ^ 2.0",
													Start: ast.Position{
														Column: 35,
														Line:   45,
													},
												},
											},
											Left: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   45,
														},
														File:   "linearreg.flux",
														Source: "(r.y - r.y_hat)",
														Start: ast.Position{
															Column: 35,
															Line:   45,
														},
													},
												},
												Expression: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   45,
															},
															File:   "linearreg.flux",
															Source: "r.y - r.y_hat",
															Start: ast.Position{
																Column: 36,
																Line:   45,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   45,
																},
																File:   "linearreg.flux",
																Source: "r.y",
																Start: ast.Position{
																	Column: 36,
																	Line:   45,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   45,
																	},
																	File:   "linearreg.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 36,
																		Line:   45,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   45,
																	},
																	File:   "linearreg.flux",
																	Source: "y",
																	Start: ast.Position{
																		Column: 38,
																		Line:   45,
																	},
																},
															},
															Name: "y",
														},
														Rbrack: nil,
													},
													Operator: 6,
													Right: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   45,
																},
																File:   "linearreg.flux",
																Source: "r.y_hat",
																Start: ast.Position{
																	Column: 42,
																	Line:   45,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   45,
																	},
																	File:   "linearreg.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 42,
																		Line:   45,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   45,
																	},
																	File:   "linearreg.flux",
																	Source: "y_hat",
																	Start: ast.Position{
																		Column: 44,
																		Line:   45,
																	},
																},
															},
															Name: "y_hat",
														},
														Rbrack: nil,
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Operator: 4,
											Right: &ast.FloatLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   45,
														},
														File:   "linearreg.flux",
														Source: "2.0",
														Start: ast.Position{
															Column: 53,
															Line:   45,
														},
													},
												},
												Value: 2.0,
											},
										},
									}},
									Rbrace: nil,
									With: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   45,
												},
												File:   "linearreg.flux",
												Source: "r",
												Start: ast.Position{
													Column: 20,
													Line:   45,
												},
											},
										},
										Name: "r",
									},
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   45,
										},
										File:   "linearreg.flux",
										Source: "r",
										Start: ast.Position{
											Column: 12,
											Line:   45,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   45,
											},
											File:   "linearreg.flux",
											Source: "r",
											Start: ast.Position{
												Column: 12,
												Line:   45,
											},
										},
									},
									Name: "r",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   48,
								},
								File:   "linearreg.flux",
								Source: "output = renameAndSum\n        |> map(fn: y_hat)\n        |> map(fn: rse)",
								Start: ast.Position{
									Column: 5,
									Line:   46,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   46,
									},
									File:   "linearreg.flux",
									Source: "output",
									Start: ast.Position{
										Column: 5,
										Line:   46,
									},
								},
							},
							Name: "output",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   46,
											},
											File:   "linearreg.flux",
											Source: "renameAndSum",
											Start: ast.Position{
												Column: 14,
												Line:   46,
											},
										},
									},
									Name: "renameAndSum",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   47,
										},
										File:   "linearreg.flux",
										Source: "renameAndSum\n        |> map(fn: y_hat)",
										Start: ast.Position{
											Column: 14,
											Line:   46,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   47,
												},
												File:   "linearreg.flux",
												Source: "fn: y_hat",
												Start: ast.Position{
													Column: 16,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   47,
													},
													File:   "linearreg.flux",
													Source: "fn: y_hat",
													Start: ast.Position{
														Column: 16,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   47,
														},
														File:   "linearreg.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   47,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   47,
														},
														File:   "linearreg.flux",
														Source: "y_hat",
														Start: ast.Position{
															Column: 20,
															Line:   47,
														},
													},
												},
												Name: "y_hat",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   47,
											},
											File:   "linearreg.flux",
											Source: "map(fn: y_hat)",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   47,
												},
												File:   "linearreg.flux",
												Source: "map",
												Start: ast.Position{
													Column: 12,
													Line:   47,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   48,
									},
									File:   "linearreg.flux",
									Source: "renameAndSum\n        |> map(fn: y_hat)\n        |> map(fn: rse)",
									Start: ast.Position{
										Column: 14,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   48,
											},
											File:   "linearreg.flux",
											Source: "fn: rse",
											Start: ast.Position{
												Column: 16,
												Line:   48,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   48,
												},
												File:   "linearreg.flux",
												Source: "fn: rse",
												Start: ast.Position{
													Column: 16,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   48,
													},
													File:   "linearreg.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 16,
														Line:   48,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   48,
													},
													File:   "linearreg.flux",
													Source: "rse",
													Start: ast.Position{
														Column: 20,
														Line:   48,
													},
												},
											},
											Name: "rse",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   48,
										},
										File:   "linearreg.flux",
										Source: "map(fn: rse)",
										Start: ast.Position{
											Column: 12,
											Line:   48,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   48,
											},
											File:   "linearreg.flux",
											Source: "map",
											Start: ast.Position{
												Column: 12,
												Line:   48,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   50,
									},
									File:   "linearreg.flux",
									Source: "output",
									Start: ast.Position{
										Column: 12,
										Line:   50,
									},
								},
							},
							Name: "output",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   50,
								},
								File:   "linearreg.flux",
								Source: "return output",
								Start: ast.Position{
									Column: 5,
									Line:   50,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   8,
							},
							File:   "linearreg.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 21,
								Line:   8,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   8,
								},
								File:   "linearreg.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 21,
									Line:   8,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   8,
							},
							File:   "linearreg.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   8,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "linearreg.flux",
					Source: "import \"math\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "linearreg.flux",
						Source: "\"math\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "math",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   5,
					},
					File:   "linearreg.flux",
					Source: "import \"generate\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   5,
						},
						File:   "linearreg.flux",
						Source: "\"generate\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "generate",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "linearreg.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "linearreg.flux",
					Source: "package statsmodels",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "linearreg.flux",
						Source: "statsmodels",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "statsmodels",
			},
		},
	}},
	Package: "statsmodels",
	Path:    "contrib/anaisdg/statsmodels",
}
