// DO NOT EDIT: This file is autogenerated via the builtin command.

package dict

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 15,
					Line:   136,
				},
				File:   "dict.flux",
				Source: "package dict\n\n\n// fromList is a function that creates a dictionary from a list of records\n//  with key and value properties.\n//\n// ## Parameters\n// - `pairs` is the list of records, each containing key and value properties.\n//\n// ## Create a dictionary from a list of records\n//\n// ```\n// import \"dict\"\n//\n// // Define a new dictionary using an array of records\n// d = dict.fromList(\n//   pairs: [\n//     {key: 1, value: \"foo\"},\n//     {key: 2, value: \"bar\"}\n//   ]\n// )\n//\n// // Return a property of the dictionary\n// dict.get(dict: d, key: 1, default: \"\") // returns foo\n// ```\nbuiltin fromList : (pairs: [{key: K, value: V}]) => [K:V] where K: Comparable\n\n// get is a function that returns the value of a specified key in the\n//  dictionary or a default value if the key does not exist.\n//\n// ## Parameters\n// - `dict` is the dictionary to return a value from.\n// - `key` is the key to return from the dictionary.\n// - `default` is the default value to return if the key does not\n//   exist in the dictionary.\n//\n//   Must be the same type as values in the dictionary.\n//\n// ## Return a property of a dictionary\n//\n// ```\n// import \"dict\"\n//\n// d = [1: \"foo\", 2: \"bar\"]\n//\n// dict.get(\n//   dict: d,\n//   key: 1,\n//   default: \"\"\n// )\n// // returns foo\n// ```\nbuiltin get : (dict: [K:V], key: K, default: V) => V where K: Comparable\n\n// insert is a function that inserts a key-value pair into a dictionary and\n//  returns a new, updated dictionary.\n//\n//  If the key already exists in the dictionary, the function overwrites\n//  the existing value.\n//\n// ## Parameters\n// - `dict` is the dictionary to update.\n// - `key` is the key to insert into the dictionary.\n//\n//   Must be the same type as the existing keys in the dictionary.\n//\n// - `default` is the value to insert into the dictionary.\n//\n//   Must be the same type as the existing values in the dictionary. \n//\n// ## Insert a new key-value pair into the a dictionary\n//\n// ```\n// import \"dict\"\n//\n// d = [1: \"foo\", 2: \"bar\"]\n//\n// dNew = dict.insert(\n//   dict: d,\n//   key: 3,\n//   value: \"baz\"\n// )\n//\n// // Verify the new key-value pair was inserted\n// dict.get(dict: dNew, key: 3, default: \"\")\n// ```\n//\n// ## Overwrite an existing key-value pair in a dictionary\n//\n// ```\n// import \"dict\"\n//\n// d = [1: \"foo\", 2: \"bar\"]\n//\n// dNew = dict.insert(\n//   dict: d,\n//   key: 2,\n//   value: \"baz\"\n// )\n//\n// // Verify the new key-value pair was overwritten\n// dict.get(dict: dNew, key: 2, default: \"\")\n// ```\nbuiltin insert : (dict: [K:V], key: K, value: V) => [K:V] where K: Comparable\n\n// remove is a function that removes a key value pair from a dictionary and\n//  returns an updated dictionary. \n//\n// ## Parameters\n// - `dict` is the dictionary to remove the key-value pair from.\n// - `key` is the key to remove from the dictionary.\n//\n//   Must be the same type as existing keys in the dictionary.\n//\n// ## Remove a property from a dictionary\n//\n// ```\n// import \"dict\"\n//\n// d = [1: \"foo\", 2: \"bar\"]\n//\n// dNew = dict.remove(\n//   dict: d,\n//   key: 1\n// )\n//\n// // Verify the key-value pairs was removed\n//\n// dict.get(dict: dNew, key: 1, default: \"\")\n// // Returns an empty string\n//\n// dict.get(dict: dNew, key: 2, default: \"\")\n// // Returns bar\n// ```\nbuiltin remove",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// fromList is a function that creates a dictionary from a list of records\n"}, ast.Comment{Text: "//  with key and value properties.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `pairs` is the list of records, each containing key and value properties.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Create a dictionary from a list of records\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"dict\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// // Define a new dictionary using an array of records\n"}, ast.Comment{Text: "// d = dict.fromList(\n"}, ast.Comment{Text: "//   pairs: [\n"}, ast.Comment{Text: "//     {key: 1, value: \"foo\"},\n"}, ast.Comment{Text: "//     {key: 2, value: \"bar\"}\n"}, ast.Comment{Text: "//   ]\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// // Return a property of the dictionary\n"}, ast.Comment{Text: "// dict.get(dict: d, key: 1, default: \"\") // returns foo\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   27,
					},
					File:   "dict.flux",
					Source: "builtin fromList",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   27,
						},
						File:   "dict.flux",
						Source: "fromList",
						Start: ast.Position{
							Column: 9,
							Line:   27,
						},
					},
				},
				Name: "fromList",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 78,
							Line:   27,
						},
						File:   "dict.flux",
						Source: "(pairs: [{key: K, value: V}]) => [K:V] where K: Comparable",
						Start: ast.Position{
							Column: 20,
							Line:   27,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   27,
							},
							File:   "dict.flux",
							Source: "K: Comparable",
							Start: ast.Position{
								Column: 65,
								Line:   27,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   27,
								},
								File:   "dict.flux",
								Source: "Comparable",
								Start: ast.Position{
									Column: 68,
									Line:   27,
								},
							},
						},
						Name: "Comparable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   27,
								},
								File:   "dict.flux",
								Source: "K",
								Start: ast.Position{
									Column: 65,
									Line:   27,
								},
							},
						},
						Name: "K",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   27,
							},
							File:   "dict.flux",
							Source: "(pairs: [{key: K, value: V}]) => [K:V]",
							Start: ast.Position{
								Column: 20,
								Line:   27,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   27,
								},
								File:   "dict.flux",
								Source: "pairs: [{key: K, value: V}]",
								Start: ast.Position{
									Column: 21,
									Line:   27,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   27,
									},
									File:   "dict.flux",
									Source: "pairs",
									Start: ast.Position{
										Column: 21,
										Line:   27,
									},
								},
							},
							Name: "pairs",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   27,
									},
									File:   "dict.flux",
									Source: "[{key: K, value: V}]",
									Start: ast.Position{
										Column: 28,
										Line:   27,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   27,
										},
										File:   "dict.flux",
										Source: "{key: K, value: V}",
										Start: ast.Position{
											Column: 29,
											Line:   27,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   27,
											},
											File:   "dict.flux",
											Source: "key: K",
											Start: ast.Position{
												Column: 30,
												Line:   27,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   27,
												},
												File:   "dict.flux",
												Source: "key",
												Start: ast.Position{
													Column: 30,
													Line:   27,
												},
											},
										},
										Name: "key",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   27,
												},
												File:   "dict.flux",
												Source: "K",
												Start: ast.Position{
													Column: 35,
													Line:   27,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   27,
													},
													File:   "dict.flux",
													Source: "K",
													Start: ast.Position{
														Column: 35,
														Line:   27,
													},
												},
											},
											Name: "K",
										},
									},
								}, &ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   27,
											},
											File:   "dict.flux",
											Source: "value: V",
											Start: ast.Position{
												Column: 38,
												Line:   27,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   27,
												},
												File:   "dict.flux",
												Source: "value",
												Start: ast.Position{
													Column: 38,
													Line:   27,
												},
											},
										},
										Name: "value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   27,
												},
												File:   "dict.flux",
												Source: "V",
												Start: ast.Position{
													Column: 45,
													Line:   27,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   27,
													},
													File:   "dict.flux",
													Source: "V",
													Start: ast.Position{
														Column: 45,
														Line:   27,
													},
												},
											},
											Name: "V",
										},
									},
								}},
								Tvar: nil,
							},
						},
					}},
					Return: &ast.DictType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   27,
								},
								File:   "dict.flux",
								Source: "[K:V]",
								Start: ast.Position{
									Column: 53,
									Line:   27,
								},
							},
						},
						KeyType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   27,
									},
									File:   "dict.flux",
									Source: "K",
									Start: ast.Position{
										Column: 54,
										Line:   27,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   27,
										},
										File:   "dict.flux",
										Source: "K",
										Start: ast.Position{
											Column: 54,
											Line:   27,
										},
									},
								},
								Name: "K",
							},
						},
						ValueType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   27,
									},
									File:   "dict.flux",
									Source: "V",
									Start: ast.Position{
										Column: 56,
										Line:   27,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   27,
										},
										File:   "dict.flux",
										Source: "V",
										Start: ast.Position{
											Column: 56,
											Line:   27,
										},
									},
								},
								Name: "V",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// get is a function that returns the value of a specified key in the\n"}, ast.Comment{Text: "//  dictionary or a default value if the key does not exist.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `dict` is the dictionary to return a value from.\n"}, ast.Comment{Text: "// - `key` is the key to return from the dictionary.\n"}, ast.Comment{Text: "// - `default` is the default value to return if the key does not\n"}, ast.Comment{Text: "//   exist in the dictionary.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Must be the same type as values in the dictionary.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return a property of a dictionary\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"dict\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// d = [1: \"foo\", 2: \"bar\"]\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// dict.get(\n"}, ast.Comment{Text: "//   dict: d,\n"}, ast.Comment{Text: "//   key: 1,\n"}, ast.Comment{Text: "//   default: \"\"\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// // returns foo\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   54,
					},
					File:   "dict.flux",
					Source: "builtin get",
					Start: ast.Position{
						Column: 1,
						Line:   54,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   54,
						},
						File:   "dict.flux",
						Source: "get",
						Start: ast.Position{
							Column: 9,
							Line:   54,
						},
					},
				},
				Name: "get",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 73,
							Line:   54,
						},
						File:   "dict.flux",
						Source: "(dict: [K:V], key: K, default: V) => V where K: Comparable",
						Start: ast.Position{
							Column: 15,
							Line:   54,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   54,
							},
							File:   "dict.flux",
							Source: "K: Comparable",
							Start: ast.Position{
								Column: 60,
								Line:   54,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   54,
								},
								File:   "dict.flux",
								Source: "Comparable",
								Start: ast.Position{
									Column: 63,
									Line:   54,
								},
							},
						},
						Name: "Comparable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   54,
								},
								File:   "dict.flux",
								Source: "K",
								Start: ast.Position{
									Column: 60,
									Line:   54,
								},
							},
						},
						Name: "K",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   54,
							},
							File:   "dict.flux",
							Source: "(dict: [K:V], key: K, default: V) => V",
							Start: ast.Position{
								Column: 15,
								Line:   54,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   54,
								},
								File:   "dict.flux",
								Source: "dict: [K:V]",
								Start: ast.Position{
									Column: 16,
									Line:   54,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   54,
									},
									File:   "dict.flux",
									Source: "dict",
									Start: ast.Position{
										Column: 16,
										Line:   54,
									},
								},
							},
							Name: "dict",
						},
						Ty: &ast.DictType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   54,
									},
									File:   "dict.flux",
									Source: "[K:V]",
									Start: ast.Position{
										Column: 22,
										Line:   54,
									},
								},
							},
							KeyType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   54,
										},
										File:   "dict.flux",
										Source: "K",
										Start: ast.Position{
											Column: 23,
											Line:   54,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   54,
											},
											File:   "dict.flux",
											Source: "K",
											Start: ast.Position{
												Column: 23,
												Line:   54,
											},
										},
									},
									Name: "K",
								},
							},
							ValueType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   54,
										},
										File:   "dict.flux",
										Source: "V",
										Start: ast.Position{
											Column: 25,
											Line:   54,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   54,
											},
											File:   "dict.flux",
											Source: "V",
											Start: ast.Position{
												Column: 25,
												Line:   54,
											},
										},
									},
									Name: "V",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   54,
								},
								File:   "dict.flux",
								Source: "key: K",
								Start: ast.Position{
									Column: 29,
									Line:   54,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   54,
									},
									File:   "dict.flux",
									Source: "key",
									Start: ast.Position{
										Column: 29,
										Line:   54,
									},
								},
							},
							Name: "key",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   54,
									},
									File:   "dict.flux",
									Source: "K",
									Start: ast.Position{
										Column: 34,
										Line:   54,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   54,
										},
										File:   "dict.flux",
										Source: "K",
										Start: ast.Position{
											Column: 34,
											Line:   54,
										},
									},
								},
								Name: "K",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   54,
								},
								File:   "dict.flux",
								Source: "default: V",
								Start: ast.Position{
									Column: 37,
									Line:   54,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   54,
									},
									File:   "dict.flux",
									Source: "default",
									Start: ast.Position{
										Column: 37,
										Line:   54,
									},
								},
							},
							Name: "default",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   54,
									},
									File:   "dict.flux",
									Source: "V",
									Start: ast.Position{
										Column: 46,
										Line:   54,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   54,
										},
										File:   "dict.flux",
										Source: "V",
										Start: ast.Position{
											Column: 46,
											Line:   54,
										},
									},
								},
								Name: "V",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   54,
								},
								File:   "dict.flux",
								Source: "V",
								Start: ast.Position{
									Column: 52,
									Line:   54,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   54,
									},
									File:   "dict.flux",
									Source: "V",
									Start: ast.Position{
										Column: 52,
										Line:   54,
									},
								},
							},
							Name: "V",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// insert is a function that inserts a key-value pair into a dictionary and\n"}, ast.Comment{Text: "//  returns a new, updated dictionary.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//  If the key already exists in the dictionary, the function overwrites\n"}, ast.Comment{Text: "//  the existing value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `dict` is the dictionary to update.\n"}, ast.Comment{Text: "// - `key` is the key to insert into the dictionary.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Must be the same type as the existing keys in the dictionary.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `default` is the value to insert into the dictionary.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Must be the same type as the existing values in the dictionary. \n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Insert a new key-value pair into the a dictionary\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"dict\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// d = [1: \"foo\", 2: \"bar\"]\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// dNew = dict.insert(\n"}, ast.Comment{Text: "//   dict: d,\n"}, ast.Comment{Text: "//   key: 3,\n"}, ast.Comment{Text: "//   value: \"baz\"\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// // Verify the new key-value pair was inserted\n"}, ast.Comment{Text: "// dict.get(dict: dNew, key: 3, default: \"\")\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Overwrite an existing key-value pair in a dictionary\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"dict\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// d = [1: \"foo\", 2: \"bar\"]\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// dNew = dict.insert(\n"}, ast.Comment{Text: "//   dict: d,\n"}, ast.Comment{Text: "//   key: 2,\n"}, ast.Comment{Text: "//   value: \"baz\"\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// // Verify the new key-value pair was overwritten\n"}, ast.Comment{Text: "// dict.get(dict: dNew, key: 2, default: \"\")\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   105,
					},
					File:   "dict.flux",
					Source: "builtin insert",
					Start: ast.Position{
						Column: 1,
						Line:   105,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   105,
						},
						File:   "dict.flux",
						Source: "insert",
						Start: ast.Position{
							Column: 9,
							Line:   105,
						},
					},
				},
				Name: "insert",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 78,
							Line:   105,
						},
						File:   "dict.flux",
						Source: "(dict: [K:V], key: K, value: V) => [K:V] where K: Comparable",
						Start: ast.Position{
							Column: 18,
							Line:   105,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   105,
							},
							File:   "dict.flux",
							Source: "K: Comparable",
							Start: ast.Position{
								Column: 65,
								Line:   105,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   105,
								},
								File:   "dict.flux",
								Source: "Comparable",
								Start: ast.Position{
									Column: 68,
									Line:   105,
								},
							},
						},
						Name: "Comparable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   105,
								},
								File:   "dict.flux",
								Source: "K",
								Start: ast.Position{
									Column: 65,
									Line:   105,
								},
							},
						},
						Name: "K",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   105,
							},
							File:   "dict.flux",
							Source: "(dict: [K:V], key: K, value: V) => [K:V]",
							Start: ast.Position{
								Column: 18,
								Line:   105,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   105,
								},
								File:   "dict.flux",
								Source: "dict: [K:V]",
								Start: ast.Position{
									Column: 19,
									Line:   105,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   105,
									},
									File:   "dict.flux",
									Source: "dict",
									Start: ast.Position{
										Column: 19,
										Line:   105,
									},
								},
							},
							Name: "dict",
						},
						Ty: &ast.DictType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   105,
									},
									File:   "dict.flux",
									Source: "[K:V]",
									Start: ast.Position{
										Column: 25,
										Line:   105,
									},
								},
							},
							KeyType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   105,
										},
										File:   "dict.flux",
										Source: "K",
										Start: ast.Position{
											Column: 26,
											Line:   105,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   105,
											},
											File:   "dict.flux",
											Source: "K",
											Start: ast.Position{
												Column: 26,
												Line:   105,
											},
										},
									},
									Name: "K",
								},
							},
							ValueType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   105,
										},
										File:   "dict.flux",
										Source: "V",
										Start: ast.Position{
											Column: 28,
											Line:   105,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   105,
											},
											File:   "dict.flux",
											Source: "V",
											Start: ast.Position{
												Column: 28,
												Line:   105,
											},
										},
									},
									Name: "V",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   105,
								},
								File:   "dict.flux",
								Source: "key: K",
								Start: ast.Position{
									Column: 32,
									Line:   105,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   105,
									},
									File:   "dict.flux",
									Source: "key",
									Start: ast.Position{
										Column: 32,
										Line:   105,
									},
								},
							},
							Name: "key",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   105,
									},
									File:   "dict.flux",
									Source: "K",
									Start: ast.Position{
										Column: 37,
										Line:   105,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   105,
										},
										File:   "dict.flux",
										Source: "K",
										Start: ast.Position{
											Column: 37,
											Line:   105,
										},
									},
								},
								Name: "K",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   105,
								},
								File:   "dict.flux",
								Source: "value: V",
								Start: ast.Position{
									Column: 40,
									Line:   105,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   105,
									},
									File:   "dict.flux",
									Source: "value",
									Start: ast.Position{
										Column: 40,
										Line:   105,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   105,
									},
									File:   "dict.flux",
									Source: "V",
									Start: ast.Position{
										Column: 47,
										Line:   105,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   105,
										},
										File:   "dict.flux",
										Source: "V",
										Start: ast.Position{
											Column: 47,
											Line:   105,
										},
									},
								},
								Name: "V",
							},
						},
					}},
					Return: &ast.DictType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   105,
								},
								File:   "dict.flux",
								Source: "[K:V]",
								Start: ast.Position{
									Column: 53,
									Line:   105,
								},
							},
						},
						KeyType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   105,
									},
									File:   "dict.flux",
									Source: "K",
									Start: ast.Position{
										Column: 54,
										Line:   105,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   105,
										},
										File:   "dict.flux",
										Source: "K",
										Start: ast.Position{
											Column: 54,
											Line:   105,
										},
									},
								},
								Name: "K",
							},
						},
						ValueType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   105,
									},
									File:   "dict.flux",
									Source: "V",
									Start: ast.Position{
										Column: 56,
										Line:   105,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   105,
										},
										File:   "dict.flux",
										Source: "V",
										Start: ast.Position{
											Column: 56,
											Line:   105,
										},
									},
								},
								Name: "V",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// remove is a function that removes a key value pair from a dictionary and\n"}, ast.Comment{Text: "//  returns an updated dictionary. \n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `dict` is the dictionary to remove the key-value pair from.\n"}, ast.Comment{Text: "// - `key` is the key to remove from the dictionary.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Must be the same type as existing keys in the dictionary.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Remove a property from a dictionary\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"dict\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// d = [1: \"foo\", 2: \"bar\"]\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// dNew = dict.remove(\n"}, ast.Comment{Text: "//   dict: d,\n"}, ast.Comment{Text: "//   key: 1\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// // Verify the key-value pairs was removed\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// dict.get(dict: dNew, key: 1, default: \"\")\n"}, ast.Comment{Text: "// // Returns an empty string\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// dict.get(dict: dNew, key: 2, default: \"\")\n"}, ast.Comment{Text: "// // Returns bar\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   136,
					},
					File:   "dict.flux",
					Source: "builtin remove",
					Start: ast.Position{
						Column: 1,
						Line:   136,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   136,
						},
						File:   "dict.flux",
						Source: "remove",
						Start: ast.Position{
							Column: 9,
							Line:   136,
						},
					},
				},
				Name: "remove",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   136,
						},
						File:   "dict.flux",
						Source: "(dict: [K:V], key: K) => [K:V] where K: Comparable",
						Start: ast.Position{
							Column: 18,
							Line:   136,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   136,
							},
							File:   "dict.flux",
							Source: "K: Comparable",
							Start: ast.Position{
								Column: 55,
								Line:   136,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   136,
								},
								File:   "dict.flux",
								Source: "Comparable",
								Start: ast.Position{
									Column: 58,
									Line:   136,
								},
							},
						},
						Name: "Comparable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   136,
								},
								File:   "dict.flux",
								Source: "K",
								Start: ast.Position{
									Column: 55,
									Line:   136,
								},
							},
						},
						Name: "K",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   136,
							},
							File:   "dict.flux",
							Source: "(dict: [K:V], key: K) => [K:V]",
							Start: ast.Position{
								Column: 18,
								Line:   136,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   136,
								},
								File:   "dict.flux",
								Source: "dict: [K:V]",
								Start: ast.Position{
									Column: 19,
									Line:   136,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   136,
									},
									File:   "dict.flux",
									Source: "dict",
									Start: ast.Position{
										Column: 19,
										Line:   136,
									},
								},
							},
							Name: "dict",
						},
						Ty: &ast.DictType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   136,
									},
									File:   "dict.flux",
									Source: "[K:V]",
									Start: ast.Position{
										Column: 25,
										Line:   136,
									},
								},
							},
							KeyType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   136,
										},
										File:   "dict.flux",
										Source: "K",
										Start: ast.Position{
											Column: 26,
											Line:   136,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   136,
											},
											File:   "dict.flux",
											Source: "K",
											Start: ast.Position{
												Column: 26,
												Line:   136,
											},
										},
									},
									Name: "K",
								},
							},
							ValueType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   136,
										},
										File:   "dict.flux",
										Source: "V",
										Start: ast.Position{
											Column: 28,
											Line:   136,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   136,
											},
											File:   "dict.flux",
											Source: "V",
											Start: ast.Position{
												Column: 28,
												Line:   136,
											},
										},
									},
									Name: "V",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   136,
								},
								File:   "dict.flux",
								Source: "key: K",
								Start: ast.Position{
									Column: 32,
									Line:   136,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   136,
									},
									File:   "dict.flux",
									Source: "key",
									Start: ast.Position{
										Column: 32,
										Line:   136,
									},
								},
							},
							Name: "key",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   136,
									},
									File:   "dict.flux",
									Source: "K",
									Start: ast.Position{
										Column: 37,
										Line:   136,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   136,
										},
										File:   "dict.flux",
										Source: "K",
										Start: ast.Position{
											Column: 37,
											Line:   136,
										},
									},
								},
								Name: "K",
							},
						},
					}},
					Return: &ast.DictType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   136,
								},
								File:   "dict.flux",
								Source: "[K:V]",
								Start: ast.Position{
									Column: 43,
									Line:   136,
								},
							},
						},
						KeyType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   136,
									},
									File:   "dict.flux",
									Source: "K",
									Start: ast.Position{
										Column: 44,
										Line:   136,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   136,
										},
										File:   "dict.flux",
										Source: "K",
										Start: ast.Position{
											Column: 44,
											Line:   136,
										},
									},
								},
								Name: "K",
							},
						},
						ValueType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   136,
									},
									File:   "dict.flux",
									Source: "V",
									Start: ast.Position{
										Column: 46,
										Line:   136,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   136,
										},
										File:   "dict.flux",
										Source: "V",
										Start: ast.Position{
											Column: 46,
											Line:   136,
										},
									},
								},
								Name: "V",
							},
						},
					},
				},
			},
		}},
		Eof:      nil,
		Imports:  nil,
		Metadata: "parser-type=rust",
		Name:     "dict.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package dictionary provides functions for interacting with dictionary types.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   2,
					},
					File:   "dict.flux",
					Source: "package dict",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   2,
						},
						File:   "dict.flux",
						Source: "dict",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "dict",
			},
		},
	}},
	Package: "dict",
	Path:    "dict",
}
