// DO NOT EDIT: This file is autogenerated via the builtin command.

package oee

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   72,
				},
				File:   "oee.flux",
				Source: "package oee\n\n\nimport \"contrib/tomhollingworth/events\"\nimport \"experimental\"\n\n// computeAPQ computes availability, performance, quality and overall equipment effectiveness (oee).\n// productionEvents - a stream of start/stop events for the production process. Each row contains\n//   a _time and state that indicates start and stop events.\n// partEvents - a stream of part counts. Each row contains cumulative counts where column partCount\n//   represents total number of produced parts and badCount number of parts that did not meet quality standards.\n// runningState - production event or state value that corresponds to equipment running state\n// plannedTime - total time that equipment is expected to produce\n// idealCycleTime - theoretical minimum time to produce one part\ncomputeAPQ = (\n        productionEvents,\n        partEvents,\n        runningState,\n        plannedTime,\n        idealCycleTime,\n) => {\n    availability = productionEvents\n        |> events.duration(unit: 1ns, columnName: \"runTime\")\n        |> filter(fn: (r) => r.state == runningState)\n        |> sum(column: \"runTime\")\n        |> map(fn: (r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))}))\n    totalCount = partEvents\n        |> difference(columns: [\"partCount\"], nonNegative: true)\n        |> sum(column: \"partCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")\n    badCount = partEvents\n        |> difference(columns: [\"badCount\"], nonNegative: true)\n        |> sum(column: \"badCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")\n    performance = experimental.join(\n        left: availability,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        }),\n    )\n    quality = experimental.join(\n        left: badCount,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        }),\n    )\n\n    return experimental.join(\n        left: performance,\n        right: quality,\n        fn: (left, right) => ({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        }),\n    )\n}\n\n// APQ computes availability, performance, quality and overall equipment effectiveness (oee).\n// Input tables are expected to have rows with _time, state, partCount and badCount columns, where\n//   state that indicates start and stop events, partCount represents total number\n//   of produced parts and badCount represents number of parts that did not meet quality standards.\n// plannedTime - total time that equipment is expected to produce\n// idealCycleTime - theoretical minimum time to produce one part\nAPQ = (tables=<-, runningState, plannedTime, idealCycleTime) => computeAPQ(\n    productionEvents: tables,\n    partEvents: tables,\n    runningState: runningState,\n    plannedTime: plannedTime,\n    idealCycleTime: idealCycleTime,\n)",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   58,
					},
					File:   "oee.flux",
					Source: "computeAPQ = (\n        productionEvents,\n        partEvents,\n        runningState,\n        plannedTime,\n        idealCycleTime,\n) => {\n    availability = productionEvents\n        |> events.duration(unit: 1ns, columnName: \"runTime\")\n        |> filter(fn: (r) => r.state == runningState)\n        |> sum(column: \"runTime\")\n        |> map(fn: (r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))}))\n    totalCount = partEvents\n        |> difference(columns: [\"partCount\"], nonNegative: true)\n        |> sum(column: \"partCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")\n    badCount = partEvents\n        |> difference(columns: [\"badCount\"], nonNegative: true)\n        |> sum(column: \"badCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")\n    performance = experimental.join(\n        left: availability,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        }),\n    )\n    quality = experimental.join(\n        left: badCount,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        }),\n    )\n\n    return experimental.join(\n        left: performance,\n        right: quality,\n        fn: (left, right) => ({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        }),\n    )\n}",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// computeAPQ computes availability, performance, quality and overall equipment effectiveness (oee).\n"}, ast.Comment{Text: "// productionEvents - a stream of start/stop events for the production process. Each row contains\n"}, ast.Comment{Text: "//   a _time and state that indicates start and stop events.\n"}, ast.Comment{Text: "// partEvents - a stream of part counts. Each row contains cumulative counts where column partCount\n"}, ast.Comment{Text: "//   represents total number of produced parts and badCount number of parts that did not meet quality standards.\n"}, ast.Comment{Text: "// runningState - production event or state value that corresponds to equipment running state\n"}, ast.Comment{Text: "// plannedTime - total time that equipment is expected to produce\n"}, ast.Comment{Text: "// idealCycleTime - theoretical minimum time to produce one part\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   15,
						},
						File:   "oee.flux",
						Source: "computeAPQ",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "computeAPQ",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   58,
						},
						File:   "oee.flux",
						Source: "(\n        productionEvents,\n        partEvents,\n        runningState,\n        plannedTime,\n        idealCycleTime,\n) => {\n    availability = productionEvents\n        |> events.duration(unit: 1ns, columnName: \"runTime\")\n        |> filter(fn: (r) => r.state == runningState)\n        |> sum(column: \"runTime\")\n        |> map(fn: (r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))}))\n    totalCount = partEvents\n        |> difference(columns: [\"partCount\"], nonNegative: true)\n        |> sum(column: \"partCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")\n    badCount = partEvents\n        |> difference(columns: [\"badCount\"], nonNegative: true)\n        |> sum(column: \"badCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")\n    performance = experimental.join(\n        left: availability,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        }),\n    )\n    quality = experimental.join(\n        left: badCount,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        }),\n    )\n\n    return experimental.join(\n        left: performance,\n        right: quality,\n        fn: (left, right) => ({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        }),\n    )\n}",
						Start: ast.Position{
							Column: 14,
							Line:   15,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   58,
							},
							File:   "oee.flux",
							Source: "{\n    availability = productionEvents\n        |> events.duration(unit: 1ns, columnName: \"runTime\")\n        |> filter(fn: (r) => r.state == runningState)\n        |> sum(column: \"runTime\")\n        |> map(fn: (r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))}))\n    totalCount = partEvents\n        |> difference(columns: [\"partCount\"], nonNegative: true)\n        |> sum(column: \"partCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")\n    badCount = partEvents\n        |> difference(columns: [\"badCount\"], nonNegative: true)\n        |> sum(column: \"badCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")\n    performance = experimental.join(\n        left: availability,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        }),\n    )\n    quality = experimental.join(\n        left: badCount,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        }),\n    )\n\n    return experimental.join(\n        left: performance,\n        right: quality,\n        fn: (left, right) => ({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        }),\n    )\n}",
							Start: ast.Position{
								Column: 6,
								Line:   21,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 120,
									Line:   26,
								},
								File:   "oee.flux",
								Source: "availability = productionEvents\n        |> events.duration(unit: 1ns, columnName: \"runTime\")\n        |> filter(fn: (r) => r.state == runningState)\n        |> sum(column: \"runTime\")\n        |> map(fn: (r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))}))",
								Start: ast.Position{
									Column: 5,
									Line:   22,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   22,
									},
									File:   "oee.flux",
									Source: "availability",
									Start: ast.Position{
										Column: 5,
										Line:   22,
									},
								},
							},
							Name: "availability",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   22,
													},
													File:   "oee.flux",
													Source: "productionEvents",
													Start: ast.Position{
														Column: 20,
														Line:   22,
													},
												},
											},
											Name: "productionEvents",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   23,
												},
												File:   "oee.flux",
												Source: "productionEvents\n        |> events.duration(unit: 1ns, columnName: \"runTime\")",
												Start: ast.Position{
													Column: 20,
													Line:   22,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   23,
														},
														File:   "oee.flux",
														Source: "unit: 1ns, columnName: \"runTime\"",
														Start: ast.Position{
															Column: 28,
															Line:   23,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   23,
															},
															File:   "oee.flux",
															Source: "unit: 1ns",
															Start: ast.Position{
																Column: 28,
																Line:   23,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   23,
																},
																File:   "oee.flux",
																Source: "unit",
																Start: ast.Position{
																	Column: 28,
																	Line:   23,
																},
															},
														},
														Name: "unit",
													},
													Separator: nil,
													Value: &ast.DurationLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   23,
																},
																File:   "oee.flux",
																Source: "1ns",
																Start: ast.Position{
																	Column: 34,
																	Line:   23,
																},
															},
														},
														Values: []ast.Duration{ast.Duration{
															Magnitude: int64(1),
															Unit:      "ns",
														}},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   23,
															},
															File:   "oee.flux",
															Source: "columnName: \"runTime\"",
															Start: ast.Position{
																Column: 39,
																Line:   23,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   23,
																},
																File:   "oee.flux",
																Source: "columnName",
																Start: ast.Position{
																	Column: 39,
																	Line:   23,
																},
															},
														},
														Name: "columnName",
													},
													Separator: nil,
													Value: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   23,
																},
																File:   "oee.flux",
																Source: "\"runTime\"",
																Start: ast.Position{
																	Column: 51,
																	Line:   23,
																},
															},
														},
														Value: "runTime",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   23,
													},
													File:   "oee.flux",
													Source: "events.duration(unit: 1ns, columnName: \"runTime\")",
													Start: ast.Position{
														Column: 12,
														Line:   23,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   23,
														},
														File:   "oee.flux",
														Source: "events.duration",
														Start: ast.Position{
															Column: 12,
															Line:   23,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   23,
															},
															File:   "oee.flux",
															Source: "events",
															Start: ast.Position{
																Column: 12,
																Line:   23,
															},
														},
													},
													Name: "events",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   23,
															},
															File:   "oee.flux",
															Source: "duration",
															Start: ast.Position{
																Column: 19,
																Line:   23,
															},
														},
													},
													Name: "duration",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   24,
											},
											File:   "oee.flux",
											Source: "productionEvents\n        |> events.duration(unit: 1ns, columnName: \"runTime\")\n        |> filter(fn: (r) => r.state == runningState)",
											Start: ast.Position{
												Column: 20,
												Line:   22,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   24,
													},
													File:   "oee.flux",
													Source: "fn: (r) => r.state == runningState",
													Start: ast.Position{
														Column: 19,
														Line:   24,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   24,
														},
														File:   "oee.flux",
														Source: "fn: (r) => r.state == runningState",
														Start: ast.Position{
															Column: 19,
															Line:   24,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   24,
															},
															File:   "oee.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   24,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   24,
															},
															File:   "oee.flux",
															Source: "(r) => r.state == runningState",
															Start: ast.Position{
																Column: 23,
																Line:   24,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   24,
																},
																File:   "oee.flux",
																Source: "r.state == runningState",
																Start: ast.Position{
																	Column: 30,
																	Line:   24,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   24,
																	},
																	File:   "oee.flux",
																	Source: "r.state",
																	Start: ast.Position{
																		Column: 30,
																		Line:   24,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   24,
																		},
																		File:   "oee.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   24,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   24,
																		},
																		File:   "oee.flux",
																		Source: "state",
																		Start: ast.Position{
																			Column: 32,
																			Line:   24,
																		},
																	},
																},
																Name: "state",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   24,
																	},
																	File:   "oee.flux",
																	Source: "runningState",
																	Start: ast.Position{
																		Column: 41,
																		Line:   24,
																	},
																},
															},
															Name: "runningState",
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   24,
																},
																File:   "oee.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   24,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   24,
																	},
																	File:   "oee.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   24,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   24,
												},
												File:   "oee.flux",
												Source: "filter(fn: (r) => r.state == runningState)",
												Start: ast.Position{
													Column: 12,
													Line:   24,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   24,
													},
													File:   "oee.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   24,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   25,
										},
										File:   "oee.flux",
										Source: "productionEvents\n        |> events.duration(unit: 1ns, columnName: \"runTime\")\n        |> filter(fn: (r) => r.state == runningState)\n        |> sum(column: \"runTime\")",
										Start: ast.Position{
											Column: 20,
											Line:   22,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   25,
												},
												File:   "oee.flux",
												Source: "column: \"runTime\"",
												Start: ast.Position{
													Column: 16,
													Line:   25,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   25,
													},
													File:   "oee.flux",
													Source: "column: \"runTime\"",
													Start: ast.Position{
														Column: 16,
														Line:   25,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   25,
														},
														File:   "oee.flux",
														Source: "column",
														Start: ast.Position{
															Column: 16,
															Line:   25,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   25,
														},
														File:   "oee.flux",
														Source: "\"runTime\"",
														Start: ast.Position{
															Column: 24,
															Line:   25,
														},
													},
												},
												Value: "runTime",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   25,
											},
											File:   "oee.flux",
											Source: "sum(column: \"runTime\")",
											Start: ast.Position{
												Column: 12,
												Line:   25,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   25,
												},
												File:   "oee.flux",
												Source: "sum",
												Start: ast.Position{
													Column: 12,
													Line:   25,
												},
											},
										},
										Name: "sum",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 120,
										Line:   26,
									},
									File:   "oee.flux",
									Source: "productionEvents\n        |> events.duration(unit: 1ns, columnName: \"runTime\")\n        |> filter(fn: (r) => r.state == runningState)\n        |> sum(column: \"runTime\")\n        |> map(fn: (r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))}))",
									Start: ast.Position{
										Column: 20,
										Line:   22,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 119,
												Line:   26,
											},
											File:   "oee.flux",
											Source: "fn: (r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))})",
											Start: ast.Position{
												Column: 16,
												Line:   26,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 119,
													Line:   26,
												},
												File:   "oee.flux",
												Source: "fn: (r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))})",
												Start: ast.Position{
													Column: 16,
													Line:   26,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   26,
													},
													File:   "oee.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 16,
														Line:   26,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 119,
														Line:   26,
													},
													File:   "oee.flux",
													Source: "(r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))})",
													Start: ast.Position{
														Column: 20,
														Line:   26,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 119,
															Line:   26,
														},
														File:   "oee.flux",
														Source: "({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))})",
														Start: ast.Position{
															Column: 27,
															Line:   26,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 118,
																Line:   26,
															},
															File:   "oee.flux",
															Source: "{r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))}",
															Start: ast.Position{
																Column: 28,
																Line:   26,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   26,
																},
																File:   "oee.flux",
																Source: "_time: r._stop",
																Start: ast.Position{
																	Column: 36,
																	Line:   26,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   26,
																	},
																	File:   "oee.flux",
																	Source: "_time",
																	Start: ast.Position{
																		Column: 36,
																		Line:   26,
																	},
																},
															},
															Name: "_time",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   26,
																	},
																	File:   "oee.flux",
																	Source: "r._stop",
																	Start: ast.Position{
																		Column: 43,
																		Line:   26,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   26,
																		},
																		File:   "oee.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 43,
																			Line:   26,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   26,
																		},
																		File:   "oee.flux",
																		Source: "_stop",
																		Start: ast.Position{
																			Column: 45,
																			Line:   26,
																		},
																	},
																},
																Name: "_stop",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 117,
																	Line:   26,
																},
																File:   "oee.flux",
																Source: "availability: float(v: r.runTime) / float(v: int(v: plannedTime))",
																Start: ast.Position{
																	Column: 52,
																	Line:   26,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   26,
																	},
																	File:   "oee.flux",
																	Source: "availability",
																	Start: ast.Position{
																		Column: 52,
																		Line:   26,
																	},
																},
															},
															Name: "availability",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 117,
																		Line:   26,
																	},
																	File:   "oee.flux",
																	Source: "float(v: r.runTime) / float(v: int(v: plannedTime))",
																	Start: ast.Position{
																		Column: 66,
																		Line:   26,
																	},
																},
															},
															Left: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 84,
																				Line:   26,
																			},
																			File:   "oee.flux",
																			Source: "v: r.runTime",
																			Start: ast.Position{
																				Column: 72,
																				Line:   26,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 84,
																					Line:   26,
																				},
																				File:   "oee.flux",
																				Source: "v: r.runTime",
																				Start: ast.Position{
																					Column: 72,
																					Line:   26,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 73,
																						Line:   26,
																					},
																					File:   "oee.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 72,
																						Line:   26,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 84,
																						Line:   26,
																					},
																					File:   "oee.flux",
																					Source: "r.runTime",
																					Start: ast.Position{
																						Column: 75,
																						Line:   26,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 76,
																							Line:   26,
																						},
																						File:   "oee.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 75,
																							Line:   26,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 84,
																							Line:   26,
																						},
																						File:   "oee.flux",
																						Source: "runTime",
																						Start: ast.Position{
																							Column: 77,
																							Line:   26,
																						},
																					},
																				},
																				Name: "runTime",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 85,
																			Line:   26,
																		},
																		File:   "oee.flux",
																		Source: "float(v: r.runTime)",
																		Start: ast.Position{
																			Column: 66,
																			Line:   26,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 71,
																				Line:   26,
																			},
																			File:   "oee.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 66,
																				Line:   26,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
															Operator: 2,
															Right: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 116,
																				Line:   26,
																			},
																			File:   "oee.flux",
																			Source: "v: int(v: plannedTime)",
																			Start: ast.Position{
																				Column: 94,
																				Line:   26,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 116,
																					Line:   26,
																				},
																				File:   "oee.flux",
																				Source: "v: int(v: plannedTime)",
																				Start: ast.Position{
																					Column: 94,
																					Line:   26,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 95,
																						Line:   26,
																					},
																					File:   "oee.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 94,
																						Line:   26,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.CallExpression{
																			Arguments: []ast.Expression{&ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 115,
																							Line:   26,
																						},
																						File:   "oee.flux",
																						Source: "v: plannedTime",
																						Start: ast.Position{
																							Column: 101,
																							Line:   26,
																						},
																					},
																				},
																				Lbrace: nil,
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 115,
																								Line:   26,
																							},
																							File:   "oee.flux",
																							Source: "v: plannedTime",
																							Start: ast.Position{
																								Column: 101,
																								Line:   26,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 102,
																									Line:   26,
																								},
																								File:   "oee.flux",
																								Source: "v",
																								Start: ast.Position{
																									Column: 101,
																									Line:   26,
																								},
																							},
																						},
																						Name: "v",
																					},
																					Separator: nil,
																					Value: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 115,
																									Line:   26,
																								},
																								File:   "oee.flux",
																								Source: "plannedTime",
																								Start: ast.Position{
																									Column: 104,
																									Line:   26,
																								},
																							},
																						},
																						Name: "plannedTime",
																					},
																				}},
																				Rbrace: nil,
																				With:   nil,
																			}},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 116,
																						Line:   26,
																					},
																					File:   "oee.flux",
																					Source: "int(v: plannedTime)",
																					Start: ast.Position{
																						Column: 97,
																						Line:   26,
																					},
																				},
																			},
																			Callee: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 100,
																							Line:   26,
																						},
																						File:   "oee.flux",
																						Source: "int",
																						Start: ast.Position{
																							Column: 97,
																							Line:   26,
																						},
																					},
																				},
																				Name: "int",
																			},
																			Lparen: nil,
																			Rparen: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 117,
																			Line:   26,
																		},
																		File:   "oee.flux",
																		Source: "float(v: int(v: plannedTime))",
																		Start: ast.Position{
																			Column: 88,
																			Line:   26,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 93,
																				Line:   26,
																			},
																			File:   "oee.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 88,
																				Line:   26,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   26,
																},
																File:   "oee.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 29,
																	Line:   26,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   26,
														},
														File:   "oee.flux",
														Source: "r",
														Start: ast.Position{
															Column: 21,
															Line:   26,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   26,
															},
															File:   "oee.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   26,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 120,
											Line:   26,
										},
										File:   "oee.flux",
										Source: "map(fn: (r) => ({r with _time: r._stop, availability: float(v: r.runTime) / float(v: int(v: plannedTime))}))",
										Start: ast.Position{
											Column: 12,
											Line:   26,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   26,
											},
											File:   "oee.flux",
											Source: "map",
											Start: ast.Position{
												Column: 12,
												Line:   26,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   30,
								},
								File:   "oee.flux",
								Source: "totalCount = partEvents\n        |> difference(columns: [\"partCount\"], nonNegative: true)\n        |> sum(column: \"partCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")",
								Start: ast.Position{
									Column: 5,
									Line:   27,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   27,
									},
									File:   "oee.flux",
									Source: "totalCount",
									Start: ast.Position{
										Column: 5,
										Line:   27,
									},
								},
							},
							Name: "totalCount",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   27,
												},
												File:   "oee.flux",
												Source: "partEvents",
												Start: ast.Position{
													Column: 18,
													Line:   27,
												},
											},
										},
										Name: "partEvents",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   28,
											},
											File:   "oee.flux",
											Source: "partEvents\n        |> difference(columns: [\"partCount\"], nonNegative: true)",
											Start: ast.Position{
												Column: 18,
												Line:   27,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   28,
													},
													File:   "oee.flux",
													Source: "columns: [\"partCount\"], nonNegative: true",
													Start: ast.Position{
														Column: 23,
														Line:   28,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   28,
														},
														File:   "oee.flux",
														Source: "columns: [\"partCount\"]",
														Start: ast.Position{
															Column: 23,
															Line:   28,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   28,
															},
															File:   "oee.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 23,
																Line:   28,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   28,
															},
															File:   "oee.flux",
															Source: "[\"partCount\"]",
															Start: ast.Position{
																Column: 32,
																Line:   28,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   28,
																},
																File:   "oee.flux",
																Source: "\"partCount\"",
																Start: ast.Position{
																	Column: 33,
																	Line:   28,
																},
															},
														},
														Value: "partCount",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   28,
														},
														File:   "oee.flux",
														Source: "nonNegative: true",
														Start: ast.Position{
															Column: 47,
															Line:   28,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   28,
															},
															File:   "oee.flux",
															Source: "nonNegative",
															Start: ast.Position{
																Column: 47,
																Line:   28,
															},
														},
													},
													Name: "nonNegative",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   28,
															},
															File:   "oee.flux",
															Source: "true",
															Start: ast.Position{
																Column: 60,
																Line:   28,
															},
														},
													},
													Name: "true",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   28,
												},
												File:   "oee.flux",
												Source: "difference(columns: [\"partCount\"], nonNegative: true)",
												Start: ast.Position{
													Column: 12,
													Line:   28,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   28,
													},
													File:   "oee.flux",
													Source: "difference",
													Start: ast.Position{
														Column: 12,
														Line:   28,
													},
												},
											},
											Name: "difference",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   29,
										},
										File:   "oee.flux",
										Source: "partEvents\n        |> difference(columns: [\"partCount\"], nonNegative: true)\n        |> sum(column: \"partCount\")",
										Start: ast.Position{
											Column: 18,
											Line:   27,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   29,
												},
												File:   "oee.flux",
												Source: "column: \"partCount\"",
												Start: ast.Position{
													Column: 16,
													Line:   29,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   29,
													},
													File:   "oee.flux",
													Source: "column: \"partCount\"",
													Start: ast.Position{
														Column: 16,
														Line:   29,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   29,
														},
														File:   "oee.flux",
														Source: "column",
														Start: ast.Position{
															Column: 16,
															Line:   29,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   29,
														},
														File:   "oee.flux",
														Source: "\"partCount\"",
														Start: ast.Position{
															Column: 24,
															Line:   29,
														},
													},
												},
												Value: "partCount",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   29,
											},
											File:   "oee.flux",
											Source: "sum(column: \"partCount\")",
											Start: ast.Position{
												Column: 12,
												Line:   29,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   29,
												},
												File:   "oee.flux",
												Source: "sum",
												Start: ast.Position{
													Column: 12,
													Line:   29,
												},
											},
										},
										Name: "sum",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   30,
									},
									File:   "oee.flux",
									Source: "partEvents\n        |> difference(columns: [\"partCount\"], nonNegative: true)\n        |> sum(column: \"partCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")",
									Start: ast.Position{
										Column: 18,
										Line:   27,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   30,
											},
											File:   "oee.flux",
											Source: "column: \"_stop\", as: \"_time\"",
											Start: ast.Position{
												Column: 22,
												Line:   30,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   30,
												},
												File:   "oee.flux",
												Source: "column: \"_stop\"",
												Start: ast.Position{
													Column: 22,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   30,
													},
													File:   "oee.flux",
													Source: "column",
													Start: ast.Position{
														Column: 22,
														Line:   30,
													},
												},
											},
											Name: "column",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   30,
													},
													File:   "oee.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 30,
														Line:   30,
													},
												},
											},
											Value: "_stop",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   30,
												},
												File:   "oee.flux",
												Source: "as: \"_time\"",
												Start: ast.Position{
													Column: 39,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   30,
													},
													File:   "oee.flux",
													Source: "as",
													Start: ast.Position{
														Column: 39,
														Line:   30,
													},
												},
											},
											Name: "as",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   30,
													},
													File:   "oee.flux",
													Source: "\"_time\"",
													Start: ast.Position{
														Column: 43,
														Line:   30,
													},
												},
											},
											Value: "_time",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   30,
										},
										File:   "oee.flux",
										Source: "duplicate(column: \"_stop\", as: \"_time\")",
										Start: ast.Position{
											Column: 12,
											Line:   30,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   30,
											},
											File:   "oee.flux",
											Source: "duplicate",
											Start: ast.Position{
												Column: 12,
												Line:   30,
											},
										},
									},
									Name: "duplicate",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   34,
								},
								File:   "oee.flux",
								Source: "badCount = partEvents\n        |> difference(columns: [\"badCount\"], nonNegative: true)\n        |> sum(column: \"badCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")",
								Start: ast.Position{
									Column: 5,
									Line:   31,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   31,
									},
									File:   "oee.flux",
									Source: "badCount",
									Start: ast.Position{
										Column: 5,
										Line:   31,
									},
								},
							},
							Name: "badCount",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   31,
												},
												File:   "oee.flux",
												Source: "partEvents",
												Start: ast.Position{
													Column: 16,
													Line:   31,
												},
											},
										},
										Name: "partEvents",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   32,
											},
											File:   "oee.flux",
											Source: "partEvents\n        |> difference(columns: [\"badCount\"], nonNegative: true)",
											Start: ast.Position{
												Column: 16,
												Line:   31,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   32,
													},
													File:   "oee.flux",
													Source: "columns: [\"badCount\"], nonNegative: true",
													Start: ast.Position{
														Column: 23,
														Line:   32,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   32,
														},
														File:   "oee.flux",
														Source: "columns: [\"badCount\"]",
														Start: ast.Position{
															Column: 23,
															Line:   32,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   32,
															},
															File:   "oee.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 23,
																Line:   32,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   32,
															},
															File:   "oee.flux",
															Source: "[\"badCount\"]",
															Start: ast.Position{
																Column: 32,
																Line:   32,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 43,
																	Line:   32,
																},
																File:   "oee.flux",
																Source: "\"badCount\"",
																Start: ast.Position{
																	Column: 33,
																	Line:   32,
																},
															},
														},
														Value: "badCount",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   32,
														},
														File:   "oee.flux",
														Source: "nonNegative: true",
														Start: ast.Position{
															Column: 46,
															Line:   32,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 57,
																Line:   32,
															},
															File:   "oee.flux",
															Source: "nonNegative",
															Start: ast.Position{
																Column: 46,
																Line:   32,
															},
														},
													},
													Name: "nonNegative",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   32,
															},
															File:   "oee.flux",
															Source: "true",
															Start: ast.Position{
																Column: 59,
																Line:   32,
															},
														},
													},
													Name: "true",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   32,
												},
												File:   "oee.flux",
												Source: "difference(columns: [\"badCount\"], nonNegative: true)",
												Start: ast.Position{
													Column: 12,
													Line:   32,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   32,
													},
													File:   "oee.flux",
													Source: "difference",
													Start: ast.Position{
														Column: 12,
														Line:   32,
													},
												},
											},
											Name: "difference",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   33,
										},
										File:   "oee.flux",
										Source: "partEvents\n        |> difference(columns: [\"badCount\"], nonNegative: true)\n        |> sum(column: \"badCount\")",
										Start: ast.Position{
											Column: 16,
											Line:   31,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   33,
												},
												File:   "oee.flux",
												Source: "column: \"badCount\"",
												Start: ast.Position{
													Column: 16,
													Line:   33,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   33,
													},
													File:   "oee.flux",
													Source: "column: \"badCount\"",
													Start: ast.Position{
														Column: 16,
														Line:   33,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   33,
														},
														File:   "oee.flux",
														Source: "column",
														Start: ast.Position{
															Column: 16,
															Line:   33,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   33,
														},
														File:   "oee.flux",
														Source: "\"badCount\"",
														Start: ast.Position{
															Column: 24,
															Line:   33,
														},
													},
												},
												Value: "badCount",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   33,
											},
											File:   "oee.flux",
											Source: "sum(column: \"badCount\")",
											Start: ast.Position{
												Column: 12,
												Line:   33,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   33,
												},
												File:   "oee.flux",
												Source: "sum",
												Start: ast.Position{
													Column: 12,
													Line:   33,
												},
											},
										},
										Name: "sum",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   34,
									},
									File:   "oee.flux",
									Source: "partEvents\n        |> difference(columns: [\"badCount\"], nonNegative: true)\n        |> sum(column: \"badCount\")\n        |> duplicate(column: \"_stop\", as: \"_time\")",
									Start: ast.Position{
										Column: 16,
										Line:   31,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   34,
											},
											File:   "oee.flux",
											Source: "column: \"_stop\", as: \"_time\"",
											Start: ast.Position{
												Column: 22,
												Line:   34,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   34,
												},
												File:   "oee.flux",
												Source: "column: \"_stop\"",
												Start: ast.Position{
													Column: 22,
													Line:   34,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   34,
													},
													File:   "oee.flux",
													Source: "column",
													Start: ast.Position{
														Column: 22,
														Line:   34,
													},
												},
											},
											Name: "column",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   34,
													},
													File:   "oee.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 30,
														Line:   34,
													},
												},
											},
											Value: "_stop",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   34,
												},
												File:   "oee.flux",
												Source: "as: \"_time\"",
												Start: ast.Position{
													Column: 39,
													Line:   34,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   34,
													},
													File:   "oee.flux",
													Source: "as",
													Start: ast.Position{
														Column: 39,
														Line:   34,
													},
												},
											},
											Name: "as",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   34,
													},
													File:   "oee.flux",
													Source: "\"_time\"",
													Start: ast.Position{
														Column: 43,
														Line:   34,
													},
												},
											},
											Value: "_time",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   34,
										},
										File:   "oee.flux",
										Source: "duplicate(column: \"_stop\", as: \"_time\")",
										Start: ast.Position{
											Column: 12,
											Line:   34,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   34,
											},
											File:   "oee.flux",
											Source: "duplicate",
											Start: ast.Position{
												Column: 12,
												Line:   34,
											},
										},
									},
									Name: "duplicate",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   41,
								},
								File:   "oee.flux",
								Source: "performance = experimental.join(\n        left: availability,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        }),\n    )",
								Start: ast.Position{
									Column: 5,
									Line:   35,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   35,
									},
									File:   "oee.flux",
									Source: "performance",
									Start: ast.Position{
										Column: 5,
										Line:   35,
									},
								},
							},
							Name: "performance",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   40,
										},
										File:   "oee.flux",
										Source: "left: availability,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        })",
										Start: ast.Position{
											Column: 9,
											Line:   36,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   36,
											},
											File:   "oee.flux",
											Source: "left: availability",
											Start: ast.Position{
												Column: 9,
												Line:   36,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   36,
												},
												File:   "oee.flux",
												Source: "left",
												Start: ast.Position{
													Column: 9,
													Line:   36,
												},
											},
										},
										Name: "left",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   36,
												},
												File:   "oee.flux",
												Source: "availability",
												Start: ast.Position{
													Column: 15,
													Line:   36,
												},
											},
										},
										Name: "availability",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   37,
											},
											File:   "oee.flux",
											Source: "right: totalCount",
											Start: ast.Position{
												Column: 9,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   37,
												},
												File:   "oee.flux",
												Source: "right",
												Start: ast.Position{
													Column: 9,
													Line:   37,
												},
											},
										},
										Name: "right",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   37,
												},
												File:   "oee.flux",
												Source: "totalCount",
												Start: ast.Position{
													Column: 16,
													Line:   37,
												},
											},
										},
										Name: "totalCount",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   40,
											},
											File:   "oee.flux",
											Source: "fn: (left, right) => ({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        })",
											Start: ast.Position{
												Column: 9,
												Line:   38,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   38,
												},
												File:   "oee.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 9,
													Line:   38,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   40,
												},
												File:   "oee.flux",
												Source: "(left, right) => ({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        })",
												Start: ast.Position{
													Column: 13,
													Line:   38,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   40,
													},
													File:   "oee.flux",
													Source: "({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        })",
													Start: ast.Position{
														Column: 30,
														Line:   38,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   40,
														},
														File:   "oee.flux",
														Source: "{left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        }",
														Start: ast.Position{
															Column: 31,
															Line:   38,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 111,
																Line:   39,
															},
															File:   "oee.flux",
															Source: "performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime)",
															Start: ast.Position{
																Column: 13,
																Line:   39,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   39,
																},
																File:   "oee.flux",
																Source: "performance",
																Start: ast.Position{
																	Column: 13,
																	Line:   39,
																},
															},
														},
														Name: "performance",
													},
													Separator: nil,
													Value: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 111,
																	Line:   39,
																},
																File:   "oee.flux",
																Source: "float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime)",
																Start: ast.Position{
																	Column: 26,
																	Line:   39,
																},
															},
														},
														Left: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 86,
																		Line:   39,
																	},
																	File:   "oee.flux",
																	Source: "float(v: right.partCount) * float(v: int(v: idealCycleTime))",
																	Start: ast.Position{
																		Column: 26,
																		Line:   39,
																	},
																},
															},
															Left: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 50,
																				Line:   39,
																			},
																			File:   "oee.flux",
																			Source: "v: right.partCount",
																			Start: ast.Position{
																				Column: 32,
																				Line:   39,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 50,
																					Line:   39,
																				},
																				File:   "oee.flux",
																				Source: "v: right.partCount",
																				Start: ast.Position{
																					Column: 32,
																					Line:   39,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 33,
																						Line:   39,
																					},
																					File:   "oee.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 32,
																						Line:   39,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 50,
																						Line:   39,
																					},
																					File:   "oee.flux",
																					Source: "right.partCount",
																					Start: ast.Position{
																						Column: 35,
																						Line:   39,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 40,
																							Line:   39,
																						},
																						File:   "oee.flux",
																						Source: "right",
																						Start: ast.Position{
																							Column: 35,
																							Line:   39,
																						},
																					},
																				},
																				Name: "right",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 50,
																							Line:   39,
																						},
																						File:   "oee.flux",
																						Source: "partCount",
																						Start: ast.Position{
																							Column: 41,
																							Line:   39,
																						},
																					},
																				},
																				Name: "partCount",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 51,
																			Line:   39,
																		},
																		File:   "oee.flux",
																		Source: "float(v: right.partCount)",
																		Start: ast.Position{
																			Column: 26,
																			Line:   39,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 31,
																				Line:   39,
																			},
																			File:   "oee.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 26,
																				Line:   39,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
															Operator: 1,
															Right: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 85,
																				Line:   39,
																			},
																			File:   "oee.flux",
																			Source: "v: int(v: idealCycleTime)",
																			Start: ast.Position{
																				Column: 60,
																				Line:   39,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 85,
																					Line:   39,
																				},
																				File:   "oee.flux",
																				Source: "v: int(v: idealCycleTime)",
																				Start: ast.Position{
																					Column: 60,
																					Line:   39,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 61,
																						Line:   39,
																					},
																					File:   "oee.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 60,
																						Line:   39,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.CallExpression{
																			Arguments: []ast.Expression{&ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 84,
																							Line:   39,
																						},
																						File:   "oee.flux",
																						Source: "v: idealCycleTime",
																						Start: ast.Position{
																							Column: 67,
																							Line:   39,
																						},
																					},
																				},
																				Lbrace: nil,
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 84,
																								Line:   39,
																							},
																							File:   "oee.flux",
																							Source: "v: idealCycleTime",
																							Start: ast.Position{
																								Column: 67,
																								Line:   39,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 68,
																									Line:   39,
																								},
																								File:   "oee.flux",
																								Source: "v",
																								Start: ast.Position{
																									Column: 67,
																									Line:   39,
																								},
																							},
																						},
																						Name: "v",
																					},
																					Separator: nil,
																					Value: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 84,
																									Line:   39,
																								},
																								File:   "oee.flux",
																								Source: "idealCycleTime",
																								Start: ast.Position{
																									Column: 70,
																									Line:   39,
																								},
																							},
																						},
																						Name: "idealCycleTime",
																					},
																				}},
																				Rbrace: nil,
																				With:   nil,
																			}},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 85,
																						Line:   39,
																					},
																					File:   "oee.flux",
																					Source: "int(v: idealCycleTime)",
																					Start: ast.Position{
																						Column: 63,
																						Line:   39,
																					},
																				},
																			},
																			Callee: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 66,
																							Line:   39,
																						},
																						File:   "oee.flux",
																						Source: "int",
																						Start: ast.Position{
																							Column: 63,
																							Line:   39,
																						},
																					},
																				},
																				Name: "int",
																			},
																			Lparen: nil,
																			Rparen: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 86,
																			Line:   39,
																		},
																		File:   "oee.flux",
																		Source: "float(v: int(v: idealCycleTime))",
																		Start: ast.Position{
																			Column: 54,
																			Line:   39,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   39,
																			},
																			File:   "oee.flux",
																			Source: "float",
																			Start: ast.Position{
																				Column: 54,
																				Line:   39,
																			},
																		},
																	},
																	Name: "float",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
														Operator: 2,
														Right: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 110,
																			Line:   39,
																		},
																		File:   "oee.flux",
																		Source: "v: left.runTime",
																		Start: ast.Position{
																			Column: 95,
																			Line:   39,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 110,
																				Line:   39,
																			},
																			File:   "oee.flux",
																			Source: "v: left.runTime",
																			Start: ast.Position{
																				Column: 95,
																				Line:   39,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 96,
																					Line:   39,
																				},
																				File:   "oee.flux",
																				Source: "v",
																				Start: ast.Position{
																					Column: 95,
																					Line:   39,
																				},
																			},
																		},
																		Name: "v",
																	},
																	Separator: nil,
																	Value: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 110,
																					Line:   39,
																				},
																				File:   "oee.flux",
																				Source: "left.runTime",
																				Start: ast.Position{
																					Column: 98,
																					Line:   39,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 102,
																						Line:   39,
																					},
																					File:   "oee.flux",
																					Source: "left",
																					Start: ast.Position{
																						Column: 98,
																						Line:   39,
																					},
																				},
																			},
																			Name: "left",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 110,
																						Line:   39,
																					},
																					File:   "oee.flux",
																					Source: "runTime",
																					Start: ast.Position{
																						Column: 103,
																						Line:   39,
																					},
																				},
																			},
																			Name: "runTime",
																		},
																		Rbrack: nil,
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 111,
																		Line:   39,
																	},
																	File:   "oee.flux",
																	Source: "float(v: left.runTime)",
																	Start: ast.Position{
																		Column: 89,
																		Line:   39,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 94,
																			Line:   39,
																		},
																		File:   "oee.flux",
																		Source: "float",
																		Start: ast.Position{
																			Column: 89,
																			Line:   39,
																		},
																	},
																},
																Name: "float",
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   38,
															},
															File:   "oee.flux",
															Source: "left",
															Start: ast.Position{
																Column: 32,
																Line:   38,
															},
														},
													},
													Name: "left",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   38,
													},
													File:   "oee.flux",
													Source: "left",
													Start: ast.Position{
														Column: 14,
														Line:   38,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   38,
														},
														File:   "oee.flux",
														Source: "left",
														Start: ast.Position{
															Column: 14,
															Line:   38,
														},
													},
												},
												Name: "left",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   38,
													},
													File:   "oee.flux",
													Source: "right",
													Start: ast.Position{
														Column: 20,
														Line:   38,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   38,
														},
														File:   "oee.flux",
														Source: "right",
														Start: ast.Position{
															Column: 20,
															Line:   38,
														},
													},
												},
												Name: "right",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   41,
									},
									File:   "oee.flux",
									Source: "experimental.join(\n        left: availability,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            performance: float(v: right.partCount) * float(v: int(v: idealCycleTime)) / float(v: left.runTime),\n        }),\n    )",
									Start: ast.Position{
										Column: 19,
										Line:   35,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   35,
										},
										File:   "oee.flux",
										Source: "experimental.join",
										Start: ast.Position{
											Column: 19,
											Line:   35,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   35,
											},
											File:   "oee.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 19,
												Line:   35,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   35,
											},
											File:   "oee.flux",
											Source: "join",
											Start: ast.Position{
												Column: 32,
												Line:   35,
											},
										},
									},
									Name: "join",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   48,
								},
								File:   "oee.flux",
								Source: "quality = experimental.join(\n        left: badCount,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        }),\n    )",
								Start: ast.Position{
									Column: 5,
									Line:   42,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   42,
									},
									File:   "oee.flux",
									Source: "quality",
									Start: ast.Position{
										Column: 5,
										Line:   42,
									},
								},
							},
							Name: "quality",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   47,
										},
										File:   "oee.flux",
										Source: "left: badCount,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        })",
										Start: ast.Position{
											Column: 9,
											Line:   43,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   43,
											},
											File:   "oee.flux",
											Source: "left: badCount",
											Start: ast.Position{
												Column: 9,
												Line:   43,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   43,
												},
												File:   "oee.flux",
												Source: "left",
												Start: ast.Position{
													Column: 9,
													Line:   43,
												},
											},
										},
										Name: "left",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   43,
												},
												File:   "oee.flux",
												Source: "badCount",
												Start: ast.Position{
													Column: 15,
													Line:   43,
												},
											},
										},
										Name: "badCount",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   44,
											},
											File:   "oee.flux",
											Source: "right: totalCount",
											Start: ast.Position{
												Column: 9,
												Line:   44,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   44,
												},
												File:   "oee.flux",
												Source: "right",
												Start: ast.Position{
													Column: 9,
													Line:   44,
												},
											},
										},
										Name: "right",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   44,
												},
												File:   "oee.flux",
												Source: "totalCount",
												Start: ast.Position{
													Column: 16,
													Line:   44,
												},
											},
										},
										Name: "totalCount",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   47,
											},
											File:   "oee.flux",
											Source: "fn: (left, right) => ({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        })",
											Start: ast.Position{
												Column: 9,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   45,
												},
												File:   "oee.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 9,
													Line:   45,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   47,
												},
												File:   "oee.flux",
												Source: "(left, right) => ({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        })",
												Start: ast.Position{
													Column: 13,
													Line:   45,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   47,
													},
													File:   "oee.flux",
													Source: "({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        })",
													Start: ast.Position{
														Column: 30,
														Line:   45,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   47,
														},
														File:   "oee.flux",
														Source: "{left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        }",
														Start: ast.Position{
															Column: 31,
															Line:   45,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 103,
																Line:   46,
															},
															File:   "oee.flux",
															Source: "quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount)",
															Start: ast.Position{
																Column: 13,
																Line:   46,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   46,
																},
																File:   "oee.flux",
																Source: "quality",
																Start: ast.Position{
																	Column: 13,
																	Line:   46,
																},
															},
														},
														Name: "quality",
													},
													Separator: nil,
													Value: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 103,
																	Line:   46,
																},
																File:   "oee.flux",
																Source: "(float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount)",
																Start: ast.Position{
																	Column: 22,
																	Line:   46,
																},
															},
														},
														Left: &ast.ParenExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   46,
																	},
																	File:   "oee.flux",
																	Source: "(float(v: right.partCount) - float(v: left.badCount))",
																	Start: ast.Position{
																		Column: 22,
																		Line:   46,
																	},
																},
															},
															Expression: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 74,
																			Line:   46,
																		},
																		File:   "oee.flux",
																		Source: "float(v: right.partCount) - float(v: left.badCount)",
																		Start: ast.Position{
																			Column: 23,
																			Line:   46,
																		},
																	},
																},
																Left: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 47,
																					Line:   46,
																				},
																				File:   "oee.flux",
																				Source: "v: right.partCount",
																				Start: ast.Position{
																					Column: 29,
																					Line:   46,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   46,
																					},
																					File:   "oee.flux",
																					Source: "v: right.partCount",
																					Start: ast.Position{
																						Column: 29,
																						Line:   46,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 30,
																							Line:   46,
																						},
																						File:   "oee.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 29,
																							Line:   46,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 47,
																							Line:   46,
																						},
																						File:   "oee.flux",
																						Source: "right.partCount",
																						Start: ast.Position{
																							Column: 32,
																							Line:   46,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 37,
																								Line:   46,
																							},
																							File:   "oee.flux",
																							Source: "right",
																							Start: ast.Position{
																								Column: 32,
																								Line:   46,
																							},
																						},
																					},
																					Name: "right",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 47,
																								Line:   46,
																							},
																							File:   "oee.flux",
																							Source: "partCount",
																							Start: ast.Position{
																								Column: 38,
																								Line:   46,
																							},
																						},
																					},
																					Name: "partCount",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   46,
																			},
																			File:   "oee.flux",
																			Source: "float(v: right.partCount)",
																			Start: ast.Position{
																				Column: 23,
																				Line:   46,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   46,
																				},
																				File:   "oee.flux",
																				Source: "float",
																				Start: ast.Position{
																					Column: 23,
																					Line:   46,
																				},
																			},
																		},
																		Name: "float",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
																Operator: 6,
																Right: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 73,
																					Line:   46,
																				},
																				File:   "oee.flux",
																				Source: "v: left.badCount",
																				Start: ast.Position{
																					Column: 57,
																					Line:   46,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 73,
																						Line:   46,
																					},
																					File:   "oee.flux",
																					Source: "v: left.badCount",
																					Start: ast.Position{
																						Column: 57,
																						Line:   46,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 58,
																							Line:   46,
																						},
																						File:   "oee.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 57,
																							Line:   46,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 73,
																							Line:   46,
																						},
																						File:   "oee.flux",
																						Source: "left.badCount",
																						Start: ast.Position{
																							Column: 60,
																							Line:   46,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 64,
																								Line:   46,
																							},
																							File:   "oee.flux",
																							Source: "left",
																							Start: ast.Position{
																								Column: 60,
																								Line:   46,
																							},
																						},
																					},
																					Name: "left",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 73,
																								Line:   46,
																							},
																							File:   "oee.flux",
																							Source: "badCount",
																							Start: ast.Position{
																								Column: 65,
																								Line:   46,
																							},
																						},
																					},
																					Name: "badCount",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 74,
																				Line:   46,
																			},
																			File:   "oee.flux",
																			Source: "float(v: left.badCount)",
																			Start: ast.Position{
																				Column: 51,
																				Line:   46,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 56,
																					Line:   46,
																				},
																				File:   "oee.flux",
																				Source: "float",
																				Start: ast.Position{
																					Column: 51,
																					Line:   46,
																				},
																			},
																		},
																		Name: "float",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															},
															Lparen: nil,
															Rparen: nil,
														},
														Operator: 2,
														Right: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 102,
																			Line:   46,
																		},
																		File:   "oee.flux",
																		Source: "v: right.partCount",
																		Start: ast.Position{
																			Column: 84,
																			Line:   46,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 102,
																				Line:   46,
																			},
																			File:   "oee.flux",
																			Source: "v: right.partCount",
																			Start: ast.Position{
																				Column: 84,
																				Line:   46,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 85,
																					Line:   46,
																				},
																				File:   "oee.flux",
																				Source: "v",
																				Start: ast.Position{
																					Column: 84,
																					Line:   46,
																				},
																			},
																		},
																		Name: "v",
																	},
																	Separator: nil,
																	Value: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 102,
																					Line:   46,
																				},
																				File:   "oee.flux",
																				Source: "right.partCount",
																				Start: ast.Position{
																					Column: 87,
																					Line:   46,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 92,
																						Line:   46,
																					},
																					File:   "oee.flux",
																					Source: "right",
																					Start: ast.Position{
																						Column: 87,
																						Line:   46,
																					},
																				},
																			},
																			Name: "right",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 102,
																						Line:   46,
																					},
																					File:   "oee.flux",
																					Source: "partCount",
																					Start: ast.Position{
																						Column: 93,
																						Line:   46,
																					},
																				},
																			},
																			Name: "partCount",
																		},
																		Rbrack: nil,
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 103,
																		Line:   46,
																	},
																	File:   "oee.flux",
																	Source: "float(v: right.partCount)",
																	Start: ast.Position{
																		Column: 78,
																		Line:   46,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 83,
																			Line:   46,
																		},
																		File:   "oee.flux",
																		Source: "float",
																		Start: ast.Position{
																			Column: 78,
																			Line:   46,
																		},
																	},
																},
																Name: "float",
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   45,
															},
															File:   "oee.flux",
															Source: "left",
															Start: ast.Position{
																Column: 32,
																Line:   45,
															},
														},
													},
													Name: "left",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   45,
													},
													File:   "oee.flux",
													Source: "left",
													Start: ast.Position{
														Column: 14,
														Line:   45,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   45,
														},
														File:   "oee.flux",
														Source: "left",
														Start: ast.Position{
															Column: 14,
															Line:   45,
														},
													},
												},
												Name: "left",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   45,
													},
													File:   "oee.flux",
													Source: "right",
													Start: ast.Position{
														Column: 20,
														Line:   45,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   45,
														},
														File:   "oee.flux",
														Source: "right",
														Start: ast.Position{
															Column: 20,
															Line:   45,
														},
													},
												},
												Name: "right",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   48,
									},
									File:   "oee.flux",
									Source: "experimental.join(\n        left: badCount,\n        right: totalCount,\n        fn: (left, right) => ({left with\n            quality: (float(v: right.partCount) - float(v: left.badCount)) / float(v: right.partCount),\n        }),\n    )",
									Start: ast.Position{
										Column: 15,
										Line:   42,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   42,
										},
										File:   "oee.flux",
										Source: "experimental.join",
										Start: ast.Position{
											Column: 15,
											Line:   42,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   42,
											},
											File:   "oee.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 15,
												Line:   42,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   42,
											},
											File:   "oee.flux",
											Source: "join",
											Start: ast.Position{
												Column: 28,
												Line:   42,
											},
										},
									},
									Name: "join",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   56,
										},
										File:   "oee.flux",
										Source: "left: performance,\n        right: quality,\n        fn: (left, right) => ({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        })",
										Start: ast.Position{
											Column: 9,
											Line:   51,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   51,
											},
											File:   "oee.flux",
											Source: "left: performance",
											Start: ast.Position{
												Column: 9,
												Line:   51,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   51,
												},
												File:   "oee.flux",
												Source: "left",
												Start: ast.Position{
													Column: 9,
													Line:   51,
												},
											},
										},
										Name: "left",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   51,
												},
												File:   "oee.flux",
												Source: "performance",
												Start: ast.Position{
													Column: 15,
													Line:   51,
												},
											},
										},
										Name: "performance",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   52,
											},
											File:   "oee.flux",
											Source: "right: quality",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   52,
												},
												File:   "oee.flux",
												Source: "right",
												Start: ast.Position{
													Column: 9,
													Line:   52,
												},
											},
										},
										Name: "right",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   52,
												},
												File:   "oee.flux",
												Source: "quality",
												Start: ast.Position{
													Column: 16,
													Line:   52,
												},
											},
										},
										Name: "quality",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   56,
											},
											File:   "oee.flux",
											Source: "fn: (left, right) => ({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        })",
											Start: ast.Position{
												Column: 9,
												Line:   53,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   53,
												},
												File:   "oee.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   56,
												},
												File:   "oee.flux",
												Source: "(left, right) => ({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        })",
												Start: ast.Position{
													Column: 13,
													Line:   53,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   56,
													},
													File:   "oee.flux",
													Source: "({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        })",
													Start: ast.Position{
														Column: 30,
														Line:   53,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   56,
														},
														File:   "oee.flux",
														Source: "{left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        }",
														Start: ast.Position{
															Column: 31,
															Line:   53,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   54,
															},
															File:   "oee.flux",
															Source: "quality: right.quality",
															Start: ast.Position{
																Column: 13,
																Line:   54,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   54,
																},
																File:   "oee.flux",
																Source: "quality",
																Start: ast.Position{
																	Column: 13,
																	Line:   54,
																},
															},
														},
														Name: "quality",
													},
													Separator: nil,
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   54,
																},
																File:   "oee.flux",
																Source: "right.quality",
																Start: ast.Position{
																	Column: 22,
																	Line:   54,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   54,
																	},
																	File:   "oee.flux",
																	Source: "right",
																	Start: ast.Position{
																		Column: 22,
																		Line:   54,
																	},
																},
															},
															Name: "right",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   54,
																	},
																	File:   "oee.flux",
																	Source: "quality",
																	Start: ast.Position{
																		Column: 28,
																		Line:   54,
																	},
																},
															},
															Name: "quality",
														},
														Rbrack: nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 70,
																Line:   55,
															},
															File:   "oee.flux",
															Source: "oee: left.availability * left.performance * right.quality",
															Start: ast.Position{
																Column: 13,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   55,
																},
																File:   "oee.flux",
																Source: "oee",
																Start: ast.Position{
																	Column: 13,
																	Line:   55,
																},
															},
														},
														Name: "oee",
													},
													Separator: nil,
													Value: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 70,
																	Line:   55,
																},
																File:   "oee.flux",
																Source: "left.availability * left.performance * right.quality",
																Start: ast.Position{
																	Column: 18,
																	Line:   55,
																},
															},
														},
														Left: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   55,
																	},
																	File:   "oee.flux",
																	Source: "left.availability * left.performance",
																	Start: ast.Position{
																		Column: 18,
																		Line:   55,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 35,
																			Line:   55,
																		},
																		File:   "oee.flux",
																		Source: "left.availability",
																		Start: ast.Position{
																			Column: 18,
																			Line:   55,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 22,
																				Line:   55,
																			},
																			File:   "oee.flux",
																			Source: "left",
																			Start: ast.Position{
																				Column: 18,
																				Line:   55,
																			},
																		},
																	},
																	Name: "left",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   55,
																			},
																			File:   "oee.flux",
																			Source: "availability",
																			Start: ast.Position{
																				Column: 23,
																				Line:   55,
																			},
																		},
																	},
																	Name: "availability",
																},
																Rbrack: nil,
															},
															Operator: 1,
															Right: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   55,
																		},
																		File:   "oee.flux",
																		Source: "left.performance",
																		Start: ast.Position{
																			Column: 38,
																			Line:   55,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 42,
																				Line:   55,
																			},
																			File:   "oee.flux",
																			Source: "left",
																			Start: ast.Position{
																				Column: 38,
																				Line:   55,
																			},
																		},
																	},
																	Name: "left",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 54,
																				Line:   55,
																			},
																			File:   "oee.flux",
																			Source: "performance",
																			Start: ast.Position{
																				Column: 43,
																				Line:   55,
																			},
																		},
																	},
																	Name: "performance",
																},
																Rbrack: nil,
															},
														},
														Operator: 1,
														Right: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 70,
																		Line:   55,
																	},
																	File:   "oee.flux",
																	Source: "right.quality",
																	Start: ast.Position{
																		Column: 57,
																		Line:   55,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 62,
																			Line:   55,
																		},
																		File:   "oee.flux",
																		Source: "right",
																		Start: ast.Position{
																			Column: 57,
																			Line:   55,
																		},
																	},
																},
																Name: "right",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 70,
																			Line:   55,
																		},
																		File:   "oee.flux",
																		Source: "quality",
																		Start: ast.Position{
																			Column: 63,
																			Line:   55,
																		},
																	},
																},
																Name: "quality",
															},
															Rbrack: nil,
														},
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   53,
															},
															File:   "oee.flux",
															Source: "left",
															Start: ast.Position{
																Column: 32,
																Line:   53,
															},
														},
													},
													Name: "left",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   53,
													},
													File:   "oee.flux",
													Source: "left",
													Start: ast.Position{
														Column: 14,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   53,
														},
														File:   "oee.flux",
														Source: "left",
														Start: ast.Position{
															Column: 14,
															Line:   53,
														},
													},
												},
												Name: "left",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   53,
													},
													File:   "oee.flux",
													Source: "right",
													Start: ast.Position{
														Column: 20,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   53,
														},
														File:   "oee.flux",
														Source: "right",
														Start: ast.Position{
															Column: 20,
															Line:   53,
														},
													},
												},
												Name: "right",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   57,
									},
									File:   "oee.flux",
									Source: "experimental.join(\n        left: performance,\n        right: quality,\n        fn: (left, right) => ({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        }),\n    )",
									Start: ast.Position{
										Column: 12,
										Line:   50,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   50,
										},
										File:   "oee.flux",
										Source: "experimental.join",
										Start: ast.Position{
											Column: 12,
											Line:   50,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   50,
											},
											File:   "oee.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 12,
												Line:   50,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   50,
											},
											File:   "oee.flux",
											Source: "join",
											Start: ast.Position{
												Column: 25,
												Line:   50,
											},
										},
									},
									Name: "join",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   57,
								},
								File:   "oee.flux",
								Source: "return experimental.join(\n        left: performance,\n        right: quality,\n        fn: (left, right) => ({left with\n            quality: right.quality,\n            oee: left.availability * left.performance * right.quality,\n        }),\n    )",
								Start: ast.Position{
									Column: 5,
									Line:   50,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   16,
							},
							File:   "oee.flux",
							Source: "productionEvents",
							Start: ast.Position{
								Column: 9,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   16,
								},
								File:   "oee.flux",
								Source: "productionEvents",
								Start: ast.Position{
									Column: 9,
									Line:   16,
								},
							},
						},
						Name: "productionEvents",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   17,
							},
							File:   "oee.flux",
							Source: "partEvents",
							Start: ast.Position{
								Column: 9,
								Line:   17,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   17,
								},
								File:   "oee.flux",
								Source: "partEvents",
								Start: ast.Position{
									Column: 9,
									Line:   17,
								},
							},
						},
						Name: "partEvents",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   18,
							},
							File:   "oee.flux",
							Source: "runningState",
							Start: ast.Position{
								Column: 9,
								Line:   18,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   18,
								},
								File:   "oee.flux",
								Source: "runningState",
								Start: ast.Position{
									Column: 9,
									Line:   18,
								},
							},
						},
						Name: "runningState",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   19,
							},
							File:   "oee.flux",
							Source: "plannedTime",
							Start: ast.Position{
								Column: 9,
								Line:   19,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   19,
								},
								File:   "oee.flux",
								Source: "plannedTime",
								Start: ast.Position{
									Column: 9,
									Line:   19,
								},
							},
						},
						Name: "plannedTime",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   20,
							},
							File:   "oee.flux",
							Source: "idealCycleTime",
							Start: ast.Position{
								Column: 9,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   20,
								},
								File:   "oee.flux",
								Source: "idealCycleTime",
								Start: ast.Position{
									Column: 9,
									Line:   20,
								},
							},
						},
						Name: "idealCycleTime",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   72,
					},
					File:   "oee.flux",
					Source: "APQ = (tables=<-, runningState, plannedTime, idealCycleTime) => computeAPQ(\n    productionEvents: tables,\n    partEvents: tables,\n    runningState: runningState,\n    plannedTime: plannedTime,\n    idealCycleTime: idealCycleTime,\n)",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// APQ computes availability, performance, quality and overall equipment effectiveness (oee).\n"}, ast.Comment{Text: "// Input tables are expected to have rows with _time, state, partCount and badCount columns, where\n"}, ast.Comment{Text: "//   state that indicates start and stop events, partCount represents total number\n"}, ast.Comment{Text: "//   of produced parts and badCount represents number of parts that did not meet quality standards.\n"}, ast.Comment{Text: "// plannedTime - total time that equipment is expected to produce\n"}, ast.Comment{Text: "// idealCycleTime - theoretical minimum time to produce one part\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   66,
						},
						File:   "oee.flux",
						Source: "APQ",
						Start: ast.Position{
							Column: 1,
							Line:   66,
						},
					},
				},
				Name: "APQ",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   72,
						},
						File:   "oee.flux",
						Source: "(tables=<-, runningState, plannedTime, idealCycleTime) => computeAPQ(\n    productionEvents: tables,\n    partEvents: tables,\n    runningState: runningState,\n    plannedTime: plannedTime,\n    idealCycleTime: idealCycleTime,\n)",
						Start: ast.Position{
							Column: 7,
							Line:   66,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   71,
								},
								File:   "oee.flux",
								Source: "productionEvents: tables,\n    partEvents: tables,\n    runningState: runningState,\n    plannedTime: plannedTime,\n    idealCycleTime: idealCycleTime",
								Start: ast.Position{
									Column: 5,
									Line:   67,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   67,
									},
									File:   "oee.flux",
									Source: "productionEvents: tables",
									Start: ast.Position{
										Column: 5,
										Line:   67,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   67,
										},
										File:   "oee.flux",
										Source: "productionEvents",
										Start: ast.Position{
											Column: 5,
											Line:   67,
										},
									},
								},
								Name: "productionEvents",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   67,
										},
										File:   "oee.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 23,
											Line:   67,
										},
									},
								},
								Name: "tables",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   68,
									},
									File:   "oee.flux",
									Source: "partEvents: tables",
									Start: ast.Position{
										Column: 5,
										Line:   68,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   68,
										},
										File:   "oee.flux",
										Source: "partEvents",
										Start: ast.Position{
											Column: 5,
											Line:   68,
										},
									},
								},
								Name: "partEvents",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   68,
										},
										File:   "oee.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 17,
											Line:   68,
										},
									},
								},
								Name: "tables",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   69,
									},
									File:   "oee.flux",
									Source: "runningState: runningState",
									Start: ast.Position{
										Column: 5,
										Line:   69,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   69,
										},
										File:   "oee.flux",
										Source: "runningState",
										Start: ast.Position{
											Column: 5,
											Line:   69,
										},
									},
								},
								Name: "runningState",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   69,
										},
										File:   "oee.flux",
										Source: "runningState",
										Start: ast.Position{
											Column: 19,
											Line:   69,
										},
									},
								},
								Name: "runningState",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   70,
									},
									File:   "oee.flux",
									Source: "plannedTime: plannedTime",
									Start: ast.Position{
										Column: 5,
										Line:   70,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   70,
										},
										File:   "oee.flux",
										Source: "plannedTime",
										Start: ast.Position{
											Column: 5,
											Line:   70,
										},
									},
								},
								Name: "plannedTime",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   70,
										},
										File:   "oee.flux",
										Source: "plannedTime",
										Start: ast.Position{
											Column: 18,
											Line:   70,
										},
									},
								},
								Name: "plannedTime",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   71,
									},
									File:   "oee.flux",
									Source: "idealCycleTime: idealCycleTime",
									Start: ast.Position{
										Column: 5,
										Line:   71,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   71,
										},
										File:   "oee.flux",
										Source: "idealCycleTime",
										Start: ast.Position{
											Column: 5,
											Line:   71,
										},
									},
								},
								Name: "idealCycleTime",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   71,
										},
										File:   "oee.flux",
										Source: "idealCycleTime",
										Start: ast.Position{
											Column: 21,
											Line:   71,
										},
									},
								},
								Name: "idealCycleTime",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   72,
							},
							File:   "oee.flux",
							Source: "computeAPQ(\n    productionEvents: tables,\n    partEvents: tables,\n    runningState: runningState,\n    plannedTime: plannedTime,\n    idealCycleTime: idealCycleTime,\n)",
							Start: ast.Position{
								Column: 65,
								Line:   66,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   66,
								},
								File:   "oee.flux",
								Source: "computeAPQ",
								Start: ast.Position{
									Column: 65,
									Line:   66,
								},
							},
						},
						Name: "computeAPQ",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   66,
							},
							File:   "oee.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 8,
								Line:   66,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   66,
								},
								File:   "oee.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 8,
									Line:   66,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   66,
							},
							File:   "oee.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 15,
								Line:   66,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   66,
							},
							File:   "oee.flux",
							Source: "runningState",
							Start: ast.Position{
								Column: 19,
								Line:   66,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   66,
								},
								File:   "oee.flux",
								Source: "runningState",
								Start: ast.Position{
									Column: 19,
									Line:   66,
								},
							},
						},
						Name: "runningState",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   66,
							},
							File:   "oee.flux",
							Source: "plannedTime",
							Start: ast.Position{
								Column: 33,
								Line:   66,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   66,
								},
								File:   "oee.flux",
								Source: "plannedTime",
								Start: ast.Position{
									Column: 33,
									Line:   66,
								},
							},
						},
						Name: "plannedTime",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   66,
							},
							File:   "oee.flux",
							Source: "idealCycleTime",
							Start: ast.Position{
								Column: 46,
								Line:   66,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   66,
								},
								File:   "oee.flux",
								Source: "idealCycleTime",
								Start: ast.Position{
									Column: 46,
									Line:   66,
								},
							},
						},
						Name: "idealCycleTime",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   4,
					},
					File:   "oee.flux",
					Source: "import \"contrib/tomhollingworth/events\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   4,
						},
						File:   "oee.flux",
						Source: "\"contrib/tomhollingworth/events\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "contrib/tomhollingworth/events",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   5,
					},
					File:   "oee.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   5,
						},
						File:   "oee.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "oee.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   1,
					},
					File:   "oee.flux",
					Source: "package oee",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   1,
						},
						File:   "oee.flux",
						Source: "oee",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "oee",
			},
		},
	}},
	Package: "oee",
	Path:    "experimental/oee",
}
