// DO NOT EDIT: This file is autogenerated via the builtin command.

package promql

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 122,
					Line:   103,
				},
				File:   "join_test.flux",
				Source: "package promql_test\n\n\nimport \"internal/promql\"\nimport \"testing\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,0,2018-12-19T22:13:30Z,_m,a,t,1\n,,0,2018-12-19T22:13:40Z,_m,a,t,2\n,,0,2018-12-19T22:13:50Z,_m,a,t,3\n,,0,2018-12-19T22:14:00Z,_m,a,t,4\n,,0,2018-12-19T22:14:10Z,_m,a,t,5\n,,0,2018-12-19T22:14:20Z,_m,a,t,6\n,,1,2018-12-19T22:13:30Z,_m,a,g,2\n,,1,2018-12-19T22:13:40Z,_m,a,g,3\n,,1,2018-12-19T22:13:50Z,_m,a,g,4\n,,1,2018-12-19T22:14:00Z,_m,a,g,5\n,,1,2018-12-19T22:14:10Z,_m,a,g,6\n,,1,2018-12-19T22:14:20Z,_m,a,g,7\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,2,2018-12-19T22:13:30Z,_m,a,t,1\n,,2,2018-12-19T22:13:40Z,_m,a,t,2\n,,2,2018-12-19T22:13:50Z,_m,a,t,3\n,,2,2018-12-19T22:14:00Z,_m,a,t,4\n,,2,2018-12-19T22:14:10Z,_m,a,t,5\n,,2,2018-12-19T22:14:20Z,_m,a,t,6\n,,3,2018-12-19T22:13:30Z,_m,a,g,1\n,,3,2018-12-19T22:13:40Z,_m,a,g,2\n,,3,2018-12-19T22:13:50Z,_m,a,g,3\n,,3,2018-12-19T22:14:00Z,_m,a,g,4\n,,3,2018-12-19T22:14:10Z,_m,a,g,5\n,,3,2018-12-19T22:14:20Z,_m,a,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,4,2018-12-19T22:13:30Z,_m,b,s,1\n,,4,2018-12-19T22:13:40Z,_m,b,s,2\n,,4,2018-12-19T22:13:50Z,_m,b,s,3\n,,4,2018-12-19T22:14:00Z,_m,b,s,4\n,,4,2018-12-19T22:14:10Z,_m,b,s,5\n,,4,2018-12-19T22:14:20Z,_m,b,s,6\n,,5,2018-12-19T22:13:30Z,_m,b,g,1\n,,5,2018-12-19T22:13:40Z,_m,b,g,2\n,,5,2018-12-19T22:13:50Z,_m,b,g,3\n,,5,2018-12-19T22:14:00Z,_m,b,g,4\n,,5,2018-12-19T22:14:10Z,_m,b,g,5\n,,5,2018-12-19T22:14:20Z,_m,b,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,6,2018-12-19T22:13:30Z,_m,b,s,1\n,,6,2018-12-19T22:13:40Z,_m,b,s,2\n,,6,2018-12-19T22:13:50Z,_m,b,s,3\n,,6,2018-12-19T22:14:00Z,_m,b,s,4\n,,6,2018-12-19T22:14:10Z,_m,b,s,5\n,,6,2018-12-19T22:14:20Z,_m,b,s,6\n,,7,2018-12-19T22:13:30Z,_m,b,p,1\n,,7,2018-12-19T22:13:40Z,_m,b,p,2\n,,7,2018-12-19T22:13:50Z,_m,b,p,3\n,,7,2018-12-19T22:14:00Z,_m,b,p,4\n,,7,2018-12-19T22:14:10Z,_m,b,p,5\n,,7,2018-12-19T22:14:20Z,_m,b,p,6\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,double,double\n#group,false,false,true,true,false,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,tag0,value_a,value_b\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:30Z,_m,g,2,1\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:40Z,_m,g,3,2\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:50Z,_m,g,4,3\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:00Z,_m,g,5,4\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:10Z,_m,g,6,5\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:20Z,_m,g,7,6\n\"\njoin_test_fn = (table=<-) => {\n    a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})\n    b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})\n\n    return promql.join(left: a, right: b, fn: (left, right) => ({left with value_b: right.value_b}))\n}\n\ntest prom_join = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   75,
					},
					File:   "join_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,0,2018-12-19T22:13:30Z,_m,a,t,1\n,,0,2018-12-19T22:13:40Z,_m,a,t,2\n,,0,2018-12-19T22:13:50Z,_m,a,t,3\n,,0,2018-12-19T22:14:00Z,_m,a,t,4\n,,0,2018-12-19T22:14:10Z,_m,a,t,5\n,,0,2018-12-19T22:14:20Z,_m,a,t,6\n,,1,2018-12-19T22:13:30Z,_m,a,g,2\n,,1,2018-12-19T22:13:40Z,_m,a,g,3\n,,1,2018-12-19T22:13:50Z,_m,a,g,4\n,,1,2018-12-19T22:14:00Z,_m,a,g,5\n,,1,2018-12-19T22:14:10Z,_m,a,g,6\n,,1,2018-12-19T22:14:20Z,_m,a,g,7\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,2,2018-12-19T22:13:30Z,_m,a,t,1\n,,2,2018-12-19T22:13:40Z,_m,a,t,2\n,,2,2018-12-19T22:13:50Z,_m,a,t,3\n,,2,2018-12-19T22:14:00Z,_m,a,t,4\n,,2,2018-12-19T22:14:10Z,_m,a,t,5\n,,2,2018-12-19T22:14:20Z,_m,a,t,6\n,,3,2018-12-19T22:13:30Z,_m,a,g,1\n,,3,2018-12-19T22:13:40Z,_m,a,g,2\n,,3,2018-12-19T22:13:50Z,_m,a,g,3\n,,3,2018-12-19T22:14:00Z,_m,a,g,4\n,,3,2018-12-19T22:14:10Z,_m,a,g,5\n,,3,2018-12-19T22:14:20Z,_m,a,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,4,2018-12-19T22:13:30Z,_m,b,s,1\n,,4,2018-12-19T22:13:40Z,_m,b,s,2\n,,4,2018-12-19T22:13:50Z,_m,b,s,3\n,,4,2018-12-19T22:14:00Z,_m,b,s,4\n,,4,2018-12-19T22:14:10Z,_m,b,s,5\n,,4,2018-12-19T22:14:20Z,_m,b,s,6\n,,5,2018-12-19T22:13:30Z,_m,b,g,1\n,,5,2018-12-19T22:13:40Z,_m,b,g,2\n,,5,2018-12-19T22:13:50Z,_m,b,g,3\n,,5,2018-12-19T22:14:00Z,_m,b,g,4\n,,5,2018-12-19T22:14:10Z,_m,b,g,5\n,,5,2018-12-19T22:14:20Z,_m,b,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,6,2018-12-19T22:13:30Z,_m,b,s,1\n,,6,2018-12-19T22:13:40Z,_m,b,s,2\n,,6,2018-12-19T22:13:50Z,_m,b,s,3\n,,6,2018-12-19T22:14:00Z,_m,b,s,4\n,,6,2018-12-19T22:14:10Z,_m,b,s,5\n,,6,2018-12-19T22:14:20Z,_m,b,s,6\n,,7,2018-12-19T22:13:30Z,_m,b,p,1\n,,7,2018-12-19T22:13:40Z,_m,b,p,2\n,,7,2018-12-19T22:13:50Z,_m,b,p,3\n,,7,2018-12-19T22:14:00Z,_m,b,p,4\n,,7,2018-12-19T22:14:10Z,_m,b,p,5\n,,7,2018-12-19T22:14:20Z,_m,b,p,6\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "join_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   75,
						},
						File:   "join_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,0,2018-12-19T22:13:30Z,_m,a,t,1\n,,0,2018-12-19T22:13:40Z,_m,a,t,2\n,,0,2018-12-19T22:13:50Z,_m,a,t,3\n,,0,2018-12-19T22:14:00Z,_m,a,t,4\n,,0,2018-12-19T22:14:10Z,_m,a,t,5\n,,0,2018-12-19T22:14:20Z,_m,a,t,6\n,,1,2018-12-19T22:13:30Z,_m,a,g,2\n,,1,2018-12-19T22:13:40Z,_m,a,g,3\n,,1,2018-12-19T22:13:50Z,_m,a,g,4\n,,1,2018-12-19T22:14:00Z,_m,a,g,5\n,,1,2018-12-19T22:14:10Z,_m,a,g,6\n,,1,2018-12-19T22:14:20Z,_m,a,g,7\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,2,2018-12-19T22:13:30Z,_m,a,t,1\n,,2,2018-12-19T22:13:40Z,_m,a,t,2\n,,2,2018-12-19T22:13:50Z,_m,a,t,3\n,,2,2018-12-19T22:14:00Z,_m,a,t,4\n,,2,2018-12-19T22:14:10Z,_m,a,t,5\n,,2,2018-12-19T22:14:20Z,_m,a,t,6\n,,3,2018-12-19T22:13:30Z,_m,a,g,1\n,,3,2018-12-19T22:13:40Z,_m,a,g,2\n,,3,2018-12-19T22:13:50Z,_m,a,g,3\n,,3,2018-12-19T22:14:00Z,_m,a,g,4\n,,3,2018-12-19T22:14:10Z,_m,a,g,5\n,,3,2018-12-19T22:14:20Z,_m,a,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,4,2018-12-19T22:13:30Z,_m,b,s,1\n,,4,2018-12-19T22:13:40Z,_m,b,s,2\n,,4,2018-12-19T22:13:50Z,_m,b,s,3\n,,4,2018-12-19T22:14:00Z,_m,b,s,4\n,,4,2018-12-19T22:14:10Z,_m,b,s,5\n,,4,2018-12-19T22:14:20Z,_m,b,s,6\n,,5,2018-12-19T22:13:30Z,_m,b,g,1\n,,5,2018-12-19T22:13:40Z,_m,b,g,2\n,,5,2018-12-19T22:13:50Z,_m,b,g,3\n,,5,2018-12-19T22:14:00Z,_m,b,g,4\n,,5,2018-12-19T22:14:10Z,_m,b,g,5\n,,5,2018-12-19T22:14:20Z,_m,b,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,6,2018-12-19T22:13:30Z,_m,b,s,1\n,,6,2018-12-19T22:13:40Z,_m,b,s,2\n,,6,2018-12-19T22:13:50Z,_m,b,s,3\n,,6,2018-12-19T22:14:00Z,_m,b,s,4\n,,6,2018-12-19T22:14:10Z,_m,b,s,5\n,,6,2018-12-19T22:14:20Z,_m,b,s,6\n,,7,2018-12-19T22:13:30Z,_m,b,p,1\n,,7,2018-12-19T22:13:40Z,_m,b,p,2\n,,7,2018-12-19T22:13:50Z,_m,b,p,3\n,,7,2018-12-19T22:14:00Z,_m,b,p,4\n,,7,2018-12-19T22:14:10Z,_m,b,p,5\n,,7,2018-12-19T22:14:20Z,_m,b,p,6\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,0,2018-12-19T22:13:30Z,_m,a,t,1\n,,0,2018-12-19T22:13:40Z,_m,a,t,2\n,,0,2018-12-19T22:13:50Z,_m,a,t,3\n,,0,2018-12-19T22:14:00Z,_m,a,t,4\n,,0,2018-12-19T22:14:10Z,_m,a,t,5\n,,0,2018-12-19T22:14:20Z,_m,a,t,6\n,,1,2018-12-19T22:13:30Z,_m,a,g,2\n,,1,2018-12-19T22:13:40Z,_m,a,g,3\n,,1,2018-12-19T22:13:50Z,_m,a,g,4\n,,1,2018-12-19T22:14:00Z,_m,a,g,5\n,,1,2018-12-19T22:14:10Z,_m,a,g,6\n,,1,2018-12-19T22:14:20Z,_m,a,g,7\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,2,2018-12-19T22:13:30Z,_m,a,t,1\n,,2,2018-12-19T22:13:40Z,_m,a,t,2\n,,2,2018-12-19T22:13:50Z,_m,a,t,3\n,,2,2018-12-19T22:14:00Z,_m,a,t,4\n,,2,2018-12-19T22:14:10Z,_m,a,t,5\n,,2,2018-12-19T22:14:20Z,_m,a,t,6\n,,3,2018-12-19T22:13:30Z,_m,a,g,1\n,,3,2018-12-19T22:13:40Z,_m,a,g,2\n,,3,2018-12-19T22:13:50Z,_m,a,g,3\n,,3,2018-12-19T22:14:00Z,_m,a,g,4\n,,3,2018-12-19T22:14:10Z,_m,a,g,5\n,,3,2018-12-19T22:14:20Z,_m,a,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,4,2018-12-19T22:13:30Z,_m,b,s,1\n,,4,2018-12-19T22:13:40Z,_m,b,s,2\n,,4,2018-12-19T22:13:50Z,_m,b,s,3\n,,4,2018-12-19T22:14:00Z,_m,b,s,4\n,,4,2018-12-19T22:14:10Z,_m,b,s,5\n,,4,2018-12-19T22:14:20Z,_m,b,s,6\n,,5,2018-12-19T22:13:30Z,_m,b,g,1\n,,5,2018-12-19T22:13:40Z,_m,b,g,2\n,,5,2018-12-19T22:13:50Z,_m,b,g,3\n,,5,2018-12-19T22:14:00Z,_m,b,g,4\n,,5,2018-12-19T22:14:10Z,_m,b,g,5\n,,5,2018-12-19T22:14:20Z,_m,b,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,6,2018-12-19T22:13:30Z,_m,b,s,1\n,,6,2018-12-19T22:13:40Z,_m,b,s,2\n,,6,2018-12-19T22:13:50Z,_m,b,s,3\n,,6,2018-12-19T22:14:00Z,_m,b,s,4\n,,6,2018-12-19T22:14:10Z,_m,b,s,5\n,,6,2018-12-19T22:14:20Z,_m,b,s,6\n,,7,2018-12-19T22:13:30Z,_m,b,p,1\n,,7,2018-12-19T22:13:40Z,_m,b,p,2\n,,7,2018-12-19T22:13:50Z,_m,b,p,3\n,,7,2018-12-19T22:14:00Z,_m,b,p,4\n,,7,2018-12-19T22:14:10Z,_m,b,p,5\n,,7,2018-12-19T22:14:20Z,_m,b,p,6\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   87,
					},
					File:   "join_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,double,double\n#group,false,false,true,true,false,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,tag0,value_a,value_b\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:30Z,_m,g,2,1\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:40Z,_m,g,3,2\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:50Z,_m,g,4,3\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:00Z,_m,g,5,4\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:10Z,_m,g,6,5\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:20Z,_m,g,7,6\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   76,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   76,
						},
						File:   "join_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   76,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   87,
						},
						File:   "join_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,double,double\n#group,false,false,true,true,false,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,tag0,value_a,value_b\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:30Z,_m,g,2,1\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:40Z,_m,g,3,2\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:50Z,_m,g,4,3\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:00Z,_m,g,5,4\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:10Z,_m,g,6,5\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:20Z,_m,g,7,6\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   76,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,double,double\n#group,false,false,true,true,false,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,tag0,value_a,value_b\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:30Z,_m,g,2,1\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:40Z,_m,g,3,2\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:50Z,_m,g,4,3\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:00Z,_m,g,5,4\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:10Z,_m,g,6,5\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:20Z,_m,g,7,6\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   101,
					},
					File:   "join_test.flux",
					Source: "join_test_fn = (table=<-) => {\n    a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})\n    b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})\n\n    return promql.join(left: a, right: b, fn: (left, right) => ({left with value_b: right.value_b}))\n}",
					Start: ast.Position{
						Column: 1,
						Line:   88,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   88,
						},
						File:   "join_test.flux",
						Source: "join_test_fn",
						Start: ast.Position{
							Column: 1,
							Line:   88,
						},
					},
				},
				Name: "join_test_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   101,
						},
						File:   "join_test.flux",
						Source: "(table=<-) => {\n    a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})\n    b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})\n\n    return promql.join(left: a, right: b, fn: (left, right) => ({left with value_b: right.value_b}))\n}",
						Start: ast.Position{
							Column: 16,
							Line:   88,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   101,
							},
							File:   "join_test.flux",
							Source: "{\n    a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})\n    b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})\n\n    return promql.join(left: a, right: b, fn: (left, right) => ({left with value_b: right.value_b}))\n}",
							Start: ast.Position{
								Column: 30,
								Line:   88,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   93,
								},
								File:   "join_test.flux",
								Source: "a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})",
								Start: ast.Position{
									Column: 5,
									Line:   89,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   89,
									},
									File:   "join_test.flux",
									Source: "a",
									Start: ast.Position{
										Column: 5,
										Line:   89,
									},
								},
							},
							Name: "a",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   89,
													},
													File:   "join_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 9,
														Line:   89,
													},
												},
											},
											Name: "table",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   90,
												},
												File:   "join_test.flux",
												Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)",
												Start: ast.Position{
													Column: 9,
													Line:   89,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   90,
														},
														File:   "join_test.flux",
														Source: "start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z",
														Start: ast.Position{
															Column: 18,
															Line:   90,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   90,
															},
															File:   "join_test.flux",
															Source: "start: 2018-12-19T00:00:00Z",
															Start: ast.Position{
																Column: 18,
																Line:   90,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   90,
																},
																File:   "join_test.flux",
																Source: "start",
																Start: ast.Position{
																	Column: 18,
																	Line:   90,
																},
															},
														},
														Name: "start",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   90,
																},
																File:   "join_test.flux",
																Source: "2018-12-19T00:00:00Z",
																Start: ast.Position{
																	Column: 25,
																	Line:   90,
																},
															},
														},
														Value: parser.MustParseTime("2018-12-19T00:00:00Z"),
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   90,
															},
															File:   "join_test.flux",
															Source: "stop: 2018-12-20T00:00:00Z",
															Start: ast.Position{
																Column: 47,
																Line:   90,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   90,
																},
																File:   "join_test.flux",
																Source: "stop",
																Start: ast.Position{
																	Column: 47,
																	Line:   90,
																},
															},
														},
														Name: "stop",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   90,
																},
																File:   "join_test.flux",
																Source: "2018-12-20T00:00:00Z",
																Start: ast.Position{
																	Column: 53,
																	Line:   90,
																},
															},
														},
														Value: parser.MustParseTime("2018-12-20T00:00:00Z"),
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   90,
													},
													File:   "join_test.flux",
													Source: "range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)",
													Start: ast.Position{
														Column: 12,
														Line:   90,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   90,
														},
														File:   "join_test.flux",
														Source: "range",
														Start: ast.Position{
															Column: 12,
															Line:   90,
														},
													},
												},
												Name: "range",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   91,
											},
											File:   "join_test.flux",
											Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")",
											Start: ast.Position{
												Column: 9,
												Line:   89,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   91,
													},
													File:   "join_test.flux",
													Source: "fn: (r) => r._field == \"a\"",
													Start: ast.Position{
														Column: 19,
														Line:   91,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   91,
														},
														File:   "join_test.flux",
														Source: "fn: (r) => r._field == \"a\"",
														Start: ast.Position{
															Column: 19,
															Line:   91,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   91,
															},
															File:   "join_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   91,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   91,
															},
															File:   "join_test.flux",
															Source: "(r) => r._field == \"a\"",
															Start: ast.Position{
																Column: 23,
																Line:   91,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   91,
																},
																File:   "join_test.flux",
																Source: "r._field == \"a\"",
																Start: ast.Position{
																	Column: 30,
																	Line:   91,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   91,
																	},
																	File:   "join_test.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 30,
																		Line:   91,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   91,
																		},
																		File:   "join_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   91,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   91,
																		},
																		File:   "join_test.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 32,
																			Line:   91,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   91,
																	},
																	File:   "join_test.flux",
																	Source: "\"a\"",
																	Start: ast.Position{
																		Column: 42,
																		Line:   91,
																	},
																},
															},
															Value: "a",
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   91,
																},
																File:   "join_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   91,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   91,
																	},
																	File:   "join_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   91,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   91,
												},
												File:   "join_test.flux",
												Source: "filter(fn: (r) => r._field == \"a\")",
												Start: ast.Position{
													Column: 12,
													Line:   91,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   91,
													},
													File:   "join_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   91,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   92,
										},
										File:   "join_test.flux",
										Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])",
										Start: ast.Position{
											Column: 9,
											Line:   89,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   92,
												},
												File:   "join_test.flux",
												Source: "columns: [\"_field\"]",
												Start: ast.Position{
													Column: 17,
													Line:   92,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   92,
													},
													File:   "join_test.flux",
													Source: "columns: [\"_field\"]",
													Start: ast.Position{
														Column: 17,
														Line:   92,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   92,
														},
														File:   "join_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   92,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   92,
														},
														File:   "join_test.flux",
														Source: "[\"_field\"]",
														Start: ast.Position{
															Column: 26,
															Line:   92,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   92,
															},
															File:   "join_test.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 27,
																Line:   92,
															},
														},
													},
													Value: "_field",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   92,
											},
											File:   "join_test.flux",
											Source: "drop(columns: [\"_field\"])",
											Start: ast.Position{
												Column: 12,
												Line:   92,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   92,
												},
												File:   "join_test.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   92,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   93,
									},
									File:   "join_test.flux",
									Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})",
									Start: ast.Position{
										Column: 9,
										Line:   89,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   93,
											},
											File:   "join_test.flux",
											Source: "columns: {_value: \"value_a\"}",
											Start: ast.Position{
												Column: 19,
												Line:   93,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   93,
												},
												File:   "join_test.flux",
												Source: "columns: {_value: \"value_a\"}",
												Start: ast.Position{
													Column: 19,
													Line:   93,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   93,
													},
													File:   "join_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 19,
														Line:   93,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   93,
													},
													File:   "join_test.flux",
													Source: "{_value: \"value_a\"}",
													Start: ast.Position{
														Column: 28,
														Line:   93,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   93,
														},
														File:   "join_test.flux",
														Source: "_value: \"value_a\"",
														Start: ast.Position{
															Column: 29,
															Line:   93,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   93,
															},
															File:   "join_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 29,
																Line:   93,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   93,
															},
															File:   "join_test.flux",
															Source: "\"value_a\"",
															Start: ast.Position{
																Column: 37,
																Line:   93,
															},
														},
													},
													Value: "value_a",
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   93,
										},
										File:   "join_test.flux",
										Source: "rename(columns: {_value: \"value_a\"})",
										Start: ast.Position{
											Column: 12,
											Line:   93,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   93,
											},
											File:   "join_test.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 12,
												Line:   93,
											},
										},
									},
									Name: "rename",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   98,
								},
								File:   "join_test.flux",
								Source: "b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})",
								Start: ast.Position{
									Column: 5,
									Line:   94,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   94,
									},
									File:   "join_test.flux",
									Source: "b",
									Start: ast.Position{
										Column: 5,
										Line:   94,
									},
								},
							},
							Name: "b",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   94,
													},
													File:   "join_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 9,
														Line:   94,
													},
												},
											},
											Name: "table",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   95,
												},
												File:   "join_test.flux",
												Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)",
												Start: ast.Position{
													Column: 9,
													Line:   94,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   95,
														},
														File:   "join_test.flux",
														Source: "start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z",
														Start: ast.Position{
															Column: 18,
															Line:   95,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   95,
															},
															File:   "join_test.flux",
															Source: "start: 2018-12-19T00:00:00Z",
															Start: ast.Position{
																Column: 18,
																Line:   95,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   95,
																},
																File:   "join_test.flux",
																Source: "start",
																Start: ast.Position{
																	Column: 18,
																	Line:   95,
																},
															},
														},
														Name: "start",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   95,
																},
																File:   "join_test.flux",
																Source: "2018-12-19T00:00:00Z",
																Start: ast.Position{
																	Column: 25,
																	Line:   95,
																},
															},
														},
														Value: parser.MustParseTime("2018-12-19T00:00:00Z"),
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   95,
															},
															File:   "join_test.flux",
															Source: "stop: 2018-12-20T00:00:00Z",
															Start: ast.Position{
																Column: 47,
																Line:   95,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   95,
																},
																File:   "join_test.flux",
																Source: "stop",
																Start: ast.Position{
																	Column: 47,
																	Line:   95,
																},
															},
														},
														Name: "stop",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   95,
																},
																File:   "join_test.flux",
																Source: "2018-12-20T00:00:00Z",
																Start: ast.Position{
																	Column: 53,
																	Line:   95,
																},
															},
														},
														Value: parser.MustParseTime("2018-12-20T00:00:00Z"),
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   95,
													},
													File:   "join_test.flux",
													Source: "range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)",
													Start: ast.Position{
														Column: 12,
														Line:   95,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   95,
														},
														File:   "join_test.flux",
														Source: "range",
														Start: ast.Position{
															Column: 12,
															Line:   95,
														},
													},
												},
												Name: "range",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   96,
											},
											File:   "join_test.flux",
											Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")",
											Start: ast.Position{
												Column: 9,
												Line:   94,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   96,
													},
													File:   "join_test.flux",
													Source: "fn: (r) => r._field == \"b\"",
													Start: ast.Position{
														Column: 19,
														Line:   96,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   96,
														},
														File:   "join_test.flux",
														Source: "fn: (r) => r._field == \"b\"",
														Start: ast.Position{
															Column: 19,
															Line:   96,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   96,
															},
															File:   "join_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   96,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   96,
															},
															File:   "join_test.flux",
															Source: "(r) => r._field == \"b\"",
															Start: ast.Position{
																Column: 23,
																Line:   96,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   96,
																},
																File:   "join_test.flux",
																Source: "r._field == \"b\"",
																Start: ast.Position{
																	Column: 30,
																	Line:   96,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   96,
																	},
																	File:   "join_test.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 30,
																		Line:   96,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   96,
																		},
																		File:   "join_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   96,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   96,
																		},
																		File:   "join_test.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 32,
																			Line:   96,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   96,
																	},
																	File:   "join_test.flux",
																	Source: "\"b\"",
																	Start: ast.Position{
																		Column: 42,
																		Line:   96,
																	},
																},
															},
															Value: "b",
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   96,
																},
																File:   "join_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   96,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   96,
																	},
																	File:   "join_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   96,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   96,
												},
												File:   "join_test.flux",
												Source: "filter(fn: (r) => r._field == \"b\")",
												Start: ast.Position{
													Column: 12,
													Line:   96,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   96,
													},
													File:   "join_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   96,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   97,
										},
										File:   "join_test.flux",
										Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])",
										Start: ast.Position{
											Column: 9,
											Line:   94,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   97,
												},
												File:   "join_test.flux",
												Source: "columns: [\"_field\"]",
												Start: ast.Position{
													Column: 17,
													Line:   97,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   97,
													},
													File:   "join_test.flux",
													Source: "columns: [\"_field\"]",
													Start: ast.Position{
														Column: 17,
														Line:   97,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   97,
														},
														File:   "join_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   97,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   97,
														},
														File:   "join_test.flux",
														Source: "[\"_field\"]",
														Start: ast.Position{
															Column: 26,
															Line:   97,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   97,
															},
															File:   "join_test.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 27,
																Line:   97,
															},
														},
													},
													Value: "_field",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   97,
											},
											File:   "join_test.flux",
											Source: "drop(columns: [\"_field\"])",
											Start: ast.Position{
												Column: 12,
												Line:   97,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   97,
												},
												File:   "join_test.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   97,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   98,
									},
									File:   "join_test.flux",
									Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})",
									Start: ast.Position{
										Column: 9,
										Line:   94,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   98,
											},
											File:   "join_test.flux",
											Source: "columns: {_value: \"value_b\"}",
											Start: ast.Position{
												Column: 19,
												Line:   98,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   98,
												},
												File:   "join_test.flux",
												Source: "columns: {_value: \"value_b\"}",
												Start: ast.Position{
													Column: 19,
													Line:   98,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   98,
													},
													File:   "join_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 19,
														Line:   98,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   98,
													},
													File:   "join_test.flux",
													Source: "{_value: \"value_b\"}",
													Start: ast.Position{
														Column: 28,
														Line:   98,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   98,
														},
														File:   "join_test.flux",
														Source: "_value: \"value_b\"",
														Start: ast.Position{
															Column: 29,
															Line:   98,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   98,
															},
															File:   "join_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 29,
																Line:   98,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   98,
															},
															File:   "join_test.flux",
															Source: "\"value_b\"",
															Start: ast.Position{
																Column: 37,
																Line:   98,
															},
														},
													},
													Value: "value_b",
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   98,
										},
										File:   "join_test.flux",
										Source: "rename(columns: {_value: \"value_b\"})",
										Start: ast.Position{
											Column: 12,
											Line:   98,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   98,
											},
											File:   "join_test.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 12,
												Line:   98,
											},
										},
									},
									Name: "rename",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 100,
											Line:   100,
										},
										File:   "join_test.flux",
										Source: "left: a, right: b, fn: (left, right) => ({left with value_b: right.value_b})",
										Start: ast.Position{
											Column: 24,
											Line:   100,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   100,
											},
											File:   "join_test.flux",
											Source: "left: a",
											Start: ast.Position{
												Column: 24,
												Line:   100,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   100,
												},
												File:   "join_test.flux",
												Source: "left",
												Start: ast.Position{
													Column: 24,
													Line:   100,
												},
											},
										},
										Name: "left",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   100,
												},
												File:   "join_test.flux",
												Source: "a",
												Start: ast.Position{
													Column: 30,
													Line:   100,
												},
											},
										},
										Name: "a",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   100,
											},
											File:   "join_test.flux",
											Source: "right: b",
											Start: ast.Position{
												Column: 33,
												Line:   100,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   100,
												},
												File:   "join_test.flux",
												Source: "right",
												Start: ast.Position{
													Column: 33,
													Line:   100,
												},
											},
										},
										Name: "right",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   100,
												},
												File:   "join_test.flux",
												Source: "b",
												Start: ast.Position{
													Column: 40,
													Line:   100,
												},
											},
										},
										Name: "b",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   100,
											},
											File:   "join_test.flux",
											Source: "fn: (left, right) => ({left with value_b: right.value_b})",
											Start: ast.Position{
												Column: 43,
												Line:   100,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   100,
												},
												File:   "join_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 43,
													Line:   100,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   100,
												},
												File:   "join_test.flux",
												Source: "(left, right) => ({left with value_b: right.value_b})",
												Start: ast.Position{
													Column: 47,
													Line:   100,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   100,
													},
													File:   "join_test.flux",
													Source: "({left with value_b: right.value_b})",
													Start: ast.Position{
														Column: 64,
														Line:   100,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   100,
														},
														File:   "join_test.flux",
														Source: "{left with value_b: right.value_b}",
														Start: ast.Position{
															Column: 65,
															Line:   100,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 98,
																Line:   100,
															},
															File:   "join_test.flux",
															Source: "value_b: right.value_b",
															Start: ast.Position{
																Column: 76,
																Line:   100,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 83,
																	Line:   100,
																},
																File:   "join_test.flux",
																Source: "value_b",
																Start: ast.Position{
																	Column: 76,
																	Line:   100,
																},
															},
														},
														Name: "value_b",
													},
													Separator: nil,
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 98,
																	Line:   100,
																},
																File:   "join_test.flux",
																Source: "right.value_b",
																Start: ast.Position{
																	Column: 85,
																	Line:   100,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 90,
																		Line:   100,
																	},
																	File:   "join_test.flux",
																	Source: "right",
																	Start: ast.Position{
																		Column: 85,
																		Line:   100,
																	},
																},
															},
															Name: "right",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 98,
																		Line:   100,
																	},
																	File:   "join_test.flux",
																	Source: "value_b",
																	Start: ast.Position{
																		Column: 91,
																		Line:   100,
																	},
																},
															},
															Name: "value_b",
														},
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 70,
																Line:   100,
															},
															File:   "join_test.flux",
															Source: "left",
															Start: ast.Position{
																Column: 66,
																Line:   100,
															},
														},
													},
													Name: "left",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   100,
													},
													File:   "join_test.flux",
													Source: "left",
													Start: ast.Position{
														Column: 48,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   100,
														},
														File:   "join_test.flux",
														Source: "left",
														Start: ast.Position{
															Column: 48,
															Line:   100,
														},
													},
												},
												Name: "left",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   100,
													},
													File:   "join_test.flux",
													Source: "right",
													Start: ast.Position{
														Column: 54,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   100,
														},
														File:   "join_test.flux",
														Source: "right",
														Start: ast.Position{
															Column: 54,
															Line:   100,
														},
													},
												},
												Name: "right",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   100,
									},
									File:   "join_test.flux",
									Source: "promql.join(left: a, right: b, fn: (left, right) => ({left with value_b: right.value_b}))",
									Start: ast.Position{
										Column: 12,
										Line:   100,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   100,
										},
										File:   "join_test.flux",
										Source: "promql.join",
										Start: ast.Position{
											Column: 12,
											Line:   100,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   100,
											},
											File:   "join_test.flux",
											Source: "promql",
											Start: ast.Position{
												Column: 12,
												Line:   100,
											},
										},
									},
									Name: "promql",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   100,
											},
											File:   "join_test.flux",
											Source: "join",
											Start: ast.Position{
												Column: 19,
												Line:   100,
											},
										},
									},
									Name: "join",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   100,
								},
								File:   "join_test.flux",
								Source: "return promql.join(left: a, right: b, fn: (left, right) => ({left with value_b: right.value_b}))",
								Start: ast.Position{
									Column: 5,
									Line:   100,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   88,
							},
							File:   "join_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 17,
								Line:   88,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   88,
								},
								File:   "join_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 17,
									Line:   88,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   88,
							},
							File:   "join_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   88,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 122,
							Line:   103,
						},
						File:   "join_test.flux",
						Source: "prom_join = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   103,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   103,
							},
							File:   "join_test.flux",
							Source: "prom_join",
							Start: ast.Position{
								Column: 6,
								Line:   103,
							},
						},
					},
					Name: "prom_join",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 122,
								Line:   103,
							},
							File:   "join_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
							Start: ast.Position{
								Column: 18,
								Line:   103,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 122,
									Line:   103,
								},
								File:   "join_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
								Start: ast.Position{
									Column: 24,
									Line:   103,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 121,
										Line:   103,
									},
									File:   "join_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn}",
									Start: ast.Position{
										Column: 25,
										Line:   103,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   103,
										},
										File:   "join_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 26,
											Line:   103,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   103,
											},
											File:   "join_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 26,
												Line:   103,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   103,
												},
												File:   "join_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 53,
													Line:   103,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   103,
													},
													File:   "join_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 53,
														Line:   103,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   103,
														},
														File:   "join_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 53,
															Line:   103,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   103,
														},
														File:   "join_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 58,
															Line:   103,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   103,
											},
											File:   "join_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 33,
												Line:   103,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   103,
												},
												File:   "join_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 33,
													Line:   103,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   103,
													},
													File:   "join_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 33,
														Line:   103,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   103,
													},
													File:   "join_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 41,
														Line:   103,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   103,
										},
										File:   "join_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 67,
											Line:   103,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   103,
											},
											File:   "join_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 67,
												Line:   103,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 101,
													Line:   103,
												},
												File:   "join_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 89,
													Line:   103,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 101,
														Line:   103,
													},
													File:   "join_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 89,
														Line:   103,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 92,
															Line:   103,
														},
														File:   "join_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 89,
															Line:   103,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 101,
															Line:   103,
														},
														File:   "join_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 94,
															Line:   103,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   103,
											},
											File:   "join_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 73,
												Line:   103,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   103,
												},
												File:   "join_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 73,
													Line:   103,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   103,
													},
													File:   "join_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 73,
														Line:   103,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   103,
													},
													File:   "join_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 81,
														Line:   103,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 120,
											Line:   103,
										},
										File:   "join_test.flux",
										Source: "fn: join_test_fn",
										Start: ast.Position{
											Column: 104,
											Line:   103,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 106,
												Line:   103,
											},
											File:   "join_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 104,
												Line:   103,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 120,
												Line:   103,
											},
											File:   "join_test.flux",
											Source: "join_test_fn",
											Start: ast.Position{
												Column: 108,
												Line:   103,
											},
										},
									},
									Name: "join_test_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 122,
						Line:   103,
					},
					File:   "join_test.flux",
					Source: "test prom_join = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   103,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   4,
					},
					File:   "join_test.flux",
					Source: "import \"internal/promql\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   4,
						},
						File:   "join_test.flux",
						Source: "\"internal/promql\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "internal/promql",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "join_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "join_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "join_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "join_test.flux",
					Source: "package promql_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "join_test.flux",
						Source: "promql_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "promql_test",
			},
		},
	}},
	Package: "promql_test",
	Path:    "internal/promql",
}}
