// DO NOT EDIT: This file is autogenerated via the builtin command.

package pushbullet

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   148,
				},
				File:   "pushbullet.flux",
				Source: "package pushbullet\n\n\nimport \"http\"\nimport \"json\"\n\noption defaultURL = \"https://api.pushbullet.com/v2/pushes\"\n\n// pushData sends a push notification to the Pushbullet API.\n//\n// ## Parameters\n//\n// - `url` is the URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n// - `token` is the api token string.  Defaults to: \"\".\n// - `data` is the data to send to the endpoint. It will be encoded in JSON and sent to PushBullet's endpoint.\n// For how to structure data, see https://docs.pushbullet.com/#create-push.\n//\n// ## Send the last reported status to Pushbullet\n//\n// ```\n// import \"pushbullet\"\n// import \"influxdata/influxdb/secrets\"\n//\n// token = secrets.get(key: \"PUSHBULLET_TOKEN\")\n//\n// lastReported =\n//   from(bucket: \"example-bucket\")\n//     |> range(start: -1m)\n//     |> filter(fn: (r) => r._measurement == \"statuses\")\n//     |> last()\n//     |> tableFind(fn: (key) => true)\n//     |> getRecord(idx: 0)\n//\n// pushbullet.pushData(\n//   token: token,\n//   data: {\n//     \"type\": \"link\",\n//     \"title\": \"Last reported status\",\n//     \"body\": \"${lastReported._time}: ${lastReported.status}.\"\n//     \"url\": \"${lastReported.statusURL}\"\n//   }\n// )\n// ```\n//\npushData = (url=defaultURL, token=\"\", data) => {\n    headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}\n\n// pushNote sends a push notification of type note to the Pushbullet API.\n//\n// ## Parameters\n//\n// - `url` is the URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n// - `token` is the api token string.  Defaults to: \"\".\n// - `title` is the title of the notification.\n// - `text` is the text to display in the notification.\n//\n// ## Send the last reported status to Pushbullet\n//\n// ```\n// import \"pushbullet\"\n// import \"influxdata/influxdb/secrets\"\n//\n// token = secrets.get(key: \"PUSHBULLET_TOKEN\")\n//\n// lastReported =\n//   from(bucket: \"example-bucket\")\n//     |> range(start: -1m)\n//     |> filter(fn: (r) => r._measurement == \"statuses\")\n//     |> last()\n//     |> tableFind(fn: (key) => true)\n//     |> getRecord(idx: 0)\n//\n// pushbullet.pushNote(\n//   token: token,\n//   data: {\n//     token: token,\n//     title: \"Last reported status\",\n//     text: \"${lastReported._time}: ${lastReported.status}.\"\n//   }\n// )\n// ```\npushNote = (url=defaultURL, token=\"\", title, text) => {\n    data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }\n\n    return pushData(token: token, url: url, data: data)\n}\n\n// endpoint creates the endpoint for the Pushbullet API and sends a notification of type note.\n//\n// ## Parameters\n//\n// - `url` is the URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n// - `token` is the api token string.  Defaults to: \"\".\n// - `Usage` pushbullet.endpoint is a factory function that outputs another function. The output function requires a mapFn parameter.\n// - `mapFn` is a function that builds the record used to generate the API request. Requires an r parameter.\n//\n// ## Send the last reported status to Pushbullet\n//\n// ```\n// import \"pushbullet\"\n// import \"influxdata/influxdb/secrets\"\n//\n// token = secrets.get(key: \"PUSHBULLET_TOKEN\")\n//\n// lastReported =\n//   from(bucket: \"example-bucket\")\n//     |> range(start: -10m)\n//     |> filter(fn: (r) => r._measurement == \"statuses\")\n//     |> last()\n//\n// lastReported\n//   |> e(mapFn: (r) => ({\n//       r with\n//       title: r.title,\n//       text: \"${string(v: r._time)}: ${r.status}.\"\n//     })\n//   )()\n// ```\n//\nendpoint = (url=defaultURL, token=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   8,
						},
						File:   "pushbullet.flux",
						Source: "defaultURL = \"https://api.pushbullet.com/v2/pushes\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   8,
							},
							File:   "pushbullet.flux",
							Source: "defaultURL",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "defaultURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   8,
							},
							File:   "pushbullet.flux",
							Source: "\"https://api.pushbullet.com/v2/pushes\"",
							Start: ast.Position{
								Column: 21,
								Line:   8,
							},
						},
					},
					Value: "https://api.pushbullet.com/v2/pushes",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 59,
						Line:   8,
					},
					File:   "pushbullet.flux",
					Source: "option defaultURL = \"https://api.pushbullet.com/v2/pushes\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   54,
					},
					File:   "pushbullet.flux",
					Source: "pushData = (url=defaultURL, token=\"\", data) => {\n    headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// pushData sends a push notification to the Pushbullet API.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `url` is the URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n"}, ast.Comment{Text: "// - `token` is the api token string.  Defaults to: \"\".\n"}, ast.Comment{Text: "// - `data` is the data to send to the endpoint. It will be encoded in JSON and sent to PushBullet's endpoint.\n"}, ast.Comment{Text: "// For how to structure data, see https://docs.pushbullet.com/#create-push.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Send the last reported status to Pushbullet\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"pushbullet\"\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/secrets\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// token = secrets.get(key: \"PUSHBULLET_TOKEN\")\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// lastReported =\n"}, ast.Comment{Text: "//   from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//     |> range(start: -1m)\n"}, ast.Comment{Text: "//     |> filter(fn: (r) => r._measurement == \"statuses\")\n"}, ast.Comment{Text: "//     |> last()\n"}, ast.Comment{Text: "//     |> tableFind(fn: (key) => true)\n"}, ast.Comment{Text: "//     |> getRecord(idx: 0)\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// pushbullet.pushData(\n"}, ast.Comment{Text: "//   token: token,\n"}, ast.Comment{Text: "//   data: {\n"}, ast.Comment{Text: "//     \"type\": \"link\",\n"}, ast.Comment{Text: "//     \"title\": \"Last reported status\",\n"}, ast.Comment{Text: "//     \"body\": \"${lastReported._time}: ${lastReported.status}.\"\n"}, ast.Comment{Text: "//     \"url\": \"${lastReported.statusURL}\"\n"}, ast.Comment{Text: "//   }\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   46,
						},
						File:   "pushbullet.flux",
						Source: "pushData",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "pushData",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   54,
						},
						File:   "pushbullet.flux",
						Source: "(url=defaultURL, token=\"\", data) => {\n    headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}",
						Start: ast.Position{
							Column: 12,
							Line:   46,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   54,
							},
							File:   "pushbullet.flux",
							Source: "{\n    headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}",
							Start: ast.Position{
								Column: 48,
								Line:   46,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   50,
								},
								File:   "pushbullet.flux",
								Source: "headers = {\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   47,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   47,
									},
									File:   "pushbullet.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   47,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   50,
									},
									File:   "pushbullet.flux",
									Source: "{\n        \"Access-Token\": token,\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   47,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   48,
										},
										File:   "pushbullet.flux",
										Source: "\"Access-Token\": token",
										Start: ast.Position{
											Column: 9,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   48,
											},
											File:   "pushbullet.flux",
											Source: "\"Access-Token\"",
											Start: ast.Position{
												Column: 9,
												Line:   48,
											},
										},
									},
									Value: "Access-Token",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   48,
											},
											File:   "pushbullet.flux",
											Source: "token",
											Start: ast.Position{
												Column: 25,
												Line:   48,
											},
										},
									},
									Name: "token",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   49,
										},
										File:   "pushbullet.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   49,
											},
											File:   "pushbullet.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   49,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   49,
											},
											File:   "pushbullet.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   49,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   51,
								},
								File:   "pushbullet.flux",
								Source: "enc = json.encode(v: data)",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   51,
									},
									File:   "pushbullet.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   51,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   51,
										},
										File:   "pushbullet.flux",
										Source: "v: data",
										Start: ast.Position{
											Column: 23,
											Line:   51,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   51,
											},
											File:   "pushbullet.flux",
											Source: "v: data",
											Start: ast.Position{
												Column: 23,
												Line:   51,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   51,
												},
												File:   "pushbullet.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   51,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   51,
												},
												File:   "pushbullet.flux",
												Source: "data",
												Start: ast.Position{
													Column: 26,
													Line:   51,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   51,
									},
									File:   "pushbullet.flux",
									Source: "json.encode(v: data)",
									Start: ast.Position{
										Column: 11,
										Line:   51,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   51,
										},
										File:   "pushbullet.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   51,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   51,
											},
											File:   "pushbullet.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   51,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   51,
											},
											File:   "pushbullet.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   51,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   53,
										},
										File:   "pushbullet.flux",
										Source: "headers: headers, url: url, data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   53,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   53,
											},
											File:   "pushbullet.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   53,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   53,
												},
												File:   "pushbullet.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   53,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   53,
												},
												File:   "pushbullet.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   53,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   53,
											},
											File:   "pushbullet.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   53,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   53,
												},
												File:   "pushbullet.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   53,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   53,
												},
												File:   "pushbullet.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   53,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   53,
											},
											File:   "pushbullet.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 50,
												Line:   53,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   53,
												},
												File:   "pushbullet.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   53,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   53,
												},
												File:   "pushbullet.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 56,
													Line:   53,
												},
											},
										},
										Name: "enc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   53,
									},
									File:   "pushbullet.flux",
									Source: "http.post(headers: headers, url: url, data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   53,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   53,
										},
										File:   "pushbullet.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   53,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   53,
											},
											File:   "pushbullet.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   53,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   53,
											},
											File:   "pushbullet.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   53,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   53,
								},
								File:   "pushbullet.flux",
								Source: "return http.post(headers: headers, url: url, data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   53,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   46,
							},
							File:   "pushbullet.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   46,
								},
								File:   "pushbullet.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   46,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   46,
								},
								File:   "pushbullet.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   46,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   46,
							},
							File:   "pushbullet.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 29,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   46,
								},
								File:   "pushbullet.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   46,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   46,
								},
								File:   "pushbullet.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 35,
									Line:   46,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   46,
							},
							File:   "pushbullet.flux",
							Source: "data",
							Start: ast.Position{
								Column: 39,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   46,
								},
								File:   "pushbullet.flux",
								Source: "data",
								Start: ast.Position{
									Column: 39,
									Line:   46,
								},
							},
						},
						Name: "data",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   98,
					},
					File:   "pushbullet.flux",
					Source: "pushNote = (url=defaultURL, token=\"\", title, text) => {\n    data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }\n\n    return pushData(token: token, url: url, data: data)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   90,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// pushNote sends a push notification of type note to the Pushbullet API.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `url` is the URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n"}, ast.Comment{Text: "// - `token` is the api token string.  Defaults to: \"\".\n"}, ast.Comment{Text: "// - `title` is the title of the notification.\n"}, ast.Comment{Text: "// - `text` is the text to display in the notification.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Send the last reported status to Pushbullet\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"pushbullet\"\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/secrets\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// token = secrets.get(key: \"PUSHBULLET_TOKEN\")\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// lastReported =\n"}, ast.Comment{Text: "//   from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//     |> range(start: -1m)\n"}, ast.Comment{Text: "//     |> filter(fn: (r) => r._measurement == \"statuses\")\n"}, ast.Comment{Text: "//     |> last()\n"}, ast.Comment{Text: "//     |> tableFind(fn: (key) => true)\n"}, ast.Comment{Text: "//     |> getRecord(idx: 0)\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// pushbullet.pushNote(\n"}, ast.Comment{Text: "//   token: token,\n"}, ast.Comment{Text: "//   data: {\n"}, ast.Comment{Text: "//     token: token,\n"}, ast.Comment{Text: "//     title: \"Last reported status\",\n"}, ast.Comment{Text: "//     text: \"${lastReported._time}: ${lastReported.status}.\"\n"}, ast.Comment{Text: "//   }\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   90,
						},
						File:   "pushbullet.flux",
						Source: "pushNote",
						Start: ast.Position{
							Column: 1,
							Line:   90,
						},
					},
				},
				Name: "pushNote",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   98,
						},
						File:   "pushbullet.flux",
						Source: "(url=defaultURL, token=\"\", title, text) => {\n    data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }\n\n    return pushData(token: token, url: url, data: data)\n}",
						Start: ast.Position{
							Column: 12,
							Line:   90,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   98,
							},
							File:   "pushbullet.flux",
							Source: "{\n    data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }\n\n    return pushData(token: token, url: url, data: data)\n}",
							Start: ast.Position{
								Column: 55,
								Line:   90,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   95,
								},
								File:   "pushbullet.flux",
								Source: "data = {\n        type: \"note\",\n        title: title,\n        body: text,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   91,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   91,
									},
									File:   "pushbullet.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   91,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   95,
									},
									File:   "pushbullet.flux",
									Source: "{\n        type: \"note\",\n        title: title,\n        body: text,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   91,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   92,
										},
										File:   "pushbullet.flux",
										Source: "type: \"note\"",
										Start: ast.Position{
											Column: 9,
											Line:   92,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   92,
											},
											File:   "pushbullet.flux",
											Source: "type",
											Start: ast.Position{
												Column: 9,
												Line:   92,
											},
										},
									},
									Name: "type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   92,
											},
											File:   "pushbullet.flux",
											Source: "\"note\"",
											Start: ast.Position{
												Column: 15,
												Line:   92,
											},
										},
									},
									Value: "note",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   93,
										},
										File:   "pushbullet.flux",
										Source: "title: title",
										Start: ast.Position{
											Column: 9,
											Line:   93,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   93,
											},
											File:   "pushbullet.flux",
											Source: "title",
											Start: ast.Position{
												Column: 9,
												Line:   93,
											},
										},
									},
									Name: "title",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   93,
											},
											File:   "pushbullet.flux",
											Source: "title",
											Start: ast.Position{
												Column: 16,
												Line:   93,
											},
										},
									},
									Name: "title",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   94,
										},
										File:   "pushbullet.flux",
										Source: "body: text",
										Start: ast.Position{
											Column: 9,
											Line:   94,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   94,
											},
											File:   "pushbullet.flux",
											Source: "body",
											Start: ast.Position{
												Column: 9,
												Line:   94,
											},
										},
									},
									Name: "body",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   94,
											},
											File:   "pushbullet.flux",
											Source: "text",
											Start: ast.Position{
												Column: 15,
												Line:   94,
											},
										},
									},
									Name: "text",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   97,
										},
										File:   "pushbullet.flux",
										Source: "token: token, url: url, data: data",
										Start: ast.Position{
											Column: 21,
											Line:   97,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   97,
											},
											File:   "pushbullet.flux",
											Source: "token: token",
											Start: ast.Position{
												Column: 21,
												Line:   97,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   97,
												},
												File:   "pushbullet.flux",
												Source: "token",
												Start: ast.Position{
													Column: 21,
													Line:   97,
												},
											},
										},
										Name: "token",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   97,
												},
												File:   "pushbullet.flux",
												Source: "token",
												Start: ast.Position{
													Column: 28,
													Line:   97,
												},
											},
										},
										Name: "token",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   97,
											},
											File:   "pushbullet.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 35,
												Line:   97,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   97,
												},
												File:   "pushbullet.flux",
												Source: "url",
												Start: ast.Position{
													Column: 35,
													Line:   97,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   97,
												},
												File:   "pushbullet.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   97,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   97,
											},
											File:   "pushbullet.flux",
											Source: "data: data",
											Start: ast.Position{
												Column: 45,
												Line:   97,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   97,
												},
												File:   "pushbullet.flux",
												Source: "data",
												Start: ast.Position{
													Column: 45,
													Line:   97,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   97,
												},
												File:   "pushbullet.flux",
												Source: "data",
												Start: ast.Position{
													Column: 51,
													Line:   97,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   97,
									},
									File:   "pushbullet.flux",
									Source: "pushData(token: token, url: url, data: data)",
									Start: ast.Position{
										Column: 12,
										Line:   97,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   97,
										},
										File:   "pushbullet.flux",
										Source: "pushData",
										Start: ast.Position{
											Column: 12,
											Line:   97,
										},
									},
								},
								Name: "pushData",
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   97,
								},
								File:   "pushbullet.flux",
								Source: "return pushData(token: token, url: url, data: data)",
								Start: ast.Position{
									Column: 5,
									Line:   97,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   90,
							},
							File:   "pushbullet.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   90,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   90,
								},
								File:   "pushbullet.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   90,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   90,
								},
								File:   "pushbullet.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   90,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   90,
							},
							File:   "pushbullet.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 29,
								Line:   90,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   90,
								},
								File:   "pushbullet.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   90,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   90,
								},
								File:   "pushbullet.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 35,
									Line:   90,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   90,
							},
							File:   "pushbullet.flux",
							Source: "title",
							Start: ast.Position{
								Column: 39,
								Line:   90,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   90,
								},
								File:   "pushbullet.flux",
								Source: "title",
								Start: ast.Position{
									Column: 39,
									Line:   90,
								},
							},
						},
						Name: "title",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   90,
							},
							File:   "pushbullet.flux",
							Source: "text",
							Start: ast.Position{
								Column: 46,
								Line:   90,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   90,
								},
								File:   "pushbullet.flux",
								Source: "text",
								Start: ast.Position{
									Column: 46,
									Line:   90,
								},
							},
						},
						Name: "text",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   148,
					},
					File:   "pushbullet.flux",
					Source: "endpoint = (url=defaultURL, token=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   132,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// endpoint creates the endpoint for the Pushbullet API and sends a notification of type note.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `url` is the URL of the PushBullet endpoint. Defaults to: \"https://api.pushbullet.com/v2/pushes\".\n"}, ast.Comment{Text: "// - `token` is the api token string.  Defaults to: \"\".\n"}, ast.Comment{Text: "// - `Usage` pushbullet.endpoint is a factory function that outputs another function. The output function requires a mapFn parameter.\n"}, ast.Comment{Text: "// - `mapFn` is a function that builds the record used to generate the API request. Requires an r parameter.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Send the last reported status to Pushbullet\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"pushbullet\"\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/secrets\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// token = secrets.get(key: \"PUSHBULLET_TOKEN\")\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// lastReported =\n"}, ast.Comment{Text: "//   from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//     |> range(start: -10m)\n"}, ast.Comment{Text: "//     |> filter(fn: (r) => r._measurement == \"statuses\")\n"}, ast.Comment{Text: "//     |> last()\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// lastReported\n"}, ast.Comment{Text: "//   |> e(mapFn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       title: r.title,\n"}, ast.Comment{Text: "//       text: \"${string(v: r._time)}: ${r.status}.\"\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   132,
						},
						File:   "pushbullet.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   132,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   148,
						},
						File:   "pushbullet.flux",
						Source: "(url=defaultURL, token=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   132,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   148,
							},
							File:   "pushbullet.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 42,
								Line:   132,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   148,
								},
								File:   "pushbullet.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 53,
									Line:   132,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   132,
										},
										File:   "pushbullet.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 68,
											Line:   132,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   148,
									},
									File:   "pushbullet.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 68,
										Line:   132,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   147,
											},
											File:   "pushbullet.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   134,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   147,
												},
												File:   "pushbullet.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   134,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   134,
													},
													File:   "pushbullet.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   134,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   147,
													},
													File:   "pushbullet.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   134,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   147,
														},
														File:   "pushbullet.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   134,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   135,
															},
															File:   "pushbullet.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   135,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   135,
																},
																File:   "pushbullet.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   135,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   135,
																	},
																	File:   "pushbullet.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   135,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   135,
																		},
																		File:   "pushbullet.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   135,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   135,
																			},
																			File:   "pushbullet.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   135,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   135,
																			},
																			File:   "pushbullet.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   135,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   135,
																},
																File:   "pushbullet.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   135,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   135,
																	},
																	File:   "pushbullet.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   135,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   146,
																},
																File:   "pushbullet.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   137,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   145,
																	},
																	File:   "pushbullet.flux",
																	Source: "_sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   138,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   138,
																		},
																		File:   "pushbullet.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   138,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   144,
																			},
																			File:   "pushbullet.flux",
																			Source: "v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   139,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   144,
																				},
																				File:   "pushbullet.flux",
																				Source: "v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   139,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   139,
																					},
																					File:   "pushbullet.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   139,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   144,
																					},
																					File:   "pushbullet.flux",
																					Source: "2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   139,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   139,
																						},
																						File:   "pushbullet.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   139,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   144,
																						},
																						File:   "pushbullet.flux",
																						Source: "pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   139,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 39,
																									Line:   143,
																								},
																								File:   "pushbullet.flux",
																								Source: "url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text",
																								Start: ast.Position{
																									Column: 25,
																									Line:   140,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   140,
																									},
																									File:   "pushbullet.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   140,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   140,
																										},
																										File:   "pushbullet.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   140,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   140,
																										},
																										File:   "pushbullet.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   140,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 37,
																										Line:   141,
																									},
																									File:   "pushbullet.flux",
																									Source: "token: token",
																									Start: ast.Position{
																										Column: 25,
																										Line:   141,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   141,
																										},
																										File:   "pushbullet.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 25,
																											Line:   141,
																										},
																									},
																								},
																								Name: "token",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   141,
																										},
																										File:   "pushbullet.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 32,
																											Line:   141,
																										},
																									},
																								},
																								Name: "token",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   142,
																									},
																									File:   "pushbullet.flux",
																									Source: "title: obj.title",
																									Start: ast.Position{
																										Column: 25,
																										Line:   142,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   142,
																										},
																										File:   "pushbullet.flux",
																										Source: "title",
																										Start: ast.Position{
																											Column: 25,
																											Line:   142,
																										},
																									},
																								},
																								Name: "title",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   142,
																										},
																										File:   "pushbullet.flux",
																										Source: "obj.title",
																										Start: ast.Position{
																											Column: 32,
																											Line:   142,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   142,
																											},
																											File:   "pushbullet.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   142,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   142,
																											},
																											File:   "pushbullet.flux",
																											Source: "title",
																											Start: ast.Position{
																												Column: 36,
																												Line:   142,
																											},
																										},
																									},
																									Name: "title",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   143,
																									},
																									File:   "pushbullet.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 25,
																										Line:   143,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   143,
																										},
																										File:   "pushbullet.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 25,
																											Line:   143,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   143,
																										},
																										File:   "pushbullet.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 31,
																											Line:   143,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   143,
																											},
																											File:   "pushbullet.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   143,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   143,
																											},
																											File:   "pushbullet.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 35,
																												Line:   143,
																											},
																										},
																									},
																									Name: "text",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   144,
																							},
																							File:   "pushbullet.flux",
																							Source: "pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   139,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 37,
																									Line:   139,
																								},
																								File:   "pushbullet.flux",
																								Source: "pushNote",
																								Start: ast.Position{
																									Column: 29,
																									Line:   139,
																								},
																							},
																						},
																						Name: "pushNote",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   144,
																							},
																							File:   "pushbullet.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   144,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   145,
																		},
																		File:   "pushbullet.flux",
																		Source: "string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   138,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   138,
																			},
																			File:   "pushbullet.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   138,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   137,
																	},
																	File:   "pushbullet.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   137,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   146,
															},
															File:   "pushbullet.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   137,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   134,
														},
														File:   "pushbullet.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   134,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   134,
															},
															File:   "pushbullet.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   134,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   148,
										},
										File:   "pushbullet.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == pushNote(\n                        url: url,\n                        token: token,\n                        title: obj.title,\n                        text: obj.text,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   133,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   133,
											},
											File:   "pushbullet.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   133,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   132,
									},
									File:   "pushbullet.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 54,
										Line:   132,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   132,
										},
										File:   "pushbullet.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 54,
											Line:   132,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   132,
									},
									File:   "pushbullet.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 61,
										Line:   132,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   132,
								},
								File:   "pushbullet.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 43,
									Line:   132,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   132,
									},
									File:   "pushbullet.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 43,
										Line:   132,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   132,
							},
							File:   "pushbullet.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   132,
								},
								File:   "pushbullet.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   132,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   132,
								},
								File:   "pushbullet.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   132,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   132,
							},
							File:   "pushbullet.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 29,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   132,
								},
								File:   "pushbullet.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   132,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   132,
								},
								File:   "pushbullet.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 35,
									Line:   132,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "pushbullet.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "pushbullet.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   6,
					},
					File:   "pushbullet.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   6,
						},
						File:   "pushbullet.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "pushbullet.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package pushbullet provides functions for sending data to Pushbullet.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   2,
					},
					File:   "pushbullet.flux",
					Source: "package pushbullet",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   2,
						},
						File:   "pushbullet.flux",
						Source: "pushbullet",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "pushbullet",
			},
		},
	}},
	Package: "pushbullet",
	Path:    "pushbullet",
}
