// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package firebase provides access to the Firebase Management API.
//
// For product documentation, see: https://firebase.google.com
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/firebase/v1beta1"
//	...
//	ctx := context.Background()
//	firebaseService, err := firebase.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	firebaseService, err := firebase.NewService(ctx, option.WithScopes(firebase.FirebaseReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	firebaseService, err := firebase.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	firebaseService, err := firebase.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package firebase // import "google.golang.org/api/firebase/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "firebase:v1beta1"
const apiName = "firebase"
const apiVersion = "v1beta1"
const basePath = "https://firebase.googleapis.com/"
const basePathTemplate = "https://firebase.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://firebase.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View your data across Google Cloud services and see the email address of
	// your Google Account
	CloudPlatformReadOnlyScope = "https://www.googleapis.com/auth/cloud-platform.read-only"

	// View and administer all your Firebase data and settings
	FirebaseScope = "https://www.googleapis.com/auth/firebase"

	// View all your Firebase data and settings
	FirebaseReadonlyScope = "https://www.googleapis.com/auth/firebase.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud-platform.read-only",
		"https://www.googleapis.com/auth/firebase",
		"https://www.googleapis.com/auth/firebase.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.AvailableProjects = NewAvailableProjectsService(s)
	s.Operations = NewOperationsService(s)
	s.Projects = NewProjectsService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	AvailableProjects *AvailableProjectsService

	Operations *OperationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAvailableProjectsService(s *Service) *AvailableProjectsService {
	rs := &AvailableProjectsService{s: s}
	return rs
}

type AvailableProjectsService struct {
	s *Service
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.AndroidApps = NewProjectsAndroidAppsService(s)
	rs.AvailableLocations = NewProjectsAvailableLocationsService(s)
	rs.DefaultLocation = NewProjectsDefaultLocationService(s)
	rs.IosApps = NewProjectsIosAppsService(s)
	rs.WebApps = NewProjectsWebAppsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	AndroidApps *ProjectsAndroidAppsService

	AvailableLocations *ProjectsAvailableLocationsService

	DefaultLocation *ProjectsDefaultLocationService

	IosApps *ProjectsIosAppsService

	WebApps *ProjectsWebAppsService
}

func NewProjectsAndroidAppsService(s *Service) *ProjectsAndroidAppsService {
	rs := &ProjectsAndroidAppsService{s: s}
	rs.Sha = NewProjectsAndroidAppsShaService(s)
	return rs
}

type ProjectsAndroidAppsService struct {
	s *Service

	Sha *ProjectsAndroidAppsShaService
}

func NewProjectsAndroidAppsShaService(s *Service) *ProjectsAndroidAppsShaService {
	rs := &ProjectsAndroidAppsShaService{s: s}
	return rs
}

type ProjectsAndroidAppsShaService struct {
	s *Service
}

func NewProjectsAvailableLocationsService(s *Service) *ProjectsAvailableLocationsService {
	rs := &ProjectsAvailableLocationsService{s: s}
	return rs
}

type ProjectsAvailableLocationsService struct {
	s *Service
}

func NewProjectsDefaultLocationService(s *Service) *ProjectsDefaultLocationService {
	rs := &ProjectsDefaultLocationService{s: s}
	return rs
}

type ProjectsDefaultLocationService struct {
	s *Service
}

func NewProjectsIosAppsService(s *Service) *ProjectsIosAppsService {
	rs := &ProjectsIosAppsService{s: s}
	return rs
}

type ProjectsIosAppsService struct {
	s *Service
}

func NewProjectsWebAppsService(s *Service) *ProjectsWebAppsService {
	rs := &ProjectsWebAppsService{s: s}
	return rs
}

type ProjectsWebAppsService struct {
	s *Service
}

// AddFirebaseRequest: All fields are required.
type AddFirebaseRequest struct {
	// LocationId: **DEPRECATED.** _Instead, use product-specific REST APIs to work
	// with the location of each resource in a Project. This field may be ignored,
	// especially for newly provisioned projects after October 30, 2024._ The ID of
	// the Project's "location for default Google Cloud resources"
	// (https://firebase.google.com/docs/projects/locations#default-cloud-location),
	// which are resources associated with Google App Engine. The location must be
	// one of the available Google App Engine locations
	// (https://cloud.google.com/about/locations#region).
	LocationId string `json:"locationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddFirebaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddFirebaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AddGoogleAnalyticsRequest struct {
	// AnalyticsAccountId: The ID for the existing Google Analytics account
	// (http://www.google.com/analytics/) that you want to link with the
	// `FirebaseProject`. Specifying this field will provision a new Google
	// Analytics property in your Google Analytics account and associate the new
	// property with the `FirebaseProject`.
	AnalyticsAccountId string `json:"analyticsAccountId,omitempty"`
	// AnalyticsPropertyId: The ID for the existing Google Analytics property that
	// you want to associate with the `FirebaseProject`.
	AnalyticsPropertyId string `json:"analyticsPropertyId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalyticsAccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyticsAccountId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddGoogleAnalyticsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddGoogleAnalyticsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AdminSdkConfig struct {
	// DatabaseURL: **DEPRECATED.** _Instead, find the URL of the default Realtime
	// Database instance using the list endpoint
	// (https://firebase.google.com/docs/reference/rest/database/database-management/rest/v1beta/projects.locations.instances/list)
	// within the Firebase Realtime Database REST API. If the default instance for
	// the Project has not yet been provisioned, the return might not contain a
	// default instance. Note that the config that's generated for the Firebase
	// console or the Firebase CLI uses the Realtime Database endpoint to populate
	// this value for that config._ The URL of the default Firebase Realtime
	// Database instance.
	DatabaseURL string `json:"databaseURL,omitempty"`
	// LocationId: **DEPRECATED.** _Instead, use product-specific REST APIs to find
	// the location of each resource in a Project. This field may not be populated,
	// especially for newly provisioned projects after October 30, 2024._ The ID of
	// the Project's "location for default Google Cloud resources"
	// (https://firebase.google.com/docs/projects/locations#default-cloud-location),
	// which are resources associated with Google App Engine. The location is one
	// of the available App Engine locations
	// (https://cloud.google.com/about/locations#region). This field is omitted if
	// the location for default Google Cloud resources has not been set.
	LocationId string `json:"locationId,omitempty"`
	// ProjectId: Immutable. A user-assigned unique identifier for the
	// `FirebaseProject`. This identifier may appear in URLs or names for some
	// Firebase resources associated with the Project, but it should generally be
	// treated as a convenience alias to reference the Project.
	ProjectId string `json:"projectId,omitempty"`
	// StorageBucket: **DEPRECATED.** _Instead, find the name of the default Cloud
	// Storage for Firebase bucket using the list endpoint
	// (https://firebase.google.com/docs/reference/rest/storage/rest/v1beta/projects.buckets/list)
	// within the Cloud Storage for Firebase REST API. If the default bucket for
	// the Project has not yet been provisioned, the return might not contain a
	// default bucket. Note that the config that's generated for the Firebase
	// console or the Firebase CLI uses the Cloud Storage for Firebase endpoint to
	// populate this value for that config._ The name of the default Cloud Storage
	// for Firebase bucket.
	StorageBucket string `json:"storageBucket,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DatabaseURL") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseURL") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdminSdkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AdminSdkConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AnalyticsDetails struct {
	// AnalyticsProperty: The Analytics Property object associated with the
	// specified `FirebaseProject`. This object contains the details of the Google
	// Analytics property associated with the Project.
	AnalyticsProperty *AnalyticsProperty `json:"analyticsProperty,omitempty"`
	// StreamMappings:  - For `AndroidApps` and `IosApps`: a map of `app` to
	// `streamId` for each Firebase App in the specified `FirebaseProject`. Each
	// `app` and `streamId` appears only once. - For `WebApps`: a map of `app` to
	// `streamId` and `measurementId` for each `WebApp` in the specified
	// `FirebaseProject`. Each `app`, `streamId`, and `measurementId` appears only
	// once.
	StreamMappings []*StreamMapping `json:"streamMappings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalyticsProperty") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyticsProperty") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyticsDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyticsDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyticsProperty: Details of a Google Analytics property
type AnalyticsProperty struct {
	// AnalyticsAccountId: Output only. The ID of the Google Analytics account
	// (https://www.google.com/analytics/) for the Google Analytics property
	// associated with the specified FirebaseProject.
	AnalyticsAccountId string `json:"analyticsAccountId,omitempty"`
	// DisplayName: The display name of the Google Analytics property associated
	// with the specified `FirebaseProject`.
	DisplayName string `json:"displayName,omitempty"`
	// Id: The globally unique, Google-assigned identifier of the Google Analytics
	// property associated with the specified `FirebaseProject`. If you called
	// `AddGoogleAnalytics` (../../v1beta1/projects/addGoogleAnalytics) to link the
	// `FirebaseProject` with a Google Analytics account, the value in this `id`
	// field is the same as the ID of the property either specified or provisioned
	// with that call to `AddGoogleAnalytics`.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalyticsAccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyticsAccountId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyticsProperty) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyticsProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AndroidApp: Details of a Firebase App for Android.
type AndroidApp struct {
	// ApiKeyId: The globally unique, Google-assigned identifier (UID) for the
	// Firebase API key associated with the `AndroidApp`. Be aware that this value
	// is the UID of the API key, _not_ the `keyString`
	// (https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string)
	// of the API key. The `keyString` is the value that can be found in the App's
	// configuration artifact (../../rest/v1beta1/projects.androidApps/getConfig).
	// If `api_key_id` is not set in requests to `androidApps.Create`
	// (../../rest/v1beta1/projects.androidApps/create), then Firebase
	// automatically associates an `api_key_id` with the `AndroidApp`. This
	// auto-associated key may be an existing valid key or, if no valid key exists,
	// a new one will be provisioned. In patch requests, `api_key_id` cannot be set
	// to an empty value, and the new UID must have no restrictions or only have
	// restrictions that are valid for the associated `AndroidApp`. We recommend
	// using the Google Cloud Console
	// (https://console.cloud.google.com/apis/credentials) to manage API keys.
	ApiKeyId string `json:"apiKeyId,omitempty"`
	// AppId: Output only. Immutable. The globally unique, Firebase-assigned
	// identifier for the `AndroidApp`. This identifier should be treated as an
	// opaque token, as the data format is not specified.
	AppId string `json:"appId,omitempty"`
	// DisplayName: The user-assigned display name for the `AndroidApp`.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: This checksum is computed by the server based on the value of other
	// fields, and it may be sent with update requests to ensure the client has an
	// up-to-date value before proceeding. Learn more about `etag` in Google's
	// AIP-154 standard
	// (https://google.aip.dev/154#declarative-friendly-resources). This etag is
	// strongly validated.
	Etag string `json:"etag,omitempty"`
	// ExpireTime: Output only. If the App has been removed from the Project, this
	// is the timestamp of when the App is considered expired and will be
	// permanently deleted. After this time, the App cannot be undeleted (that is,
	// restored to the Project). This value is only provided if the App is in the
	// `DELETED` state.
	ExpireTime string `json:"expireTime,omitempty"`
	// Name: The resource name of the AndroidApp, in the format: projects/
	// PROJECT_IDENTIFIER/androidApps/APP_ID * PROJECT_IDENTIFIER: the parent
	// Project's `ProjectNumber`
	// (../projects#FirebaseProject.FIELDS.project_number) ***(recommended)*** or
	// its `ProjectId` (../projects#FirebaseProject.FIELDS.project_id). Learn more
	// about using project identifiers in Google's AIP 2510 standard
	// (https://google.aip.dev/cloud/2510). Note that the value for
	// PROJECT_IDENTIFIER in any response body will be the `ProjectId`. * APP_ID:
	// the globally unique, Firebase-assigned identifier for the App (see `appId`
	// (../projects.androidApps#AndroidApp.FIELDS.app_id)).
	Name string `json:"name,omitempty"`
	// PackageName: Immutable. The canonical package name of the Android app as
	// would appear in the Google Play Developer Console.
	PackageName string `json:"packageName,omitempty"`
	// ProjectId: Output only. Immutable. A user-assigned unique identifier of the
	// parent FirebaseProject for the `AndroidApp`.
	ProjectId string `json:"projectId,omitempty"`
	// Sha1Hashes: The SHA1 certificate hashes for the AndroidApp.
	Sha1Hashes []string `json:"sha1Hashes,omitempty"`
	// Sha256Hashes: The SHA256 certificate hashes for the AndroidApp.
	Sha256Hashes []string `json:"sha256Hashes,omitempty"`
	// State: Output only. The lifecycle state of the App.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The App is active.
	//   "DELETED" - The App has been soft-deleted. After an App has been in the
	// `DELETED` state for more than 30 days, it is considered expired and will be
	// permanently deleted. Up until this time, you can restore the App by calling
	// `Undelete` ([Android](projects.androidApps/undelete) |
	// [iOS](projects.iosApps/undelete) | [web](projects.webApps/undelete)).
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AndroidApp) MarshalJSON() ([]byte, error) {
	type NoMethod AndroidApp
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AndroidAppConfig: Configuration metadata of a single Firebase App for
// Android.
type AndroidAppConfig struct {
	// ConfigFileContents: The contents of the JSON configuration file.
	ConfigFileContents string `json:"configFileContents,omitempty"`
	// ConfigFilename: The filename that the configuration artifact for the
	// `AndroidApp` is typically saved as. For example: `google-services.json`
	ConfigFilename string `json:"configFilename,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConfigFileContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigFileContents") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AndroidAppConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AndroidAppConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultResources: **DEPRECATED.** _Auto-provisioning of these resources is
// changing, so this object no longer reliably provides information about the
// resources within the Project. Instead, retrieve information about each
// resource directly from its resource-specific API._ The default
// auto-provisioned resources associated with the Project.
type DefaultResources struct {
	// HostingSite: Output only. **DEPRECATED.** _Instead, find the name of the
	// default Firebase Hosting site using ListSites
	// (https://firebase.google.com/docs/reference/hosting/rest/v1beta1/projects.sites/list)
	// within the Firebase Hosting REST API. If the default Hosting site for the
	// Project has not yet been provisioned, the return might not contain a default
	// site._ The name of the default Firebase Hosting site, in the format:
	// PROJECT_ID Though rare, your `projectId` might already be used as the name
	// for an existing Hosting site in another project (learn more about creating
	// non-default, additional sites
	// (https://firebase.google.com/docs/hosting/multisites)). In these cases, your
	// `projectId` is appended with a hyphen then five alphanumeric characters to
	// create your default Hosting site name. For example, if your `projectId` is
	// `myproject123`, your default Hosting site name might be:
	// `myproject123-a5c16`
	HostingSite string `json:"hostingSite,omitempty"`
	// LocationId: Output only. **DEPRECATED.** _Instead, use product-specific REST
	// APIs to find the location of each resource in a Project. This field may not
	// be populated, especially for newly provisioned projects after October 30,
	// 2024._ The ID of the Project's "location for default Google Cloud resources"
	// (https://firebase.google.com/docs/projects/locations#default-cloud-location),
	// which are resources associated with Google App Engine. The location is one
	// of the available Google App Engine locations
	// (https://cloud.google.com/about/locations#region). This field is omitted if
	// the location for default Google Cloud resources has not been set.
	LocationId string `json:"locationId,omitempty"`
	// RealtimeDatabaseInstance: Output only. **DEPRECATED.** _Instead, find the
	// name of the default Realtime Database instance using the list endpoint
	// (https://firebase.google.com/docs/reference/rest/database/database-management/rest/v1beta/projects.locations.instances/list)
	// within the Firebase Realtime Database REST API. If the default Realtime
	// Database instance for a Project has not yet been provisioned, the return
	// might not contain a default instance._ The default Firebase Realtime
	// Database instance name, in the format: PROJECT_ID Though rare, your
	// `projectId` might already be used as the name for an existing Realtime
	// Database instance in another project (learn more about database sharding
	// (https://firebase.google.com/docs/database/usage/sharding)). In these cases,
	// your `projectId` is appended with a hyphen then five alphanumeric characters
	// to create your default Realtime Database instance name. For example, if your
	// `projectId` is `myproject123`, your default database instance name might be:
	// `myproject123-a5c16`
	RealtimeDatabaseInstance string `json:"realtimeDatabaseInstance,omitempty"`
	// StorageBucket: Output only. **DEPRECATED.** _Instead, find the name of the
	// default Cloud Storage for Firebase bucket using the list endpoint
	// (https://firebase.google.com/docs/reference/rest/storage/rest/v1beta/projects.buckets/list)
	// within the Cloud Storage for Firebase REST API. If the default bucket for
	// the Project has not yet been provisioned, the return might not contain a
	// default bucket._ The name of the default Cloud Storage for Firebase bucket,
	// in one of the following formats: * If provisioned _before_ October 30, 2024:
	// PROJECT_ID.firebasestorage.app * If provisioned _on or after_ October 30,
	// 2024: PROJECT_ID.firebasestorage.app
	StorageBucket string `json:"storageBucket,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HostingSite") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HostingSite") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefaultResources) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

type FinalizeDefaultLocationRequest struct {
	// LocationId: **DEPRECATED** The ID of the Project's "location for default
	// Google Cloud resources"
	// (https://firebase.google.com/docs/projects/locations#default-cloud-location),
	// which are resources associated with Google App Engine. The location must be
	// one of the available Google App Engine locations
	// (https://cloud.google.com/about/locations#region).
	LocationId string `json:"locationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FinalizeDefaultLocationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod FinalizeDefaultLocationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FirebaseAppInfo: A high-level summary of an App.
type FirebaseAppInfo struct {
	// ApiKeyId: The globally unique, Google-assigned identifier (UID) for the
	// Firebase API key associated with the App. Be aware that this value is the
	// UID of the API key, _not_ the `keyString`
	// (https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string)
	// of the API key. The `keyString` is the value that can be found in the App's
	// configuration artifact (`AndroidApp`
	// (../../rest/v1beta1/projects.androidApps/getConfig) | `IosApp`
	// (../../rest/v1beta1/projects.iosApps/getConfig) | `WebApp`
	// (../../rest/v1beta1/projects.webApps/getConfig)). If `api_key_id` is not set
	// in requests to create the App (`AndroidApp`
	// (../../rest/v1beta1/projects.androidApps/create) | `IosApp`
	// (../../rest/v1beta1/projects.iosApps/create) | `WebApp`
	// (../../rest/v1beta1/projects.webApps/create)), then Firebase automatically
	// associates an `api_key_id` with the App. This auto-associated key may be an
	// existing valid key or, if no valid key exists, a new one will be
	// provisioned.
	ApiKeyId string `json:"apiKeyId,omitempty"`
	// AppId: Output only. Immutable. The globally unique, Firebase-assigned
	// identifier for the `WebApp`. This identifier should be treated as an opaque
	// token, as the data format is not specified.
	AppId string `json:"appId,omitempty"`
	// DisplayName: The user-assigned display name of the Firebase App.
	DisplayName string `json:"displayName,omitempty"`
	// ExpireTime: Output only. If the App has been removed from the Project, this
	// is the timestamp of when the App is considered expired and will be
	// permanently deleted. After this time, the App cannot be undeleted (that is,
	// restored to the Project). This value is only provided if the App is in the
	// `DELETED` state.
	ExpireTime string `json:"expireTime,omitempty"`
	// Name: The resource name of the Firebase App, in the format:
	// projects/PROJECT_ID /iosApps/APP_ID or
	// projects/PROJECT_ID/androidApps/APP_ID or projects/
	// PROJECT_ID/webApps/APP_ID
	Name string `json:"name,omitempty"`
	// Namespace: Output only. Immutable. The platform-specific identifier of the
	// App. *Note:* For most use cases, use `appId`, which is the canonical,
	// globally unique identifier for referencing an App. This string is derived
	// from a native identifier for each platform: `packageName` for an
	// `AndroidApp`, `bundleId` for an `IosApp`, and `webId` for a `WebApp`. Its
	// contents should be treated as opaque, as the native identifier format may
	// change as platforms evolve. This string is only unique within a
	// `FirebaseProject` and its associated Apps.
	Namespace string `json:"namespace,omitempty"`
	// Platform: The platform of the Firebase App.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Unknown state. This is only used for
	// distinguishing unset values.
	//   "IOS" - The Firebase App is associated with iOS.
	//   "ANDROID" - The Firebase App is associated with Android.
	//   "WEB" - The Firebase App is associated with web.
	Platform string `json:"platform,omitempty"`
	// State: Output only. The lifecycle state of the App.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The App is active.
	//   "DELETED" - The App has been soft-deleted. After an App has been in the
	// `DELETED` state for more than 30 days, it is considered expired and will be
	// permanently deleted. Up until this time, you can restore the App by calling
	// `Undelete` ([Android](projects.androidApps/undelete) |
	// [iOS](projects.iosApps/undelete) | [web](projects.webApps/undelete)).
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FirebaseAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod FirebaseAppInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FirebaseProject: A `FirebaseProject` is the top-level Firebase entity. It is
// the container for Firebase Apps, Firebase Hosting sites, storage systems
// (Firebase Realtime Database, Cloud Firestore, Cloud Storage buckets), and
// other Firebase and Google Cloud resources. You create a `FirebaseProject` by
// calling AddFirebase and specifying an *existing* Google Cloud `Project`
// (https://cloud.google.com/resource-manager/reference/rest/v1/projects). This
// adds Firebase resources to the existing Google Cloud `Project`. Since a
// FirebaseProject is actually also a Google Cloud `Project`, a
// `FirebaseProject` has the same underlying Google Cloud identifiers
// (`projectNumber` and `projectId`). This allows for easy interop with Google
// APIs.
type FirebaseProject struct {
	// Annotations: A set of user-defined annotations for the FirebaseProject.
	// Learn more about annotations in Google's AIP-128 standard
	// (https://google.aip.dev/128#annotations). These annotations are intended
	// solely for developers and client-side tools. Firebase services will not
	// mutate this annotations set.
	Annotations map[string]string `json:"annotations,omitempty"`
	// DisplayName: The user-assigned display name of the Project.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: This checksum is computed by the server based on the value of other
	// fields, and it may be sent with update requests to ensure the client has an
	// up-to-date value before proceeding. Learn more about `etag` in Google's
	// AIP-154 standard
	// (https://google.aip.dev/154#declarative-friendly-resources). This etag is
	// strongly validated.
	Etag string `json:"etag,omitempty"`
	// Name: The resource name of the Project, in the format:
	// projects/PROJECT_IDENTIFIER PROJECT_IDENTIFIER: the Project's
	// `ProjectNumber` (../projects#FirebaseProject.FIELDS.project_number)
	// ***(recommended)*** or its `ProjectId`
	// (../projects#FirebaseProject.FIELDS.project_id). Learn more about using
	// project identifiers in Google's AIP 2510 standard
	// (https://google.aip.dev/cloud/2510). Note that the value for
	// PROJECT_IDENTIFIER in any response body will be the `ProjectId`.
	Name string `json:"name,omitempty"`
	// ProjectId: Output only. Immutable. A user-assigned unique identifier for the
	// Project. This identifier may appear in URLs or names for some Firebase
	// resources associated with the Project, but it should generally be treated as
	// a convenience alias to reference the Project.
	ProjectId string `json:"projectId,omitempty"`
	// ProjectNumber: Output only. Immutable. The globally unique, Google-assigned
	// canonical identifier for the Project. Use this identifier when configuring
	// integrations and/or making API calls to Firebase or third-party services.
	ProjectNumber int64 `json:"projectNumber,omitempty,string"`
	// Resources: Output only. **DEPRECATED.** _Auto-provisioning of these
	// resources is changing, so this object no longer reliably provides
	// information about the Project. Instead, retrieve information about each
	// resource directly from its resource-specific API._ The default Firebase
	// resources associated with the Project.
	Resources *DefaultResources `json:"resources,omitempty"`
	// State: Output only. The lifecycle state of the Project.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The Project is active.
	//   "DELETED" - The Project has been soft-deleted.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FirebaseProject) MarshalJSON() ([]byte, error) {
	type NoMethod FirebaseProject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IosApp: Details of a Firebase App for iOS.
type IosApp struct {
	// ApiKeyId: The globally unique, Google-assigned identifier (UID) for the
	// Firebase API key associated with the `IosApp`. Be aware that this value is
	// the UID of the API key, _not_ the `keyString`
	// (https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string)
	// of the API key. The `keyString` is the value that can be found in the App's
	// configuration artifact (../../rest/v1beta1/projects.iosApps/getConfig). If
	// `api_key_id` is not set in requests to `iosApps.Create`
	// (../../rest/v1beta1/projects.iosApps/create), then Firebase automatically
	// associates an `api_key_id` with the `IosApp`. This auto-associated key may
	// be an existing valid key or, if no valid key exists, a new one will be
	// provisioned. In patch requests, `api_key_id` cannot be set to an empty
	// value, and the new UID must have no restrictions or only have restrictions
	// that are valid for the associated `IosApp`. We recommend using the Google
	// Cloud Console (https://console.cloud.google.com/apis/credentials) to manage
	// API keys.
	ApiKeyId string `json:"apiKeyId,omitempty"`
	// AppId: Output only. Immutable. The globally unique, Firebase-assigned
	// identifier for the `IosApp`. This identifier should be treated as an opaque
	// token, as the data format is not specified.
	AppId string `json:"appId,omitempty"`
	// AppStoreId: The automatically generated Apple ID assigned to the iOS app by
	// Apple in the iOS App Store.
	AppStoreId string `json:"appStoreId,omitempty"`
	// BundleId: Immutable. The canonical bundle ID of the iOS app as it would
	// appear in the iOS AppStore.
	BundleId string `json:"bundleId,omitempty"`
	// DisplayName: The user-assigned display name for the `IosApp`.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: This checksum is computed by the server based on the value of other
	// fields, and it may be sent with update requests to ensure the client has an
	// up-to-date value before proceeding. Learn more about `etag` in Google's
	// AIP-154 standard
	// (https://google.aip.dev/154#declarative-friendly-resources). This etag is
	// strongly validated.
	Etag string `json:"etag,omitempty"`
	// ExpireTime: Output only. If the App has been removed from the Project, this
	// is the timestamp of when the App is considered expired and will be
	// permanently deleted. After this time, the App cannot be undeleted (that is,
	// restored to the Project). This value is only provided if the App is in the
	// `DELETED` state.
	ExpireTime string `json:"expireTime,omitempty"`
	// Name: The resource name of the IosApp, in the format:
	// projects/PROJECT_IDENTIFIER /iosApps/APP_ID * PROJECT_IDENTIFIER: the parent
	// Project's `ProjectNumber`
	// (../projects#FirebaseProject.FIELDS.project_number) ***(recommended)*** or
	// its `ProjectId` (../projects#FirebaseProject.FIELDS.project_id). Learn more
	// about using project identifiers in Google's AIP 2510 standard
	// (https://google.aip.dev/cloud/2510). Note that the value for
	// PROJECT_IDENTIFIER in any response body will be the `ProjectId`. * APP_ID:
	// the globally unique, Firebase-assigned identifier for the App (see `appId`
	// (../projects.iosApps#IosApp.FIELDS.app_id)).
	Name string `json:"name,omitempty"`
	// ProjectId: Output only. Immutable. A user-assigned unique identifier of the
	// parent FirebaseProject for the `IosApp`.
	ProjectId string `json:"projectId,omitempty"`
	// State: Output only. The lifecycle state of the App.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The App is active.
	//   "DELETED" - The App has been soft-deleted. After an App has been in the
	// `DELETED` state for more than 30 days, it is considered expired and will be
	// permanently deleted. Up until this time, you can restore the App by calling
	// `Undelete` ([Android](projects.androidApps/undelete) |
	// [iOS](projects.iosApps/undelete) | [web](projects.webApps/undelete)).
	State string `json:"state,omitempty"`
	// TeamId: The Apple Developer Team ID associated with the App in the App
	// Store.
	TeamId string `json:"teamId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IosApp) MarshalJSON() ([]byte, error) {
	type NoMethod IosApp
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IosAppConfig: Configuration metadata of a single Firebase App for iOS.
type IosAppConfig struct {
	// ConfigFileContents: The content of the XML configuration file.
	ConfigFileContents string `json:"configFileContents,omitempty"`
	// ConfigFilename: The filename that the configuration artifact for the
	// `IosApp` is typically saved as. For example: `GoogleService-Info.plist`
	ConfigFilename string `json:"configFilename,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConfigFileContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigFileContents") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IosAppConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IosAppConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListAndroidAppsResponse struct {
	// Apps: List of each `AndroidApp` associated with the specified
	// `FirebaseProject`.
	Apps []*AndroidApp `json:"apps,omitempty"`
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. If the string is empty, then this response is the
	// last page of results. This token can be used in a subsequent call to
	// `ListAndroidApps` to find the next group of Apps. Page tokens are
	// short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Apps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apps") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAndroidAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAndroidAppsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListAvailableLocationsResponse struct {
	// Locations: One page of results from a call to `ListAvailableLocations`.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. If the string is empty, then this response is the
	// last page of results and all available locations have been listed. This
	// token can be used in a subsequent call to `ListAvailableLocations` to find
	// more locations. Page tokens are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAvailableLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAvailableLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListAvailableProjectsResponse struct {
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. If the string is empty, then this response is the
	// last page of results. This token can be used in a subsequent calls to
	// `ListAvailableProjects` to find the next group of Projects. Page tokens are
	// short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ProjectInfo: The list of Google Cloud `Projects` which can have Firebase
	// resources added to them.
	ProjectInfo []*ProjectInfo `json:"projectInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAvailableProjectsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAvailableProjectsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListFirebaseProjectsResponse struct {
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. If the string is empty, then this response is the
	// last page of results. This token can be used in a subsequent calls to
	// `ListFirebaseProjects` to find the next group of Projects. Page tokens are
	// short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Results: One page of the list of Projects that are accessible to the caller.
	Results []*FirebaseProject `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFirebaseProjectsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFirebaseProjectsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListIosAppsResponse struct {
	// Apps: List of each `IosApp` associated with the specified `FirebaseProject`.
	Apps []*IosApp `json:"apps,omitempty"`
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. If the string is empty, then this response is the
	// last page of results. This token can be used in a subsequent call to
	// `ListIosApps` to find the next group of Apps. Page tokens are short-lived
	// and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Apps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apps") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListIosAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListIosAppsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListShaCertificatesResponse struct {
	// Certificates: The list of each `ShaCertificate` associated with the
	// `AndroidApp`.
	Certificates []*ShaCertificate `json:"certificates,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Certificates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Certificates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListShaCertificatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListShaCertificatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListWebAppsResponse struct {
	// Apps: List of each `WebApp` associated with the specified `FirebaseProject`.
	Apps []*WebApp `json:"apps,omitempty"`
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. If the string is empty, then this response is the
	// last page of results. This token can be used in a subsequent call to
	// `ListWebApps` to find the next group of Apps. Page tokens are short-lived
	// and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Apps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apps") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListWebAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListWebAppsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: **DEPRECATED.** _This Location is no longer used to determine
// Firebase resource locations. Instead, consult product documentation to
// determine valid locations for each resource used in your Project._ A
// "location for default Google Cloud resources"
// (https://firebase.google.com/docs/projects/locations#default-cloud-location)
// that can be selected for a FirebaseProject. These are resources associated
// with Google App Engine.
type Location struct {
	// Features: Products and services that are available in the location for
	// default Google Cloud resources.
	//
	// Possible values:
	//   "LOCATION_FEATURE_UNSPECIFIED" - Used internally for distinguishing unset
	// values and is not intended for external use.
	//   "FIRESTORE" - This location supports Cloud Firestore database instances.
	// Google App Engine is available in this location, so it can be a Project's
	// location for default Google Cloud resources.
	//   "DEFAULT_STORAGE" - This location supports default Cloud Storage buckets.
	// Google App Engine is available in this location, so it can be a Project's
	// location for default Google Cloud resources.
	//   "FUNCTIONS" - Cloud Functions for Firebase is available in this location.
	Features []string `json:"features,omitempty"`
	// LocationId: The ID of the Project's location for default Google Cloud
	// resources. It will be one of the available Google App Engine locations
	// (https://cloud.google.com/about/locations#region).
	LocationId string `json:"locationId,omitempty"`
	// Type: Indicates whether the location for default Google Cloud resources is a
	// regional or multi-regional location
	// (https://firebase.google.com/docs/projects/locations#types) for data
	// replication.
	//
	// Possible values:
	//   "LOCATION_TYPE_UNSPECIFIED" - Used internally for distinguishing unset
	// values and is not intended for external use.
	//   "REGIONAL" - The location is a regional location. Data in a regional
	// location is replicated in multiple zones within a region.
	//   "MULTI_REGIONAL" - The location is a multi-regional location. Data in a
	// multi-region location is replicated in multiple regions. Within each region,
	// data is replicated in multiple zones.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Features") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MessageSet: This is proto2's version of MessageSet.
type MessageSet struct {
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Describes the progress of an LRO. It is included in the
// `metadata` field of the `Operation`.
type OperationMetadata struct {
}

// ProductMetadata: Metadata about a long-running Product operation.
type ProductMetadata struct {
	// WarningMessages: List of warnings related to the associated operation.
	WarningMessages []string `json:"warningMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WarningMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WarningMessages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ProductMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProjectInfo: A reference to a Google Cloud `Project`.
type ProjectInfo struct {
	// DisplayName: The user-assigned display name of the Google Cloud `Project`,
	// for example: `My App`.
	DisplayName string `json:"displayName,omitempty"`
	// LocationId: **DEPRECATED** _Instead, use product-specific REST APIs to work
	// with the location of each resource in a Project. This field may not be
	// populated, especially for newly provisioned projects after October 30,
	// 2024._ The ID of the Project's "location for default Google Cloud resources"
	// (https://firebase.google.com/docs/projects/locations#default-cloud-location).
	// The location is one of the available Google App Engine locations
	// (https://cloud.google.com/about/locations#region). Not all Projects will
	// have this field populated. If it is not populated, it means that the Project
	// does not yet have a location for default Google Cloud resources.
	LocationId string `json:"locationId,omitempty"`
	// Project: The resource name of the Google Cloud `Project` to which Firebase
	// resources can be added, in the format: projects/PROJECT_IDENTIFIER Refer to
	// the `FirebaseProject` `name` (../projects#FirebaseProject.FIELDS.name) field
	// for details about PROJECT_IDENTIFIER values.
	Project string `json:"project,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProjectInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ProjectInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RemoveAnalyticsRequest struct {
	// AnalyticsPropertyId: Optional. The ID of the Google Analytics property
	// associated with the specified `FirebaseProject`. - If not set, then the
	// Google Analytics property that is currently associated with the specified
	// `FirebaseProject` is removed. - If set, and the specified `FirebaseProject`
	// is currently associated with a *different* Google Analytics property, then
	// the response is a `412 Precondition Failed` error.
	AnalyticsPropertyId string `json:"analyticsPropertyId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalyticsPropertyId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyticsPropertyId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveAnalyticsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveAnalyticsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RemoveAndroidAppRequest struct {
	// AllowMissing: If set to true, and the App is not found, the request will
	// succeed but no action will be taken on the server.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// Etag: Checksum provided in the AndroidApp resource. If provided, this
	// checksum ensures that the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// Immediate: Determines whether to _immediately_ delete the AndroidApp. If set
	// to true, the App is immediately deleted from the Project and cannot be
	// undeleted (that is, restored to the Project). If not set, defaults to false,
	// which means the App will be set to expire in 30 days. Within the 30 days,
	// the App may be restored to the Project using UndeleteAndroidApp.
	Immediate bool `json:"immediate,omitempty"`
	// ValidateOnly: If set to true, the request is only validated. The App will
	// _not_ be removed.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMissing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveAndroidAppRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveAndroidAppRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RemoveIosAppRequest struct {
	// AllowMissing: If set to true, and the App is not found, the request will
	// succeed but no action will be taken on the server.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// Etag: Checksum provided in the IosApp resource. If provided, this checksum
	// ensures that the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// Immediate: Determines whether to _immediately_ delete the IosApp. If set to
	// true, the App is immediately deleted from the Project and cannot be
	// undeleted (that is, restored to the Project). If not set, defaults to false,
	// which means the App will be set to expire in 30 days. Within the 30 days,
	// the App may be restored to the Project using UndeleteIosApp
	Immediate bool `json:"immediate,omitempty"`
	// ValidateOnly: If set to true, the request is only validated. The App will
	// _not_ be removed.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMissing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveIosAppRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveIosAppRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RemoveWebAppRequest struct {
	// AllowMissing: If set to true, and the App is not found, the request will
	// succeed but no action will be taken on the server.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// Etag: Checksum provided in the WebApp resource. If provided, this checksum
	// ensures that the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// Immediate: Determines whether to _immediately_ delete the WebApp. If set to
	// true, the App is immediately deleted from the Project and cannot be
	// undeleted (that is, restored to the Project). If not set, defaults to false,
	// which means the App will be set to expire in 30 days. Within the 30 days,
	// the App may be restored to the Project using UndeleteWebApp
	Immediate bool `json:"immediate,omitempty"`
	// ValidateOnly: If set to true, the request is only validated. The App will
	// _not_ be removed.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMissing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveWebAppRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveWebAppRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SearchFirebaseAppsResponse struct {
	// Apps: One page of results from a call to `SearchFirebaseApps`.
	Apps []*FirebaseAppInfo `json:"apps,omitempty"`
	// NextPageToken: If the result list is too large to fit in a single response,
	// then a token is returned. This token can be used in a subsequent calls to
	// `SearchFirebaseApps` to find the next group of Apps. Page tokens are
	// short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Apps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apps") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchFirebaseAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchFirebaseAppsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShaCertificate: A SHA-1 or SHA-256 certificate associated with the
// AndroidApp.
type ShaCertificate struct {
	// CertType: The type of SHA certificate encoded in the hash.
	//
	// Possible values:
	//   "SHA_CERTIFICATE_TYPE_UNSPECIFIED" - Unknown state. This is only used for
	// distinguishing unset values.
	//   "SHA_1" - Certificate is a SHA-1 type certificate.
	//   "SHA_256" - Certificate is a SHA-256 type certificate.
	CertType string `json:"certType,omitempty"`
	// Name: The resource name of the ShaCertificate for the AndroidApp, in the
	// format: projects/PROJECT_IDENTIFIER/androidApps/APP_ID/sha/SHA_HASH *
	// PROJECT_IDENTIFIER: the parent Project's `ProjectNumber`
	// (../projects#FirebaseProject.FIELDS.project_number) ***(recommended)*** or
	// its `ProjectId` (../projects#FirebaseProject.FIELDS.project_id). Learn more
	// about using project identifiers in Google's AIP 2510 standard
	// (https://google.aip.dev/cloud/2510). Note that the value for
	// PROJECT_IDENTIFIER in any response body will be the `ProjectId`. * APP_ID:
	// the globally unique, Firebase-assigned identifier for the App (see `appId`
	// (../projects.androidApps#AndroidApp.FIELDS.app_id)). * SHA_HASH: the
	// certificate hash for the App (see `shaHash`
	// (../projects.androidApps.sha#ShaCertificate.FIELDS.sha_hash)).
	Name string `json:"name,omitempty"`
	// ShaHash: The certificate hash for the `AndroidApp`.
	ShaHash string `json:"shaHash,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CertType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShaCertificate) MarshalJSON() ([]byte, error) {
	type NoMethod ShaCertificate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StatusProto: Wire-format for a Status object
type StatusProto struct {
	// CanonicalCode: The canonical error code (see codes.proto) that most closely
	// corresponds to this status. This may be missing, and in the common case of
	// the generic space, it definitely will be. copybara:strip_begin(b/383363683)
	// copybara:strip_end_and_replace optional int32 canonical_code = 6;
	CanonicalCode int64 `json:"canonicalCode,omitempty"`
	// Code: Numeric code drawn from the space specified below. Often, this is the
	// canonical error space, and code is drawn from google3/util/task/codes.proto
	// copybara:strip_begin(b/383363683) copybara:strip_end_and_replace optional
	// int32 code = 1;
	Code int64 `json:"code,omitempty"`
	// Message: Detail message copybara:strip_begin(b/383363683)
	// copybara:strip_end_and_replace optional string message = 3;
	Message string `json:"message,omitempty"`
	// MessageSet: message_set associates an arbitrary proto message with the
	// status. copybara:strip_begin(b/383363683) copybara:strip_end_and_replace
	// optional proto2.bridge.MessageSet message_set = 5;
	MessageSet *MessageSet `json:"messageSet,omitempty"`
	// Space: The following are usually only present when code != 0 Space to which
	// this status belongs copybara:strip_begin(b/383363683)
	// copybara:strip_end_and_replace optional string space = 2;
	Space string `json:"space,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanonicalCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanonicalCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StatusProto) MarshalJSON() ([]byte, error) {
	type NoMethod StatusProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StreamMapping: A mapping of a Firebase App to a Google Analytics data stream
type StreamMapping struct {
	// App: The resource name of the Firebase App associated with the Google
	// Analytics data stream, in the format:
	// projects/PROJECT_IDENTIFIER/androidApps/APP_ID or
	// projects/PROJECT_IDENTIFIER/iosApps/APP_ID or projects/PROJECT_IDENTIFIER
	// /webApps/APP_ID Refer to the `FirebaseProject` `name`
	// (../projects#FirebaseProject.FIELDS.name) field for details about
	// PROJECT_IDENTIFIER values.
	App string `json:"app,omitempty"`
	// MeasurementId: Applicable for Firebase Web Apps only. The unique
	// Google-assigned identifier of the Google Analytics web stream associated
	// with the Firebase Web App. Firebase SDKs use this ID to interact with Google
	// Analytics APIs. Learn more about this ID and Google Analytics web streams in
	// the Analytics documentation
	// (https://support.google.com/analytics/answer/9304153).
	MeasurementId string `json:"measurementId,omitempty"`
	// StreamId: The unique Google-assigned identifier of the Google Analytics data
	// stream associated with the Firebase App. Learn more about Google Analytics
	// data streams in the Analytics documentation
	// (https://support.google.com/analytics/answer/9303323).
	StreamId int64 `json:"streamId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "App") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "App") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StreamMapping) MarshalJSON() ([]byte, error) {
	type NoMethod StreamMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UndeleteAndroidAppRequest struct {
	// Etag: Checksum provided in the AndroidApp resource. If provided, this
	// checksum ensures that the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// ValidateOnly: If set to true, the request is only validated. The App will
	// _not_ be undeleted.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UndeleteAndroidAppRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UndeleteAndroidAppRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UndeleteIosAppRequest struct {
	// Etag: Checksum provided in the IosApp resource. If provided, this checksum
	// ensures that the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// ValidateOnly: If set to true, the request is only validated. The App will
	// _not_ be undeleted.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UndeleteIosAppRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UndeleteIosAppRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UndeleteWebAppRequest struct {
	// Etag: Checksum provided in the WebApp resource. If provided, this checksum
	// ensures that the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// ValidateOnly: If set to true, the request is only validated. The App will
	// _not_ be undeleted.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UndeleteWebAppRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UndeleteWebAppRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WebApp: Details of a Firebase App for the web.
type WebApp struct {
	// ApiKeyId: The globally unique, Google-assigned identifier (UID) for the
	// Firebase API key associated with the `WebApp`. Be aware that this value is
	// the UID of the API key, _not_ the `keyString`
	// (https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string)
	// of the API key. The `keyString` is the value that can be found in the App's
	// configuration artifact (../../rest/v1beta1/projects.webApps/getConfig). If
	// `api_key_id` is not set in requests to `webApps.Create`
	// (../../rest/v1beta1/projects.webApps/create), then Firebase automatically
	// associates an `api_key_id` with the `WebApp`. This auto-associated key may
	// be an existing valid key or, if no valid key exists, a new one will be
	// provisioned. In patch requests, `api_key_id` cannot be set to an empty
	// value, and the new UID must have no restrictions or only have restrictions
	// that are valid for the associated `WebApp`. We recommend using the Google
	// Cloud Console (https://console.cloud.google.com/apis/credentials) to manage
	// API keys.
	ApiKeyId string `json:"apiKeyId,omitempty"`
	// AppId: Output only. Immutable. The globally unique, Firebase-assigned
	// identifier for the `WebApp`. This identifier should be treated as an opaque
	// token, as the data format is not specified.
	AppId string `json:"appId,omitempty"`
	// AppUrls: The URLs where the `WebApp` is hosted.
	AppUrls []string `json:"appUrls,omitempty"`
	// DisplayName: The user-assigned display name for the `WebApp`.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: This checksum is computed by the server based on the value of other
	// fields, and it may be sent with update requests to ensure the client has an
	// up-to-date value before proceeding. Learn more about `etag` in Google's
	// AIP-154 standard
	// (https://google.aip.dev/154#declarative-friendly-resources). This etag is
	// strongly validated.
	Etag string `json:"etag,omitempty"`
	// ExpireTime: Output only. If the App has been removed from the Project, this
	// is the timestamp of when the App is considered expired and will be
	// permanently deleted. After this time, the App cannot be undeleted (that is,
	// restored to the Project). This value is only provided if the App is in the
	// `DELETED` state.
	ExpireTime string `json:"expireTime,omitempty"`
	// Name: The resource name of the WebApp, in the format:
	// projects/PROJECT_IDENTIFIER /webApps/APP_ID * PROJECT_IDENTIFIER: the parent
	// Project's `ProjectNumber`
	// (../projects#FirebaseProject.FIELDS.project_number) ***(recommended)*** or
	// its `ProjectId` (../projects#FirebaseProject.FIELDS.project_id). Learn more
	// about using project identifiers in Google's AIP 2510 standard
	// (https://google.aip.dev/cloud/2510). Note that the value for
	// PROJECT_IDENTIFIER in any response body will be the `ProjectId`. * APP_ID:
	// the globally unique, Firebase-assigned identifier for the App (see `appId`
	// (../projects.webApps#WebApp.FIELDS.app_id)).
	Name string `json:"name,omitempty"`
	// ProjectId: Output only. Immutable. A user-assigned unique identifier of the
	// parent FirebaseProject for the `WebApp`.
	ProjectId string `json:"projectId,omitempty"`
	// State: Output only. The lifecycle state of the App.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The App is active.
	//   "DELETED" - The App has been soft-deleted. After an App has been in the
	// `DELETED` state for more than 30 days, it is considered expired and will be
	// permanently deleted. Up until this time, you can restore the App by calling
	// `Undelete` ([Android](projects.androidApps/undelete) |
	// [iOS](projects.iosApps/undelete) | [web](projects.webApps/undelete)).
	State string `json:"state,omitempty"`
	// WebId: Output only. Immutable. A unique, Firebase-assigned identifier for
	// the `WebApp`. This identifier is only used to populate the `namespace` value
	// for the `WebApp`. For most use cases, use `appId` to identify or reference
	// the App. The `webId` value is only unique within a `FirebaseProject` and its
	// associated Apps.
	WebId string `json:"webId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WebApp) MarshalJSON() ([]byte, error) {
	type NoMethod WebApp
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WebAppConfig: Configuration metadata of a single Firebase App for the web.
type WebAppConfig struct {
	// ApiKey: The `keyString`
	// (https://cloud.google.com/api-keys/docs/reference/rest/v2/projects.locations.keys#Key.FIELDS.key_string)
	// of the API key associated with the `WebApp`. Note that this value is _not_
	// the `apiKeyId` (../projects.webApps#WebApp.FIELDS.api_key_id) (the UID) of
	// the API key associated with the `WebApp`.
	ApiKey string `json:"apiKey,omitempty"`
	// AppId: Immutable. The globally unique, Firebase-assigned identifier for the
	// `WebApp`.
	AppId string `json:"appId,omitempty"`
	// AuthDomain: The domain Firebase Auth configures for OAuth redirects, in the
	// format: PROJECT_ID.firebaseapp.com
	AuthDomain string `json:"authDomain,omitempty"`
	// DatabaseURL: **DEPRECATED.** _Instead, find the URL of the default Realtime
	// Database instance using the list endpoint
	// (https://firebase.google.com/docs/reference/rest/database/database-management/rest/v1beta/projects.locations.instances/list)
	// within the Firebase Realtime Database REST API. If the default instance for
	// the Project has not yet been provisioned, the return might not contain a
	// default instance. Note that the config that's generated for the Firebase
	// console or the Firebase CLI uses the Realtime Database endpoint to populate
	// this value for that config._ The URL of the default Firebase Realtime
	// Database instance.
	DatabaseURL string `json:"databaseURL,omitempty"`
	// LocationId: **DEPRECATED.** _Instead, use product-specific REST APIs to find
	// the location of each resource in a Project. This field may not be populated,
	// especially for newly provisioned projects after October 30, 2024._ The ID of
	// the Project's "location for default Google Cloud resources"
	// (https://firebase.google.com/docs/projects/locations#default-cloud-location),
	// which are resources associated with Google App Engine. The location is one
	// of the available App Engine locations
	// (https://cloud.google.com/about/locations#region). This field is omitted if
	// the location for default Google Cloud resources has not been set.
	LocationId string `json:"locationId,omitempty"`
	// MeasurementId: The unique Google-assigned identifier of the Google Analytics
	// web stream associated with the `WebApp`. Firebase SDKs use this ID to
	// interact with Google Analytics APIs. This field is only present if the
	// `WebApp` is linked to a web stream in a Google Analytics App + Web property.
	// Learn more about this ID and Google Analytics web streams in the Analytics
	// documentation (https://support.google.com/analytics/answer/9304153). To
	// generate a `measurementId` and link the `WebApp` with a Google Analytics web
	// stream, call `AddGoogleAnalytics`
	// (../../v1beta1/projects/addGoogleAnalytics). For apps using the Firebase
	// JavaScript SDK v7.20.0 and later, Firebase dynamically fetches the
	// `measurementId` when your app initializes Analytics. Having this ID in your
	// config object is optional, but it does serve as a fallback in the rare case
	// that the dynamic fetch fails.
	MeasurementId string `json:"measurementId,omitempty"`
	// MessagingSenderId: The sender ID for use with Firebase Cloud Messaging.
	MessagingSenderId string `json:"messagingSenderId,omitempty"`
	// ProjectId: Immutable. A user-assigned unique identifier for the
	// `FirebaseProject`.
	ProjectId string `json:"projectId,omitempty"`
	// ProjectNumber: Output only. Immutable. The globally unique, Google-assigned
	// canonical identifier for the Project. Use this identifier when configuring
	// integrations and/or making API calls to Google Cloud or third-party
	// services.
	ProjectNumber string `json:"projectNumber,omitempty"`
	// RealtimeDatabaseUrl: Optional. Duplicate field for the URL of the default
	// Realtime Database instances (if the default instance has been provisioned).
	// If the request asks for the V2 config format, this field will be populated
	// instead of `realtime_database_instance_uri`.
	RealtimeDatabaseUrl string `json:"realtimeDatabaseUrl,omitempty"`
	// StorageBucket: **DEPRECATED.** _Instead, find the name of the default Cloud
	// Storage for Firebase bucket using the list endpoint
	// (https://firebase.google.com/docs/reference/rest/storage/rest/v1beta/projects.buckets/list)
	// within the Cloud Storage for Firebase REST API. If the default bucket for
	// the Project has not yet been provisioned, the return might not contain a
	// default bucket. Note that the config that's generated for the Firebase
	// console or the Firebase CLI uses the Cloud Storage for Firebase endpoint to
	// populate this value for that config._ The name of the default Cloud Storage
	// for Firebase bucket.
	StorageBucket string `json:"storageBucket,omitempty"`
	// Version: Version of the config specification.
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WebAppConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WebAppConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AvailableProjectsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists each Google Cloud `Project`
// (https://cloud.google.com/resource-manager/reference/rest/v1/projects) that
// can have Firebase resources added and Firebase services enabled. A Project
// will only be listed if: - The caller has sufficient Google IAM
// (https://cloud.google.com/iam) permissions to call AddFirebase. - The
// Project is not already a FirebaseProject. - The Project is not in an
// Organization which has policies that prevent Firebase resources from being
// added.
func (r *AvailableProjectsService) List() *AvailableProjectsListCall {
	c := &AvailableProjectsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// Projects to return in the response. The server may return fewer than this
// value at its discretion. If no value is specified (or too large a value is
// specified), the server will impose its own limit. This value cannot be
// negative.
func (c *AvailableProjectsListCall) PageSize(pageSize int64) *AvailableProjectsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to `ListAvailableProjects` indicating where in the set of
// Projects to resume listing.
func (c *AvailableProjectsListCall) PageToken(pageToken string) *AvailableProjectsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AvailableProjectsListCall) Fields(s ...googleapi.Field) *AvailableProjectsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AvailableProjectsListCall) IfNoneMatch(entityTag string) *AvailableProjectsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AvailableProjectsListCall) Context(ctx context.Context) *AvailableProjectsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AvailableProjectsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AvailableProjectsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/availableProjects")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.availableProjects.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.availableProjects.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAvailableProjectsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AvailableProjectsListCall) Do(opts ...googleapi.CallOption) (*ListAvailableProjectsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAvailableProjectsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.availableProjects.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AvailableProjectsListCall) Pages(ctx context.Context, f func(*ListAvailableProjectsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *OperationsService) Get(name string) *OperationsGetCall {
	c := &OperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OperationsGetCall) Fields(s ...googleapi.Field) *OperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OperationsGetCall) IfNoneMatch(entityTag string) *OperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OperationsGetCall) Context(ctx context.Context) *OperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAddFirebaseCall struct {
	s                  *Service
	projectid          string
	addfirebaserequest *AddFirebaseRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// AddFirebase: Adds Firebase resources and enables Firebase services in the
// specified existing Google Cloud `Project`
// (https://cloud.google.com/resource-manager/reference/rest/v1/projects).
// Since a FirebaseProject is actually also a Google Cloud `Project`, a
// `FirebaseProject` has the same underlying Google Cloud identifiers
// (`projectNumber` and `projectId`). This allows for easy interop with Google
// APIs. The result of this call is an `Operation` (../../v1beta1/operations).
// Poll the `Operation` to track the provisioning process by calling
// GetOperation until `done` (../../v1beta1/operations#Operation.FIELDS.done)
// is `true`. When `done` is `true`, the `Operation` has either succeeded or
// failed. If the `Operation` succeeded, its `response`
// (../../v1beta1/operations#Operation.FIELDS.response) is set to a
// FirebaseProject; if the `Operation` failed, its `error`
// (../../v1beta1/operations#Operation.FIELDS.error) is set to a
// google.rpc.Status. The `Operation` is automatically deleted after
// completion, so there is no need to call DeleteOperation. This method does
// not modify any billing account information on the underlying Google Cloud
// `Project`. To call `AddFirebase`, a project member or service account must
// have the following permissions (the IAM roles of Editor and Owner contain
// these permissions): `firebase.projects.update`,
// `resourcemanager.projects.get`, `serviceusage.services.enable`, and
// `serviceusage.services.get`.
//
//   - project: The resource name of the Google Cloud `Project` in which Firebase
//     resources will be added and Firebase services enabled, in the format:
//     projects/ PROJECT_IDENTIFIER Refer to the `FirebaseProject` `name`
//     (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values. After calling `AddFirebase`, the unique Project
//     identifiers ( `projectNumber`
//     (https://cloud.google.com/resource-manager/reference/rest/v1/projects#Project.FIELDS.project_number)
//     and `projectId`
//     (https://cloud.google.com/resource-manager/reference/rest/v1/projects#Project.FIELDS.project_id))
//     of the underlying Google Cloud `Project` are also the identifiers of the
//     FirebaseProject.
func (r *ProjectsService) AddFirebase(projectid string, addfirebaserequest *AddFirebaseRequest) *ProjectsAddFirebaseCall {
	c := &ProjectsAddFirebaseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectid = projectid
	c.addfirebaserequest = addfirebaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAddFirebaseCall) Fields(s ...googleapi.Field) *ProjectsAddFirebaseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAddFirebaseCall) Context(ctx context.Context) *ProjectsAddFirebaseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAddFirebaseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAddFirebaseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addfirebaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+project}:addFirebase")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.projectid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.addFirebase", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.addFirebase" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAddFirebaseCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.addFirebase", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAddGoogleAnalyticsCall struct {
	s                         *Service
	parent                    string
	addgoogleanalyticsrequest *AddGoogleAnalyticsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// AddGoogleAnalytics: Links the specified FirebaseProject with an existing
// Google Analytics account (http://www.google.com/analytics/). Using this
// call, you can either: - Specify an `analyticsAccountId` to provision a new
// Google Analytics property within the specified account and associate the new
// property with the `FirebaseProject`. - Specify an existing
// `analyticsPropertyId` to associate the property with the `FirebaseProject`.
// Note that when you call `AddGoogleAnalytics`: 1. The first check determines
// if any existing data streams in the Google Analytics property correspond to
// any existing Firebase Apps in the `FirebaseProject` (based on the
// `packageName` or `bundleId` associated with the data stream). Then, as
// applicable, the data streams and apps are linked. Note that this
// auto-linking only applies to `AndroidApps` and `IosApps`. 2. If no
// corresponding data streams are found for the Firebase Apps, new data streams
// are provisioned in the Google Analytics property for each of the Firebase
// Apps. Note that a new data stream is always provisioned for a Web App even
// if it was previously associated with a data stream in the Analytics
// property. Learn more about the hierarchy and structure of Google Analytics
// accounts in the Analytics documentation
// (https://support.google.com/analytics/answer/9303323). The result of this
// call is an `Operation` (../../v1beta1/operations). Poll the `Operation` to
// track the provisioning process by calling GetOperation until `done`
// (../../v1beta1/operations#Operation.FIELDS.done) is `true`. When `done` is
// `true`, the `Operation` has either succeeded or failed. If the `Operation`
// succeeded, its `response`
// (../../v1beta1/operations#Operation.FIELDS.response) is set to an
// AnalyticsDetails; if the `Operation` failed, its `error`
// (../../v1beta1/operations#Operation.FIELDS.error) is set to a
// google.rpc.Status. To call `AddGoogleAnalytics`, a project member must be an
// Owner for the existing `FirebaseProject` and have the `Edit` permission
// (https://support.google.com/analytics/answer/2884495) for the Google
// Analytics account. If the `FirebaseProject` already has Google Analytics
// enabled, and you call `AddGoogleAnalytics` using an `analyticsPropertyId`
// that's different from the currently associated property, then the call will
// fail. Analytics may have already been enabled in the Firebase console or by
// specifying `timeZone` and `regionCode` in the call to `AddFirebase`
// (../../v1beta1/projects/addFirebase).
//
//   - parent: The resource name of the FirebaseProject to link to an existing
//     Google Analytics account, in the format: projects/PROJECT_IDENTIFIER Refer
//     to the `FirebaseProject` `name` (../projects#FirebaseProject.FIELDS.name)
//     field for details about PROJECT_IDENTIFIER values.
func (r *ProjectsService) AddGoogleAnalytics(parent string, addgoogleanalyticsrequest *AddGoogleAnalyticsRequest) *ProjectsAddGoogleAnalyticsCall {
	c := &ProjectsAddGoogleAnalyticsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.addgoogleanalyticsrequest = addgoogleanalyticsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAddGoogleAnalyticsCall) Fields(s ...googleapi.Field) *ProjectsAddGoogleAnalyticsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAddGoogleAnalyticsCall) Context(ctx context.Context) *ProjectsAddGoogleAnalyticsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAddGoogleAnalyticsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAddGoogleAnalyticsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addgoogleanalyticsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:addGoogleAnalytics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.addGoogleAnalytics", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.addGoogleAnalytics" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAddGoogleAnalyticsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.addGoogleAnalytics", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified FirebaseProject.
//
//   - name: The resource name of the FirebaseProject, in the format: projects/
//     PROJECT_IDENTIFIER Refer to the `FirebaseProject` `name`
//     (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values.
func (r *ProjectsService) Get(name string) *ProjectsGetCall {
	c := &ProjectsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetCall) Fields(s ...googleapi.Field) *ProjectsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetCall) IfNoneMatch(entityTag string) *ProjectsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetCall) Context(ctx context.Context) *ProjectsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FirebaseProject.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsGetCall) Do(opts ...googleapi.CallOption) (*FirebaseProject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FirebaseProject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGetAdminSdkConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAdminSdkConfig: Gets the configuration artifact associated with the
// specified FirebaseProject, which can be used by servers to simplify
// initialization. Typically, this configuration is used with the Firebase
// Admin SDK initializeApp
// (https://firebase.google.com/docs/admin/setup#initialize_the_sdk) command.
//
//   - name: The resource name of the FirebaseProject, in the format: projects/
//     PROJECT_IDENTIFIER/adminSdkConfig Refer to the `FirebaseProject` `name`
//     (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values.
func (r *ProjectsService) GetAdminSdkConfig(name string) *ProjectsGetAdminSdkConfigCall {
	c := &ProjectsGetAdminSdkConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetAdminSdkConfigCall) Fields(s ...googleapi.Field) *ProjectsGetAdminSdkConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetAdminSdkConfigCall) IfNoneMatch(entityTag string) *ProjectsGetAdminSdkConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetAdminSdkConfigCall) Context(ctx context.Context) *ProjectsGetAdminSdkConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetAdminSdkConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetAdminSdkConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.getAdminSdkConfig", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.getAdminSdkConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *AdminSdkConfig.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsGetAdminSdkConfigCall) Do(opts ...googleapi.CallOption) (*AdminSdkConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AdminSdkConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.getAdminSdkConfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGetAnalyticsDetailsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAnalyticsDetails: Gets the Google Analytics details currently associated
// with the specified FirebaseProject. If the `FirebaseProject` is not yet
// linked to Google Analytics, then the response to `GetAnalyticsDetails` is
// `NOT_FOUND`.
//
//   - name: The resource name of the FirebaseProject, in the format: projects/
//     PROJECT_IDENTIFIER/analyticsDetails Refer to the `FirebaseProject` `name`
//     (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values.
func (r *ProjectsService) GetAnalyticsDetails(name string) *ProjectsGetAnalyticsDetailsCall {
	c := &ProjectsGetAnalyticsDetailsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetAnalyticsDetailsCall) Fields(s ...googleapi.Field) *ProjectsGetAnalyticsDetailsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetAnalyticsDetailsCall) IfNoneMatch(entityTag string) *ProjectsGetAnalyticsDetailsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetAnalyticsDetailsCall) Context(ctx context.Context) *ProjectsGetAnalyticsDetailsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetAnalyticsDetailsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetAnalyticsDetailsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.getAnalyticsDetails", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.getAnalyticsDetails" call.
// Any non-2xx status code is an error. Response headers are in either
// *AnalyticsDetails.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsGetAnalyticsDetailsCall) Do(opts ...googleapi.CallOption) (*AnalyticsDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AnalyticsDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.getAnalyticsDetails", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists each FirebaseProject accessible to the caller. The elements are
// returned in no particular order, but they will be a consistent view of the
// Projects when additional requests are made with a `pageToken`. This method
// is eventually consistent with Project mutations, which means newly
// provisioned Projects and recent modifications to existing Projects might not
// be reflected in the set of Projects. The list will include only ACTIVE
// Projects. Use GetFirebaseProject for consistent reads as well as for
// additional Project details.
func (r *ProjectsService) List() *ProjectsListCall {
	c := &ProjectsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// Projects to return in the response. The server may return fewer than this at
// its discretion. If no value is specified (or too large a value is
// specified), the server will impose its own limit. This value cannot be
// negative.
func (c *ProjectsListCall) PageSize(pageSize int64) *ProjectsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to `ListFirebaseProjects` indicating where in the set of
// Projects to resume listing.
func (c *ProjectsListCall) PageToken(pageToken string) *ProjectsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Controls whether
// Projects in the DELETED state should be returned in the response. If not
// specified, only `ACTIVE` Projects will be returned.
func (c *ProjectsListCall) ShowDeleted(showDeleted bool) *ProjectsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsListCall) Fields(s ...googleapi.Field) *ProjectsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsListCall) IfNoneMatch(entityTag string) *ProjectsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsListCall) Context(ctx context.Context) *ProjectsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFirebaseProjectsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsListCall) Do(opts ...googleapi.CallOption) (*ListFirebaseProjectsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFirebaseProjectsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsListCall) Pages(ctx context.Context, f func(*ListFirebaseProjectsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsPatchCall struct {
	s               *Service
	nameid          string
	firebaseproject *FirebaseProject
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the attributes of the specified FirebaseProject. All query
// parameters (#query-parameters) are required.
//
//   - name: The resource name of the Project, in the format:
//     projects/PROJECT_IDENTIFIER PROJECT_IDENTIFIER: the Project's
//     `ProjectNumber` (../projects#FirebaseProject.FIELDS.project_number)
//     ***(recommended)*** or its `ProjectId`
//     (../projects#FirebaseProject.FIELDS.project_id). Learn more about using
//     project identifiers in Google's AIP 2510 standard
//     (https://google.aip.dev/cloud/2510). Note that the value for
//     PROJECT_IDENTIFIER in any response body will be the `ProjectId`.
func (r *ProjectsService) Patch(nameid string, firebaseproject *FirebaseProject) *ProjectsPatchCall {
	c := &ProjectsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.firebaseproject = firebaseproject
	return c
}

// UpdateMask sets the optional parameter "updateMask": Specifies which fields
// of the FirebaseProject to update. Note that the following fields are
// immutable: `name`, `project_id`, and `project_number`. To update `state`,
// use any of the following Google Cloud endpoints: `projects.delete`
// (https://cloud.google.com/resource-manager/reference/rest/v1/projects/delete)
// or `projects.undelete`
// (https://cloud.google.com/resource-manager/reference/rest/v1/projects/undelete)
func (c *ProjectsPatchCall) UpdateMask(updateMask string) *ProjectsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchCall) Fields(s ...googleapi.Field) *ProjectsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchCall) Context(ctx context.Context) *ProjectsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firebaseproject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *FirebaseProject.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsPatchCall) Do(opts ...googleapi.CallOption) (*FirebaseProject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FirebaseProject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRemoveAnalyticsCall struct {
	s                      *Service
	parent                 string
	removeanalyticsrequest *RemoveAnalyticsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// RemoveAnalytics: Unlinks the specified FirebaseProject from its Google
// Analytics account. This call removes the association of the specified
// `FirebaseProject` with its current Google Analytics property. However, this
// call does not delete the Google Analytics resources, such as the Google
// Analytics property or any data streams. These resources may be re-associated
// later to the `FirebaseProject` by calling `AddGoogleAnalytics`
// (../../v1beta1/projects/addGoogleAnalytics) and specifying the same
// `analyticsPropertyId`. For Android Apps and iOS Apps, this call re-links
// data streams with their corresponding apps. However, for Web Apps, this call
// provisions a *new* data stream for each Web App. To call `RemoveAnalytics`,
// a project member must be an Owner for the `FirebaseProject`.
//
//   - parent: The resource name of the FirebaseProject to unlink from its Google
//     Analytics account, in the format: projects/PROJECT_IDENTIFIER Refer to the
//     `FirebaseProject` `name` (../projects#FirebaseProject.FIELDS.name) field
//     for details about PROJECT_IDENTIFIER values.
func (r *ProjectsService) RemoveAnalytics(parent string, removeanalyticsrequest *RemoveAnalyticsRequest) *ProjectsRemoveAnalyticsCall {
	c := &ProjectsRemoveAnalyticsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.removeanalyticsrequest = removeanalyticsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRemoveAnalyticsCall) Fields(s ...googleapi.Field) *ProjectsRemoveAnalyticsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRemoveAnalyticsCall) Context(ctx context.Context) *ProjectsRemoveAnalyticsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRemoveAnalyticsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRemoveAnalyticsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removeanalyticsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:removeAnalytics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.removeAnalytics", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.removeAnalytics" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRemoveAnalyticsCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.removeAnalytics", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsSearchAppsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchApps: Lists all available Apps for the specified FirebaseProject. This
// is a convenience method. Typically, interaction with an App should be done
// using the platform-specific service, but some tool use-cases require a
// summary of all known Apps (such as for App selector interfaces).
//
//   - parent: The parent FirebaseProject for which to list Apps, in the format:
//     projects/ PROJECT_IDENTIFIER Refer to the `FirebaseProject` `name`
//     (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values.
func (r *ProjectsService) SearchApps(parent string) *ProjectsSearchAppsCall {
	c := &ProjectsSearchAppsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A query string compatible with
// Google's AIP-160 standard (https://google.aip.dev/160). Use any of the
// following fields in a query: * `app_id`
// (../projects/searchApps#FirebaseAppInfo.FIELDS.app_id) * `namespace`
// (../projects/searchApps#FirebaseAppInfo.FIELDS.namespace) * `platform`
// (../projects/searchApps#FirebaseAppInfo.FIELDS.platform) This query also
// supports the following "virtual" fields. These are fields which are not
// actually part of the returned resource object, but they can be queried as if
// they are pre-populated with specific values. * `sha1_hash` or `sha1_hashes`:
// This field is considered to be a _repeated_ `string` field, populated with
// the list of all SHA-1 certificate fingerprints registered with the
// AndroidApp. This list is empty if the App is not an `AndroidApp`. *
// `sha256_hash` or `sha256_hashes`: This field is considered to be a
// _repeated_ `string` field, populated with the list of all SHA-256
// certificate fingerprints registered with the AndroidApp. This list is empty
// if the App is not an `AndroidApp`. * `app_store_id`: This field is
// considered to be a _singular_ `string` field, populated with the Apple App
// Store ID registered with the IosApp. This field is empty if the App is not
// an `IosApp`. * `team_id`: This field is considered to be a _singular_
// `string` field, populated with the Apple team ID registered with the IosApp.
// This field is empty if the App is not an `IosApp`.
func (c *ProjectsSearchAppsCall) Filter(filter string) *ProjectsSearchAppsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of Apps
// to return in the response. The server may return fewer than this value at
// its discretion. If no value is specified (or too large a value is
// specified), then the server will impose its own limit. This value cannot be
// negative.
func (c *ProjectsSearchAppsCall) PageSize(pageSize int64) *ProjectsSearchAppsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to `SearchFirebaseApps` indicating where in the set of Apps to
// resume listing.
func (c *ProjectsSearchAppsCall) PageToken(pageToken string) *ProjectsSearchAppsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Controls whether Apps
// in the DELETED state should be returned. If not specified, only `ACTIVE`
// Apps will be returned.
func (c *ProjectsSearchAppsCall) ShowDeleted(showDeleted bool) *ProjectsSearchAppsCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsSearchAppsCall) Fields(s ...googleapi.Field) *ProjectsSearchAppsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsSearchAppsCall) IfNoneMatch(entityTag string) *ProjectsSearchAppsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsSearchAppsCall) Context(ctx context.Context) *ProjectsSearchAppsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsSearchAppsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsSearchAppsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:searchApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.searchApps", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.searchApps" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchFirebaseAppsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsSearchAppsCall) Do(opts ...googleapi.CallOption) (*SearchFirebaseAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchFirebaseAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.searchApps", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsSearchAppsCall) Pages(ctx context.Context, f func(*SearchFirebaseAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAndroidAppsCreateCall struct {
	s          *Service
	parent     string
	androidapp *AndroidApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Requests the creation of a new AndroidApp in the specified
// FirebaseProject. The result of this call is an `Operation` which can be used
// to track the provisioning process. The `Operation` is automatically deleted
// after completion, so there is no need to call `DeleteOperation`.
//
//   - parent: The resource name of the parent FirebaseProject in which to create
//     an AndroidApp, in the format: projects/PROJECT_IDENTIFIER/androidApps
//     Refer to the `FirebaseProject` `name`
//     (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values.
func (r *ProjectsAndroidAppsService) Create(parent string, androidapp *AndroidApp) *ProjectsAndroidAppsCreateCall {
	c := &ProjectsAndroidAppsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.androidapp = androidapp
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsCreateCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsCreateCall) Context(ctx context.Context) *ProjectsAndroidAppsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.androidapp)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/androidApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAndroidAppsGetCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified AndroidApp.
//
//   - name: The resource name of the AndroidApp, in the format: projects/
//     PROJECT_IDENTIFIER/androidApps/APP_ID Since an APP_ID is a unique
//     identifier, the Unique Resource from Sub-Collection access pattern may be
//     used here, in the format: projects/-/androidApps/APP_ID Refer to the
//     `AndroidApp` `name` (../projects.androidApps#AndroidApp.FIELDS.name) field
//     for details about PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsAndroidAppsService) Get(nameid string) *ProjectsAndroidAppsGetCall {
	c := &ProjectsAndroidAppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsGetCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAndroidAppsGetCall) IfNoneMatch(entityTag string) *ProjectsAndroidAppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsGetCall) Context(ctx context.Context) *ProjectsAndroidAppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AndroidApp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsGetCall) Do(opts ...googleapi.CallOption) (*AndroidApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AndroidApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAndroidAppsGetConfigCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetConfig: Gets the configuration artifact associated with the specified
// AndroidApp.
//
//   - name: The resource name of the AndroidApp configuration to download, in
//     the format: projects/PROJECT_IDENTIFIER/androidApps/APP_ID/config Since an
//     APP_ID is a unique identifier, the Unique Resource from Sub-Collection
//     access pattern may be used here, in the format:
//     projects/-/androidApps/APP_ID Refer to the `AndroidApp` `name`
//     (../projects.androidApps#AndroidApp.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsAndroidAppsService) GetConfig(nameid string) *ProjectsAndroidAppsGetConfigCall {
	c := &ProjectsAndroidAppsGetConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsGetConfigCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsGetConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAndroidAppsGetConfigCall) IfNoneMatch(entityTag string) *ProjectsAndroidAppsGetConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsGetConfigCall) Context(ctx context.Context) *ProjectsAndroidAppsGetConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsGetConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsGetConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.getConfig", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.getConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *AndroidAppConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAndroidAppsGetConfigCall) Do(opts ...googleapi.CallOption) (*AndroidAppConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AndroidAppConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.getConfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAndroidAppsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists each AndroidApp associated with the specified FirebaseProject.
// The elements are returned in no particular order, but will be a consistent
// view of the Apps when additional requests are made with a `pageToken`.
//
//   - parent: The resource name of the parent FirebaseProject for which to list
//     each associated AndroidApp, in the format: projects/PROJECT_IDENTIFIER
//     /androidApps Refer to the `FirebaseProject` `name`
//     (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values.
func (r *ProjectsAndroidAppsService) List(parent string) *ProjectsAndroidAppsListCall {
	c := &ProjectsAndroidAppsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of Apps
// to return in the response. The server may return fewer than this at its
// discretion. If no value is specified (or too large a value is specified),
// then the server will impose its own limit.
func (c *ProjectsAndroidAppsListCall) PageSize(pageSize int64) *ProjectsAndroidAppsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to `ListAndroidApps` indicating where in the set of Apps to
// resume listing.
func (c *ProjectsAndroidAppsListCall) PageToken(pageToken string) *ProjectsAndroidAppsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Controls whether Apps
// in the DELETED state should be returned in the response. If not specified,
// only `ACTIVE` Apps will be returned.
func (c *ProjectsAndroidAppsListCall) ShowDeleted(showDeleted bool) *ProjectsAndroidAppsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsListCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAndroidAppsListCall) IfNoneMatch(entityTag string) *ProjectsAndroidAppsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsListCall) Context(ctx context.Context) *ProjectsAndroidAppsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/androidApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAndroidAppsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsListCall) Do(opts ...googleapi.CallOption) (*ListAndroidAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAndroidAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAndroidAppsListCall) Pages(ctx context.Context, f func(*ListAndroidAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAndroidAppsPatchCall struct {
	s          *Service
	nameid     string
	androidapp *AndroidApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the attributes of the specified AndroidApp.
//
//   - name: The resource name of the AndroidApp, in the format: projects/
//     PROJECT_IDENTIFIER/androidApps/APP_ID * PROJECT_IDENTIFIER: the parent
//     Project's `ProjectNumber`
//     (../projects#FirebaseProject.FIELDS.project_number) ***(recommended)*** or
//     its `ProjectId` (../projects#FirebaseProject.FIELDS.project_id). Learn
//     more about using project identifiers in Google's AIP 2510 standard
//     (https://google.aip.dev/cloud/2510). Note that the value for
//     PROJECT_IDENTIFIER in any response body will be the `ProjectId`. * APP_ID:
//     the globally unique, Firebase-assigned identifier for the App (see `appId`
//     (../projects.androidApps#AndroidApp.FIELDS.app_id)).
func (r *ProjectsAndroidAppsService) Patch(nameid string, androidapp *AndroidApp) *ProjectsAndroidAppsPatchCall {
	c := &ProjectsAndroidAppsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.androidapp = androidapp
	return c
}

// UpdateMask sets the optional parameter "updateMask": Specifies which fields
// of the AndroidApp to update. Note that the following fields are immutable:
// `name`, `app_id`, `project_id`, and `package_name`. To update `state`, use
// any of the following endpoints: RemoveAndroidApp or UndeleteAndroidApp.
func (c *ProjectsAndroidAppsPatchCall) UpdateMask(updateMask string) *ProjectsAndroidAppsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsPatchCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsPatchCall) Context(ctx context.Context) *ProjectsAndroidAppsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.androidapp)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AndroidApp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsPatchCall) Do(opts ...googleapi.CallOption) (*AndroidApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AndroidApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAndroidAppsRemoveCall struct {
	s                       *Service
	nameid                  string
	removeandroidapprequest *RemoveAndroidAppRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Remove: Removes the specified AndroidApp from the FirebaseProject.
//
//   - name: The resource name of the AndroidApp, in the format: projects/
//     PROJECT_IDENTIFIER/androidApps/APP_ID Since an APP_ID is a unique
//     identifier, the Unique Resource from Sub-Collection access pattern may be
//     used here, in the format: projects/-/androidApps/APP_ID Refer to the
//     AndroidApp name (../projects.androidApps#AndroidApp.FIELDS.name) field for
//     details about PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsAndroidAppsService) Remove(nameid string, removeandroidapprequest *RemoveAndroidAppRequest) *ProjectsAndroidAppsRemoveCall {
	c := &ProjectsAndroidAppsRemoveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.removeandroidapprequest = removeandroidapprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsRemoveCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsRemoveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsRemoveCall) Context(ctx context.Context) *ProjectsAndroidAppsRemoveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsRemoveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsRemoveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removeandroidapprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:remove")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.remove", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.remove" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsRemoveCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.remove", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAndroidAppsUndeleteCall struct {
	s                         *Service
	nameid                    string
	undeleteandroidapprequest *UndeleteAndroidAppRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Undelete: Restores the specified AndroidApp to the FirebaseProject.
//
//   - name: The resource name of the AndroidApp, in the format: projects/
//     PROJECT_IDENTIFIER/androidApps/APP_ID Since an APP_ID is a unique
//     identifier, the Unique Resource from Sub-Collection access pattern may be
//     used here, in the format: projects/-/androidApps/APP_ID Refer to the
//     AndroidApp name (../projects.androidApps#AndroidApp.FIELDS.name) field for
//     details about PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsAndroidAppsService) Undelete(nameid string, undeleteandroidapprequest *UndeleteAndroidAppRequest) *ProjectsAndroidAppsUndeleteCall {
	c := &ProjectsAndroidAppsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.undeleteandroidapprequest = undeleteandroidapprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsUndeleteCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsUndeleteCall) Context(ctx context.Context) *ProjectsAndroidAppsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.undeleteandroidapprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.undelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.undelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsUndeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.undelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAndroidAppsShaCreateCall struct {
	s              *Service
	parentid       string
	shacertificate *ShaCertificate
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Adds a ShaCertificate to the specified AndroidApp.
//
//   - parent: The resource name of the parent AndroidApp to which to add a
//     ShaCertificate, in the format: projects/PROJECT_IDENTIFIER/androidApps/
//     APP_ID Since an APP_ID is a unique identifier, the Unique Resource from
//     Sub-Collection access pattern may be used here, in the format:
//     projects/-/androidApps/APP_ID Refer to the `AndroidApp` `name`
//     (../projects.androidApps#AndroidApp.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsAndroidAppsShaService) Create(parentid string, shacertificate *ShaCertificate) *ProjectsAndroidAppsShaCreateCall {
	c := &ProjectsAndroidAppsShaCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.shacertificate = shacertificate
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsShaCreateCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsShaCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsShaCreateCall) Context(ctx context.Context) *ProjectsAndroidAppsShaCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsShaCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsShaCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.shacertificate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/sha")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.sha.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.sha.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *ShaCertificate.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsShaCreateCall) Do(opts ...googleapi.CallOption) (*ShaCertificate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ShaCertificate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.sha.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAndroidAppsShaDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a ShaCertificate from the specified AndroidApp.
//
//   - name: The resource name of the ShaCertificate to remove from the parent
//     AndroidApp, in the format: projects/PROJECT_IDENTIFIER/androidApps/APP_ID
//     /sha/SHA_HASH Refer to the `ShaCertificate` `name`
//     (../projects.androidApps.sha#ShaCertificate.FIELDS.name) field for details
//     about PROJECT_IDENTIFIER, APP_ID, and SHA_HASH values. You can obtain the
//     full resource name of the `ShaCertificate` from the response of
//     `ListShaCertificates` (../projects.androidApps.sha/list) or the original
//     `CreateShaCertificate` (../projects.androidApps.sha/create).
func (r *ProjectsAndroidAppsShaService) Delete(name string) *ProjectsAndroidAppsShaDeleteCall {
	c := &ProjectsAndroidAppsShaDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsShaDeleteCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsShaDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsShaDeleteCall) Context(ctx context.Context) *ProjectsAndroidAppsShaDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsShaDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsShaDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.sha.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.sha.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsShaDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.sha.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAndroidAppsShaListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the SHA-1 and SHA-256 certificates for the specified AndroidApp.
//
//   - parent: The resource name of the parent AndroidApp for which to list each
//     associated ShaCertificate, in the format: projects/PROJECT_IDENTIFIER
//     /androidApps/APP_ID Since an APP_ID is a unique identifier, the Unique
//     Resource from Sub-Collection access pattern may be used here, in the
//     format: projects/-/androidApps/APP_ID Refer to the `AndroidApp` `name`
//     (../projects.androidApps#AndroidApp.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsAndroidAppsShaService) List(parentid string) *ProjectsAndroidAppsShaListCall {
	c := &ProjectsAndroidAppsShaListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAndroidAppsShaListCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsShaListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAndroidAppsShaListCall) IfNoneMatch(entityTag string) *ProjectsAndroidAppsShaListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAndroidAppsShaListCall) Context(ctx context.Context) *ProjectsAndroidAppsShaListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAndroidAppsShaListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsShaListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/sha")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.sha.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.sha.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListShaCertificatesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsShaListCall) Do(opts ...googleapi.CallOption) (*ListShaCertificatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListShaCertificatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.androidApps.sha.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAvailableLocationsListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: **DECOMMISSIONED.** **If called, this endpoint will return a 404
// error.** _Instead, use the applicable resource-specific REST API (or
// associated documentation, as needed) to determine valid locations for each
// resource used in your Project._ Lists the valid "locations for default
// Google Cloud resources"
// (https://firebase.google.com/docs/projects/locations#default-cloud-location)
// for the specified Project (including a FirebaseProject). One of these
// locations can be selected as the Project's location for default Google Cloud
// resources, which is the geographical location where the Project's resources
// associated with Google App Engine (such as the default Cloud Firestore
// instance) will be provisioned by default. However, if the location for
// default Google Cloud resources has already been set for the Project, then
// this setting cannot be changed. This call checks for any possible location
// restrictions
// (https://cloud.google.com/resource-manager/docs/organization-policy/defining-locations)
// for the specified Project and, thus, might return a subset of all possible
// locations. To list all locations (regardless of any restrictions), call the
// endpoint without specifying a unique project identifier (that is,
// `/v1beta1/{parent=projects/-}/listAvailableLocations`). To call
// `ListAvailableLocations` with a specified project, a member must be at
// minimum a Viewer of the Project. Calls without a specified project do not
// require any specific project permissions.
//
//   - parent: The FirebaseProject for which to list locations for default Google
//     Cloud resources
//     (https://firebase.google.com/docs/projects/locations#default-cloud-location),
//     in the format: projects/PROJECT_IDENTIFIER Refer to the `FirebaseProject`
//     `name` (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values. If no unique project identifier is specified
//     (that is, `projects/-`), the returned list does not take into account
//     org-specific or project-specific location restrictions.
func (r *ProjectsAvailableLocationsService) List(parentid string) *ProjectsAvailableLocationsListCall {
	c := &ProjectsAvailableLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// locations to return in the response. The server may return fewer than this
// value at its discretion. If no value is specified (or too large a value is
// specified), then the server will impose its own limit. This value cannot be
// negative.
func (c *ProjectsAvailableLocationsListCall) PageSize(pageSize int64) *ProjectsAvailableLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to `ListAvailableLocations` indicating where in the list of
// locations to resume listing.
func (c *ProjectsAvailableLocationsListCall) PageToken(pageToken string) *ProjectsAvailableLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAvailableLocationsListCall) Fields(s ...googleapi.Field) *ProjectsAvailableLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAvailableLocationsListCall) IfNoneMatch(entityTag string) *ProjectsAvailableLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAvailableLocationsListCall) Context(ctx context.Context) *ProjectsAvailableLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAvailableLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAvailableLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/availableLocations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.availableLocations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.availableLocations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAvailableLocationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAvailableLocationsListCall) Do(opts ...googleapi.CallOption) (*ListAvailableLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAvailableLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.availableLocations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAvailableLocationsListCall) Pages(ctx context.Context, f func(*ListAvailableLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDefaultLocationFinalizeCall struct {
	s                              *Service
	parent                         string
	finalizedefaultlocationrequest *FinalizeDefaultLocationRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Finalize: **DECOMMISSIONED.** **If called, this endpoint will return a 404
// error.** _Instead, use the applicable resource-specific REST API to set the
// location for each resource used in your Project._ Sets the "location for
// default Google Cloud resources"
// (https://firebase.google.com/docs/projects/locations#default-cloud-location)
// for the specified FirebaseProject. This method creates a Google App Engine
// application with a default Cloud Storage bucket
// (https://cloud.google.com/appengine/docs/standard/python/googlecloudstorageclient/setting-up-cloud-storage#activating_a_cloud_storage_bucket),
// located in the specified `locationId`
// (#body.request_body.FIELDS.location_id). This location must be one of the
// available App Engine locations
// (https://cloud.google.com/about/locations#region). After the location for
// default Google Cloud resources is finalized, or if it was already set, it
// cannot be changed. The location for default Google Cloud resources for the
// specified `FirebaseProject` might already be set because either the
// underlying Google Cloud `Project` already has an App Engine application or
// `FinalizeDefaultLocation` was previously called with a specified
// `locationId`. The result of this call is an `Operation`
// (../../v1beta1/operations), which can be used to track the provisioning
// process. The `response` (../../v1beta1/operations#Operation.FIELDS.response)
// type of the `Operation` is google.protobuf.Empty. The `Operation` can be
// polled by its `name` using GetOperation until `done` is true. When `done` is
// true, the `Operation` has either succeeded or failed. If the `Operation` has
// succeeded, its `response`
// (../../v1beta1/operations#Operation.FIELDS.response) will be set to a
// google.protobuf.Empty; if the `Operation` has failed, its `error` will be
// set to a google.rpc.Status. The `Operation` is automatically deleted after
// completion, so there is no need to call DeleteOperation. All fields listed
// in the request body (#request-body) are required. To call
// `FinalizeDefaultLocation`, a member must be an Owner of the Project.
//
//   - parent: The resource name of the FirebaseProject for which the "location
//     for default Google Cloud resources"
//     (https://firebase.google.com/docs/projects/locations#default-cloud-location)
//     will be set, in the format: projects/PROJECT_IDENTIFIER Refer to the
//     `FirebaseProject` `name` (../projects#FirebaseProject.FIELDS.name) field
//     for details about PROJECT_IDENTIFIER values.
func (r *ProjectsDefaultLocationService) Finalize(parent string, finalizedefaultlocationrequest *FinalizeDefaultLocationRequest) *ProjectsDefaultLocationFinalizeCall {
	c := &ProjectsDefaultLocationFinalizeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.finalizedefaultlocationrequest = finalizedefaultlocationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDefaultLocationFinalizeCall) Fields(s ...googleapi.Field) *ProjectsDefaultLocationFinalizeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDefaultLocationFinalizeCall) Context(ctx context.Context) *ProjectsDefaultLocationFinalizeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDefaultLocationFinalizeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDefaultLocationFinalizeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.finalizedefaultlocationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/defaultLocation:finalize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.defaultLocation.finalize", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.defaultLocation.finalize" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDefaultLocationFinalizeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.defaultLocation.finalize", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsIosAppsCreateCall struct {
	s          *Service
	parent     string
	iosapp     *IosApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Requests the creation of a new IosApp in the specified
// FirebaseProject. The result of this call is an `Operation` which can be used
// to track the provisioning process. The `Operation` is automatically deleted
// after completion, so there is no need to call `DeleteOperation`.
//
//   - parent: The resource name of the parent FirebaseProject in which to create
//     an IosApp, in the format: projects/PROJECT_IDENTIFIER/iosApps Refer to the
//     `FirebaseProject` `name` (../projects#FirebaseProject.FIELDS.name) field
//     for details about PROJECT_IDENTIFIER values.
func (r *ProjectsIosAppsService) Create(parent string, iosapp *IosApp) *ProjectsIosAppsCreateCall {
	c := &ProjectsIosAppsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.iosapp = iosapp
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsIosAppsCreateCall) Fields(s ...googleapi.Field) *ProjectsIosAppsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsIosAppsCreateCall) Context(ctx context.Context) *ProjectsIosAppsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsIosAppsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.iosapp)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/iosApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsIosAppsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsIosAppsGetCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified IosApp.
//
//   - name: The resource name of the IosApp, in the format:
//     projects/PROJECT_IDENTIFIER /iosApps/APP_ID Since an APP_ID is a unique
//     identifier, the Unique Resource from Sub-Collection access pattern may be
//     used here, in the format: projects/-/iosApps/APP_ID Refer to the `IosApp`
//     `name` (../projects.iosApps#IosApp.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsIosAppsService) Get(nameid string) *ProjectsIosAppsGetCall {
	c := &ProjectsIosAppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsIosAppsGetCall) Fields(s ...googleapi.Field) *ProjectsIosAppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsIosAppsGetCall) IfNoneMatch(entityTag string) *ProjectsIosAppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsIosAppsGetCall) Context(ctx context.Context) *ProjectsIosAppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsIosAppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *IosApp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsIosAppsGetCall) Do(opts ...googleapi.CallOption) (*IosApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IosApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsIosAppsGetConfigCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetConfig: Gets the configuration artifact associated with the specified
// IosApp.
//
//   - name: The resource name of the App configuration to download, in the
//     format: projects/PROJECT_IDENTIFIER/iosApps/APP_ID/config Since an APP_ID
//     is a unique identifier, the Unique Resource from Sub-Collection access
//     pattern may be used here, in the format: projects/-/iosApps/APP_ID Refer
//     to the `IosApp` `name` (../projects.iosApps#IosApp.FIELDS.name) field for
//     details about PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsIosAppsService) GetConfig(nameid string) *ProjectsIosAppsGetConfigCall {
	c := &ProjectsIosAppsGetConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsIosAppsGetConfigCall) Fields(s ...googleapi.Field) *ProjectsIosAppsGetConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsIosAppsGetConfigCall) IfNoneMatch(entityTag string) *ProjectsIosAppsGetConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsIosAppsGetConfigCall) Context(ctx context.Context) *ProjectsIosAppsGetConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsIosAppsGetConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsGetConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.getConfig", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.getConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *IosAppConfig.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsIosAppsGetConfigCall) Do(opts ...googleapi.CallOption) (*IosAppConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IosAppConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.getConfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsIosAppsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists each IosApp associated with the specified FirebaseProject. The
// elements are returned in no particular order, but will be a consistent view
// of the Apps when additional requests are made with a `pageToken`.
//
//   - parent: The resource name of the parent FirebaseProject for which to list
//     each associated IosApp, in the format: projects/PROJECT_IDENTIFIER/iosApps
//     Refer to the `FirebaseProject` `name`
//     (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values.
func (r *ProjectsIosAppsService) List(parent string) *ProjectsIosAppsListCall {
	c := &ProjectsIosAppsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of Apps
// to return in the response. The server may return fewer than this at its
// discretion. If no value is specified (or too large a value is specified),
// the server will impose its own limit.
func (c *ProjectsIosAppsListCall) PageSize(pageSize int64) *ProjectsIosAppsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to `ListIosApps` indicating where in the set of Apps to resume
// listing.
func (c *ProjectsIosAppsListCall) PageToken(pageToken string) *ProjectsIosAppsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Controls whether Apps
// in the DELETED state should be returned in the response. If not specified,
// only `ACTIVE` Apps will be returned.
func (c *ProjectsIosAppsListCall) ShowDeleted(showDeleted bool) *ProjectsIosAppsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsIosAppsListCall) Fields(s ...googleapi.Field) *ProjectsIosAppsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsIosAppsListCall) IfNoneMatch(entityTag string) *ProjectsIosAppsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsIosAppsListCall) Context(ctx context.Context) *ProjectsIosAppsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsIosAppsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/iosApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListIosAppsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsIosAppsListCall) Do(opts ...googleapi.CallOption) (*ListIosAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListIosAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsIosAppsListCall) Pages(ctx context.Context, f func(*ListIosAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsIosAppsPatchCall struct {
	s          *Service
	nameid     string
	iosapp     *IosApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the attributes of the specified IosApp.
//
//   - name: The resource name of the IosApp, in the format:
//     projects/PROJECT_IDENTIFIER /iosApps/APP_ID * PROJECT_IDENTIFIER: the
//     parent Project's `ProjectNumber`
//     (../projects#FirebaseProject.FIELDS.project_number) ***(recommended)*** or
//     its `ProjectId` (../projects#FirebaseProject.FIELDS.project_id). Learn
//     more about using project identifiers in Google's AIP 2510 standard
//     (https://google.aip.dev/cloud/2510). Note that the value for
//     PROJECT_IDENTIFIER in any response body will be the `ProjectId`. * APP_ID:
//     the globally unique, Firebase-assigned identifier for the App (see `appId`
//     (../projects.iosApps#IosApp.FIELDS.app_id)).
func (r *ProjectsIosAppsService) Patch(nameid string, iosapp *IosApp) *ProjectsIosAppsPatchCall {
	c := &ProjectsIosAppsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.iosapp = iosapp
	return c
}

// UpdateMask sets the optional parameter "updateMask": Specifies which fields
// of the IosApp to update. Note that the following fields are immutable:
// `name`, `app_id`, `project_id`, and `bundle_id`. To update `state`, use any
// of the following endpoints: RemoveIosApp or UndeleteIosApp.
func (c *ProjectsIosAppsPatchCall) UpdateMask(updateMask string) *ProjectsIosAppsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsIosAppsPatchCall) Fields(s ...googleapi.Field) *ProjectsIosAppsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsIosAppsPatchCall) Context(ctx context.Context) *ProjectsIosAppsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsIosAppsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.iosapp)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *IosApp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsIosAppsPatchCall) Do(opts ...googleapi.CallOption) (*IosApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IosApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsIosAppsRemoveCall struct {
	s                   *Service
	nameid              string
	removeiosapprequest *RemoveIosAppRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Remove: Removes the specified IosApp from the FirebaseProject.
//
//   - name: The resource name of the IosApp, in the format: projects/
//     PROJECT_IDENTIFIER/iosApps/APP_ID Since an APP_ID is a unique identifier,
//     the Unique Resource from Sub-Collection access pattern may be used here,
//     in the format: projects/-/iosApps/APP_ID Refer to the IosApp name
//     (../projects.iosApps#IosApp.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsIosAppsService) Remove(nameid string, removeiosapprequest *RemoveIosAppRequest) *ProjectsIosAppsRemoveCall {
	c := &ProjectsIosAppsRemoveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.removeiosapprequest = removeiosapprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsIosAppsRemoveCall) Fields(s ...googleapi.Field) *ProjectsIosAppsRemoveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsIosAppsRemoveCall) Context(ctx context.Context) *ProjectsIosAppsRemoveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsIosAppsRemoveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsRemoveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removeiosapprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:remove")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.remove", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.remove" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsIosAppsRemoveCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.remove", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsIosAppsUndeleteCall struct {
	s                     *Service
	nameid                string
	undeleteiosapprequest *UndeleteIosAppRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Undelete: Restores the specified IosApp to the FirebaseProject.
//
//   - name: The resource name of the IosApp, in the format: projects/
//     PROJECT_IDENTIFIER/iosApps/APP_ID Since an APP_ID is a unique identifier,
//     the Unique Resource from Sub-Collection access pattern may be used here,
//     in the format: projects/-/iosApps/APP_ID Refer to the IosApp name
//     (../projects.iosApps#IosApp.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsIosAppsService) Undelete(nameid string, undeleteiosapprequest *UndeleteIosAppRequest) *ProjectsIosAppsUndeleteCall {
	c := &ProjectsIosAppsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.undeleteiosapprequest = undeleteiosapprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsIosAppsUndeleteCall) Fields(s ...googleapi.Field) *ProjectsIosAppsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsIosAppsUndeleteCall) Context(ctx context.Context) *ProjectsIosAppsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsIosAppsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.undeleteiosapprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.undelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.undelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsIosAppsUndeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.iosApps.undelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsWebAppsCreateCall struct {
	s          *Service
	parent     string
	webapp     *WebApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Requests the creation of a new WebApp in the specified
// FirebaseProject. The result of this call is an `Operation` which can be used
// to track the provisioning process. The `Operation` is automatically deleted
// after completion, so there is no need to call `DeleteOperation`.
//
//   - parent: The resource name of the parent FirebaseProject in which to create
//     a WebApp, in the format: projects/PROJECT_IDENTIFIER/webApps Refer to the
//     `FirebaseProject` `name` (../projects#FirebaseProject.FIELDS.name) field
//     for details about PROJECT_IDENTIFIER values.
func (r *ProjectsWebAppsService) Create(parent string, webapp *WebApp) *ProjectsWebAppsCreateCall {
	c := &ProjectsWebAppsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.webapp = webapp
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsWebAppsCreateCall) Fields(s ...googleapi.Field) *ProjectsWebAppsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsWebAppsCreateCall) Context(ctx context.Context) *ProjectsWebAppsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsWebAppsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.webapp)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/webApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.webApps.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsWebAppsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.webApps.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsWebAppsGetCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified WebApp.
//
//   - name: The resource name of the WebApp, in the format:
//     projects/PROJECT_IDENTIFIER /webApps/APP_ID Since an APP_ID is a unique
//     identifier, the Unique Resource from Sub-Collection access pattern may be
//     used here, in the format: projects/-/webApps/APP_ID Refer to the `WebApp`
//     `name` (../projects.webApps#WebApp.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsWebAppsService) Get(nameid string) *ProjectsWebAppsGetCall {
	c := &ProjectsWebAppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsWebAppsGetCall) Fields(s ...googleapi.Field) *ProjectsWebAppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsWebAppsGetCall) IfNoneMatch(entityTag string) *ProjectsWebAppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsWebAppsGetCall) Context(ctx context.Context) *ProjectsWebAppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsWebAppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.webApps.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *WebApp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsWebAppsGetCall) Do(opts ...googleapi.CallOption) (*WebApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WebApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.webApps.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsWebAppsGetConfigCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetConfig: Gets the configuration artifact associated with the specified
// WebApp.
//
//   - name: The resource name of the WebApp configuration to download, in the
//     format: projects/PROJECT_IDENTIFIER/webApps/APP_ID/config Since an APP_ID
//     is a unique identifier, the Unique Resource from Sub-Collection access
//     pattern may be used here, in the format: projects/-/webApps/APP_ID Refer
//     to the `WebApp` `name` (../projects.webApps#WebApp.FIELDS.name) field for
//     details about PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsWebAppsService) GetConfig(nameid string) *ProjectsWebAppsGetConfigCall {
	c := &ProjectsWebAppsGetConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsWebAppsGetConfigCall) Fields(s ...googleapi.Field) *ProjectsWebAppsGetConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsWebAppsGetConfigCall) IfNoneMatch(entityTag string) *ProjectsWebAppsGetConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsWebAppsGetConfigCall) Context(ctx context.Context) *ProjectsWebAppsGetConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsWebAppsGetConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsGetConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.webApps.getConfig", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.getConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *WebAppConfig.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsWebAppsGetConfigCall) Do(opts ...googleapi.CallOption) (*WebAppConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WebAppConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.webApps.getConfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsWebAppsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists each WebApp associated with the specified FirebaseProject. The
// elements are returned in no particular order, but will be a consistent view
// of the Apps when additional requests are made with a `pageToken`.
//
//   - parent: The resource name of the parent FirebaseProject for which to list
//     each associated WebApp, in the format: projects/PROJECT_IDENTIFIER/webApps
//     Refer to the `FirebaseProject` `name`
//     (../projects#FirebaseProject.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER values.
func (r *ProjectsWebAppsService) List(parent string) *ProjectsWebAppsListCall {
	c := &ProjectsWebAppsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of Apps
// to return in the response. The server may return fewer than this value at
// its discretion. If no value is specified (or too large a value is
// specified), then the server will impose its own limit.
func (c *ProjectsWebAppsListCall) PageSize(pageSize int64) *ProjectsWebAppsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned from a
// previous call to `ListWebApps` indicating where in the set of Apps to resume
// listing.
func (c *ProjectsWebAppsListCall) PageToken(pageToken string) *ProjectsWebAppsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Controls whether Apps
// in the DELETED state should be returned in the response. If not specified,
// only `ACTIVE` Apps will be returned.
func (c *ProjectsWebAppsListCall) ShowDeleted(showDeleted bool) *ProjectsWebAppsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsWebAppsListCall) Fields(s ...googleapi.Field) *ProjectsWebAppsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsWebAppsListCall) IfNoneMatch(entityTag string) *ProjectsWebAppsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsWebAppsListCall) Context(ctx context.Context) *ProjectsWebAppsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsWebAppsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/webApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.webApps.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListWebAppsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsWebAppsListCall) Do(opts ...googleapi.CallOption) (*ListWebAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListWebAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.webApps.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsWebAppsListCall) Pages(ctx context.Context, f func(*ListWebAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsWebAppsPatchCall struct {
	s          *Service
	nameid     string
	webapp     *WebApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the attributes of the specified WebApp.
//
//   - name: The resource name of the WebApp, in the format:
//     projects/PROJECT_IDENTIFIER /webApps/APP_ID * PROJECT_IDENTIFIER: the
//     parent Project's `ProjectNumber`
//     (../projects#FirebaseProject.FIELDS.project_number) ***(recommended)*** or
//     its `ProjectId` (../projects#FirebaseProject.FIELDS.project_id). Learn
//     more about using project identifiers in Google's AIP 2510 standard
//     (https://google.aip.dev/cloud/2510). Note that the value for
//     PROJECT_IDENTIFIER in any response body will be the `ProjectId`. * APP_ID:
//     the globally unique, Firebase-assigned identifier for the App (see `appId`
//     (../projects.webApps#WebApp.FIELDS.app_id)).
func (r *ProjectsWebAppsService) Patch(nameid string, webapp *WebApp) *ProjectsWebAppsPatchCall {
	c := &ProjectsWebAppsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.webapp = webapp
	return c
}

// UpdateMask sets the optional parameter "updateMask": Specifies which fields
// of the WebApp to update. Note that the following fields are immutable:
// `name`, `app_id`, and `project_id`. To update `state`, use any of the
// following endpoints: RemoveWebApp or UndeleteWebApp.
func (c *ProjectsWebAppsPatchCall) UpdateMask(updateMask string) *ProjectsWebAppsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsWebAppsPatchCall) Fields(s ...googleapi.Field) *ProjectsWebAppsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsWebAppsPatchCall) Context(ctx context.Context) *ProjectsWebAppsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsWebAppsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.webapp)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.webApps.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *WebApp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsWebAppsPatchCall) Do(opts ...googleapi.CallOption) (*WebApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WebApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.webApps.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsWebAppsRemoveCall struct {
	s                   *Service
	nameid              string
	removewebapprequest *RemoveWebAppRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Remove: Removes the specified WebApp from the FirebaseProject.
//
//   - name: The resource name of the WebApp, in the format: projects/
//     PROJECT_IDENTIFIER/webApps/APP_ID Since an APP_ID is a unique identifier,
//     the Unique Resource from Sub-Collection access pattern may be used here,
//     in the format: projects/-/webApps/APP_ID Refer to the WebApp name
//     (../projects.webApps#WebApp.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsWebAppsService) Remove(nameid string, removewebapprequest *RemoveWebAppRequest) *ProjectsWebAppsRemoveCall {
	c := &ProjectsWebAppsRemoveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.removewebapprequest = removewebapprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsWebAppsRemoveCall) Fields(s ...googleapi.Field) *ProjectsWebAppsRemoveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsWebAppsRemoveCall) Context(ctx context.Context) *ProjectsWebAppsRemoveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsWebAppsRemoveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsRemoveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removewebapprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:remove")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.webApps.remove", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.remove" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsWebAppsRemoveCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.webApps.remove", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsWebAppsUndeleteCall struct {
	s                     *Service
	nameid                string
	undeletewebapprequest *UndeleteWebAppRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Undelete: Restores the specified WebApp to the FirebaseProject.
//
//   - name: The resource name of the WebApp, in the format: projects/
//     PROJECT_IDENTIFIER/webApps/APP_ID Since an APP_ID is a unique identifier,
//     the Unique Resource from Sub-Collection access pattern may be used here,
//     in the format: projects/-/webApps/APP_ID Refer to the WebApp name
//     (../projects.webApps#WebApp.FIELDS.name) field for details about
//     PROJECT_IDENTIFIER and APP_ID values.
func (r *ProjectsWebAppsService) Undelete(nameid string, undeletewebapprequest *UndeleteWebAppRequest) *ProjectsWebAppsUndeleteCall {
	c := &ProjectsWebAppsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.undeletewebapprequest = undeletewebapprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsWebAppsUndeleteCall) Fields(s ...googleapi.Field) *ProjectsWebAppsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsWebAppsUndeleteCall) Context(ctx context.Context) *ProjectsWebAppsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsWebAppsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.undeletewebapprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebase.projects.webApps.undelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.undelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsWebAppsUndeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebase.projects.webApps.undelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
