package containerregistry

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Action enumerates the values for action.
type Action string

const (
	// ActionAllow ...
	ActionAllow Action = "Allow"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{ActionAllow}
}

// ActionsRequired enumerates the values for actions required.
type ActionsRequired string

const (
	// ActionsRequiredNone ...
	ActionsRequiredNone ActionsRequired = "None"
	// ActionsRequiredRecreate ...
	ActionsRequiredRecreate ActionsRequired = "Recreate"
)

// PossibleActionsRequiredValues returns an array of possible values for the ActionsRequired const type.
func PossibleActionsRequiredValues() []ActionsRequired {
	return []ActionsRequired{ActionsRequiredNone, ActionsRequiredRecreate}
}

// ActivationStatus enumerates the values for activation status.
type ActivationStatus string

const (
	// ActivationStatusActive ...
	ActivationStatusActive ActivationStatus = "Active"
	// ActivationStatusInactive ...
	ActivationStatusInactive ActivationStatus = "Inactive"
)

// PossibleActivationStatusValues returns an array of possible values for the ActivationStatus const type.
func PossibleActivationStatusValues() []ActivationStatus {
	return []ActivationStatus{ActivationStatusActive, ActivationStatusInactive}
}

// Architecture enumerates the values for architecture.
type Architecture string

const (
	// ArchitectureAmd64 ...
	ArchitectureAmd64 Architecture = "amd64"
	// ArchitectureArm ...
	ArchitectureArm Architecture = "arm"
	// ArchitectureArm64 ...
	ArchitectureArm64 Architecture = "arm64"
	// ArchitectureThreeEightSix ...
	ArchitectureThreeEightSix Architecture = "386"
	// ArchitectureX86 ...
	ArchitectureX86 Architecture = "x86"
)

// PossibleArchitectureValues returns an array of possible values for the Architecture const type.
func PossibleArchitectureValues() []Architecture {
	return []Architecture{ArchitectureAmd64, ArchitectureArm, ArchitectureArm64, ArchitectureThreeEightSix, ArchitectureX86}
}

// AuditLogStatus enumerates the values for audit log status.
type AuditLogStatus string

const (
	// AuditLogStatusDisabled ...
	AuditLogStatusDisabled AuditLogStatus = "Disabled"
	// AuditLogStatusEnabled ...
	AuditLogStatusEnabled AuditLogStatus = "Enabled"
)

// PossibleAuditLogStatusValues returns an array of possible values for the AuditLogStatus const type.
func PossibleAuditLogStatusValues() []AuditLogStatus {
	return []AuditLogStatus{AuditLogStatusDisabled, AuditLogStatusEnabled}
}

// BaseImageDependencyType enumerates the values for base image dependency type.
type BaseImageDependencyType string

const (
	// BaseImageDependencyTypeBuildTime ...
	BaseImageDependencyTypeBuildTime BaseImageDependencyType = "BuildTime"
	// BaseImageDependencyTypeRunTime ...
	BaseImageDependencyTypeRunTime BaseImageDependencyType = "RunTime"
)

// PossibleBaseImageDependencyTypeValues returns an array of possible values for the BaseImageDependencyType const type.
func PossibleBaseImageDependencyTypeValues() []BaseImageDependencyType {
	return []BaseImageDependencyType{BaseImageDependencyTypeBuildTime, BaseImageDependencyTypeRunTime}
}

// BaseImageTriggerType enumerates the values for base image trigger type.
type BaseImageTriggerType string

const (
	// BaseImageTriggerTypeAll ...
	BaseImageTriggerTypeAll BaseImageTriggerType = "All"
	// BaseImageTriggerTypeRuntime ...
	BaseImageTriggerTypeRuntime BaseImageTriggerType = "Runtime"
)

// PossibleBaseImageTriggerTypeValues returns an array of possible values for the BaseImageTriggerType const type.
func PossibleBaseImageTriggerTypeValues() []BaseImageTriggerType {
	return []BaseImageTriggerType{BaseImageTriggerTypeAll, BaseImageTriggerTypeRuntime}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// CertificateTypeLocalDirectory ...
	CertificateTypeLocalDirectory CertificateType = "LocalDirectory"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{CertificateTypeLocalDirectory}
}

// ConnectedRegistryMode enumerates the values for connected registry mode.
type ConnectedRegistryMode string

const (
	// ConnectedRegistryModeMirror ...
	ConnectedRegistryModeMirror ConnectedRegistryMode = "Mirror"
	// ConnectedRegistryModeRegistry ...
	ConnectedRegistryModeRegistry ConnectedRegistryMode = "Registry"
)

// PossibleConnectedRegistryModeValues returns an array of possible values for the ConnectedRegistryMode const type.
func PossibleConnectedRegistryModeValues() []ConnectedRegistryMode {
	return []ConnectedRegistryMode{ConnectedRegistryModeMirror, ConnectedRegistryModeRegistry}
}

// ConnectionState enumerates the values for connection state.
type ConnectionState string

const (
	// ConnectionStateOffline ...
	ConnectionStateOffline ConnectionState = "Offline"
	// ConnectionStateOnline ...
	ConnectionStateOnline ConnectionState = "Online"
	// ConnectionStateSyncing ...
	ConnectionStateSyncing ConnectionState = "Syncing"
	// ConnectionStateUnhealthy ...
	ConnectionStateUnhealthy ConnectionState = "Unhealthy"
)

// PossibleConnectionStateValues returns an array of possible values for the ConnectionState const type.
func PossibleConnectionStateValues() []ConnectionState {
	return []ConnectionState{ConnectionStateOffline, ConnectionStateOnline, ConnectionStateSyncing, ConnectionStateUnhealthy}
}

// ConnectionStatus enumerates the values for connection status.
type ConnectionStatus string

const (
	// ConnectionStatusApproved ...
	ConnectionStatusApproved ConnectionStatus = "Approved"
	// ConnectionStatusDisconnected ...
	ConnectionStatusDisconnected ConnectionStatus = "Disconnected"
	// ConnectionStatusPending ...
	ConnectionStatusPending ConnectionStatus = "Pending"
	// ConnectionStatusRejected ...
	ConnectionStatusRejected ConnectionStatus = "Rejected"
)

// PossibleConnectionStatusValues returns an array of possible values for the ConnectionStatus const type.
func PossibleConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{ConnectionStatusApproved, ConnectionStatusDisconnected, ConnectionStatusPending, ConnectionStatusRejected}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DefaultAction enumerates the values for default action.
type DefaultAction string

const (
	// DefaultActionAllow ...
	DefaultActionAllow DefaultAction = "Allow"
	// DefaultActionDeny ...
	DefaultActionDeny DefaultAction = "Deny"
)

// PossibleDefaultActionValues returns an array of possible values for the DefaultAction const type.
func PossibleDefaultActionValues() []DefaultAction {
	return []DefaultAction{DefaultActionAllow, DefaultActionDeny}
}

// EncryptionStatus enumerates the values for encryption status.
type EncryptionStatus string

const (
	// EncryptionStatusDisabled ...
	EncryptionStatusDisabled EncryptionStatus = "disabled"
	// EncryptionStatusEnabled ...
	EncryptionStatusEnabled EncryptionStatus = "enabled"
)

// PossibleEncryptionStatusValues returns an array of possible values for the EncryptionStatus const type.
func PossibleEncryptionStatusValues() []EncryptionStatus {
	return []EncryptionStatus{EncryptionStatusDisabled, EncryptionStatusEnabled}
}

// ExportPolicyStatus enumerates the values for export policy status.
type ExportPolicyStatus string

const (
	// ExportPolicyStatusDisabled ...
	ExportPolicyStatusDisabled ExportPolicyStatus = "disabled"
	// ExportPolicyStatusEnabled ...
	ExportPolicyStatusEnabled ExportPolicyStatus = "enabled"
)

// PossibleExportPolicyStatusValues returns an array of possible values for the ExportPolicyStatus const type.
func PossibleExportPolicyStatusValues() []ExportPolicyStatus {
	return []ExportPolicyStatus{ExportPolicyStatusDisabled, ExportPolicyStatusEnabled}
}

// ImportMode enumerates the values for import mode.
type ImportMode string

const (
	// ImportModeForce ...
	ImportModeForce ImportMode = "Force"
	// ImportModeNoForce ...
	ImportModeNoForce ImportMode = "NoForce"
)

// PossibleImportModeValues returns an array of possible values for the ImportMode const type.
func PossibleImportModeValues() []ImportMode {
	return []ImportMode{ImportModeForce, ImportModeNoForce}
}

// LastModifiedByType enumerates the values for last modified by type.
type LastModifiedByType string

const (
	// LastModifiedByTypeApplication ...
	LastModifiedByTypeApplication LastModifiedByType = "Application"
	// LastModifiedByTypeKey ...
	LastModifiedByTypeKey LastModifiedByType = "Key"
	// LastModifiedByTypeManagedIdentity ...
	LastModifiedByTypeManagedIdentity LastModifiedByType = "ManagedIdentity"
	// LastModifiedByTypeUser ...
	LastModifiedByTypeUser LastModifiedByType = "User"
)

// PossibleLastModifiedByTypeValues returns an array of possible values for the LastModifiedByType const type.
func PossibleLastModifiedByTypeValues() []LastModifiedByType {
	return []LastModifiedByType{LastModifiedByTypeApplication, LastModifiedByTypeKey, LastModifiedByTypeManagedIdentity, LastModifiedByTypeUser}
}

// LogLevel enumerates the values for log level.
type LogLevel string

const (
	// LogLevelDebug ...
	LogLevelDebug LogLevel = "Debug"
	// LogLevelError ...
	LogLevelError LogLevel = "Error"
	// LogLevelInformation ...
	LogLevelInformation LogLevel = "Information"
	// LogLevelNone ...
	LogLevelNone LogLevel = "None"
	// LogLevelWarning ...
	LogLevelWarning LogLevel = "Warning"
)

// PossibleLogLevelValues returns an array of possible values for the LogLevel const type.
func PossibleLogLevelValues() []LogLevel {
	return []LogLevel{LogLevelDebug, LogLevelError, LogLevelInformation, LogLevelNone, LogLevelWarning}
}

// NetworkRuleBypassOptions enumerates the values for network rule bypass options.
type NetworkRuleBypassOptions string

const (
	// NetworkRuleBypassOptionsAzureServices ...
	NetworkRuleBypassOptionsAzureServices NetworkRuleBypassOptions = "AzureServices"
	// NetworkRuleBypassOptionsNone ...
	NetworkRuleBypassOptionsNone NetworkRuleBypassOptions = "None"
)

// PossibleNetworkRuleBypassOptionsValues returns an array of possible values for the NetworkRuleBypassOptions const type.
func PossibleNetworkRuleBypassOptionsValues() []NetworkRuleBypassOptions {
	return []NetworkRuleBypassOptions{NetworkRuleBypassOptionsAzureServices, NetworkRuleBypassOptionsNone}
}

// OS enumerates the values for os.
type OS string

const (
	// OSLinux ...
	OSLinux OS = "Linux"
	// OSWindows ...
	OSWindows OS = "Windows"
)

// PossibleOSValues returns an array of possible values for the OS const type.
func PossibleOSValues() []OS {
	return []OS{OSLinux, OSWindows}
}

// PasswordName enumerates the values for password name.
type PasswordName string

const (
	// PasswordNamePassword ...
	PasswordNamePassword PasswordName = "password"
	// PasswordNamePassword2 ...
	PasswordNamePassword2 PasswordName = "password2"
)

// PossiblePasswordNameValues returns an array of possible values for the PasswordName const type.
func PossiblePasswordNameValues() []PasswordName {
	return []PasswordName{PasswordNamePassword, PasswordNamePassword2}
}

// PipelineOptions enumerates the values for pipeline options.
type PipelineOptions string

const (
	// PipelineOptionsContinueOnErrors ...
	PipelineOptionsContinueOnErrors PipelineOptions = "ContinueOnErrors"
	// PipelineOptionsDeleteSourceBlobOnSuccess ...
	PipelineOptionsDeleteSourceBlobOnSuccess PipelineOptions = "DeleteSourceBlobOnSuccess"
	// PipelineOptionsOverwriteBlobs ...
	PipelineOptionsOverwriteBlobs PipelineOptions = "OverwriteBlobs"
	// PipelineOptionsOverwriteTags ...
	PipelineOptionsOverwriteTags PipelineOptions = "OverwriteTags"
)

// PossiblePipelineOptionsValues returns an array of possible values for the PipelineOptions const type.
func PossiblePipelineOptionsValues() []PipelineOptions {
	return []PipelineOptions{PipelineOptionsContinueOnErrors, PipelineOptionsDeleteSourceBlobOnSuccess, PipelineOptionsOverwriteBlobs, PipelineOptionsOverwriteTags}
}

// PipelineRunSourceType enumerates the values for pipeline run source type.
type PipelineRunSourceType string

const (
	// PipelineRunSourceTypeAzureStorageBlob ...
	PipelineRunSourceTypeAzureStorageBlob PipelineRunSourceType = "AzureStorageBlob"
)

// PossiblePipelineRunSourceTypeValues returns an array of possible values for the PipelineRunSourceType const type.
func PossiblePipelineRunSourceTypeValues() []PipelineRunSourceType {
	return []PipelineRunSourceType{PipelineRunSourceTypeAzureStorageBlob}
}

// PipelineRunTargetType enumerates the values for pipeline run target type.
type PipelineRunTargetType string

const (
	// PipelineRunTargetTypeAzureStorageBlob ...
	PipelineRunTargetTypeAzureStorageBlob PipelineRunTargetType = "AzureStorageBlob"
)

// PossiblePipelineRunTargetTypeValues returns an array of possible values for the PipelineRunTargetType const type.
func PossiblePipelineRunTargetTypeValues() []PipelineRunTargetType {
	return []PipelineRunTargetType{PipelineRunTargetTypeAzureStorageBlob}
}

// PipelineSourceType enumerates the values for pipeline source type.
type PipelineSourceType string

const (
	// PipelineSourceTypeAzureStorageBlobContainer ...
	PipelineSourceTypeAzureStorageBlobContainer PipelineSourceType = "AzureStorageBlobContainer"
)

// PossiblePipelineSourceTypeValues returns an array of possible values for the PipelineSourceType const type.
func PossiblePipelineSourceTypeValues() []PipelineSourceType {
	return []PipelineSourceType{PipelineSourceTypeAzureStorageBlobContainer}
}

// PolicyStatus enumerates the values for policy status.
type PolicyStatus string

const (
	// PolicyStatusDisabled ...
	PolicyStatusDisabled PolicyStatus = "disabled"
	// PolicyStatusEnabled ...
	PolicyStatusEnabled PolicyStatus = "enabled"
)

// PossiblePolicyStatusValues returns an array of possible values for the PolicyStatus const type.
func PossiblePolicyStatusValues() []PolicyStatus {
	return []PolicyStatus{PolicyStatusDisabled, PolicyStatusEnabled}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// RegistryUsageUnit enumerates the values for registry usage unit.
type RegistryUsageUnit string

const (
	// RegistryUsageUnitBytes ...
	RegistryUsageUnitBytes RegistryUsageUnit = "Bytes"
	// RegistryUsageUnitCount ...
	RegistryUsageUnitCount RegistryUsageUnit = "Count"
)

// PossibleRegistryUsageUnitValues returns an array of possible values for the RegistryUsageUnit const type.
func PossibleRegistryUsageUnitValues() []RegistryUsageUnit {
	return []RegistryUsageUnit{RegistryUsageUnitBytes, RegistryUsageUnitCount}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// RunStatus enumerates the values for run status.
type RunStatus string

const (
	// RunStatusCanceled ...
	RunStatusCanceled RunStatus = "Canceled"
	// RunStatusError ...
	RunStatusError RunStatus = "Error"
	// RunStatusFailed ...
	RunStatusFailed RunStatus = "Failed"
	// RunStatusQueued ...
	RunStatusQueued RunStatus = "Queued"
	// RunStatusRunning ...
	RunStatusRunning RunStatus = "Running"
	// RunStatusStarted ...
	RunStatusStarted RunStatus = "Started"
	// RunStatusSucceeded ...
	RunStatusSucceeded RunStatus = "Succeeded"
	// RunStatusTimeout ...
	RunStatusTimeout RunStatus = "Timeout"
)

// PossibleRunStatusValues returns an array of possible values for the RunStatus const type.
func PossibleRunStatusValues() []RunStatus {
	return []RunStatus{RunStatusCanceled, RunStatusError, RunStatusFailed, RunStatusQueued, RunStatusRunning, RunStatusStarted, RunStatusSucceeded, RunStatusTimeout}
}

// RunType enumerates the values for run type.
type RunType string

const (
	// RunTypeAutoBuild ...
	RunTypeAutoBuild RunType = "AutoBuild"
	// RunTypeAutoRun ...
	RunTypeAutoRun RunType = "AutoRun"
	// RunTypeQuickBuild ...
	RunTypeQuickBuild RunType = "QuickBuild"
	// RunTypeQuickRun ...
	RunTypeQuickRun RunType = "QuickRun"
)

// PossibleRunTypeValues returns an array of possible values for the RunType const type.
func PossibleRunTypeValues() []RunType {
	return []RunType{RunTypeAutoBuild, RunTypeAutoRun, RunTypeQuickBuild, RunTypeQuickRun}
}

// SecretObjectType enumerates the values for secret object type.
type SecretObjectType string

const (
	// SecretObjectTypeOpaque ...
	SecretObjectTypeOpaque SecretObjectType = "Opaque"
	// SecretObjectTypeVaultsecret ...
	SecretObjectTypeVaultsecret SecretObjectType = "Vaultsecret"
)

// PossibleSecretObjectTypeValues returns an array of possible values for the SecretObjectType const type.
func PossibleSecretObjectTypeValues() []SecretObjectType {
	return []SecretObjectType{SecretObjectTypeOpaque, SecretObjectTypeVaultsecret}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic ...
	SkuNameBasic SkuName = "Basic"
	// SkuNameClassic ...
	SkuNameClassic SkuName = "Classic"
	// SkuNamePremium ...
	SkuNamePremium SkuName = "Premium"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameBasic, SkuNameClassic, SkuNamePremium, SkuNameStandard}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierClassic ...
	SkuTierClassic SkuTier = "Classic"
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierClassic, SkuTierPremium, SkuTierStandard}
}

// SourceControlType enumerates the values for source control type.
type SourceControlType string

const (
	// SourceControlTypeGithub ...
	SourceControlTypeGithub SourceControlType = "Github"
	// SourceControlTypeVisualStudioTeamService ...
	SourceControlTypeVisualStudioTeamService SourceControlType = "VisualStudioTeamService"
)

// PossibleSourceControlTypeValues returns an array of possible values for the SourceControlType const type.
func PossibleSourceControlTypeValues() []SourceControlType {
	return []SourceControlType{SourceControlTypeGithub, SourceControlTypeVisualStudioTeamService}
}

// SourceRegistryLoginMode enumerates the values for source registry login mode.
type SourceRegistryLoginMode string

const (
	// SourceRegistryLoginModeDefault ...
	SourceRegistryLoginModeDefault SourceRegistryLoginMode = "Default"
	// SourceRegistryLoginModeNone ...
	SourceRegistryLoginModeNone SourceRegistryLoginMode = "None"
)

// PossibleSourceRegistryLoginModeValues returns an array of possible values for the SourceRegistryLoginMode const type.
func PossibleSourceRegistryLoginModeValues() []SourceRegistryLoginMode {
	return []SourceRegistryLoginMode{SourceRegistryLoginModeDefault, SourceRegistryLoginModeNone}
}

// SourceTriggerEvent enumerates the values for source trigger event.
type SourceTriggerEvent string

const (
	// SourceTriggerEventCommit ...
	SourceTriggerEventCommit SourceTriggerEvent = "commit"
	// SourceTriggerEventPullrequest ...
	SourceTriggerEventPullrequest SourceTriggerEvent = "pullrequest"
)

// PossibleSourceTriggerEventValues returns an array of possible values for the SourceTriggerEvent const type.
func PossibleSourceTriggerEventValues() []SourceTriggerEvent {
	return []SourceTriggerEvent{SourceTriggerEventCommit, SourceTriggerEventPullrequest}
}

// TaskStatus enumerates the values for task status.
type TaskStatus string

const (
	// TaskStatusDisabled ...
	TaskStatusDisabled TaskStatus = "Disabled"
	// TaskStatusEnabled ...
	TaskStatusEnabled TaskStatus = "Enabled"
)

// PossibleTaskStatusValues returns an array of possible values for the TaskStatus const type.
func PossibleTaskStatusValues() []TaskStatus {
	return []TaskStatus{TaskStatusDisabled, TaskStatusEnabled}
}

// TLSStatus enumerates the values for tls status.
type TLSStatus string

const (
	// TLSStatusDisabled ...
	TLSStatusDisabled TLSStatus = "Disabled"
	// TLSStatusEnabled ...
	TLSStatusEnabled TLSStatus = "Enabled"
)

// PossibleTLSStatusValues returns an array of possible values for the TLSStatus const type.
func PossibleTLSStatusValues() []TLSStatus {
	return []TLSStatus{TLSStatusDisabled, TLSStatusEnabled}
}

// TokenCertificateName enumerates the values for token certificate name.
type TokenCertificateName string

const (
	// TokenCertificateNameCertificate1 ...
	TokenCertificateNameCertificate1 TokenCertificateName = "certificate1"
	// TokenCertificateNameCertificate2 ...
	TokenCertificateNameCertificate2 TokenCertificateName = "certificate2"
)

// PossibleTokenCertificateNameValues returns an array of possible values for the TokenCertificateName const type.
func PossibleTokenCertificateNameValues() []TokenCertificateName {
	return []TokenCertificateName{TokenCertificateNameCertificate1, TokenCertificateNameCertificate2}
}

// TokenPasswordName enumerates the values for token password name.
type TokenPasswordName string

const (
	// TokenPasswordNamePassword1 ...
	TokenPasswordNamePassword1 TokenPasswordName = "password1"
	// TokenPasswordNamePassword2 ...
	TokenPasswordNamePassword2 TokenPasswordName = "password2"
)

// PossibleTokenPasswordNameValues returns an array of possible values for the TokenPasswordName const type.
func PossibleTokenPasswordNameValues() []TokenPasswordName {
	return []TokenPasswordName{TokenPasswordNamePassword1, TokenPasswordNamePassword2}
}

// TokenStatus enumerates the values for token status.
type TokenStatus string

const (
	// TokenStatusDisabled ...
	TokenStatusDisabled TokenStatus = "disabled"
	// TokenStatusEnabled ...
	TokenStatusEnabled TokenStatus = "enabled"
)

// PossibleTokenStatusValues returns an array of possible values for the TokenStatus const type.
func PossibleTokenStatusValues() []TokenStatus {
	return []TokenStatus{TokenStatusDisabled, TokenStatusEnabled}
}

// TokenType enumerates the values for token type.
type TokenType string

const (
	// TokenTypeOAuth ...
	TokenTypeOAuth TokenType = "OAuth"
	// TokenTypePAT ...
	TokenTypePAT TokenType = "PAT"
)

// PossibleTokenTypeValues returns an array of possible values for the TokenType const type.
func PossibleTokenTypeValues() []TokenType {
	return []TokenType{TokenTypeOAuth, TokenTypePAT}
}

// TriggerStatus enumerates the values for trigger status.
type TriggerStatus string

const (
	// TriggerStatusDisabled ...
	TriggerStatusDisabled TriggerStatus = "Disabled"
	// TriggerStatusEnabled ...
	TriggerStatusEnabled TriggerStatus = "Enabled"
)

// PossibleTriggerStatusValues returns an array of possible values for the TriggerStatus const type.
func PossibleTriggerStatusValues() []TriggerStatus {
	return []TriggerStatus{TriggerStatusDisabled, TriggerStatusEnabled}
}

// TrustPolicyType enumerates the values for trust policy type.
type TrustPolicyType string

const (
	// TrustPolicyTypeNotary ...
	TrustPolicyTypeNotary TrustPolicyType = "Notary"
)

// PossibleTrustPolicyTypeValues returns an array of possible values for the TrustPolicyType const type.
func PossibleTrustPolicyTypeValues() []TrustPolicyType {
	return []TrustPolicyType{TrustPolicyTypeNotary}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeDockerBuildRequest ...
	TypeDockerBuildRequest Type = "DockerBuildRequest"
	// TypeEncodedTaskRunRequest ...
	TypeEncodedTaskRunRequest Type = "EncodedTaskRunRequest"
	// TypeFileTaskRunRequest ...
	TypeFileTaskRunRequest Type = "FileTaskRunRequest"
	// TypeRunRequest ...
	TypeRunRequest Type = "RunRequest"
	// TypeTaskRunRequest ...
	TypeTaskRunRequest Type = "TaskRunRequest"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeDockerBuildRequest, TypeEncodedTaskRunRequest, TypeFileTaskRunRequest, TypeRunRequest, TypeTaskRunRequest}
}

// TypeBasicTaskStepProperties enumerates the values for type basic task step properties.
type TypeBasicTaskStepProperties string

const (
	// TypeBasicTaskStepPropertiesTypeDocker ...
	TypeBasicTaskStepPropertiesTypeDocker TypeBasicTaskStepProperties = "Docker"
	// TypeBasicTaskStepPropertiesTypeEncodedTask ...
	TypeBasicTaskStepPropertiesTypeEncodedTask TypeBasicTaskStepProperties = "EncodedTask"
	// TypeBasicTaskStepPropertiesTypeFileTask ...
	TypeBasicTaskStepPropertiesTypeFileTask TypeBasicTaskStepProperties = "FileTask"
	// TypeBasicTaskStepPropertiesTypeTaskStepProperties ...
	TypeBasicTaskStepPropertiesTypeTaskStepProperties TypeBasicTaskStepProperties = "TaskStepProperties"
)

// PossibleTypeBasicTaskStepPropertiesValues returns an array of possible values for the TypeBasicTaskStepProperties const type.
func PossibleTypeBasicTaskStepPropertiesValues() []TypeBasicTaskStepProperties {
	return []TypeBasicTaskStepProperties{TypeBasicTaskStepPropertiesTypeDocker, TypeBasicTaskStepPropertiesTypeEncodedTask, TypeBasicTaskStepPropertiesTypeFileTask, TypeBasicTaskStepPropertiesTypeTaskStepProperties}
}

// TypeBasicTaskStepUpdateParameters enumerates the values for type basic task step update parameters.
type TypeBasicTaskStepUpdateParameters string

const (
	// TypeBasicTaskStepUpdateParametersTypeDocker ...
	TypeBasicTaskStepUpdateParametersTypeDocker TypeBasicTaskStepUpdateParameters = "Docker"
	// TypeBasicTaskStepUpdateParametersTypeEncodedTask ...
	TypeBasicTaskStepUpdateParametersTypeEncodedTask TypeBasicTaskStepUpdateParameters = "EncodedTask"
	// TypeBasicTaskStepUpdateParametersTypeFileTask ...
	TypeBasicTaskStepUpdateParametersTypeFileTask TypeBasicTaskStepUpdateParameters = "FileTask"
	// TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters ...
	TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters TypeBasicTaskStepUpdateParameters = "TaskStepUpdateParameters"
)

// PossibleTypeBasicTaskStepUpdateParametersValues returns an array of possible values for the TypeBasicTaskStepUpdateParameters const type.
func PossibleTypeBasicTaskStepUpdateParametersValues() []TypeBasicTaskStepUpdateParameters {
	return []TypeBasicTaskStepUpdateParameters{TypeBasicTaskStepUpdateParametersTypeDocker, TypeBasicTaskStepUpdateParametersTypeEncodedTask, TypeBasicTaskStepUpdateParametersTypeFileTask, TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters}
}

// UpdateTriggerPayloadType enumerates the values for update trigger payload type.
type UpdateTriggerPayloadType string

const (
	// UpdateTriggerPayloadTypeDefault ...
	UpdateTriggerPayloadTypeDefault UpdateTriggerPayloadType = "Default"
	// UpdateTriggerPayloadTypeToken ...
	UpdateTriggerPayloadTypeToken UpdateTriggerPayloadType = "Token"
)

// PossibleUpdateTriggerPayloadTypeValues returns an array of possible values for the UpdateTriggerPayloadType const type.
func PossibleUpdateTriggerPayloadTypeValues() []UpdateTriggerPayloadType {
	return []UpdateTriggerPayloadType{UpdateTriggerPayloadTypeDefault, UpdateTriggerPayloadTypeToken}
}

// Variant enumerates the values for variant.
type Variant string

const (
	// VariantV6 ...
	VariantV6 Variant = "v6"
	// VariantV7 ...
	VariantV7 Variant = "v7"
	// VariantV8 ...
	VariantV8 Variant = "v8"
)

// PossibleVariantValues returns an array of possible values for the Variant const type.
func PossibleVariantValues() []Variant {
	return []Variant{VariantV6, VariantV7, VariantV8}
}

// WebhookAction enumerates the values for webhook action.
type WebhookAction string

const (
	// WebhookActionChartDelete ...
	WebhookActionChartDelete WebhookAction = "chart_delete"
	// WebhookActionChartPush ...
	WebhookActionChartPush WebhookAction = "chart_push"
	// WebhookActionDelete ...
	WebhookActionDelete WebhookAction = "delete"
	// WebhookActionPush ...
	WebhookActionPush WebhookAction = "push"
	// WebhookActionQuarantine ...
	WebhookActionQuarantine WebhookAction = "quarantine"
)

// PossibleWebhookActionValues returns an array of possible values for the WebhookAction const type.
func PossibleWebhookActionValues() []WebhookAction {
	return []WebhookAction{WebhookActionChartDelete, WebhookActionChartPush, WebhookActionDelete, WebhookActionPush, WebhookActionQuarantine}
}

// WebhookStatus enumerates the values for webhook status.
type WebhookStatus string

const (
	// WebhookStatusDisabled ...
	WebhookStatusDisabled WebhookStatus = "disabled"
	// WebhookStatusEnabled ...
	WebhookStatusEnabled WebhookStatus = "enabled"
)

// PossibleWebhookStatusValues returns an array of possible values for the WebhookStatus const type.
func PossibleWebhookStatusValues() []WebhookStatus {
	return []WebhookStatus{WebhookStatusDisabled, WebhookStatusEnabled}
}

// ZoneRedundancy enumerates the values for zone redundancy.
type ZoneRedundancy string

const (
	// ZoneRedundancyDisabled ...
	ZoneRedundancyDisabled ZoneRedundancy = "Disabled"
	// ZoneRedundancyEnabled ...
	ZoneRedundancyEnabled ZoneRedundancy = "Enabled"
)

// PossibleZoneRedundancyValues returns an array of possible values for the ZoneRedundancy const type.
func PossibleZoneRedundancyValues() []ZoneRedundancy {
	return []ZoneRedundancy{ZoneRedundancyDisabled, ZoneRedundancyEnabled}
}
