//
//
// File generated from our OpenAPI spec
//
//

package stripe

import "encoding/json"

// If the refund failed, the reason for refund failure if known. Possible values are `lost_or_stolen_card`, `expired_or_canceled_card`, `charge_for_pending_refund_disputed`, `insufficient_funds`, `declined`, `merchant_request` or `unknown`.
type RefundFailureReason string

// List of values that RefundFailureReason can take
const (
	RefundFailureReasonExpiredOrCanceledCard RefundFailureReason = "expired_or_canceled_card"
	RefundFailureReasonLostOrStolenCard      RefundFailureReason = "lost_or_stolen_card"
	RefundFailureReasonUnknown               RefundFailureReason = "unknown"
)

// Reason for the refund, either user-provided (`duplicate`, `fraudulent`, or `requested_by_customer`) or generated by Stripe internally (`expired_uncaptured_charge`).
type RefundReason string

// List of values that RefundReason can take
const (
	RefundReasonDuplicate               RefundReason = "duplicate"
	RefundReasonExpiredUncapturedCharge RefundReason = "expired_uncaptured_charge"
	RefundReasonFraudulent              RefundReason = "fraudulent"
	RefundReasonRequestedByCustomer     RefundReason = "requested_by_customer"
)

// Status of the refund. For credit card refunds, this can be `pending`, `succeeded`, or `failed`. For other types of refunds, it can be `pending`, `requires_action`, `succeeded`, `failed`, or `canceled`. Refer to our [refunds](https://stripe.com/docs/refunds#failed-refunds) documentation for more details.
type RefundStatus string

// List of values that RefundStatus can take
const (
	RefundStatusCanceled       RefundStatus = "canceled"
	RefundStatusFailed         RefundStatus = "failed"
	RefundStatusPending        RefundStatus = "pending"
	RefundStatusSucceeded      RefundStatus = "succeeded"
	RefundStatusRequiresAction RefundStatus = "requires_action"
)

// Returns a list of all refunds you've previously created. The refunds are returned in sorted order, with the most recent refunds appearing first. For convenience, the 10 most recent refunds are always available by default on the charge object.
type RefundListParams struct {
	ListParams `form:"*"`
	// Only return refunds for the charge specified by this charge ID.
	Charge       *string           `form:"charge"`
	Created      *int64            `form:"created"`
	CreatedRange *RangeQueryParams `form:"created"`
	// Only return refunds for the PaymentIntent specified by this ID.
	PaymentIntent *string `form:"payment_intent"`
}

// Create a refund.
type RefundParams struct {
	Params `form:"*"`
	// A positive integer representing how much to refund.
	Amount *int64  `form:"amount"`
	Charge *string `form:"charge"`
	// Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
	Currency *string `form:"currency"`
	// Customer whose customer balance to refund from.
	Customer *string `form:"customer"`
	// For payment methods without native refund support (e.g., Konbini, PromptPay), use this email from the customer to receive refund instructions.
	InstructionsEmail *string `form:"instructions_email"`
	// Origin of the refund
	Origin               *string `form:"origin"`
	PaymentIntent        *string `form:"payment_intent"`
	Reason               *string `form:"reason"`
	RefundApplicationFee *bool   `form:"refund_application_fee"`
	ReverseTransfer      *bool   `form:"reverse_transfer"`
}

// Cancels a refund with a status of requires_action.
//
// Refunds in other states cannot be canceled, and only refunds for payment methods that require customer action will enter the requires_action state.
type RefundCancelParams struct {
	Params `form:"*"`
}
type RefundNextActionDisplayDetailsEmailSent struct {
	// The timestamp when the email was sent.
	EmailSentAt int64 `json:"email_sent_at"`
	// The recipient's email address.
	EmailSentTo string `json:"email_sent_to"`
}

// Contains the refund details.
type RefundNextActionDisplayDetails struct {
	EmailSent *RefundNextActionDisplayDetailsEmailSent `json:"email_sent"`
	// The expiry timestamp.
	ExpiresAt int64 `json:"expires_at"`
}
type RefundNextAction struct {
	// Contains the refund details.
	DisplayDetails *RefundNextActionDisplayDetails `json:"display_details"`
	// Type of the next action to perform.
	Type string `json:"type"`
}

// `Refund` objects allow you to refund a charge that has previously been created
// but not yet refunded. Funds will be refunded to the credit or debit card that
// was originally charged.
//
// Related guide: [Refunds](https://stripe.com/docs/refunds)
type Refund struct {
	APIResource
	// Amount, in cents (or local equivalent).
	Amount int64 `json:"amount"`
	// Balance transaction that describes the impact on your account balance.
	BalanceTransaction *BalanceTransaction `json:"balance_transaction"`
	// ID of the charge that was refunded.
	Charge *Charge `json:"charge"`
	// Time at which the object was created. Measured in seconds since the Unix epoch.
	Created int64 `json:"created"`
	// Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
	Currency Currency `json:"currency"`
	// An arbitrary string attached to the object. Often useful for displaying to users. (Available on non-card refunds only)
	Description string `json:"description"`
	// If the refund failed, this balance transaction describes the adjustment made on your account balance that reverses the initial balance transaction.
	FailureBalanceTransaction *BalanceTransaction `json:"failure_balance_transaction"`
	// If the refund failed, the reason for refund failure if known. Possible values are `lost_or_stolen_card`, `expired_or_canceled_card`, `charge_for_pending_refund_disputed`, `insufficient_funds`, `declined`, `merchant_request` or `unknown`.
	FailureReason RefundFailureReason `json:"failure_reason"`
	// Unique identifier for the object.
	ID string `json:"id"`
	// For payment methods without native refund support (e.g., Konbini, PromptPay), email for the customer to receive refund instructions.
	InstructionsEmail string `json:"instructions_email"`
	// Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
	Metadata   map[string]string `json:"metadata"`
	NextAction *RefundNextAction `json:"next_action"`
	// String representing the object's type. Objects of the same type share the same value.
	Object string `json:"object"`
	// ID of the PaymentIntent that was refunded.
	PaymentIntent *PaymentIntent `json:"payment_intent"`
	// Reason for the refund, either user-provided (`duplicate`, `fraudulent`, or `requested_by_customer`) or generated by Stripe internally (`expired_uncaptured_charge`).
	Reason RefundReason `json:"reason"`
	// This is the transaction number that appears on email receipts sent for this refund.
	ReceiptNumber string `json:"receipt_number"`
	// The transfer reversal that is associated with the refund. Only present if the charge came from another Stripe account. See the Connect documentation for details.
	SourceTransferReversal *TransferReversal `json:"source_transfer_reversal"`
	// Status of the refund. For credit card refunds, this can be `pending`, `succeeded`, or `failed`. For other types of refunds, it can be `pending`, `requires_action`, `succeeded`, `failed`, or `canceled`. Refer to our [refunds](https://stripe.com/docs/refunds#failed-refunds) documentation for more details.
	Status RefundStatus `json:"status"`
	// If the accompanying transfer was reversed, the transfer reversal object. Only applicable if the charge was created using the destination parameter.
	TransferReversal *TransferReversal `json:"transfer_reversal"`
}

// RefundList is a list of Refunds as retrieved from a list endpoint.
type RefundList struct {
	APIResource
	ListMeta
	Data []*Refund `json:"data"`
}

// UnmarshalJSON handles deserialization of a Refund.
// This custom unmarshaling is needed because the resulting
// property may be an id or the full struct if it was expanded.
func (r *Refund) UnmarshalJSON(data []byte) error {
	if id, ok := ParseID(data); ok {
		r.ID = id
		return nil
	}

	type refund Refund
	var v refund
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}

	*r = Refund(v)
	return nil
}
