// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Clears any customization of a GatewayResponse of a specified response type
// on the given RestApi and resets it with the default settings.
type DeleteGatewayResponseInput struct {
	_ struct{} `type:"structure"`

	// [Required]
	// The response type of the associated GatewayResponse. Valid values are
	//    * ACCESS_DENIED
	//
	//    * API_CONFIGURATION_ERROR
	//
	//    * AUTHORIZER_FAILURE
	//
	//    * AUTHORIZER_CONFIGURATION_ERROR
	//
	//    * BAD_REQUEST_PARAMETERS
	//
	//    * BAD_REQUEST_BODY
	//
	//    * DEFAULT_4XX
	//
	//    * DEFAULT_5XX
	//
	//    * EXPIRED_TOKEN
	//
	//    * INVALID_SIGNATURE
	//
	//    * INTEGRATION_FAILURE
	//
	//    * INTEGRATION_TIMEOUT
	//
	//    * INVALID_API_KEY
	//
	//    * MISSING_AUTHENTICATION_TOKEN
	//
	//    * QUOTA_EXCEEDED
	//
	//    * REQUEST_TOO_LARGE
	//
	//    * RESOURCE_NOT_FOUND
	//
	//    * THROTTLED
	//
	//    * UNAUTHORIZED
	//
	//    * UNSUPPORTED_MEDIA_TYPE
	//
	// ResponseType is a required field
	ResponseType GatewayResponseType `location:"uri" locationName:"response_type" type:"string" required:"true" enum:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGatewayResponseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayResponseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteGatewayResponseInput"}
	if len(s.ResponseType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ResponseType"))
	}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteGatewayResponseInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.ResponseType) > 0 {
		v := s.ResponseType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "response_type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteGatewayResponseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGatewayResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteGatewayResponseOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteGatewayResponse = "DeleteGatewayResponse"

// DeleteGatewayResponseRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Clears any customization of a GatewayResponse of a specified response type
// on the given RestApi and resets it with the default settings.
//
//    // Example sending a request using DeleteGatewayResponseRequest.
//    req := client.DeleteGatewayResponseRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteGatewayResponseRequest(input *DeleteGatewayResponseInput) DeleteGatewayResponseRequest {
	op := &aws.Operation{
		Name:       opDeleteGatewayResponse,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/gatewayresponses/{response_type}",
	}

	if input == nil {
		input = &DeleteGatewayResponseInput{}
	}

	req := c.newRequest(op, input, &DeleteGatewayResponseOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteGatewayResponseRequest{Request: req, Input: input, Copy: c.DeleteGatewayResponseRequest}
}

// DeleteGatewayResponseRequest is the request type for the
// DeleteGatewayResponse API operation.
type DeleteGatewayResponseRequest struct {
	*aws.Request
	Input *DeleteGatewayResponseInput
	Copy  func(*DeleteGatewayResponseInput) DeleteGatewayResponseRequest
}

// Send marshals and sends the DeleteGatewayResponse API request.
func (r DeleteGatewayResponseRequest) Send(ctx context.Context) (*DeleteGatewayResponseResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteGatewayResponseResponse{
		DeleteGatewayResponseOutput: r.Request.Data.(*DeleteGatewayResponseOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteGatewayResponseResponse is the response type for the
// DeleteGatewayResponse API operation.
type DeleteGatewayResponseResponse struct {
	*DeleteGatewayResponseOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteGatewayResponse request.
func (r *DeleteGatewayResponseResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
