// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKeyRequest
type CreateApiKeyInput struct {
	_ struct{} `type:"structure"`

	// The ID for your GraphQL API.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A description of the purpose of the API key.
	Description *string `locationName:"description" type:"string"`

	// The time from creation time after which the API key expires. The date is
	// represented as seconds since the epoch, rounded down to the nearest hour.
	// The default value for this parameter is 7 days from creation time. For more
	// information, see .
	Expires *int64 `locationName:"expires" type:"long"`
}

// String returns the string representation
func (s CreateApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApiKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateApiKeyInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApiKeyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Expires != nil {
		v := *s.Expires

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expires", protocol.Int64Value(v), metadata)
	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKeyResponse
type CreateApiKeyOutput struct {
	_ struct{} `type:"structure"`

	// The API key.
	ApiKey *ApiKey `locationName:"apiKey" type:"structure"`
}

// String returns the string representation
func (s CreateApiKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApiKeyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiKey != nil {
		v := s.ApiKey

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "apiKey", v, metadata)
	}
	return nil
}

const opCreateApiKey = "CreateApiKey"

// CreateApiKeyRequest returns a request value for making API operation for
// AWS AppSync.
//
// Creates a unique key that you can distribute to clients who are executing
// your API.
//
//    // Example sending a request using CreateApiKeyRequest.
//    req := client.CreateApiKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKey
func (c *Client) CreateApiKeyRequest(input *CreateApiKeyInput) CreateApiKeyRequest {
	op := &aws.Operation{
		Name:       opCreateApiKey,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/apikeys",
	}

	if input == nil {
		input = &CreateApiKeyInput{}
	}

	req := c.newRequest(op, input, &CreateApiKeyOutput{})
	return CreateApiKeyRequest{Request: req, Input: input, Copy: c.CreateApiKeyRequest}
}

// CreateApiKeyRequest is the request type for the
// CreateApiKey API operation.
type CreateApiKeyRequest struct {
	*aws.Request
	Input *CreateApiKeyInput
	Copy  func(*CreateApiKeyInput) CreateApiKeyRequest
}

// Send marshals and sends the CreateApiKey API request.
func (r CreateApiKeyRequest) Send(ctx context.Context) (*CreateApiKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateApiKeyResponse{
		CreateApiKeyOutput: r.Request.Data.(*CreateApiKeyOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateApiKeyResponse is the response type for the
// CreateApiKey API operation.
type CreateApiKeyResponse struct {
	*CreateApiKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateApiKey request.
func (r *CreateApiKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
