// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleActionType
type CompleteLifecycleActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	InstanceId *string `min:"1" type:"string"`

	// The action for the group to take. This parameter can be either CONTINUE or
	// ABANDON.
	//
	// LifecycleActionResult is a required field
	LifecycleActionResult *string `type:"string" required:"true"`

	// A universally unique identifier (UUID) that identifies a specific lifecycle
	// action associated with an instance. Amazon EC2 Auto Scaling sends this token
	// to the notification target you specified when you created the lifecycle hook.
	LifecycleActionToken *string `min:"36" type:"string"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteLifecycleActionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteLifecycleActionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CompleteLifecycleActionInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if s.LifecycleActionResult == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifecycleActionResult"))
	}
	if s.LifecycleActionToken != nil && len(*s.LifecycleActionToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("LifecycleActionToken", 36))
	}

	if s.LifecycleHookName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleActionAnswer
type CompleteLifecycleActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CompleteLifecycleActionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCompleteLifecycleAction = "CompleteLifecycleAction"

// CompleteLifecycleActionRequest returns a request value for making API operation for
// Auto Scaling.
//
// Completes the lifecycle action for the specified token or instance with the
// specified result.
//
// This step is a part of the procedure for adding a lifecycle hook to an Auto
// Scaling group:
//
// (Optional) Create a Lambda function and a rule that allows CloudWatch Events
// to invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates
// instances.
//
// (Optional) Create a notification target and an IAM role. The target can be
// either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon
// EC2 Auto Scaling to publish lifecycle notifications to the target.
//
// Create the lifecycle hook. Specify whether the hook is used when the instances
// launch or terminate.
//
// If you need more time, record the lifecycle action heartbeat to keep the
// instance in a pending state.
//
// If you finish before the timeout period ends, complete the lifecycle action.
//
// For more information, see Amazon EC2 Auto Scaling Lifecycle Hooks (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using CompleteLifecycleActionRequest.
//    req := client.CompleteLifecycleActionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleAction
func (c *Client) CompleteLifecycleActionRequest(input *CompleteLifecycleActionInput) CompleteLifecycleActionRequest {
	op := &aws.Operation{
		Name:       opCompleteLifecycleAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteLifecycleActionInput{}
	}

	req := c.newRequest(op, input, &CompleteLifecycleActionOutput{})
	return CompleteLifecycleActionRequest{Request: req, Input: input, Copy: c.CompleteLifecycleActionRequest}
}

// CompleteLifecycleActionRequest is the request type for the
// CompleteLifecycleAction API operation.
type CompleteLifecycleActionRequest struct {
	*aws.Request
	Input *CompleteLifecycleActionInput
	Copy  func(*CompleteLifecycleActionInput) CompleteLifecycleActionRequest
}

// Send marshals and sends the CompleteLifecycleAction API request.
func (r CompleteLifecycleActionRequest) Send(ctx context.Context) (*CompleteLifecycleActionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CompleteLifecycleActionResponse{
		CompleteLifecycleActionOutput: r.Request.Data.(*CompleteLifecycleActionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CompleteLifecycleActionResponse is the response type for the
// CompleteLifecycleAction API operation.
type CompleteLifecycleActionResponse struct {
	*CompleteLifecycleActionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CompleteLifecycleAction request.
func (r *CompleteLifecycleActionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
