// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollectionQuery
type DisableMetricsCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more of the following metrics. If you omit this parameter, all metrics
	// are disabled.
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	Metrics []string `type:"list"`
}

// String returns the string representation
func (s DisableMetricsCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableMetricsCollectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableMetricsCollectionInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollectionOutput
type DisableMetricsCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableMetricsCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableMetricsCollection = "DisableMetricsCollection"

// DisableMetricsCollectionRequest returns a request value for making API operation for
// Auto Scaling.
//
// Disables group metrics for the specified Auto Scaling group.
//
//    // Example sending a request using DisableMetricsCollectionRequest.
//    req := client.DisableMetricsCollectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollection
func (c *Client) DisableMetricsCollectionRequest(input *DisableMetricsCollectionInput) DisableMetricsCollectionRequest {
	op := &aws.Operation{
		Name:       opDisableMetricsCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableMetricsCollectionInput{}
	}

	req := c.newRequest(op, input, &DisableMetricsCollectionOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DisableMetricsCollectionRequest{Request: req, Input: input, Copy: c.DisableMetricsCollectionRequest}
}

// DisableMetricsCollectionRequest is the request type for the
// DisableMetricsCollection API operation.
type DisableMetricsCollectionRequest struct {
	*aws.Request
	Input *DisableMetricsCollectionInput
	Copy  func(*DisableMetricsCollectionInput) DisableMetricsCollectionRequest
}

// Send marshals and sends the DisableMetricsCollection API request.
func (r DisableMetricsCollectionRequest) Send(ctx context.Context) (*DisableMetricsCollectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableMetricsCollectionResponse{
		DisableMetricsCollectionOutput: r.Request.Data.(*DisableMetricsCollectionOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableMetricsCollectionResponse is the response type for the
// DisableMetricsCollection API operation.
type DisableMetricsCollectionResponse struct {
	*DisableMetricsCollectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableMetricsCollection request.
func (r *DisableMetricsCollectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
