// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DisableDirectoryRequest
type DisableDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory to disable.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableDirectoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableDirectoryInput"}

	if s.DirectoryArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisableDirectoryInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DisableDirectoryResponse
type DisableDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory that has been disabled.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisableDirectoryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DirectoryArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDisableDirectory = "DisableDirectory"

// DisableDirectoryRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Disables the specified directory. Disabled directories cannot be read or
// written to. Only enabled directories can be disabled. Disabled directories
// may be reenabled.
//
//    // Example sending a request using DisableDirectoryRequest.
//    req := client.DisableDirectoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DisableDirectory
func (c *Client) DisableDirectoryRequest(input *DisableDirectoryInput) DisableDirectoryRequest {
	op := &aws.Operation{
		Name:       opDisableDirectory,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/directory/disable",
	}

	if input == nil {
		input = &DisableDirectoryInput{}
	}

	req := c.newRequest(op, input, &DisableDirectoryOutput{})
	return DisableDirectoryRequest{Request: req, Input: input, Copy: c.DisableDirectoryRequest}
}

// DisableDirectoryRequest is the request type for the
// DisableDirectory API operation.
type DisableDirectoryRequest struct {
	*aws.Request
	Input *DisableDirectoryInput
	Copy  func(*DisableDirectoryInput) DisableDirectoryRequest
}

// Send marshals and sends the DisableDirectory API request.
func (r DisableDirectoryRequest) Send(ctx context.Context) (*DisableDirectoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableDirectoryResponse{
		DisableDirectoryOutput: r.Request.Data.(*DisableDirectoryOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableDirectoryResponse is the response type for the
// DisableDirectory API operation.
type DisableDirectoryResponse struct {
	*DisableDirectoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableDirectory request.
func (r *DisableDirectoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
