// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Structure that contains the results of the account gate function which AWS
// CloudFormation invokes, if present, before proceeding with a stack set operation
// in an account and region.
//
// For each account and region, AWS CloudFormation lets you specify a Lamdba
// function that encapsulates any requirements that must be met before CloudFormation
// can proceed with a stack set operation in that account and region. CloudFormation
// invokes the function each time a stack set operation is requested for that
// account and region; if the function returns FAILED, CloudFormation cancels
// the operation in that account and region, and sets the stack set operation
// result status for that account and region to FAILED.
//
// For more information, see Configuring a target account gate (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-account-gating.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/AccountGateResult
type AccountGateResult struct {
	_ struct{} `type:"structure"`

	// The status of the account gate function.
	//
	//    * SUCCEEDED: The account gate function has determined that the account
	//    and region passes any requirements for a stack set operation to occur.
	//    AWS CloudFormation proceeds with the stack operation in that account and
	//    region.
	//
	//    * FAILED: The account gate function has determined that the account and
	//    region does not meet the requirements for a stack set operation to occur.
	//    AWS CloudFormation cancels the stack set operation in that account and
	//    region, and sets the stack set operation result status for that account
	//    and region to FAILED.
	//
	//    * SKIPPED: AWS CloudFormation has skipped calling the account gate function
	//    for this account and region, for one of the following reasons: An account
	//    gate function has not been specified for the account and region. AWS CloudFormation
	//    proceeds with the stack set operation in this account and region. The
	//    AWSCloudFormationStackSetExecutionRole of the stack set adminstration
	//    account lacks permissions to invoke the function. AWS CloudFormation proceeds
	//    with the stack set operation in this account and region. Either no action
	//    is necessary, or no action is possible, on the stack. AWS CloudFormation
	//    skips the stack set operation in this account and region.
	Status AccountGateStatus `type:"string" enum:"true"`

	// The reason for the account gate status assigned to this account and region
	// for the stack set operation.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s AccountGateResult) String() string {
	return awsutil.Prettify(s)
}

// The AccountLimit data type. For more information about account limits, see
// AWS CloudFormation Limits (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
// in the AWS CloudFormation User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/AccountLimit
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The name of the account limit.
	Name *string `type:"string"`

	// The value that is associated with the account limit name.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// The Change structure describes the changes AWS CloudFormation will perform
// if you execute the change set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Change
type Change struct {
	_ struct{} `type:"structure"`

	// A ResourceChange structure that describes the resource and action that AWS
	// CloudFormation will perform.
	ResourceChange *ResourceChange `type:"structure"`

	// The type of entity that AWS CloudFormation changes. Currently, the only entity
	// type is Resource.
	Type ChangeType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// The ChangeSetSummary structure describes a change set, its status, and the
// stack with which it's associated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ChangeSetSummary
type ChangeSetSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The name of the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Descriptive information about the change set.
	Description *string `min:"1" type:"string"`

	// If the change set execution status is AVAILABLE, you can execute the change
	// set. If you can’t execute the change set, the status indicates why. For
	// example, a change set might be in an UNAVAILABLE state because AWS CloudFormation
	// is still creating it or in an OBSOLETE state because the stack was already
	// updated.
	ExecutionStatus ExecutionStatus `type:"string" enum:"true"`

	// The ID of the stack with which the change set is associated.
	StackId *string `type:"string"`

	// The name of the stack with which the change set is associated.
	StackName *string `type:"string"`

	// The state of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE,
	// or FAILED.
	Status ChangeSetStatus `type:"string" enum:"true"`

	// A description of the change set's status. For example, if your change set
	// is in the FAILED state, AWS CloudFormation shows the error message.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s ChangeSetSummary) String() string {
	return awsutil.Prettify(s)
}

// The Export structure describes the exported output values for a stack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Export
type Export struct {
	_ struct{} `type:"structure"`

	// The stack that contains the exported output name and value.
	ExportingStackId *string `type:"string"`

	// The name of exported output value. Use this name and the Fn::ImportValue
	// function to import the associated value into other stacks. The name is defined
	// in the Export field in the associated stack's Outputs section.
	Name *string `type:"string"`

	// The value of the exported output, such as a resource physical ID. This value
	// is defined in the Export field in the associated stack's Outputs section.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Export) String() string {
	return awsutil.Prettify(s)
}

// The Output data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Output
type Output struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the output.
	Description *string `min:"1" type:"string"`

	// The name of the export associated with the output.
	ExportName *string `type:"string"`

	// The key associated with the output.
	OutputKey *string `type:"string"`

	// The value associated with the output.
	OutputValue *string `type:"string"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// The Parameter data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Parameter
type Parameter struct {
	_ struct{} `type:"structure"`

	// The key associated with the parameter. If you don't specify a key and value
	// for a particular parameter, AWS CloudFormation uses the default value that
	// is specified in your template.
	ParameterKey *string `type:"string"`

	// The input value associated with the parameter.
	ParameterValue *string `type:"string"`

	// Read-only. The value that corresponds to a Systems Manager parameter key.
	// This field is returned only for SSM parameter types (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types)
	// in the template.
	ResolvedValue *string `type:"string"`

	// During a stack update, use the existing parameter value that the stack is
	// using for a given parameter key. If you specify true, do not specify a parameter
	// value.
	UsePreviousValue *bool `type:"boolean"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// A set of criteria that AWS CloudFormation uses to validate parameter values.
// Although other constraints might be defined in the stack template, AWS CloudFormation
// returns only the AllowedValues property.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ParameterConstraints
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// A list of values that are permitted for a parameter.
	AllowedValues []string `type:"list"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// The ParameterDeclaration data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ParameterDeclaration
type ParameterDeclaration struct {
	_ struct{} `type:"structure"`

	// The default value of the parameter.
	DefaultValue *string `type:"string"`

	// The description that is associate with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag that indicates whether the parameter value is shown as plain text in
	// logs and in the AWS Management Console.
	NoEcho *bool `type:"boolean"`

	// The criteria that AWS CloudFormation uses to validate parameter values.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The name that is associated with the parameter.
	ParameterKey *string `type:"string"`

	// The type of parameter.
	ParameterType *string `type:"string"`
}

// String returns the string representation
func (s ParameterDeclaration) String() string {
	return awsutil.Prettify(s)
}

// Context information that enables AWS CloudFormation to uniquely identify
// a resource. AWS CloudFormation uses context key-value pairs in cases where
// a resource's logical and physical IDs are not enough to uniquely identify
// that resource. Each context key-value pair specifies a resource that contains
// the targeted resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PhysicalResourceIdContextKeyValuePair
type PhysicalResourceIdContextKeyValuePair struct {
	_ struct{} `type:"structure"`

	// The resource context key.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The resource context value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PhysicalResourceIdContextKeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// Information about a resource property whose actual value differs from its
// expected value, as defined in the stack template and any values specified
// as template parameters. These will be present only for resources whose StackResourceDriftStatus
// is MODIFIED. For more information, see Detecting Unregulated Configuration
// Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PropertyDifference
type PropertyDifference struct {
	_ struct{} `type:"structure"`

	// The actual property value of the resource property.
	//
	// ActualValue is a required field
	ActualValue *string `type:"string" required:"true"`

	// The type of property difference.
	//
	//    * ADD: A value has been added to a resource property that is an array
	//    or list data type.
	//
	//    * REMOVE: The property has been removed from the current resource configuration.
	//
	//    * NOT_EQUAL: The current property value differs from its expected value
	//    (as defined in the stack template and any values specified as template
	//    parameters).
	//
	// DifferenceType is a required field
	DifferenceType DifferenceType `type:"string" required:"true" enum:"true"`

	// The expected property value of the resource property, as defined in the stack
	// template and any values specified as template parameters.
	//
	// ExpectedValue is a required field
	ExpectedValue *string `type:"string" required:"true"`

	// The fully-qualified path to the resource property.
	//
	// PropertyPath is a required field
	PropertyPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PropertyDifference) String() string {
	return awsutil.Prettify(s)
}

// The ResourceChange structure describes the resource and the action that AWS
// CloudFormation will perform on it if you execute this change set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ResourceChange
type ResourceChange struct {
	_ struct{} `type:"structure"`

	// The action that AWS CloudFormation takes on the resource, such as Add (adds
	// a new resource), Modify (changes a resource), or Remove (deletes a resource).
	Action ChangeAction `type:"string" enum:"true"`

	// For the Modify action, a list of ResourceChangeDetail structures that describes
	// the changes that AWS CloudFormation will make to the resource.
	Details []ResourceChangeDetail `type:"list"`

	// The resource's logical ID, which is defined in the stack's template.
	LogicalResourceId *string `type:"string"`

	// The resource's physical ID (resource name). Resources that you are adding
	// don't have physical IDs because they haven't been created.
	PhysicalResourceId *string `type:"string"`

	// For the Modify action, indicates whether AWS CloudFormation will replace
	// the resource by creating a new one and deleting the old one. This value depends
	// on the value of the RequiresRecreation property in the ResourceTargetDefinition
	// structure. For example, if the RequiresRecreation field is Always and the
	// Evaluation field is Static, Replacement is True. If the RequiresRecreation
	// field is Always and the Evaluation field is Dynamic, Replacement is Conditionally.
	//
	// If you have multiple changes with different RequiresRecreation values, the
	// Replacement value depends on the change with the most impact. A RequiresRecreation
	// value of Always has the most impact, followed by Conditionally, and then
	// Never.
	Replacement Replacement `type:"string" enum:"true"`

	// The type of AWS CloudFormation resource, such as AWS::S3::Bucket.
	ResourceType *string `min:"1" type:"string"`

	// For the Modify action, indicates which resource attribute is triggering this
	// update, such as a change in the resource attribute's Metadata, Properties,
	// or Tags.
	Scope []ResourceAttribute `type:"list"`
}

// String returns the string representation
func (s ResourceChange) String() string {
	return awsutil.Prettify(s)
}

// For a resource with Modify as the action, the ResourceChange structure describes
// the changes AWS CloudFormation will make to that resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ResourceChangeDetail
type ResourceChangeDetail struct {
	_ struct{} `type:"structure"`

	// The identity of the entity that triggered this change. This entity is a member
	// of the group that is specified by the ChangeSource field. For example, if
	// you modified the value of the KeyPairName parameter, the CausingEntity is
	// the name of the parameter (KeyPairName).
	//
	// If the ChangeSource value is DirectModification, no value is given for CausingEntity.
	CausingEntity *string `type:"string"`

	// The group to which the CausingEntity value belongs. There are five entity
	// groups:
	//
	//    * ResourceReference entities are Ref intrinsic functions that refer to
	//    resources in the template, such as { "Ref" : "MyEC2InstanceResource" }.
	//
	//    * ParameterReference entities are Ref intrinsic functions that get template
	//    parameter values, such as { "Ref" : "MyPasswordParameter" }.
	//
	//    * ResourceAttribute entities are Fn::GetAtt intrinsic functions that get
	//    resource attribute values, such as { "Fn::GetAtt" : [ "MyEC2InstanceResource",
	//    "PublicDnsName" ] }.
	//
	//    * DirectModification entities are changes that are made directly to the
	//    template.
	//
	//    * Automatic entities are AWS::CloudFormation::Stack resource types, which
	//    are also known as nested stacks. If you made no changes to the AWS::CloudFormation::Stack
	//    resource, AWS CloudFormation sets the ChangeSource to Automatic because
	//    the nested stack's template might have changed. Changes to a nested stack's
	//    template aren't visible to AWS CloudFormation until you run an update
	//    on the parent stack.
	ChangeSource ChangeSource `type:"string" enum:"true"`

	// Indicates whether AWS CloudFormation can determine the target value, and
	// whether the target value will change before you execute a change set.
	//
	// For Static evaluations, AWS CloudFormation can determine that the target
	// value will change, and its value. For example, if you directly modify the
	// InstanceType property of an EC2 instance, AWS CloudFormation knows that this
	// property value will change, and its value, so this is a Static evaluation.
	//
	// For Dynamic evaluations, cannot determine the target value because it depends
	// on the result of an intrinsic function, such as a Ref or Fn::GetAtt intrinsic
	// function, when the stack is updated. For example, if your template includes
	// a reference to a resource that is conditionally recreated, the value of the
	// reference (the physical ID of the resource) might change, depending on if
	// the resource is recreated. If the resource is recreated, it will have a new
	// physical ID, so all references to that resource will also be updated.
	Evaluation EvaluationType `type:"string" enum:"true"`

	// A ResourceTargetDefinition structure that describes the field that AWS CloudFormation
	// will change and whether the resource will be recreated.
	Target *ResourceTargetDefinition `type:"structure"`
}

// String returns the string representation
func (s ResourceChangeDetail) String() string {
	return awsutil.Prettify(s)
}

// The field that AWS CloudFormation will change, such as the name of a resource's
// property, and whether the resource will be recreated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ResourceTargetDefinition
type ResourceTargetDefinition struct {
	_ struct{} `type:"structure"`

	// Indicates which resource attribute is triggering this update, such as a change
	// in the resource attribute's Metadata, Properties, or Tags.
	Attribute ResourceAttribute `type:"string" enum:"true"`

	// If the Attribute value is Properties, the name of the property. For all other
	// attributes, the value is null.
	Name *string `type:"string"`

	// If the Attribute value is Properties, indicates whether a change to this
	// property causes the resource to be recreated. The value can be Never, Always,
	// or Conditionally. To determine the conditions for a Conditionally recreation,
	// see the update behavior for that property (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.
	RequiresRecreation RequiresRecreation `type:"string" enum:"true"`
}

// String returns the string representation
func (s ResourceTargetDefinition) String() string {
	return awsutil.Prettify(s)
}

// Structure containing the rollback triggers for AWS CloudFormation to monitor
// during stack creation and updating operations, and for the specified monitoring
// period afterwards.
//
// Rollback triggers enable you to have AWS CloudFormation monitor the state
// of your application during stack creation and updating, and to roll back
// that operation if the application breaches the threshold of any of the alarms
// you've specified. For more information, see Monitor and Roll Back Stack Operations
// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-rollback-triggers.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration
type RollbackConfiguration struct {
	_ struct{} `type:"structure"`

	// The amount of time, in minutes, during which CloudFormation should monitor
	// all the rollback triggers after the stack creation or update operation deploys
	// all necessary resources.
	//
	// The default is 0 minutes.
	//
	// If you specify a monitoring period but do not specify any rollback triggers,
	// CloudFormation still waits the specified period of time before cleaning up
	// old resources after update operations. You can use this monitoring period
	// to perform any manual stack validation desired, and manually cancel the stack
	// creation or update (using CancelUpdateStack (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html),
	// for example) as necessary.
	//
	// If you specify 0 for this parameter, CloudFormation still monitors the specified
	// rollback triggers during stack creation and update operations. Then, for
	// update operations, it begins disposing of old resources immediately once
	// the operation completes.
	MonitoringTimeInMinutes *int64 `type:"integer"`

	// The triggers to monitor during stack creation or update actions.
	//
	// By default, AWS CloudFormation saves the rollback triggers specified for
	// a stack and applies them to any subsequent update operations for the stack,
	// unless you specify otherwise. If you do specify rollback triggers for this
	// parameter, those triggers replace any list of triggers previously specified
	// for the stack. This means:
	//
	//    * To use the rollback triggers previously specified for this stack, if
	//    any, don't specify this parameter.
	//
	//    * To specify new or updated rollback triggers, you must specify all the
	//    triggers that you want used for this stack, even triggers you've specifed
	//    before (for example, when creating the stack or during a previous stack
	//    update). Any triggers that you don't include in the updated list of triggers
	//    are no longer applied to the stack.
	//
	//    * To remove all currently specified triggers, specify an empty list for
	//    this parameter.
	//
	// If a specified trigger is missing, the entire stack operation fails and is
	// rolled back.
	RollbackTriggers []RollbackTrigger `type:"list"`
}

// String returns the string representation
func (s RollbackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RollbackConfiguration"}
	if s.RollbackTriggers != nil {
		for i, v := range s.RollbackTriggers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RollbackTriggers", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A rollback trigger AWS CloudFormation monitors during creation and updating
// of stacks. If any of the alarms you specify goes to ALARM state during the
// stack operation or within the specified monitoring period afterwards, CloudFormation
// rolls back the entire stack operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger
type RollbackTrigger struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rollback trigger.
	//
	// If a specified trigger is missing, the entire stack operation fails and is
	// rolled back.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The resource type of the rollback trigger. Currently, AWS::CloudWatch::Alarm
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html)
	// is the only supported resource type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RollbackTrigger) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackTrigger) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RollbackTrigger"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Stack data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Stack
type Stack struct {
	_ struct{} `type:"structure"`

	// The capabilities allowed in the stack.
	Capabilities []Capability `type:"list"`

	// The unique ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The time at which the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A user-defined description associated with the stack.
	Description *string `min:"1" type:"string"`

	// Boolean to enable or disable rollback on stack creation failures:
	//
	//    * true: disable rollback
	//
	//    * false: enable rollback
	DisableRollback *bool `type:"boolean"`

	// Information on whether a stack's actual configuration differs, or has drifted,
	// from it's expected configuration, as defined in the stack template and any
	// values specified as template parameters. For more information, see Detecting
	// Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackDriftInformation `type:"structure"`

	// Whether termination protection is enabled for the stack.
	//
	// For nested stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
	// termination protection is set on the root stack and cannot be changed directly
	// on the nested stack. For more information, see Protecting a Stack From Being
	// Deleted (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
	// in the AWS CloudFormation User Guide.
	EnableTerminationProtection *bool `type:"boolean"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// SNS topic ARNs to which stack related events are published.
	NotificationARNs []string `type:"list"`

	// A list of output structures.
	Outputs []Output `type:"list"`

	// A list of Parameter structures.
	Parameters []Parameter `type:"list"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the direct parent of this stack. For the first level of nested stacks,
	// the root stack is also the parent stack.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	ParentId *string `type:"string"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that is associated with the stack. During a stack operation, AWS CloudFormation
	// uses this role's credentials to make calls on your behalf.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the the top-level stack to which the nested stack ultimately belongs.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	RootId *string `type:"string"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Current status of the stack.
	//
	// StackStatus is a required field
	StackStatus StackStatus `type:"string" required:"true" enum:"true"`

	// Success/failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// A list of Tags that specify information about the stack.
	Tags []Tag `type:"list"`

	// The amount of time within which stack creation should complete.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// Contains information about whether the stack's actual configuration differs,
// or has drifted, from its expected configuration, as defined in the stack
// template and any values specified as template parameters. A stack is considered
// to have drifted if one or more of its resources have drifted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackDriftInformation
type StackDriftInformation struct {
	_ struct{} `type:"structure"`

	// Most recent time when a drift detection operation was initiated on the stack,
	// or any of its individual resources that support drift detection.
	LastCheckTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	//
	//    * DRIFTED: The stack differs from its expected template configuration.
	//    A stack is considered to have drifted if one or more of its resources
	//    have drifted.
	//
	//    * NOT_CHECKED: AWS CloudFormation has not checked if the stack differs
	//    from its expected template configuration.
	//
	//    * IN_SYNC: The stack's actual configuration matches its expected template
	//    configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	//
	// StackDriftStatus is a required field
	StackDriftStatus StackDriftStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StackDriftInformation) String() string {
	return awsutil.Prettify(s)
}

// Contains information about whether the stack's actual configuration differs,
// or has drifted, from its expected configuration, as defined in the stack
// template and any values specified as template parameters. A stack is considered
// to have drifted if one or more of its resources have drifted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackDriftInformationSummary
type StackDriftInformationSummary struct {
	_ struct{} `type:"structure"`

	// Most recent time when a drift detection operation was initiated on the stack,
	// or any of its individual resources that support drift detection.
	LastCheckTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	//
	//    * DRIFTED: The stack differs from its expected template configuration.
	//    A stack is considered to have drifted if one or more of its resources
	//    have drifted.
	//
	//    * NOT_CHECKED: AWS CloudFormation has not checked if the stack differs
	//    from its expected template configuration.
	//
	//    * IN_SYNC: The stack's actual configuration matches its expected template
	//    configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	//
	// StackDriftStatus is a required field
	StackDriftStatus StackDriftStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StackDriftInformationSummary) String() string {
	return awsutil.Prettify(s)
}

// The StackEvent data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackEvent
type StackEvent struct {
	_ struct{} `type:"structure"`

	// The token passed to the operation that generated this event.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// The unique ID of this event.
	//
	// EventId is a required field
	EventId *string `type:"string" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier associated with the physical instance of the
	// resource.
	PhysicalResourceId *string `type:"string"`

	// BLOB of the properties used to create the resource.
	ResourceProperties *string `type:"string"`

	// Current status of the resource.
	ResourceStatus ResourceStatus `type:"string" enum:"true"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to AWS Resource Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `min:"1" type:"string"`

	// The unique ID name of the instance of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// The name associated with a stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s StackEvent) String() string {
	return awsutil.Prettify(s)
}

// An AWS CloudFormation stack, in a specific account and region, that's part
// of a stack set operation. A stack instance is a reference to an attempted
// or actual stack in a given account within a given region. A stack instance
// can exist without a stack—for example, if the stack couldn't be created
// for some reason. A stack instance is associated with only one stack set.
// Each stack instance contains the ID of its associated stack set, as well
// as the ID of the actual stack and the stack status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackInstance
type StackInstance struct {
	_ struct{} `type:"structure"`

	// The name of the AWS account that the stack instance is associated with.
	Account *string `type:"string"`

	// A list of parameters from the stack set template whose values have been overridden
	// in this stack instance.
	ParameterOverrides []Parameter `type:"list"`

	// The name of the AWS region that the stack instance is associated with.
	Region *string `type:"string"`

	// The ID of the stack instance.
	StackId *string `type:"string"`

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string `type:"string"`

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	//    * INOPERABLE: A DeleteStackInstances operation has failed and left the
	//    stack in an unstable state. Stacks in this state are excluded from further
	//    UpdateStackSet operations. You might need to perform a DeleteStackInstances
	//    operation, with RetainStacks set to true, to delete the stack instance,
	//    and then delete the stack manually.
	//
	//    * OUTDATED: The stack isn't currently up to date with the stack set because:
	//    The associated stack failed during a CreateStackSet or UpdateStackSet
	//    operation. The stack was part of a CreateStackSet or UpdateStackSet operation
	//    that failed or was stopped before the stack was created or updated.
	//
	//    * CURRENT: The stack is currently up to date with the stack set.
	Status StackInstanceStatus `type:"string" enum:"true"`

	// The explanation for the specific status code that is assigned to this stack
	// instance.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s StackInstance) String() string {
	return awsutil.Prettify(s)
}

// The structure that contains summary information about a stack instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackInstanceSummary
type StackInstanceSummary struct {
	_ struct{} `type:"structure"`

	// The name of the AWS account that the stack instance is associated with.
	Account *string `type:"string"`

	// The name of the AWS region that the stack instance is associated with.
	Region *string `type:"string"`

	// The ID of the stack instance.
	StackId *string `type:"string"`

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string `type:"string"`

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	//    * INOPERABLE: A DeleteStackInstances operation has failed and left the
	//    stack in an unstable state. Stacks in this state are excluded from further
	//    UpdateStackSet operations. You might need to perform a DeleteStackInstances
	//    operation, with RetainStacks set to true, to delete the stack instance,
	//    and then delete the stack manually.
	//
	//    * OUTDATED: The stack isn't currently up to date with the stack set because:
	//    The associated stack failed during a CreateStackSet or UpdateStackSet
	//    operation. The stack was part of a CreateStackSet or UpdateStackSet operation
	//    that failed or was stopped before the stack was created or updated.
	//
	//    * CURRENT: The stack is currently up to date with the stack set.
	Status StackInstanceStatus `type:"string" enum:"true"`

	// The explanation for the specific status code assigned to this stack instance.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s StackInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// The StackResource data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResource
type StackResource struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// Information about whether the resource's actual configuration differs, or
	// has drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformation `type:"structure"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus ResourceStatus `type:"string" required:"true" enum:"true"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to AWS Resource Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s StackResource) String() string {
	return awsutil.Prettify(s)
}

// Contains detailed information about the specified stack resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResourceDetail
type StackResourceDetail struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// Information about whether the resource's actual configuration differs, or
	// has drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformation `type:"structure"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The content of the Metadata attribute declared for the resource. For more
	// information, see Metadata Attribute (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html)
	// in the AWS CloudFormation User Guide.
	Metadata *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus ResourceStatus `type:"string" required:"true" enum:"true"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. ((For more information, go to AWS Resource Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s StackResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// Contains the drift information for a resource that has been checked for drift.
// This includes actual and expected property values for resources in which
// AWS CloudFormation has detected drift. Only resource properties explicitly
// defined in the stack template are checked for drift. For more information,
// see Detecting Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
//
// Resources that do not currently support drift detection cannot be checked.
// For a list of resources that support drift detection, see Resources that
// Support Drift Detection (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// Use DetectStackResourceDrift to detect drift on individual resources, or
// DetectStackDrift to detect drift on all resources in a given stack that support
// drift detection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResourceDrift
type StackResourceDrift struct {
	_ struct{} `type:"structure"`

	// A JSON structure containing the actual property values of the stack resource.
	//
	// For resources whose StackResourceDriftStatus is DELETED, this structure will
	// not be present.
	ActualProperties *string `type:"string"`

	// A JSON structure containing the expected property values of the stack resource,
	// as defined in the stack template and any values specified as template parameters.
	//
	// For resources whose StackResourceDriftStatus is DELETED, this structure will
	// not be present.
	ExpectedProperties *string `type:"string"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Context information that enables AWS CloudFormation to uniquely identify
	// a resource. AWS CloudFormation uses context key-value pairs in cases where
	// a resource's logical and physical IDs are not enough to uniquely identify
	// that resource. Each context key-value pair specifies a unique resource that
	// contains the targeted resource.
	PhysicalResourceIdContext []PhysicalResourceIdContextKeyValuePair `type:"list"`

	// A collection of the resource properties whose actual values differ from their
	// expected values. These will be present only for resources whose StackResourceDriftStatus
	// is MODIFIED.
	PropertyDifferences []PropertyDifference `type:"list"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// The ID of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// Status of the resource's actual configuration compared to its expected configuration
	//
	//    * DELETED: The resource differs from its expected template configuration
	//    because the resource has been deleted.
	//
	//    * MODIFIED: One or more resource properties differ from their expected
	//    values (as defined in the stack template and any values specified as template
	//    parameters).
	//
	//    * IN_SYNC: The resources's actual configuration matches its expected template
	//    configuration.
	//
	//    * NOT_CHECKED: AWS CloudFormation does not currently return this value.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus StackResourceDriftStatus `type:"string" required:"true" enum:"true"`

	// Time at which AWS CloudFormation performed drift detection on the stack resource.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s StackResourceDrift) String() string {
	return awsutil.Prettify(s)
}

// Contains information about whether the resource's actual configuration differs,
// or has drifted, from its expected configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResourceDriftInformation
type StackResourceDriftInformation struct {
	_ struct{} `type:"structure"`

	// When AWS CloudFormation last checked if the resource had drifted from its
	// expected configuration.
	LastCheckTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Status of the resource's actual configuration compared to its expected configuration
	//
	//    * DELETED: The resource differs from its expected configuration in that
	//    it has been deleted.
	//
	//    * MODIFIED: The resource differs from its expected configuration.
	//
	//    * NOT_CHECKED: AWS CloudFormation has not checked if the resource differs
	//    from its expected configuration. Any resources that do not currently support
	//    drift detection have a status of NOT_CHECKED. For more information, see
	//    Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//
	//    * IN_SYNC: The resources's actual configuration matches its expected configuration.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus StackResourceDriftStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StackResourceDriftInformation) String() string {
	return awsutil.Prettify(s)
}

// Summarizes information about whether the resource's actual configuration
// differs, or has drifted, from its expected configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResourceDriftInformationSummary
type StackResourceDriftInformationSummary struct {
	_ struct{} `type:"structure"`

	// When AWS CloudFormation last checked if the resource had drifted from its
	// expected configuration.
	LastCheckTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Status of the resource's actual configuration compared to its expected configuration
	//
	//    * DELETED: The resource differs from its expected configuration in that
	//    it has been deleted.
	//
	//    * MODIFIED: The resource differs from its expected configuration.
	//
	//    * NOT_CHECKED: AWS CloudFormation has not checked if the resource differs
	//    from its expected configuration. Any resources that do not currently support
	//    drift detection have a status of NOT_CHECKED. For more information, see
	//    Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//    If you performed an ContinueUpdateRollback operation on a stack, any resources
	//    included in ResourcesToSkip will also have a status of NOT_CHECKED. For
	//    more information on skipping resources during rollback operations, see
	//    Continue Rolling Back an Update (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html)
	//    in the AWS CloudFormation User Guide.
	//
	//    * IN_SYNC: The resources's actual configuration matches its expected configuration.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus StackResourceDriftStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StackResourceDriftInformationSummary) String() string {
	return awsutil.Prettify(s)
}

// Contains high-level information about the specified stack resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResourceSummary
type StackResourceSummary struct {
	_ struct{} `type:"structure"`

	// Information about whether the resource's actual configuration differs, or
	// has drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformationSummary `type:"structure"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of the resource.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus ResourceStatus `type:"string" required:"true" enum:"true"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to AWS Resource Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StackResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// A structure that contains information about a stack set. A stack set enables
// you to provision stacks into AWS accounts and across regions by using a single
// CloudFormation template. In the stack set, you specify the template to use,
// as well as any parameters and capabilities that the template requires.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSet
type StackSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the IAM role used to create or update
	// the stack set.
	//
	// Use customized administrator roles to control which users or groups can manage
	// specific stack sets within the same administrator account. For more information,
	// see Prerequisites: Granting Permissions for Stack Set Operations (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// The capabilities that are allowed in the stack set. Some stack set templates
	// might include resources that can affect permissions in your AWS account—for
	// example, by creating new AWS Identity and Access Management (IAM) users.
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates. (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities)
	Capabilities []Capability `type:"list"`

	// A description of the stack set that you specify when the stack set is created
	// or updated.
	Description *string `min:"1" type:"string"`

	// The name of the IAM execution role used to create or update the stack set.
	//
	// Use customized execution roles to control which stack resources users and
	// groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// A list of input parameters for a stack set.
	Parameters []Parameter `type:"list"`

	// The Amazon Resource Number (ARN) of the stack set.
	StackSetARN *string `type:"string"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The name that's associated with the stack set.
	StackSetName *string `type:"string"`

	// The status of the stack set.
	Status StackSetStatus `type:"string" enum:"true"`

	// A list of tags that specify information about the stack set. A maximum number
	// of 50 tags can be specified.
	Tags []Tag `type:"list"`

	// The structure that contains the body of the template that was used to create
	// or update the stack set.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StackSet) String() string {
	return awsutil.Prettify(s)
}

// The structure that contains information about a stack set operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetOperation
type StackSetOperation struct {
	_ struct{} `type:"structure"`

	// The type of stack set operation: CREATE, UPDATE, or DELETE. Create and delete
	// operations affect only the specified stack set instances that are associated
	// with the specified stack set. Update operations affect both the stack set
	// itself, as well as all associated stack set instances.
	Action StackSetOperationAction `type:"string" enum:"true"`

	// The Amazon Resource Number (ARN) of the IAM role used to perform this stack
	// set operation.
	//
	// Use customized administrator roles to control which users or groups can manage
	// specific stack sets within the same administrator account. For more information,
	// see Define Permissions for Multiple Administrators (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// The time at which the operation was initiated. Note that the creation times
	// for the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because AWS CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time at which the stack set operation ended, across all accounts and
	// regions specified. Note that this doesn't necessarily mean that the stack
	// set operation was successful, or even attempted, in each account or region.
	EndTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the IAM execution role used to create or update the stack set.
	//
	// Use customized execution roles to control which stack resources users and
	// groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// The unique ID of a stack set operation.
	OperationId *string `min:"1" type:"string"`

	// The preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// For stack set operations of action type DELETE, specifies whether to remove
	// the stack instances from the specified stack set, but doesn't delete the
	// stacks. You can't reassociate a retained stack, or add an existing, saved
	// stack to a new stack set.
	RetainStacks *bool `type:"boolean"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The status of the operation.
	//
	//    * FAILED: The operation exceeded the specified failure tolerance. The
	//    failure tolerance value that you've set for an operation is applied for
	//    each region during stack create and update operations. If the number of
	//    failed stacks within a region exceeds the failure tolerance, the status
	//    of the operation in the region is set to FAILED. This in turn sets the
	//    status of the operation as a whole to FAILED, and AWS CloudFormation cancels
	//    the operation in any remaining regions.
	//
	//    * RUNNING: The operation is currently being performed.
	//
	//    * STOPPED: The user has cancelled the operation.
	//
	//    * STOPPING: The operation is in the process of stopping, at user request.
	//
	//    * SUCCEEDED: The operation completed creating or updating all the specified
	//    stacks without exceeding the failure tolerance for the operation.
	Status StackSetOperationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StackSetOperation) String() string {
	return awsutil.Prettify(s)
}

// The user-specified preferences for how AWS CloudFormation performs a stack
// set operation.
//
// For more information on maximum concurrent accounts and failure tolerance,
// see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetOperationPreferences
type StackSetOperationPreferences struct {
	_ struct{} `type:"structure"`

	// The number of accounts, per region, for which this operation can fail before
	// AWS CloudFormation stops the operation in that region. If the operation is
	// stopped in a region, AWS CloudFormation doesn't attempt the operation in
	// any subsequent regions.
	//
	// Conditional: You must specify either FailureToleranceCount or FailureTolerancePercentage
	// (but not both).
	FailureToleranceCount *int64 `type:"integer"`

	// The percentage of accounts, per region, for which this stack operation can
	// fail before AWS CloudFormation stops the operation in that region. If the
	// operation is stopped in a region, AWS CloudFormation doesn't attempt the
	// operation in any subsequent regions.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS CloudFormation rounds down to the next whole number.
	//
	// Conditional: You must specify either FailureToleranceCount or FailureTolerancePercentage,
	// but not both.
	FailureTolerancePercentage *int64 `type:"integer"`

	// The maximum number of accounts in which to perform this operation at one
	// time. This is dependent on the value of FailureToleranceCount—MaxConcurrentCount
	// is at most one more than the FailureToleranceCount .
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Conditional: You must specify either MaxConcurrentCount or MaxConcurrentPercentage,
	// but not both.
	MaxConcurrentCount *int64 `min:"1" type:"integer"`

	// The maximum percentage of accounts in which to perform this operation at
	// one time.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS CloudFormation rounds down to the next whole number. This is true except
	// in cases where rounding down would result is zero. In this case, CloudFormation
	// sets the number as one instead.
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Conditional: You must specify either MaxConcurrentCount or MaxConcurrentPercentage,
	// but not both.
	MaxConcurrentPercentage *int64 `min:"1" type:"integer"`

	// The order of the regions in where you want to perform the stack operation.
	RegionOrder []string `type:"list"`
}

// String returns the string representation
func (s StackSetOperationPreferences) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StackSetOperationPreferences) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StackSetOperationPreferences"}
	if s.MaxConcurrentCount != nil && *s.MaxConcurrentCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxConcurrentCount", 1))
	}
	if s.MaxConcurrentPercentage != nil && *s.MaxConcurrentPercentage < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxConcurrentPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The structure that contains information about a specified operation's results
// for a given account in a given region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetOperationResultSummary
type StackSetOperationResultSummary struct {
	_ struct{} `type:"structure"`

	// The name of the AWS account for this operation result.
	Account *string `type:"string"`

	// The results of the account gate function AWS CloudFormation invokes, if present,
	// before proceeding with stack set operations in an account
	AccountGateResult *AccountGateResult `type:"structure"`

	// The name of the AWS region for this operation result.
	Region *string `type:"string"`

	// The result status of the stack set operation for the given account in the
	// given region.
	//
	//    * CANCELLED: The operation in the specified account and region has been
	//    cancelled. This is either because a user has stopped the stack set operation,
	//    or because the failure tolerance of the stack set operation has been exceeded.
	//
	//    * FAILED: The operation in the specified account and region failed. If
	//    the stack set operation fails in enough accounts within a region, the
	//    failure tolerance for the stack set operation as a whole might be exceeded.
	//
	//    * RUNNING: The operation in the specified account and region is currently
	//    in progress.
	//
	//    * PENDING: The operation in the specified account and region has yet to
	//    start.
	//
	//    * SUCCEEDED: The operation in the specified account and region completed
	//    successfully.
	Status StackSetOperationResultStatus `type:"string" enum:"true"`

	// The reason for the assigned result status.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s StackSetOperationResultSummary) String() string {
	return awsutil.Prettify(s)
}

// The structures that contain summary information about the specified operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetOperationSummary
type StackSetOperationSummary struct {
	_ struct{} `type:"structure"`

	// The type of operation: CREATE, UPDATE, or DELETE. Create and delete operations
	// affect only the specified stack instances that are associated with the specified
	// stack set. Update operations affect both the stack set itself as well as
	// all associated stack set instances.
	Action StackSetOperationAction `type:"string" enum:"true"`

	// The time at which the operation was initiated. Note that the creation times
	// for the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because AWS CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time at which the stack set operation ended, across all accounts and
	// regions specified. Note that this doesn't necessarily mean that the stack
	// set operation was successful, or even attempted, in each account or region.
	EndTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique ID of the stack set operation.
	OperationId *string `min:"1" type:"string"`

	// The overall status of the operation.
	//
	//    * FAILED: The operation exceeded the specified failure tolerance. The
	//    failure tolerance value that you've set for an operation is applied for
	//    each region during stack create and update operations. If the number of
	//    failed stacks within a region exceeds the failure tolerance, the status
	//    of the operation in the region is set to FAILED. This in turn sets the
	//    status of the operation as a whole to FAILED, and AWS CloudFormation cancels
	//    the operation in any remaining regions.
	//
	//    * RUNNING: The operation is currently being performed.
	//
	//    * STOPPED: The user has cancelled the operation.
	//
	//    * STOPPING: The operation is in the process of stopping, at user request.
	//
	//    * SUCCEEDED: The operation completed creating or updating all the specified
	//    stacks without exceeding the failure tolerance for the operation.
	Status StackSetOperationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StackSetOperationSummary) String() string {
	return awsutil.Prettify(s)
}

// The structures that contain summary information about the specified stack
// set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetSummary
type StackSetSummary struct {
	_ struct{} `type:"structure"`

	// A description of the stack set that you specify when the stack set is created
	// or updated.
	Description *string `min:"1" type:"string"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The name of the stack set.
	StackSetName *string `type:"string"`

	// The status of the stack set.
	Status StackSetStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StackSetSummary) String() string {
	return awsutil.Prettify(s)
}

// The StackSummary Data Type
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSummary
type StackSummary struct {
	_ struct{} `type:"structure"`

	// The time the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Summarizes information on whether a stack's actual configuration differs,
	// or has drifted, from it's expected configuration, as defined in the stack
	// template and any values specified as template parameters. For more information,
	// see Detecting Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackDriftInformationSummary `type:"structure"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the direct parent of this stack. For the first level of nested stacks,
	// the root stack is also the parent stack.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	ParentId *string `type:"string"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the the top-level stack to which the nested stack ultimately belongs.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	RootId *string `type:"string"`

	// Unique stack identifier.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// The current status of the stack.
	//
	// StackStatus is a required field
	StackStatus StackStatus `type:"string" required:"true" enum:"true"`

	// Success/Failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// The template description of the template used to create the stack.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// The Tag type enables you to specify a key-value pair that can be used to
// store information about an AWS CloudFormation stack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// Required. A string used to identify this tag. You can specify a maximum of
	// 128 characters for a tag key. Tags owned by Amazon Web Services (AWS) have
	// the reserved prefix: aws:.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Required. A string containing the value for this tag. You can specify a maximum
	// of 256 characters for a tag value.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The TemplateParameter data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TemplateParameter
type TemplateParameter struct {
	_ struct{} `type:"structure"`

	// The default value associated with the parameter.
	DefaultValue *string `type:"string"`

	// User defined description associated with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag indicating whether the parameter should be displayed as plain text in
	// logs and UIs.
	NoEcho *bool `type:"boolean"`

	// The name associated with the parameter.
	ParameterKey *string `type:"string"`
}

// String returns the string representation
func (s TemplateParameter) String() string {
	return awsutil.Prettify(s)
}
