// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// A complex type that lists the AWS accounts, if any, that you included in
// the TrustedSigners complex type for this distribution. These are the accounts
// that you want to allow to create signed URLs for private content.
//
// The Signer complex type lists the AWS account number of the trusted signer
// or self if the signer is the AWS account that created the distribution. The
// Signer element also includes the IDs of any active CloudFront key pairs that
// are associated with the trusted signer's AWS account. If no KeyPairId element
// appears for a Signer, that signer can't create signed URLs.
//
// For more information, see Serving Private Content through CloudFront (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/ActiveTrustedSigners
type ActiveTrustedSigners struct {
	_ struct{} `type:"structure"`

	// Enabled is true if any of the AWS accounts listed in the TrustedSigners complex
	// type for this RTMP distribution have active CloudFront key pairs. If not,
	// Enabled is false.
	//
	// For more information, see ActiveTrustedSigners.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A complex type that contains one Signer complex type for each trusted signer
	// that is specified in the TrustedSigners complex type.
	//
	// For more information, see ActiveTrustedSigners.
	Items []Signer `locationNameList:"Signer" type:"list"`

	// A complex type that contains one Signer complex type for each trusted signer
	// specified in the TrustedSigners complex type.
	//
	// For more information, see ActiveTrustedSigners.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ActiveTrustedSigners) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActiveTrustedSigners) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Signer"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains information about CNAMEs (alternate domain names),
// if any, for this distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Aliases
type Aliases struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the CNAME aliases, if any, that you want to
	// associate with this distribution.
	Items []string `locationNameList:"CNAME" type:"list"`

	// The number of CNAME aliases, if any, that you want to associate with this
	// distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Aliases) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Aliases) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Aliases"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Aliases) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "CNAME"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that controls which HTTP methods CloudFront processes and
// forwards to your Amazon S3 bucket or your custom origin. There are three
// choices:
//
//    * CloudFront forwards only GET and HEAD requests.
//
//    * CloudFront forwards only GET, HEAD, and OPTIONS requests.
//
//    * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
//    requests.
//
// If you pick the third choice, you may need to restrict access to your Amazon
// S3 bucket or to your custom origin so users can't perform operations that
// you don't want them to. For example, you might not want users to have permissions
// to delete objects from your origin.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/AllowedMethods
type AllowedMethods struct {
	_ struct{} `type:"structure"`

	// A complex type that controls whether CloudFront caches the response to requests
	// using the specified HTTP methods. There are two choices:
	//
	//    * CloudFront caches responses to GET and HEAD requests.
	//
	//    * CloudFront caches responses to GET, HEAD, and OPTIONS requests.
	//
	// If you pick the second choice for your Amazon S3 Origin, you may need to
	// forward Access-Control-Request-Method, Access-Control-Request-Headers, and
	// Origin headers for the responses to be cached correctly.
	CachedMethods *CachedMethods `type:"structure"`

	// A complex type that contains the HTTP methods that you want CloudFront to
	// process and forward to your origin.
	//
	// Items is a required field
	Items []Method `locationNameList:"Method" type:"list" required:"true"`

	// The number of HTTP methods that you want CloudFront to forward to your origin.
	// Valid values are 2 (for GET and HEAD requests), 3 (for GET, HEAD, and OPTIONS
	// requests) and 7 (for GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE requests).
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s AllowedMethods) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllowedMethods) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AllowedMethods"}

	if s.Items == nil {
		invalidParams.Add(aws.NewErrParamRequired("Items"))
	}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.CachedMethods != nil {
		if err := s.CachedMethods.Validate(); err != nil {
			invalidParams.AddNested("CachedMethods", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AllowedMethods) MarshalFields(e protocol.FieldEncoder) error {
	if s.CachedMethods != nil {
		v := s.CachedMethods

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CachedMethods", v, metadata)
	}
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Method"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that describes how CloudFront processes requests.
//
// You must create at least as many cache behaviors (including the default cache
// behavior) as you have origins if you want CloudFront to distribute objects
// from all of the origins. Each cache behavior specifies the one origin from
// which you want CloudFront to get objects. If you have two origins and only
// the default cache behavior, the default cache behavior will cause CloudFront
// to get objects from one of the origins, but the other origin is never used.
//
// For the current limit on the number of cache behaviors that you can add to
// a distribution, see Amazon CloudFront Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_cloudfront)
// in the AWS General Reference.
//
// If you don't want to specify any cache behaviors, include only an empty CacheBehaviors
// element. Don't include an empty CacheBehavior element, or CloudFront returns
// a MalformedXML error.
//
// To delete all cache behaviors in an existing distribution, update the distribution
// configuration and include only an empty CacheBehaviors element.
//
// To add, change, or remove one or more cache behaviors, update the distribution
// configuration and specify all of the cache behaviors that you want to include
// in the updated distribution.
//
// For more information about cache behaviors, see Cache Behaviors (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CacheBehavior
type CacheBehavior struct {
	_ struct{} `type:"structure"`

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices:
	//
	//    * CloudFront forwards only GET and HEAD requests.
	//
	//    * CloudFront forwards only GET, HEAD, and OPTIONS requests.
	//
	//    * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
	//    requests.
	//
	// If you pick the third choice, you may need to restrict access to your Amazon
	// S3 bucket or to your custom origin so users can't perform operations that
	// you don't want them to. For example, you might not want users to have permissions
	// to delete objects from your origin.
	AllowedMethods *AllowedMethods `type:"structure"`

	// Whether you want CloudFront to automatically compress certain files for this
	// cache behavior. If so, specify true; if not, specify false. For more information,
	// see Serving Compressed Files (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html)
	// in the Amazon CloudFront Developer Guide.
	Compress *bool `type:"boolean"`

	// The default amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin does not add HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Specifying How
	// Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	DefaultTTL *int64 `type:"long"`

	// The value of ID for the field-level encryption configuration that you want
	// CloudFront to use for encrypting specific fields of data for a cache behavior
	// or for the default cache behavior in your distribution.
	FieldLevelEncryptionId *string `type:"string"`

	// A complex type that specifies how CloudFront handles query strings and cookies.
	//
	// ForwardedValues is a required field
	ForwardedValues *ForwardedValues `type:"structure" required:"true"`

	// A complex type that contains zero or more Lambda function associations for
	// a cache behavior.
	LambdaFunctionAssociations *LambdaFunctionAssociations `type:"structure"`

	// The maximum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin adds HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Specifying How
	// Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	MaxTTL *int64 `type:"long"`

	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. For more information, see Specifying How Long
	// Objects and Errors Stay in a CloudFront Edge Cache (Expiration) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon Amazon CloudFront Developer Guide.
	//
	// You must specify 0 for MinTTL if you configure CloudFront to forward all
	// headers to your origin (under Headers, if you specify 1 for Quantity and
	// * for Name).
	//
	// MinTTL is a required field
	MinTTL *int64 `type:"long" required:"true"`

	// The pattern (for example, images/*.jpg) that specifies which requests to
	// apply the behavior to. When CloudFront receives a viewer request, the requested
	// path is compared with path patterns in the order in which cache behaviors
	// are listed in the distribution.
	//
	// You can optionally include a slash (/) at the beginning of the path pattern.
	// For example, /images/*.jpg. CloudFront behavior is the same with or without
	// the leading /.
	//
	// The path pattern for the default cache behavior is * and cannot be changed.
	// If the request for an object does not match the path pattern for any cache
	// behaviors, CloudFront applies the behavior in the default cache behavior.
	//
	// For more information, see Path Pattern (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern)
	// in the Amazon CloudFront Developer Guide.
	//
	// PathPattern is a required field
	PathPattern *string `type:"string" required:"true"`

	// Indicates whether you want to distribute media files in the Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true; if not, specify false. If you specify true for SmoothStreaming,
	// you can still distribute other content using this cache behavior if the content
	// matches the value of PathPattern.
	SmoothStreaming *bool `type:"boolean"`

	// The value of ID for the origin that you want CloudFront to route requests
	// to when a request matches the path pattern either for a cache behavior or
	// for the default cache behavior in your distribution.
	//
	// TargetOriginId is a required field
	TargetOriginId *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content.
	//
	// If you want to require signed URLs in requests for objects in the target
	// origin that match the PathPattern for this cache behavior, specify true for
	// Enabled, and specify the applicable values for Quantity and Items. For more
	// information, see Serving Private Content through CloudFront (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon Amazon CloudFront Developer Guide.
	//
	// If you don't want to require signed URLs in requests for objects that match
	// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items.
	//
	// To add, change, or remove one or more trusted signers, change Enabled to
	// true (if it's currently false), change Quantity as applicable, and specify
	// all of the trusted signers that you want to include in the updated distribution.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`

	// The protocol that viewers can use to access the files in the origin specified
	// by TargetOriginId when a request matches the path pattern in PathPattern.
	// You can specify the following options:
	//
	//    * allow-all: Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https: If a viewer submits an HTTP request, CloudFront returns
	//    an HTTP status code of 301 (Moved Permanently) to the viewer along with
	//    the HTTPS URL. The viewer then resubmits the request using the new URL.
	//
	//    * https-only: If a viewer sends an HTTP request, CloudFront returns an
	//    HTTP status code of 403 (Forbidden).
	//
	// For more information about requiring the HTTPS protocol, see Using an HTTPS
	// Connection to Access Your Objects (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The only way to guarantee that viewers retrieve an object that was fetched
	// from the origin using HTTPS is never to use any other protocol to fetch the
	// object. If you have recently changed from HTTP to HTTPS, we recommend that
	// you clear your objects' cache because cached objects are protocol agnostic.
	// That means that an edge location will return an object from the cache regardless
	// of whether the current request protocol matches the protocol used previously.
	// For more information, see Specifying How Long Objects and Errors Stay in
	// a CloudFront Edge Cache (Expiration) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// ViewerProtocolPolicy is a required field
	ViewerProtocolPolicy ViewerProtocolPolicy `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CacheBehavior) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CacheBehavior"}

	if s.ForwardedValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForwardedValues"))
	}

	if s.MinTTL == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinTTL"))
	}

	if s.PathPattern == nil {
		invalidParams.Add(aws.NewErrParamRequired("PathPattern"))
	}

	if s.TargetOriginId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetOriginId"))
	}

	if s.TrustedSigners == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrustedSigners"))
	}
	if len(s.ViewerProtocolPolicy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ViewerProtocolPolicy"))
	}
	if s.AllowedMethods != nil {
		if err := s.AllowedMethods.Validate(); err != nil {
			invalidParams.AddNested("AllowedMethods", err.(aws.ErrInvalidParams))
		}
	}
	if s.ForwardedValues != nil {
		if err := s.ForwardedValues.Validate(); err != nil {
			invalidParams.AddNested("ForwardedValues", err.(aws.ErrInvalidParams))
		}
	}
	if s.LambdaFunctionAssociations != nil {
		if err := s.LambdaFunctionAssociations.Validate(); err != nil {
			invalidParams.AddNested("LambdaFunctionAssociations", err.(aws.ErrInvalidParams))
		}
	}
	if s.TrustedSigners != nil {
		if err := s.TrustedSigners.Validate(); err != nil {
			invalidParams.AddNested("TrustedSigners", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CacheBehavior) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowedMethods != nil {
		v := s.AllowedMethods

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AllowedMethods", v, metadata)
	}
	if s.Compress != nil {
		v := *s.Compress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Compress", protocol.BoolValue(v), metadata)
	}
	if s.DefaultTTL != nil {
		v := *s.DefaultTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultTTL", protocol.Int64Value(v), metadata)
	}
	if s.FieldLevelEncryptionId != nil {
		v := *s.FieldLevelEncryptionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldLevelEncryptionId", protocol.StringValue(v), metadata)
	}
	if s.ForwardedValues != nil {
		v := s.ForwardedValues

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ForwardedValues", v, metadata)
	}
	if s.LambdaFunctionAssociations != nil {
		v := s.LambdaFunctionAssociations

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LambdaFunctionAssociations", v, metadata)
	}
	if s.MaxTTL != nil {
		v := *s.MaxTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxTTL", protocol.Int64Value(v), metadata)
	}
	if s.MinTTL != nil {
		v := *s.MinTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MinTTL", protocol.Int64Value(v), metadata)
	}
	if s.PathPattern != nil {
		v := *s.PathPattern

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PathPattern", protocol.StringValue(v), metadata)
	}
	if s.SmoothStreaming != nil {
		v := *s.SmoothStreaming

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SmoothStreaming", protocol.BoolValue(v), metadata)
	}
	if s.TargetOriginId != nil {
		v := *s.TargetOriginId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetOriginId", protocol.StringValue(v), metadata)
	}
	if s.TrustedSigners != nil {
		v := s.TrustedSigners

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TrustedSigners", v, metadata)
	}
	if len(s.ViewerProtocolPolicy) > 0 {
		v := s.ViewerProtocolPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ViewerProtocolPolicy", v, metadata)
	}
	return nil
}

// A complex type that contains zero or more CacheBehavior elements.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CacheBehaviors
type CacheBehaviors struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains cache behaviors for this distribution.
	// If Quantity is 0, you can omit Items.
	Items []CacheBehavior `locationNameList:"CacheBehavior" type:"list"`

	// The number of cache behaviors for this distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CacheBehaviors) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CacheBehaviors) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CacheBehaviors"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CacheBehaviors) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "CacheBehavior"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that controls whether CloudFront caches the response to requests
// using the specified HTTP methods. There are two choices:
//
//    * CloudFront caches responses to GET and HEAD requests.
//
//    * CloudFront caches responses to GET, HEAD, and OPTIONS requests.
//
// If you pick the second choice for your Amazon S3 Origin, you may need to
// forward Access-Control-Request-Method, Access-Control-Request-Headers, and
// Origin headers for the responses to be cached correctly.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CachedMethods
type CachedMethods struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the HTTP methods that you want CloudFront to
	// cache responses to.
	//
	// Items is a required field
	Items []Method `locationNameList:"Method" type:"list" required:"true"`

	// The number of HTTP methods for which you want CloudFront to cache responses.
	// Valid values are 2 (for caching responses to GET and HEAD requests) and 3
	// (for caching responses to GET, HEAD, and OPTIONS requests).
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CachedMethods) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CachedMethods) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CachedMethods"}

	if s.Items == nil {
		invalidParams.Add(aws.NewErrParamRequired("Items"))
	}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CachedMethods) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Method"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// CloudFront origin access identity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CloudFrontOriginAccessIdentity
type CloudFrontOriginAccessIdentity struct {
	_ struct{} `type:"structure"`

	// The current configuration information for the identity.
	CloudFrontOriginAccessIdentityConfig *CloudFrontOriginAccessIdentityConfig `type:"structure"`

	// The ID for the origin access identity, for example, E74FTE3AJFJ256A.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The Amazon S3 canonical user ID for the origin access identity, used when
	// giving the origin access identity read permission to an object in Amazon
	// S3.
	//
	// S3CanonicalUserId is a required field
	S3CanonicalUserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CloudFrontOriginAccessIdentity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudFrontOriginAccessIdentity) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudFrontOriginAccessIdentityConfig != nil {
		v := s.CloudFrontOriginAccessIdentityConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CloudFrontOriginAccessIdentityConfig", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.S3CanonicalUserId != nil {
		v := *s.S3CanonicalUserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3CanonicalUserId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Origin access identity configuration. Send a GET request to the /CloudFront
// API version/CloudFront/identity ID/config resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CloudFrontOriginAccessIdentityConfig
type CloudFrontOriginAccessIdentityConfig struct {
	_ struct{} `type:"structure"`

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// CloudFrontOriginAccessIdentityConfig object), a new origin access identity
	// is created.
	//
	// If the CallerReference is a value already sent in a previous identity request,
	// and the content of the CloudFrontOriginAccessIdentityConfig is identical
	// to the original request (ignoring white space), the response includes the
	// same information returned to the original request.
	//
	// If the CallerReference is a value you already sent in a previous request
	// to create an identity, but the content of the CloudFrontOriginAccessIdentityConfig
	// is different from the original request, CloudFront returns a CloudFrontOriginAccessIdentityAlreadyExists
	// error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the origin access identity.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CloudFrontOriginAccessIdentityConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudFrontOriginAccessIdentityConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudFrontOriginAccessIdentityConfig"}

	if s.CallerReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("CallerReference"))
	}

	if s.Comment == nil {
		invalidParams.Add(aws.NewErrParamRequired("Comment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudFrontOriginAccessIdentityConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	return nil
}

// Lists the origin access identities for CloudFront.Send a GET request to the
// /CloudFront API version/origin-access-identity/cloudfront resource. The response
// includes a CloudFrontOriginAccessIdentityList element with zero or more CloudFrontOriginAccessIdentitySummary
// child elements. By default, your entire list of origin access identities
// is returned in one single page. If the list is long, you can paginate it
// using the MaxItems and Marker parameters.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CloudFrontOriginAccessIdentityList
type CloudFrontOriginAccessIdentityList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more origin access identities remain to be
	// listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more items in the
	// list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one CloudFrontOriginAccessIdentitySummary element
	// for each origin access identity that was created by the current AWS account.
	Items []CloudFrontOriginAccessIdentitySummary `locationNameList:"CloudFrontOriginAccessIdentitySummary" type:"list"`

	// Use this when paginating results to indicate where to begin in your list
	// of origin access identities. The results include identities in the list that
	// occur after the marker. To get the next page of results, set the Marker to
	// the value of the NextMarker from the current page's response (which is also
	// the ID of the last identity on that page).
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The maximum number of origin access identities you want in the response body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your origin
	// access identities where they left off.
	NextMarker *string `type:"string"`

	// The number of CloudFront origin access identities that were created by the
	// current AWS account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CloudFrontOriginAccessIdentityList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudFrontOriginAccessIdentityList) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "CloudFrontOriginAccessIdentitySummary"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.StringValue(v), metadata)
	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Summary of the information about a CloudFront origin access identity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CloudFrontOriginAccessIdentitySummary
type CloudFrontOriginAccessIdentitySummary struct {
	_ struct{} `type:"structure"`

	// The comment for this origin access identity, as originally specified when
	// created.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// The ID for the origin access identity. For example: E74FTE3AJFJ256A.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The Amazon S3 canonical user ID for the origin access identity, which you
	// use when giving the origin access identity read permission to an object in
	// Amazon S3.
	//
	// S3CanonicalUserId is a required field
	S3CanonicalUserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CloudFrontOriginAccessIdentitySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudFrontOriginAccessIdentitySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.S3CanonicalUserId != nil {
		v := *s.S3CanonicalUserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3CanonicalUserId", protocol.StringValue(v), metadata)
	}
	return nil
}

// A field-level encryption content type profile.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/ContentTypeProfile
type ContentTypeProfile struct {
	_ struct{} `type:"structure"`

	// The content type for a field-level encryption content type-profile mapping.
	//
	// ContentType is a required field
	ContentType *string `type:"string" required:"true"`

	// The format for a field-level encryption content type-profile mapping.
	//
	// Format is a required field
	Format Format `type:"string" required:"true" enum:"true"`

	// The profile ID for a field-level encryption content type-profile mapping.
	ProfileId *string `type:"string"`
}

// String returns the string representation
func (s ContentTypeProfile) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentTypeProfile) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContentTypeProfile"}

	if s.ContentType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContentType"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContentTypeProfile) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentType", protocol.StringValue(v), metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", v, metadata)
	}
	if s.ProfileId != nil {
		v := *s.ProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProfileId", protocol.StringValue(v), metadata)
	}
	return nil
}

// The configuration for a field-level encryption content type-profile mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/ContentTypeProfileConfig
type ContentTypeProfileConfig struct {
	_ struct{} `type:"structure"`

	// The configuration for a field-level encryption content type-profile.
	ContentTypeProfiles *ContentTypeProfiles `type:"structure"`

	// The setting in a field-level encryption content type-profile mapping that
	// specifies what to do when an unknown content type is provided for the profile.
	// If true, content is forwarded without being encrypted when the content type
	// is unknown. If false (the default), an error is returned when the content
	// type is unknown.
	//
	// ForwardWhenContentTypeIsUnknown is a required field
	ForwardWhenContentTypeIsUnknown *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ContentTypeProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentTypeProfileConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContentTypeProfileConfig"}

	if s.ForwardWhenContentTypeIsUnknown == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForwardWhenContentTypeIsUnknown"))
	}
	if s.ContentTypeProfiles != nil {
		if err := s.ContentTypeProfiles.Validate(); err != nil {
			invalidParams.AddNested("ContentTypeProfiles", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContentTypeProfileConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentTypeProfiles != nil {
		v := s.ContentTypeProfiles

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ContentTypeProfiles", v, metadata)
	}
	if s.ForwardWhenContentTypeIsUnknown != nil {
		v := *s.ForwardWhenContentTypeIsUnknown

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ForwardWhenContentTypeIsUnknown", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Field-level encryption content type-profile.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/ContentTypeProfiles
type ContentTypeProfiles struct {
	_ struct{} `type:"structure"`

	// Items in a field-level encryption content type-profile mapping.
	Items []ContentTypeProfile `locationNameList:"ContentTypeProfile" type:"list"`

	// The number of field-level encryption content type-profile mappings.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ContentTypeProfiles) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentTypeProfiles) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContentTypeProfiles"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContentTypeProfiles) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "ContentTypeProfile"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that specifies whether you want CloudFront to forward cookies
// to the origin and, if so, which ones. For more information about forwarding
// cookies to the origin, see How CloudFront Forwards, Caches, and Logs Cookies
// (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CookieNames
type CookieNames struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one Name element for each cookie that you want
	// CloudFront to forward to the origin for this cache behavior.
	Items []string `locationNameList:"Name" type:"list"`

	// The number of different cookies that you want CloudFront to forward to the
	// origin for this cache behavior.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CookieNames) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CookieNames) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CookieNames"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CookieNames) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Name"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that specifies whether you want CloudFront to forward cookies
// to the origin and, if so, which ones. For more information about forwarding
// cookies to the origin, see How CloudFront Forwards, Caches, and Logs Cookies
// (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CookiePreference
type CookiePreference struct {
	_ struct{} `type:"structure"`

	// Specifies which cookies to forward to the origin for this cache behavior:
	// all, none, or the list of cookies specified in the WhitelistedNames complex
	// type.
	//
	// Amazon S3 doesn't process cookies. When the cache behavior is forwarding
	// requests to an Amazon S3 origin, specify none for the Forward element.
	//
	// Forward is a required field
	Forward ItemSelection `type:"string" required:"true" enum:"true"`

	// Required if you specify whitelist for the value of Forward:. A complex type
	// that specifies how many different cookies you want CloudFront to forward
	// to the origin for this cache behavior and, if you want to forward selected
	// cookies, the names of those cookies.
	//
	// If you specify all or none for the value of Forward, omit WhitelistedNames.
	// If you change the value of Forward from whitelist to all or none and you
	// don't delete the WhitelistedNames element and its child elements, CloudFront
	// deletes them automatically.
	//
	// For the current limit on the number of cookie names that you can whitelist
	// for each cache behavior, see Amazon CloudFront Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_cloudfront)
	// in the AWS General Reference.
	WhitelistedNames *CookieNames `type:"structure"`
}

// String returns the string representation
func (s CookiePreference) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CookiePreference) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CookiePreference"}
	if len(s.Forward) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Forward"))
	}
	if s.WhitelistedNames != nil {
		if err := s.WhitelistedNames.Validate(); err != nil {
			invalidParams.AddNested("WhitelistedNames", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CookiePreference) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Forward) > 0 {
		v := s.Forward

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Forward", v, metadata)
	}
	if s.WhitelistedNames != nil {
		v := s.WhitelistedNames

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "WhitelistedNames", v, metadata)
	}
	return nil
}

// A complex type that controls:
//
//    * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range
//    with custom error messages before returning the response to the viewer.
//
//    * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
//
// For more information about custom error pages, see Customizing Error Responses
// (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CustomErrorResponse
type CustomErrorResponse struct {
	_ struct{} `type:"structure"`

	// The minimum amount of time, in seconds, that you want CloudFront to cache
	// the HTTP status code specified in ErrorCode. When this time period has elapsed,
	// CloudFront queries your origin to see whether the problem that caused the
	// error has been resolved and the requested object is now available.
	//
	// If you don't want to specify a value, include an empty element, <ErrorCachingMinTTL>,
	// in the XML document.
	//
	// For more information, see Customizing Error Responses (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
	// in the Amazon CloudFront Developer Guide.
	ErrorCachingMinTTL *int64 `type:"long"`

	// The HTTP status code for which you want to specify a custom error page and/or
	// a caching duration.
	//
	// ErrorCode is a required field
	ErrorCode *int64 `type:"integer" required:"true"`

	// The HTTP status code that you want CloudFront to return to the viewer along
	// with the custom error page. There are a variety of reasons that you might
	// want CloudFront to return a status code different from the status code that
	// your origin returned to CloudFront, for example:
	//
	//    * Some Internet devices (some firewalls and corporate proxies, for example)
	//    intercept HTTP 4xx and 5xx and prevent the response from being returned
	//    to the viewer. If you substitute 200, the response typically won't be
	//    intercepted.
	//
	//    * If you don't care about distinguishing among different client errors
	//    or server errors, you can specify 400 or 500 as the ResponseCode for all
	//    4xx or 5xx errors.
	//
	//    * You might want to return a 200 status code (OK) and static website so
	//    your customers don't know that your website is down.
	//
	// If you specify a value for ResponseCode, you must also specify a value for
	// ResponsePagePath. If you don't want to specify a value, include an empty
	// element, <ResponseCode>, in the XML document.
	ResponseCode *string `type:"string"`

	// The path to the custom error page that you want CloudFront to return to a
	// viewer when your origin returns the HTTP status code specified by ErrorCode,
	// for example, /4xx-errors/403-forbidden.html. If you want to store your objects
	// and your custom error pages in different locations, your distribution must
	// include a cache behavior for which the following is true:
	//
	//    * The value of PathPattern matches the path to your custom error messages.
	//    For example, suppose you saved custom error pages for 4xx errors in an
	//    Amazon S3 bucket in a directory named /4xx-errors. Your distribution must
	//    include a cache behavior for which the path pattern routes requests for
	//    your custom error pages to that location, for example, /4xx-errors/*.
	//
	//    * The value of TargetOriginId specifies the value of the ID element for
	//    the origin that contains your custom error pages.
	//
	// If you specify a value for ResponsePagePath, you must also specify a value
	// for ResponseCode. If you don't want to specify a value, include an empty
	// element, <ResponsePagePath>, in the XML document.
	//
	// We recommend that you store custom error pages in an Amazon S3 bucket. If
	// you store custom error pages on an HTTP server and the server starts to return
	// 5xx errors, CloudFront can't get the files that you want to return to viewers
	// because the origin server is unavailable.
	ResponsePagePath *string `type:"string"`
}

// String returns the string representation
func (s CustomErrorResponse) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomErrorResponse) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomErrorResponse"}

	if s.ErrorCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("ErrorCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomErrorResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCachingMinTTL != nil {
		v := *s.ErrorCachingMinTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCachingMinTTL", protocol.Int64Value(v), metadata)
	}
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.Int64Value(v), metadata)
	}
	if s.ResponseCode != nil {
		v := *s.ResponseCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResponseCode", protocol.StringValue(v), metadata)
	}
	if s.ResponsePagePath != nil {
		v := *s.ResponsePagePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResponsePagePath", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that controls:
//
//    * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range
//    with custom error messages before returning the response to the viewer.
//
//    * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
//
// For more information about custom error pages, see Customizing Error Responses
// (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CustomErrorResponses
type CustomErrorResponses struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a CustomErrorResponse element for each HTTP
	// status code for which you want to specify a custom error page and/or a caching
	// duration.
	Items []CustomErrorResponse `locationNameList:"CustomErrorResponse" type:"list"`

	// The number of HTTP status codes for which you want to specify a custom error
	// page and/or a caching duration. If Quantity is 0, you can omit Items.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomErrorResponses) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomErrorResponses) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomErrorResponses"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomErrorResponses) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "CustomErrorResponse"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains the list of Custom Headers for each origin.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CustomHeaders
type CustomHeaders struct {
	_ struct{} `type:"structure"`

	// Optional: A list that contains one OriginCustomHeader element for each custom
	// header that you want CloudFront to forward to the origin. If Quantity is
	// 0, omit Items.
	Items []OriginCustomHeader `locationNameList:"OriginCustomHeader" type:"list"`

	// The number of custom headers, if any, for this distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomHeaders) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomHeaders) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomHeaders"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomHeaders) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "OriginCustomHeader"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A customer origin or an Amazon S3 bucket configured as a website endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/CustomOriginConfig
type CustomOriginConfig struct {
	_ struct{} `type:"structure"`

	// The HTTP port the custom origin listens on.
	//
	// HTTPPort is a required field
	HTTPPort *int64 `type:"integer" required:"true"`

	// The HTTPS port the custom origin listens on.
	//
	// HTTPSPort is a required field
	HTTPSPort *int64 `type:"integer" required:"true"`

	// You can create a custom keep-alive timeout. All timeout units are in seconds.
	// The default keep-alive timeout is 5 seconds, but you can configure custom
	// timeout lengths using the CloudFront API. The minimum timeout length is 1
	// second; the maximum is 60 seconds.
	//
	// If you need to increase the maximum time limit, contact the AWS Support Center
	// (https://console.aws.amazon.com/support/home#/).
	OriginKeepaliveTimeout *int64 `type:"integer"`

	// The origin protocol policy to apply to your origin.
	//
	// OriginProtocolPolicy is a required field
	OriginProtocolPolicy OriginProtocolPolicy `type:"string" required:"true" enum:"true"`

	// You can create a custom origin read timeout. All timeout units are in seconds.
	// The default origin read timeout is 30 seconds, but you can configure custom
	// timeout lengths using the CloudFront API. The minimum timeout length is 4
	// seconds; the maximum is 60 seconds.
	//
	// If you need to increase the maximum time limit, contact the AWS Support Center
	// (https://console.aws.amazon.com/support/home#/).
	OriginReadTimeout *int64 `type:"integer"`

	// The SSL/TLS protocols that you want CloudFront to use when communicating
	// with your origin over HTTPS.
	OriginSslProtocols *OriginSslProtocols `type:"structure"`
}

// String returns the string representation
func (s CustomOriginConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomOriginConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomOriginConfig"}

	if s.HTTPPort == nil {
		invalidParams.Add(aws.NewErrParamRequired("HTTPPort"))
	}

	if s.HTTPSPort == nil {
		invalidParams.Add(aws.NewErrParamRequired("HTTPSPort"))
	}
	if len(s.OriginProtocolPolicy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("OriginProtocolPolicy"))
	}
	if s.OriginSslProtocols != nil {
		if err := s.OriginSslProtocols.Validate(); err != nil {
			invalidParams.AddNested("OriginSslProtocols", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomOriginConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.HTTPPort != nil {
		v := *s.HTTPPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HTTPPort", protocol.Int64Value(v), metadata)
	}
	if s.HTTPSPort != nil {
		v := *s.HTTPSPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HTTPSPort", protocol.Int64Value(v), metadata)
	}
	if s.OriginKeepaliveTimeout != nil {
		v := *s.OriginKeepaliveTimeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginKeepaliveTimeout", protocol.Int64Value(v), metadata)
	}
	if len(s.OriginProtocolPolicy) > 0 {
		v := s.OriginProtocolPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginProtocolPolicy", v, metadata)
	}
	if s.OriginReadTimeout != nil {
		v := *s.OriginReadTimeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginReadTimeout", protocol.Int64Value(v), metadata)
	}
	if s.OriginSslProtocols != nil {
		v := s.OriginSslProtocols

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OriginSslProtocols", v, metadata)
	}
	return nil
}

// A complex type that describes the default cache behavior if you don't specify
// a CacheBehavior element or if files don't match any of the values of PathPattern
// in CacheBehavior elements. You must create exactly one default cache behavior.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DefaultCacheBehavior
type DefaultCacheBehavior struct {
	_ struct{} `type:"structure"`

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices:
	//
	//    * CloudFront forwards only GET and HEAD requests.
	//
	//    * CloudFront forwards only GET, HEAD, and OPTIONS requests.
	//
	//    * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
	//    requests.
	//
	// If you pick the third choice, you may need to restrict access to your Amazon
	// S3 bucket or to your custom origin so users can't perform operations that
	// you don't want them to. For example, you might not want users to have permissions
	// to delete objects from your origin.
	AllowedMethods *AllowedMethods `type:"structure"`

	// Whether you want CloudFront to automatically compress certain files for this
	// cache behavior. If so, specify true; if not, specify false. For more information,
	// see Serving Compressed Files (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html)
	// in the Amazon CloudFront Developer Guide.
	Compress *bool `type:"boolean"`

	// The default amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin does not add HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Specifying How
	// Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	DefaultTTL *int64 `type:"long"`

	// The value of ID for the field-level encryption configuration that you want
	// CloudFront to use for encrypting specific fields of data for a cache behavior
	// or for the default cache behavior in your distribution.
	FieldLevelEncryptionId *string `type:"string"`

	// A complex type that specifies how CloudFront handles query strings and cookies.
	//
	// ForwardedValues is a required field
	ForwardedValues *ForwardedValues `type:"structure" required:"true"`

	// A complex type that contains zero or more Lambda function associations for
	// a cache behavior.
	LambdaFunctionAssociations *LambdaFunctionAssociations `type:"structure"`

	MaxTTL *int64 `type:"long"`

	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. For more information, see Specifying How Long
	// Objects and Errors Stay in a CloudFront Edge Cache (Expiration) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon Amazon CloudFront Developer Guide.
	//
	// You must specify 0 for MinTTL if you configure CloudFront to forward all
	// headers to your origin (under Headers, if you specify 1 for Quantity and
	// * for Name).
	//
	// MinTTL is a required field
	MinTTL *int64 `type:"long" required:"true"`

	// Indicates whether you want to distribute media files in the Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true; if not, specify false. If you specify true for SmoothStreaming,
	// you can still distribute other content using this cache behavior if the content
	// matches the value of PathPattern.
	SmoothStreaming *bool `type:"boolean"`

	// The value of ID for the origin that you want CloudFront to route requests
	// to when a request matches the path pattern either for a cache behavior or
	// for the default cache behavior in your distribution.
	//
	// TargetOriginId is a required field
	TargetOriginId *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content.
	//
	// If you want to require signed URLs in requests for objects in the target
	// origin that match the PathPattern for this cache behavior, specify true for
	// Enabled, and specify the applicable values for Quantity and Items. For more
	// information, see Serving Private Content through CloudFront (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon Amazon CloudFront Developer Guide.
	//
	// If you don't want to require signed URLs in requests for objects that match
	// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items.
	//
	// To add, change, or remove one or more trusted signers, change Enabled to
	// true (if it's currently false), change Quantity as applicable, and specify
	// all of the trusted signers that you want to include in the updated distribution.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`

	// The protocol that viewers can use to access the files in the origin specified
	// by TargetOriginId when a request matches the path pattern in PathPattern.
	// You can specify the following options:
	//
	//    * allow-all: Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https: If a viewer submits an HTTP request, CloudFront returns
	//    an HTTP status code of 301 (Moved Permanently) to the viewer along with
	//    the HTTPS URL. The viewer then resubmits the request using the new URL.
	//
	//    * https-only: If a viewer sends an HTTP request, CloudFront returns an
	//    HTTP status code of 403 (Forbidden).
	//
	// For more information about requiring the HTTPS protocol, see Using an HTTPS
	// Connection to Access Your Objects (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The only way to guarantee that viewers retrieve an object that was fetched
	// from the origin using HTTPS is never to use any other protocol to fetch the
	// object. If you have recently changed from HTTP to HTTPS, we recommend that
	// you clear your objects' cache because cached objects are protocol agnostic.
	// That means that an edge location will return an object from the cache regardless
	// of whether the current request protocol matches the protocol used previously.
	// For more information, see Specifying How Long Objects and Errors Stay in
	// a CloudFront Edge Cache (Expiration) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// ViewerProtocolPolicy is a required field
	ViewerProtocolPolicy ViewerProtocolPolicy `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DefaultCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefaultCacheBehavior) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DefaultCacheBehavior"}

	if s.ForwardedValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForwardedValues"))
	}

	if s.MinTTL == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinTTL"))
	}

	if s.TargetOriginId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetOriginId"))
	}

	if s.TrustedSigners == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrustedSigners"))
	}
	if len(s.ViewerProtocolPolicy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ViewerProtocolPolicy"))
	}
	if s.AllowedMethods != nil {
		if err := s.AllowedMethods.Validate(); err != nil {
			invalidParams.AddNested("AllowedMethods", err.(aws.ErrInvalidParams))
		}
	}
	if s.ForwardedValues != nil {
		if err := s.ForwardedValues.Validate(); err != nil {
			invalidParams.AddNested("ForwardedValues", err.(aws.ErrInvalidParams))
		}
	}
	if s.LambdaFunctionAssociations != nil {
		if err := s.LambdaFunctionAssociations.Validate(); err != nil {
			invalidParams.AddNested("LambdaFunctionAssociations", err.(aws.ErrInvalidParams))
		}
	}
	if s.TrustedSigners != nil {
		if err := s.TrustedSigners.Validate(); err != nil {
			invalidParams.AddNested("TrustedSigners", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultCacheBehavior) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowedMethods != nil {
		v := s.AllowedMethods

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AllowedMethods", v, metadata)
	}
	if s.Compress != nil {
		v := *s.Compress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Compress", protocol.BoolValue(v), metadata)
	}
	if s.DefaultTTL != nil {
		v := *s.DefaultTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultTTL", protocol.Int64Value(v), metadata)
	}
	if s.FieldLevelEncryptionId != nil {
		v := *s.FieldLevelEncryptionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldLevelEncryptionId", protocol.StringValue(v), metadata)
	}
	if s.ForwardedValues != nil {
		v := s.ForwardedValues

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ForwardedValues", v, metadata)
	}
	if s.LambdaFunctionAssociations != nil {
		v := s.LambdaFunctionAssociations

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LambdaFunctionAssociations", v, metadata)
	}
	if s.MaxTTL != nil {
		v := *s.MaxTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxTTL", protocol.Int64Value(v), metadata)
	}
	if s.MinTTL != nil {
		v := *s.MinTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MinTTL", protocol.Int64Value(v), metadata)
	}
	if s.SmoothStreaming != nil {
		v := *s.SmoothStreaming

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SmoothStreaming", protocol.BoolValue(v), metadata)
	}
	if s.TargetOriginId != nil {
		v := *s.TargetOriginId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetOriginId", protocol.StringValue(v), metadata)
	}
	if s.TrustedSigners != nil {
		v := s.TrustedSigners

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TrustedSigners", v, metadata)
	}
	if len(s.ViewerProtocolPolicy) > 0 {
		v := s.ViewerProtocolPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ViewerProtocolPolicy", v, metadata)
	}
	return nil
}

// The distribution's information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Distribution
type Distribution struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// CloudFront automatically adds this element to the response only if you've
	// set up the distribution to serve private content with signed URLs. The element
	// lists the key pair IDs that CloudFront is aware of for each trusted signer.
	// The Signer child element lists the AWS account number of the trusted signer
	// (or an empty Self element if the signer is you). The Signer element also
	// includes the IDs of any active key pairs associated with the trusted signer's
	// AWS account. If no KeyPairId element appears for a Signer, that signer can't
	// create working signed URLs.
	//
	// ActiveTrustedSigners is a required field
	ActiveTrustedSigners *ActiveTrustedSigners `type:"structure" required:"true"`

	// The current configuration information for the distribution. Send a GET request
	// to the /CloudFront API version/distribution ID/config resource.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `type:"structure" required:"true"`

	// The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The identifier for the distribution. For example: EDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The number of invalidation batches currently in progress.
	//
	// InProgressInvalidationBatches is a required field
	InProgressInvalidationBatches *int64 `type:"integer" required:"true"`

	// The date and time the distribution was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// This response element indicates the current status of the distribution. When
	// the status is Deployed, the distribution's information is fully propagated
	// to all CloudFront edge locations.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Distribution) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Distribution) MarshalFields(e protocol.FieldEncoder) error {
	if s.ARN != nil {
		v := *s.ARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ARN", protocol.StringValue(v), metadata)
	}
	if s.ActiveTrustedSigners != nil {
		v := s.ActiveTrustedSigners

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ActiveTrustedSigners", v, metadata)
	}
	if s.DistributionConfig != nil {
		v := s.DistributionConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DistributionConfig", v, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.InProgressInvalidationBatches != nil {
		v := *s.InProgressInvalidationBatches

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InProgressInvalidationBatches", protocol.Int64Value(v), metadata)
	}
	if s.LastModifiedTime != nil {
		v := *s.LastModifiedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.StringValue(v), metadata)
	}
	return nil
}

// A distribution configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DistributionConfig
type DistributionConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	Aliases *Aliases `type:"structure"`

	// A complex type that contains zero or more CacheBehavior elements.
	CacheBehaviors *CacheBehaviors `type:"structure"`

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// DistributionConfig object), CloudFront creates a new distribution.
	//
	// If CallerReference is a value that you already sent in a previous request
	// to create a distribution, CloudFront returns a DistributionAlreadyExists
	// error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the distribution.
	//
	// If you don't want to specify a comment, include an empty Comment element.
	//
	// To delete an existing comment, update the distribution configuration and
	// include an empty Comment element.
	//
	// To add or change a comment, update the distribution configuration and specify
	// the new comment.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// A complex type that controls the following:
	//
	//    * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range
	//    with custom error messages before returning the response to the viewer.
	//
	//    * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
	//
	// For more information about custom error pages, see Customizing Error Responses
	// (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
	// in the Amazon CloudFront Developer Guide.
	CustomErrorResponses *CustomErrorResponses `type:"structure"`

	// A complex type that describes the default cache behavior if you don't specify
	// a CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements. You must create exactly one default cache behavior.
	//
	// DefaultCacheBehavior is a required field
	DefaultCacheBehavior *DefaultCacheBehavior `type:"structure" required:"true"`

	// The object that you want CloudFront to request from your origin (for example,
	// index.html) when a viewer requests the root URL for your distribution (http://www.example.com)
	// instead of an object in your distribution (http://www.example.com/product-description.html).
	// Specifying a default root object avoids exposing the contents of your distribution.
	//
	// Specify only the object name, for example, index.html. Don't add a / before
	// the object name.
	//
	// If you don't want to specify a default root object when you create a distribution,
	// include an empty DefaultRootObject element.
	//
	// To delete the default root object from an existing distribution, update the
	// distribution configuration and include an empty DefaultRootObject element.
	//
	// To replace the default root object, update the distribution configuration
	// and specify the new object.
	//
	// For more information about the default root object, see Creating a Default
	// Root Object (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html)
	// in the Amazon CloudFront Developer Guide.
	DefaultRootObject *string `type:"string"`

	// From this field, you can enable or disable the selected distribution.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// (Optional) Specify the maximum HTTP version that you want viewers to use
	// to communicate with CloudFront. The default value for new web distributions
	// is http2. Viewers that don't support HTTP/2 automatically use an earlier
	// HTTP version.
	//
	// For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or
	// later, and must support Server Name Identification (SNI).
	//
	// In general, configuring CloudFront to communicate with viewers using HTTP/2
	// reduces latency. You can improve performance by optimizing for HTTP/2. For
	// more information, do an Internet search for "http/2 optimization."
	HttpVersion HttpVersion `type:"string" enum:"true"`

	// If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address
	// for your distribution, specify true. If you specify false, CloudFront responds
	// to IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
	// This allows viewers to submit a second request, for an IPv4 address for your
	// distribution.
	//
	// In general, you should enable IPv6 if you have users on IPv6 networks who
	// want to access your content. However, if you're using signed URLs or signed
	// cookies to restrict access to your content, and if you're using a custom
	// policy that includes the IpAddress parameter to restrict the IP addresses
	// that can access your content, don't enable IPv6. If you want to restrict
	// access to some content by IP address and not restrict access to other content
	// (or restrict access but not by IP address), you can create two distributions.
	// For more information, see Creating a Signed URL Using a Custom Policy (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you're using an Amazon Route 53 alias resource record set to route traffic
	// to your CloudFront distribution, you need to create a second alias resource
	// record set when both of the following are true:
	//
	//    * You enable IPv6 for the distribution
	//
	//    * You're using alternate domain names in the URLs for your objects
	//
	// For more information, see Routing Traffic to an Amazon CloudFront Web Distribution
	// by Using Your Domain Name (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// If you created a CNAME resource record set, either with Amazon Route 53 or
	// with another DNS service, you don't need to make any changes. A CNAME record
	// will route traffic to your distribution regardless of the IP address format
	// of the viewer request.
	IsIPV6Enabled *bool `type:"boolean"`

	// A complex type that controls whether access logs are written for the distribution.
	//
	// For more information about logging, see Access Logs (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html)
	// in the Amazon CloudFront Developer Guide.
	Logging *LoggingConfig `type:"structure"`

	// A complex type that contains information about origin groups for this distribution.
	OriginGroups *OriginGroups `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	//
	// Origins is a required field
	Origins *Origins `type:"structure" required:"true"`

	// The price class that corresponds with the maximum price that you want to
	// pay for CloudFront service. If you specify PriceClass_All, CloudFront responds
	// to requests for your objects from all CloudFront edge locations.
	//
	// If you specify a price class other than PriceClass_All, CloudFront serves
	// your objects from the CloudFront edge location that has the lowest latency
	// among the edge locations in your price class. Viewers who are in or near
	// regions that are excluded from your specified price class may encounter slower
	// performance.
	//
	// For more information about price classes, see Choosing the Price Class for
	// a CloudFront Distribution (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html)
	// in the Amazon CloudFront Developer Guide. For information about CloudFront
	// pricing, including how price classes (such as Price Class 100) map to CloudFront
	// regions, see Amazon CloudFront Pricing (https://aws.amazon.com/cloudfront/pricing/).
	// For price class information, scroll down to see the table at the bottom of
	// the page.
	PriceClass PriceClass `type:"string" enum:"true"`

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	Restrictions *Restrictions `type:"structure"`

	// A complex type that specifies the following:
	//
	//    * Whether you want viewers to use HTTP or HTTPS to request your objects.
	//
	//    * If you want viewers to use HTTPS, whether you're using an alternate
	//    domain name such as example.com or the CloudFront domain name for your
	//    distribution, such as d111111abcdef8.cloudfront.net.
	//
	//    * If you're using an alternate domain name, whether AWS Certificate Manager
	//    (ACM) provided the certificate, or you purchased a certificate from a
	//    third-party certificate authority and imported it into ACM or uploaded
	//    it to the IAM certificate store.
	//
	// You must specify only one of the following values:
	//
	//    * ViewerCertificate$ACMCertificateArn
	//
	//    * ViewerCertificate$IAMCertificateId
	//
	//    * ViewerCertificate$CloudFrontDefaultCertificate
	//
	// Don't specify false for CloudFrontDefaultCertificate.
	//
	// If you want viewers to use HTTP instead of HTTPS to request your objects:
	// Specify the following value:
	//
	// <CloudFrontDefaultCertificate>true<CloudFrontDefaultCertificate>
	//
	// In addition, specify allow-all for ViewerProtocolPolicy for all of your cache
	// behaviors.
	//
	// If you want viewers to use HTTPS to request your objects: Choose the type
	// of certificate that you want to use based on whether you're using an alternate
	// domain name for your objects or the CloudFront domain name:
	//
	//    * If you're using an alternate domain name, such as example.com: Specify
	//    one of the following values, depending on whether ACM provided your certificate
	//    or you purchased your certificate from third-party certificate authority:
	//    <ACMCertificateArn>ARN for ACM SSL/TLS certificate<ACMCertificateArn>
	//    where ARN for ACM SSL/TLS certificate is the ARN for the ACM SSL/TLS certificate
	//    that you want to use for this distribution. <IAMCertificateId>IAM certificate
	//    ID<IAMCertificateId> where IAM certificate ID is the ID that IAM returned
	//    when you added the certificate to the IAM certificate store. If you specify
	//    ACMCertificateArn or IAMCertificateId, you must also specify a value for
	//    SSLSupportMethod. If you choose to use an ACM certificate or a certificate
	//    in the IAM certificate store, we recommend that you use only an alternate
	//    domain name in your object URLs (https://example.com/logo.jpg). If you
	//    use the domain name that is associated with your CloudFront distribution
	//    (such as https://d111111abcdef8.cloudfront.net/logo.jpg) and the viewer
	//    supports SNI, then CloudFront behaves normally. However, if the browser
	//    does not support SNI, the user's experience depends on the value that
	//    you choose for SSLSupportMethod: vip: The viewer displays a warning because
	//    there is a mismatch between the CloudFront domain name and the domain
	//    name in your SSL/TLS certificate. sni-only: CloudFront drops the connection
	//    with the browser without returning the object.
	//
	//    * If you're using the CloudFront domain name for your distribution, such
	//    as d111111abcdef8.cloudfront.net : Specify the following value: <CloudFrontDefaultCertificate>true<CloudFrontDefaultCertificate>
	//
	// If you want viewers to use HTTPS, you must also specify one of the following
	// values in your cache behaviors:
	//
	//    * <ViewerProtocolPolicy>https-only<ViewerProtocolPolicy>
	//
	//    * <ViewerProtocolPolicy>redirect-to-https<ViewerProtocolPolicy>
	//
	// You can also optionally require that CloudFront use HTTPS to communicate
	// with your origin by specifying one of the following values for the applicable
	// origins:
	//
	//    * <OriginProtocolPolicy>https-only<OriginProtocolPolicy>
	//
	//    * <OriginProtocolPolicy>match-viewer<OriginProtocolPolicy>
	//
	// For more information, see Using Alternate Domain Names and HTTPS (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS)
	// in the Amazon CloudFront Developer Guide.
	ViewerCertificate *ViewerCertificate `type:"structure"`

	// A unique identifier that specifies the AWS WAF web ACL, if any, to associate
	// with this distribution.
	//
	// AWS WAF is a web application firewall that lets you monitor the HTTP and
	// HTTPS requests that are forwarded to CloudFront, and lets you control access
	// to your content. Based on conditions that you specify, such as the IP addresses
	// that requests originate from or the values of query strings, CloudFront responds
	// to requests either with the requested content or with an HTTP 403 status
	// code (Forbidden). You can also configure CloudFront to return a custom error
	// page when a request is blocked. For more information about AWS WAF, see the
	// AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
	WebACLId *string `type:"string"`
}

// String returns the string representation
func (s DistributionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DistributionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DistributionConfig"}

	if s.CallerReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("CallerReference"))
	}

	if s.Comment == nil {
		invalidParams.Add(aws.NewErrParamRequired("Comment"))
	}

	if s.DefaultCacheBehavior == nil {
		invalidParams.Add(aws.NewErrParamRequired("DefaultCacheBehavior"))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if s.Origins == nil {
		invalidParams.Add(aws.NewErrParamRequired("Origins"))
	}
	if s.Aliases != nil {
		if err := s.Aliases.Validate(); err != nil {
			invalidParams.AddNested("Aliases", err.(aws.ErrInvalidParams))
		}
	}
	if s.CacheBehaviors != nil {
		if err := s.CacheBehaviors.Validate(); err != nil {
			invalidParams.AddNested("CacheBehaviors", err.(aws.ErrInvalidParams))
		}
	}
	if s.CustomErrorResponses != nil {
		if err := s.CustomErrorResponses.Validate(); err != nil {
			invalidParams.AddNested("CustomErrorResponses", err.(aws.ErrInvalidParams))
		}
	}
	if s.DefaultCacheBehavior != nil {
		if err := s.DefaultCacheBehavior.Validate(); err != nil {
			invalidParams.AddNested("DefaultCacheBehavior", err.(aws.ErrInvalidParams))
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(aws.ErrInvalidParams))
		}
	}
	if s.OriginGroups != nil {
		if err := s.OriginGroups.Validate(); err != nil {
			invalidParams.AddNested("OriginGroups", err.(aws.ErrInvalidParams))
		}
	}
	if s.Origins != nil {
		if err := s.Origins.Validate(); err != nil {
			invalidParams.AddNested("Origins", err.(aws.ErrInvalidParams))
		}
	}
	if s.Restrictions != nil {
		if err := s.Restrictions.Validate(); err != nil {
			invalidParams.AddNested("Restrictions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DistributionConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Aliases != nil {
		v := s.Aliases

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Aliases", v, metadata)
	}
	if s.CacheBehaviors != nil {
		v := s.CacheBehaviors

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CacheBehaviors", v, metadata)
	}
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.CustomErrorResponses != nil {
		v := s.CustomErrorResponses

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CustomErrorResponses", v, metadata)
	}
	if s.DefaultCacheBehavior != nil {
		v := s.DefaultCacheBehavior

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultCacheBehavior", v, metadata)
	}
	if s.DefaultRootObject != nil {
		v := *s.DefaultRootObject

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultRootObject", protocol.StringValue(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if len(s.HttpVersion) > 0 {
		v := s.HttpVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpVersion", v, metadata)
	}
	if s.IsIPV6Enabled != nil {
		v := *s.IsIPV6Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsIPV6Enabled", protocol.BoolValue(v), metadata)
	}
	if s.Logging != nil {
		v := s.Logging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Logging", v, metadata)
	}
	if s.OriginGroups != nil {
		v := s.OriginGroups

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OriginGroups", v, metadata)
	}
	if s.Origins != nil {
		v := s.Origins

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Origins", v, metadata)
	}
	if len(s.PriceClass) > 0 {
		v := s.PriceClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PriceClass", v, metadata)
	}
	if s.Restrictions != nil {
		v := s.Restrictions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Restrictions", v, metadata)
	}
	if s.ViewerCertificate != nil {
		v := s.ViewerCertificate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ViewerCertificate", v, metadata)
	}
	if s.WebACLId != nil {
		v := *s.WebACLId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WebACLId", protocol.StringValue(v), metadata)
	}
	return nil
}

// A distribution Configuration and a list of tags to be associated with the
// distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DistributionConfigWithTags
type DistributionConfigWithTags struct {
	_ struct{} `type:"structure"`

	// A distribution configuration.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `type:"structure" required:"true"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `type:"structure" required:"true"`
}

// String returns the string representation
func (s DistributionConfigWithTags) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DistributionConfigWithTags) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DistributionConfigWithTags"}

	if s.DistributionConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("DistributionConfig"))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}
	if s.DistributionConfig != nil {
		if err := s.DistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("DistributionConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		if err := s.Tags.Validate(); err != nil {
			invalidParams.AddNested("Tags", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DistributionConfigWithTags) MarshalFields(e protocol.FieldEncoder) error {
	if s.DistributionConfig != nil {
		v := s.DistributionConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DistributionConfig", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tags", v, metadata)
	}
	return nil
}

// A distribution list.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DistributionList
type DistributionList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more distributions remain to be listed. If
	// your results were truncated, you can make a follow-up pagination request
	// using the Marker request parameter to retrieve more distributions in the
	// list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one DistributionSummary element for each distribution
	// that was created by the current AWS account.
	Items []DistributionSummary `locationNameList:"DistributionSummary" type:"list"`

	// The value you provided for the Marker request parameter.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your distributions
	// where they left off.
	NextMarker *string `type:"string"`

	// The number of distributions that were created by the current AWS account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s DistributionList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DistributionList) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "DistributionSummary"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.StringValue(v), metadata)
	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A summary of the information about a CloudFront distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DistributionSummary
type DistributionSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	//
	// Aliases is a required field
	Aliases *Aliases `type:"structure" required:"true"`

	// A complex type that contains zero or more CacheBehavior elements.
	//
	// CacheBehaviors is a required field
	CacheBehaviors *CacheBehaviors `type:"structure" required:"true"`

	// The comment originally specified when this distribution was created.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// A complex type that contains zero or more CustomErrorResponses elements.
	//
	// CustomErrorResponses is a required field
	CustomErrorResponses *CustomErrorResponses `type:"structure" required:"true"`

	// A complex type that describes the default cache behavior if you don't specify
	// a CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements. You must create exactly one default cache behavior.
	//
	// DefaultCacheBehavior is a required field
	DefaultCacheBehavior *DefaultCacheBehavior `type:"structure" required:"true"`

	// The domain name that corresponds to the distribution, for example, d111111abcdef8.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Whether the distribution is enabled to accept user requests for content.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specify the maximum HTTP version that you want viewers to use to communicate
	// with CloudFront. The default value for new web distributions is http2. Viewers
	// that don't support HTTP/2 will automatically use an earlier version.
	//
	// HttpVersion is a required field
	HttpVersion HttpVersion `type:"string" required:"true" enum:"true"`

	// The identifier for the distribution. For example: EDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for
	// your distribution.
	//
	// IsIPV6Enabled is a required field
	IsIPV6Enabled *bool `type:"boolean" required:"true"`

	// The date and time the distribution was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A complex type that contains information about origin groups for this distribution.
	OriginGroups *OriginGroups `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	//
	// Origins is a required field
	Origins *Origins `type:"structure" required:"true"`

	// A complex type that contains information about price class for this streaming
	// distribution.
	//
	// PriceClass is a required field
	PriceClass PriceClass `type:"string" required:"true" enum:"true"`

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	//
	// Restrictions is a required field
	Restrictions *Restrictions `type:"structure" required:"true"`

	// The current status of the distribution. When the status is Deployed, the
	// distribution's information is propagated to all CloudFront edge locations.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// A complex type that specifies the following:
	//
	//    * Whether you want viewers to use HTTP or HTTPS to request your objects.
	//
	//    * If you want viewers to use HTTPS, whether you're using an alternate
	//    domain name such as example.com or the CloudFront domain name for your
	//    distribution, such as d111111abcdef8.cloudfront.net.
	//
	//    * If you're using an alternate domain name, whether AWS Certificate Manager
	//    (ACM) provided the certificate, or you purchased a certificate from a
	//    third-party certificate authority and imported it into ACM or uploaded
	//    it to the IAM certificate store.
	//
	// You must specify only one of the following values:
	//
	//    * ViewerCertificate$ACMCertificateArn
	//
	//    * ViewerCertificate$IAMCertificateId
	//
	//    * ViewerCertificate$CloudFrontDefaultCertificate
	//
	// Don't specify false for CloudFrontDefaultCertificate.
	//
	// If you want viewers to use HTTP instead of HTTPS to request your objects:
	// Specify the following value:
	//
	// <CloudFrontDefaultCertificate>true<CloudFrontDefaultCertificate>
	//
	// In addition, specify allow-all for ViewerProtocolPolicy for all of your cache
	// behaviors.
	//
	// If you want viewers to use HTTPS to request your objects: Choose the type
	// of certificate that you want to use based on whether you're using an alternate
	// domain name for your objects or the CloudFront domain name:
	//
	//    * If you're using an alternate domain name, such as example.com: Specify
	//    one of the following values, depending on whether ACM provided your certificate
	//    or you purchased your certificate from third-party certificate authority:
	//    <ACMCertificateArn>ARN for ACM SSL/TLS certificate<ACMCertificateArn>
	//    where ARN for ACM SSL/TLS certificate is the ARN for the ACM SSL/TLS certificate
	//    that you want to use for this distribution. <IAMCertificateId>IAM certificate
	//    ID<IAMCertificateId> where IAM certificate ID is the ID that IAM returned
	//    when you added the certificate to the IAM certificate store. If you specify
	//    ACMCertificateArn or IAMCertificateId, you must also specify a value for
	//    SSLSupportMethod. If you choose to use an ACM certificate or a certificate
	//    in the IAM certificate store, we recommend that you use only an alternate
	//    domain name in your object URLs (https://example.com/logo.jpg). If you
	//    use the domain name that is associated with your CloudFront distribution
	//    (such as https://d111111abcdef8.cloudfront.net/logo.jpg) and the viewer
	//    supports SNI, then CloudFront behaves normally. However, if the browser
	//    does not support SNI, the user's experience depends on the value that
	//    you choose for SSLSupportMethod: vip: The viewer displays a warning because
	//    there is a mismatch between the CloudFront domain name and the domain
	//    name in your SSL/TLS certificate. sni-only: CloudFront drops the connection
	//    with the browser without returning the object.
	//
	//    * If you're using the CloudFront domain name for your distribution, such
	//    as d111111abcdef8.cloudfront.net : Specify the following value: <CloudFrontDefaultCertificate>true<CloudFrontDefaultCertificate>
	//
	// If you want viewers to use HTTPS, you must also specify one of the following
	// values in your cache behaviors:
	//
	//    * <ViewerProtocolPolicy>https-only<ViewerProtocolPolicy>
	//
	//    * <ViewerProtocolPolicy>redirect-to-https<ViewerProtocolPolicy>
	//
	// You can also optionally require that CloudFront use HTTPS to communicate
	// with your origin by specifying one of the following values for the applicable
	// origins:
	//
	//    * <OriginProtocolPolicy>https-only<OriginProtocolPolicy>
	//
	//    * <OriginProtocolPolicy>match-viewer<OriginProtocolPolicy>
	//
	// For more information, see Using Alternate Domain Names and HTTPS (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS)
	// in the Amazon CloudFront Developer Guide.
	//
	// ViewerCertificate is a required field
	ViewerCertificate *ViewerCertificate `type:"structure" required:"true"`

	// The Web ACL Id (if any) associated with the distribution.
	//
	// WebACLId is a required field
	WebACLId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DistributionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DistributionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ARN != nil {
		v := *s.ARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ARN", protocol.StringValue(v), metadata)
	}
	if s.Aliases != nil {
		v := s.Aliases

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Aliases", v, metadata)
	}
	if s.CacheBehaviors != nil {
		v := s.CacheBehaviors

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CacheBehaviors", v, metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.CustomErrorResponses != nil {
		v := s.CustomErrorResponses

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CustomErrorResponses", v, metadata)
	}
	if s.DefaultCacheBehavior != nil {
		v := s.DefaultCacheBehavior

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultCacheBehavior", v, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.StringValue(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if len(s.HttpVersion) > 0 {
		v := s.HttpVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpVersion", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.IsIPV6Enabled != nil {
		v := *s.IsIPV6Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsIPV6Enabled", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedTime != nil {
		v := *s.LastModifiedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.OriginGroups != nil {
		v := s.OriginGroups

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OriginGroups", v, metadata)
	}
	if s.Origins != nil {
		v := s.Origins

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Origins", v, metadata)
	}
	if len(s.PriceClass) > 0 {
		v := s.PriceClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PriceClass", v, metadata)
	}
	if s.Restrictions != nil {
		v := s.Restrictions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Restrictions", v, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.StringValue(v), metadata)
	}
	if s.ViewerCertificate != nil {
		v := s.ViewerCertificate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ViewerCertificate", v, metadata)
	}
	if s.WebACLId != nil {
		v := *s.WebACLId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WebACLId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Complex data type for field-level encryption profiles that includes all of
// the encryption entities.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/EncryptionEntities
type EncryptionEntities struct {
	_ struct{} `type:"structure"`

	// An array of field patterns in a field-level encryption content type-profile
	// mapping.
	Items []EncryptionEntity `locationNameList:"EncryptionEntity" type:"list"`

	// Number of field pattern items in a field-level encryption content type-profile
	// mapping.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s EncryptionEntities) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionEntities) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncryptionEntities"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncryptionEntities) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "EncryptionEntity"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Complex data type for field-level encryption profiles that includes the encryption
// key and field pattern specifications.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/EncryptionEntity
type EncryptionEntity struct {
	_ struct{} `type:"structure"`

	// Field patterns in a field-level encryption content type profile specify the
	// fields that you want to be encrypted. You can provide the full field name,
	// or any beginning characters followed by a wildcard (*). You can't overlap
	// field patterns. For example, you can't have both ABC* and AB*. Note that
	// field patterns are case-sensitive.
	//
	// FieldPatterns is a required field
	FieldPatterns *FieldPatterns `type:"structure" required:"true"`

	// The provider associated with the public key being used for encryption. This
	// value must also be provided with the private key for applications to be able
	// to decrypt data.
	//
	// ProviderId is a required field
	ProviderId *string `type:"string" required:"true"`

	// The public key associated with a set of field-level encryption patterns,
	// to be used when encrypting the fields that match the patterns.
	//
	// PublicKeyId is a required field
	PublicKeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EncryptionEntity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionEntity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncryptionEntity"}

	if s.FieldPatterns == nil {
		invalidParams.Add(aws.NewErrParamRequired("FieldPatterns"))
	}

	if s.ProviderId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProviderId"))
	}

	if s.PublicKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PublicKeyId"))
	}
	if s.FieldPatterns != nil {
		if err := s.FieldPatterns.Validate(); err != nil {
			invalidParams.AddNested("FieldPatterns", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncryptionEntity) MarshalFields(e protocol.FieldEncoder) error {
	if s.FieldPatterns != nil {
		v := s.FieldPatterns

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FieldPatterns", v, metadata)
	}
	if s.ProviderId != nil {
		v := *s.ProviderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProviderId", protocol.StringValue(v), metadata)
	}
	if s.PublicKeyId != nil {
		v := *s.PublicKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PublicKeyId", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex data type that includes the profile configurations and other options
// specified for field-level encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/FieldLevelEncryption
type FieldLevelEncryption struct {
	_ struct{} `type:"structure"`

	// A complex data type that includes the profile configurations specified for
	// field-level encryption.
	//
	// FieldLevelEncryptionConfig is a required field
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `type:"structure" required:"true"`

	// The configuration ID for a field-level encryption configuration which includes
	// a set of profiles that specify certain selected data fields to be encrypted
	// by specific public keys.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The last time the field-level encryption configuration was changed.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldLevelEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.FieldLevelEncryptionConfig != nil {
		v := s.FieldLevelEncryptionConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FieldLevelEncryptionConfig", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LastModifiedTime != nil {
		v := *s.LastModifiedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	return nil
}

// A complex data type that includes the profile configurations specified for
// field-level encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/FieldLevelEncryptionConfig
type FieldLevelEncryptionConfig struct {
	_ struct{} `type:"structure"`

	// A unique number that ensures the request can't be replayed.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// An optional comment about the configuration.
	Comment *string `type:"string"`

	// A complex data type that specifies when to forward content if a content type
	// isn't recognized and profiles to use as by default in a request if a query
	// argument doesn't specify a profile to use.
	ContentTypeProfileConfig *ContentTypeProfileConfig `type:"structure"`

	// A complex data type that specifies when to forward content if a profile isn't
	// found and the profile that can be provided as a query argument in a request.
	QueryArgProfileConfig *QueryArgProfileConfig `type:"structure"`
}

// String returns the string representation
func (s FieldLevelEncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldLevelEncryptionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FieldLevelEncryptionConfig"}

	if s.CallerReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("CallerReference"))
	}
	if s.ContentTypeProfileConfig != nil {
		if err := s.ContentTypeProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("ContentTypeProfileConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.QueryArgProfileConfig != nil {
		if err := s.QueryArgProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("QueryArgProfileConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldLevelEncryptionConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.ContentTypeProfileConfig != nil {
		v := s.ContentTypeProfileConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ContentTypeProfileConfig", v, metadata)
	}
	if s.QueryArgProfileConfig != nil {
		v := s.QueryArgProfileConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QueryArgProfileConfig", v, metadata)
	}
	return nil
}

// List of field-level encrpytion configurations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/FieldLevelEncryptionList
type FieldLevelEncryptionList struct {
	_ struct{} `type:"structure"`

	// An array of field-level encryption items.
	Items []FieldLevelEncryptionSummary `locationNameList:"FieldLevelEncryptionSummary" type:"list"`

	// The maximum number of elements you want in the response body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your configurations where you left off.
	NextMarker *string `type:"string"`

	// The number of field-level encryption items.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldLevelEncryptionList) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "FieldLevelEncryptionSummary"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.StringValue(v), metadata)
	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex data type for field-level encryption profiles.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/FieldLevelEncryptionProfile
type FieldLevelEncryptionProfile struct {
	_ struct{} `type:"structure"`

	// A complex data type that includes the profile name and the encryption entities
	// for the field-level encryption profile.
	//
	// FieldLevelEncryptionProfileConfig is a required field
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig `type:"structure" required:"true"`

	// The ID for a field-level encryption profile configuration which includes
	// a set of profiles that specify certain selected data fields to be encrypted
	// by specific public keys.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The last time the field-level encryption profile was updated.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfile) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldLevelEncryptionProfile) MarshalFields(e protocol.FieldEncoder) error {
	if s.FieldLevelEncryptionProfileConfig != nil {
		v := s.FieldLevelEncryptionProfileConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FieldLevelEncryptionProfileConfig", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LastModifiedTime != nil {
		v := *s.LastModifiedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	return nil
}

// A complex data type of profiles for the field-level encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/FieldLevelEncryptionProfileConfig
type FieldLevelEncryptionProfileConfig struct {
	_ struct{} `type:"structure"`

	// A unique number that ensures that the request can't be replayed.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// An optional comment for the field-level encryption profile.
	Comment *string `type:"string"`

	// A complex data type of encryption entities for the field-level encryption
	// profile that include the public key ID, provider, and field patterns for
	// specifying which fields to encrypt with this key.
	//
	// EncryptionEntities is a required field
	EncryptionEntities *EncryptionEntities `type:"structure" required:"true"`

	// Profile name for the field-level encryption profile.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldLevelEncryptionProfileConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FieldLevelEncryptionProfileConfig"}

	if s.CallerReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("CallerReference"))
	}

	if s.EncryptionEntities == nil {
		invalidParams.Add(aws.NewErrParamRequired("EncryptionEntities"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.EncryptionEntities != nil {
		if err := s.EncryptionEntities.Validate(); err != nil {
			invalidParams.AddNested("EncryptionEntities", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldLevelEncryptionProfileConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.EncryptionEntities != nil {
		v := s.EncryptionEntities

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EncryptionEntities", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	return nil
}

// List of field-level encryption profiles.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/FieldLevelEncryptionProfileList
type FieldLevelEncryptionProfileList struct {
	_ struct{} `type:"structure"`

	// The field-level encryption profile items.
	Items []FieldLevelEncryptionProfileSummary `locationNameList:"FieldLevelEncryptionProfileSummary" type:"list"`

	// The maximum number of field-level encryption profiles you want in the response
	// body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your profiles where you left off.
	NextMarker *string `type:"string"`

	// The number of field-level encryption profiles.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfileList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldLevelEncryptionProfileList) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "FieldLevelEncryptionProfileSummary"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.StringValue(v), metadata)
	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The field-level encryption profile summary.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/FieldLevelEncryptionProfileSummary
type FieldLevelEncryptionProfileSummary struct {
	_ struct{} `type:"structure"`

	// An optional comment for the field-level encryption profile summary.
	Comment *string `type:"string"`

	// A complex data type of encryption entities for the field-level encryption
	// profile that include the public key ID, provider, and field patterns for
	// specifying which fields to encrypt with this key.
	//
	// EncryptionEntities is a required field
	EncryptionEntities *EncryptionEntities `type:"structure" required:"true"`

	// ID for the field-level encryption profile summary.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The time when the the field-level encryption profile summary was last updated.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Name for the field-level encryption profile summary.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldLevelEncryptionProfileSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.EncryptionEntities != nil {
		v := s.EncryptionEntities

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EncryptionEntities", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LastModifiedTime != nil {
		v := *s.LastModifiedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	return nil
}

// A summary of a field-level encryption item.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/FieldLevelEncryptionSummary
type FieldLevelEncryptionSummary struct {
	_ struct{} `type:"structure"`

	// An optional comment about the field-level encryption item.
	Comment *string `type:"string"`

	// A summary of a content type-profile mapping.
	ContentTypeProfileConfig *ContentTypeProfileConfig `type:"structure"`

	// The unique ID of a field-level encryption item.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The last time that the summary of field-level encryption items was modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A summary of a query argument-profile mapping.
	QueryArgProfileConfig *QueryArgProfileConfig `type:"structure"`
}

// String returns the string representation
func (s FieldLevelEncryptionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldLevelEncryptionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.ContentTypeProfileConfig != nil {
		v := s.ContentTypeProfileConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ContentTypeProfileConfig", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LastModifiedTime != nil {
		v := *s.LastModifiedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.QueryArgProfileConfig != nil {
		v := s.QueryArgProfileConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QueryArgProfileConfig", v, metadata)
	}
	return nil
}

// A complex data type that includes the field patterns to match for field-level
// encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/FieldPatterns
type FieldPatterns struct {
	_ struct{} `type:"structure"`

	// An array of the field-level encryption field patterns.
	Items []string `locationNameList:"FieldPattern" type:"list"`

	// The number of field-level encryption field patterns.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FieldPatterns) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldPatterns) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FieldPatterns"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldPatterns) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "FieldPattern"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that specifies how CloudFront handles query strings and cookies.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/ForwardedValues
type ForwardedValues struct {
	_ struct{} `type:"structure"`

	// A complex type that specifies whether you want CloudFront to forward cookies
	// to the origin and, if so, which ones. For more information about forwarding
	// cookies to the origin, see How CloudFront Forwards, Caches, and Logs Cookies
	// (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// Cookies is a required field
	Cookies *CookiePreference `type:"structure" required:"true"`

	// A complex type that specifies the Headers, if any, that you want CloudFront
	// to base caching on for this cache behavior.
	Headers *Headers `type:"structure"`

	// Indicates whether you want CloudFront to forward query strings to the origin
	// that is associated with this cache behavior and cache based on the query
	// string parameters. CloudFront behavior depends on the value of QueryString
	// and on the values that you specify for QueryStringCacheKeys, if any:
	//
	// If you specify true for QueryString and you don't specify any values for
	// QueryStringCacheKeys, CloudFront forwards all query string parameters to
	// the origin and caches based on all query string parameters. Depending on
	// how many query string parameters and values you have, this can adversely
	// affect performance because CloudFront must forward more requests to the origin.
	//
	// If you specify true for QueryString and you specify one or more values for
	// QueryStringCacheKeys, CloudFront forwards all query string parameters to
	// the origin, but it only caches based on the query string parameters that
	// you specify.
	//
	// If you specify false for QueryString, CloudFront doesn't forward any query
	// string parameters to the origin, and doesn't cache based on query string
	// parameters.
	//
	// For more information, see Configuring CloudFront to Cache Based on Query
	// String Parameters (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// QueryString is a required field
	QueryString *bool `type:"boolean" required:"true"`

	// A complex type that contains information about the query string parameters
	// that you want CloudFront to use for caching for this cache behavior.
	QueryStringCacheKeys *QueryStringCacheKeys `type:"structure"`
}

// String returns the string representation
func (s ForwardedValues) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForwardedValues) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ForwardedValues"}

	if s.Cookies == nil {
		invalidParams.Add(aws.NewErrParamRequired("Cookies"))
	}

	if s.QueryString == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryString"))
	}
	if s.Cookies != nil {
		if err := s.Cookies.Validate(); err != nil {
			invalidParams.AddNested("Cookies", err.(aws.ErrInvalidParams))
		}
	}
	if s.Headers != nil {
		if err := s.Headers.Validate(); err != nil {
			invalidParams.AddNested("Headers", err.(aws.ErrInvalidParams))
		}
	}
	if s.QueryStringCacheKeys != nil {
		if err := s.QueryStringCacheKeys.Validate(); err != nil {
			invalidParams.AddNested("QueryStringCacheKeys", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ForwardedValues) MarshalFields(e protocol.FieldEncoder) error {
	if s.Cookies != nil {
		v := s.Cookies

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Cookies", v, metadata)
	}
	if s.Headers != nil {
		v := s.Headers

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Headers", v, metadata)
	}
	if s.QueryString != nil {
		v := *s.QueryString

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QueryString", protocol.BoolValue(v), metadata)
	}
	if s.QueryStringCacheKeys != nil {
		v := s.QueryStringCacheKeys

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QueryStringCacheKeys", v, metadata)
	}
	return nil
}

// A complex type that controls the countries in which your content is distributed.
// CloudFront determines the location of your users using MaxMind GeoIP databases.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/GeoRestriction
type GeoRestriction struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a Location element for each country in which
	// you want CloudFront either to distribute your content (whitelist) or not
	// distribute your content (blacklist).
	//
	// The Location element is a two-letter, uppercase country code for a country
	// that you want to include in your blacklist or whitelist. Include one Location
	// element for each country.
	//
	// CloudFront and MaxMind both use ISO 3166 country codes. For the current list
	// of countries and the corresponding codes, see ISO 3166-1-alpha-2 code on
	// the International Organization for Standardization website. You can also
	// refer to the country list on the CloudFront console, which includes both
	// country names and codes.
	Items []string `locationNameList:"Location" type:"list"`

	// When geo restriction is enabled, this is the number of countries in your
	// whitelist or blacklist. Otherwise, when it is not enabled, Quantity is 0,
	// and you can omit Items.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`

	// The method that you want to use to restrict distribution of your content
	// by country:
	//
	//    * none: No geo restriction is enabled, meaning access to content is not
	//    restricted by client geo location.
	//
	//    * blacklist: The Location elements specify the countries in which you
	//    don't want CloudFront to distribute your content.
	//
	//    * whitelist: The Location elements specify the countries in which you
	//    want CloudFront to distribute your content.
	//
	// RestrictionType is a required field
	RestrictionType GeoRestrictionType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GeoRestriction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoRestriction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GeoRestriction"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if len(s.RestrictionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RestrictionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GeoRestriction) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Location"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	if len(s.RestrictionType) > 0 {
		v := s.RestrictionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RestrictionType", v, metadata)
	}
	return nil
}

// A complex type that specifies the request headers, if any, that you want
// CloudFront to base caching on for this cache behavior.
//
// For the headers that you specify, CloudFront caches separate versions of
// a specified object based on the header values in viewer requests. For example,
// suppose viewer requests for logo.jpg contain a custom product header that
// has a value of either acme or apex, and you configure CloudFront to cache
// your content based on values in the product header. CloudFront forwards the
// product header to the origin and caches the response from the origin once
// for each header value. For more information about caching based on header
// values, see How CloudFront Forwards and Caches Headers (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Headers
type Headers struct {
	_ struct{} `type:"structure"`

	// A list that contains one Name element for each header that you want CloudFront
	// to use for caching in this cache behavior. If Quantity is 0, omit Items.
	Items []string `locationNameList:"Name" type:"list"`

	// The number of different headers that you want CloudFront to base caching
	// on for this cache behavior. You can configure each cache behavior in a web
	// distribution to do one of the following:
	//
	//    * Forward all headers to your origin: Specify 1 for Quantity and * for
	//    Name. CloudFront doesn't cache the objects that are associated with this
	//    cache behavior. Instead, CloudFront sends every request to the origin.
	//
	//    * Forward a whitelist of headers you specify: Specify the number of headers
	//    that you want CloudFront to base caching on. Then specify the header names
	//    in Name elements. CloudFront caches your objects based on the values in
	//    the specified headers.
	//
	//    * Forward only the default headers: Specify 0 for Quantity and omit Items.
	//    In this configuration, CloudFront doesn't cache based on the values in
	//    the request headers.
	//
	// Regardless of which option you choose, CloudFront forwards headers to your
	// origin based on whether the origin is an S3 bucket or a custom origin. See
	// the following documentation:
	//
	//    * S3 bucket: See HTTP Request Headers That CloudFront Removes or Updates
	//    (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorS3Origin.html#request-s3-removed-headers)
	//
	//    * Custom origin: See HTTP Request Headers and CloudFront Behavior (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-headers-behavior)
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Headers) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Headers) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Headers"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Headers) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Name"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An invalidation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Invalidation
type Invalidation struct {
	_ struct{} `type:"structure"`

	// The date and time the invalidation request was first made.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The identifier for the invalidation request. For example: IDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The current invalidation information for the batch request.
	//
	// InvalidationBatch is a required field
	InvalidationBatch *InvalidationBatch `type:"structure" required:"true"`

	// The status of the invalidation request. When the invalidation batch is finished,
	// the status is Completed.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Invalidation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Invalidation) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreateTime != nil {
		v := *s.CreateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreateTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.InvalidationBatch != nil {
		v := s.InvalidationBatch

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InvalidationBatch", v, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.StringValue(v), metadata)
	}
	return nil
}

// An invalidation batch.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/InvalidationBatch
type InvalidationBatch struct {
	_ struct{} `type:"structure"`

	// A value that you specify to uniquely identify an invalidation request. CloudFront
	// uses the value to prevent you from accidentally resubmitting an identical
	// request. Whenever you create a new invalidation request, you must specify
	// a new value for CallerReference and change other values in the request as
	// applicable. One way to ensure that the value of CallerReference is unique
	// is to use a timestamp, for example, 20120301090000.
	//
	// If you make a second invalidation request with the same value for CallerReference,
	// and if the rest of the request is the same, CloudFront doesn't create a new
	// invalidation request. Instead, CloudFront returns information about the invalidation
	// request that you previously created with the same CallerReference.
	//
	// If CallerReference is a value you already sent in a previous invalidation
	// batch request but the content of any Path is different from the original
	// request, CloudFront returns an InvalidationBatchAlreadyExists error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// A complex type that contains information about the objects that you want
	// to invalidate. For more information, see Specifying the Objects to Invalidate
	// (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects)
	// in the Amazon CloudFront Developer Guide.
	//
	// Paths is a required field
	Paths *Paths `type:"structure" required:"true"`
}

// String returns the string representation
func (s InvalidationBatch) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvalidationBatch) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InvalidationBatch"}

	if s.CallerReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("CallerReference"))
	}

	if s.Paths == nil {
		invalidParams.Add(aws.NewErrParamRequired("Paths"))
	}
	if s.Paths != nil {
		if err := s.Paths.Validate(); err != nil {
			invalidParams.AddNested("Paths", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvalidationBatch) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.Paths != nil {
		v := s.Paths

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Paths", v, metadata)
	}
	return nil
}

// The InvalidationList complex type describes the list of invalidation objects.
// For more information about invalidation, see Invalidating Objects (Web Distributions
// Only) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/InvalidationList
type InvalidationList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more invalidation batch requests remain to
	// be listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more invalidation
	// batches in the list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one InvalidationSummary element for each invalidation
	// batch created by the current AWS account.
	Items []InvalidationSummary `locationNameList:"InvalidationSummary" type:"list"`

	// The value that you provided for the Marker request parameter.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you provided for the MaxItems request parameter.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value that
	// you can use for the Marker request parameter to continue listing your invalidation
	// batches where they left off.
	NextMarker *string `type:"string"`

	// The number of invalidation batches that were created by the current AWS account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s InvalidationList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvalidationList) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "InvalidationSummary"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.StringValue(v), metadata)
	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A summary of an invalidation request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/InvalidationSummary
type InvalidationSummary struct {
	_ struct{} `type:"structure"`

	// The time that an invalidation request was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique ID for an invalidation request.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The status of an invalidation request.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InvalidationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvalidationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreateTime != nil {
		v := *s.CreateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreateTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that lists the active CloudFront key pairs, if any, that are
// associated with AwsAccountNumber.
//
// For more information, see ActiveTrustedSigners.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/KeyPairIds
type KeyPairIds struct {
	_ struct{} `type:"structure"`

	// A complex type that lists the active CloudFront key pairs, if any, that are
	// associated with AwsAccountNumber.
	//
	// For more information, see ActiveTrustedSigners.
	Items []string `locationNameList:"KeyPairId" type:"list"`

	// The number of active CloudFront key pairs for AwsAccountNumber.
	//
	// For more information, see ActiveTrustedSigners.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s KeyPairIds) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KeyPairIds) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "KeyPairId"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains a Lambda function association.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/LambdaFunctionAssociation
type LambdaFunctionAssociation struct {
	_ struct{} `type:"structure"`

	// Specifies the event type that triggers a Lambda function invocation. You
	// can specify the following values:
	//
	//    * viewer-request: The function executes when CloudFront receives a request
	//    from a viewer and before it checks to see whether the requested object
	//    is in the edge cache.
	//
	//    * origin-request: The function executes only when CloudFront forwards
	//    a request to your origin. When the requested object is in the edge cache,
	//    the function doesn't execute.
	//
	//    * origin-response: The function executes after CloudFront receives a response
	//    from the origin and before it caches the object in the response. When
	//    the requested object is in the edge cache, the function doesn't execute.
	//
	//    * viewer-response: The function executes before CloudFront returns the
	//    requested object to the viewer. The function executes regardless of whether
	//    the object was already in the edge cache. If the origin returns an HTTP
	//    status code other than HTTP 200 (OK), the function doesn't execute.
	//
	// EventType is a required field
	EventType EventType `type:"string" required:"true" enum:"true"`

	// A flag that allows a Lambda function to have read access to the body content.
	// For more information, see Accessing the Request Body by Choosing the Include
	// Body Option (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html)
	// in the Amazon CloudFront Developer Guide.
	IncludeBody *bool `type:"boolean"`

	// The ARN of the Lambda function. You must specify the ARN of a function version;
	// you can't specify a Lambda alias or $LATEST.
	//
	// LambdaFunctionARN is a required field
	LambdaFunctionARN *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionAssociation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionAssociation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaFunctionAssociation"}
	if len(s.EventType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EventType"))
	}

	if s.LambdaFunctionARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("LambdaFunctionARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaFunctionAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EventType) > 0 {
		v := s.EventType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventType", v, metadata)
	}
	if s.IncludeBody != nil {
		v := *s.IncludeBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IncludeBody", protocol.BoolValue(v), metadata)
	}
	if s.LambdaFunctionARN != nil {
		v := *s.LambdaFunctionARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LambdaFunctionARN", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that specifies a list of Lambda functions associations for
// a cache behavior.
//
// If you want to invoke one or more Lambda functions triggered by requests
// that match the PathPattern of the cache behavior, specify the applicable
// values for Quantity and Items. Note that there can be up to 4 LambdaFunctionAssociation
// items in this list (one for each possible value of EventType) and each EventType
// can be associated with the Lambda function only once.
//
// If you don't want to invoke any Lambda functions for the requests that match
// PathPattern, specify 0 for Quantity and omit Items.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/LambdaFunctionAssociations
type LambdaFunctionAssociations struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains LambdaFunctionAssociation items for
	// this cache behavior. If Quantity is 0, you can omit Items.
	Items []LambdaFunctionAssociation `locationNameList:"LambdaFunctionAssociation" type:"list"`

	// The number of Lambda function associations for this cache behavior.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionAssociations) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionAssociations) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaFunctionAssociations"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaFunctionAssociations) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "LambdaFunctionAssociation"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that controls whether access logs are written for the distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/LoggingConfig
type LoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you don't want to enable logging when you create a distribution
	// or if you want to disable logging for an existing distribution, specify false
	// for Enabled, and specify empty Bucket and Prefix elements. If you specify
	// false for Enabled but you specify values for Bucket, prefix, and IncludeCookies,
	// the values are automatically deleted.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specifies whether you want CloudFront to include cookies in access logs,
	// specify true for IncludeCookies. If you choose to include cookies in logs,
	// CloudFront logs all cookies regardless of how you configure the cache behaviors
	// for this distribution. If you don't want to include cookies when you create
	// a distribution or if you want to disable include cookies for an existing
	// distribution, specify false for IncludeCookies.
	//
	// IncludeCookies is a required field
	IncludeCookies *bool `type:"boolean" required:"true"`

	// An optional string that you want CloudFront to prefix to the access log filenames
	// for this distribution, for example, myprefix/. If you want to enable logging,
	// but you don't want to specify a prefix, you still must include an empty Prefix
	// element in the Logging element.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingConfig"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if s.IncludeCookies == nil {
		invalidParams.Add(aws.NewErrParamRequired("IncludeCookies"))
	}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.IncludeCookies != nil {
		v := *s.IncludeCookies

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IncludeCookies", protocol.BoolValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that describes the Amazon S3 bucket, HTTP server (for example,
// a web server), Amazon MediaStore, or other server from which CloudFront gets
// your files. This can also be an origin group, if you've created an origin
// group. You must specify at least one origin or origin group.
//
// For the current limit on the number of origins or origin groups that you
// can specify for a distribution, see Amazon CloudFront Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_cloudfront)
// in the AWS General Reference.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Origin
type Origin struct {
	_ struct{} `type:"structure"`

	// A complex type that contains names and values for the custom headers that
	// you want.
	CustomHeaders *CustomHeaders `type:"structure"`

	// A complex type that contains information about a custom origin. If the origin
	// is an Amazon S3 bucket, use the S3OriginConfig element instead.
	CustomOriginConfig *CustomOriginConfig `type:"structure"`

	// Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want
	// CloudFront to get objects for this origin, for example, myawsbucket.s3.amazonaws.com.
	// If you set up your bucket to be configured as a website endpoint, enter the
	// Amazon S3 static website hosting endpoint for the bucket.
	//
	// For more information about specifying this value for different types of origins,
	// see Origin Domain Name (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName)
	// in the Amazon CloudFront Developer Guide.
	//
	// Constraints for Amazon S3 origins:
	//
	//    * If you configured Amazon S3 Transfer Acceleration for your bucket, don't
	//    specify the s3-accelerate endpoint for DomainName.
	//
	//    * The bucket name must be between 3 and 63 characters long (inclusive).
	//
	//    * The bucket name must contain only lowercase characters, numbers, periods,
	//    underscores, and dashes.
	//
	//    * The bucket name must not contain adjacent periods.
	//
	// Custom Origins: The DNS domain name for the HTTP server from which you want
	// CloudFront to get objects for this origin, for example, www.example.com.
	//
	// Constraints for custom origins:
	//
	//    * DomainName must be a valid DNS name that contains only a-z, A-Z, 0-9,
	//    dot (.), hyphen (-), or underscore (_) characters.
	//
	//    * The name cannot exceed 128 characters.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// A unique identifier for the origin or origin group. The value of Id must
	// be unique within the distribution.
	//
	// When you specify the value of TargetOriginId for the default cache behavior
	// or for another cache behavior, you indicate the origin to which you want
	// the cache behavior to route requests by specifying the value of the Id element
	// for that origin. When a request matches the path pattern for that cache behavior,
	// CloudFront routes the request to the specified origin. For more information,
	// see Cache Behavior Settings (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior)
	// in the Amazon CloudFront Developer Guide.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// An optional element that causes CloudFront to request your content from a
	// directory in your Amazon S3 bucket or your custom origin. When you include
	// the OriginPath element, specify the directory name, beginning with a /. CloudFront
	// appends the directory name to the value of DomainName, for example, example.com/production.
	// Do not include a / at the end of the directory name.
	//
	// For example, suppose you've specified the following values for your distribution:
	//
	//    * DomainName: An Amazon S3 bucket named myawsbucket.
	//
	//    * OriginPath: /production
	//
	//    * CNAME: example.com
	//
	// When a user enters example.com/index.html in a browser, CloudFront sends
	// a request to Amazon S3 for myawsbucket/production/index.html.
	//
	// When a user enters example.com/acme/index.html in a browser, CloudFront sends
	// a request to Amazon S3 for myawsbucket/production/acme/index.html.
	OriginPath *string `type:"string"`

	// A complex type that contains information about the Amazon S3 origin. If the
	// origin is a custom origin, use the CustomOriginConfig element instead.
	S3OriginConfig *S3OriginConfig `type:"structure"`
}

// String returns the string representation
func (s Origin) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Origin) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Origin"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.CustomHeaders != nil {
		if err := s.CustomHeaders.Validate(); err != nil {
			invalidParams.AddNested("CustomHeaders", err.(aws.ErrInvalidParams))
		}
	}
	if s.CustomOriginConfig != nil {
		if err := s.CustomOriginConfig.Validate(); err != nil {
			invalidParams.AddNested("CustomOriginConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3OriginConfig != nil {
		if err := s.S3OriginConfig.Validate(); err != nil {
			invalidParams.AddNested("S3OriginConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Origin) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomHeaders != nil {
		v := s.CustomHeaders

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CustomHeaders", v, metadata)
	}
	if s.CustomOriginConfig != nil {
		v := s.CustomOriginConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CustomOriginConfig", v, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.OriginPath != nil {
		v := *s.OriginPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginPath", protocol.StringValue(v), metadata)
	}
	if s.S3OriginConfig != nil {
		v := s.S3OriginConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3OriginConfig", v, metadata)
	}
	return nil
}

// A complex type that contains HeaderName and HeaderValue elements, if any,
// for this distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/OriginCustomHeader
type OriginCustomHeader struct {
	_ struct{} `type:"structure"`

	// The name of a header that you want CloudFront to forward to your origin.
	// For more information, see Forwarding Custom Headers to Your Origin (Web Distributions
	// Only) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html)
	// in the Amazon Amazon CloudFront Developer Guide.
	//
	// HeaderName is a required field
	HeaderName *string `type:"string" required:"true"`

	// The value for the header that you specified in the HeaderName field.
	//
	// HeaderValue is a required field
	HeaderValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginCustomHeader) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginCustomHeader) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OriginCustomHeader"}

	if s.HeaderName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HeaderName"))
	}

	if s.HeaderValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("HeaderValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginCustomHeader) MarshalFields(e protocol.FieldEncoder) error {
	if s.HeaderName != nil {
		v := *s.HeaderName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HeaderName", protocol.StringValue(v), metadata)
	}
	if s.HeaderValue != nil {
		v := *s.HeaderValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HeaderValue", protocol.StringValue(v), metadata)
	}
	return nil
}

// An origin group includes two origins (a primary origin and a second origin
// to failover to) and a failover criteria that you specify. You create an origin
// group to support origin failover in CloudFront. When you create or update
// a distribution, you can specifiy the origin group instead of a single origin,
// and CloudFront will failover from the primary origin to the second origin
// under the failover conditions that you've chosen.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/OriginGroup
type OriginGroup struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the failover criteria for
	// an origin group.
	//
	// FailoverCriteria is a required field
	FailoverCriteria *OriginGroupFailoverCriteria `type:"structure" required:"true"`

	// The origin group's ID.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A complex type that contains information about the origins in an origin group.
	//
	// Members is a required field
	Members *OriginGroupMembers `type:"structure" required:"true"`
}

// String returns the string representation
func (s OriginGroup) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroup) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OriginGroup"}

	if s.FailoverCriteria == nil {
		invalidParams.Add(aws.NewErrParamRequired("FailoverCriteria"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.Members == nil {
		invalidParams.Add(aws.NewErrParamRequired("Members"))
	}
	if s.FailoverCriteria != nil {
		if err := s.FailoverCriteria.Validate(); err != nil {
			invalidParams.AddNested("FailoverCriteria", err.(aws.ErrInvalidParams))
		}
	}
	if s.Members != nil {
		if err := s.Members.Validate(); err != nil {
			invalidParams.AddNested("Members", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.FailoverCriteria != nil {
		v := s.FailoverCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FailoverCriteria", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Members != nil {
		v := s.Members

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Members", v, metadata)
	}
	return nil
}

// A complex data type that includes information about the failover criteria
// for an origin group, including the status codes for which CloudFront will
// failover from the primary origin to the second origin.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/OriginGroupFailoverCriteria
type OriginGroupFailoverCriteria struct {
	_ struct{} `type:"structure"`

	// The status codes that, when returned from the primary origin, will trigger
	// CloudFront to failover to the second origin.
	//
	// StatusCodes is a required field
	StatusCodes *StatusCodes `type:"structure" required:"true"`
}

// String returns the string representation
func (s OriginGroupFailoverCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroupFailoverCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OriginGroupFailoverCriteria"}

	if s.StatusCodes == nil {
		invalidParams.Add(aws.NewErrParamRequired("StatusCodes"))
	}
	if s.StatusCodes != nil {
		if err := s.StatusCodes.Validate(); err != nil {
			invalidParams.AddNested("StatusCodes", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginGroupFailoverCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.StatusCodes != nil {
		v := s.StatusCodes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StatusCodes", v, metadata)
	}
	return nil
}

// An origin in an origin group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/OriginGroupMember
type OriginGroupMember struct {
	_ struct{} `type:"structure"`

	// The ID for an origin in an origin group.
	//
	// OriginId is a required field
	OriginId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginGroupMember) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroupMember) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OriginGroupMember"}

	if s.OriginId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OriginId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginGroupMember) MarshalFields(e protocol.FieldEncoder) error {
	if s.OriginId != nil {
		v := *s.OriginId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginId", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex data type for the origins included in an origin group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/OriginGroupMembers
type OriginGroupMembers struct {
	_ struct{} `type:"structure"`

	// Items (origins) in an origin group.
	//
	// Items is a required field
	Items []OriginGroupMember `locationNameList:"OriginGroupMember" min:"2" type:"list" required:"true"`

	// The number of origins in an origin group.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginGroupMembers) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroupMembers) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OriginGroupMembers"}

	if s.Items == nil {
		invalidParams.Add(aws.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Items", 2))
	}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginGroupMembers) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "OriginGroupMember"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex data type for the origin groups specified for a distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/OriginGroups
type OriginGroups struct {
	_ struct{} `type:"structure"`

	// The items (origin groups) in a distribution.
	Items []OriginGroup `locationNameList:"OriginGroup" type:"list"`

	// The number of origin groups.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginGroups) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroups) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OriginGroups"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginGroups) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "OriginGroup"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains information about the SSL/TLS protocols that
// CloudFront can use when establishing an HTTPS connection with your origin.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/OriginSslProtocols
type OriginSslProtocols struct {
	_ struct{} `type:"structure"`

	// A list that contains allowed SSL/TLS protocols for this distribution.
	//
	// Items is a required field
	Items []SslProtocol `locationNameList:"SslProtocol" type:"list" required:"true"`

	// The number of SSL/TLS protocols that you want to allow CloudFront to use
	// when establishing an HTTPS connection with this origin.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginSslProtocols) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginSslProtocols) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OriginSslProtocols"}

	if s.Items == nil {
		invalidParams.Add(aws.NewErrParamRequired("Items"))
	}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginSslProtocols) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "SslProtocol"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains information about origins and origin groups
// for this distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Origins
type Origins struct {
	_ struct{} `type:"structure"`

	// A complex type that contains origins or origin groups for this distribution.
	//
	// Items is a required field
	Items []Origin `locationNameList:"Origin" min:"1" type:"list" required:"true"`

	// The number of origins or origin groups for this distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Origins) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Origins) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Origins"}

	if s.Items == nil {
		invalidParams.Add(aws.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Items", 1))
	}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Origins) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Origin"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains information about the objects that you want
// to invalidate. For more information, see Specifying the Objects to Invalidate
// (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Paths
type Paths struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a list of the paths that you want to invalidate.
	Items []string `locationNameList:"Path" type:"list"`

	// The number of objects that you want to invalidate.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Paths) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Paths) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Paths"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Paths) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Path"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex data type of public keys you add to CloudFront to use with features
// like field-level encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/PublicKey
type PublicKey struct {
	_ struct{} `type:"structure"`

	// A time you added a public key to CloudFront.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A unique ID assigned to a public key you've added to CloudFront.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A complex data type for a public key you add to CloudFront to use with features
	// like field-level encryption.
	//
	// PublicKeyConfig is a required field
	PublicKeyConfig *PublicKeyConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s PublicKey) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicKey) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.PublicKeyConfig != nil {
		v := s.PublicKeyConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PublicKeyConfig", v, metadata)
	}
	return nil
}

// Information about a public key you add to CloudFront to use with features
// like field-level encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/PublicKeyConfig
type PublicKeyConfig struct {
	_ struct{} `type:"structure"`

	// A unique number that ensures that the request can't be replayed.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// An optional comment about a public key.
	Comment *string `type:"string"`

	// The encoded public key that you want to add to CloudFront to use with features
	// like field-level encryption.
	//
	// EncodedKey is a required field
	EncodedKey *string `type:"string" required:"true"`

	// The name for a public key you add to CloudFront to use with features like
	// field-level encryption.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PublicKeyConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublicKeyConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PublicKeyConfig"}

	if s.CallerReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("CallerReference"))
	}

	if s.EncodedKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("EncodedKey"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicKeyConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.EncodedKey != nil {
		v := *s.EncodedKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncodedKey", protocol.StringValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	return nil
}

// A list of public keys you've added to CloudFront to use with features like
// field-level encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/PublicKeyList
type PublicKeyList struct {
	_ struct{} `type:"structure"`

	// An array of information about a public key you add to CloudFront to use with
	// features like field-level encryption.
	Items []PublicKeySummary `locationNameList:"PublicKeySummary" type:"list"`

	// The maximum number of public keys you want in the response body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your public keys where you left off.
	NextMarker *string `type:"string"`

	// The number of public keys you added to CloudFront to use with features like
	// field-level encryption.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PublicKeyList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicKeyList) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "PublicKeySummary"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.StringValue(v), metadata)
	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex data type for public key information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/PublicKeySummary
type PublicKeySummary struct {
	_ struct{} `type:"structure"`

	// Comment for public key information summary.
	Comment *string `type:"string"`

	// Creation time for public key information summary.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Encoded key for public key information summary.
	//
	// EncodedKey is a required field
	EncodedKey *string `type:"string" required:"true"`

	// ID for public key information summary.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Name for public key information summary.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PublicKeySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicKeySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.EncodedKey != nil {
		v := *s.EncodedKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncodedKey", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	return nil
}

// Query argument-profile mapping for field-level encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/QueryArgProfile
type QueryArgProfile struct {
	_ struct{} `type:"structure"`

	// ID of profile to use for field-level encryption query argument-profile mapping
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// Query argument for field-level encryption query argument-profile mapping.
	//
	// QueryArg is a required field
	QueryArg *string `type:"string" required:"true"`
}

// String returns the string representation
func (s QueryArgProfile) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryArgProfile) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "QueryArgProfile"}

	if s.ProfileId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfileId"))
	}

	if s.QueryArg == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryArg"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueryArgProfile) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProfileId != nil {
		v := *s.ProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProfileId", protocol.StringValue(v), metadata)
	}
	if s.QueryArg != nil {
		v := *s.QueryArg

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QueryArg", protocol.StringValue(v), metadata)
	}
	return nil
}

// Configuration for query argument-profile mapping for field-level encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/QueryArgProfileConfig
type QueryArgProfileConfig struct {
	_ struct{} `type:"structure"`

	// Flag to set if you want a request to be forwarded to the origin even if the
	// profile specified by the field-level encryption query argument, fle-profile,
	// is unknown.
	//
	// ForwardWhenQueryArgProfileIsUnknown is a required field
	ForwardWhenQueryArgProfileIsUnknown *bool `type:"boolean" required:"true"`

	// Profiles specified for query argument-profile mapping for field-level encryption.
	QueryArgProfiles *QueryArgProfiles `type:"structure"`
}

// String returns the string representation
func (s QueryArgProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryArgProfileConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "QueryArgProfileConfig"}

	if s.ForwardWhenQueryArgProfileIsUnknown == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForwardWhenQueryArgProfileIsUnknown"))
	}
	if s.QueryArgProfiles != nil {
		if err := s.QueryArgProfiles.Validate(); err != nil {
			invalidParams.AddNested("QueryArgProfiles", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueryArgProfileConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.ForwardWhenQueryArgProfileIsUnknown != nil {
		v := *s.ForwardWhenQueryArgProfileIsUnknown

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ForwardWhenQueryArgProfileIsUnknown", protocol.BoolValue(v), metadata)
	}
	if s.QueryArgProfiles != nil {
		v := s.QueryArgProfiles

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QueryArgProfiles", v, metadata)
	}
	return nil
}

// Query argument-profile mapping for field-level encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/QueryArgProfiles
type QueryArgProfiles struct {
	_ struct{} `type:"structure"`

	// Number of items for query argument-profile mapping for field-level encryption.
	Items []QueryArgProfile `locationNameList:"QueryArgProfile" type:"list"`

	// Number of profiles for query argument-profile mapping for field-level encryption.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s QueryArgProfiles) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryArgProfiles) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "QueryArgProfiles"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueryArgProfiles) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "QueryArgProfile"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/QueryStringCacheKeys
type QueryStringCacheKeys struct {
	_ struct{} `type:"structure"`

	// (Optional) A list that contains the query string parameters that you want
	// CloudFront to use as a basis for caching for this cache behavior. If Quantity
	// is 0, you can omit Items.
	Items []string `locationNameList:"Name" type:"list"`

	// The number of whitelisted query string parameters for this cache behavior.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s QueryStringCacheKeys) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryStringCacheKeys) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "QueryStringCacheKeys"}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueryStringCacheKeys) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Name"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that identifies ways in which you want to restrict distribution
// of your content.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Restrictions
type Restrictions struct {
	_ struct{} `type:"structure"`

	// A complex type that controls the countries in which your content is distributed.
	// CloudFront determines the location of your users using MaxMind GeoIP databases.
	//
	// GeoRestriction is a required field
	GeoRestriction *GeoRestriction `type:"structure" required:"true"`
}

// String returns the string representation
func (s Restrictions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Restrictions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Restrictions"}

	if s.GeoRestriction == nil {
		invalidParams.Add(aws.NewErrParamRequired("GeoRestriction"))
	}
	if s.GeoRestriction != nil {
		if err := s.GeoRestriction.Validate(); err != nil {
			invalidParams.AddNested("GeoRestriction", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Restrictions) MarshalFields(e protocol.FieldEncoder) error {
	if s.GeoRestriction != nil {
		v := s.GeoRestriction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GeoRestriction", v, metadata)
	}
	return nil
}

// A complex type that contains information about the Amazon S3 bucket from
// which you want CloudFront to get your media files for distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/S3Origin
type S3Origin struct {
	_ struct{} `type:"structure"`

	// The DNS name of the Amazon S3 origin.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The CloudFront origin access identity to associate with the RTMP distribution.
	// Use an origin access identity to configure the distribution so that end users
	// can only access objects in an Amazon S3 bucket through CloudFront.
	//
	// If you want end users to be able to access objects using either the CloudFront
	// URL or the Amazon S3 URL, specify an empty OriginAccessIdentity element.
	//
	// To delete the origin access identity from an existing distribution, update
	// the distribution configuration and include an empty OriginAccessIdentity
	// element.
	//
	// To replace the origin access identity, update the distribution configuration
	// and specify the new origin access identity.
	//
	// For more information, see Using an Origin Access Identity to Restrict Access
	// to Your Amazon S3 Content (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html)
	// in the Amazon Amazon CloudFront Developer Guide.
	//
	// OriginAccessIdentity is a required field
	OriginAccessIdentity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Origin) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Origin) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Origin"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if s.OriginAccessIdentity == nil {
		invalidParams.Add(aws.NewErrParamRequired("OriginAccessIdentity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Origin) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.StringValue(v), metadata)
	}
	if s.OriginAccessIdentity != nil {
		v := *s.OriginAccessIdentity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginAccessIdentity", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains information about the Amazon S3 origin. If the
// origin is a custom origin, use the CustomOriginConfig element instead.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/S3OriginConfig
type S3OriginConfig struct {
	_ struct{} `type:"structure"`

	// The CloudFront origin access identity to associate with the origin. Use an
	// origin access identity to configure the origin so that viewers can only access
	// objects in an Amazon S3 bucket through CloudFront. The format of the value
	// is:
	//
	// origin-access-identity/cloudfront/ID-of-origin-access-identity
	//
	// where ID-of-origin-access-identity is the value that CloudFront returned
	// in the ID element when you created the origin access identity.
	//
	// If you want viewers to be able to access objects using either the CloudFront
	// URL or the Amazon S3 URL, specify an empty OriginAccessIdentity element.
	//
	// To delete the origin access identity from an existing distribution, update
	// the distribution configuration and include an empty OriginAccessIdentity
	// element.
	//
	// To replace the origin access identity, update the distribution configuration
	// and specify the new origin access identity.
	//
	// For more information about the origin access identity, see Serving Private
	// Content through CloudFront (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// OriginAccessIdentity is a required field
	OriginAccessIdentity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3OriginConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3OriginConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3OriginConfig"}

	if s.OriginAccessIdentity == nil {
		invalidParams.Add(aws.NewErrParamRequired("OriginAccessIdentity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3OriginConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.OriginAccessIdentity != nil {
		v := *s.OriginAccessIdentity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginAccessIdentity", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that lists the AWS accounts that were included in the TrustedSigners
// complex type, as well as their active CloudFront key pair IDs, if any.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Signer
type Signer struct {
	_ struct{} `type:"structure"`

	// An AWS account that is included in the TrustedSigners complex type for this
	// RTMP distribution. Valid values include:
	//
	//    * self, which is the AWS account used to create the distribution.
	//
	//    * An AWS account number.
	AwsAccountNumber *string `type:"string"`

	// A complex type that lists the active CloudFront key pairs, if any, that are
	// associated with AwsAccountNumber.
	KeyPairIds *KeyPairIds `type:"structure"`
}

// String returns the string representation
func (s Signer) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Signer) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsAccountNumber != nil {
		v := *s.AwsAccountNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AwsAccountNumber", protocol.StringValue(v), metadata)
	}
	if s.KeyPairIds != nil {
		v := s.KeyPairIds

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "KeyPairIds", v, metadata)
	}
	return nil
}

// A complex data type for the status codes that you specify that, when returned
// by a primary origin, trigger CloudFront to failover to a second origin.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/StatusCodes
type StatusCodes struct {
	_ struct{} `type:"structure"`

	// The items (status codes) for an origin group.
	//
	// Items is a required field
	Items []int64 `locationNameList:"StatusCode" min:"1" type:"list" required:"true"`

	// The number of status codes.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StatusCodes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatusCodes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StatusCodes"}

	if s.Items == nil {
		invalidParams.Add(aws.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Items", 1))
	}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StatusCodes) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "StatusCode"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.Int64Value(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A streaming distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/StreamingDistribution
type StreamingDistribution struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// A complex type that lists the AWS accounts, if any, that you included in
	// the TrustedSigners complex type for this distribution. These are the accounts
	// that you want to allow to create signed URLs for private content.
	//
	// The Signer complex type lists the AWS account number of the trusted signer
	// or self if the signer is the AWS account that created the distribution. The
	// Signer element also includes the IDs of any active CloudFront key pairs that
	// are associated with the trusted signer's AWS account. If no KeyPairId element
	// appears for a Signer, that signer can't create signed URLs.
	//
	// For more information, see Serving Private Content through CloudFront (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// ActiveTrustedSigners is a required field
	ActiveTrustedSigners *ActiveTrustedSigners `type:"structure" required:"true"`

	// The domain name that corresponds to the streaming distribution, for example,
	// s5c39gqb8ow64r.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The identifier for the RTMP distribution. For example: EGTXBD79EXAMPLE.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time that the distribution was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The current status of the RTMP distribution. When the status is Deployed,
	// the distribution's information is propagated to all CloudFront edge locations.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The current configuration information for the RTMP distribution.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistribution) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamingDistribution) MarshalFields(e protocol.FieldEncoder) error {
	if s.ARN != nil {
		v := *s.ARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ARN", protocol.StringValue(v), metadata)
	}
	if s.ActiveTrustedSigners != nil {
		v := s.ActiveTrustedSigners

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ActiveTrustedSigners", v, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LastModifiedTime != nil {
		v := *s.LastModifiedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.StringValue(v), metadata)
	}
	if s.StreamingDistributionConfig != nil {
		v := s.StreamingDistributionConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StreamingDistributionConfig", v, metadata)
	}
	return nil
}

// The RTMP distribution's configuration information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/StreamingDistributionConfig
type StreamingDistributionConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	Aliases *Aliases `type:"structure"`

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// StreamingDistributionConfig object), CloudFront creates a new distribution.
	//
	// If CallerReference is a value that you already sent in a previous request
	// to create a distribution, CloudFront returns a DistributionAlreadyExists
	// error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the streaming distribution.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// Whether the streaming distribution is enabled to accept user requests for
	// content.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A complex type that controls whether access logs are written for the streaming
	// distribution.
	Logging *StreamingLoggingConfig `type:"structure"`

	// A complex type that contains information about price class for this streaming
	// distribution.
	PriceClass PriceClass `type:"string" enum:"true"`

	// A complex type that contains information about the Amazon S3 bucket from
	// which you want CloudFront to get your media files for distribution.
	//
	// S3Origin is a required field
	S3Origin *S3Origin `type:"structure" required:"true"`

	// A complex type that specifies any AWS accounts that you want to permit to
	// create signed URLs for private content. If you want the distribution to use
	// signed URLs, include this element; if you want the distribution to use public
	// URLs, remove this element. For more information, see Serving Private Content
	// through CloudFront (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingDistributionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StreamingDistributionConfig"}

	if s.CallerReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("CallerReference"))
	}

	if s.Comment == nil {
		invalidParams.Add(aws.NewErrParamRequired("Comment"))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if s.S3Origin == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Origin"))
	}

	if s.TrustedSigners == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrustedSigners"))
	}
	if s.Aliases != nil {
		if err := s.Aliases.Validate(); err != nil {
			invalidParams.AddNested("Aliases", err.(aws.ErrInvalidParams))
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Origin != nil {
		if err := s.S3Origin.Validate(); err != nil {
			invalidParams.AddNested("S3Origin", err.(aws.ErrInvalidParams))
		}
	}
	if s.TrustedSigners != nil {
		if err := s.TrustedSigners.Validate(); err != nil {
			invalidParams.AddNested("TrustedSigners", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamingDistributionConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Aliases != nil {
		v := s.Aliases

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Aliases", v, metadata)
	}
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.Logging != nil {
		v := s.Logging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Logging", v, metadata)
	}
	if len(s.PriceClass) > 0 {
		v := s.PriceClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PriceClass", v, metadata)
	}
	if s.S3Origin != nil {
		v := s.S3Origin

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3Origin", v, metadata)
	}
	if s.TrustedSigners != nil {
		v := s.TrustedSigners

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TrustedSigners", v, metadata)
	}
	return nil
}

// A streaming distribution Configuration and a list of tags to be associated
// with the streaming distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/StreamingDistributionConfigWithTags
type StreamingDistributionConfigWithTags struct {
	_ struct{} `type:"structure"`

	// A streaming distribution Configuration.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure" required:"true"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionConfigWithTags) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingDistributionConfigWithTags) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StreamingDistributionConfigWithTags"}

	if s.StreamingDistributionConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamingDistributionConfig"))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}
	if s.StreamingDistributionConfig != nil {
		if err := s.StreamingDistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		if err := s.Tags.Validate(); err != nil {
			invalidParams.AddNested("Tags", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamingDistributionConfigWithTags) MarshalFields(e protocol.FieldEncoder) error {
	if s.StreamingDistributionConfig != nil {
		v := s.StreamingDistributionConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StreamingDistributionConfig", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tags", v, metadata)
	}
	return nil
}

// A streaming distribution list.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/StreamingDistributionList
type StreamingDistributionList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more streaming distributions remain to be listed.
	// If your results were truncated, you can make a follow-up pagination request
	// using the Marker request parameter to retrieve more distributions in the
	// list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one StreamingDistributionSummary element for
	// each distribution that was created by the current AWS account.
	Items []StreamingDistributionSummary `locationNameList:"StreamingDistributionSummary" type:"list"`

	// The value you provided for the Marker request parameter.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your RTMP distributions
	// where they left off.
	NextMarker *string `type:"string"`

	// The number of streaming distributions that were created by the current AWS
	// account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamingDistributionList) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "StreamingDistributionSummary"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.StringValue(v), metadata)
	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A summary of the information for an Amazon CloudFront streaming distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/StreamingDistributionSummary
type StreamingDistributionSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the streaming distribution. For example:
	// arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	//
	// Aliases is a required field
	Aliases *Aliases `type:"structure" required:"true"`

	// The comment originally specified when this distribution was created.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Whether the distribution is enabled to accept end user requests for content.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The identifier for the distribution, for example, EDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time the distribution was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// PriceClass is a required field
	PriceClass PriceClass `type:"string" required:"true" enum:"true"`

	// A complex type that contains information about the Amazon S3 bucket from
	// which you want CloudFront to get your media files for distribution.
	//
	// S3Origin is a required field
	S3Origin *S3Origin `type:"structure" required:"true"`

	// Indicates the current status of the distribution. When the status is Deployed,
	// the distribution's information is fully propagated throughout the Amazon
	// CloudFront system.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content. If you want to require signed
	// URLs in requests for objects in the target origin that match the PathPattern
	// for this cache behavior, specify true for Enabled, and specify the applicable
	// values for Quantity and Items.If you don't want to require signed URLs in
	// requests for objects that match PathPattern, specify false for Enabled and
	// 0 for Quantity. Omit Items. To add, change, or remove one or more trusted
	// signers, change Enabled to true (if it's currently false), change Quantity
	// as applicable, and specify all of the trusted signers that you want to include
	// in the updated distribution.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamingDistributionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ARN != nil {
		v := *s.ARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ARN", protocol.StringValue(v), metadata)
	}
	if s.Aliases != nil {
		v := s.Aliases

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Aliases", v, metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.StringValue(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LastModifiedTime != nil {
		v := *s.LastModifiedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if len(s.PriceClass) > 0 {
		v := s.PriceClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PriceClass", v, metadata)
	}
	if s.S3Origin != nil {
		v := s.S3Origin

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3Origin", v, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.StringValue(v), metadata)
	}
	if s.TrustedSigners != nil {
		v := s.TrustedSigners

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TrustedSigners", v, metadata)
	}
	return nil
}

// A complex type that controls whether access logs are written for this streaming
// distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/StreamingLoggingConfig
type StreamingLoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you don't want to enable logging when you create a streaming distribution
	// or if you want to disable logging for an existing streaming distribution,
	// specify false for Enabled, and specify empty Bucket and Prefix elements.
	// If you specify false for Enabled but you specify values for Bucket and Prefix,
	// the values are automatically deleted.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// An optional string that you want CloudFront to prefix to the access log filenames
	// for this streaming distribution, for example, myprefix/. If you want to enable
	// logging, but you don't want to specify a prefix, you still must include an
	// empty Prefix element in the Logging element.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StreamingLoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingLoggingConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StreamingLoggingConfig"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamingLoggingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains Tag key and Tag value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// A string that contains Tag key.
	//
	// The string length should be between 1 and 128 characters. Valid characters
	// include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// A string that contains an optional Tag value.
	//
	// The string length should be between 0 and 256 characters. Valid characters
	// include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains zero or more Tag elements.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/TagKeys
type TagKeys struct {
	_ struct{} `type:"structure"`

	// A complex type that contains Tag key elements.
	Items []string `locationNameList:"Key" type:"list"`
}

// String returns the string representation
func (s TagKeys) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagKeys) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Key"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	return nil
}

// A complex type that contains zero or more Tag elements.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/Tags
type Tags struct {
	_ struct{} `type:"structure"`

	// A complex type that contains Tag elements.
	Items []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s Tags) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tags) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tags"}
	if s.Items != nil {
		for i, v := range s.Items {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tags) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "Tag"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A complex type that specifies the AWS accounts, if any, that you want to
// allow to create signed URLs for private content.
//
// If you want to require signed URLs in requests for objects in the target
// origin that match the PathPattern for this cache behavior, specify true for
// Enabled, and specify the applicable values for Quantity and Items. For more
// information, see Serving Private Content through CloudFront (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
// in the Amazon Amazon CloudFront Developer Guide.
//
// If you don't want to require signed URLs in requests for objects that match
// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items.
//
// To add, change, or remove one or more trusted signers, change Enabled to
// true (if it's currently false), change Quantity as applicable, and specify
// all of the trusted signers that you want to include in the updated distribution.
//
// For more information about updating the distribution configuration, see DistributionConfig .
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/TrustedSigners
type TrustedSigners struct {
	_ struct{} `type:"structure"`

	// Specifies whether you want to require viewers to use signed URLs to access
	// the files specified by PathPattern and TargetOriginId.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Optional: A complex type that contains trusted signers for this cache behavior.
	// If Quantity is 0, you can omit Items.
	Items []string `locationNameList:"AwsAccountNumber" type:"list"`

	// The number of trusted signers for this cache behavior.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s TrustedSigners) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrustedSigners) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrustedSigners"}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if s.Quantity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TrustedSigners) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{ListLocationName: "AwsAccountNumber"}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Quantity != nil {
		v := *s.Quantity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quantity", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that specifies the following:
//
//    * Whether you want viewers to use HTTP or HTTPS to request your objects.
//
//    * If you want viewers to use HTTPS, whether you're using an alternate
//    domain name such as example.com or the CloudFront domain name for your
//    distribution, such as d111111abcdef8.cloudfront.net.
//
//    * If you're using an alternate domain name, whether AWS Certificate Manager
//    (ACM) provided the certificate, or you purchased a certificate from a
//    third-party certificate authority and imported it into ACM or uploaded
//    it to the IAM certificate store.
//
// You must specify only one of the following values:
//
//    * ViewerCertificate$ACMCertificateArn
//
//    * ViewerCertificate$IAMCertificateId
//
//    * ViewerCertificate$CloudFrontDefaultCertificate
//
// Don't specify false for CloudFrontDefaultCertificate.
//
// If you want viewers to use HTTP instead of HTTPS to request your objects:
// Specify the following value:
//
// <CloudFrontDefaultCertificate>true<CloudFrontDefaultCertificate>
//
// In addition, specify allow-all for ViewerProtocolPolicy for all of your cache
// behaviors.
//
// If you want viewers to use HTTPS to request your objects: Choose the type
// of certificate that you want to use based on whether you're using an alternate
// domain name for your objects or the CloudFront domain name:
//
//    * If you're using an alternate domain name, such as example.com: Specify
//    one of the following values, depending on whether ACM provided your certificate
//    or you purchased your certificate from third-party certificate authority:
//    <ACMCertificateArn>ARN for ACM SSL/TLS certificate<ACMCertificateArn>
//    where ARN for ACM SSL/TLS certificate is the ARN for the ACM SSL/TLS certificate
//    that you want to use for this distribution. <IAMCertificateId>IAM certificate
//    ID<IAMCertificateId> where IAM certificate ID is the ID that IAM returned
//    when you added the certificate to the IAM certificate store. If you specify
//    ACMCertificateArn or IAMCertificateId, you must also specify a value for
//    SSLSupportMethod. If you choose to use an ACM certificate or a certificate
//    in the IAM certificate store, we recommend that you use only an alternate
//    domain name in your object URLs (https://example.com/logo.jpg). If you
//    use the domain name that is associated with your CloudFront distribution
//    (such as https://d111111abcdef8.cloudfront.net/logo.jpg) and the viewer
//    supports SNI, then CloudFront behaves normally. However, if the browser
//    does not support SNI, the user's experience depends on the value that
//    you choose for SSLSupportMethod: vip: The viewer displays a warning because
//    there is a mismatch between the CloudFront domain name and the domain
//    name in your SSL/TLS certificate. sni-only: CloudFront drops the connection
//    with the browser without returning the object.
//
//    * If you're using the CloudFront domain name for your distribution, such
//    as d111111abcdef8.cloudfront.net : Specify the following value: <CloudFrontDefaultCertificate>true<CloudFrontDefaultCertificate>
//
// If you want viewers to use HTTPS, you must also specify one of the following
// values in your cache behaviors:
//
//    * <ViewerProtocolPolicy>https-only<ViewerProtocolPolicy>
//
//    * <ViewerProtocolPolicy>redirect-to-https<ViewerProtocolPolicy>
//
// You can also optionally require that CloudFront use HTTPS to communicate
// with your origin by specifying one of the following values for the applicable
// origins:
//
//    * <OriginProtocolPolicy>https-only<OriginProtocolPolicy>
//
//    * <OriginProtocolPolicy>match-viewer<OriginProtocolPolicy>
//
// For more information, see Using Alternate Domain Names and HTTPS (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS)
// in the Amazon CloudFront Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/ViewerCertificate
type ViewerCertificate struct {
	_ struct{} `type:"structure"`

	// For information about how and when to use ACMCertificateArn, see ViewerCertificate.
	ACMCertificateArn *string `type:"string"`

	// This field has been deprecated. Use one of the following fields instead:
	//
	//    * ViewerCertificate$ACMCertificateArn
	//
	//    * ViewerCertificate$IAMCertificateId
	//
	//    * ViewerCertificate$CloudFrontDefaultCertificate
	Certificate *string `deprecated:"true" type:"string"`

	// This field has been deprecated. Use one of the following fields instead:
	//
	//    * ViewerCertificate$ACMCertificateArn
	//
	//    * ViewerCertificate$IAMCertificateId
	//
	//    * ViewerCertificate$CloudFrontDefaultCertificate
	CertificateSource CertificateSource `deprecated:"true" type:"string" enum:"true"`

	// For information about how and when to use CloudFrontDefaultCertificate, see
	// ViewerCertificate.
	CloudFrontDefaultCertificate *bool `type:"boolean"`

	// For information about how and when to use IAMCertificateId, see ViewerCertificate.
	IAMCertificateId *string `type:"string"`

	// Specify the security policy that you want CloudFront to use for HTTPS connections.
	// A security policy determines two settings:
	//
	//    * The minimum SSL/TLS protocol that CloudFront uses to communicate with
	//    viewers
	//
	//    * The cipher that CloudFront uses to encrypt the content that it returns
	//    to viewers
	//
	// On the CloudFront console, this setting is called Security policy.
	//
	// We recommend that you specify TLSv1.1_2016 unless your users are using browsers
	// or devices that do not support TLSv1.1 or later.
	//
	// When both of the following are true, you must specify TLSv1 or later for
	// the security policy:
	//
	//    * You're using a custom certificate: you specified a value for ACMCertificateArn
	//    or for IAMCertificateId
	//
	//    * You're using SNI: you specified sni-only for SSLSupportMethod
	//
	// If you specify true for CloudFrontDefaultCertificate, CloudFront automatically
	// sets the security policy to TLSv1 regardless of the value that you specify
	// for MinimumProtocolVersion.
	//
	// For information about the relationship between the security policy that you
	// choose and the protocols and ciphers that CloudFront uses to communicate
	// with viewers, see Supported SSL/TLS Protocols and Ciphers for Communication
	// Between Viewers and CloudFront (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers)
	// in the Amazon CloudFront Developer Guide.
	MinimumProtocolVersion MinimumProtocolVersion `type:"string" enum:"true"`

	// If you specify a value for ViewerCertificate$ACMCertificateArn or for ViewerCertificate$IAMCertificateId,
	// you must also specify how you want CloudFront to serve HTTPS requests: using
	// a method that works for all clients or one that works for most clients:
	//
	//    * vip: CloudFront uses dedicated IP addresses for your content and can
	//    respond to HTTPS requests from any viewer. However, you will incur additional
	//    monthly charges.
	//
	//    * sni-only: CloudFront can respond to HTTPS requests from viewers that
	//    support Server Name Indication (SNI). All modern browsers support SNI,
	//    but some browsers still in use don't support SNI. If some of your users'
	//    browsers don't support SNI, we recommend that you do one of the following:
	//    Use the vip option (dedicated IP addresses) instead of sni-only. Use the
	//    CloudFront SSL/TLS certificate instead of a custom certificate. This requires
	//    that you use the CloudFront domain name of your distribution in the URLs
	//    for your objects, for example, https://d111111abcdef8.cloudfront.net/logo.png.
	//    If you can control which browser your users use, upgrade the browser to
	//    one that supports SNI. Use HTTP instead of HTTPS.
	//
	// Don't specify a value for SSLSupportMethod if you specified <CloudFrontDefaultCertificate>true<CloudFrontDefaultCertificate>.
	//
	// For more information, see Using Alternate Domain Names and HTTPS (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS.html)
	// in the Amazon CloudFront Developer Guide.
	SSLSupportMethod SSLSupportMethod `type:"string" enum:"true"`
}

// String returns the string representation
func (s ViewerCertificate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ViewerCertificate) MarshalFields(e protocol.FieldEncoder) error {
	if s.ACMCertificateArn != nil {
		v := *s.ACMCertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ACMCertificateArn", protocol.StringValue(v), metadata)
	}
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.StringValue(v), metadata)
	}
	if len(s.CertificateSource) > 0 {
		v := s.CertificateSource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CertificateSource", v, metadata)
	}
	if s.CloudFrontDefaultCertificate != nil {
		v := *s.CloudFrontDefaultCertificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudFrontDefaultCertificate", protocol.BoolValue(v), metadata)
	}
	if s.IAMCertificateId != nil {
		v := *s.IAMCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IAMCertificateId", protocol.StringValue(v), metadata)
	}
	if len(s.MinimumProtocolVersion) > 0 {
		v := s.MinimumProtocolVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MinimumProtocolVersion", v, metadata)
	}
	if len(s.SSLSupportMethod) > 0 {
		v := s.SSLSupportMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SSLSupportMethod", v, metadata)
	}
	return nil
}
